/*
 * Decompiled with CFR 0.152.
 */
package thenewpoketext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import thenewpoketext.UnicodeParser;

public class PokeTextData {
    private byte[] data;
    public List<PointerEntry> ptrlist;
    public List<String> strlist;
    public boolean compressFlag;

    public PokeTextData(byte[] data) {
        this.data = Arrays.copyOf(data, data.length);
    }

    public byte[] get() {
        return this.data;
    }

    private int read16(int ofs) {
        return this.data[ofs] & 0xFF | (this.data[ofs + 1] & 0xFF) << 8;
    }

    private void write16(int d, int ofs) {
        this.data[ofs] = (byte)(d & 0xFF);
        this.data[ofs + 1] = (byte)(d >> 8 & 0xFF);
    }

    private int read32(int ofs) {
        return this.data[ofs] & 0xFF | (this.data[ofs + 1] & 0xFF) << 8 | (this.data[ofs + 2] & 0xFF) << 16 | (this.data[ofs + 3] & 0xFF) << 24;
    }

    private void write32(int d, int ofs) {
        this.data[ofs] = (byte)(d & 0xFF);
        this.data[ofs + 1] = (byte)(d >> 8 & 0xFF);
        this.data[ofs + 2] = (byte)(d >> 16 & 0xFF);
        this.data[ofs + 3] = (byte)(d >> 24 & 0xFF);
    }

    public void decrypt() {
        this.DecyptPtrs(this.read16(0), this.read16(2), 4);
        this.ptrlist = this.CreatePtrList(this.read16(0), 4);
        this.strlist = new ArrayList<String>();
        int num = this.read16(0);
        for (int i = 0; i < num; ++i) {
            PointerEntry entry = this.ptrlist.get(i);
            this.DecyptTxt(entry.getChars(), i + 1, entry.getPtr());
            this.strlist.add(this.MakeString(entry.getChars(), entry.getPtr()));
        }
    }

    public void encrypt() {
        this.ptrlist = this.CreatePtrList(this.read16(0), 4);
        int num = this.read16(0);
        for (int i = 0; i < num; ++i) {
            PointerEntry entry = this.ptrlist.get(i);
            this.DecyptTxt(entry.getChars(), i + 1, entry.getPtr());
        }
        this.DecyptPtrs(this.read16(0), this.read16(2), 4);
    }

    private void DecyptPtrs(int count, int key, int sdidx) {
        key = key * 765 & 0xFFFF;
        for (int i = 0; i < count; ++i) {
            int key2 = key * (i + 1) & 0xFFFF;
            int realkey = key2 | key2 << 16;
            this.write32(this.read32(sdidx) ^ realkey, sdidx);
            this.write32(this.read32(sdidx + 4) ^ realkey, sdidx + 4);
            sdidx += 8;
        }
    }

    private List<PointerEntry> CreatePtrList(int count, int sdidx) {
        ArrayList<PointerEntry> ptrlist = new ArrayList<PointerEntry>();
        for (int i = 0; i < count; ++i) {
            ptrlist.add(new PointerEntry(this.read32(sdidx), this.read32(sdidx + 4)));
            sdidx += 8;
        }
        return ptrlist;
    }

    private void DecyptTxt(int count, int id, int idx) {
        int key = 596947 * id & 0xFFFF;
        for (int i = 0; i < count; ++i) {
            this.write16(this.read16(idx) ^ key, idx);
            key += 18749;
            key &= 0xFFFF;
            idx += 2;
        }
    }

    private String MakeString(int count, int idx) {
        int i;
        StringBuilder string = new StringBuilder();
        ArrayList<Integer> chars = new ArrayList<Integer>();
        ArrayList<Integer> uncomp = new ArrayList<Integer>();
        for (i = 0; i < count; ++i) {
            chars.add(this.read16(idx));
            idx += 2;
        }
        if ((Integer)chars.get(0) == 61696) {
            this.compressFlag = true;
            int j = 1;
            int shift1 = 0;
            int trans = 0;
            while (true) {
                int tmp = (Integer)chars.get(j);
                int tmp1 = tmp >>= shift1;
                if (shift1 >= 15) {
                    if ((shift1 -= 15) <= 0) continue;
                    tmp1 = trans | (Integer)chars.get(j) << 9 - shift1 & 0x1FF;
                    if (tmp1 == 511) break;
                    uncomp.add(tmp1);
                    continue;
                }
                tmp1 = (Integer)chars.get(j) >> shift1 & 0x1FF;
                if (tmp1 == 511) break;
                uncomp.add(tmp1);
                if ((shift1 += 9) < 15) {
                    trans = (Integer)chars.get(j) >> shift1 & 0x1FF;
                    shift1 += 9;
                }
                ++j;
            }
            chars = uncomp;
        }
        i = 0;
        for (int c = 0; c < chars.size(); ++c) {
            int currChar = (Integer)chars.get(i);
            if (UnicodeParser.tb[currChar] != null) {
                string.append(UnicodeParser.tb[currChar]);
            } else if (currChar == 65534) {
                string.append("\\v" + String.format("%04X", chars.get(++i)));
                int total = (Integer)chars.get(++i);
                for (int z = 0; z < total; ++z) {
                    string.append("\\z" + String.format("%04X", chars.get(++i)));
                }
            } else {
                if (currChar == 65535) break;
                string.append("\\x" + String.format("%04X", chars.get(i)));
            }
            ++i;
        }
        return string.toString();
    }

    public void SetKey(int key) {
        this.write16(key, 2);
    }

    public int GetKey() {
        return this.read16(2);
    }

    public class PointerEntry {
        private int ptr;
        private int chars;

        public PointerEntry(int ptr, int chars) {
            this.ptr = ptr;
            this.chars = chars;
        }

        public int getPtr() {
            return this.ptr;
        }

        public int getChars() {
            return this.chars;
        }
    }
}

