/*
 * Decompiled with CFR 0.152.
 */
package pptxt;

import com.dabomstew.pkrandom.FileFunctions;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PPTxtHandler {
    public static Map<String, String> pokeToText = new HashMap<String, String>();
    public static Map<String, String> textToPoke = new HashMap<String, String>();
    public static Pattern pokeToTextPattern;
    public static Pattern textToPokePattern;
    private static List<Integer> lastKeys;
    private static List<Integer> lastUnknowns;

    public static Pattern makePattern(Iterable<String> tokens) {
        String patternStr = "(" + PPTxtHandler.implode(tokens, "|").replace("\\", "\\\\").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)") + ")";
        return Pattern.compile(patternStr);
    }

    public static String implode(Iterable<String> tokens, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String token : tokens) {
            if (!first) {
                sb.append(sep);
            }
            sb.append(token);
            first = false;
        }
        return sb.toString();
    }

    private static List<Integer> decompress(List<Integer> chars) {
        ArrayList<Integer> uncomp = new ArrayList<Integer>();
        int j = 1;
        int shift1 = 0;
        int trans = 0;
        while (true) {
            int tmp = chars.get(j);
            int tmp1 = tmp >>= shift1;
            if (shift1 >= 16) {
                if ((shift1 -= 16) <= 0) continue;
                tmp1 = trans | chars.get(j) << 9 - shift1 & 0x1FF;
                if ((tmp1 & 0xFF) == 255) break;
                if (tmp1 == 0 || tmp1 == 1) continue;
                uncomp.add(tmp1);
                continue;
            }
            tmp1 = chars.get(j) >> shift1 & 0x1FF;
            if ((tmp1 & 0xFF) == 255) break;
            if (tmp1 != 0 && tmp1 != 1) {
                uncomp.add(tmp1);
            }
            if ((shift1 += 9) < 16) {
                trans = chars.get(j) >> shift1 & 0x1FF;
                shift1 += 9;
            }
            ++j;
        }
        return uncomp;
    }

    public static List<String> readTexts(byte[] ds) {
        int pos = 0;
        int i = 0;
        lastKeys = new ArrayList<Integer>();
        lastUnknowns = new ArrayList<Integer>();
        ArrayList<String> strings = new ArrayList<String>();
        int[] sizeSections = new int[]{0, 0, 0};
        int[] sectionOffset = new int[]{0, 0, 0};
        HashMap tableOffsets = new HashMap();
        HashMap characterCount = new HashMap();
        HashMap unknown = new HashMap();
        HashMap encText = new HashMap();
        HashMap decText = new HashMap();
        String string = "";
        int numSections = PPTxtHandler.readWord(ds, 0);
        int numEntries = PPTxtHandler.readWord(ds, 2);
        sizeSections[0] = PPTxtHandler.readLong(ds, 4);
        pos += 12;
        if (numSections > i) {
            int j;
            for (int z = 0; z < numSections; ++z) {
                sectionOffset[z] = PPTxtHandler.readLong(ds, pos);
                pos += 4;
            }
            pos = sectionOffset[i];
            sizeSections[i] = PPTxtHandler.readLong(ds, pos);
            pos += 4;
            tableOffsets.put(i, new ArrayList());
            characterCount.put(i, new ArrayList());
            unknown.put(i, new ArrayList());
            encText.put(i, new ArrayList());
            decText.put(i, new ArrayList());
            for (j = 0; j < numEntries; ++j) {
                int tmpOffset = PPTxtHandler.readLong(ds, pos);
                int tmpCharCount = PPTxtHandler.readWord(ds, pos += 4);
                int tmpUnknown = PPTxtHandler.readWord(ds, pos += 2);
                pos += 2;
                ((List)tableOffsets.get(i)).add(tmpOffset);
                ((List)characterCount.get(i)).add(tmpCharCount);
                ((List)unknown.get(i)).add(tmpUnknown);
                lastUnknowns.add(tmpUnknown);
            }
            for (j = 0; j < numEntries; ++j) {
                int k;
                ArrayList<Integer> tmpEncChars = new ArrayList<Integer>();
                pos = sectionOffset[i] + (Integer)((List)tableOffsets.get(i)).get(j);
                for (k = 0; k < (Integer)((List)characterCount.get(i)).get(j); ++k) {
                    int tmpChar = PPTxtHandler.readWord(ds, pos);
                    pos += 2;
                    tmpEncChars.add(tmpChar);
                }
                ((List)encText.get(i)).add(tmpEncChars);
                int key = (Integer)((List)((List)encText.get(i)).get(j)).get((Integer)((List)characterCount.get(i)).get(j) - 1) ^ 0xFFFF;
                for (k = (Integer)((List)characterCount.get(i)).get(j) - 1; k >= 0; --k) {
                    ((List)((List)encText.get(i)).get(j)).set(k, (Integer)((List)((List)encText.get(i)).get(j)).get(k) ^ key);
                    if (k == 0) {
                        lastKeys.add(key);
                    }
                    key = (key >>> 3 | key << 13) & 0xFFFF;
                }
                if ((Integer)((List)((List)encText.get(i)).get(j)).get(0) == 61696) {
                    ((List)encText.get(i)).set(j, PPTxtHandler.decompress((List)((List)encText.get(i)).get(j)));
                    ((List)characterCount.get(i)).set(j, ((List)((List)encText.get(i)).get(j)).size());
                }
                ArrayList<String> chars = new ArrayList<String>();
                string = "";
                for (int k2 = 0; k2 < (Integer)((List)characterCount.get(i)).get(j); ++k2) {
                    if ((Integer)((List)((List)encText.get(i)).get(j)).get(k2) == 65535) {
                        chars.add("\\xFFFF");
                        continue;
                    }
                    if ((Integer)((List)((List)encText.get(i)).get(j)).get(k2) > 20 && (Integer)((List)((List)encText.get(i)).get(j)).get(k2) <= 65520 && Character.UnicodeBlock.of((Integer)((List)((List)encText.get(i)).get(j)).get(k2)) != null) {
                        chars.add("" + (char)((Integer)((List)((List)encText.get(i)).get(j)).get(k2)).intValue());
                    } else {
                        String num = String.format("%04X", ((List)((List)encText.get(i)).get(j)).get(k2));
                        chars.add("\\x" + num);
                    }
                    string = string + (String)chars.get(k2);
                }
                strings.add(string);
                ((List)decText.get(i)).add(chars);
            }
        }
        for (int sn = 0; sn < strings.size(); ++sn) {
            strings.set(sn, PPTxtHandler.bulkReplace((String)strings.get(sn), pokeToTextPattern, pokeToText));
        }
        return strings;
    }

    private static String bulkReplace(String string, Pattern pattern, Map<String, String> replacements) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacements.get(matcher.group(1)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static byte[] saveEntry(byte[] originalData, List<String> text) {
        int z;
        for (int sn = 0; sn < text.size(); ++sn) {
            text.set(sn, PPTxtHandler.bulkReplace(text.get(sn), textToPokePattern, textToPoke));
        }
        PPTxtHandler.readTexts(originalData);
        int[] sizeSections = new int[]{0, 0, 0};
        int[] sectionOffset = new int[]{0, 0, 0};
        int[] newsizeSections = new int[]{0, 0, 0};
        int[] newsectionOffset = new int[]{0, 0, 0};
        byte[] ds = originalData;
        int pos = 0;
        int numSections = PPTxtHandler.readWord(ds, 0);
        int numEntries = PPTxtHandler.readWord(ds, 2);
        sizeSections[0] = PPTxtHandler.readLong(ds, 4);
        pos += 12;
        if (text.size() < numEntries) {
            System.err.println("Can't do anything due to too few lines");
            return originalData;
        }
        byte[] newEntry = PPTxtHandler.makeSection(text, numEntries);
        for (z = 0; z < numSections; ++z) {
            sectionOffset[z] = PPTxtHandler.readLong(ds, pos);
            pos += 4;
        }
        for (z = 0; z < numSections; ++z) {
            pos = sectionOffset[z];
            sizeSections[z] = PPTxtHandler.readLong(ds, pos);
            pos += 4;
        }
        newsizeSections[0] = newEntry.length;
        byte[] newData = new byte[ds.length - sizeSections[0] + newsizeSections[0]];
        System.arraycopy(ds, 0, newData, 0, Math.min(ds.length, newData.length));
        PPTxtHandler.writeLong(newData, 4, newsizeSections[0]);
        if (numSections == 2) {
            newsectionOffset[1] = newsizeSections[0] + sectionOffset[0];
            PPTxtHandler.writeLong(newData, 16, newsectionOffset[1]);
        }
        System.arraycopy(newEntry, 0, newData, sectionOffset[0], newEntry.length);
        if (numSections == 2) {
            System.arraycopy(ds, sectionOffset[1], newData, newsectionOffset[1], sizeSections[1]);
        }
        return newData;
    }

    private static byte[] makeSection(List<String> strings, int numEntries) {
        int i;
        ArrayList<List<Integer>> data = new ArrayList<List<Integer>>();
        int size = 0;
        int offset = 4 + 8 * numEntries;
        for (int i2 = 0; i2 < numEntries; ++i2) {
            data.add(PPTxtHandler.parseString(strings.get(i2), i2));
            size += ((List)data.get(i2)).size() * 2;
        }
        if (size % 4 == 2) {
            size += 2;
            int tmpKey = lastKeys.get(numEntries - 1);
            for (int i3 = 0; i3 < ((List)data.get(numEntries - 1)).size(); ++i3) {
                tmpKey = (tmpKey << 3 | tmpKey >> 13) & 0xFFFF;
            }
            ((List)data.get(numEntries - 1)).add(0xFFFF ^ tmpKey);
        }
        byte[] section = new byte[size += offset];
        int pos = 0;
        PPTxtHandler.writeLong(section, pos, size);
        pos += 4;
        for (i = 0; i < numEntries; ++i) {
            int charCount = ((List)data.get(i)).size();
            PPTxtHandler.writeLong(section, pos, offset);
            PPTxtHandler.writeWord(section, pos += 4, charCount);
            PPTxtHandler.writeWord(section, pos += 2, lastUnknowns.get(i));
            pos += 2;
            offset += charCount * 2;
        }
        for (i = 0; i < numEntries; ++i) {
            Iterator iterator = ((List)data.get(i)).iterator();
            while (iterator.hasNext()) {
                int word = (Integer)iterator.next();
                PPTxtHandler.writeWord(section, pos, word);
                pos += 2;
            }
        }
        return section;
    }

    private static List<Integer> parseString(String string, int entry_id) {
        ArrayList<Integer> chars = new ArrayList<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\\') {
                chars.add(Integer.valueOf(string.charAt(i)));
                continue;
            }
            if (i + 2 < string.length() && string.charAt(i + 2) == '{') {
                chars.add(Integer.valueOf(string.charAt(i)));
                continue;
            }
            chars.add(Integer.parseInt(string.substring(i + 2, i + 6), 16));
            i += 5;
        }
        chars.add(65535);
        int key = lastKeys.get(entry_id);
        for (int i = 0; i < chars.size(); ++i) {
            chars.set(i, ((Integer)chars.get(i) ^ key) & 0xFFFF);
            key = (key << 3 | key >>> 13) & 0xFFFF;
        }
        return chars;
    }

    private static int readWord(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8);
    }

    private static int readLong(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8) + ((data[offset + 2] & 0xFF) << 16) + ((data[offset + 3] & 0xFF) << 24);
    }

    protected static void writeWord(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    protected static void writeLong(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 2] = (byte)(value >> 16 & 0xFF);
        data[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    static {
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig("Generation5.tbl"), "UTF-8");
            while (sc.hasNextLine()) {
                String q = sc.nextLine();
                if (q.trim().isEmpty()) continue;
                String[] r = q.split("=", 2);
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                pokeToText.put(Character.toString((char)Integer.parseInt(r[0], 16)), r[1].replace("\\", "\\\\").replace("$", "\\$"));
                textToPoke.put(r[1], "\\\\x" + r[0]);
            }
            sc.close();
            pokeToTextPattern = PPTxtHandler.makePattern(pokeToText.keySet());
            textToPokePattern = PPTxtHandler.makePattern(textToPoke.keySet());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }
}

