/*
 * Decompiled with CFR 0.152.
 */
package cuecompressors;

import com.dabomstew.pkrandom.FileFunctions;
import java.io.FileOutputStream;
import java.io.IOException;

public class BLZCoder {
    private static final int CMD_DECODE = 0;
    private static final int CMD_ENCODE = 1;
    private static final int BLZ_NORMAL = 0;
    private static final int BLZ_BEST = 1;
    private static final int BLZ_SHIFT = 1;
    private static final int BLZ_MASK = 128;
    private static final int BLZ_THRESHOLD = 2;
    private static final int BLZ_N = 4098;
    private static final int BLZ_F = 18;
    private static final int RAW_MAXIM = 0xFFFFFF;
    private static final int BLZ_MAXIM = 0x1400000;
    private boolean arm9;
    private int new_len;

    public static void main(String[] args) {
        new BLZCoder(args);
    }

    public BLZCoder(String[] args) {
        int cmd;
        int mode = 0;
        if (args == null) {
            return;
        }
        this.Title();
        if (args.length < 1) {
            this.Usage();
        }
        if (args[0].equalsIgnoreCase("-d")) {
            cmd = 0;
        } else if (args[0].equalsIgnoreCase("-en") || args[0].equalsIgnoreCase("-en9")) {
            cmd = 1;
            mode = 0;
        } else if (args[0].equalsIgnoreCase("-eo") || args[0].equalsIgnoreCase("-eo9")) {
            cmd = 1;
            mode = 1;
        } else {
            this.EXIT("Command not supported\n");
            return;
        }
        if (args.length < 2) {
            this.EXIT("Filename not specified\n");
        }
        switch (cmd) {
            case 0: {
                for (int arg = 1; arg < args.length; ++arg) {
                    this.BLZ_Decode(args[arg]);
                }
                break;
            }
            case 1: {
                this.arm9 = args[0].length() > 3 && args[0].charAt(3) == '9';
                for (int arg = 1; arg < args.length; ++arg) {
                    this.BLZ_Encode(args[arg], mode);
                }
                break;
            }
        }
        System.out.print("\nDone\n");
    }

    private void Usage() {
        this.EXIT("Usage: BLZ command filename [filename [...]]\n\ncommand:\n  -d ....... decode 'filename'\n  -en[9] ... encode 'filename', normal mode\n  -eo[9] ... encode 'filename', optimal mode (LZ-CUE)\n\n* '9' compress an ARM9 file with 0x4000 bytes decoded\n* multiple filenames and wildcards are permitted\n* the original file is overwritten with the new file\n* this codification is used in the DS overlay files\n");
    }

    private void Title() {
        System.out.print("\n");
        System.out.print("BLZ - (c) CUE 2011\n");
        System.out.print("Bottom LZ coding for Nintendo GBA/DS\n");
        System.out.print("\n");
    }

    public void EXIT(String text) {
        System.out.print(text);
        System.exit(0);
    }

    private void Save(String filename, int[] buffer, int length) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            byte[] write = new byte[length];
            for (int i = 0; i < length; ++i) {
                write[i] = (byte)buffer[i];
            }
            fos.write(write);
            fos.close();
        }
        catch (IOException e) {
            this.EXIT("\nFile write error\n");
        }
    }

    private void BLZ_Decode(String filename) {
        try {
            System.out.printf("- decoding '%s'", filename);
            long startTime = System.currentTimeMillis();
            byte[] buf = FileFunctions.readFileFullyIntoBuffer(filename);
            BLZResult result = this.BLZ_Decode(buf);
            if (result != null) {
                this.Save(filename, result.buffer, result.length);
            }
            System.out.print(" - done, time=" + (System.currentTimeMillis() - startTime) + "ms");
            System.out.print("\n");
        }
        catch (IOException e) {
            this.EXIT("\nFile read error\n");
        }
    }

    public byte[] BLZ_DecodePub(byte[] data, String reference) {
        BLZResult result = this.BLZ_Decode(data);
        if (result != null) {
            byte[] retbuf = new byte[result.length];
            for (int i = 0; i < result.length; ++i) {
                retbuf[i] = (byte)result.buffer[i];
            }
            result = null;
            return retbuf;
        }
        return null;
    }

    private BLZResult BLZ_Decode(byte[] data) {
        int len;
        int raw_len;
        int dec_len;
        int enc_len;
        int pak_len;
        int flags = 0;
        int[] pak_buffer = this.prepareData(data);
        int inc_len = this.readUnsigned(pak_buffer, (pak_len = pak_buffer.length - 3) - 4);
        if (inc_len < 1) {
            System.out.printf(", WARNING: not coded file!", new Object[0]);
            enc_len = 0;
            dec_len = pak_len;
            pak_len = 0;
            raw_len = dec_len;
        } else {
            if (pak_len < 8) {
                this.EXIT("\nFile has a bad header\n");
                return null;
            }
            int hdr_len = pak_buffer[pak_len - 5];
            if (hdr_len < 8 || hdr_len > 11) {
                this.EXIT("\nBad header length\n");
                return null;
            }
            if (pak_len <= hdr_len) {
                this.EXIT("\nBad length\n");
                return null;
            }
            enc_len = this.readUnsigned(pak_buffer, pak_len - 8) & 0xFFFFFF;
            dec_len = pak_len - enc_len;
            pak_len = enc_len - hdr_len;
            raw_len = dec_len + enc_len + inc_len;
            if (raw_len > 0xFFFFFF) {
                this.EXIT("\nBad decoded length\n");
                return null;
            }
        }
        int[] raw_buffer = new int[raw_len];
        int pak = 0;
        int raw = 0;
        int pak_end = dec_len + pak_len;
        int raw_end = raw_len;
        for (len = 0; len < dec_len; ++len) {
            raw_buffer[raw++] = pak_buffer[pak++];
        }
        this.BLZ_Invert(pak_buffer, dec_len, pak_len);
        int mask = 0;
        while (raw < raw_end) {
            if ((mask >>>= 1) == 0) {
                if (pak == pak_end) break;
                flags = pak_buffer[pak++];
                mask = 128;
            }
            if ((flags & mask) == 0) {
                if (pak == pak_end) break;
                raw_buffer[raw++] = pak_buffer[pak++];
                continue;
            }
            if (pak + 1 >= pak_end) break;
            int pos = pak_buffer[pak++] << 8;
            if (raw + (len = ((pos |= pak_buffer[pak++]) >>> 12) + 2 + 1) > raw_end) {
                System.out.print(", WARNING: wrong decoded length!");
                len = raw_end - raw;
            }
            pos = (pos & 0xFFF) + 3;
            while (len-- > 0) {
                int charHere = raw_buffer[raw - pos];
                raw_buffer[raw++] = charHere;
            }
        }
        this.BLZ_Invert(raw_buffer, dec_len, raw_len - dec_len);
        raw_len = raw;
        if (raw != raw_end) {
            System.out.print(", WARNING: unexpected end of encoded file!");
        }
        return new BLZResult(raw_buffer, raw_len);
    }

    private int[] prepareData(byte[] data) {
        int fs = data.length;
        int[] fb = new int[fs + 3];
        for (int i = 0; i < fs; ++i) {
            fb[i] = data[i] & 0xFF;
        }
        return fb;
    }

    private int readUnsigned(int[] buffer, int offset) {
        return buffer[offset] | buffer[offset + 1] << 8 | buffer[offset + 2] << 16 | (buffer[offset + 3] & 0x7F) << 24;
    }

    private void writeUnsigned(int[] buffer, int offset, int value) {
        buffer[offset] = value & 0xFF;
        buffer[offset + 1] = value >> 8 & 0xFF;
        buffer[offset + 2] = value >> 16 & 0xFF;
        buffer[offset + 3] = value >> 24 & 0x7F;
    }

    private void BLZ_Encode(String filename, int mode) {
        try {
            System.out.printf("- encoding '%s'", filename);
            long startTime = System.currentTimeMillis();
            byte[] buf = FileFunctions.readFileFullyIntoBuffer(filename);
            BLZResult result = this.BLZ_Encode(buf, mode);
            if (result != null) {
                this.Save(filename, result.buffer, result.length);
            }
            System.out.print(" - done, time=" + (System.currentTimeMillis() - startTime) + "ms");
            System.out.print("\n");
        }
        catch (IOException e) {
            this.EXIT("\nFile read error\n");
        }
    }

    public byte[] BLZ_EncodePub(byte[] data, boolean arm9, boolean best, String reference) {
        int mode = best ? 1 : 0;
        this.arm9 = arm9;
        System.out.printf("- encoding '%s' (memory)", reference);
        long startTime = System.currentTimeMillis();
        BLZResult result = this.BLZ_Encode(data, mode);
        System.out.print(" - done, time=" + (System.currentTimeMillis() - startTime) + "ms");
        System.out.print("\n");
        if (result != null) {
            byte[] retbuf = new byte[result.length];
            for (int i = 0; i < result.length; ++i) {
                retbuf[i] = (byte)result.buffer[i];
            }
            result = null;
            return retbuf;
        }
        return null;
    }

    private BLZResult BLZ_Encode(byte[] data, int mode) {
        this.new_len = 0;
        int[] raw_buffer = this.prepareData(data);
        int raw_len = raw_buffer.length - 3;
        int[] pak_buffer = null;
        int pak_len = 0x1400001;
        int[] new_buffer = this.BLZ_Code(raw_buffer, raw_len, mode);
        if (this.new_len < pak_len) {
            pak_buffer = new_buffer;
            pak_len = this.new_len;
        }
        return new BLZResult(pak_buffer, pak_len);
    }

    private int[] BLZ_Code(int[] raw_buffer, int raw_len, int best) {
        int flg = 0;
        int pos_best = 0;
        int pos_next = 0;
        int pos_post = 0;
        int pak_tmp = 0;
        int raw_tmp = raw_len;
        int pak_len = raw_len + (raw_len + 7) / 8 + 11;
        int[] pak_buffer = new int[pak_len];
        int raw_new = raw_len;
        if (this.arm9) {
            raw_new -= 16384;
        }
        this.BLZ_Invert(raw_buffer, 0, raw_len);
        int pak = 0;
        int raw = 0;
        int raw_end = raw_new;
        int mask = 0;
        while (raw < raw_end) {
            if ((mask >>>= 1) == 0) {
                flg = pak++;
                pak_buffer[flg] = 0;
                mask = 128;
            }
            SearchPair sl1 = this.SEARCH(pos_best, raw_buffer, raw, raw_end);
            int len_best = sl1.l;
            pos_best = sl1.p;
            if (best == 1 && len_best > 2 && raw + len_best < raw_end) {
                SearchPair sl2 = this.SEARCH(pos_next, raw_buffer, raw += len_best, raw_end);
                int len_next = sl2.l;
                pos_next = sl2.p;
                SearchPair sl3 = this.SEARCH(pos_post, raw_buffer, raw -= len_best - 1, raw_end);
                int len_post = sl3.l;
                pos_post = sl3.p;
                --raw;
                if (len_next <= 2) {
                    len_next = 1;
                }
                if (len_post <= 2) {
                    len_post = 1;
                }
                if (len_best + len_next <= 1 + len_post) {
                    len_best = 1;
                }
            }
            pak_buffer[flg] = pak_buffer[flg] << 1;
            if (len_best > 2) {
                raw += len_best;
                int n = flg;
                pak_buffer[n] = pak_buffer[n] | 1;
                pak_buffer[pak++] = len_best - 3 << 4 | pos_best - 3 >>> 8;
                pak_buffer[pak++] = pos_best - 3 & 0xFF;
            } else {
                pak_buffer[pak++] = raw_buffer[raw++];
            }
            if (pak + raw_len - raw >= pak_tmp + raw_tmp) continue;
            pak_tmp = pak;
            raw_tmp = raw_len - raw;
        }
        while (mask > 0 && mask != 1) {
            mask >>>= 1;
            pak_buffer[flg] = pak_buffer[flg] << 1;
        }
        pak_len = pak;
        this.BLZ_Invert(raw_buffer, 0, raw_len);
        this.BLZ_Invert(pak_buffer, 0, pak_len);
        if (pak_tmp == 0 || raw_len + 4 < (pak_tmp + raw_tmp + 3 & 0xFFFFFFFC) + 8) {
            pak = 0;
            raw = 0;
            raw_end = raw_len;
            while (raw < raw_end) {
                pak_buffer[pak] = raw_buffer[raw];
            }
            while ((pak & 3) > 0) {
                pak_buffer[pak++] = 0;
            }
            pak_buffer[pak++] = 0;
            pak_buffer[pak++] = 0;
            pak_buffer[pak++] = 0;
            pak_buffer[pak++] = 0;
        } else {
            int len;
            int[] tmp = new int[raw_tmp + pak_tmp + 11];
            for (len = 0; len < raw_tmp; ++len) {
                tmp[len] = raw_buffer[len];
            }
            for (len = 0; len < pak_tmp; ++len) {
                tmp[raw_tmp + len] = pak_buffer[len + pak_len - pak_tmp];
            }
            pak = 0;
            pak_buffer = tmp;
            pak = raw_tmp + pak_tmp;
            int enc_len = pak_tmp;
            int hdr_len = 8;
            int inc_len = raw_len - pak_tmp - raw_tmp;
            while ((pak & 3) > 0) {
                pak_buffer[pak++] = 255;
                ++hdr_len;
            }
            this.writeUnsigned(pak_buffer, pak, enc_len + hdr_len);
            pak += 3;
            pak_buffer[pak++] = hdr_len;
            this.writeUnsigned(pak_buffer, pak, inc_len - hdr_len);
            pak += 4;
        }
        this.new_len = pak;
        return pak_buffer;
    }

    private SearchPair SEARCH(int p, int[] raw_buffer, int raw, int raw_end) {
        int l = 2;
        int max = raw >= 4098 ? 4098 : raw;
        for (int pos = 3; pos <= max; ++pos) {
            int len;
            for (len = 0; len < 18 && raw + len != raw_end && len < pos && raw_buffer[raw + len] == raw_buffer[raw + len - pos]; ++len) {
            }
            if (len <= l) continue;
            p = pos;
            l = len;
            if (l == 18) break;
        }
        return new SearchPair(l, p);
    }

    private void BLZ_Invert(int[] buffer, int offset, int length) {
        int bottom = offset + length - 1;
        while (offset < bottom) {
            int ch = buffer[offset];
            buffer[offset++] = buffer[bottom];
            buffer[bottom--] = ch;
        }
    }

    private class BLZResult {
        int[] buffer;
        int length;

        public BLZResult(int[] raw_buffer, int raw_len) {
            this.buffer = raw_buffer;
            this.length = raw_len;
        }
    }

    private static class SearchPair {
        public int l;
        public int p;

        public SearchPair(int l, int p) {
            this.l = l;
            this.p = p;
        }
    }
}

