/*
 * Decompiled with CFR 0.152.
 */
package compressors;

public class Gen2Decmp {
    private static final int LZ_END = 255;
    private static final int INITIAL_BUF_SIZE = 4096;
    public byte[] data;
    public int address;
    private byte[] output;
    private int out_idx;
    private int cmd;
    private int len;
    private int offset;
    private static int[] bit_flipped = new int[256];

    public Gen2Decmp(byte[] input, int baseOffset, int tilesWide, int tilesHigh) {
        this.data = input;
        this.address = baseOffset;
        this.decompress();
        this.cutAndTranspose(tilesWide, tilesHigh);
    }

    public byte[] getData() {
        return this.output;
    }

    public byte[] getFlattenedData() {
        return Gen2Decmp.flatten(this.output);
    }

    private void cutAndTranspose(int width, int height) {
        if (this.output == null) {
            return;
        }
        int tiles = width * height;
        byte[] newData = new byte[width * height * 16];
        for (int tile = 0; tile < tiles; ++tile) {
            int oldTileX = tile % width;
            int oldTileY = tile / width;
            int newTileNum = oldTileX * height + oldTileY;
            System.arraycopy(this.output, tile * 16, newData, newTileNum * 16, 16);
        }
        this.output = newData;
    }

    private void decompress() {
        this.output = new byte[4096];
        block9: while (true) {
            if (this.peek() == 255) break;
            this.cmd = (this.peek() & 0xE0) >> 5;
            if (this.cmd == 7) {
                this.cmd = (this.peek() & 0x1C) >> 2;
                this.len = (this.next() & 3) * 256 + this.next() + 1;
            } else {
                this.len = (this.next() & 0x1F) + 1;
            }
            while (this.out_idx + this.len > this.output.length) {
                this.resizeOutput();
            }
            switch (this.cmd) {
                case 0: {
                    System.arraycopy(this.data, this.address, this.output, this.out_idx, this.len);
                    this.out_idx += this.len;
                    this.address += this.len;
                    break;
                }
                case 1: {
                    byte repe = (byte)this.next();
                    int i = 0;
                    while (true) {
                        if (i >= this.len) continue block9;
                        this.output[this.out_idx++] = repe;
                        ++i;
                    }
                }
                case 2: {
                    byte[] alts = new byte[]{(byte)this.next(), (byte)this.next()};
                    int i = 0;
                    while (true) {
                        if (i >= this.len) continue block9;
                        this.output[this.out_idx++] = alts[i & 1];
                        ++i;
                    }
                }
                case 3: {
                    this.out_idx += this.len;
                    break;
                }
                case 4: {
                    this.repeat();
                    break;
                }
                case 5: {
                    this.repeat(1, bit_flipped);
                    break;
                }
                case 6: {
                    this.repeat(-1, null);
                }
            }
        }
        this.next();
        byte[] finalOutput = new byte[this.out_idx];
        System.arraycopy(this.output, 0, finalOutput, 0, this.out_idx);
        this.output = finalOutput;
    }

    private void repeat() {
        this.repeat(1, null);
    }

    private void repeat(int direction, int[] table) {
        this.get_offset();
        for (int i = 0; i < this.len; ++i) {
            int value = this.output[this.offset + i * direction] & 0xFF;
            this.output[this.out_idx++] = (byte)(table == null ? value : table[value]);
        }
    }

    private void get_offset() {
        if (this.peek() >= 128) {
            this.offset = this.next() & 0x7F;
            this.offset = this.out_idx - this.offset - 1;
        } else {
            this.offset = this.next() * 256 + this.next();
        }
    }

    private void resizeOutput() {
        byte[] newOut = new byte[this.output.length * 2];
        System.arraycopy(this.output, 0, newOut, 0, this.out_idx);
        this.output = newOut;
    }

    public int peek() {
        return this.data[this.address] & 0xFF;
    }

    public int next() {
        return this.data[this.address++] & 0xFF;
    }

    private static byte[] flatten(byte[] planar) {
        byte[] strips = new byte[planar.length * 4];
        for (int j = 0; j < planar.length / 2; ++j) {
            int bottom = planar[j * 2] & 0xFF;
            int top = planar[j * 2 + 1] & 0xFF;
            byte[] strip = new byte[8];
            for (int i = 7; i >= 0; --i) {
                strip[7 - i] = (byte)((bottom >>> i & 1) + (top * 2 >>> i & 2));
            }
            System.arraycopy(strip, 0, strips, j * 8, 8);
        }
        return strips;
    }

    static {
        for (int b = 0; b < 256; ++b) {
            for (int i = 0; i < 8; ++i) {
                int n = b;
                bit_flipped[n] = bit_flipped[n] + ((b >> i & 1) << 7 - i);
            }
        }
    }
}

