/*
 * Decompiled with CFR 0.152.
 */
package compressors;

public class Gen1Decmp {
    static int[] table1;
    static int[] table3;
    static int[][] table2;
    static int tilesize;
    private BitStream bs;
    private boolean mirror;
    private boolean planar;
    private byte[] data;
    private int sizex;
    private int sizey;
    private int size;
    private int ramorder;

    public static int bitflip(int x, int n) {
        int r = 0;
        while (n > 0) {
            r = r << 1 | x & 1;
            x >>= 1;
            --n;
        }
        return r;
    }

    public Gen1Decmp(byte[] input, int baseOffset) {
        this(input, baseOffset, false, true);
    }

    public Gen1Decmp(byte[] input, int baseOffset, boolean mirror, boolean planar) {
        this.bs = new BitStream(input, baseOffset);
        this.mirror = mirror;
        this.planar = planar;
        this.data = null;
    }

    public void decompress() {
        byte[][] rams = new byte[2][];
        this.sizex = this.readint(4) * tilesize;
        this.sizey = this.readint(4);
        this.size = this.sizex * this.sizey;
        int r1 = this.ramorder = this.readbit();
        int r2 = this.ramorder ^ 1;
        this.fillram(rams, r1);
        int mode = this.readbit();
        if (mode == 1) {
            mode += this.readbit();
        }
        this.fillram(rams, r2);
        rams[0] = this.bitgroups_to_bytes(rams[0]);
        rams[1] = this.bitgroups_to_bytes(rams[1]);
        if (mode == 0) {
            this.decode(rams[0]);
            this.decode(rams[1]);
        } else if (mode == 1) {
            this.decode(rams[r1]);
            this.xor(rams[r1], rams[r2]);
        } else if (mode == 2) {
            this.decode(rams[r2], false);
            this.decode(rams[r1]);
            this.xor(rams[r1], rams[r2]);
        }
        if (this.planar) {
            this.data = new byte[this.size * 2];
            for (int i = 0; i < rams[0].length; ++i) {
                this.data[i * 2] = rams[0][i];
                this.data[i * 2 + 1] = rams[1][i];
            }
        } else {
            byte[] tmpdata = new byte[this.size * 8];
            BitStream r0S = new BitStream(rams[0]);
            BitStream r1S = new BitStream(rams[1]);
            for (int i = 0; i < tmpdata.length; ++i) {
                tmpdata[i] = (byte)(r0S.next() | r1S.next() << 1);
            }
            this.data = this.bitgroups_to_bytes(tmpdata);
        }
    }

    public void transpose() {
        if (this.data == null) {
            return;
        }
        int tiles = this.data.length / 16;
        int width = this.sizex / tilesize;
        int height = this.sizey;
        byte[] newData = new byte[this.data.length];
        for (int tile = 0; tile < tiles; ++tile) {
            int oldTileX = tile % width;
            int oldTileY = tile / width;
            int newTileNum = oldTileX * height + oldTileY;
            System.arraycopy(this.data, tile * 16, newData, newTileNum * 16, 16);
        }
        this.data = newData;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getFlattenedData() {
        return Gen1Decmp.flatten(this.data);
    }

    public int getWidth() {
        return this.sizex;
    }

    public int getHeight() {
        return this.sizey * tilesize;
    }

    private void fillram(byte[][] rams, int rOffset) {
        int size = this.size * 4;
        rams[rOffset] = new byte[size];
        boolean rleMode = this.readbit() == 0;
        int written = 0;
        while (written < size) {
            written = rleMode ? (written += this.read_rle_chunk(rams[rOffset], written)) : (written += this.read_data_chunk(rams[rOffset], written, size));
            rleMode = !rleMode;
        }
        rams[rOffset] = this.deinterlace_bitgroups(rams[rOffset]);
    }

    private byte[] deinterlace_bitgroups(byte[] bits) {
        byte[] l = new byte[bits.length];
        int offs = 0;
        for (int y = 0; y < this.sizey; ++y) {
            for (int x = 0; x < this.sizex; ++x) {
                int i = 4 * y * this.sizex + x;
                for (int j = 0; j < 4; ++j) {
                    l[offs++] = bits[i];
                    i += this.sizex;
                }
            }
        }
        return l;
    }

    private int read_rle_chunk(byte[] ram, int baseOffset) {
        int i = 0;
        while (this.readbit() == 1) {
            ++i;
        }
        int n = table1[i];
        int a = this.readint(i + 1);
        n += a;
        for (i = 0; i < n; ++i) {
            ram[baseOffset + i] = 0;
        }
        return n;
    }

    private int read_data_chunk(byte[] ram, int baseOffset, int size) {
        int bitgroup;
        int written = 0;
        while ((bitgroup = this.readint(2)) != 0) {
            ram[baseOffset + written] = (byte)bitgroup;
            if (baseOffset + ++written < size) continue;
            break;
        }
        return written;
    }

    private int readbit() {
        return this.bs.next();
    }

    private int readint(int count) {
        return this.readint(this.bs, count);
    }

    private int readint(BitStream strm, int count) {
        int n = 0;
        while (count > 0) {
            n <<= 1;
            n |= strm.next();
            --count;
        }
        return n;
    }

    private byte[] bitgroups_to_bytes(byte[] bits) {
        int limiter = bits.length - 3;
        byte[] ret = new byte[bits.length / 4];
        for (int i = 0; i < limiter; i += 4) {
            int n = bits[i + 0] << 6 | bits[i + 1] << 4 | bits[i + 2] << 2 | bits[i + 3] << 0;
            ret[i / 4] = (byte)n;
        }
        return ret;
    }

    private void decode(byte[] ram) {
        this.decode(ram, this.mirror);
    }

    private void decode(byte[] ram, boolean mirror) {
        for (int x = 0; x < this.sizex; ++x) {
            int bit = 0;
            for (int y = 0; y < this.sizey; ++y) {
                int i = y * this.sizex + x;
                int a = (ram[i] & 0xFF) >> 4 & 0xF;
                int b = ram[i] & 0xF;
                a = table2[bit][a];
                bit = a & 1;
                if (mirror) {
                    a = table3[a];
                }
                b = table2[bit][b];
                bit = b & 1;
                if (mirror) {
                    b = table3[b];
                }
                ram[i] = (byte)(a << 4 | b);
            }
        }
    }

    private void xor(byte[] ram1, byte[] ram2) {
        this.xor(ram1, ram2, this.mirror);
    }

    private void xor(byte[] ram1, byte[] ram2, boolean mirror) {
        for (int i = 0; i < ram2.length; ++i) {
            if (mirror) {
                int a = (ram2[i] & 0xFF) >> 4 & 0xF;
                int b = ram2[i] & 0xF;
                a = table3[a];
                b = table3[b];
                ram2[i] = (byte)(a << 4 | b);
            }
            ram2[i] = (byte)(ram2[i] & 0xFF ^ ram1[i] & 0xFF);
        }
    }

    private static byte[] flatten(byte[] planar) {
        byte[] strips = new byte[planar.length * 4];
        for (int j = 0; j < planar.length / 2; ++j) {
            int bottom = planar[j * 2] & 0xFF;
            int top = planar[j * 2 + 1] & 0xFF;
            byte[] strip = new byte[8];
            for (int i = 7; i >= 0; --i) {
                strip[7 - i] = (byte)((bottom >>> i & 1) + (top * 2 >>> i & 2));
            }
            System.arraycopy(strip, 0, strips, j * 8, 8);
        }
        return strips;
    }

    static {
        table2 = new int[][]{{0, 1, 3, 2, 7, 6, 4, 5, 15, 14, 12, 13, 8, 9, 11, 10}, {15, 14, 12, 13, 8, 9, 11, 10, 0, 1, 3, 2, 7, 6, 4, 5}, {0, 8, 12, 4, 14, 6, 2, 10, 15, 7, 3, 11, 1, 9, 13, 5}, {15, 7, 3, 11, 1, 9, 13, 5, 0, 8, 12, 4, 14, 6, 2, 10}};
        table1 = new int[16];
        table3 = new int[16];
        for (int i = 0; i < 16; ++i) {
            Gen1Decmp.table1[i] = (2 << i) - 1;
            Gen1Decmp.table3[i] = Gen1Decmp.bitflip(i, 4);
        }
        tilesize = 8;
    }

    private static class BitStream {
        private byte[] data;
        private int offset;
        private int bitsLeft;
        private int bufVal;
        private static final int[] bmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};

        public BitStream(byte[] data) {
            this(data, 0);
        }

        public BitStream(byte[] data, int baseOffset) {
            this.data = data;
            this.offset = baseOffset - 1;
            this.bitsLeft = 0;
            this.bufVal = -1;
        }

        public int next() {
            if (this.bitsLeft == 0) {
                ++this.offset;
                this.bufVal = this.data[this.offset] & 0xFF;
                if (this.offset >= this.data.length) {
                    return -1;
                }
                this.bitsLeft = 8;
            }
            int retval = this.bufVal >> this.bitsLeft - 1;
            this.bufVal &= bmask[this.bitsLeft - 1];
            --this.bitsLeft;
            return retval;
        }
    }
}

