/*
 * Decompiled with CFR 0.152.
 */
package compressors;

import com.dabomstew.pkrandom.FileFunctions;

public class DSDecmp {
    public static byte[] Decompress(byte[] data) {
        return DSDecmp.Decompress(data, 0);
    }

    public static byte[] Decompress(byte[] data, int offset) {
        switch (data[offset] & 0xFF) {
            case 16: {
                return DSDecmp.decompress10LZ(data, offset);
            }
            case 17: {
                return DSDecmp.decompress11LZ(data, offset);
            }
        }
        return null;
    }

    private static byte[] decompress10LZ(byte[] data, int offset) {
        int length = data[++offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16;
        offset += 3;
        if (length == 0) {
            length = FileFunctions.readFullInt(data, offset);
            offset += 4;
        }
        byte[] outData = new byte[length];
        int curr_size = 0;
        block2: while (curr_size < outData.length) {
            int flags = data[offset++] & 0xFF;
            for (int i = 0; i < 8; ++i) {
                int b;
                boolean flag;
                boolean bl = flag = (flags & 128 >> i) > 0;
                if (flag) {
                    int disp = 0;
                    b = data[offset++] & 0xFF;
                    int n = b >> 4;
                    disp = (b & 0xF) << 8;
                    int n2 = offset++;
                    n += 3;
                    int cdest = curr_size;
                    if ((disp |= data[n2] & 0xFF) > curr_size) {
                        throw new ArrayIndexOutOfBoundsException("Cannot go back more than already written");
                    }
                    for (int j = 0; j < n; ++j) {
                        outData[curr_size++] = outData[cdest - disp - 1 + j];
                    }
                    if (curr_size <= outData.length) continue;
                    continue block2;
                }
                b = data[offset++] & 0xFF;
                try {
                    outData[curr_size++] = (byte)b;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    if (b == 0) continue block2;
                }
                if (curr_size > outData.length) continue block2;
            }
        }
        return outData;
    }

    private static byte[] decompress11LZ(byte[] data, int offset) {
        int length = data[++offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16;
        offset += 3;
        if (length == 0) {
            length = FileFunctions.readFullInt(data, offset);
            offset += 4;
        }
        byte[] outData = new byte[length];
        int curr_size = 0;
        block4: while (curr_size < outData.length) {
            int flags = data[offset++] & 0xFF;
            for (int i = 0; i < 8 && curr_size < outData.length; ++i) {
                boolean flag;
                boolean bl = flag = (flags & 128 >> i) > 0;
                if (flag) {
                    int disp;
                    int len;
                    int b1 = data[offset++] & 0xFF;
                    switch (b1 >> 4) {
                        case 0: {
                            len = b1 << 4;
                            int bt = data[offset++] & 0xFF;
                            len |= bt >> 4;
                            len += 17;
                            disp = (bt & 0xF) << 8;
                            int b2 = data[offset++] & 0xFF;
                            disp |= b2;
                            break;
                        }
                        case 1: {
                            int bt = data[offset++] & 0xFF;
                            int b2 = data[offset++] & 0xFF;
                            int b3 = data[offset++] & 0xFF;
                            len = (b1 & 0xF) << 12;
                            len |= bt << 4;
                            len |= b2 >> 4;
                            len += 273;
                            disp = (b2 & 0xF) << 8;
                            disp |= b3;
                            break;
                        }
                        default: {
                            len = (b1 >> 4) + 1;
                            disp = (b1 & 0xF) << 8;
                            int b2 = data[offset++] & 0xFF;
                            disp |= b2;
                        }
                    }
                    if (disp > curr_size) {
                        throw new ArrayIndexOutOfBoundsException("Cannot go back more than already written");
                    }
                    int cdest = curr_size;
                    for (int j = 0; j < len && curr_size < outData.length; ++j) {
                        outData[curr_size++] = outData[cdest - disp - 1 + j];
                    }
                    if (curr_size <= outData.length) continue;
                    continue block4;
                }
                outData[curr_size++] = data[offset++];
                if (curr_size > outData.length) continue block4;
            }
        }
        return outData;
    }
}

