/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.GenRestrictions;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.Type;
import java.awt.image.BufferedImage;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.Random;

public interface RomHandler {
    public boolean loadRom(String var1);

    public boolean saveRom(String var1);

    public String loadedFilename();

    public void setLog(PrintStream var1);

    public List<Pokemon> getPokemon();

    public void setPokemonPool(GenRestrictions var1);

    public void removeEvosForPokemonPool();

    public List<Pokemon> getStarters();

    public boolean setStarters(List<Pokemon> var1);

    public boolean canChangeStarters();

    public void shufflePokemonStats(boolean var1);

    public void randomizePokemonStats(boolean var1);

    public void updatePokemonStats();

    public Pokemon randomPokemon();

    public Pokemon randomNonLegendaryPokemon();

    public Pokemon randomLegendaryPokemon();

    public Pokemon random2EvosPokemon();

    public Type randomType();

    public boolean typeInGame(Type var1);

    public void randomizePokemonTypes(boolean var1);

    public int abilitiesPerPokemon();

    public int highestAbilityIndex();

    public String abilityName(int var1);

    public void randomizeAbilities(boolean var1, boolean var2, boolean var3, boolean var4);

    public List<EncounterSet> getEncounters(boolean var1);

    public void setEncounters(boolean var1, List<EncounterSet> var2);

    public void randomEncounters(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public void area1to1Encounters(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public void game1to1Encounters(boolean var1, boolean var2, boolean var3);

    public boolean hasTimeBasedEncounters();

    public List<Pokemon> bannedForWildEncounters();

    public List<Trainer> getTrainers();

    public void setTrainers(List<Trainer> var1);

    public void randomizeTrainerPokes(boolean var1, boolean var2, boolean var3, int var4);

    public void typeThemeTrainerPokes(boolean var1, boolean var2, boolean var3, boolean var4, int var5);

    public void rivalCarriesStarter();

    public void forceFullyEvolvedTrainerPokes(int var1);

    public void randomizeMovePowers();

    public void randomizeMovePPs();

    public void randomizeMoveAccuracies();

    public void randomizeMoveTypes();

    public boolean hasPhysicalSpecialSplit();

    public void randomizeMoveCategory();

    public void updateMovesToGen5();

    public void updateMovesToGen6();

    public void initMoveUpdates();

    public void printMoveUpdates();

    public List<Move> getMoves();

    public Map<Pokemon, List<MoveLearnt>> getMovesLearnt();

    public void setMovesLearnt(Map<Pokemon, List<MoveLearnt>> var1);

    public List<Integer> getMovesBannedFromLevelup();

    public void randomizeMovesLearnt(boolean var1, boolean var2, boolean var3, double var4);

    public void orderDamagingMovesByDamage();

    public void metronomeOnlyMode();

    public boolean supportsFourStartingMoves();

    public List<Pokemon> getStaticPokemon();

    public boolean setStaticPokemon(List<Pokemon> var1);

    public void randomizeStaticPokemon(boolean var1);

    public boolean canChangeStaticPokemon();

    public List<Pokemon> bannedForStaticPokemon();

    public List<Integer> getTMMoves();

    public List<Integer> getHMMoves();

    public void setTMMoves(List<Integer> var1);

    public void randomizeTMMoves(boolean var1, boolean var2, double var3);

    public int getTMCount();

    public int getHMCount();

    public Map<Pokemon, boolean[]> getTMHMCompatibility();

    public void setTMHMCompatibility(Map<Pokemon, boolean[]> var1);

    public void randomizeTMHMCompatibility(boolean var1);

    public void fullTMHMCompatibility();

    public void ensureTMCompatSanity();

    public void fullHMCompatibility();

    public boolean hasMoveTutors();

    public List<Integer> getMoveTutorMoves();

    public void setMoveTutorMoves(List<Integer> var1);

    public void randomizeMoveTutorMoves(boolean var1, boolean var2, double var3);

    public Map<Pokemon, boolean[]> getMoveTutorCompatibility();

    public void setMoveTutorCompatibility(Map<Pokemon, boolean[]> var1);

    public void randomizeMoveTutorCompatibility(boolean var1);

    public void fullMoveTutorCompatibility();

    public void ensureMoveTutorCompatSanity();

    public boolean canChangeTrainerText();

    public List<String> getTrainerNames();

    public void setTrainerNames(List<String> var1);

    public TrainerNameMode trainerNameMode();

    public int maxTrainerNameLength();

    public int maxSumOfTrainerNameLengths();

    public List<Integer> getTCNameLengthsByTrainer();

    public void randomizeTrainerNames(CustomNamesSet var1);

    public List<String> getTrainerClassNames();

    public void setTrainerClassNames(List<String> var1);

    public boolean fixedTrainerClassNamesLength();

    public int maxTrainerClassNameLength();

    public void randomizeTrainerClassNames(CustomNamesSet var1);

    public List<Integer> getDoublesTrainerClasses();

    public ItemList getAllowedItems();

    public ItemList getNonBadItems();

    public void randomizeWildHeldItems(boolean var1);

    public String[] getItemNames();

    public List<Integer> getStarterHeldItems();

    public void setStarterHeldItems(List<Integer> var1);

    public void randomizeStarterHeldItems(boolean var1);

    public List<Integer> getRequiredFieldTMs();

    public List<Integer> getCurrentFieldTMs();

    public void setFieldTMs(List<Integer> var1);

    public List<Integer> getRegularFieldItems();

    public void setRegularFieldItems(List<Integer> var1);

    public void shuffleFieldItems();

    public void randomizeFieldItems(boolean var1);

    public List<IngameTrade> getIngameTrades();

    public void setIngameTrades(List<IngameTrade> var1);

    public void randomizeIngameTrades(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, CustomNamesSet var6);

    public boolean hasDVs();

    public int maxTradeNicknameLength();

    public int maxTradeOTNameLength();

    public void removeTradeEvolutions(boolean var1);

    public void condenseLevelEvolutions(int var1, int var2);

    public void randomizeEvolutions(boolean var1, boolean var2, boolean var3, boolean var4);

    public void minimumCatchRate(int var1, int var2);

    public void standardizeEXPCurves();

    public List<Integer> getGameBreakingMoves();

    public List<Integer> getFieldMoves();

    public List<Integer> getEarlyRequiredHMMoves();

    public boolean isYellow();

    public String getROMName();

    public String getROMCode();

    public String getSupportLevel();

    public String getDefaultExtension();

    public int internalStringLength(String var1);

    public void applySignature();

    public BufferedImage getMascotImage();

    public boolean isROMHack();

    public int generationOfPokemon();

    public void writeCheckValueToROM(int var1);

    public int miscTweaksAvailable();

    public void applyMiscTweak(MiscTweak var1);

    public static enum TrainerNameMode {
        SAME_LENGTH,
        MAX_LENGTH,
        MAX_LENGTH_WITH_CLASS;

    }

    public static abstract class Factory {
        public RomHandler create(Random random) {
            return this.create(random, null);
        }

        public abstract RomHandler create(Random var1, PrintStream var2);

        public abstract boolean isLoadable(String var1);
    }
}

