/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.GFXFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RomFunctions;
import com.dabomstew.pkrandom.constants.Gen5Constants;
import com.dabomstew.pkrandom.constants.GlobalConstants;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.newnds.NARCArchive;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.EvolutionType;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.romhandlers.AbstractDSRomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import compressors.DSDecmp;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import pptxt.PPTxtHandler;

public class Gen5RomHandler
extends AbstractDSRomHandler {
    private static List<RomEntry> roms;
    private Pokemon[] pokes;
    private List<Pokemon> pokemonList;
    private Move[] moves;
    private RomEntry romEntry;
    private byte[] arm9;
    private List<String> abilityNames;
    private List<String> itemNames;
    private boolean loadedWildMapNames;
    private Map<Integer, String> wildMapNames;
    private ItemList allowedItems;
    private ItemList nonBadItems;
    private NARCArchive pokeNarc;
    private NARCArchive moveNarc;
    private NARCArchive stringsNarc;
    private NARCArchive storyTextNarc;
    private NARCArchive scriptNarc;
    private static RomFunctions.StringSizeDeterminer ssd;

    public Gen5RomHandler(Random random) {
        super(random, null);
    }

    public Gen5RomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    private static void loadROMInfo() {
        roms = new ArrayList<RomEntry>();
        RomEntry current = null;
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig("gen5_offsets.ini"), "UTF-8");
            while (sc.hasNextLine()) {
                int n;
                String q = sc.nextLine().trim();
                if (q.contains("//")) {
                    q = q.substring(0, q.indexOf("//")).trim();
                }
                if (q.isEmpty()) continue;
                if (q.startsWith("[") && q.endsWith("]")) {
                    current = new RomEntry();
                    current.name = q.substring(1, q.length() - 1);
                    roms.add(current);
                    continue;
                }
                String[] r = q.split("=", 2);
                if (r.length == 1) {
                    System.err.println("invalid entry " + q);
                    continue;
                }
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                r[1] = r[1].trim();
                if (r[0].equals("Game")) {
                    current.romCode = r[1];
                    continue;
                }
                if (r[0].equals("Type")) {
                    if (r[1].equalsIgnoreCase("BW2")) {
                        current.romType = 1;
                        continue;
                    }
                    current.romType = 0;
                    continue;
                }
                if (r[0].equals("CopyFrom")) {
                    for (RomEntry otherEntry : roms) {
                        if (!r[1].equalsIgnoreCase(otherEntry.romCode)) continue;
                        current.arrayEntries.putAll(otherEntry.arrayEntries);
                        current.numbers.putAll(otherEntry.numbers);
                        current.strings.putAll(otherEntry.strings);
                        current.offsetArrayEntries.putAll(otherEntry.offsetArrayEntries);
                        if (current.copyStaticPokemon) {
                            current.staticPokemon.addAll(otherEntry.staticPokemon);
                            current.staticPokemonSupport = true;
                            continue;
                        }
                        current.staticPokemonSupport = false;
                    }
                    continue;
                }
                if (r[0].equals("StaticPokemon[]")) {
                    if (r[1].startsWith("[") && r[1].endsWith("]")) {
                        String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                        int[] offs = new int[offsets.length];
                        int[] files = new int[offsets.length];
                        int c = 0;
                        String[] stringArray = offsets;
                        n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String off = stringArray[i];
                            String[] parts = off.split("\\:");
                            files[c] = Gen5RomHandler.parseRIInt(parts[0]);
                            offs[c++] = Gen5RomHandler.parseRIInt(parts[1]);
                        }
                        StaticPokemon sp = new StaticPokemon();
                        StaticPokemon.access$1302(sp, files);
                        StaticPokemon.access$1402(sp, offs);
                        current.staticPokemon.add(sp);
                        continue;
                    }
                    String[] parts = r[1].split("\\:");
                    int files = Gen5RomHandler.parseRIInt(parts[0]);
                    int offs = Gen5RomHandler.parseRIInt(parts[1]);
                    StaticPokemon sp = new StaticPokemon();
                    StaticPokemon.access$1302(sp, new int[]{files});
                    StaticPokemon.access$1402(sp, new int[]{offs});
                    continue;
                }
                if (r[0].equals("StaticPokemonSupport")) {
                    int spsupport = Gen5RomHandler.parseRIInt(r[1]);
                    current.staticPokemonSupport = spsupport > 0;
                    continue;
                }
                if (r[0].equals("CopyStaticPokemon")) {
                    int csp = Gen5RomHandler.parseRIInt(r[1]);
                    current.copyStaticPokemon = csp > 0;
                    continue;
                }
                if (r[0].startsWith("StarterOffsets") || r[0].equals("StaticPokemonFormValues")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    OffsetWithinEntry[] offs = new OffsetWithinEntry[offsets.length];
                    int c = 0;
                    String[] stringArray = offsets;
                    int n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        String off = stringArray[n];
                        String[] parts = off.split("\\:");
                        OffsetWithinEntry owe = new OffsetWithinEntry();
                        owe.entry = Gen5RomHandler.parseRIInt(parts[0]);
                        owe.offset = Gen5RomHandler.parseRIInt(parts[1]);
                        offs[c++] = owe;
                    }
                    current.offsetArrayEntries.put(r[0], offs);
                    continue;
                }
                if (r[0].endsWith("Tweak")) {
                    current.tweakFiles.put(r[0], r[1]);
                    continue;
                }
                if (r[1].startsWith("[") && r[1].endsWith("]")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    if (offsets.length == 1 && offsets[0].trim().isEmpty()) {
                        current.arrayEntries.put(r[0], new int[0]);
                        continue;
                    }
                    int[] offs = new int[offsets.length];
                    int c = 0;
                    String[] stringArray = offsets;
                    int n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        String off = stringArray[n];
                        offs[c++] = Gen5RomHandler.parseRIInt(off);
                    }
                    current.arrayEntries.put(r[0], offs);
                    continue;
                }
                if (r[0].endsWith("Offset") || r[0].endsWith("Count") || r[0].endsWith("Number")) {
                    int offs = Gen5RomHandler.parseRIInt(r[1]);
                    current.numbers.put(r[0], offs);
                    continue;
                }
                current.strings.put(r[0], r[1]);
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static int parseRIInt(String off) {
        int radix = 10;
        if ((off = off.trim().toLowerCase()).startsWith("0x") || off.startsWith("&h")) {
            radix = 16;
            off = off.substring(2);
        }
        try {
            return Integer.parseInt(off, radix);
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid base " + radix + "number " + off);
            return 0;
        }
    }

    @Override
    protected boolean detectNDSRom(String ndsCode) {
        return Gen5RomHandler.detectNDSRomInner(ndsCode);
    }

    private static boolean detectNDSRomInner(String ndsCode) {
        return Gen5RomHandler.entryFor(ndsCode) != null;
    }

    private static RomEntry entryFor(String ndsCode) {
        if (ndsCode == null) {
            return null;
        }
        for (RomEntry re : roms) {
            if (!ndsCode.equals(re.romCode)) continue;
            return re;
        }
        return null;
    }

    @Override
    protected void loadedROM(String romCode) {
        this.romEntry = Gen5RomHandler.entryFor(romCode);
        try {
            this.arm9 = this.readARM9();
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.stringsNarc = this.readNARC(this.romEntry.getString("TextStrings"));
            this.storyTextNarc = this.readNARC(this.romEntry.getString("TextStory"));
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.scriptNarc = this.readNARC(this.romEntry.getString("Scripts"));
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        this.loadPokemonStats();
        this.pokemonList = Arrays.asList(this.pokes);
        this.loadMoves();
        this.abilityNames = this.getStrings(false, this.romEntry.getInt("AbilityNamesTextOffset"));
        this.itemNames = this.getStrings(false, this.romEntry.getInt("ItemNamesTextOffset"));
        this.loadedWildMapNames = false;
        this.allowedItems = Gen5Constants.allowedItems.copy();
        this.nonBadItems = Gen5Constants.nonBadItems.copy();
    }

    private void loadPokemonStats() {
        try {
            this.pokeNarc = this.readNARC(this.romEntry.getString("PokemonStats"));
            String[] pokeNames = this.readPokemonNames();
            this.pokes = new Pokemon[650];
            for (int i = 1; i <= 649; ++i) {
                this.pokes[i] = new Pokemon();
                this.pokes[i].number = i;
                this.loadBasicPokeStats(this.pokes[i], this.pokeNarc.files.get(i));
                this.pokes[i].name = pokeNames[i];
            }
            this.populateEvolutions();
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void loadMoves() {
        try {
            this.moveNarc = this.readNARC(this.romEntry.getString("MoveData"));
            this.moves = new Move[560];
            List<String> moveNames = this.getStrings(false, this.romEntry.getInt("MoveNamesTextOffset"));
            for (int i = 1; i <= 559; ++i) {
                byte[] moveData = this.moveNarc.files.get(i);
                this.moves[i] = new Move();
                this.moves[i].name = moveNames.get(i);
                this.moves[i].number = i;
                this.moves[i].internalId = i;
                this.moves[i].hitratio = moveData[4] & 0xFF;
                this.moves[i].power = moveData[3] & 0xFF;
                this.moves[i].pp = moveData[5] & 0xFF;
                this.moves[i].type = Gen5Constants.typeTable[moveData[0] & 0xFF];
                this.moves[i].category = Gen5Constants.moveCategoryIndices[moveData[2] & 0xFF];
                if (GlobalConstants.normalMultihitMoves.contains(i)) {
                    this.moves[i].hitCount = 3.1666666666666665;
                    continue;
                }
                if (GlobalConstants.doubleHitMoves.contains(i)) {
                    this.moves[i].hitCount = 2.0;
                    continue;
                }
                if (i != 167) continue;
                this.moves[i].hitCount = 2.71;
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void loadBasicPokeStats(Pokemon pkmn, byte[] stats) {
        int item2;
        pkmn.hp = stats[0] & 0xFF;
        pkmn.attack = stats[1] & 0xFF;
        pkmn.defense = stats[2] & 0xFF;
        pkmn.speed = stats[3] & 0xFF;
        pkmn.spatk = stats[4] & 0xFF;
        pkmn.spdef = stats[5] & 0xFF;
        pkmn.primaryType = Gen5Constants.typeTable[stats[6] & 0xFF];
        pkmn.secondaryType = Gen5Constants.typeTable[stats[7] & 0xFF];
        if (pkmn.secondaryType == pkmn.primaryType) {
            pkmn.secondaryType = null;
        }
        pkmn.catchRate = stats[8] & 0xFF;
        pkmn.growthCurve = ExpCurve.fromByte(stats[21]);
        pkmn.ability1 = stats[24] & 0xFF;
        pkmn.ability2 = stats[25] & 0xFF;
        pkmn.ability3 = stats[26] & 0xFF;
        int item1 = this.readWord(stats, 12);
        if (item1 == (item2 = this.readWord(stats, 14))) {
            pkmn.guaranteedHeldItem = item1;
            pkmn.commonHeldItem = 0;
            pkmn.rareHeldItem = 0;
            pkmn.darkGrassHeldItem = 0;
        } else {
            pkmn.guaranteedHeldItem = 0;
            pkmn.commonHeldItem = item1;
            pkmn.rareHeldItem = item2;
            pkmn.darkGrassHeldItem = this.readWord(stats, 16);
        }
    }

    private String[] readPokemonNames() {
        String[] pokeNames = new String[650];
        List<String> nameList = this.getStrings(false, this.romEntry.getInt("PokemonNamesTextOffset"));
        for (int i = 1; i <= 649; ++i) {
            pokeNames[i] = nameList.get(i);
        }
        return pokeNames;
    }

    @Override
    protected void savingROM() {
        this.savePokemonStats();
        this.saveMoves();
        try {
            this.writeARM9(this.arm9);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.writeNARC(this.romEntry.getString("TextStrings"), this.stringsNarc);
            this.writeNARC(this.romEntry.getString("TextStory"), this.storyTextNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.writeNARC(this.romEntry.getString("Scripts"), this.scriptNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void saveMoves() {
        for (int i = 1; i <= 559; ++i) {
            byte[] data = this.moveNarc.files.get(i);
            data[2] = Gen5Constants.moveCategoryToByte(this.moves[i].category);
            data[3] = (byte)this.moves[i].power;
            data[0] = Gen5Constants.typeToByte(this.moves[i].type);
            int hitratio = (int)Math.round(this.moves[i].hitratio);
            if (hitratio < 0) {
                hitratio = 0;
            }
            if (hitratio > 101) {
                hitratio = 100;
            }
            data[4] = (byte)hitratio;
            data[5] = (byte)this.moves[i].pp;
        }
        try {
            this.writeNARC(this.romEntry.getString("MoveData"), this.moveNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void savePokemonStats() {
        List<String> nameList = this.getStrings(false, this.romEntry.getInt("PokemonNamesTextOffset"));
        for (int i = 1; i <= 649; ++i) {
            this.saveBasicPokeStats(this.pokes[i], this.pokeNarc.files.get(i));
            nameList.set(i, this.pokes[i].name);
        }
        this.setStrings(false, this.romEntry.getInt("PokemonNamesTextOffset"), nameList);
        try {
            this.writeNARC(this.romEntry.getString("PokemonStats"), this.pokeNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        this.writeEvolutions();
    }

    private void saveBasicPokeStats(Pokemon pkmn, byte[] stats) {
        stats[0] = (byte)pkmn.hp;
        stats[1] = (byte)pkmn.attack;
        stats[2] = (byte)pkmn.defense;
        stats[3] = (byte)pkmn.speed;
        stats[4] = (byte)pkmn.spatk;
        stats[5] = (byte)pkmn.spdef;
        stats[6] = Gen5Constants.typeToByte(pkmn.primaryType);
        stats[7] = pkmn.secondaryType == null ? stats[6] : Gen5Constants.typeToByte(pkmn.secondaryType);
        stats[8] = (byte)pkmn.catchRate;
        stats[21] = pkmn.growthCurve.toByte();
        stats[24] = (byte)pkmn.ability1;
        stats[25] = (byte)pkmn.ability2;
        stats[26] = (byte)pkmn.ability3;
        if (pkmn.guaranteedHeldItem > 0) {
            this.writeWord(stats, 12, pkmn.guaranteedHeldItem);
            this.writeWord(stats, 14, pkmn.guaranteedHeldItem);
            this.writeWord(stats, 16, 0);
        } else {
            this.writeWord(stats, 12, pkmn.commonHeldItem);
            this.writeWord(stats, 14, pkmn.rareHeldItem);
            this.writeWord(stats, 16, pkmn.darkGrassHeldItem);
        }
    }

    @Override
    public List<Pokemon> getPokemon() {
        return this.pokemonList;
    }

    @Override
    public List<Pokemon> getStarters() {
        NARCArchive scriptNARC = this.scriptNarc;
        ArrayList<Pokemon> starters = new ArrayList<Pokemon>();
        for (int i = 0; i < 3; ++i) {
            OffsetWithinEntry[] thisStarter = (OffsetWithinEntry[])this.romEntry.offsetArrayEntries.get("StarterOffsets" + (i + 1));
            starters.add(this.pokes[this.readWord(scriptNARC.files.get(thisStarter[0].entry), thisStarter[0].offset)]);
        }
        return starters;
    }

    @Override
    public boolean setStarters(List<Pokemon> newStarters) {
        if (newStarters.size() != 3) {
            return false;
        }
        try {
            int offset;
            byte[] newFile;
            byte[] oldFile;
            byte[] newScript;
            NARCArchive scriptNARC = this.scriptNarc;
            for (int i = 0; i < 3; ++i) {
                OffsetWithinEntry[] thisStarter;
                int starter = newStarters.get((int)i).number;
                for (OffsetWithinEntry entry : thisStarter = (OffsetWithinEntry[])this.romEntry.offsetArrayEntries.get("StarterOffsets" + (i + 1))) {
                    this.writeWord(scriptNARC.files.get(entry.entry), entry.offset, starter);
                }
            }
            if (this.romEntry.romType == 1) {
                newScript = Gen5Constants.bw2NewStarterScript;
                oldFile = scriptNARC.files.get(this.romEntry.getInt("PokedexGivenFileOffset"));
                newFile = new byte[oldFile.length + newScript.length];
                offset = this.find(oldFile, "2800A1400400");
                if (offset > 0) {
                    System.arraycopy(oldFile, 0, newFile, 0, oldFile.length);
                    System.arraycopy(newScript, 0, newFile, oldFile.length, newScript.length);
                    if (this.romEntry.romCode.charAt(3) == 'J') {
                        int n = oldFile.length + 6;
                        newFile[n] = (byte)(newFile[n] - 4);
                    }
                    newFile[offset++] = 30;
                    newFile[offset++] = 0;
                    this.writeRelativePointer(newFile, offset, oldFile.length);
                    scriptNARC.files.set(this.romEntry.getInt("PokedexGivenFileOffset"), newFile);
                }
            } else {
                newScript = Gen5Constants.bw1NewStarterScript;
                oldFile = scriptNARC.files.get(this.romEntry.getInt("PokedexGivenFileOffset"));
                newFile = new byte[oldFile.length + newScript.length];
                offset = this.find(oldFile, "2400A702");
                if (offset > 0) {
                    System.arraycopy(oldFile, 0, newFile, 0, oldFile.length);
                    System.arraycopy(newScript, 0, newFile, oldFile.length, newScript.length);
                    if (this.romEntry.romCode.charAt(3) == 'J') {
                        int n = oldFile.length + 4;
                        newFile[n] = (byte)(newFile[n] - 4);
                        int n2 = oldFile.length + 8;
                        newFile[n2] = (byte)(newFile[n2] - 4);
                    }
                    newFile[offset++] = 4;
                    newFile[offset++] = 0;
                    this.writeRelativePointer(newFile, offset, oldFile.length);
                    scriptNARC.files.set(this.romEntry.getInt("PokedexGivenFileOffset"), newFile);
                }
            }
            NARCArchive starterNARC = this.readNARC(this.romEntry.getString("StarterGraphics"));
            NARCArchive pokespritesNARC = this.readNARC(this.romEntry.getString("PokemonGraphics"));
            this.replaceStarterFiles(starterNARC, pokespritesNARC, 0, newStarters.get((int)0).number);
            this.replaceStarterFiles(starterNARC, pokespritesNARC, 1, newStarters.get((int)1).number);
            this.replaceStarterFiles(starterNARC, pokespritesNARC, 2, newStarters.get((int)2).number);
            this.writeNARC(this.romEntry.getString("StarterGraphics"), starterNARC);
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
        catch (InterruptedException e) {
            throw new RandomizerIOException(e);
        }
        if (this.romEntry.romType == 0) {
            List<String> yourHouseStrings = this.getStrings(true, this.romEntry.getInt("StarterLocationTextOffset"));
            for (int i = 0; i < 3; ++i) {
                yourHouseStrings.set(18 - i, "\\xF000\\xBD02\\x0000The " + newStarters.get((int)i).primaryType.camelCase() + "-type Pok\\x00E9mon\\xFFFE\\xF000\\xBD02\\x0000" + newStarters.get((int)i).name);
            }
            yourHouseStrings.set(26, "Cheren: Hey, how come you get to pick\\xFFFEout my Pok\\x00E9mon?\\xF000\\xBE01\\x0000\\xFFFEOh, never mind. I wanted this one\\xFFFEfrom the start, anyway.\\xF000\\xBE01\\x0000");
            yourHouseStrings.set(53, "It's decided. You'll be my opponent...\\xFFFEin our first Pok\\x00E9mon battle!\\xF000\\xBE01\\x0000\\xFFFELet's see what you can do, \\xFFFEmy Pok\\x00E9mon!\\xF000\\xBE01\\x0000");
            this.setStrings(true, this.romEntry.getInt("StarterLocationTextOffset"), yourHouseStrings);
        } else {
            List<String> starterTownStrings = this.getStrings(true, this.romEntry.getInt("StarterLocationTextOffset"));
            for (int i = 0; i < 3; ++i) {
                starterTownStrings.set(37 - i, "\\xF000\\xBD02\\x0000The " + newStarters.get((int)i).primaryType.camelCase() + "-type Pok\\x00E9mon\\xFFFE\\xF000\\xBD02\\x0000" + newStarters.get((int)i).name);
            }
            starterTownStrings.set(60, "\\xF000\\x0100\\x0001\\x0001: Let's see how good\\xFFFEa Trainer you are!\\xF000\\xBE01\\x0000\\xFFFEI'll use my Pok\\x00E9mon\\xFFFEthat I raised from an Egg!\\xF000\\xBE01\\x0000");
            this.setStrings(true, this.romEntry.getInt("StarterLocationTextOffset"), starterTownStrings);
        }
        return true;
    }

    @Override
    public List<Integer> getStarterHeldItems() {
        return new ArrayList<Integer>();
    }

    @Override
    public void setStarterHeldItems(List<Integer> items) {
    }

    private void replaceStarterFiles(NARCArchive starterNARC, NARCArchive pokespritesNARC, int starterIndex, int pokeNumber) throws IOException, InterruptedException {
        starterNARC.files.set(starterIndex * 2, pokespritesNARC.files.get(pokeNumber * 20 + 18));
        byte[] compressedPic = pokespritesNARC.files.get(pokeNumber * 20);
        byte[] uncompressedPic = DSDecmp.Decompress(compressedPic);
        starterNARC.files.set(12 + starterIndex, uncompressedPic);
    }

    @Override
    public List<Move> getMoves() {
        return Arrays.asList(this.moves);
    }

    @Override
    public List<EncounterSet> getEncounters(boolean useTimeOfDay) {
        if (!this.loadedWildMapNames) {
            this.loadWildMapNames();
        }
        try {
            NARCArchive encounterNARC = this.readNARC(this.romEntry.getString("WildPokemon"));
            ArrayList<EncounterSet> encounters = new ArrayList<EncounterSet>();
            int idx = -1;
            for (byte[] entry : encounterNARC.files) {
                ++idx;
                if (entry.length > 232 && useTimeOfDay) {
                    for (int i = 0; i < 4; ++i) {
                        this.processEncounterEntry(encounters, entry, i * 232, idx);
                    }
                    continue;
                }
                this.processEncounterEntry(encounters, entry, 0, idx);
            }
            return encounters;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void processEncounterEntry(List<EncounterSet> encounters, byte[] entry, int startOffset, int idx) {
        if (!this.wildMapNames.containsKey(idx)) {
            this.wildMapNames.put(idx, "? Unknown ?");
        }
        String mapName = this.wildMapNames.get(idx);
        int[] amounts = Gen5Constants.encountersOfEachType;
        int offset = 8;
        for (int i = 0; i < 7; ++i) {
            int rate = entry[startOffset + i] & 0xFF;
            if (rate != 0) {
                List<Encounter> encs = this.readEncounters(entry, startOffset + offset, amounts[i]);
                EncounterSet area = new EncounterSet();
                area.rate = rate;
                area.encounters = encs;
                area.offset = idx;
                area.displayName = mapName + " " + Gen5Constants.encounterTypeNames[i];
                encounters.add(area);
            }
            offset += amounts[i] * 4;
        }
    }

    private List<Encounter> readEncounters(byte[] data, int offset, int number) {
        ArrayList<Encounter> encs = new ArrayList<Encounter>();
        for (int i = 0; i < number; ++i) {
            Encounter enc1 = new Encounter();
            enc1.pokemon = this.pokes[(data[offset + i * 4] & 0xFF) + ((data[offset + 1 + i * 4] & 3) << 8)];
            enc1.level = data[offset + 2 + i * 4] & 0xFF;
            enc1.maxLevel = data[offset + 3 + i * 4] & 0xFF;
            encs.add(enc1);
        }
        return encs;
    }

    @Override
    public void setEncounters(boolean useTimeOfDay, List<EncounterSet> encountersList) {
        block13: {
            try {
                int s;
                int i;
                NARCArchive encounterNARC = this.readNARC(this.romEntry.getString("WildPokemon"));
                Iterator<EncounterSet> encounters = encountersList.iterator();
                for (byte[] entry : encounterNARC.files) {
                    this.writeEncounterEntry(encounters, entry, 0);
                    if (entry.length <= 232) continue;
                    if (useTimeOfDay) {
                        for (i = 1; i < 4; ++i) {
                            this.writeEncounterEntry(encounters, entry, i * 232);
                        }
                        continue;
                    }
                    System.arraycopy(entry, 0, entry, 232, 232);
                    System.arraycopy(entry, 0, entry, 464, 232);
                    System.arraycopy(entry, 0, entry, 696, 232);
                }
                this.writeNARC(this.romEntry.getString("WildPokemon"), encounterNARC);
                if (this.romEntry.romType != 1) break block13;
                NARCArchive areaNARC = this.readNARC(this.romEntry.getString("PokemonAreaData"));
                ArrayList<byte[]> newFiles = new ArrayList<byte[]>();
                for (i = 0; i < 649; ++i) {
                    byte[] nf = new byte[345];
                    nf[0] = 1;
                    newFiles.add(nf);
                }
                for (i = 0; i < encounterNARC.files.size(); ++i) {
                    byte[] encEntry = encounterNARC.files.get(i);
                    if (encEntry.length > 232) {
                        for (s = 0; s < 4; ++s) {
                            this.parseAreaData(encEntry, s * 232, newFiles, s, i);
                        }
                        continue;
                    }
                    for (s = 0; s < 4; ++s) {
                        this.parseAreaData(encEntry, 0, newFiles, s, i);
                    }
                }
                for (i = 0; i < 649; ++i) {
                    byte[] file = (byte[])newFiles.get(i);
                    for (s = 0; s < 4; ++s) {
                        boolean unobtainable = true;
                        for (int e = 0; e < 85; ++e) {
                            if (file[s * 86 + e + 2] == 0) continue;
                            unobtainable = false;
                            break;
                        }
                        if (!unobtainable) continue;
                        file[s * 86 + 1] = 1;
                    }
                    areaNARC.files.set(i, file);
                }
                this.writeNARC(this.romEntry.getString("PokemonAreaData"), areaNARC);
            }
            catch (IOException e) {
                throw new RandomizerIOException(e);
            }
        }
    }

    private void parseAreaData(byte[] entry, int startOffset, List<byte[]> areaData, int season, int fileNumber) {
        int[] amounts = Gen5Constants.encountersOfEachType;
        int offset = 8;
        for (int i = 0; i < 7; ++i) {
            int rate = entry[startOffset + i] & 0xFF;
            if (rate != 0) {
                for (int e = 0; e < amounts[i]; ++e) {
                    Pokemon pkmn = this.pokes[(entry[startOffset + offset + e * 4] & 0xFF) + ((entry[startOffset + offset + 1 + e * 4] & 3) << 8)];
                    byte[] pokeFile = areaData.get(pkmn.number - 1);
                    int areaIndex = Gen5Constants.wildFileToAreaMap[fileNumber];
                    if (areaIndex == 40 && (fileNumber == 104 && this.romEntry.romCode.charAt(2) == 'D' || fileNumber == 105 && this.romEntry.romCode.charAt(2) == 'E')) {
                        areaIndex = -1;
                    }
                    if (areaIndex == 76) {
                        if (this.romEntry.romCode.charAt(2) == 'D') {
                            if (fileNumber == 71 || fileNumber == 73) {
                                areaIndex = -1;
                            }
                        } else if (fileNumber == 78 || fileNumber == 79) {
                            areaIndex = -1;
                        }
                    }
                    if (areaIndex == 73) {
                        if (this.romEntry.romCode.charAt(2) == 'D') {
                            if (fileNumber >= 49 && fileNumber <= 54) {
                                areaIndex = -1;
                            }
                        } else if (fileNumber >= 55 && fileNumber <= 60) {
                            areaIndex = -1;
                        }
                    }
                    if (areaIndex == -1) continue;
                    int n = season * 86 + 2 + areaIndex;
                    pokeFile[n] = (byte)(pokeFile[n] | 1 << i);
                }
            }
            offset += amounts[i] * 4;
        }
    }

    private void addHabitats(byte[] entry, int startOffset, Map<Pokemon, byte[]> pokemonHere, int season) {
        int[] amounts = Gen5Constants.encountersOfEachType;
        int[] type = Gen5Constants.habitatClassificationOfEachType;
        int offset = 8;
        for (int i = 0; i < 7; ++i) {
            int rate = entry[startOffset + i] & 0xFF;
            if (rate != 0) {
                for (int e = 0; e < amounts[i]; ++e) {
                    Pokemon pkmn = this.pokes[(entry[startOffset + offset + e * 4] & 0xFF) + ((entry[startOffset + offset + 1 + e * 4] & 3) << 8)];
                    if (pokemonHere.containsKey(pkmn)) {
                        pokemonHere.get((Object)pkmn)[type[i] + season * 3] = 1;
                        continue;
                    }
                    byte[] locs = new byte[12];
                    locs[type[i] + season * 3] = 1;
                    pokemonHere.put(pkmn, locs);
                }
            }
            offset += amounts[i] * 4;
        }
    }

    private void writeEncounterEntry(Iterator<EncounterSet> encounters, byte[] entry, int startOffset) {
        int[] amounts = Gen5Constants.encountersOfEachType;
        int offset = 8;
        for (int i = 0; i < 7; ++i) {
            int rate = entry[startOffset + i] & 0xFF;
            if (rate != 0) {
                EncounterSet area = encounters.next();
                for (int j = 0; j < amounts[i]; ++j) {
                    Encounter enc = area.encounters.get(j);
                    this.writeWord(entry, startOffset + offset + j * 4, enc.pokemon.number);
                    entry[startOffset + offset + j * 4 + 2] = (byte)enc.level;
                    entry[startOffset + offset + j * 4 + 3] = (byte)enc.maxLevel;
                }
            }
            offset += amounts[i] * 4;
        }
    }

    private void loadWildMapNames() {
        try {
            this.wildMapNames = new HashMap<Integer, String>();
            byte[] mapHeaderData = this.readNARC((String)((RomEntry)this.romEntry).getString((String)"MapTableFile")).files.get(0);
            int numMapHeaders = mapHeaderData.length / 48;
            List<String> allMapNames = this.getStrings(false, this.romEntry.getInt("MapNamesTextOffset"));
            for (int map = 0; map < numMapHeaders; ++map) {
                int wildSet;
                int baseOffset = map * 48;
                int mapNameIndex = mapHeaderData[baseOffset + 26] & 0xFF;
                String mapName = allMapNames.get(mapNameIndex);
                if (this.romEntry.romType == 1) {
                    wildSet = mapHeaderData[baseOffset + 20] & 0xFF;
                    if (wildSet == 255) continue;
                    this.wildMapNames.put(wildSet, mapName);
                    continue;
                }
                wildSet = this.readWord(mapHeaderData, baseOffset + 20);
                if (wildSet == 65535) continue;
                this.wildMapNames.put(wildSet, mapName);
            }
            this.loadedWildMapNames = true;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public List<Trainer> getTrainers() {
        ArrayList<Trainer> allTrainers = new ArrayList<Trainer>();
        try {
            NARCArchive trainers = this.readNARC(this.romEntry.getString("TrainerData"));
            NARCArchive trpokes = this.readNARC(this.romEntry.getString("TrainerPokemon"));
            int trainernum = trainers.files.size();
            List<String> tclasses = this.getTrainerClassNames();
            List<String> tnames = this.getTrainerNames();
            for (int i = 1; i < trainernum; ++i) {
                byte[] trainer = trainers.files.get(i);
                byte[] trpoke = trpokes.files.get(i);
                Trainer tr = new Trainer();
                tr.poketype = trainer[0] & 0xFF;
                tr.offset = i;
                tr.trainerclass = trainer[1] & 0xFF;
                int numPokes = trainer[3] & 0xFF;
                int pokeOffs = 0;
                tr.fullDisplayName = tclasses.get(tr.trainerclass) + " " + tnames.get(i - 1);
                for (int poke = 0; poke < numPokes; ++poke) {
                    int ailevel = trpoke[pokeOffs] & 0xFF;
                    int level = this.readWord(trpoke, pokeOffs + 2);
                    int species = this.readWord(trpoke, pokeOffs + 4);
                    TrainerPokemon tpk = new TrainerPokemon();
                    tpk.level = level;
                    tpk.pokemon = this.pokes[species];
                    tpk.AILevel = ailevel;
                    tpk.ability = trpoke[pokeOffs + 1] & 0xFF;
                    pokeOffs += 8;
                    if ((tr.poketype & 2) == 2) {
                        int heldItem;
                        tpk.heldItem = heldItem = this.readWord(trpoke, pokeOffs);
                        pokeOffs += 2;
                    }
                    if ((tr.poketype & 1) == 1) {
                        int attack1 = this.readWord(trpoke, pokeOffs);
                        int attack2 = this.readWord(trpoke, pokeOffs + 2);
                        int attack3 = this.readWord(trpoke, pokeOffs + 4);
                        int attack4 = this.readWord(trpoke, pokeOffs + 6);
                        tpk.move1 = attack1;
                        tpk.move2 = attack2;
                        tpk.move3 = attack3;
                        tpk.move4 = attack4;
                        pokeOffs += 8;
                    }
                    tr.pokemon.add(tpk);
                }
                allTrainers.add(tr);
            }
            if (this.romEntry.romType == 0) {
                Gen5Constants.tagTrainersBW(allTrainers);
            } else {
                if (!this.romEntry.getString("DriftveilPokemon").isEmpty()) {
                    NARCArchive driftveil = this.readNARC(this.romEntry.getString("DriftveilPokemon"));
                    for (int trno = 0; trno < 2; ++trno) {
                        Trainer tr = new Trainer();
                        tr.poketype = 3;
                        tr.offset = 0;
                        for (int poke = 0; poke < 3; ++poke) {
                            byte[] pkmndata = driftveil.files.get(trno * 3 + poke + 1);
                            TrainerPokemon tpk = new TrainerPokemon();
                            tpk.level = 25;
                            tpk.pokemon = this.pokes[this.readWord(pkmndata, 0)];
                            tpk.AILevel = 255;
                            tpk.heldItem = this.readWord(pkmndata, 12);
                            tpk.move1 = this.readWord(pkmndata, 2);
                            tpk.move2 = this.readWord(pkmndata, 4);
                            tpk.move3 = this.readWord(pkmndata, 6);
                            tpk.move4 = this.readWord(pkmndata, 8);
                            tr.pokemon.add(tpk);
                        }
                        allTrainers.add(tr);
                    }
                }
                Gen5Constants.tagTrainersBW2(allTrainers);
            }
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
        return allTrainers;
    }

    @Override
    public void setTrainers(List<Trainer> trainerData) {
        block14: {
            Iterator<Trainer> allTrainers = trainerData.iterator();
            try {
                Trainer tr;
                NARCArchive trainers = this.readNARC(this.romEntry.getString("TrainerData"));
                NARCArchive trpokes = new NARCArchive();
                Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
                trpokes.files.add(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
                int trainernum = trainers.files.size();
                for (int i = 1; i < trainernum; ++i) {
                    byte[] trainer = trainers.files.get(i);
                    tr = allTrainers.next();
                    trainer[0] = (byte)tr.poketype;
                    int numPokes = tr.pokemon.size();
                    trainer[3] = (byte)numPokes;
                    int bytesNeeded = 8 * numPokes;
                    if ((tr.poketype & 1) == 1) {
                        bytesNeeded += 8 * numPokes;
                    }
                    if ((tr.poketype & 2) == 2) {
                        bytesNeeded += 2 * numPokes;
                    }
                    byte[] trpoke = new byte[bytesNeeded];
                    int pokeOffs = 0;
                    Iterator<TrainerPokemon> tpokes = tr.pokemon.iterator();
                    for (int poke = 0; poke < numPokes; ++poke) {
                        TrainerPokemon tp = tpokes.next();
                        trpoke[pokeOffs] = (byte)tp.AILevel;
                        this.writeWord(trpoke, pokeOffs + 2, tp.level);
                        this.writeWord(trpoke, pokeOffs + 4, tp.pokemon.number);
                        pokeOffs += 8;
                        if ((tr.poketype & 2) == 2) {
                            this.writeWord(trpoke, pokeOffs, tp.heldItem);
                            pokeOffs += 2;
                        }
                        if ((tr.poketype & 1) != 1) continue;
                        if (tp.resetMoves) {
                            int[] pokeMoves = RomFunctions.getMovesAtLevel(tp.pokemon, movesets, tp.level);
                            for (int m = 0; m < 4; ++m) {
                                this.writeWord(trpoke, pokeOffs + m * 2, pokeMoves[m]);
                            }
                        } else {
                            this.writeWord(trpoke, pokeOffs, tp.move1);
                            this.writeWord(trpoke, pokeOffs + 2, tp.move2);
                            this.writeWord(trpoke, pokeOffs + 4, tp.move3);
                            this.writeWord(trpoke, pokeOffs + 6, tp.move4);
                        }
                        pokeOffs += 8;
                    }
                    trpokes.files.add(trpoke);
                }
                this.writeNARC(this.romEntry.getString("TrainerData"), trainers);
                this.writeNARC(this.romEntry.getString("TrainerPokemon"), trpokes);
                if (this.romEntry.romType != 1 || this.romEntry.getString("DriftveilPokemon").isEmpty()) break block14;
                NARCArchive driftveil = this.readNARC(this.romEntry.getString("DriftveilPokemon"));
                for (int trno = 0; trno < 2; ++trno) {
                    tr = allTrainers.next();
                    Iterator<TrainerPokemon> tpks = tr.pokemon.iterator();
                    for (int poke = 0; poke < 3; ++poke) {
                        byte[] pkmndata = driftveil.files.get(trno * 3 + poke + 1);
                        TrainerPokemon tp = tpks.next();
                        this.writeWord(pkmndata, 0, tp.pokemon.number);
                        this.writeWord(pkmndata, 12, tp.heldItem);
                        if (tp.resetMoves) {
                            int[] pokeMoves = RomFunctions.getMovesAtLevel(tp.pokemon, movesets, tp.level);
                            for (int m = 0; m < 4; ++m) {
                                this.writeWord(pkmndata, 2 + m * 2, pokeMoves[m]);
                            }
                            continue;
                        }
                        this.writeWord(pkmndata, 2, tp.move1);
                        this.writeWord(pkmndata, 4, tp.move2);
                        this.writeWord(pkmndata, 6, tp.move3);
                        this.writeWord(pkmndata, 8, tp.move4);
                    }
                }
                this.writeNARC(this.romEntry.getString("DriftveilPokemon"), driftveil);
            }
            catch (IOException ex) {
                throw new RandomizerIOException(ex);
            }
        }
    }

    @Override
    public Map<Pokemon, List<MoveLearnt>> getMovesLearnt() {
        TreeMap<Pokemon, List<MoveLearnt>> movesets = new TreeMap<Pokemon, List<MoveLearnt>>();
        try {
            NARCArchive movesLearnt = this.readNARC(this.romEntry.getString("PokemonMovesets"));
            for (int i = 1; i <= 649; ++i) {
                Pokemon pkmn = this.pokes[i];
                byte[] movedata = movesLearnt.files.get(i);
                int moveDataLoc = 0;
                ArrayList<MoveLearnt> learnt = new ArrayList<MoveLearnt>();
                while (this.readWord(movedata, moveDataLoc) != 65535 || this.readWord(movedata, moveDataLoc + 2) != 65535) {
                    int move = this.readWord(movedata, moveDataLoc);
                    int level = this.readWord(movedata, moveDataLoc + 2);
                    MoveLearnt ml = new MoveLearnt();
                    ml.level = level;
                    ml.move = move;
                    learnt.add(ml);
                    moveDataLoc += 4;
                }
                movesets.put(pkmn, learnt);
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return movesets;
    }

    @Override
    public void setMovesLearnt(Map<Pokemon, List<MoveLearnt>> movesets) {
        try {
            NARCArchive movesLearnt = this.readNARC(this.romEntry.getString("PokemonMovesets"));
            for (int i = 1; i <= 649; ++i) {
                int j;
                Pokemon pkmn = this.pokes[i];
                List<MoveLearnt> learnt = movesets.get(pkmn);
                int sizeNeeded = learnt.size() * 4 + 4;
                byte[] moveset = new byte[sizeNeeded];
                for (j = 0; j < learnt.size(); ++j) {
                    MoveLearnt ml = learnt.get(j);
                    this.writeWord(moveset, j * 4, ml.move);
                    this.writeWord(moveset, j * 4 + 2, ml.level);
                }
                this.writeWord(moveset, j * 4, 65535);
                this.writeWord(moveset, j * 4 + 2, 65535);
                movesLearnt.files.set(i, moveset);
            }
            this.writeNARC(this.romEntry.getString("PokemonMovesets"), movesLearnt);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return this.romEntry.staticPokemonSupport;
    }

    @Override
    public List<Pokemon> getStaticPokemon() {
        ArrayList<Pokemon> sp = new ArrayList<Pokemon>();
        if (!this.romEntry.staticPokemonSupport) {
            return sp;
        }
        NARCArchive scriptNARC = this.scriptNarc;
        for (StaticPokemon statP : this.romEntry.staticPokemon) {
            sp.add(statP.getPokemon(this, scriptNARC));
        }
        return sp;
    }

    @Override
    public boolean setStaticPokemon(List<Pokemon> staticPokemon) {
        if (!this.romEntry.staticPokemonSupport) {
            return false;
        }
        if (staticPokemon.size() != this.romEntry.staticPokemon.size()) {
            return false;
        }
        Iterator<Pokemon> statics = staticPokemon.iterator();
        NARCArchive scriptNARC = this.scriptNarc;
        for (StaticPokemon statP : this.romEntry.staticPokemon) {
            statP.setPokemon(this, scriptNARC, statics.next());
        }
        if (this.romEntry.offsetArrayEntries.containsKey("StaticPokemonFormValues")) {
            OffsetWithinEntry[] formValues;
            for (OffsetWithinEntry owe : formValues = (OffsetWithinEntry[])this.romEntry.offsetArrayEntries.get("StaticPokemonFormValues")) {
                this.writeWord(scriptNARC.files.get(owe.entry), owe.offset, 0);
            }
        }
        return true;
    }

    @Override
    public int miscTweaksAvailable() {
        int available = 0;
        if (this.romEntry.romType == 1) {
            available |= MiscTweak.RANDOMIZE_HIDDEN_HOLLOWS.getValue();
        }
        if (this.romEntry.tweakFiles.get("FastestTextTweak") != null) {
            available |= MiscTweak.FASTEST_TEXT.getValue();
        }
        return available |= MiscTweak.BAN_LUCKY_EGG.getValue();
    }

    @Override
    public void applyMiscTweak(MiscTweak tweak) {
        if (tweak == MiscTweak.RANDOMIZE_HIDDEN_HOLLOWS) {
            this.randomizeHiddenHollowPokemon();
        } else if (tweak == MiscTweak.FASTEST_TEXT) {
            this.applyFastestText();
        } else if (tweak == MiscTweak.BAN_LUCKY_EGG) {
            this.allowedItems.banSingles(231);
            this.nonBadItems.banSingles(231);
        }
    }

    private void randomizeHiddenHollowPokemon() {
        if (this.romEntry.romType != 1) {
            return;
        }
        int[] allowedUnovaPokemon = Gen5Constants.bw2HiddenHollowUnovaPokemon;
        int randomSize = 493 + allowedUnovaPokemon.length;
        try {
            NARCArchive hhNARC = this.readNARC(this.romEntry.getString("HiddenHollows"));
            for (byte[] hhEntry : hhNARC.files) {
                for (int version = 0; version < 2; ++version) {
                    for (int rarityslot = 0; rarityslot < 3; ++rarityslot) {
                        for (int group = 0; group < 4; ++group) {
                            int pokeChoice = this.random.nextInt(randomSize) + 1;
                            if (pokeChoice > 493) {
                                pokeChoice = allowedUnovaPokemon[pokeChoice - 494];
                            }
                            this.writeWord(hhEntry, version * 78 + rarityslot * 26 + group * 2, pokeChoice);
                            int genderRatio = this.random.nextInt(101);
                            hhEntry[version * 78 + rarityslot * 26 + 16 + group] = (byte)genderRatio;
                            hhEntry[version * 78 + rarityslot * 26 + 20 + group] = 0;
                        }
                    }
                }
            }
            this.writeNARC(this.romEntry.getString("HiddenHollows"), hhNARC);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void applyFastestText() {
        this.genericIPSPatch(this.arm9, "FastestTextTweak");
    }

    private boolean genericIPSPatch(byte[] data, String ctName) {
        String patchName = (String)this.romEntry.tweakFiles.get(ctName);
        if (patchName == null) {
            return false;
        }
        try {
            FileFunctions.applyPatch(data, patchName);
            return true;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public List<Integer> getTMMoves() {
        String tmDataPrefix = "87038803";
        int offset = this.find(this.arm9, tmDataPrefix);
        if (offset > 0) {
            int i;
            offset += "87038803".length() / 2;
            ArrayList<Integer> tms = new ArrayList<Integer>();
            for (i = 0; i < 92; ++i) {
                tms.add(this.readWord(this.arm9, offset + i * 2));
            }
            offset += 196;
            for (i = 0; i < 3; ++i) {
                tms.add(this.readWord(this.arm9, offset + i * 2));
            }
            return tms;
        }
        return null;
    }

    @Override
    public List<Integer> getHMMoves() {
        String tmDataPrefix = "87038803";
        int offset = this.find(this.arm9, tmDataPrefix);
        if (offset > 0) {
            offset += "87038803".length() / 2;
            offset += 184;
            ArrayList<Integer> hms = new ArrayList<Integer>();
            for (int i = 0; i < 6; ++i) {
                hms.add(this.readWord(this.arm9, offset + i * 2));
            }
            return hms;
        }
        return null;
    }

    @Override
    public void setTMMoves(List<Integer> moveIndexes) {
        String tmDataPrefix = "87038803";
        int offset = this.find(this.arm9, tmDataPrefix);
        if (offset > 0) {
            int i;
            int i2;
            offset += "87038803".length() / 2;
            for (i2 = 0; i2 < 92; ++i2) {
                this.writeWord(this.arm9, offset + i2 * 2, moveIndexes.get(i2));
            }
            offset += 196;
            for (i2 = 0; i2 < 3; ++i2) {
                this.writeWord(this.arm9, offset + i2 * 2, moveIndexes.get(i2 + 92));
            }
            List<String> itemDescriptions = this.getStrings(false, this.romEntry.getInt("ItemDescriptionsTextOffset"));
            List<String> moveDescriptions = this.getStrings(false, this.romEntry.getInt("MoveDescriptionsTextOffset"));
            for (i = 0; i < 92; ++i) {
                itemDescriptions.set(i + 328, moveDescriptions.get(moveIndexes.get(i)));
            }
            for (i = 0; i < 3; ++i) {
                itemDescriptions.set(i + 618, moveDescriptions.get(moveIndexes.get(i + 92)));
            }
            this.setStrings(false, this.romEntry.getInt("ItemDescriptionsTextOffset"), itemDescriptions);
            String baseOfPalettes = this.romEntry.romType == 0 ? "E903EA03020003000400050006000700" : "FD03FE03020003000400050006000700";
            int offsPals = this.find(this.arm9, baseOfPalettes);
            if (offsPals > 0) {
                int pal;
                Move m;
                int itmNum;
                int i3;
                for (i3 = 0; i3 < 92; ++i3) {
                    itmNum = 328 + i3;
                    m = this.moves[moveIndexes.get(i3)];
                    pal = this.typeTMPaletteNumber(m.type);
                    this.writeWord(this.arm9, offsPals + itmNum * 4 + 2, pal);
                }
                for (i3 = 0; i3 < 3; ++i3) {
                    itmNum = 618 + i3;
                    m = this.moves[moveIndexes.get(i3 + 92)];
                    pal = this.typeTMPaletteNumber(m.type);
                    this.writeWord(this.arm9, offsPals + itmNum * 4 + 2, pal);
                }
            }
        }
    }

    @Override
    public int getTMCount() {
        return 95;
    }

    @Override
    public int getHMCount() {
        return 6;
    }

    @Override
    public Map<Pokemon, boolean[]> getTMHMCompatibility() {
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        for (int i = 1; i <= 649; ++i) {
            byte[] data = this.pokeNarc.files.get(i);
            Pokemon pkmn = this.pokes[i];
            boolean[] flags = new boolean[102];
            for (int j = 0; j < 13; ++j) {
                this.readByteIntoFlags(data, flags, j * 8 + 1, 40 + j);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setTMHMCompatibility(Map<Pokemon, boolean[]> compatData) {
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            byte[] data = this.pokeNarc.files.get(pkmn.number);
            for (int j = 0; j < 13; ++j) {
                data[40 + j] = this.getByteFromFlags(flags, j * 8 + 1);
            }
        }
    }

    @Override
    public boolean hasMoveTutors() {
        return this.romEntry.romType == 1;
    }

    @Override
    public List<Integer> getMoveTutorMoves() {
        if (!this.hasMoveTutors()) {
            return new ArrayList<Integer>();
        }
        int baseOffset = this.romEntry.getInt("MoveTutorDataOffset");
        int amount = 60;
        int bytesPer = 12;
        ArrayList<Integer> mtMoves = new ArrayList<Integer>();
        try {
            byte[] mtFile = this.readOverlay(this.romEntry.getInt("MoveTutorOvlNumber"));
            for (int i = 0; i < amount; ++i) {
                mtMoves.add(this.readWord(mtFile, baseOffset + i * bytesPer));
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return mtMoves;
    }

    @Override
    public void setMoveTutorMoves(List<Integer> moves) {
        if (!this.hasMoveTutors()) {
            return;
        }
        int baseOffset = this.romEntry.getInt("MoveTutorDataOffset");
        int amount = 60;
        int bytesPer = 12;
        if (moves.size() != amount) {
            return;
        }
        try {
            byte[] mtFile = this.readOverlay(this.romEntry.getInt("MoveTutorOvlNumber"));
            for (int i = 0; i < amount; ++i) {
                this.writeWord(mtFile, baseOffset + i * bytesPer, moves.get(i));
            }
            this.writeOverlay(this.romEntry.getInt("MoveTutorOvlNumber"), mtFile);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public Map<Pokemon, boolean[]> getMoveTutorCompatibility() {
        if (!this.hasMoveTutors()) {
            return new TreeMap<Pokemon, boolean[]>();
        }
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        int[] countsPersonalOrder = new int[]{15, 17, 13, 15};
        int[] countsMoveOrder = new int[]{13, 15, 15, 17};
        int[] personalToMoveOrder = new int[]{1, 3, 0, 2};
        for (int i = 1; i <= 649; ++i) {
            byte[] data = this.pokeNarc.files.get(i);
            Pokemon pkmn = this.pokes[i];
            boolean[] flags = new boolean[61];
            for (int mt = 0; mt < 4; ++mt) {
                boolean[] mtflags = new boolean[countsPersonalOrder[mt] + 1];
                for (int j = 0; j < 4; ++j) {
                    this.readByteIntoFlags(data, mtflags, j * 8 + 1, 60 + mt * 4 + j);
                }
                int offsetOfThisData = 0;
                for (int cmoIndex = 0; cmoIndex < personalToMoveOrder[mt]; ++cmoIndex) {
                    offsetOfThisData += countsMoveOrder[cmoIndex];
                }
                System.arraycopy(mtflags, 1, flags, offsetOfThisData + 1, countsPersonalOrder[mt]);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setMoveTutorCompatibility(Map<Pokemon, boolean[]> compatData) {
        if (!this.hasMoveTutors()) {
            return;
        }
        int[] countsPersonalOrder = new int[]{15, 17, 13, 15};
        int[] countsMoveOrder = new int[]{13, 15, 15, 17};
        int[] personalToMoveOrder = new int[]{1, 3, 0, 2};
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            byte[] data = this.pokeNarc.files.get(pkmn.number);
            for (int mt = 0; mt < 4; ++mt) {
                int offsetOfThisData = 0;
                for (int cmoIndex = 0; cmoIndex < personalToMoveOrder[mt]; ++cmoIndex) {
                    offsetOfThisData += countsMoveOrder[cmoIndex];
                }
                boolean[] mtflags = new boolean[countsPersonalOrder[mt] + 1];
                System.arraycopy(flags, offsetOfThisData + 1, mtflags, 1, countsPersonalOrder[mt]);
                for (int j = 0; j < 4; ++j) {
                    data[60 + mt * 4 + j] = this.getByteFromFlags(mtflags, j * 8 + 1);
                }
            }
        }
    }

    private int find(byte[] data, String hexString) {
        if (hexString.length() % 2 != 0) {
            return -3;
        }
        byte[] searchFor = new byte[hexString.length() / 2];
        for (int i = 0; i < searchFor.length; ++i) {
            searchFor[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        List<Integer> found = RomFunctions.search(data, searchFor);
        if (found.size() == 0) {
            return -1;
        }
        if (found.size() > 1) {
            return -2;
        }
        return found.get(0);
    }

    private List<String> getStrings(boolean isStoryText, int index) {
        NARCArchive baseNARC = isStoryText ? this.storyTextNarc : this.stringsNarc;
        byte[] rawFile = baseNARC.files.get(index);
        return new ArrayList<String>(PPTxtHandler.readTexts(rawFile));
    }

    private void setStrings(boolean isStoryText, int index, List<String> strings) {
        NARCArchive baseNARC = isStoryText ? this.storyTextNarc : this.stringsNarc;
        byte[] oldRawFile = baseNARC.files.get(index);
        byte[] newRawFile = PPTxtHandler.saveEntry(oldRawFile, strings);
        baseNARC.files.set(index, newRawFile);
    }

    @Override
    public String getROMName() {
        return "Pokemon " + this.romEntry.name;
    }

    @Override
    public String getROMCode() {
        return this.romEntry.romCode;
    }

    @Override
    public String getSupportLevel() {
        return this.romEntry.staticPokemonSupport ? "Complete" : "No Static Pokemon";
    }

    @Override
    public boolean hasTimeBasedEncounters() {
        return true;
    }

    private void populateEvolutions() {
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            pkmn.evolutionsFrom.clear();
            pkmn.evolutionsTo.clear();
        }
        try {
            NARCArchive evoNARC = this.readNARC(this.romEntry.getString("PokemonEvolutions"));
            for (int i = 1; i <= 649; ++i) {
                Pokemon pk = this.pokes[i];
                byte[] evoEntry = evoNARC.files.get(i);
                for (int evo = 0; evo < 7; ++evo) {
                    int extraInfo;
                    EvolutionType et;
                    Evolution evol;
                    int method = this.readWord(evoEntry, evo * 6);
                    int species = this.readWord(evoEntry, evo * 6 + 4);
                    if (method < 1 || method > 27 || species < 1 || pk.evolutionsFrom.contains(evol = new Evolution(pk, this.pokes[species], true, et = EvolutionType.fromIndex(5, method), extraInfo = this.readWord(evoEntry, evo * 6 + 2)))) continue;
                    pk.evolutionsFrom.add(evol);
                    this.pokes[species].evolutionsTo.add(evol);
                }
                if (pk.evolutionsFrom.size() <= 1) continue;
                for (Evolution e : pk.evolutionsFrom) {
                    e.carryStats = false;
                }
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void writeEvolutions() {
        try {
            NARCArchive evoNARC = this.readNARC(this.romEntry.getString("PokemonEvolutions"));
            for (int i = 1; i <= 649; ++i) {
                byte[] evoEntry = evoNARC.files.get(i);
                Pokemon pk = this.pokes[i];
                int evosWritten = 0;
                for (Evolution evo : pk.evolutionsFrom) {
                    this.writeWord(evoEntry, evosWritten * 6, evo.type.toIndex(5));
                    this.writeWord(evoEntry, evosWritten * 6 + 2, evo.extraInfo);
                    this.writeWord(evoEntry, evosWritten * 6 + 4, evo.to.number);
                    if (++evosWritten != 7) continue;
                    break;
                }
                while (evosWritten < 7) {
                    this.writeWord(evoEntry, evosWritten * 6, 0);
                    this.writeWord(evoEntry, evosWritten * 6 + 2, 0);
                    this.writeWord(evoEntry, evosWritten * 6 + 4, 0);
                    ++evosWritten;
                }
            }
            this.writeNARC(this.romEntry.getString("PokemonEvolutions"), evoNARC);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public void removeTradeEvolutions(boolean changeMoveEvos) {
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        this.log("--Removing Trade Evolutions--");
        HashSet<Evolution> extraEvolutions = new HashSet<Evolution>();
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            extraEvolutions.clear();
            for (Evolution evo : pkmn.evolutionsFrom) {
                if (changeMoveEvos && evo.type == EvolutionType.LEVEL_WITH_MOVE) {
                    int move = evo.extraInfo;
                    int levelLearntAt = 1;
                    for (MoveLearnt ml : movesets.get(evo.from)) {
                        if (ml.move != move) continue;
                        levelLearntAt = ml.level;
                        break;
                    }
                    if (levelLearntAt == 1) {
                        levelLearntAt = 45;
                    }
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = levelLearntAt;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, levelLearntAt);
                }
                if (evo.type == EvolutionType.TRADE) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 37;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 37);
                }
                if (evo.type == EvolutionType.TRADE_ITEM) {
                    int item = evo.extraInfo;
                    if (evo.from.number == 79) {
                        evo.type = EvolutionType.STONE;
                        evo.extraInfo = 84;
                        this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames.get(84));
                    } else {
                        this.logEvoChangeLevelWithItem(evo.from.name, evo.to.name, this.itemNames.get(item));
                        evo.type = EvolutionType.LEVEL_ITEM_DAY;
                        Evolution extraEntry = new Evolution(evo.from, evo.to, true, EvolutionType.LEVEL_ITEM_NIGHT, item);
                        extraEvolutions.add(extraEntry);
                    }
                }
                if (evo.type != EvolutionType.TRADE_SPECIAL) continue;
                evo.type = EvolutionType.LEVEL_WITH_OTHER;
                evo.extraInfo = evo.from.number == 588 ? 616 : 588;
                this.logEvoChangeLevelWithPkmn(evo.from.name, evo.to.name, this.pokes[evo.from.number == 588 ? 616 : 588].name);
            }
            pkmn.evolutionsFrom.addAll(extraEvolutions);
            for (Evolution ev : extraEvolutions) {
                ev.to.evolutionsTo.add(ev);
            }
        }
        this.logBlankLine();
    }

    @Override
    public boolean canChangeTrainerText() {
        return true;
    }

    @Override
    public List<String> getTrainerNames() {
        List<String> tnames = this.getStrings(false, this.romEntry.getInt("TrainerNamesTextOffset"));
        tnames.remove(0);
        List<String> mnames = this.getStrings(false, this.romEntry.getInt("TrainerMugshotsTextOffset"));
        for (String mname : mnames) {
            if (mname.isEmpty() || mname.charAt(0) < 'A' || mname.charAt(0) > 'Z') continue;
            tnames.add(mname);
        }
        return tnames;
    }

    @Override
    public int maxTrainerNameLength() {
        return 10;
    }

    @Override
    public void setTrainerNames(List<String> trainerNames) {
        List<String> tnames = this.getStrings(false, this.romEntry.getInt("TrainerNamesTextOffset"));
        List<String> mnames = this.getStrings(false, this.romEntry.getInt("TrainerMugshotsTextOffset"));
        int trNamesSize = trainerNames.size();
        for (int i = mnames.size() - 1; i >= 0; --i) {
            String origMName = mnames.get(i);
            if (origMName.isEmpty() || origMName.charAt(0) < 'A' || origMName.charAt(0) > 'Z') continue;
            String replacement = trainerNames.remove(--trNamesSize);
            mnames.set(i, replacement);
        }
        this.setStrings(false, this.romEntry.getInt("TrainerMugshotsTextOffset"), mnames);
        ArrayList<String> newTNames = new ArrayList<String>(trainerNames);
        newTNames.add(0, tnames.get(0));
        this.setStrings(false, this.romEntry.getInt("TrainerNamesTextOffset"), newTNames);
    }

    @Override
    public RomHandler.TrainerNameMode trainerNameMode() {
        return RomHandler.TrainerNameMode.MAX_LENGTH;
    }

    @Override
    public List<Integer> getTCNameLengthsByTrainer() {
        return new ArrayList<Integer>();
    }

    @Override
    public List<String> getTrainerClassNames() {
        return this.getStrings(false, this.romEntry.getInt("TrainerClassesTextOffset"));
    }

    @Override
    public void setTrainerClassNames(List<String> trainerClassNames) {
        this.setStrings(false, this.romEntry.getInt("TrainerClassesTextOffset"), trainerClassNames);
    }

    @Override
    public int maxTrainerClassNameLength() {
        return 12;
    }

    @Override
    public boolean fixedTrainerClassNamesLength() {
        return false;
    }

    @Override
    public List<Integer> getDoublesTrainerClasses() {
        int[] doublesClasses = (int[])this.romEntry.arrayEntries.get("DoublesTrainerClasses");
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        for (int tClass : doublesClasses) {
            doubles.add(tClass);
        }
        return doubles;
    }

    @Override
    public String getDefaultExtension() {
        return "nds";
    }

    @Override
    public int abilitiesPerPokemon() {
        return 3;
    }

    @Override
    public int highestAbilityIndex() {
        return 123;
    }

    @Override
    public int internalStringLength(String string) {
        return ssd.lengthFor(string);
    }

    @Override
    public void applySignature() {
    }

    @Override
    public ItemList getAllowedItems() {
        return this.allowedItems;
    }

    @Override
    public ItemList getNonBadItems() {
        return this.nonBadItems;
    }

    @Override
    public String[] getItemNames() {
        return this.itemNames.toArray(new String[0]);
    }

    @Override
    public String abilityName(int number) {
        return this.abilityNames.get(number);
    }

    private List<Integer> getFieldItems() {
        int offsetInFile;
        int part1;
        int part12;
        ArrayList<Integer> fieldItems = new ArrayList<Integer>();
        int scriptFileNormal = this.romEntry.getInt("ItemBallsScriptOffset");
        int scriptFileHidden = this.romEntry.getInt("HiddenItemsScriptOffset");
        int[] skipTable = (int[])this.romEntry.arrayEntries.get("ItemBallsSkip");
        int[] skipTableH = (int[])this.romEntry.arrayEntries.get("HiddenItemsSkip");
        int setVarNormal = 40;
        int setVarHidden = 42;
        byte[] itemScripts = this.scriptNarc.files.get(scriptFileNormal);
        int offset = 0;
        int skipTableOffset = 0;
        while ((part12 = this.readWord(itemScripts, offset)) != 64787) {
            int offsetInFile2 = this.readRelativePointer(itemScripts, offset);
            offset += 4;
            if (offsetInFile2 > itemScripts.length) break;
            if (skipTableOffset < skipTable.length && skipTable[skipTableOffset] == offset / 4 - 1) {
                ++skipTableOffset;
                continue;
            }
            int command = this.readWord(itemScripts, offsetInFile2 + 2);
            int variable = this.readWord(itemScripts, offsetInFile2 + 4);
            if (command != setVarNormal || variable != 32780) continue;
            int item = this.readWord(itemScripts, offsetInFile2 + 6);
            fieldItems.add(item);
        }
        byte[] hitemScripts = this.scriptNarc.files.get(scriptFileHidden);
        offset = 0;
        skipTableOffset = 0;
        while ((part1 = this.readWord(hitemScripts, offset)) != 64787 && (offsetInFile = this.readRelativePointer(hitemScripts, offset)) <= hitemScripts.length) {
            if (skipTableOffset < skipTable.length && skipTableH[skipTableOffset] == (offset += 4) / 4 - 1) {
                ++skipTableOffset;
                continue;
            }
            int command = this.readWord(hitemScripts, offsetInFile + 2);
            int variable = this.readWord(hitemScripts, offsetInFile + 4);
            if (command != setVarHidden || variable != 32768) continue;
            int item = this.readWord(hitemScripts, offsetInFile + 6);
            fieldItems.add(item);
        }
        return fieldItems;
    }

    private void setFieldItems(List<Integer> fieldItems) {
        int part1;
        int part12;
        Iterator<Integer> iterItems = fieldItems.iterator();
        int scriptFileNormal = this.romEntry.getInt("ItemBallsScriptOffset");
        int scriptFileHidden = this.romEntry.getInt("HiddenItemsScriptOffset");
        int[] skipTable = (int[])this.romEntry.arrayEntries.get("ItemBallsSkip");
        int[] skipTableH = (int[])this.romEntry.arrayEntries.get("HiddenItemsSkip");
        int setVarNormal = 40;
        int setVarHidden = 42;
        byte[] itemScripts = this.scriptNarc.files.get(scriptFileNormal);
        int offset = 0;
        int skipTableOffset = 0;
        while ((part12 = this.readWord(itemScripts, offset)) != 64787) {
            int offsetInFile = this.readRelativePointer(itemScripts, offset);
            offset += 4;
            if (offsetInFile > itemScripts.length) break;
            if (skipTableOffset < skipTable.length && skipTable[skipTableOffset] == offset / 4 - 1) {
                ++skipTableOffset;
                continue;
            }
            int command = this.readWord(itemScripts, offsetInFile + 2);
            int variable = this.readWord(itemScripts, offsetInFile + 4);
            if (command != setVarNormal || variable != 32780) continue;
            int item = iterItems.next();
            this.writeWord(itemScripts, offsetInFile + 6, item);
        }
        byte[] hitemScripts = this.scriptNarc.files.get(scriptFileHidden);
        offset = 0;
        skipTableOffset = 0;
        while ((part1 = this.readWord(hitemScripts, offset)) != 64787) {
            int offsetInFile = this.readRelativePointer(hitemScripts, offset);
            offset += 4;
            if (offsetInFile > hitemScripts.length) break;
            if (skipTableOffset < skipTable.length && skipTableH[skipTableOffset] == offset / 4 - 1) {
                ++skipTableOffset;
                continue;
            }
            int command = this.readWord(hitemScripts, offsetInFile + 2);
            int variable = this.readWord(hitemScripts, offsetInFile + 4);
            if (command != setVarHidden || variable != 32768) continue;
            int item = iterItems.next();
            this.writeWord(hitemScripts, offsetInFile + 6, item);
        }
    }

    private int tmFromIndex(int index) {
        if (index >= 328 && index < 420) {
            return index - 327;
        }
        return index + 92 - 617;
    }

    private int indexFromTM(int tm) {
        if (tm >= 1 && tm <= 92) {
            return tm + 327;
        }
        return tm + 525;
    }

    @Override
    public List<Integer> getCurrentFieldTMs() {
        List<Integer> fieldItems = this.getFieldItems();
        ArrayList<Integer> fieldTMs = new ArrayList<Integer>();
        for (int item : fieldItems) {
            if (!Gen5Constants.allowedItems.isTM(item)) continue;
            fieldTMs.add(this.tmFromIndex(item));
        }
        return fieldTMs;
    }

    @Override
    public void setFieldTMs(List<Integer> fieldTMs) {
        List<Integer> fieldItems = this.getFieldItems();
        int fiLength = fieldItems.size();
        Iterator<Integer> iterTMs = fieldTMs.iterator();
        for (int i = 0; i < fiLength; ++i) {
            int oldItem = fieldItems.get(i);
            if (!Gen5Constants.allowedItems.isTM(oldItem)) continue;
            int newItem = this.indexFromTM(iterTMs.next());
            fieldItems.set(i, newItem);
        }
        this.setFieldItems(fieldItems);
    }

    @Override
    public List<Integer> getRegularFieldItems() {
        List<Integer> fieldItems = this.getFieldItems();
        ArrayList<Integer> fieldRegItems = new ArrayList<Integer>();
        for (int item : fieldItems) {
            if (!Gen5Constants.allowedItems.isAllowed(item) || Gen5Constants.allowedItems.isTM(item)) continue;
            fieldRegItems.add(item);
        }
        return fieldRegItems;
    }

    @Override
    public void setRegularFieldItems(List<Integer> items) {
        List<Integer> fieldItems = this.getFieldItems();
        int fiLength = fieldItems.size();
        Iterator<Integer> iterNewItems = items.iterator();
        for (int i = 0; i < fiLength; ++i) {
            int oldItem = fieldItems.get(i);
            if (Gen5Constants.allowedItems.isTM(oldItem) || !Gen5Constants.allowedItems.isAllowed(oldItem)) continue;
            int newItem = iterNewItems.next();
            fieldItems.set(i, newItem);
        }
        this.setFieldItems(fieldItems);
    }

    @Override
    public List<Integer> getRequiredFieldTMs() {
        if (this.romEntry.romType == 0) {
            return Gen5Constants.bw1RequiredFieldTMs;
        }
        return Gen5Constants.bw2RequiredFieldTMs;
    }

    @Override
    public List<IngameTrade> getIngameTrades() {
        ArrayList<IngameTrade> trades = new ArrayList<IngameTrade>();
        try {
            NARCArchive tradeNARC = this.readNARC(this.romEntry.getString("InGameTrades"));
            List<String> tradeStrings = this.getStrings(false, this.romEntry.getInt("IngameTradesTextOffset"));
            int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
            int unusedOffset = 0;
            int tableSize = tradeNARC.files.size();
            for (int entry = 0; entry < tableSize; ++entry) {
                if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                    ++unusedOffset;
                    continue;
                }
                IngameTrade trade = new IngameTrade();
                byte[] tfile = tradeNARC.files.get(entry);
                trade.nickname = tradeStrings.get(entry * 2);
                trade.givenPokemon = this.pokes[this.readLong(tfile, 4)];
                trade.ivs = new int[6];
                for (int iv = 0; iv < 6; ++iv) {
                    trade.ivs[iv] = this.readLong(tfile, 16 + iv * 4);
                }
                trade.otId = this.readWord(tfile, 52);
                trade.item = this.readLong(tfile, 76);
                trade.otName = tradeStrings.get(entry * 2 + 1);
                trade.requestedPokemon = this.pokes[this.readLong(tfile, 92)];
                trades.add(trade);
            }
        }
        catch (Exception ex) {
            throw new RandomizerIOException(ex);
        }
        return trades;
    }

    @Override
    public void setIngameTrades(List<IngameTrade> trades) {
        int tradeOffset = 0;
        try {
            NARCArchive tradeNARC = this.readNARC(this.romEntry.getString("InGameTrades"));
            List<String> tradeStrings = this.getStrings(false, this.romEntry.getInt("IngameTradesTextOffset"));
            int tradeCount = tradeNARC.files.size();
            int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
            int unusedOffset = 0;
            for (int i = 0; i < tradeCount; ++i) {
                if (unusedOffset < unused.length && unused[unusedOffset] == i) {
                    ++unusedOffset;
                    continue;
                }
                byte[] tfile = tradeNARC.files.get(i);
                IngameTrade trade = trades.get(tradeOffset++);
                tradeStrings.set(i * 2, trade.nickname);
                tradeStrings.set(i * 2 + 1, trade.otName);
                this.writeLong(tfile, 4, trade.givenPokemon.number);
                this.writeLong(tfile, 8, 0);
                for (int iv = 0; iv < 6; ++iv) {
                    this.writeLong(tfile, 16 + iv * 4, trade.ivs[iv]);
                }
                this.writeLong(tfile, 44, 255);
                this.writeWord(tfile, 52, trade.otId);
                this.writeLong(tfile, 76, trade.item);
                this.writeLong(tfile, 92, trade.requestedPokemon.number);
            }
            this.writeNARC(this.romEntry.getString("InGameTrades"), tradeNARC);
            this.setStrings(false, this.romEntry.getInt("IngameTradesTextOffset"), tradeStrings);
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
    }

    @Override
    public boolean hasDVs() {
        return false;
    }

    @Override
    public int generationOfPokemon() {
        return 5;
    }

    @Override
    public void removeEvosForPokemonPool() {
        List pokemonIncluded = this.mainPokemonList;
        HashSet<Evolution> keepEvos = new HashSet<Evolution>();
        for (Pokemon pk : this.pokes) {
            if (pk == null) continue;
            keepEvos.clear();
            for (Evolution evol : pk.evolutionsFrom) {
                if (pokemonIncluded.contains(evol.from) && pokemonIncluded.contains(evol.to)) {
                    keepEvos.add(evol);
                    continue;
                }
                evol.to.evolutionsTo.remove(evol);
            }
            pk.evolutionsFrom.retainAll(keepEvos);
        }
        try {
            NARCArchive babyNARC = this.readNARC(this.romEntry.getString("BabyPokemon"));
            for (int i = 1; i <= 649; ++i) {
                Pokemon baby = this.pokes[i];
                while (baby.evolutionsTo.size() > 0) {
                    baby = baby.evolutionsTo.get((int)0).from;
                }
                this.writeWord(babyNARC.files.get(i), 0, baby.number);
            }
            this.writeNARC(this.romEntry.getString("BabyPokemon"), babyNARC);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public boolean supportsFourStartingMoves() {
        return true;
    }

    @Override
    public List<Integer> getFieldMoves() {
        return Gen5Constants.fieldMoves;
    }

    @Override
    public List<Integer> getEarlyRequiredHMMoves() {
        if (this.romEntry.romType == 1) {
            return Gen5Constants.bw2EarlyRequiredHMMoves;
        }
        return Gen5Constants.bw1EarlyRequiredHMMoves;
    }

    @Override
    public BufferedImage getMascotImage() {
        try {
            Pokemon pk = this.randomPokemon();
            NARCArchive pokespritesNARC = this.readNARC(this.romEntry.getString("PokemonGraphics"));
            byte[] rawPalette = pokespritesNARC.files.get(pk.number * 20 + 18);
            int[] palette = new int[16];
            for (int i = 1; i < 16; ++i) {
                palette[i] = GFXFunctions.conv16BitColorToARGB(this.readWord(rawPalette, 40 + i * 2));
            }
            byte[] compressedPic = pokespritesNARC.files.get(pk.number * 20);
            byte[] uncompressedPic = DSDecmp.Decompress(compressedPic);
            BufferedImage bim = GFXFunctions.drawTiledImage(uncompressedPic, palette, 48, 64, 144, 4);
            BufferedImage finalImage = new BufferedImage(96, 96, 2);
            Graphics g = finalImage.getGraphics();
            g.drawImage(bim, 0, 0, 64, 64, 0, 0, 64, 64, null);
            g.drawImage(bim, 64, 0, 96, 8, 0, 64, 32, 72, null);
            g.drawImage(bim, 64, 8, 96, 16, 32, 64, 64, 72, null);
            g.drawImage(bim, 64, 16, 96, 24, 0, 72, 32, 80, null);
            g.drawImage(bim, 64, 24, 96, 32, 32, 72, 64, 80, null);
            g.drawImage(bim, 64, 32, 96, 40, 0, 80, 32, 88, null);
            g.drawImage(bim, 64, 40, 96, 48, 32, 80, 64, 88, null);
            g.drawImage(bim, 64, 48, 96, 56, 0, 88, 32, 96, null);
            g.drawImage(bim, 64, 56, 96, 64, 32, 88, 64, 96, null);
            g.drawImage(bim, 0, 64, 64, 96, 0, 96, 64, 128, null);
            g.drawImage(bim, 64, 64, 96, 72, 0, 128, 32, 136, null);
            g.drawImage(bim, 64, 72, 96, 80, 32, 128, 64, 136, null);
            g.drawImage(bim, 64, 80, 96, 88, 0, 136, 32, 144, null);
            g.drawImage(bim, 64, 88, 96, 96, 32, 136, 64, 144, null);
            return finalImage;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    static {
        Gen5RomHandler.loadROMInfo();
        ssd = new RomFunctions.StringSizeDeterminer(){

            @Override
            public int lengthFor(String encodedText) {
                int offs = 0;
                int len = encodedText.length();
                while (encodedText.indexOf("\\x", offs) != -1) {
                    len -= 5;
                    offs = encodedText.indexOf("\\x", offs) + 1;
                }
                return len;
            }
        };
    }

    private static class StaticPokemon {
        private int[] files;
        private int[] offsets;

        private StaticPokemon() {
        }

        public Pokemon getPokemon(Gen5RomHandler parent, NARCArchive scriptNARC) {
            return parent.pokes[parent.readWord(scriptNARC.files.get(this.files[0]), this.offsets[0])];
        }

        public void setPokemon(Gen5RomHandler parent, NARCArchive scriptNARC, Pokemon pkmn) {
            int value = pkmn.number;
            for (int i = 0; i < this.offsets.length; ++i) {
                byte[] file = scriptNARC.files.get(this.files[i]);
                parent.writeWord(file, this.offsets[i], value);
            }
        }

        static /* synthetic */ int[] access$1302(StaticPokemon x0, int[] x1) {
            x0.files = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1402(StaticPokemon x0, int[] x1) {
            x0.offsets = x1;
            return x1;
        }
    }

    private static class RomEntry {
        private String name;
        private String romCode;
        private int romType;
        private boolean staticPokemonSupport = false;
        private boolean copyStaticPokemon = false;
        private Map<String, String> strings = new HashMap<String, String>();
        private Map<String, Integer> numbers = new HashMap<String, Integer>();
        private Map<String, String> tweakFiles = new HashMap<String, String>();
        private Map<String, int[]> arrayEntries = new HashMap<String, int[]>();
        private Map<String, OffsetWithinEntry[]> offsetArrayEntries = new HashMap<String, OffsetWithinEntry[]>();
        private List<StaticPokemon> staticPokemon = new ArrayList<StaticPokemon>();

        private RomEntry() {
        }

        private int getInt(String key) {
            if (!this.numbers.containsKey(key)) {
                this.numbers.put(key, 0);
            }
            return this.numbers.get(key);
        }

        private String getString(String key) {
            if (!this.strings.containsKey(key)) {
                this.strings.put(key, "");
            }
            return this.strings.get(key);
        }
    }

    private static class OffsetWithinEntry {
        private int entry;
        private int offset;

        private OffsetWithinEntry() {
        }
    }

    public static class Factory
    extends RomHandler.Factory {
        @Override
        public Gen5RomHandler create(Random random, PrintStream logStream) {
            return new Gen5RomHandler(random, logStream);
        }

        @Override
        public boolean isLoadable(String filename) {
            return Gen5RomHandler.detectNDSRomInner(AbstractDSRomHandler.getROMCodeFromFile(filename));
        }
    }
}

