/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.GFXFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RomFunctions;
import com.dabomstew.pkrandom.constants.Gen4Constants;
import com.dabomstew.pkrandom.constants.GlobalConstants;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.newnds.NARCArchive;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.EvolutionType;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.romhandlers.AbstractDSRomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import thenewpoketext.PokeTextData;
import thenewpoketext.TextToPoke;

public class Gen4RomHandler
extends AbstractDSRomHandler {
    private static List<RomEntry> roms;
    private Pokemon[] pokes;
    private List<Pokemon> pokemonList;
    private Move[] moves;
    private NARCArchive pokeNarc;
    private NARCArchive moveNarc;
    private NARCArchive msgNarc;
    private NARCArchive scriptNarc;
    private NARCArchive eventNarc;
    private byte[] arm9;
    private List<String> abilityNames;
    private List<String> itemNames;
    private boolean loadedWildMapNames;
    private Map<Integer, String> wildMapNames;
    private ItemList allowedItems;
    private ItemList nonBadItems;
    private RomEntry romEntry;
    private static RomFunctions.StringSizeDeterminer ssd;
    private boolean lastStringsCompressed = false;

    public Gen4RomHandler(Random random) {
        super(random, null);
    }

    public Gen4RomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    private static void loadROMInfo() {
        roms = new ArrayList<RomEntry>();
        RomEntry current = null;
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig("gen4_offsets.ini"), "UTF-8");
            while (sc.hasNextLine()) {
                String q = sc.nextLine().trim();
                if (q.contains("//")) {
                    q = q.substring(0, q.indexOf("//")).trim();
                }
                if (q.isEmpty()) continue;
                if (q.startsWith("[") && q.endsWith("]")) {
                    current = new RomEntry();
                    current.name = q.substring(1, q.length() - 1);
                    roms.add(current);
                    continue;
                }
                String[] r = q.split("=", 2);
                if (r.length == 1) {
                    System.err.println("invalid entry " + q);
                    continue;
                }
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                r[1] = r[1].trim();
                if (r[0].equals("Game")) {
                    current.romCode = r[1];
                    continue;
                }
                if (r[0].equals("Type")) {
                    if (r[1].equalsIgnoreCase("DP")) {
                        current.romType = 0;
                        continue;
                    }
                    if (r[1].equalsIgnoreCase("Plat")) {
                        current.romType = 1;
                        continue;
                    }
                    if (r[1].equalsIgnoreCase("HGSS")) {
                        current.romType = 2;
                        continue;
                    }
                    System.err.println("unrecognised rom type: " + r[1]);
                    continue;
                }
                if (r[0].equals("CopyFrom")) {
                    for (RomEntry otherEntry : roms) {
                        if (!r[1].equalsIgnoreCase(otherEntry.romCode)) continue;
                        current.arrayEntries.putAll(otherEntry.arrayEntries);
                        current.numbers.putAll(otherEntry.numbers);
                        current.strings.putAll(otherEntry.strings);
                        if (current.copyStaticPokemon) {
                            current.staticPokemon.addAll(otherEntry.staticPokemon);
                            current.staticPokemonSupport = true;
                            continue;
                        }
                        current.staticPokemonSupport = false;
                    }
                    continue;
                }
                if (r[0].equals("StaticPokemon[]")) {
                    if (r[1].startsWith("[") && r[1].endsWith("]")) {
                        String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                        int[] offs = new int[offsets.length];
                        int[] files = new int[offsets.length];
                        int c = 0;
                        String[] stringArray = offsets;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String off = stringArray[i];
                            String[] parts = off.split("\\:");
                            files[c] = Gen4RomHandler.parseRIInt(parts[0]);
                            offs[c++] = Gen4RomHandler.parseRIInt(parts[1]);
                        }
                        StaticPokemon sp = new StaticPokemon();
                        StaticPokemon.access$1202(sp, files);
                        StaticPokemon.access$1302(sp, offs);
                        current.staticPokemon.add(sp);
                        continue;
                    }
                    String[] parts = r[1].split("\\:");
                    int files = Gen4RomHandler.parseRIInt(parts[0]);
                    int offs = Gen4RomHandler.parseRIInt(parts[1]);
                    StaticPokemon sp = new StaticPokemon();
                    StaticPokemon.access$1202(sp, new int[]{files});
                    StaticPokemon.access$1302(sp, new int[]{offs});
                    continue;
                }
                if (r[0].equals("StaticPokemonSupport")) {
                    int spsupport = Gen4RomHandler.parseRIInt(r[1]);
                    current.staticPokemonSupport = spsupport > 0;
                    continue;
                }
                if (r[0].equals("CopyStaticPokemon")) {
                    int csp = Gen4RomHandler.parseRIInt(r[1]);
                    current.copyStaticPokemon = csp > 0;
                    continue;
                }
                if (r[0].endsWith("Tweak")) {
                    current.tweakFiles.put(r[0], r[1]);
                    continue;
                }
                if (r[1].startsWith("[") && r[1].endsWith("]")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    if (offsets.length == 1 && offsets[0].trim().isEmpty()) {
                        current.arrayEntries.put(r[0], new int[0]);
                        continue;
                    }
                    int[] offs = new int[offsets.length];
                    int c = 0;
                    for (String off : offsets) {
                        offs[c++] = Gen4RomHandler.parseRIInt(off);
                    }
                    current.arrayEntries.put(r[0], offs);
                    continue;
                }
                if (r[0].endsWith("Offset") || r[0].endsWith("Count") || r[0].endsWith("Number") || r[0].endsWith("Size")) {
                    int offs = Gen4RomHandler.parseRIInt(r[1]);
                    current.numbers.put(r[0], offs);
                    continue;
                }
                current.strings.put(r[0], r[1]);
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static int parseRIInt(String off) {
        int radix = 10;
        if ((off = off.trim().toLowerCase()).startsWith("0x") || off.startsWith("&h")) {
            radix = 16;
            off = off.substring(2);
        }
        try {
            return Integer.parseInt(off, radix);
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid base " + radix + "number " + off);
            return 0;
        }
    }

    @Override
    protected boolean detectNDSRom(String ndsCode) {
        return Gen4RomHandler.detectNDSRomInner(ndsCode);
    }

    private static boolean detectNDSRomInner(String ndsCode) {
        return Gen4RomHandler.entryFor(ndsCode) != null;
    }

    private static RomEntry entryFor(String ndsCode) {
        for (RomEntry re : roms) {
            if (!ndsCode.equals(re.romCode)) continue;
            return re;
        }
        return null;
    }

    @Override
    protected void loadedROM(String romCode) {
        this.romEntry = Gen4RomHandler.entryFor(romCode);
        try {
            this.arm9 = this.readARM9();
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.msgNarc = this.readNARC(this.romEntry.getString("Text"));
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.scriptNarc = this.readNARC(this.romEntry.getString("Scripts"));
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.eventNarc = this.readNARC(this.romEntry.getString("Events"));
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        this.loadPokemonStats();
        this.pokemonList = Arrays.asList(this.pokes);
        this.loadMoves();
        this.abilityNames = this.getStrings(this.romEntry.getInt("AbilityNamesTextOffset"));
        this.itemNames = this.getStrings(this.romEntry.getInt("ItemNamesTextOffset"));
        this.loadedWildMapNames = false;
        this.allowedItems = Gen4Constants.allowedItems.copy();
        this.nonBadItems = Gen4Constants.nonBadItems.copy();
    }

    private void loadMoves() {
        try {
            this.moveNarc = this.readNARC(this.romEntry.getString("MoveData"));
            this.moves = new Move[468];
            List<String> moveNames = this.getStrings(this.romEntry.getInt("MoveNamesTextOffset"));
            for (int i = 1; i <= 467; ++i) {
                byte[] moveData = this.moveNarc.files.get(i);
                this.moves[i] = new Move();
                this.moves[i].name = moveNames.get(i);
                this.moves[i].number = i;
                this.moves[i].internalId = i;
                this.moves[i].effectIndex = this.readWord(moveData, 0);
                this.moves[i].hitratio = moveData[5] & 0xFF;
                this.moves[i].power = moveData[3] & 0xFF;
                this.moves[i].pp = moveData[6] & 0xFF;
                this.moves[i].type = Gen4Constants.typeTable[moveData[4] & 0xFF];
                this.moves[i].category = Gen4Constants.moveCategoryIndices[moveData[2] & 0xFF];
                if (GlobalConstants.normalMultihitMoves.contains(i)) {
                    this.moves[i].hitCount = 3.0;
                    continue;
                }
                if (GlobalConstants.doubleHitMoves.contains(i)) {
                    this.moves[i].hitCount = 2.0;
                    continue;
                }
                if (i != 167) continue;
                this.moves[i].hitCount = 2.71;
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void loadPokemonStats() {
        try {
            String pstatsnarc = this.romEntry.getString("PokemonStats");
            this.pokeNarc = this.readNARC(pstatsnarc);
            String[] pokeNames = this.readPokemonNames();
            this.pokes = new Pokemon[494];
            for (int i = 1; i <= 493; ++i) {
                this.pokes[i] = new Pokemon();
                this.pokes[i].number = i;
                this.loadBasicPokeStats(this.pokes[i], this.pokeNarc.files.get(i));
                this.pokes[i].name = pokeNames[i];
            }
            this.populateEvolutions();
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void loadBasicPokeStats(Pokemon pkmn, byte[] stats) {
        int item2;
        pkmn.hp = stats[0] & 0xFF;
        pkmn.attack = stats[1] & 0xFF;
        pkmn.defense = stats[2] & 0xFF;
        pkmn.speed = stats[3] & 0xFF;
        pkmn.spatk = stats[4] & 0xFF;
        pkmn.spdef = stats[5] & 0xFF;
        pkmn.primaryType = Gen4Constants.typeTable[stats[6] & 0xFF];
        pkmn.secondaryType = Gen4Constants.typeTable[stats[7] & 0xFF];
        if (pkmn.secondaryType == pkmn.primaryType) {
            pkmn.secondaryType = null;
        }
        pkmn.catchRate = stats[8] & 0xFF;
        pkmn.growthCurve = ExpCurve.fromByte(stats[19]);
        pkmn.ability1 = stats[22] & 0xFF;
        pkmn.ability2 = stats[23] & 0xFF;
        int item1 = this.readWord(stats, 12);
        if (item1 == (item2 = this.readWord(stats, 14))) {
            pkmn.guaranteedHeldItem = item1;
            pkmn.commonHeldItem = 0;
            pkmn.rareHeldItem = 0;
        } else {
            pkmn.guaranteedHeldItem = 0;
            pkmn.commonHeldItem = item1;
            pkmn.rareHeldItem = item2;
        }
        pkmn.darkGrassHeldItem = -1;
    }

    private String[] readPokemonNames() {
        String[] pokeNames = new String[494];
        List<String> nameList = this.getStrings(this.romEntry.getInt("PokemonNamesTextOffset"));
        for (int i = 1; i <= 493; ++i) {
            pokeNames[i] = nameList.get(i);
        }
        return pokeNames;
    }

    @Override
    protected void savingROM() {
        this.savePokemonStats();
        this.saveMoves();
        try {
            this.writeARM9(this.arm9);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.writeNARC(this.romEntry.getString("Text"), this.msgNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.writeNARC(this.romEntry.getString("Scripts"), this.scriptNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        try {
            this.writeNARC(this.romEntry.getString("Events"), this.eventNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void saveMoves() {
        for (int i = 1; i <= 467; ++i) {
            byte[] data = this.moveNarc.files.get(i);
            this.writeWord(data, 0, this.moves[i].effectIndex);
            data[3] = (byte)this.moves[i].power;
            data[4] = Gen4Constants.typeToByte(this.moves[i].type);
            int hitratio = (int)Math.round(this.moves[i].hitratio);
            if (hitratio < 0) {
                hitratio = 0;
            }
            if (hitratio > 100) {
                hitratio = 100;
            }
            data[5] = (byte)hitratio;
            data[6] = (byte)this.moves[i].pp;
        }
        try {
            this.writeNARC(this.romEntry.getString("MoveData"), this.moveNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void savePokemonStats() {
        List<String> namesList = this.getStrings(this.romEntry.getInt("PokemonNamesTextOffset"));
        if (this.romEntry.getString("HasExtraPokemonNames").equalsIgnoreCase("Yes")) {
            List<String> namesList2 = this.getStrings(this.romEntry.getInt("PokemonNamesTextOffset") + 1);
            for (int i = 1; i <= 493; ++i) {
                this.saveBasicPokeStats(this.pokes[i], this.pokeNarc.files.get(i));
                String oldName = namesList.get(i);
                namesList.set(i, this.pokes[i].name);
                namesList2.set(i, namesList2.get(i).replace(oldName, this.pokes[i].name));
            }
            this.setStrings(this.romEntry.getInt("PokemonNamesTextOffset") + 1, namesList2, false);
        } else {
            for (int i = 1; i <= 493; ++i) {
                this.saveBasicPokeStats(this.pokes[i], this.pokeNarc.files.get(i));
                namesList.set(i, this.pokes[i].name);
            }
        }
        this.setStrings(this.romEntry.getInt("PokemonNamesTextOffset"), namesList, false);
        try {
            String pstatsnarc = this.romEntry.getString("PokemonStats");
            this.writeNARC(pstatsnarc, this.pokeNarc);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        this.writeEvolutions();
    }

    private void saveBasicPokeStats(Pokemon pkmn, byte[] stats) {
        stats[0] = (byte)pkmn.hp;
        stats[1] = (byte)pkmn.attack;
        stats[2] = (byte)pkmn.defense;
        stats[3] = (byte)pkmn.speed;
        stats[4] = (byte)pkmn.spatk;
        stats[5] = (byte)pkmn.spdef;
        stats[6] = Gen4Constants.typeToByte(pkmn.primaryType);
        stats[7] = pkmn.secondaryType == null ? stats[6] : Gen4Constants.typeToByte(pkmn.secondaryType);
        stats[8] = (byte)pkmn.catchRate;
        stats[19] = pkmn.growthCurve.toByte();
        stats[22] = (byte)pkmn.ability1;
        stats[23] = (byte)pkmn.ability2;
        if (pkmn.guaranteedHeldItem > 0) {
            this.writeWord(stats, 12, pkmn.guaranteedHeldItem);
            this.writeWord(stats, 14, pkmn.guaranteedHeldItem);
        } else {
            this.writeWord(stats, 12, pkmn.commonHeldItem);
            this.writeWord(stats, 14, pkmn.rareHeldItem);
        }
    }

    @Override
    public List<Pokemon> getPokemon() {
        return this.pokemonList;
    }

    @Override
    public List<Pokemon> getStarters() {
        if (this.romEntry.romType == 2) {
            List<Integer> tailOffsets = RomFunctions.search(this.arm9, Gen4Constants.hgssStarterCodeSuffix);
            if (tailOffsets.size() == 1) {
                int starterOffset = tailOffsets.get(0) - 13;
                int poke1 = this.readWord(this.arm9, starterOffset);
                int poke2 = this.readWord(this.arm9, starterOffset + 4);
                int poke3 = this.readWord(this.arm9, starterOffset + 8);
                return Arrays.asList(this.pokes[poke1], this.pokes[poke2], this.pokes[poke3]);
            }
            return Arrays.asList(this.pokes[152], this.pokes[155], this.pokes[158]);
        }
        try {
            byte[] starterData = this.readOverlay(this.romEntry.getInt("StarterPokemonOvlNumber"));
            int poke1 = this.readWord(starterData, this.romEntry.getInt("StarterPokemonOffset"));
            int poke2 = this.readWord(starterData, this.romEntry.getInt("StarterPokemonOffset") + 4);
            int poke3 = this.readWord(starterData, this.romEntry.getInt("StarterPokemonOffset") + 8);
            return Arrays.asList(this.pokes[poke1], this.pokes[poke2], this.pokes[poke3]);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public boolean setStarters(List<Pokemon> newStarters) {
        if (newStarters.size() != 3) {
            return false;
        }
        if (this.romEntry.romType == 2) {
            List<Integer> tailOffsets = RomFunctions.search(this.arm9, Gen4Constants.hgssStarterCodeSuffix);
            if (tailOffsets.size() == 1) {
                int starterOffset = tailOffsets.get(0) - 13;
                this.writeWord(this.arm9, starterOffset, newStarters.get((int)0).number);
                this.writeWord(this.arm9, starterOffset + 4, newStarters.get((int)1).number);
                this.writeWord(this.arm9, starterOffset + 8, newStarters.get((int)2).number);
                int[] filesWithRivalScript = Gen4Constants.hgssFilesWithRivalScript;
                byte[] magic = Gen4Constants.hgssRivalScriptMagic;
                NARCArchive scriptNARC = this.scriptNarc;
                for (int i = 0; i < filesWithRivalScript.length; ++i) {
                    int fileCheck = filesWithRivalScript[i];
                    byte[] file = scriptNARC.files.get(fileCheck);
                    List<Integer> rivalOffsets = RomFunctions.search(file, magic);
                    if (rivalOffsets.size() != 1) continue;
                    int baseOffset = rivalOffsets.get(0);
                    this.writeWord(file, baseOffset + 8, newStarters.get((int)0).number);
                    int jumpAmount = this.readLong(file, baseOffset + 13);
                    int secondBase = jumpAmount + baseOffset + 17;
                    if (file[secondBase] != 17 || (file[secondBase + 4] & 0xFF) != 155) continue;
                    this.writeWord(file, secondBase + 4, newStarters.get((int)1).number);
                }
                List<String> spStrings = this.getStrings(this.romEntry.getInt("StarterScreenTextOffset"));
                String[] intros = new String[]{"So, you like", "You\u2019ll take", "Do you want"};
                for (int i = 0; i < 3; ++i) {
                    Pokemon newStarter = newStarters.get(i);
                    int color = i == 0 ? 3 : i;
                    String newStarterDesc = "Professor Elm: " + intros[i] + " \\vFF00\\z000" + color + newStarter.name + "\\vFF00\\z0000,\\nthe " + newStarter.primaryType.camelCase() + "-type Pok\u00e9mon?";
                    spStrings.set(i + 1, newStarterDesc);
                    String altStarterDesc = "\\vFF00\\z000" + color + newStarter.name + "\\vFF00\\z0000, the " + newStarter.primaryType.camelCase() + "-type Pok\u00e9mon, is\\nin this Pok\u00e9 Ball!";
                    spStrings.set(i + 4, altStarterDesc);
                }
                this.setStrings(this.romEntry.getInt("StarterScreenTextOffset"), spStrings);
                return true;
            }
            return false;
        }
        try {
            byte[] starterData = this.readOverlay(this.romEntry.getInt("StarterPokemonOvlNumber"));
            this.writeWord(starterData, this.romEntry.getInt("StarterPokemonOffset"), newStarters.get((int)0).number);
            this.writeWord(starterData, this.romEntry.getInt("StarterPokemonOffset") + 4, newStarters.get((int)1).number);
            this.writeWord(starterData, this.romEntry.getInt("StarterPokemonOffset") + 8, newStarters.get((int)2).number);
            this.writeOverlay(this.romEntry.getInt("StarterPokemonOvlNumber"), starterData);
            int[] filesWithRivalScript = this.romEntry.romType == 1 ? Gen4Constants.ptFilesWithRivalScript : Gen4Constants.dpFilesWithRivalScript;
            byte[] magic = Gen4Constants.dpptRivalScriptMagic;
            NARCArchive scriptNARC = this.scriptNarc;
            for (int i = 0; i < filesWithRivalScript.length; ++i) {
                int fileCheck = filesWithRivalScript[i];
                byte[] file = scriptNARC.files.get(fileCheck);
                List<Integer> rivalOffsets = RomFunctions.search(file, magic);
                if (rivalOffsets.size() <= 0) continue;
                for (int baseOffset : rivalOffsets) {
                    int jumpLoc = baseOffset + magic.length;
                    int jumpTo = this.readLong(file, jumpLoc) + jumpLoc + 4;
                    if (this.readWord(file, jumpTo) != 229 && this.readWord(file, jumpTo) != 655 && (this.readWord(file, jumpTo) != 293 || this.romEntry.romType != 1)) continue;
                    this.writeWord(file, baseOffset + 8, newStarters.get((int)0).number);
                    this.writeWord(file, baseOffset + 21, newStarters.get((int)1).number);
                }
            }
            byte[] tagBattleMagic = Gen4Constants.dpptTagBattleScriptMagic1;
            byte[] tagBattleMagic2 = Gen4Constants.dpptTagBattleScriptMagic2;
            int[] filesWithTagBattleScript = this.romEntry.romType == 1 ? Gen4Constants.ptFilesWithTagScript : Gen4Constants.dpFilesWithTagScript;
            for (int i = 0; i < filesWithTagBattleScript.length; ++i) {
                int fileCheck = filesWithTagBattleScript[i];
                byte[] file = scriptNARC.files.get(fileCheck);
                List<Integer> tbOffsets = RomFunctions.search(file, tagBattleMagic);
                if (tbOffsets.size() <= 0) continue;
                for (int baseOffset : tbOffsets) {
                    int jumpLoc;
                    int jumpTo;
                    int secondPartStart = baseOffset + tagBattleMagic.length + 2;
                    if (secondPartStart + tagBattleMagic2.length > file.length) continue;
                    boolean valid = true;
                    for (int spo = 0; spo < tagBattleMagic2.length; ++spo) {
                        if (file[secondPartStart + spo] == tagBattleMagic2[spo]) continue;
                        valid = false;
                        break;
                    }
                    if (!valid || this.readWord(file, jumpTo = this.readLong(file, jumpLoc = secondPartStart + tagBattleMagic2.length) + jumpLoc + 4) != 27) continue;
                    if (this.readWord(file, baseOffset + 33) == 387) {
                        this.writeWord(file, baseOffset + 33, newStarters.get((int)0).number);
                    } else {
                        this.writeWord(file, baseOffset + 33, newStarters.get((int)2).number);
                    }
                    this.writeWord(file, baseOffset + 14, newStarters.get((int)1).number);
                }
            }
            List<String> spStrings = this.getStrings(this.romEntry.getInt("StarterScreenTextOffset"));
            List<String> pokedexSpeciesStrings = this.getStrings(this.romEntry.getInt("PokedexSpeciesTextOffset"));
            for (int i = 0; i < 3; ++i) {
                Pokemon newStarter = newStarters.get(i);
                int color = i == 0 ? 3 : i;
                String newStarterDesc = "\\vFF00\\z000" + color + pokedexSpeciesStrings.get(newStarter.number) + " " + newStarter.name + "\\vFF00\\z0000!\\nWill you take this Pok\u00e9mon?";
                spStrings.set(i + 1, newStarterDesc);
            }
            this.setStrings(this.romEntry.getInt("StarterScreenTextOffset"), spStrings);
            if (this.romEntry.romType == 0) {
                List<String> lakeStrings = this.getStrings(this.romEntry.getInt("StarterLocationTextOffset"));
                lakeStrings.set(19, "\\v0103\\z0000: Fwaaah!\\nYour Pok\u00e9mon totally rocked!\\pBut mine was way tougher\\nthan yours!\\p...They were other people\u2019s\\nPok\u00e9mon, though...\\pBut we had to use them...\\nThey won\u2019t mind, will they?\\p");
                this.setStrings(this.romEntry.getInt("StarterLocationTextOffset"), lakeStrings);
            } else {
                List<String> r201Strings = this.getStrings(this.romEntry.getInt("StarterLocationTextOffset"));
                r201Strings.set(36, "\\v0103\\z0000\\z0000: Then, I choose you!\\nI\u2019m picking this one!\\p");
                this.setStrings(this.romEntry.getInt("StarterLocationTextOffset"), r201Strings);
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return true;
    }

    @Override
    public List<Integer> getStarterHeldItems() {
        return new ArrayList<Integer>();
    }

    @Override
    public void setStarterHeldItems(List<Integer> items) {
    }

    @Override
    public List<Move> getMoves() {
        return Arrays.asList(this.moves);
    }

    @Override
    public List<EncounterSet> getEncounters(boolean useTimeOfDay) {
        if (!this.loadedWildMapNames) {
            this.loadWildMapNames();
        }
        try {
            if (this.romEntry.romType == 2) {
                return this.getEncountersHGSS(useTimeOfDay);
            }
            return this.getEncountersDPPt(useTimeOfDay);
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
    }

    private List<EncounterSet> getEncountersDPPt(boolean useTimeOfDay) throws IOException {
        String encountersFile = this.romEntry.getString("WildPokemon");
        NARCArchive encounterData = this.readNARC(encountersFile);
        ArrayList<EncounterSet> encounters = new ArrayList<EncounterSet>();
        int c = -1;
        for (byte[] b : encounterData.files) {
            if (!this.wildMapNames.containsKey(++c)) {
                this.wildMapNames.put(c, "? Unknown ?");
            }
            String mapName = this.wildMapNames.get(c);
            int grassRate = this.readLong(b, 0);
            if (grassRate != 0) {
                List<Encounter> grassEncounters = this.readEncountersDPPt(b, 4, 12);
                EncounterSet grass = new EncounterSet();
                grass.displayName = mapName + " Grass/Cave";
                grass.encounters = grassEncounters;
                grass.rate = grassRate;
                grass.offset = c;
                encounters.add(grass);
                if (useTimeOfDay) {
                    for (int i = 0; i < 4; ++i) {
                        int pknum = this.readLong(b, 108 + 4 * i);
                        if (pknum < 1 || pknum > 493) continue;
                        Pokemon pk = this.pokes[pknum];
                        Encounter enc = new Encounter();
                        enc.level = grassEncounters.get((int)Gen4Constants.dpptAlternateSlots[i + 2]).level;
                        enc.pokemon = pk;
                        grassEncounters.add(enc);
                    }
                }
                EncounterSet conds = new EncounterSet();
                conds.displayName = mapName + " Swarm/Radar/GBA";
                conds.rate = grassRate;
                conds.offset = c;
                for (int i = 0; i < 20; ++i) {
                    int offs;
                    int pknum;
                    if (i >= 2 && i <= 5 || (pknum = this.readLong(b, offs = 100 + i * 4 + (i >= 10 ? 24 : 0))) < 1 || pknum > 493) continue;
                    Pokemon pk = this.pokes[pknum];
                    Encounter enc = new Encounter();
                    enc.level = grassEncounters.get((int)Gen4Constants.dpptAlternateSlots[i]).level;
                    enc.pokemon = pk;
                    conds.encounters.add(enc);
                }
                if (conds.encounters.size() > 0) {
                    encounters.add(conds);
                }
            }
            int offset = 204;
            for (int i = 0; i < 5; ++i) {
                int rate = this.readLong(b, offset);
                List<Encounter> encountersHere = this.readSeaEncountersDPPt(b, offset += 4, 5);
                offset += 40;
                if (rate == 0 || i == 1) continue;
                EncounterSet other = new EncounterSet();
                other.displayName = mapName + " " + Gen4Constants.dpptWaterSlotSetNames[i];
                other.offset = c;
                other.encounters = encountersHere;
                other.rate = rate;
                encounters.add(other);
            }
        }
        return encounters;
    }

    private List<Encounter> readEncountersDPPt(byte[] data, int offset, int amount) {
        ArrayList<Encounter> encounters = new ArrayList<Encounter>();
        for (int i = 0; i < amount; ++i) {
            int level = this.readLong(data, offset + i * 8);
            int pokemon = this.readLong(data, offset + 4 + i * 8);
            Encounter enc = new Encounter();
            enc.level = level;
            enc.pokemon = this.pokes[pokemon];
            encounters.add(enc);
        }
        return encounters;
    }

    private List<Encounter> readSeaEncountersDPPt(byte[] data, int offset, int amount) {
        ArrayList<Encounter> encounters = new ArrayList<Encounter>();
        for (int i = 0; i < amount; ++i) {
            int level = this.readLong(data, offset + i * 8);
            int pokemon = this.readLong(data, offset + 4 + i * 8);
            Encounter enc = new Encounter();
            enc.level = level >> 8;
            enc.maxLevel = level & 0xFF;
            enc.pokemon = this.pokes[pokemon];
            encounters.add(enc);
        }
        return encounters;
    }

    private List<EncounterSet> getEncountersHGSS(boolean useTimeOfDay) throws IOException {
        String encountersFile = this.romEntry.getString("WildPokemon");
        NARCArchive encounterData = this.readNARC(encountersFile);
        ArrayList<EncounterSet> encounters = new ArrayList<EncounterSet>();
        int[] amounts = new int[]{0, 5, 2, 5, 5, 5};
        int c = -1;
        for (byte[] b : encounterData.files) {
            if (!this.wildMapNames.containsKey(++c)) {
                this.wildMapNames.put(c, "? Unknown ?");
            }
            String mapName = this.wildMapNames.get(c);
            int[] rates = new int[]{b[0] & 0xFF, b[1] & 0xFF, b[2] & 0xFF, b[3] & 0xFF, b[4] & 0xFF, b[5] & 0xFF};
            int[] grassLevels = new int[12];
            for (int i = 0; i < 12; ++i) {
                grassLevels[i] = b[8 + i] & 0xFF;
            }
            Pokemon[][] grassPokes = new Pokemon[3][12];
            grassPokes[0] = this.readPokemonHGSS(b, 20, 12);
            grassPokes[1] = this.readPokemonHGSS(b, 44, 12);
            grassPokes[2] = this.readPokemonHGSS(b, 68, 12);
            if (rates[0] != 0) {
                if (!useTimeOfDay) {
                    List<Encounter> grassEncounters = this.stitchEncsToLevels(grassPokes[1], grassLevels);
                    EncounterSet grass = new EncounterSet();
                    grass.encounters = grassEncounters;
                    grass.rate = rates[0];
                    grass.displayName = mapName + " Grass/Cave";
                    encounters.add(grass);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        EncounterSet grass = new EncounterSet();
                        grass.encounters = this.stitchEncsToLevels(grassPokes[i], grassLevels);
                        grass.rate = rates[0];
                        grass.displayName = mapName + " " + Gen4Constants.hgssTimeOfDayNames[i] + " Grass/Cave";
                        encounters.add(grass);
                    }
                }
            }
            EncounterSet radio = this.readOptionalEncountersHGSS(b, 92, 4);
            radio.displayName = mapName + " Hoenn/Sinnoh Radio";
            if (radio.encounters.size() > 0) {
                encounters.add(radio);
            }
            int offset = 100;
            for (int i = 1; i < 6; ++i) {
                List<Encounter> encountersHere = this.readSeaEncountersHGSS(b, offset, amounts[i]);
                offset += 4 * amounts[i];
                if (rates[i] == 0) continue;
                EncounterSet other = new EncounterSet();
                other.encounters = encountersHere;
                other.displayName = mapName + " " + Gen4Constants.hgssNonGrassSetNames[i];
                other.rate = rates[i];
                encounters.add(other);
            }
            EncounterSet swarms = this.readOptionalEncountersHGSS(b, offset, 4);
            swarms.displayName = mapName + " Swarms";
            if (swarms.encounters.size() <= 0) continue;
            encounters.add(swarms);
        }
        return encounters;
    }

    private EncounterSet readOptionalEncountersHGSS(byte[] data, int offset, int amount) {
        EncounterSet es = new EncounterSet();
        es.rate = 1;
        for (int i = 0; i < amount; ++i) {
            int pokemon = this.readWord(data, offset + i * 2);
            if (pokemon == 0) continue;
            Encounter e = new Encounter();
            e.level = 1;
            e.pokemon = this.pokes[pokemon];
            es.encounters.add(e);
        }
        return es;
    }

    private Pokemon[] readPokemonHGSS(byte[] data, int offset, int amount) {
        Pokemon[] pokesHere = new Pokemon[amount];
        for (int i = 0; i < amount; ++i) {
            pokesHere[i] = this.pokes[this.readWord(data, offset + i * 2)];
        }
        return pokesHere;
    }

    private List<Encounter> readSeaEncountersHGSS(byte[] data, int offset, int amount) {
        ArrayList<Encounter> encounters = new ArrayList<Encounter>();
        for (int i = 0; i < amount; ++i) {
            int level = this.readWord(data, offset + i * 4);
            int pokemon = this.readWord(data, offset + 2 + i * 4);
            Encounter enc = new Encounter();
            enc.level = level & 0xFF;
            enc.maxLevel = level >> 8;
            enc.pokemon = this.pokes[pokemon];
            encounters.add(enc);
        }
        return encounters;
    }

    @Override
    public void setEncounters(boolean useTimeOfDay, List<EncounterSet> encounters) {
        try {
            if (this.romEntry.romType == 2) {
                this.setEncountersHGSS(useTimeOfDay, encounters);
            } else {
                this.setEncountersDPPt(useTimeOfDay, encounters);
            }
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
    }

    private void setEncountersDPPt(boolean useTimeOfDay, List<EncounterSet> encounterList) throws IOException {
        String encountersFile = this.romEntry.getString("WildPokemon");
        NARCArchive encounterData = this.readNARC(encountersFile);
        Iterator<EncounterSet> encounters = encounterList.iterator();
        for (byte[] b : encounterData.files) {
            int grassRate = this.readLong(b, 0);
            if (grassRate != 0) {
                EncounterSet grass = encounters.next();
                this.writeEncountersDPPt(b, 4, grass.encounters, 12);
                int todEncounterSlot = 12;
                for (int i = 0; i < 4; ++i) {
                    Pokemon pk;
                    int pknum = this.readLong(b, 108 + 4 * i);
                    if (pknum < 1 || pknum > 493) continue;
                    if (useTimeOfDay) {
                        pk = grass.encounters.get((int)todEncounterSlot++).pokemon;
                        this.writeLong(b, 108 + 4 * i, pk.number);
                        continue;
                    }
                    pk = grass.encounters.get((int)Gen4Constants.dpptAlternateSlots[i + 2]).pokemon;
                    this.writeLong(b, 108 + 4 * i, pk.number);
                }
                Iterator<Encounter> condEncounters = null;
                for (int i = 0; i < 20; ++i) {
                    int offs;
                    int pknum;
                    if (i >= 2 && i <= 5 || (pknum = this.readLong(b, offs = 100 + i * 4 + (i >= 10 ? 24 : 0))) < 1 || pknum > 493) continue;
                    if (condEncounters == null) {
                        condEncounters = encounters.next().encounters.iterator();
                    }
                    Pokemon pk = ((Encounter)condEncounters.next()).pokemon;
                    this.writeLong(b, offs, pk.number);
                }
            }
            int offset = 204;
            for (int i = 0; i < 5; ++i) {
                int rate = this.readLong(b, offset);
                offset += 4;
                if (rate == 0 || i == 1) {
                    offset += 40;
                    continue;
                }
                EncounterSet other = encounters.next();
                this.writeSeaEncountersDPPt(b, offset, other.encounters);
                offset += 40;
            }
        }
        this.writeNARC(encountersFile, encounterData);
    }

    private void writeEncountersDPPt(byte[] data, int offset, List<Encounter> encounters, int enclength) {
        for (int i = 0; i < enclength; ++i) {
            Encounter enc = encounters.get(i);
            this.writeLong(data, offset + i * 8, enc.level);
            this.writeLong(data, offset + i * 8 + 4, enc.pokemon.number);
        }
    }

    private void writeSeaEncountersDPPt(byte[] data, int offset, List<Encounter> encounters) {
        int enclength = encounters.size();
        for (int i = 0; i < enclength; ++i) {
            Encounter enc = encounters.get(i);
            this.writeLong(data, offset + i * 8, (enc.level << 8) + enc.maxLevel);
            this.writeLong(data, offset + i * 8 + 4, enc.pokemon.number);
        }
    }

    private void setEncountersHGSS(boolean useTimeOfDay, List<EncounterSet> encounterList) throws IOException {
        String encountersFile = this.romEntry.getString("WildPokemon");
        NARCArchive encounterData = this.readNARC(encountersFile);
        Iterator<EncounterSet> encounters = encounterList.iterator();
        int[] amounts = new int[]{0, 5, 2, 5, 5, 5};
        for (byte[] b : encounterData.files) {
            int[] rates = new int[]{b[0] & 0xFF, b[1] & 0xFF, b[2] & 0xFF, b[3] & 0xFF, b[4] & 0xFF, b[5] & 0xFF};
            if (rates[0] != 0) {
                if (!useTimeOfDay) {
                    EncounterSet grass = encounters.next();
                    this.writePokemonHGSS(b, 20, grass.encounters);
                    this.writePokemonHGSS(b, 44, grass.encounters);
                    this.writePokemonHGSS(b, 68, grass.encounters);
                } else {
                    for (int i = 0; i < 3; ++i) {
                        EncounterSet grass = encounters.next();
                        this.writePokemonHGSS(b, 20 + i * 24, grass.encounters);
                    }
                }
            }
            this.writeOptionalEncountersHGSS(b, 92, 4, encounters);
            int offset = 100;
            for (int i = 1; i < 6; ++i) {
                if (rates[i] != 0) {
                    EncounterSet other = encounters.next();
                    this.writeSeaEncountersHGSS(b, offset, other.encounters);
                }
                offset += 4 * amounts[i];
            }
            this.writeOptionalEncountersHGSS(b, offset, 4, encounters);
        }
        this.writeNARC(encountersFile, encounterData);
    }

    private void writeOptionalEncountersHGSS(byte[] data, int offset, int amount, Iterator<EncounterSet> encounters) {
        Iterator<Encounter> eIter = null;
        for (int i = 0; i < amount; ++i) {
            int origPokemon = this.readWord(data, offset + i * 2);
            if (origPokemon == 0) continue;
            if (eIter == null) {
                eIter = encounters.next().encounters.iterator();
            }
            Encounter here = (Encounter)eIter.next();
            this.writeWord(data, offset + i * 2, here.pokemon.number);
        }
    }

    private void writePokemonHGSS(byte[] data, int offset, List<Encounter> encounters) {
        int enclength = encounters.size();
        for (int i = 0; i < enclength; ++i) {
            this.writeWord(data, offset + i * 2, encounters.get((int)i).pokemon.number);
        }
    }

    private void writeSeaEncountersHGSS(byte[] data, int offset, List<Encounter> encounters) {
        int enclength = encounters.size();
        for (int i = 0; i < enclength; ++i) {
            Encounter enc = encounters.get(i);
            data[offset + i * 4] = (byte)enc.level;
            data[offset + i * 4 + 1] = (byte)enc.maxLevel;
            this.writeWord(data, offset + i * 4 + 2, enc.pokemon.number);
        }
    }

    private List<Encounter> stitchEncsToLevels(Pokemon[] pokemon, int[] levels) {
        ArrayList<Encounter> encounters = new ArrayList<Encounter>();
        for (int i = 0; i < pokemon.length; ++i) {
            Encounter enc = new Encounter();
            enc.level = levels[i];
            enc.pokemon = pokemon[i];
            encounters.add(enc);
        }
        return encounters;
    }

    private void loadWildMapNames() {
        try {
            this.wildMapNames = new HashMap<Integer, String>();
            byte[] internalNames = this.readFile(this.romEntry.getString("MapTableFile"));
            int numMapHeaders = internalNames.length / 16;
            int baseMHOffset = this.romEntry.getInt("MapTableARM9Offset");
            List<String> allMapNames = this.getStrings(this.romEntry.getInt("MapNamesTextOffset"));
            int mapNameIndexSize = this.romEntry.getInt("MapTableNameIndexSize");
            for (int map = 0; map < numMapHeaders; ++map) {
                int wildSet;
                int baseOffset = baseMHOffset + map * 24;
                int mapNameIndex = mapNameIndexSize == 2 ? this.readWord(this.arm9, baseOffset + 18) : this.arm9[baseOffset + 18] & 0xFF;
                String mapName = allMapNames.get(mapNameIndex);
                if (this.romEntry.romType == 2) {
                    wildSet = this.arm9[baseOffset] & 0xFF;
                    if (wildSet == 255) continue;
                    this.wildMapNames.put(wildSet, mapName);
                    continue;
                }
                wildSet = this.readWord(this.arm9, baseOffset + 14);
                if (wildSet == 65535) continue;
                this.wildMapNames.put(wildSet, mapName);
            }
            this.loadedWildMapNames = true;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public List<Trainer> getTrainers() {
        ArrayList<Trainer> allTrainers = new ArrayList<Trainer>();
        try {
            NARCArchive trainers = this.readNARC(this.romEntry.getString("TrainerData"));
            NARCArchive trpokes = this.readNARC(this.romEntry.getString("TrainerPokemon"));
            List<String> tclasses = this.getTrainerClassNames();
            List<String> tnames = this.getTrainerNames();
            int trainernum = trainers.files.size();
            for (int i = 1; i < trainernum; ++i) {
                byte[] trainer = trainers.files.get(i);
                byte[] trpoke = trpokes.files.get(i);
                Trainer tr = new Trainer();
                tr.poketype = trainer[0] & 0xFF;
                tr.trainerclass = trainer[1] & 0xFF;
                tr.offset = i;
                int numPokes = trainer[3] & 0xFF;
                int pokeOffs = 0;
                tr.fullDisplayName = tclasses.get(tr.trainerclass) + " " + tnames.get(i - 1);
                for (int poke = 0; poke < numPokes; ++poke) {
                    int ailevel = trpoke[pokeOffs] & 0xFF;
                    int level = trpoke[pokeOffs + 2] & 0xFF;
                    int species = (trpoke[pokeOffs + 4] & 0xFF) + ((trpoke[pokeOffs + 5] & 1) << 8);
                    TrainerPokemon tpk = new TrainerPokemon();
                    tpk.level = level;
                    tpk.pokemon = this.pokes[species];
                    tpk.AILevel = ailevel;
                    tpk.ability = trpoke[pokeOffs + 1] & 0xFF;
                    pokeOffs += 6;
                    if ((tr.poketype & 2) == 2) {
                        int heldItem;
                        tpk.heldItem = heldItem = this.readWord(trpoke, pokeOffs);
                        pokeOffs += 2;
                    }
                    if ((tr.poketype & 1) == 1) {
                        int attack1 = this.readWord(trpoke, pokeOffs);
                        int attack2 = this.readWord(trpoke, pokeOffs + 2);
                        int attack3 = this.readWord(trpoke, pokeOffs + 4);
                        int attack4 = this.readWord(trpoke, pokeOffs + 6);
                        tpk.move1 = attack1;
                        tpk.move2 = attack2;
                        tpk.move3 = attack3;
                        tpk.move4 = attack4;
                        pokeOffs += 8;
                    }
                    if (this.romEntry.romType != 0) {
                        pokeOffs += 2;
                    }
                    tr.pokemon.add(tpk);
                }
                allTrainers.add(tr);
            }
            if (this.romEntry.romType == 0) {
                Gen4Constants.tagTrainersDP(allTrainers);
            } else if (this.romEntry.romType == 1) {
                Gen4Constants.tagTrainersPt(allTrainers);
            } else {
                Gen4Constants.tagTrainersHGSS(allTrainers);
            }
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
        return allTrainers;
    }

    @Override
    public void setTrainers(List<Trainer> trainerData) {
        Iterator<Trainer> allTrainers = trainerData.iterator();
        try {
            NARCArchive trainers = this.readNARC(this.romEntry.getString("TrainerData"));
            NARCArchive trpokes = new NARCArchive();
            Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
            trpokes.files.add(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
            int trainernum = trainers.files.size();
            for (int i = 1; i < trainernum; ++i) {
                byte[] trainer = trainers.files.get(i);
                Trainer tr = allTrainers.next();
                trainer[0] = (byte)tr.poketype;
                int numPokes = tr.pokemon.size();
                trainer[3] = (byte)numPokes;
                int bytesNeeded = 6 * numPokes;
                if (this.romEntry.romType != 0) {
                    bytesNeeded += 2 * numPokes;
                }
                if ((tr.poketype & 1) == 1) {
                    bytesNeeded += 8 * numPokes;
                }
                if ((tr.poketype & 2) == 2) {
                    bytesNeeded += 2 * numPokes;
                }
                byte[] trpoke = new byte[bytesNeeded];
                int pokeOffs = 0;
                Iterator<TrainerPokemon> tpokes = tr.pokemon.iterator();
                for (int poke = 0; poke < numPokes; ++poke) {
                    TrainerPokemon tp = tpokes.next();
                    this.writeWord(trpoke, pokeOffs, tp.AILevel);
                    this.writeWord(trpoke, pokeOffs + 2, tp.level);
                    this.writeWord(trpoke, pokeOffs + 4, tp.pokemon.number);
                    pokeOffs += 6;
                    if ((tr.poketype & 2) == 2) {
                        this.writeWord(trpoke, pokeOffs, tp.heldItem);
                        pokeOffs += 2;
                    }
                    if ((tr.poketype & 1) == 1) {
                        if (tp.resetMoves) {
                            int[] pokeMoves = RomFunctions.getMovesAtLevel(tp.pokemon, movesets, tp.level);
                            for (int m = 0; m < 4; ++m) {
                                this.writeWord(trpoke, pokeOffs + m * 2, pokeMoves[m]);
                            }
                        } else {
                            this.writeWord(trpoke, pokeOffs, tp.move1);
                            this.writeWord(trpoke, pokeOffs + 2, tp.move2);
                            this.writeWord(trpoke, pokeOffs + 4, tp.move3);
                            this.writeWord(trpoke, pokeOffs + 6, tp.move4);
                        }
                        pokeOffs += 8;
                    }
                    if (this.romEntry.romType == 0) continue;
                    pokeOffs += 2;
                }
                trpokes.files.add(trpoke);
            }
            this.writeNARC(this.romEntry.getString("TrainerData"), trainers);
            this.writeNARC(this.romEntry.getString("TrainerPokemon"), trpokes);
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
    }

    @Override
    public Map<Pokemon, List<MoveLearnt>> getMovesLearnt() {
        TreeMap<Pokemon, List<MoveLearnt>> movesets = new TreeMap<Pokemon, List<MoveLearnt>>();
        try {
            NARCArchive movesLearnt = this.readNARC(this.romEntry.getString("PokemonMovesets"));
            for (int i = 1; i <= 493; ++i) {
                Pokemon pkmn = this.pokes[i];
                byte[] rom = movesLearnt.files.get(i);
                int moveDataLoc = 0;
                ArrayList<MoveLearnt> learnt = new ArrayList<MoveLearnt>();
                while ((rom[moveDataLoc] & 0xFF) != 255 || (rom[moveDataLoc + 1] & 0xFF) != 255) {
                    int move = rom[moveDataLoc] & 0xFF;
                    int level = (rom[moveDataLoc + 1] & 0xFE) >> 1;
                    if ((rom[moveDataLoc + 1] & 1) == 1) {
                        move += 256;
                    }
                    MoveLearnt ml = new MoveLearnt();
                    ml.level = level;
                    ml.move = move;
                    learnt.add(ml);
                    moveDataLoc += 2;
                }
                movesets.put(pkmn, learnt);
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return movesets;
    }

    @Override
    public void setMovesLearnt(Map<Pokemon, List<MoveLearnt>> movesets) {
        int[] extraLearnSets = new int[]{7, 13, 13};
        NARCArchive movesLearnt = new NARCArchive();
        byte[] blankSet = new byte[]{-1, -1, 0, 0};
        movesLearnt.files.add(blankSet);
        for (int i = 1; i <= 493; ++i) {
            Pokemon pkmn = this.pokes[i];
            List<MoveLearnt> learnt = movesets.get(pkmn);
            int sizeNeeded = learnt.size() * 2 + 2;
            if (sizeNeeded % 4 != 0) {
                sizeNeeded += 2;
            }
            byte[] moveset = new byte[sizeNeeded];
            for (int j = 0; j < learnt.size(); ++j) {
                MoveLearnt ml = learnt.get(j);
                moveset[j * 2] = (byte)(ml.move & 0xFF);
                int levelPart = ml.level << 1 & 0xFE;
                if (ml.move > 255) {
                    ++levelPart;
                }
                moveset[j * 2 + 1] = (byte)levelPart;
            }
            moveset[j * 2] = -1;
            moveset[j * 2 + 1] = -1;
            movesLearnt.files.add(moveset);
        }
        for (int j = 0; j < extraLearnSets[this.romEntry.romType]; ++j) {
            movesLearnt.files.add(blankSet);
        }
        try {
            this.writeNARC(this.romEntry.getString("PokemonMovesets"), movesLearnt);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public List<Pokemon> getStaticPokemon() {
        ArrayList<Pokemon> sp = new ArrayList<Pokemon>();
        if (!this.romEntry.staticPokemonSupport) {
            return sp;
        }
        try {
            NARCArchive scriptNARC = this.scriptNarc;
            for (StaticPokemon statP : this.romEntry.staticPokemon) {
                sp.add(statP.getPokemon(this, scriptNARC));
            }
            if (this.romEntry.arrayEntries.containsKey("StaticPokemonTrades")) {
                int[] trades;
                NARCArchive tradeNARC = this.readNARC(this.romEntry.getString("InGameTrades"));
                for (int tradeNum : trades = (int[])this.romEntry.arrayEntries.get("StaticPokemonTrades")) {
                    sp.add(this.pokes[this.readLong(tradeNARC.files.get(tradeNum), 0)]);
                }
            }
            if (this.romEntry.getInt("MysteryEggOffset") > 0) {
                byte[] ovOverlay = this.readOverlay(this.romEntry.getInt("MoveTutorMovesOvlNumber"));
                sp.add(this.pokes[ovOverlay[this.romEntry.getInt("MysteryEggOffset")] & 0xFF]);
            }
            if (this.romEntry.getInt("FossilTableOffset") > 0) {
                byte[] ftData = this.arm9;
                int baseOffset = this.romEntry.getInt("FossilTableOffset");
                if (this.romEntry.romType == 2) {
                    ftData = this.readOverlay(this.romEntry.getInt("FossilTableOvlNumber"));
                }
                for (int f = 0; f < 7; ++f) {
                    sp.add(this.pokes[this.readWord(ftData, baseOffset + 2 + f * 4)]);
                }
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return sp;
    }

    @Override
    public boolean setStaticPokemon(List<Pokemon> staticPokemon) {
        int fossilsize;
        if (!this.romEntry.staticPokemonSupport) {
            return false;
        }
        int sptsize = this.romEntry.arrayEntries.containsKey("StaticPokemonTrades") ? ((int[])this.romEntry.arrayEntries.get("StaticPokemonTrades")).length : 0;
        int meggsize = this.romEntry.getInt("MysteryEggOffset") > 0 ? 1 : 0;
        int n = fossilsize = this.romEntry.getInt("FossilTableOffset") > 0 ? 7 : 0;
        if (staticPokemon.size() != this.romEntry.staticPokemon.size() + sptsize + meggsize + fossilsize) {
            return false;
        }
        try {
            Iterator<Pokemon> statics = staticPokemon.iterator();
            NARCArchive scriptNARC = this.scriptNarc;
            for (StaticPokemon statP : this.romEntry.staticPokemon) {
                statP.setPokemon(this, scriptNARC, statics.next());
            }
            if (this.romEntry.arrayEntries.containsKey("StaticPokemonTrades")) {
                int[] trades;
                NARCArchive tradeNARC = this.readNARC(this.romEntry.getString("InGameTrades"));
                for (int tradeNum : trades = (int[])this.romEntry.arrayEntries.get("StaticPokemonTrades")) {
                    Pokemon thisTrade = statics.next();
                    ArrayList<Integer> possibleAbilities = new ArrayList<Integer>();
                    possibleAbilities.add(thisTrade.ability1);
                    if (thisTrade.ability2 > 0) {
                        possibleAbilities.add(thisTrade.ability2);
                    }
                    if (thisTrade.ability3 > 0) {
                        possibleAbilities.add(thisTrade.ability3);
                    }
                    this.writeLong(tradeNARC.files.get(tradeNum), 0, thisTrade.number);
                    this.writeLong(tradeNARC.files.get(tradeNum), 28, (Integer)possibleAbilities.get(this.random.nextInt(possibleAbilities.size())));
                }
                this.writeNARC(this.romEntry.getString("InGameTrades"), tradeNARC);
            }
            if (this.romEntry.getInt("MysteryEggOffset") > 0) {
                int pokenum = statics.next().number;
                if (pokenum > 255) {
                    pokenum = this.random.nextInt(255) + 1;
                }
                byte[] ovOverlay = this.readOverlay(this.romEntry.getInt("MoveTutorMovesOvlNumber"));
                ovOverlay[((RomEntry)this.romEntry).getInt((String)"MysteryEggOffset")] = (byte)pokenum;
                this.writeOverlay(this.romEntry.getInt("MoveTutorMovesOvlNumber"), ovOverlay);
            }
            if (this.romEntry.getInt("FossilTableOffset") > 0) {
                int baseOffset = this.romEntry.getInt("FossilTableOffset");
                if (this.romEntry.romType == 2) {
                    byte[] ftData = this.readOverlay(this.romEntry.getInt("FossilTableOvlNumber"));
                    for (int f = 0; f < 7; ++f) {
                        int pokenum = statics.next().number;
                        this.writeWord(ftData, baseOffset + 2 + f * 4, pokenum);
                    }
                    this.writeOverlay(this.romEntry.getInt("FossilTableOvlNumber"), ftData);
                } else {
                    for (int f = 0; f < 7; ++f) {
                        int pokenum = statics.next().number;
                        this.writeWord(this.arm9, baseOffset + 2 + f * 4, pokenum);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return true;
    }

    @Override
    public List<Integer> getTMMoves() {
        String tmDataPrefix = this.romEntry.romType == 0 || this.romEntry.romType == 1 ? "D100D200D300D400" : "1E003200";
        int offset = this.find(this.arm9, tmDataPrefix);
        if (offset > 0) {
            offset += tmDataPrefix.length() / 2;
            ArrayList<Integer> tms = new ArrayList<Integer>();
            for (int i = 0; i < 92; ++i) {
                tms.add(this.readWord(this.arm9, offset + i * 2));
            }
            return tms;
        }
        return null;
    }

    @Override
    public List<Integer> getHMMoves() {
        String tmDataPrefix = this.romEntry.romType == 0 || this.romEntry.romType == 1 ? "D100D200D300D400" : "1E003200";
        int offset = this.find(this.arm9, tmDataPrefix);
        if (offset > 0) {
            offset += tmDataPrefix.length() / 2;
            offset += 184;
            ArrayList<Integer> hms = new ArrayList<Integer>();
            for (int i = 0; i < 8; ++i) {
                hms.add(this.readWord(this.arm9, offset + i * 2));
            }
            return hms;
        }
        return null;
    }

    @Override
    public void setTMMoves(List<Integer> moveIndexes) {
        String tmDataPrefix = this.romEntry.romType == 0 || this.romEntry.romType == 1 ? "D100D200D300D400" : "1E003200";
        int offset = this.find(this.arm9, tmDataPrefix);
        if (offset > 0) {
            int offsPals;
            offset += tmDataPrefix.length() / 2;
            for (int i = 0; i < 92; ++i) {
                this.writeWord(this.arm9, offset + i * 2, moveIndexes.get(i));
            }
            List<String> itemDescriptions = this.getStrings(this.romEntry.getInt("ItemDescriptionsTextOffset"));
            List<String> moveDescriptions = this.getStrings(this.romEntry.getInt("MoveDescriptionsTextOffset"));
            for (int i = 0; i < 92; ++i) {
                itemDescriptions.set(i + 328, RomFunctions.rewriteDescriptionForNewLineSize(moveDescriptions.get(moveIndexes.get(i)), "\\n", 40, ssd));
            }
            this.setStrings(this.romEntry.getInt("ItemDescriptionsTextOffset"), itemDescriptions);
            String baseOfPalettes = "8D018E01210133018D018F0122013401";
            if (this.romEntry.romType == 0) {
                baseOfPalettes = "8D018E01210132018D018F0122013301";
            }
            if ((offsPals = this.find(this.arm9, baseOfPalettes)) > 0) {
                for (int i = 0; i < 92; ++i) {
                    Move m = this.moves[moveIndexes.get(i)];
                    int pal = this.typeTMPaletteNumber(m.type);
                    this.writeWord(this.arm9, offsPals + i * 8 + 2, pal);
                }
            }
        }
    }

    @Override
    public int getTMCount() {
        return 92;
    }

    @Override
    public int getHMCount() {
        return 8;
    }

    @Override
    public Map<Pokemon, boolean[]> getTMHMCompatibility() {
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        for (int i = 1; i <= 493; ++i) {
            byte[] data = this.pokeNarc.files.get(i);
            Pokemon pkmn = this.pokes[i];
            boolean[] flags = new boolean[101];
            for (int j = 0; j < 13; ++j) {
                this.readByteIntoFlags(data, flags, j * 8 + 1, 28 + j);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setTMHMCompatibility(Map<Pokemon, boolean[]> compatData) {
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            byte[] data = this.pokeNarc.files.get(pkmn.number);
            for (int j = 0; j < 13; ++j) {
                data[28 + j] = this.getByteFromFlags(flags, j * 8 + 1);
            }
        }
    }

    @Override
    public boolean hasMoveTutors() {
        return this.romEntry.romType != 0;
    }

    @Override
    public List<Integer> getMoveTutorMoves() {
        if (!this.hasMoveTutors()) {
            return new ArrayList<Integer>();
        }
        int baseOffset = this.romEntry.getInt("MoveTutorMovesOffset");
        int amount = this.romEntry.getInt("MoveTutorCount");
        int bytesPer = this.romEntry.getInt("MoveTutorBytesCount");
        ArrayList<Integer> mtMoves = new ArrayList<Integer>();
        try {
            byte[] mtFile = this.readOverlay(this.romEntry.getInt("MoveTutorMovesOvlNumber"));
            for (int i = 0; i < amount; ++i) {
                mtMoves.add(this.readWord(mtFile, baseOffset + i * bytesPer));
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return mtMoves;
    }

    @Override
    public void setMoveTutorMoves(List<Integer> moves) {
        if (!this.hasMoveTutors()) {
            return;
        }
        int baseOffset = this.romEntry.getInt("MoveTutorMovesOffset");
        int amount = this.romEntry.getInt("MoveTutorCount");
        int bytesPer = this.romEntry.getInt("MoveTutorBytesCount");
        if (moves.size() != amount) {
            return;
        }
        try {
            byte[] mtFile = this.readOverlay(this.romEntry.getInt("MoveTutorMovesOvlNumber"));
            for (int i = 0; i < amount; ++i) {
                this.writeWord(mtFile, baseOffset + i * bytesPer, moves.get(i));
            }
            this.writeOverlay(this.romEntry.getInt("MoveTutorMovesOvlNumber"), mtFile);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public Map<Pokemon, boolean[]> getMoveTutorCompatibility() {
        if (!this.hasMoveTutors()) {
            return new TreeMap<Pokemon, boolean[]>();
        }
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        int amount = this.romEntry.getInt("MoveTutorCount");
        int baseOffset = this.romEntry.getInt("MoveTutorCompatOffset");
        int bytesPer = this.romEntry.getInt("MoveTutorCompatBytesCount");
        try {
            byte[] mtcFile = this.romEntry.romType == 2 ? this.readFile(this.romEntry.getString("MoveTutorCompat")) : this.readOverlay(this.romEntry.getInt("MoveTutorCompatOvlNumber"));
            for (int i = 1; i <= 493; ++i) {
                Pokemon pkmn = this.pokes[i];
                boolean[] flags = new boolean[amount + 1];
                for (int j = 0; j < bytesPer; ++j) {
                    this.readByteIntoFlags(mtcFile, flags, j * 8 + 1, baseOffset + (i - 1) * bytesPer + j);
                }
                compat.put(pkmn, flags);
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return compat;
    }

    @Override
    public void setMoveTutorCompatibility(Map<Pokemon, boolean[]> compatData) {
        if (!this.hasMoveTutors()) {
            return;
        }
        int amount = this.romEntry.getInt("MoveTutorCount");
        int baseOffset = this.romEntry.getInt("MoveTutorCompatOffset");
        int bytesPer = this.romEntry.getInt("MoveTutorCompatBytesCount");
        try {
            byte[] mtcFile = this.romEntry.romType == 2 ? this.readFile(this.romEntry.getString("MoveTutorCompat")) : this.readOverlay(this.romEntry.getInt("MoveTutorCompatOvlNumber"));
            for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
                Pokemon pkmn = compatEntry.getKey();
                boolean[] flags = compatEntry.getValue();
                for (int j = 0; j < bytesPer; ++j) {
                    int offsHere = baseOffset + (pkmn.number - 1) * bytesPer + j;
                    if (j * 8 + 8 <= amount) {
                        mtcFile[offsHere] = this.getByteFromFlags(flags, j * 8 + 1);
                        continue;
                    }
                    if (j * 8 >= amount) continue;
                    int newByte = this.getByteFromFlags(flags, j * 8 + 1) & 0xFF;
                    int oldByteParts = mtcFile[offsHere] >>> 8 - amount + j * 8 << 8 - amount + j * 8;
                    mtcFile[offsHere] = (byte)(newByte | oldByteParts);
                }
            }
            if (this.romEntry.romType == 2) {
                this.writeFile(this.romEntry.getString("MoveTutorCompat"), mtcFile);
            } else {
                this.writeOverlay(this.romEntry.getInt("MoveTutorCompatOvlNumber"), mtcFile);
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private int find(byte[] data, String hexString) {
        if (hexString.length() % 2 != 0) {
            return -3;
        }
        byte[] searchFor = new byte[hexString.length() / 2];
        for (int i = 0; i < searchFor.length; ++i) {
            searchFor[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        List<Integer> found = RomFunctions.search(data, searchFor);
        if (found.size() == 0) {
            return -1;
        }
        if (found.size() > 1) {
            return -2;
        }
        return found.get(0);
    }

    private List<String> getStrings(int index) {
        PokeTextData pt = new PokeTextData(this.msgNarc.files.get(index));
        pt.decrypt();
        this.lastStringsCompressed = pt.compressFlag;
        return new ArrayList<String>(pt.strlist);
    }

    private void setStrings(int index, List<String> newStrings) {
        this.setStrings(index, newStrings, false);
    }

    private void setStrings(int index, List<String> newStrings, boolean compressed) {
        byte[] rawUnencrypted = TextToPoke.MakeFile(newStrings, compressed);
        PokeTextData encrypt = new PokeTextData(rawUnencrypted);
        encrypt.SetKey(53262);
        encrypt.encrypt();
        this.msgNarc.files.set(index, encrypt.get());
    }

    @Override
    public String getROMName() {
        return "Pokemon " + this.romEntry.name;
    }

    @Override
    public String getROMCode() {
        return this.romEntry.romCode;
    }

    @Override
    public String getSupportLevel() {
        return this.romEntry.staticPokemonSupport ? "Complete" : "No Static Pokemon";
    }

    @Override
    public boolean hasTimeBasedEncounters() {
        return this.romEntry.romType == 2;
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return this.romEntry.staticPokemonSupport;
    }

    @Override
    public boolean canChangeStarters() {
        return true;
    }

    private void populateEvolutions() {
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            pkmn.evolutionsFrom.clear();
            pkmn.evolutionsTo.clear();
        }
        try {
            NARCArchive evoNARC = this.readNARC(this.romEntry.getString("PokemonEvolutions"));
            for (int i = 1; i <= 493; ++i) {
                Pokemon pk = this.pokes[i];
                byte[] evoEntry = evoNARC.files.get(i);
                for (int evo = 0; evo < 7; ++evo) {
                    int extraInfo;
                    EvolutionType et;
                    Evolution evol;
                    int method = this.readWord(evoEntry, evo * 6);
                    int species = this.readWord(evoEntry, evo * 6 + 4);
                    if (method < 1 || method > 26 || species < 1 || pk.evolutionsFrom.contains(evol = new Evolution(this.pokes[i], this.pokes[species], true, et = EvolutionType.fromIndex(4, method), extraInfo = this.readWord(evoEntry, evo * 6 + 2)))) continue;
                    pk.evolutionsFrom.add(evol);
                    this.pokes[species].evolutionsTo.add(evol);
                }
                if (pk.evolutionsFrom.size() <= 1) continue;
                for (Evolution e : pk.evolutionsFrom) {
                    e.carryStats = false;
                }
            }
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void writeEvolutions() {
        try {
            NARCArchive evoNARC = this.readNARC(this.romEntry.getString("PokemonEvolutions"));
            for (int i = 1; i <= 493; ++i) {
                byte[] evoEntry = evoNARC.files.get(i);
                int evosWritten = 0;
                Pokemon pk = this.pokes[i];
                for (Evolution evo : pk.evolutionsFrom) {
                    this.writeWord(evoEntry, evosWritten * 6, evo.type.toIndex(4));
                    this.writeWord(evoEntry, evosWritten * 6 + 2, evo.extraInfo);
                    this.writeWord(evoEntry, evosWritten * 6 + 4, evo.to.number);
                    if (++evosWritten != 7) continue;
                    break;
                }
                while (evosWritten < 7) {
                    this.writeWord(evoEntry, evosWritten * 6, 0);
                    this.writeWord(evoEntry, evosWritten * 6 + 2, 0);
                    this.writeWord(evoEntry, evosWritten * 6 + 4, 0);
                    ++evosWritten;
                }
            }
            this.writeNARC(this.romEntry.getString("PokemonEvolutions"), evoNARC);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public void removeTradeEvolutions(boolean changeMoveEvos) {
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        this.log("--Removing Trade Evolutions--");
        HashSet<Evolution> extraEvolutions = new HashSet<Evolution>();
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            extraEvolutions.clear();
            for (Evolution evo : pkmn.evolutionsFrom) {
                if (this.romEntry.romType == 2) {
                    if (evo.type == EvolutionType.LEVEL_HIGH_BEAUTY) {
                        evo.type = EvolutionType.LEVEL;
                        evo.extraInfo = 35;
                        this.logEvoChangeLevel(evo.from.name, evo.to.name, 35);
                    }
                    if (evo.type == EvolutionType.LEVEL_ELECTRIFIED_AREA) {
                        evo.type = EvolutionType.LEVEL;
                        evo.extraInfo = 40;
                        this.logEvoChangeLevel(evo.from.name, evo.to.name, 40);
                    }
                    if (evo.type == EvolutionType.LEVEL_MOSS_ROCK) {
                        evo.type = EvolutionType.STONE;
                        evo.extraInfo = 85;
                        this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames.get(85));
                    }
                    if (evo.type == EvolutionType.LEVEL_ICY_ROCK) {
                        evo.type = EvolutionType.STONE;
                        evo.extraInfo = 109;
                        this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames.get(109));
                    }
                }
                if (changeMoveEvos && evo.type == EvolutionType.LEVEL_WITH_MOVE) {
                    int move = evo.extraInfo;
                    int levelLearntAt = 1;
                    for (MoveLearnt ml : movesets.get(evo.from)) {
                        if (ml.move != move) continue;
                        levelLearntAt = ml.level;
                        break;
                    }
                    if (levelLearntAt == 1) {
                        levelLearntAt = 45;
                    }
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = levelLearntAt;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, levelLearntAt);
                }
                if (evo.type == EvolutionType.TRADE) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 37;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 37);
                }
                if (evo.type != EvolutionType.TRADE_ITEM) continue;
                int item = evo.extraInfo;
                if (evo.from.number == 79) {
                    evo.type = EvolutionType.STONE;
                    evo.extraInfo = 84;
                    this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames.get(84));
                    continue;
                }
                this.logEvoChangeLevelWithItem(evo.from.name, evo.to.name, this.itemNames.get(item));
                evo.type = EvolutionType.LEVEL_ITEM_DAY;
                Evolution extraEntry = new Evolution(evo.from, evo.to, true, EvolutionType.LEVEL_ITEM_NIGHT, item);
                extraEvolutions.add(extraEntry);
            }
            pkmn.evolutionsFrom.addAll(extraEvolutions);
            for (Evolution ev : extraEvolutions) {
                ev.to.evolutionsTo.add(ev);
            }
        }
        this.logBlankLine();
    }

    @Override
    public boolean canChangeTrainerText() {
        return true;
    }

    @Override
    public List<String> getTrainerNames() {
        ArrayList<String> tnames = new ArrayList<String>(this.getStrings(this.romEntry.getInt("TrainerNamesTextOffset")));
        tnames.remove(0);
        for (int i = 0; i < tnames.size(); ++i) {
            if (!((String)tnames.get(i)).contains("\\and")) continue;
            tnames.set(i, ((String)tnames.get(i)).replace("\\and", "&"));
        }
        return tnames;
    }

    @Override
    public int maxTrainerNameLength() {
        return 10;
    }

    @Override
    public void setTrainerNames(List<String> trainerNames) {
        List<String> oldTNames = this.getStrings(this.romEntry.getInt("TrainerNamesTextOffset"));
        ArrayList<String> newTNames = new ArrayList<String>(trainerNames);
        for (int i = 0; i < newTNames.size(); ++i) {
            if (!((String)newTNames.get(i)).contains("&")) continue;
            newTNames.set(i, ((String)newTNames.get(i)).replace("&", "\\and"));
        }
        newTNames.add(0, oldTNames.get(0));
        this.setStrings(this.romEntry.getInt("TrainerNamesTextOffset"), newTNames, this.lastStringsCompressed);
    }

    @Override
    public RomHandler.TrainerNameMode trainerNameMode() {
        return RomHandler.TrainerNameMode.MAX_LENGTH;
    }

    @Override
    public List<Integer> getTCNameLengthsByTrainer() {
        return new ArrayList<Integer>();
    }

    @Override
    public List<String> getTrainerClassNames() {
        return this.getStrings(this.romEntry.getInt("TrainerClassesTextOffset"));
    }

    @Override
    public void setTrainerClassNames(List<String> trainerClassNames) {
        this.setStrings(this.romEntry.getInt("TrainerClassesTextOffset"), trainerClassNames);
    }

    @Override
    public int maxTrainerClassNameLength() {
        return 12;
    }

    @Override
    public boolean fixedTrainerClassNamesLength() {
        return false;
    }

    @Override
    public List<Integer> getDoublesTrainerClasses() {
        int[] doublesClasses = (int[])this.romEntry.arrayEntries.get("DoublesTrainerClasses");
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        for (int tClass : doublesClasses) {
            doubles.add(tClass);
        }
        return doubles;
    }

    @Override
    public String getDefaultExtension() {
        return "nds";
    }

    @Override
    public int abilitiesPerPokemon() {
        return 2;
    }

    @Override
    public int highestAbilityIndex() {
        return 123;
    }

    @Override
    public int internalStringLength(String string) {
        return string.length();
    }

    @Override
    public void applySignature() {
    }

    @Override
    public ItemList getAllowedItems() {
        return this.allowedItems;
    }

    @Override
    public ItemList getNonBadItems() {
        return this.nonBadItems;
    }

    @Override
    public String[] getItemNames() {
        return this.itemNames.toArray(new String[0]);
    }

    @Override
    public String abilityName(int number) {
        return this.abilityNames.get(number);
    }

    private List<Integer> getFieldItems() {
        int part1;
        int setVar;
        ArrayList<Integer> fieldItems = new ArrayList<Integer>();
        int scriptFile = this.romEntry.getInt("ItemBallsScriptOffset");
        byte[] itemScripts = this.scriptNarc.files.get(scriptFile);
        int offset = 0;
        int skipTableOffset = 0;
        int[] skipTable = (int[])this.romEntry.arrayEntries.get("ItemBallsSkip");
        int n = setVar = this.romEntry.romType == 2 ? 41 : 40;
        while ((part1 = this.readWord(itemScripts, offset)) != 64787) {
            int offsetInFile = this.readRelativePointer(itemScripts, offset);
            if (skipTableOffset < skipTable.length && skipTable[skipTableOffset] == (offset += 4) / 4 - 1) {
                ++skipTableOffset;
                continue;
            }
            int command = this.readWord(itemScripts, offsetInFile);
            int variable = this.readWord(itemScripts, offsetInFile + 2);
            if (command != setVar || variable != 32776) continue;
            int item = this.readWord(itemScripts, offsetInFile + 4);
            fieldItems.add(item);
        }
        int hiTableOffset = this.romEntry.getInt("HiddenItemTableOffset");
        int hiTableLimit = this.romEntry.getInt("HiddenItemCount");
        for (int i = 0; i < hiTableLimit; ++i) {
            int item = this.readWord(this.arm9, hiTableOffset + i * 8);
            fieldItems.add(item);
        }
        return fieldItems;
    }

    private void setFieldItems(List<Integer> fieldItems) {
        int part1;
        int setVar;
        Iterator<Integer> iterItems = fieldItems.iterator();
        int scriptFile = this.romEntry.getInt("ItemBallsScriptOffset");
        byte[] itemScripts = this.scriptNarc.files.get(scriptFile);
        int offset = 0;
        int skipTableOffset = 0;
        int[] skipTable = (int[])this.romEntry.arrayEntries.get("ItemBallsSkip");
        int n = setVar = this.romEntry.romType == 2 ? 41 : 40;
        while ((part1 = this.readWord(itemScripts, offset)) != 64787) {
            int offsetInFile = this.readRelativePointer(itemScripts, offset);
            if (skipTableOffset < skipTable.length && skipTable[skipTableOffset] == (offset += 4) / 4 - 1) {
                ++skipTableOffset;
                continue;
            }
            int command = this.readWord(itemScripts, offsetInFile);
            int variable = this.readWord(itemScripts, offsetInFile + 2);
            if (command != setVar || variable != 32776) continue;
            int item = iterItems.next();
            this.writeWord(itemScripts, offsetInFile + 4, item);
        }
        int hiTableOffset = this.romEntry.getInt("HiddenItemTableOffset");
        int hiTableLimit = this.romEntry.getInt("HiddenItemCount");
        for (int i = 0; i < hiTableLimit; ++i) {
            int item = iterItems.next();
            this.writeWord(this.arm9, hiTableOffset + i * 8, item);
        }
    }

    @Override
    public List<Integer> getRequiredFieldTMs() {
        if (this.romEntry.romType == 0) {
            return Gen4Constants.dpRequiredFieldTMs;
        }
        if (this.romEntry.romType == 1) {
            return Gen4Constants.ptRequiredFieldTMs;
        }
        return new ArrayList<Integer>();
    }

    @Override
    public List<Integer> getCurrentFieldTMs() {
        List<Integer> fieldItems = this.getFieldItems();
        ArrayList<Integer> fieldTMs = new ArrayList<Integer>();
        for (int item : fieldItems) {
            if (!Gen4Constants.allowedItems.isTM(item)) continue;
            fieldTMs.add(item - 328 + 1);
        }
        return fieldTMs;
    }

    @Override
    public void setFieldTMs(List<Integer> fieldTMs) {
        List<Integer> fieldItems = this.getFieldItems();
        int fiLength = fieldItems.size();
        Iterator<Integer> iterTMs = fieldTMs.iterator();
        for (int i = 0; i < fiLength; ++i) {
            int oldItem = fieldItems.get(i);
            if (!Gen4Constants.allowedItems.isTM(oldItem)) continue;
            int newItem = iterTMs.next() + 328 - 1;
            fieldItems.set(i, newItem);
        }
        this.setFieldItems(fieldItems);
    }

    @Override
    public List<Integer> getRegularFieldItems() {
        List<Integer> fieldItems = this.getFieldItems();
        ArrayList<Integer> fieldRegItems = new ArrayList<Integer>();
        for (int item : fieldItems) {
            if (!Gen4Constants.allowedItems.isAllowed(item) || Gen4Constants.allowedItems.isTM(item)) continue;
            fieldRegItems.add(item);
        }
        return fieldRegItems;
    }

    @Override
    public void setRegularFieldItems(List<Integer> items) {
        List<Integer> fieldItems = this.getFieldItems();
        int fiLength = fieldItems.size();
        Iterator<Integer> iterNewItems = items.iterator();
        for (int i = 0; i < fiLength; ++i) {
            int oldItem = fieldItems.get(i);
            if (Gen4Constants.allowedItems.isTM(oldItem) || !Gen4Constants.allowedItems.isAllowed(oldItem)) continue;
            int newItem = iterNewItems.next();
            fieldItems.set(i, newItem);
        }
        this.setFieldItems(fieldItems);
    }

    @Override
    public List<IngameTrade> getIngameTrades() {
        ArrayList<IngameTrade> trades = new ArrayList<IngameTrade>();
        try {
            NARCArchive tradeNARC = this.readNARC(this.romEntry.getString("InGameTrades"));
            int[] spTrades = new int[]{};
            if (this.romEntry.arrayEntries.containsKey("StaticPokemonTrades")) {
                spTrades = (int[])this.romEntry.arrayEntries.get("StaticPokemonTrades");
            }
            List<String> tradeStrings = this.getStrings(this.romEntry.getInt("IngameTradesTextOffset"));
            int tradeCount = tradeNARC.files.size();
            for (int i = 0; i < tradeCount; ++i) {
                boolean isSP = false;
                for (int j = 0; j < spTrades.length; ++j) {
                    if (spTrades[j] != i) continue;
                    isSP = true;
                    break;
                }
                if (isSP) continue;
                byte[] tfile = tradeNARC.files.get(i);
                IngameTrade trade = new IngameTrade();
                trade.nickname = tradeStrings.get(i);
                trade.givenPokemon = this.pokes[this.readLong(tfile, 0)];
                trade.ivs = new int[6];
                for (int iv = 0; iv < 6; ++iv) {
                    trade.ivs[iv] = this.readLong(tfile, 4 + iv * 4);
                }
                trade.otId = this.readWord(tfile, 32);
                trade.otName = tradeStrings.get(i + tradeCount);
                trade.item = this.readLong(tfile, 60);
                trade.requestedPokemon = this.pokes[this.readLong(tfile, 76)];
                trades.add(trade);
            }
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
        return trades;
    }

    @Override
    public void setIngameTrades(List<IngameTrade> trades) {
        block9: {
            int tradeOffset = 0;
            List<IngameTrade> oldTrades = this.getIngameTrades();
            try {
                NARCArchive tradeNARC = this.readNARC(this.romEntry.getString("InGameTrades"));
                int[] spTrades = new int[]{};
                if (this.romEntry.arrayEntries.containsKey("StaticPokemonTrades")) {
                    spTrades = (int[])this.romEntry.arrayEntries.get("StaticPokemonTrades");
                }
                List<String> tradeStrings = this.getStrings(this.romEntry.getInt("IngameTradesTextOffset"));
                int tradeCount = tradeNARC.files.size();
                for (int i = 0; i < tradeCount; ++i) {
                    boolean isSP = false;
                    for (int j = 0; j < spTrades.length; ++j) {
                        if (spTrades[j] != i) continue;
                        isSP = true;
                        break;
                    }
                    if (isSP) continue;
                    byte[] tfile = tradeNARC.files.get(i);
                    IngameTrade trade = trades.get(tradeOffset++);
                    tradeStrings.set(i, trade.nickname);
                    tradeStrings.set(i + tradeCount, trade.otName);
                    this.writeLong(tfile, 0, trade.givenPokemon.number);
                    for (int iv = 0; iv < 6; ++iv) {
                        this.writeLong(tfile, 4 + iv * 4, trade.ivs[iv]);
                    }
                    this.writeWord(tfile, 32, trade.otId);
                    this.writeLong(tfile, 60, trade.item);
                    this.writeLong(tfile, 76, trade.requestedPokemon.number);
                    if (tfile.length <= 80) continue;
                    this.writeLong(tfile, 80, 0);
                }
                this.writeNARC(this.romEntry.getString("InGameTrades"), tradeNARC);
                this.setStrings(this.romEntry.getInt("IngameTradesTextOffset"), tradeStrings);
                if (!this.romEntry.arrayEntries.containsKey("IngameTradePersonTextOffsets")) break block9;
                int[] textOffsets = (int[])this.romEntry.arrayEntries.get("IngameTradePersonTextOffsets");
                for (int trade = 0; trade < textOffsets.length; ++trade) {
                    if (textOffsets[trade] <= 0) continue;
                    if (trade < oldTrades.size() && trade < trades.size()) {
                        IngameTrade oldTrade = oldTrades.get(trade);
                        IngameTrade newTrade = trades.get(trade);
                        TreeMap<String, String> replacements = new TreeMap<String, String>();
                        replacements.put(oldTrade.givenPokemon.name, newTrade.givenPokemon.name);
                        if (oldTrade.requestedPokemon != newTrade.requestedPokemon) {
                            replacements.put(oldTrade.requestedPokemon.name, newTrade.requestedPokemon.name);
                        }
                        this.replaceAllStringsInEntry(textOffsets[trade], replacements, 40);
                        if (this.romEntry.romType != 2 || trade != 6) continue;
                        this.replaceAllStringsInEntry(textOffsets[trade] + 1, replacements, 40);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException ex) {
                throw new RandomizerIOException(ex);
            }
        }
    }

    private void replaceAllStringsInEntry(int entry, Map<String, String> replacements, int lineLength) {
        List<String> thisTradeStrings = this.getStrings(entry);
        int ttsCount = thisTradeStrings.size();
        for (int strNum = 0; strNum < ttsCount; ++strNum) {
            String oldString = thisTradeStrings.get(strNum);
            String newString = RomFunctions.formatTextWithReplacements(oldString, replacements, "\\n", "\\l", "\\p", lineLength, ssd);
            thisTradeStrings.set(strNum, newString);
        }
        this.setStrings(entry, thisTradeStrings);
    }

    @Override
    public boolean hasDVs() {
        return false;
    }

    @Override
    public int generationOfPokemon() {
        return 4;
    }

    @Override
    public void removeEvosForPokemonPool() {
        List pokemonIncluded = this.mainPokemonList;
        HashSet<Evolution> keepEvos = new HashSet<Evolution>();
        for (Pokemon pk : this.pokes) {
            if (pk == null) continue;
            keepEvos.clear();
            for (Evolution evol : pk.evolutionsFrom) {
                if (pokemonIncluded.contains(evol.from) && pokemonIncluded.contains(evol.to)) {
                    keepEvos.add(evol);
                    continue;
                }
                evol.to.evolutionsTo.remove(evol);
            }
            pk.evolutionsFrom.retainAll(keepEvos);
        }
        try {
            byte[] babyPokes = this.readFile(this.romEntry.getString("BabyPokemon"));
            for (int i = 1; i <= 493; ++i) {
                Pokemon baby = this.pokes[i];
                while (baby.evolutionsTo.size() > 0) {
                    baby = baby.evolutionsTo.get((int)0).from;
                }
                this.writeWord(babyPokes, i * 2, baby.number);
            }
            this.writeFile(this.romEntry.getString("BabyPokemon"), babyPokes);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public boolean supportsFourStartingMoves() {
        return true;
    }

    @Override
    public List<Integer> getFieldMoves() {
        if (this.romEntry.romType == 2) {
            return Gen4Constants.hgssFieldMoves;
        }
        return Gen4Constants.dpptFieldMoves;
    }

    @Override
    public List<Integer> getEarlyRequiredHMMoves() {
        if (this.romEntry.romType == 2) {
            return Gen4Constants.hgssEarlyRequiredHMMoves;
        }
        return Gen4Constants.dpptEarlyRequiredHMMoves;
    }

    @Override
    public int miscTweaksAvailable() {
        int available = MiscTweak.LOWER_CASE_POKEMON_NAMES.getValue();
        available |= MiscTweak.RANDOMIZE_CATCHING_TUTORIAL.getValue();
        if (this.romEntry.tweakFiles.get("FastestTextTweak") != null) {
            available |= MiscTweak.FASTEST_TEXT.getValue();
        }
        return available |= MiscTweak.BAN_LUCKY_EGG.getValue();
    }

    @Override
    public void applyMiscTweak(MiscTweak tweak) {
        if (tweak == MiscTweak.LOWER_CASE_POKEMON_NAMES) {
            this.applyCamelCaseNames();
        } else if (tweak == MiscTweak.RANDOMIZE_CATCHING_TUTORIAL) {
            this.randomizeCatchingTutorial();
        } else if (tweak == MiscTweak.FASTEST_TEXT) {
            this.applyFastestText();
        } else if (tweak == MiscTweak.BAN_LUCKY_EGG) {
            this.allowedItems.banSingles(231);
            this.nonBadItems.banSingles(231);
        }
    }

    private void randomizeCatchingTutorial() {
        int opponentOffset = this.romEntry.getInt("CatchingTutorialOpponentMonOffset");
        if (this.romEntry.romType == 2) {
            int playerOffset = this.romEntry.getInt("CatchingTutorialPlayerMonOffset");
            Pokemon opponent = this.randomPokemonLimited(255, false);
            Pokemon player = this.randomPokemonLimited(255, false);
            if (opponent != null && player != null) {
                this.arm9[opponentOffset] = (byte)opponent.number;
                this.arm9[playerOffset] = (byte)player.number;
            }
        } else {
            Pokemon opponent = this.randomPokemonLimited(Integer.MAX_VALUE, false);
            if (opponent != null) {
                this.writeLong(this.arm9, opponentOffset, opponent.number);
            }
        }
    }

    private void applyFastestText() {
        this.genericIPSPatch(this.arm9, "FastestTextTweak");
    }

    private boolean genericIPSPatch(byte[] data, String ctName) {
        String patchName = (String)this.romEntry.tweakFiles.get(ctName);
        if (patchName == null) {
            return false;
        }
        try {
            FileFunctions.applyPatch(data, patchName);
            return true;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private Pokemon randomPokemonLimited(int maxValue, boolean blockNonMales) {
        this.checkPokemonRestrictions();
        ArrayList<Pokemon> validPokemon = new ArrayList<Pokemon>();
        for (Pokemon pk : this.mainPokemonList) {
            if (pk.number > maxValue || blockNonMales && pk.genderRatio > 253) continue;
            validPokemon.add(pk);
        }
        if (validPokemon.size() == 0) {
            return null;
        }
        return (Pokemon)validPokemon.get(this.random.nextInt(validPokemon.size()));
    }

    @Override
    public BufferedImage getMascotImage() {
        try {
            int i;
            int key;
            byte[] rawSprite;
            Pokemon pk = this.randomPokemon();
            NARCArchive pokespritesNARC = this.readNARC(this.romEntry.getString("PokemonGraphics"));
            int spriteIndex = pk.number * 6 + 2 + this.random.nextInt(2);
            int palIndex = pk.number * 6 + 4;
            if (this.random.nextInt(10) == 0) {
                ++palIndex;
            }
            if ((rawSprite = pokespritesNARC.files.get(spriteIndex)).length == 0) {
                rawSprite = pokespritesNARC.files.get(spriteIndex ^ 1);
            }
            int[] spriteData = new int[3200];
            for (int i2 = 0; i2 < 3200; ++i2) {
                spriteData[i2] = this.readWord(rawSprite, i2 * 2 + 48);
            }
            if (this.romEntry.romType != 0) {
                key = spriteData[0];
                i = 0;
                while (i < 3200) {
                    int n = i++;
                    spriteData[n] = spriteData[n] ^ key & 0xFFFF;
                    key = key * 1103515245 + 24691;
                }
            } else {
                key = spriteData[3199];
                i = 3199;
                while (i >= 0) {
                    int n = i--;
                    spriteData[n] = spriteData[n] ^ key & 0xFFFF;
                    key = key * 1103515245 + 24691;
                }
            }
            byte[] rawPalette = pokespritesNARC.files.get(palIndex);
            int[] palette = new int[16];
            for (int i3 = 1; i3 < 16; ++i3) {
                palette[i3] = GFXFunctions.conv16BitColorToARGB(this.readWord(rawPalette, 40 + i3 * 2));
            }
            BufferedImage bim = new BufferedImage(80, 80, 2);
            for (int y = 0; y < 80; ++y) {
                for (int x = 0; x < 80; ++x) {
                    int value = spriteData[y * 40 + x / 4] >> x % 4 * 4 & 0xF;
                    bim.setRGB(x, y, palette[value]);
                }
            }
            return bim;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    static {
        Gen4RomHandler.loadROMInfo();
        ssd = new RomFunctions.StringLengthSD();
    }

    private static class StaticPokemon {
        private int[] files;
        private int[] offsets;

        private StaticPokemon() {
        }

        public Pokemon getPokemon(Gen4RomHandler parent, NARCArchive scriptNARC) {
            return parent.pokes[parent.readWord(scriptNARC.files.get(this.files[0]), this.offsets[0])];
        }

        public void setPokemon(Gen4RomHandler parent, NARCArchive scriptNARC, Pokemon pkmn) {
            int value = pkmn.number;
            for (int i = 0; i < this.offsets.length; ++i) {
                byte[] file = scriptNARC.files.get(this.files[i]);
                parent.writeWord(file, this.offsets[i], value);
            }
        }

        static /* synthetic */ int[] access$1202(StaticPokemon x0, int[] x1) {
            x0.files = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1302(StaticPokemon x0, int[] x1) {
            x0.offsets = x1;
            return x1;
        }
    }

    private static class RomEntry {
        private String name;
        private String romCode;
        private int romType;
        private boolean staticPokemonSupport = false;
        private boolean copyStaticPokemon = false;
        private Map<String, String> strings = new HashMap<String, String>();
        private Map<String, String> tweakFiles = new HashMap<String, String>();
        private Map<String, Integer> numbers = new HashMap<String, Integer>();
        private Map<String, int[]> arrayEntries = new HashMap<String, int[]>();
        private List<StaticPokemon> staticPokemon = new ArrayList<StaticPokemon>();

        private RomEntry() {
        }

        private int getInt(String key) {
            if (!this.numbers.containsKey(key)) {
                this.numbers.put(key, 0);
            }
            return this.numbers.get(key);
        }

        private String getString(String key) {
            if (!this.strings.containsKey(key)) {
                this.strings.put(key, "");
            }
            return this.strings.get(key);
        }
    }

    public static class Factory
    extends RomHandler.Factory {
        @Override
        public Gen4RomHandler create(Random random, PrintStream logStream) {
            return new Gen4RomHandler(random, logStream);
        }

        @Override
        public boolean isLoadable(String filename) {
            return Gen4RomHandler.detectNDSRomInner(AbstractDSRomHandler.getROMCodeFromFile(filename));
        }
    }
}

