/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.GFXFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RomFunctions;
import com.dabomstew.pkrandom.constants.Gen3Constants;
import com.dabomstew.pkrandom.constants.GlobalConstants;
import com.dabomstew.pkrandom.exceptions.RandomizationException;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.EvolutionType;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.romhandlers.AbstractGBRomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import compressors.DSDecmp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.CRC32;

public class Gen3RomHandler
extends AbstractGBRomHandler {
    private static List<RomEntry> roms;
    private Pokemon[] pokes;
    private Pokemon[] pokesInternal;
    private List<Pokemon> pokemonList;
    private int numRealPokemon;
    private Move[] moves;
    private boolean jamboMovesetHack;
    private RomEntry romEntry;
    private boolean havePatchedObedience;
    public String[] tb;
    public Map<String, Byte> d;
    private String[] abilityNames;
    private String[] itemNames;
    private boolean mapLoadingDone;
    private List<Integer> itemOffs;
    private String[][] mapNames;
    private boolean isRomHack;
    private int[] internalToPokedex;
    private int[] pokedexToInternal;
    private int pokedexCount;
    private String[] pokeNames;
    private ItemList allowedItems;
    private ItemList nonBadItems;
    private RomFunctions.StringSizeDeterminer ssd = new RomFunctions.StringSizeDeterminer(){

        @Override
        public int lengthFor(String encodedText) {
            return Gen3RomHandler.this.translateString(encodedText).length;
        }
    };

    public Gen3RomHandler(Random random) {
        super(random, null);
    }

    public Gen3RomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    private static void loadROMInfo() {
        roms = new ArrayList<RomEntry>();
        RomEntry current = null;
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig("gen3_offsets.ini"), "UTF-8");
            while (sc.hasNextLine()) {
                TMOrMTTextEntry tte;
                int c;
                int[] offs;
                String q = sc.nextLine().trim();
                if (q.contains("//")) {
                    q = q.substring(0, q.indexOf("//")).trim();
                }
                if (q.isEmpty()) continue;
                if (q.startsWith("[") && q.endsWith("]")) {
                    current = new RomEntry();
                    current.name = q.substring(1, q.length() - 1);
                    roms.add(current);
                    continue;
                }
                String[] r = q.split("=", 2);
                if (r.length == 1) {
                    System.err.println("invalid entry " + q);
                    continue;
                }
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                r[1] = r[1].trim();
                if (r[0].equals("StaticPokemon[]")) {
                    if (r[1].startsWith("[") && r[1].endsWith("]")) {
                        String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                        offs = new int[offsets.length];
                        c = 0;
                        for (String off : offsets) {
                            offs[c++] = Gen3RomHandler.parseRIInt(off);
                        }
                        current.staticPokemon.add(new StaticPokemon(offs));
                        continue;
                    }
                    int offs2 = Gen3RomHandler.parseRIInt(r[1]);
                    current.staticPokemon.add(new StaticPokemon(offs2));
                    continue;
                }
                if (r[0].equals("TMText[]")) {
                    if (!r[1].startsWith("[") || !r[1].endsWith("]")) continue;
                    String[] parts = r[1].substring(1, r[1].length() - 1).split(",", 6);
                    tte = new TMOrMTTextEntry();
                    tte.number = Gen3RomHandler.parseRIInt(parts[0]);
                    tte.mapBank = Gen3RomHandler.parseRIInt(parts[1]);
                    tte.mapNumber = Gen3RomHandler.parseRIInt(parts[2]);
                    tte.personNum = Gen3RomHandler.parseRIInt(parts[3]);
                    tte.offsetInScript = Gen3RomHandler.parseRIInt(parts[4]);
                    tte.template = parts[5];
                    tte.isMoveTutor = false;
                    current.tmmtTexts.add(tte);
                    continue;
                }
                if (r[0].equals("MoveTutorText[]")) {
                    if (!r[1].startsWith("[") || !r[1].endsWith("]")) continue;
                    String[] parts = r[1].substring(1, r[1].length() - 1).split(",", 6);
                    tte = new TMOrMTTextEntry();
                    tte.number = Gen3RomHandler.parseRIInt(parts[0]);
                    tte.mapBank = Gen3RomHandler.parseRIInt(parts[1]);
                    tte.mapNumber = Gen3RomHandler.parseRIInt(parts[2]);
                    tte.personNum = Gen3RomHandler.parseRIInt(parts[3]);
                    tte.offsetInScript = Gen3RomHandler.parseRIInt(parts[4]);
                    tte.template = parts[5];
                    tte.isMoveTutor = true;
                    current.tmmtTexts.add(tte);
                    continue;
                }
                if (r[0].equals("Game")) {
                    current.romCode = r[1];
                    continue;
                }
                if (r[0].equals("Version")) {
                    current.version = Gen3RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].equals("Type")) {
                    if (r[1].equalsIgnoreCase("Ruby")) {
                        current.romType = 0;
                        continue;
                    }
                    if (r[1].equalsIgnoreCase("Sapp")) {
                        current.romType = 1;
                        continue;
                    }
                    if (r[1].equalsIgnoreCase("Em")) {
                        current.romType = 2;
                        continue;
                    }
                    if (r[1].equalsIgnoreCase("FRLG")) {
                        current.romType = 3;
                        continue;
                    }
                    System.err.println("unrecognised rom type: " + r[1]);
                    continue;
                }
                if (r[0].equals("TableFile")) {
                    current.tableFile = r[1];
                    continue;
                }
                if (r[0].equals("CopyStaticPokemon")) {
                    int csp = Gen3RomHandler.parseRIInt(r[1]);
                    current.copyStaticPokemon = csp > 0;
                    continue;
                }
                if (r[0].equals("CopyFrom")) {
                    for (RomEntry otherEntry : roms) {
                        boolean cTT;
                        if (!r[1].equalsIgnoreCase(otherEntry.name)) continue;
                        current.arrayEntries.putAll(otherEntry.arrayEntries);
                        current.entries.putAll(otherEntry.entries);
                        boolean bl = cTT = current.getValue("CopyTMText") == 1;
                        if (current.copyStaticPokemon) {
                            current.staticPokemon.addAll(otherEntry.staticPokemon);
                            current.entries.put("StaticPokemonSupport", 1);
                        } else {
                            current.entries.put("StaticPokemonSupport", 0);
                        }
                        if (cTT) {
                            current.tmmtTexts.addAll(otherEntry.tmmtTexts);
                        }
                        current.tableFile = otherEntry.tableFile;
                    }
                    continue;
                }
                if (r[1].startsWith("[") && r[1].endsWith("]")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    if (offsets.length == 1 && offsets[0].trim().isEmpty()) {
                        current.arrayEntries.put(r[0], new int[0]);
                        continue;
                    }
                    offs = new int[offsets.length];
                    c = 0;
                    for (String off : offsets) {
                        offs[c++] = Gen3RomHandler.parseRIInt(off);
                    }
                    current.arrayEntries.put(r[0], offs);
                    continue;
                }
                int offs3 = Gen3RomHandler.parseRIInt(r[1]);
                current.entries.put(r[0], offs3);
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static int parseRIInt(String off) {
        int radix = 10;
        if ((off = off.trim().toLowerCase()).startsWith("0x") || off.startsWith("&h")) {
            radix = 16;
            off = off.substring(2);
        }
        try {
            return Integer.parseInt(off, radix);
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid base " + radix + "number " + off);
            return 0;
        }
    }

    private void loadTextTable(String filename) {
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig(filename + ".tbl"), "UTF-8");
            while (sc.hasNextLine()) {
                String q = sc.nextLine();
                if (q.trim().isEmpty()) continue;
                String[] r = q.split("=", 2);
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                this.tb[Integer.parseInt((String)r[0], (int)16)] = r[1];
                this.d.put(r[1], (byte)Integer.parseInt(r[0], 16));
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean detectRom(byte[] rom) {
        return Gen3RomHandler.detectRomInner(rom, rom.length);
    }

    private static boolean detectRomInner(byte[] rom, int romSize) {
        if (romSize != 0x800000 && romSize != 0x1000000 && romSize != 0x2000000) {
            return false;
        }
        if (Gen3RomHandler.romName(rom, "YJencrypted")) {
            rom[172] = 66;
            rom[173] = 80;
            rom[174] = 69;
            rom[175] = 84;
            rom[189] = 102;
        }
        if (Gen3RomHandler.find(rom, "0348048009E00000FFFF0000") == -1) {
            return false;
        }
        if (Gen3RomHandler.find(rom, "80180068890B091808687047") == -1) {
            return false;
        }
        if (Gen3RomHandler.findMultiple(rom, "0448814208D0481C0004000C05E00000").size() != 3) {
            return false;
        }
        for (RomEntry re : roms) {
            if (!Gen3RomHandler.romCode(rom, re.romCode) || (rom[188] & 0xFF) != re.version) continue;
            return true;
        }
        return false;
    }

    @Override
    public void loadedRom() {
        for (RomEntry re : roms) {
            if (!Gen3RomHandler.romCode(this.rom, re.romCode) || (this.rom[188] & 0xFF) != re.version) continue;
            this.romEntry = new RomEntry(re);
            break;
        }
        this.tb = new String[256];
        this.d = new HashMap<String, Byte>();
        this.isRomHack = false;
        this.jamboMovesetHack = false;
        List<Integer> pokedexOrderPrefixes = Gen3RomHandler.findMultiple(this.rom, "0448814208D0481C0004000C05E00000");
        this.romEntry.entries.put("PokedexOrder", this.readPointer(pokedexOrderPrefixes.get(1) + 16));
        if (this.romEntry.romType == 0 || this.romEntry.romType == 1) {
            int baseNomOffset = Gen3RomHandler.find(this.rom, "30B50025084CC8F7");
            this.romEntry.entries.put("PokemonNames", this.readPointer(baseNomOffset - 4));
            this.romEntry.entries.put("FrontSprites", this.readPointer(this.findPointerPrefixAndSuffix("05E0", "1068191C")));
            this.romEntry.entries.put("PokemonPalettes", this.readPointer(this.findPointerPrefixAndSuffix("04D90148006817E0", "080C064A11404840")));
        } else {
            this.romEntry.entries.put("PokemonNames", this.readPointer(324));
            this.romEntry.entries.put("MoveNames", this.readPointer(328));
            this.romEntry.entries.put("AbilityNames", this.readPointer(448));
            this.romEntry.entries.put("ItemData", this.readPointer(456));
            this.romEntry.entries.put("MoveData", this.readPointer(460));
            this.romEntry.entries.put("PokemonStats", this.readPointer(444));
            this.romEntry.entries.put("FrontSprites", this.readPointer(296));
            this.romEntry.entries.put("PokemonPalettes", this.readPointer(304));
            this.romEntry.entries.put("MoveTutorCompatibility", this.romEntry.getValue("MoveTutorData") + this.romEntry.getValue("MoveTutorMoves") * 2);
        }
        this.loadTextTable(this.romEntry.tableFile);
        if (this.romEntry.romCode.equals("BPRE") && this.romEntry.version == 0) {
            this.basicBPRE10HackSupport();
        }
        this.loadPokemonNames();
        this.loadPokedex();
        this.loadPokemonStats();
        this.constructPokemonList();
        this.populateEvolutions();
        this.loadMoves();
        int baseWPOffset = Gen3RomHandler.findMultiple(this.rom, "0348048009E00000FFFF0000").get(0);
        this.romEntry.entries.put("WildPokemon", this.readPointer(baseWPOffset + 12));
        int baseMapsOffset = Gen3RomHandler.findMultiple(this.rom, "80180068890B091808687047").get(0);
        this.romEntry.entries.put("MapHeaders", this.readPointer(baseMapsOffset + 12));
        this.determineMapBankSizes();
        if (this.romEntry.romType == 3) {
            int baseMLOffset = Gen3RomHandler.find(this.rom, "AC470000AE470000B0470000");
            this.romEntry.entries.put("MapLabels", this.readPointer(baseMLOffset + 12));
        } else {
            int baseMLOffset = Gen3RomHandler.find(this.rom, "C078288030BC01BC00470000");
            this.romEntry.entries.put("MapLabels", this.readPointer(baseMLOffset + 12));
        }
        this.mapLoadingDone = false;
        this.loadAbilityNames();
        this.loadItemNames();
        this.allowedItems = Gen3Constants.allowedItems.copy();
        this.nonBadItems = Gen3Constants.nonBadItems.copy();
    }

    private int findPointerPrefixAndSuffix(String prefix, String suffix) {
        if (prefix.length() % 2 != 0 || suffix.length() % 2 != 0) {
            return -1;
        }
        byte[] searchPref = new byte[prefix.length() / 2];
        for (int i = 0; i < searchPref.length; ++i) {
            searchPref[i] = (byte)Integer.parseInt(prefix.substring(i * 2, i * 2 + 2), 16);
        }
        byte[] searchSuff = new byte[suffix.length() / 2];
        for (int i = 0; i < searchSuff.length; ++i) {
            searchSuff[i] = (byte)Integer.parseInt(suffix.substring(i * 2, i * 2 + 2), 16);
        }
        if (searchPref.length >= searchSuff.length) {
            List<Integer> offsets = RomFunctions.search(this.rom, searchPref);
            if (offsets.size() == 0) {
                return -1;
            }
            for (int prefOffset : offsets) {
                int ptrOffset;
                int pointerValue;
                if (prefOffset + 4 + searchSuff.length > this.rom.length || (pointerValue = this.readPointer(ptrOffset = prefOffset + searchPref.length)) < 0 || pointerValue >= this.rom.length) continue;
                boolean suffixMatch = true;
                for (int i = 0; i < searchSuff.length; ++i) {
                    if (this.rom[ptrOffset + 4 + i] == searchSuff[i]) continue;
                    suffixMatch = false;
                    break;
                }
                if (!suffixMatch) continue;
                return ptrOffset;
            }
            return -1;
        }
        List<Integer> offsets = RomFunctions.search(this.rom, searchSuff);
        if (offsets.size() == 0) {
            return -1;
        }
        for (int suffOffset : offsets) {
            int ptrOffset;
            int pointerValue;
            if (suffOffset - 4 - searchPref.length < 0 || (pointerValue = this.readPointer(ptrOffset = suffOffset - 4)) < 0 || pointerValue >= this.rom.length) continue;
            boolean prefixMatch = true;
            for (int i = 0; i < searchPref.length; ++i) {
                if (this.rom[ptrOffset - searchPref.length + i] == searchPref[i]) continue;
                prefixMatch = false;
                break;
            }
            if (!prefixMatch) continue;
            return ptrOffset;
        }
        return -1;
    }

    private void basicBPRE10HackSupport() {
        if (this.basicBPRE10HackDetection()) {
            int nameLength;
            int pointerToPokes;
            int numPokes;
            int trOffset;
            int pokeDataType;
            int descStrLen;
            int descPointer;
            int movesetPtr;
            int movesetsTable;
            int nameOffset;
            int nameStrLen;
            this.isRomHack = true;
            int iPokemonCount = 0;
            int namesOffset = this.romEntry.getValue("PokemonNames");
            int nameLen = this.romEntry.getValue("PokemonNameLength");
            while ((nameStrLen = this.lengthOfStringAt(nameOffset = namesOffset + (iPokemonCount + 1) * nameLen)) > 0 && nameStrLen < nameLen && this.rom[nameOffset] != 0) {
                ++iPokemonCount;
            }
            String lastName = this.readVariableLengthString(namesOffset + iPokemonCount * nameLen);
            if (lastName.equals("?") || lastName.equals("-")) {
                --iPokemonCount;
            }
            if (this.readLong(256800) == 1191725336) {
                int firstRoutinePtr = this.readPointer(256900);
                movesetsTable = this.readPointer(firstRoutinePtr + 75);
                this.jamboMovesetHack = true;
            } else {
                movesetsTable = this.readPointer(256636);
                this.jamboMovesetHack = false;
            }
            this.romEntry.entries.put("PokemonMovesets", movesetsTable);
            while (iPokemonCount >= 0 && ((movesetPtr = this.readPointer(movesetsTable + iPokemonCount * 4)) < 0 || movesetPtr >= this.rom.length)) {
                --iPokemonCount;
            }
            int pdOffset = this.romEntry.getValue("PokedexOrder");
            for (int i = 1; i <= iPokemonCount; ++i) {
                int pdEntry = this.readWord(pdOffset + (i - 1) * 2);
                if (pdEntry <= 1023) continue;
                iPokemonCount = i - 1;
                break;
            }
            this.romEntry.entries.put("PokemonCount", iPokemonCount);
            this.romEntry.entries.put("PokemonTMHMCompat", this.readPointer(277608));
            this.romEntry.entries.put("PokemonEvolutions", this.readPointer(274284));
            this.romEntry.entries.put("MoveTutorCompatibility", this.readPointer(1182768));
            int descsTable = this.readPointer(939072);
            this.romEntry.entries.put("MoveDescriptions", descsTable);
            int trainersTable = this.readPointer(64512);
            this.romEntry.entries.put("TrainerData", trainersTable);
            int moveCount = 0;
            while ((descPointer = this.readPointer(descsTable + moveCount * 4)) >= 0 && descPointer < this.rom.length && (descStrLen = this.lengthOfStringAt(descPointer)) > 0 && descStrLen < 100) {
                ++moveCount;
            }
            this.romEntry.entries.put("MoveCount", moveCount);
            int trainerCount = 1;
            int tEntryLen = this.romEntry.getValue("TrainerEntrySize");
            int tNameLen = this.romEntry.getValue("TrainerNameLength");
            while ((pokeDataType = this.rom[trOffset = trainersTable + tEntryLen * trainerCount] & 0xFF) < 4 && (numPokes = this.rom[trOffset + (tEntryLen - 8)] & 0xFF) != 0 && numPokes <= 6 && (pointerToPokes = this.readPointer(trOffset + (tEntryLen - 4))) >= 0 && pointerToPokes < this.rom.length && (nameLength = this.lengthOfStringAt(trOffset + 4)) < tNameLen) {
                ++trainerCount;
            }
            this.romEntry.entries.put("TrainerCount", trainerCount);
            this.romEntry.entries.put("StaticPokemonSupport", 0);
            this.romEntry.staticPokemon.clear();
            this.romEntry.tmmtTexts.clear();
        }
    }

    private boolean basicBPRE10HackDetection() {
        if (this.rom.length != 0x1000000) {
            return true;
        }
        CRC32 checksum = new CRC32();
        checksum.update(this.rom);
        long csum = checksum.getValue();
        return csum != 3716707868L;
    }

    @Override
    public void savingRom() {
        this.savePokemonStats();
        this.saveMoves();
    }

    private void loadPokedex() {
        int pdOffset = this.romEntry.getValue("PokedexOrder");
        int numInternalPokes = this.romEntry.getValue("PokemonCount");
        int maxPokedex = 0;
        this.internalToPokedex = new int[numInternalPokes + 1];
        this.pokedexToInternal = new int[numInternalPokes + 1];
        for (int i = 1; i <= numInternalPokes; ++i) {
            int dexEntry = this.readWord(this.rom, pdOffset + (i - 1) * 2);
            if (dexEntry == 0) continue;
            this.internalToPokedex[i] = dexEntry;
            if (this.pokedexToInternal[dexEntry] == 0) {
                this.pokedexToInternal[dexEntry] = i;
            }
            maxPokedex = Math.max(maxPokedex, dexEntry);
        }
        if (maxPokedex == 411) {
            int i;
            int offs = this.romEntry.getValue("PokemonStats");
            int usedSlots = 0;
            for (i = 0; i < 25; ++i) {
                int pokeSlot = 252 + i;
                int pokeOffs = offs + pokeSlot * 28;
                String lowerName = this.pokeNames[pokeSlot].toLowerCase();
                if (!(this.matches(this.rom, pokeOffs, Gen3Constants.emptyPokemonSig) || lowerName.contains("unused") || lowerName.equals("?") || lowerName.equals("-"))) {
                    this.pokedexToInternal[386 + ++usedSlots] = pokeSlot;
                    this.internalToPokedex[pokeSlot] = 386 + usedSlots;
                    continue;
                }
                this.internalToPokedex[pokeSlot] = 0;
            }
            for (i = usedSlots + 1; i <= 25; ++i) {
                this.pokedexToInternal[386 + i] = 0;
            }
            if (usedSlots > 0) {
                this.isRomHack = true;
            }
            this.pokedexCount = 386 + usedSlots;
        } else {
            this.isRomHack = true;
            this.pokedexCount = maxPokedex;
        }
    }

    private void constructPokemonList() {
        if (!this.isRomHack) {
            this.pokemonList = Arrays.asList(this.pokes);
        } else {
            this.pokemonList = new ArrayList<Pokemon>();
            this.pokemonList.add(null);
            for (int i = 1; i < this.pokes.length; ++i) {
                String lowerName;
                Pokemon pk = this.pokes[i];
                if (pk == null || (lowerName = pk.name.toLowerCase()).contains("unused") || lowerName.equals("?")) continue;
                this.pokemonList.add(pk);
            }
        }
        this.numRealPokemon = this.pokemonList.size() - 1;
    }

    private void loadPokemonStats() {
        this.pokes = new Pokemon[this.pokedexCount + 1];
        int numInternalPokes = this.romEntry.getValue("PokemonCount");
        this.pokesInternal = new Pokemon[numInternalPokes + 1];
        int offs = this.romEntry.getValue("PokemonStats");
        for (int i = 1; i <= numInternalPokes; ++i) {
            Pokemon pk = new Pokemon();
            pk.name = this.pokeNames[i];
            pk.number = this.internalToPokedex[i];
            if (pk.number != 0) {
                this.pokes[pk.number] = pk;
            }
            this.pokesInternal[i] = pk;
            int pkoffs = offs + i * 28;
            this.loadBasicPokeStats(pk, pkoffs);
        }
    }

    private void savePokemonStats() {
        int offs = this.romEntry.getValue("PokemonNames");
        int nameLen = this.romEntry.getValue("PokemonNameLength");
        int offs2 = this.romEntry.getValue("PokemonStats");
        int numInternalPokes = this.romEntry.getValue("PokemonCount");
        for (int i = 1; i <= numInternalPokes; ++i) {
            Pokemon pk = this.pokesInternal[i];
            int stringOffset = offs + i * nameLen;
            this.writeFixedLengthString(pk.name, stringOffset, nameLen);
            this.saveBasicPokeStats(pk, offs2 + i * 28);
        }
        this.writeEvolutions();
    }

    private void loadMoves() {
        int moveCount = this.romEntry.getValue("MoveCount");
        this.moves = new Move[moveCount + 1];
        int offs = this.romEntry.getValue("MoveData");
        int nameoffs = this.romEntry.getValue("MoveNames");
        int namelen = this.romEntry.getValue("MoveNameLength");
        for (int i = 1; i <= moveCount; ++i) {
            this.moves[i] = new Move();
            this.moves[i].name = this.readFixedLengthString(nameoffs + i * namelen, namelen);
            this.moves[i].number = i;
            this.moves[i].internalId = i;
            this.moves[i].effectIndex = this.rom[offs + i * 12] & 0xFF;
            this.moves[i].hitratio = (this.rom[offs + i * 12 + 3] & 0xFF) + 0;
            this.moves[i].power = this.rom[offs + i * 12 + 1] & 0xFF;
            this.moves[i].pp = this.rom[offs + i * 12 + 4] & 0xFF;
            this.moves[i].type = Gen3Constants.typeTable[this.rom[offs + i * 12 + 2]];
            if (GlobalConstants.normalMultihitMoves.contains(i)) {
                this.moves[i].hitCount = 3.0;
                continue;
            }
            if (GlobalConstants.doubleHitMoves.contains(i)) {
                this.moves[i].hitCount = 2.0;
                continue;
            }
            if (i != 167) continue;
            this.moves[i].hitCount = 2.71;
        }
    }

    private void saveMoves() {
        int moveCount = this.romEntry.getValue("MoveCount");
        int offs = this.romEntry.getValue("MoveData");
        for (int i = 1; i <= moveCount; ++i) {
            this.rom[offs + i * 12] = (byte)this.moves[i].effectIndex;
            this.rom[offs + i * 12 + 1] = (byte)this.moves[i].power;
            this.rom[offs + i * 12 + 2] = Gen3Constants.typeToByte(this.moves[i].type);
            int hitratio = (int)Math.round(this.moves[i].hitratio);
            if (hitratio < 0) {
                hitratio = 0;
            }
            if (hitratio > 100) {
                hitratio = 100;
            }
            this.rom[offs + i * 12 + 3] = (byte)hitratio;
            this.rom[offs + i * 12 + 4] = (byte)this.moves[i].pp;
        }
    }

    @Override
    public List<Move> getMoves() {
        return Arrays.asList(this.moves);
    }

    private void loadBasicPokeStats(Pokemon pkmn, int offset) {
        int item2;
        pkmn.hp = this.rom[offset + 0] & 0xFF;
        pkmn.attack = this.rom[offset + 1] & 0xFF;
        pkmn.defense = this.rom[offset + 2] & 0xFF;
        pkmn.speed = this.rom[offset + 3] & 0xFF;
        pkmn.spatk = this.rom[offset + 4] & 0xFF;
        pkmn.spdef = this.rom[offset + 5] & 0xFF;
        pkmn.primaryType = Gen3Constants.typeTable[this.rom[offset + 6] & 0xFF];
        pkmn.secondaryType = Gen3Constants.typeTable[this.rom[offset + 7] & 0xFF];
        if (pkmn.secondaryType == pkmn.primaryType) {
            pkmn.secondaryType = null;
        }
        pkmn.catchRate = this.rom[offset + 8] & 0xFF;
        pkmn.growthCurve = ExpCurve.fromByte(this.rom[offset + 19]);
        pkmn.ability1 = this.rom[offset + 22] & 0xFF;
        pkmn.ability2 = this.rom[offset + 23] & 0xFF;
        int item1 = this.readWord(offset + 12);
        if (item1 == (item2 = this.readWord(offset + 14))) {
            pkmn.guaranteedHeldItem = item1;
            pkmn.commonHeldItem = 0;
            pkmn.rareHeldItem = 0;
        } else {
            pkmn.guaranteedHeldItem = 0;
            pkmn.commonHeldItem = item1;
            pkmn.rareHeldItem = item2;
        }
        pkmn.darkGrassHeldItem = -1;
        pkmn.genderRatio = this.rom[offset + 16] & 0xFF;
    }

    private void saveBasicPokeStats(Pokemon pkmn, int offset) {
        this.rom[offset + 0] = (byte)pkmn.hp;
        this.rom[offset + 1] = (byte)pkmn.attack;
        this.rom[offset + 2] = (byte)pkmn.defense;
        this.rom[offset + 3] = (byte)pkmn.speed;
        this.rom[offset + 4] = (byte)pkmn.spatk;
        this.rom[offset + 5] = (byte)pkmn.spdef;
        this.rom[offset + 6] = Gen3Constants.typeToByte(pkmn.primaryType);
        this.rom[offset + 7] = pkmn.secondaryType == null ? this.rom[offset + 6] : Gen3Constants.typeToByte(pkmn.secondaryType);
        this.rom[offset + 8] = (byte)pkmn.catchRate;
        this.rom[offset + 19] = pkmn.growthCurve.toByte();
        this.rom[offset + 22] = (byte)pkmn.ability1;
        this.rom[offset + 23] = pkmn.ability2 == 0 ? (byte)pkmn.ability1 : (byte)pkmn.ability2;
        if (pkmn.guaranteedHeldItem > 0) {
            this.writeWord(offset + 12, pkmn.guaranteedHeldItem);
            this.writeWord(offset + 14, pkmn.guaranteedHeldItem);
        } else {
            this.writeWord(offset + 12, pkmn.commonHeldItem);
            this.writeWord(offset + 14, pkmn.rareHeldItem);
        }
        this.rom[offset + 16] = (byte)pkmn.genderRatio;
    }

    private void loadPokemonNames() {
        int offs = this.romEntry.getValue("PokemonNames");
        int nameLen = this.romEntry.getValue("PokemonNameLength");
        int numInternalPokes = this.romEntry.getValue("PokemonCount");
        this.pokeNames = new String[numInternalPokes + 1];
        for (int i = 1; i <= numInternalPokes; ++i) {
            this.pokeNames[i] = this.readFixedLengthString(offs + i * nameLen, nameLen);
        }
    }

    private String readString(int offset, int maxLength) {
        StringBuilder string = new StringBuilder();
        for (int c = 0; c < maxLength; ++c) {
            int currChar = this.rom[offset + c] & 0xFF;
            if (this.tb[currChar] != null) {
                string.append(this.tb[currChar]);
                continue;
            }
            if (currChar == 255) break;
            if (currChar == 253) {
                int nextChar = this.rom[offset + c + 1] & 0xFF;
                string.append("\\v" + String.format("%02X", nextChar));
                ++c;
                continue;
            }
            string.append("\\x" + String.format("%02X", currChar));
        }
        return string.toString();
    }

    private byte[] translateString(String text) {
        ArrayList<Byte> data = new ArrayList<Byte>();
        while (text.length() != 0) {
            int i;
            if (text.charAt(0) == '\\' && text.charAt(1) == 'x') {
                data.add((byte)Integer.parseInt(text.substring(2, 4), 16));
                text = text.substring(4);
                continue;
            }
            if (text.charAt(0) == '\\' && text.charAt(1) == 'v') {
                data.add((byte)-3);
                data.add((byte)Integer.parseInt(text.substring(2, 4), 16));
                text = text.substring(4);
                continue;
            }
            for (i = Math.max(0, 4 - text.length()); !this.d.containsKey(text.substring(0, 4 - i)) && i != 4; ++i) {
            }
            if (i == 4) {
                text = text.substring(1);
                continue;
            }
            data.add(this.d.get(text.substring(0, 4 - i)));
            text = text.substring(4 - i);
        }
        byte[] ret = new byte[data.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Byte)data.get(i);
        }
        return ret;
    }

    private String readFixedLengthString(int offset, int length) {
        return this.readString(offset, length);
    }

    public String readVariableLengthString(int offset) {
        return this.readString(offset, Integer.MAX_VALUE);
    }

    private void writeFixedLengthString(String str, int offset, int length) {
        byte[] translated = this.translateString(str);
        int len = Math.min(translated.length, length);
        System.arraycopy(translated, 0, this.rom, offset, len);
        if (len < length) {
            this.rom[offset + len] = -1;
            ++len;
        }
        while (len < length) {
            this.rom[offset + len] = 0;
            ++len;
        }
    }

    private void writeVariableLengthString(String str, int offset) {
        byte[] translated = this.translateString(str);
        System.arraycopy(translated, 0, this.rom, offset, translated.length);
        this.rom[offset + translated.length] = -1;
    }

    private int lengthOfStringAt(int offset) {
        int len = 0;
        while ((this.rom[offset + len++] & 0xFF) != 255) {
        }
        return len - 1;
    }

    public byte[] traduire(String str) {
        return this.translateString(str);
    }

    private static boolean romName(byte[] rom, String name) {
        try {
            int sigOffset = 160;
            byte[] sigBytes = name.getBytes("US-ASCII");
            for (int i = 0; i < sigBytes.length; ++i) {
                if (rom[sigOffset + i] == sigBytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    private static boolean romCode(byte[] rom, String codeToCheck) {
        try {
            int sigOffset = 172;
            byte[] sigBytes = codeToCheck.getBytes("US-ASCII");
            for (int i = 0; i < sigBytes.length; ++i) {
                if (rom[sigOffset + i] == sigBytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    private int readPointer(int offset) {
        return this.readLong(offset) - 0x8000000;
    }

    private int readLong(int offset) {
        return (this.rom[offset] & 0xFF) + ((this.rom[offset + 1] & 0xFF) << 8) + ((this.rom[offset + 2] & 0xFF) << 16) + ((this.rom[offset + 3] & 0xFF) << 24);
    }

    private void writePointer(int offset, int pointer) {
        this.writeLong(offset, pointer + 0x8000000);
    }

    private void writeLong(int offset, int value) {
        this.rom[offset] = (byte)(value & 0xFF);
        this.rom[offset + 1] = (byte)(value >> 8 & 0xFF);
        this.rom[offset + 2] = (byte)(value >> 16 & 0xFF);
        this.rom[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    @Override
    public List<Pokemon> getStarters() {
        ArrayList<Pokemon> starters = new ArrayList<Pokemon>();
        int baseOffset = this.romEntry.getValue("StarterPokemon");
        if (this.romEntry.romType == 0 || this.romEntry.romType == 1 || this.romEntry.romType == 2) {
            Pokemon starter1 = this.pokesInternal[this.readWord(baseOffset)];
            Pokemon starter2 = this.pokesInternal[this.readWord(baseOffset + 2)];
            Pokemon starter3 = this.pokesInternal[this.readWord(baseOffset + 4)];
            starters.add(starter1);
            starters.add(starter2);
            starters.add(starter3);
        } else {
            Pokemon starter1 = this.pokesInternal[this.readWord(baseOffset)];
            Pokemon starter2 = this.pokesInternal[this.readWord(baseOffset + 515)];
            Pokemon starter3 = this.pokesInternal[this.readWord(baseOffset + 461)];
            starters.add(starter1);
            starters.add(starter2);
            starters.add(starter3);
        }
        return starters;
    }

    @Override
    public boolean setStarters(List<Pokemon> newStarters) {
        if (newStarters.size() != 3) {
            return false;
        }
        this.attemptObedienceEvolutionPatches();
        int baseOffset = this.romEntry.getValue("StarterPokemon");
        int starter0 = this.pokedexToInternal[newStarters.get((int)0).number];
        int starter1 = this.pokedexToInternal[newStarters.get((int)1).number];
        int starter2 = this.pokedexToInternal[newStarters.get((int)2).number];
        if (this.romEntry.romType == 0 || this.romEntry.romType == 1 || this.romEntry.romType == 2) {
            this.writeWord(baseOffset, starter0);
            this.writeWord(baseOffset + 2, starter1);
            this.writeWord(baseOffset + 4, starter2);
        } else {
            this.writeWord(baseOffset, starter0);
            this.writeWord(baseOffset + 5, starter1);
            this.writeWord(baseOffset + 515, starter1);
            this.writeWord(baseOffset + 515 + 5, starter2);
            this.writeWord(baseOffset + 461, starter2);
            this.writeWord(baseOffset + 461 + 5, starter0);
            if (this.romEntry.romCode.charAt(3) != 'J' && this.romEntry.romCode.charAt(3) != 'B') {
                this.writeFRLGStarterText(this.pokes[1].name, newStarters.get(0), "you want to go with\\nthe ");
                this.writeFRLGStarterText(this.pokes[4].name, newStarters.get(1), "you\u2019re claiming the\\n");
                this.writeFRLGStarterText(this.pokes[7].name, newStarters.get(2), "you\u2019ve decided on the\\n");
            }
        }
        return true;
    }

    @Override
    public List<Integer> getStarterHeldItems() {
        ArrayList<Integer> sHeldItems = new ArrayList<Integer>();
        if (this.romEntry.romType == 3) {
            int baseOffset = this.romEntry.getValue("StarterPokemon");
            sHeldItems.add(this.readWord(baseOffset + 218));
        } else {
            int baseOffset = this.romEntry.getValue("StarterItems");
            int i1 = this.rom[baseOffset] & 0xFF;
            int i2 = this.rom[baseOffset + 2] & 0xFF;
            if (i2 == 0) {
                sHeldItems.add(i1);
            } else {
                sHeldItems.add(i2 + 255);
            }
        }
        return sHeldItems;
    }

    @Override
    public void setStarterHeldItems(List<Integer> items) {
        if (items.size() != 1) {
            return;
        }
        int item = items.get(0);
        if (this.romEntry.romType == 3) {
            int baseOffset = this.romEntry.getValue("StarterPokemon");
            this.writeWord(baseOffset + 218, item);
        } else {
            int baseOffset = this.romEntry.getValue("StarterItems");
            if (item <= 255) {
                this.rom[baseOffset] = (byte)item;
                this.rom[baseOffset + 2] = 0;
                this.rom[baseOffset + 3] = 50;
            } else {
                this.rom[baseOffset] = -1;
                this.rom[baseOffset + 2] = (byte)(item - 255);
                this.rom[baseOffset + 3] = 50;
            }
        }
    }

    private void writeFRLGStarterText(String findName, Pokemon pkmn, String oakText) {
        List<Integer> foundTexts = RomFunctions.search(this.rom, this.traduire(findName));
        if (foundTexts.size() > 0) {
            String pokeType;
            int offset = foundTexts.get(0);
            String pokeName = pkmn.name;
            String string = pokeType = pkmn.primaryType == null ? "???" : pkmn.primaryType.toString();
            if (pokeType.equals("NORMAL") && pkmn.secondaryType != null) {
                pokeType = pkmn.secondaryType.toString();
            }
            String speech = pokeName + " is your choice.\\pSo, \\v01, " + oakText + pokeType + " POK\u00e9MON " + pokeName + "?";
            this.writeFixedLengthString(speech, offset, this.lengthOfStringAt(offset) + 1);
        }
    }

    @Override
    public List<EncounterSet> getEncounters(boolean useTimeOfDay) {
        if (!this.mapLoadingDone) {
            this.preprocessMaps();
            this.mapLoadingDone = true;
        }
        int startOffs = this.romEntry.getValue("WildPokemon");
        ArrayList<EncounterSet> encounterAreas = new ArrayList<EncounterSet>();
        TreeSet<Integer> seenOffsets = new TreeSet<Integer>();
        int offs = startOffs;
        while (true) {
            int bank = this.rom[offs] & 0xFF;
            int map = this.rom[offs + 1] & 0xFF;
            if (bank == 255 && map == 255) break;
            String mapName = this.mapNames[bank][map];
            int grassPokes = this.readPointer(offs + 4);
            int waterPokes = this.readPointer(offs + 8);
            int treePokes = this.readPointer(offs + 12);
            int fishPokes = this.readPointer(offs + 16);
            if (grassPokes >= 0 && grassPokes < this.rom.length && this.rom[grassPokes] != 0 && !seenOffsets.contains(this.readPointer(grassPokes + 4))) {
                encounterAreas.add(this.readWildArea(grassPokes, 12, mapName + " Grass/Cave"));
                seenOffsets.add(this.readPointer(grassPokes + 4));
            }
            if (waterPokes >= 0 && waterPokes < this.rom.length && this.rom[waterPokes] != 0 && !seenOffsets.contains(this.readPointer(waterPokes + 4))) {
                encounterAreas.add(this.readWildArea(waterPokes, 5, mapName + " Surfing"));
                seenOffsets.add(this.readPointer(waterPokes + 4));
            }
            if (treePokes >= 0 && treePokes < this.rom.length && this.rom[treePokes] != 0 && !seenOffsets.contains(this.readPointer(treePokes + 4))) {
                encounterAreas.add(this.readWildArea(treePokes, 5, mapName + " Rock Smash"));
                seenOffsets.add(this.readPointer(treePokes + 4));
            }
            if (fishPokes >= 0 && fishPokes < this.rom.length && this.rom[fishPokes] != 0 && !seenOffsets.contains(this.readPointer(fishPokes + 4))) {
                encounterAreas.add(this.readWildArea(fishPokes, 10, mapName + " Fishing"));
                seenOffsets.add(this.readPointer(fishPokes + 4));
            }
            offs += 20;
        }
        if (this.romEntry.arrayEntries.containsKey("BattleTrappersBanned")) {
            int[] bannedAreas = (int[])this.romEntry.arrayEntries.get("BattleTrappersBanned");
            HashSet<Pokemon> battleTrappers = new HashSet<Pokemon>();
            for (Pokemon pk : this.getPokemon()) {
                if (!this.hasBattleTrappingAbility(pk)) continue;
                battleTrappers.add(pk);
            }
            for (Object areaIdx : (Object)bannedAreas) {
                ((EncounterSet)encounterAreas.get((int)areaIdx)).bannedPokemon.addAll(battleTrappers);
            }
        }
        return encounterAreas;
    }

    private boolean hasBattleTrappingAbility(Pokemon pokemon) {
        return pokemon != null && (GlobalConstants.battleTrappingAbilities.contains(pokemon.ability1) || GlobalConstants.battleTrappingAbilities.contains(pokemon.ability2));
    }

    private EncounterSet readWildArea(int offset, int numOfEntries, String setName) {
        EncounterSet thisSet = new EncounterSet();
        thisSet.rate = this.rom[offset];
        thisSet.displayName = setName;
        int dataOffset = this.readPointer(offset + 4);
        for (int i = 0; i < numOfEntries; ++i) {
            Encounter enc = new Encounter();
            enc.level = this.rom[dataOffset + i * 4];
            enc.maxLevel = this.rom[dataOffset + i * 4 + 1];
            enc.pokemon = this.pokesInternal[this.readWord(dataOffset + i * 4 + 2)];
            thisSet.encounters.add(enc);
        }
        return thisSet;
    }

    @Override
    public void setEncounters(boolean useTimeOfDay, List<EncounterSet> encounters) {
        this.attemptObedienceEvolutionPatches();
        int startOffs = this.romEntry.getValue("WildPokemon");
        Iterator<EncounterSet> encounterAreas = encounters.iterator();
        TreeSet<Integer> seenOffsets = new TreeSet<Integer>();
        int offs = startOffs;
        while (true) {
            int bank = this.rom[offs] & 0xFF;
            int map = this.rom[offs + 1] & 0xFF;
            if (bank == 255 && map == 255) break;
            int grassPokes = this.readPointer(offs + 4);
            int waterPokes = this.readPointer(offs + 8);
            int treePokes = this.readPointer(offs + 12);
            int fishPokes = this.readPointer(offs + 16);
            if (grassPokes >= 0 && grassPokes < this.rom.length && this.rom[grassPokes] != 0 && !seenOffsets.contains(this.readPointer(grassPokes + 4))) {
                this.writeWildArea(grassPokes, 12, encounterAreas.next());
                seenOffsets.add(this.readPointer(grassPokes + 4));
            }
            if (waterPokes >= 0 && waterPokes < this.rom.length && this.rom[waterPokes] != 0 && !seenOffsets.contains(this.readPointer(waterPokes + 4))) {
                this.writeWildArea(waterPokes, 5, encounterAreas.next());
                seenOffsets.add(this.readPointer(waterPokes + 4));
            }
            if (treePokes >= 0 && treePokes < this.rom.length && this.rom[treePokes] != 0 && !seenOffsets.contains(this.readPointer(treePokes + 4))) {
                this.writeWildArea(treePokes, 5, encounterAreas.next());
                seenOffsets.add(this.readPointer(treePokes + 4));
            }
            if (fishPokes >= 0 && fishPokes < this.rom.length && this.rom[fishPokes] != 0 && !seenOffsets.contains(this.readPointer(fishPokes + 4))) {
                this.writeWildArea(fishPokes, 10, encounterAreas.next());
                seenOffsets.add(this.readPointer(fishPokes + 4));
            }
            offs += 20;
        }
    }

    @Override
    public List<Pokemon> bannedForWildEncounters() {
        return Arrays.asList(this.pokes[201]);
    }

    @Override
    public List<Trainer> getTrainers() {
        int baseOffset = this.romEntry.getValue("TrainerData");
        int amount = this.romEntry.getValue("TrainerCount");
        int entryLen = this.romEntry.getValue("TrainerEntrySize");
        ArrayList<Trainer> theTrainers = new ArrayList<Trainer>();
        List<String> tcnames = this.getTrainerClassNames();
        for (int i = 1; i < amount; ++i) {
            TrainerPokemon thisPoke;
            int poke;
            int trOffset = baseOffset + i * entryLen;
            Trainer tr = new Trainer();
            tr.offset = trOffset;
            int trainerclass = this.rom[trOffset + 1] & 0xFF;
            tr.trainerclass = (this.rom[trOffset + 2] & 0x80) > 0 ? 1 : 0;
            int pokeDataType = this.rom[trOffset] & 0xFF;
            int numPokes = this.rom[trOffset + (entryLen - 8)] & 0xFF;
            int pointerToPokes = this.readPointer(trOffset + (entryLen - 4));
            tr.poketype = pokeDataType;
            tr.name = this.readVariableLengthString(trOffset + 4);
            tr.fullDisplayName = tcnames.get(trainerclass) + " " + tr.name;
            if (pokeDataType == 0) {
                for (poke = 0; poke < numPokes; ++poke) {
                    thisPoke = new TrainerPokemon();
                    thisPoke.AILevel = this.readWord(pointerToPokes + poke * 8);
                    thisPoke.level = this.readWord(pointerToPokes + poke * 8 + 2);
                    thisPoke.pokemon = this.pokesInternal[this.readWord(pointerToPokes + poke * 8 + 4)];
                    tr.pokemon.add(thisPoke);
                }
            } else if (pokeDataType == 2) {
                for (poke = 0; poke < numPokes; ++poke) {
                    thisPoke = new TrainerPokemon();
                    thisPoke.AILevel = this.readWord(pointerToPokes + poke * 8);
                    thisPoke.level = this.readWord(pointerToPokes + poke * 8 + 2);
                    thisPoke.pokemon = this.pokesInternal[this.readWord(pointerToPokes + poke * 8 + 4)];
                    thisPoke.heldItem = this.readWord(pointerToPokes + poke * 8 + 6);
                    tr.pokemon.add(thisPoke);
                }
            } else if (pokeDataType == 1) {
                for (poke = 0; poke < numPokes; ++poke) {
                    thisPoke = new TrainerPokemon();
                    thisPoke.AILevel = this.readWord(pointerToPokes + poke * 16);
                    thisPoke.level = this.readWord(pointerToPokes + poke * 16 + 2);
                    thisPoke.pokemon = this.pokesInternal[this.readWord(pointerToPokes + poke * 16 + 4)];
                    thisPoke.move1 = this.readWord(pointerToPokes + poke * 16 + 6);
                    thisPoke.move2 = this.readWord(pointerToPokes + poke * 16 + 8);
                    thisPoke.move3 = this.readWord(pointerToPokes + poke * 16 + 10);
                    thisPoke.move4 = this.readWord(pointerToPokes + poke * 16 + 12);
                    tr.pokemon.add(thisPoke);
                }
            } else if (pokeDataType == 3) {
                for (poke = 0; poke < numPokes; ++poke) {
                    thisPoke = new TrainerPokemon();
                    thisPoke.AILevel = this.readWord(pointerToPokes + poke * 16);
                    thisPoke.level = this.readWord(pointerToPokes + poke * 16 + 2);
                    thisPoke.pokemon = this.pokesInternal[this.readWord(pointerToPokes + poke * 16 + 4)];
                    thisPoke.heldItem = this.readWord(pointerToPokes + poke * 16 + 6);
                    thisPoke.move1 = this.readWord(pointerToPokes + poke * 16 + 8);
                    thisPoke.move2 = this.readWord(pointerToPokes + poke * 16 + 10);
                    thisPoke.move3 = this.readWord(pointerToPokes + poke * 16 + 12);
                    thisPoke.move4 = this.readWord(pointerToPokes + poke * 16 + 14);
                    tr.pokemon.add(thisPoke);
                }
            }
            theTrainers.add(tr);
        }
        if (this.romEntry.romType == 0 || this.romEntry.romType == 1) {
            Gen3Constants.trainerTagsRS(theTrainers, this.romEntry.romType);
        } else if (this.romEntry.romType == 2) {
            Gen3Constants.trainerTagsE(theTrainers);
        } else {
            Gen3Constants.trainerTagsFRLG(theTrainers);
        }
        return theTrainers;
    }

    @Override
    public void setTrainers(List<Trainer> trainerData) {
        int baseOffset = this.romEntry.getValue("TrainerData");
        int amount = this.romEntry.getValue("TrainerCount");
        int entryLen = this.romEntry.getValue("TrainerEntrySize");
        Iterator<Trainer> theTrainers = trainerData.iterator();
        int fso = this.romEntry.getValue("FreeSpace");
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        for (int i = 1; i < amount; ++i) {
            TrainerPokemon tp;
            int poke;
            int pointerToPokes;
            int trOffset = baseOffset + i * entryLen;
            Trainer tr = theTrainers.next();
            int oldPokeType = this.rom[trOffset] & 0xFF;
            int oldPokeCount = this.rom[trOffset + (entryLen - 8)] & 0xFF;
            int newPokeCount = tr.pokemon.size();
            int newDataSize = newPokeCount * ((tr.poketype & 1) == 1 ? 16 : 8);
            int oldDataSize = oldPokeCount * ((oldPokeType & 1) == 1 ? 16 : 8);
            this.rom[trOffset] = (byte)tr.poketype;
            this.rom[trOffset + (entryLen - 8)] = (byte)newPokeCount;
            if (newDataSize > oldDataSize) {
                int writeSpace = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, newDataSize, fso, true);
                if (writeSpace < fso) {
                    throw new RandomizerIOException("ROM is full");
                }
                this.writePointer(trOffset + (entryLen - 4), writeSpace);
                pointerToPokes = writeSpace;
            } else {
                pointerToPokes = this.readPointer(trOffset + (entryLen - 4));
            }
            Iterator<TrainerPokemon> pokes = tr.pokemon.iterator();
            if ((tr.poketype & 1) == 1) {
                for (poke = 0; poke < newPokeCount; ++poke) {
                    int movesStart;
                    tp = pokes.next();
                    this.writeWord(pointerToPokes + poke * 16, tp.AILevel);
                    this.writeWord(pointerToPokes + poke * 16 + 2, tp.level);
                    this.writeWord(pointerToPokes + poke * 16 + 4, this.pokedexToInternal[tp.pokemon.number]);
                    if ((tr.poketype & 2) == 2) {
                        this.writeWord(pointerToPokes + poke * 16 + 6, tp.heldItem);
                        movesStart = 8;
                    } else {
                        movesStart = 6;
                        this.writeWord(pointerToPokes + poke * 16 + 14, 0);
                    }
                    if (tp.resetMoves) {
                        int[] pokeMoves = RomFunctions.getMovesAtLevel(tp.pokemon, movesets, tp.level);
                        for (int m = 0; m < 4; ++m) {
                            this.writeWord(pointerToPokes + poke * 16 + movesStart + m * 2, pokeMoves[m]);
                        }
                        continue;
                    }
                    this.writeWord(pointerToPokes + poke * 16 + movesStart, tp.move1);
                    this.writeWord(pointerToPokes + poke * 16 + movesStart + 2, tp.move2);
                    this.writeWord(pointerToPokes + poke * 16 + movesStart + 4, tp.move3);
                    this.writeWord(pointerToPokes + poke * 16 + movesStart + 6, tp.move4);
                }
                continue;
            }
            for (poke = 0; poke < newPokeCount; ++poke) {
                tp = pokes.next();
                this.writeWord(pointerToPokes + poke * 8, tp.AILevel);
                this.writeWord(pointerToPokes + poke * 8 + 2, tp.level);
                this.writeWord(pointerToPokes + poke * 8 + 4, this.pokedexToInternal[tp.pokemon.number]);
                if ((tr.poketype & 2) == 2) {
                    this.writeWord(pointerToPokes + poke * 8 + 6, tp.heldItem);
                    continue;
                }
                this.writeWord(pointerToPokes + poke * 8 + 6, 0);
            }
        }
    }

    private void writeWildArea(int offset, int numOfEntries, EncounterSet encounters) {
        int dataOffset = this.readPointer(offset + 4);
        for (int i = 0; i < numOfEntries; ++i) {
            Encounter enc = encounters.encounters.get(i);
            this.writeWord(dataOffset + i * 4 + 2, this.pokedexToInternal[enc.pokemon.number]);
        }
    }

    @Override
    public List<Pokemon> getPokemon() {
        return this.pokemonList;
    }

    @Override
    public Map<Pokemon, List<MoveLearnt>> getMovesLearnt() {
        TreeMap<Pokemon, List<MoveLearnt>> movesets = new TreeMap<Pokemon, List<MoveLearnt>>();
        int baseOffset = this.romEntry.getValue("PokemonMovesets");
        for (int i = 1; i <= this.numRealPokemon; ++i) {
            Pokemon pkmn = this.pokemonList.get(i);
            int offsToPtr = baseOffset + this.pokedexToInternal[pkmn.number] * 4;
            int moveDataLoc = this.readPointer(offsToPtr);
            ArrayList<MoveLearnt> moves = new ArrayList<MoveLearnt>();
            if (this.jamboMovesetHack) {
                while ((this.rom[moveDataLoc] & 0xFF) != 0 || (this.rom[moveDataLoc + 1] & 0xFF) != 0 || (this.rom[moveDataLoc + 2] & 0xFF) != 255) {
                    MoveLearnt ml = new MoveLearnt();
                    ml.level = this.rom[moveDataLoc + 2] & 0xFF;
                    ml.move = this.readWord(moveDataLoc);
                    moves.add(ml);
                    moveDataLoc += 3;
                }
            } else {
                while ((this.rom[moveDataLoc] & 0xFF) != 255 || (this.rom[moveDataLoc + 1] & 0xFF) != 255) {
                    int move = this.rom[moveDataLoc] & 0xFF;
                    int level = (this.rom[moveDataLoc + 1] & 0xFE) >> 1;
                    if ((this.rom[moveDataLoc + 1] & 1) == 1) {
                        move += 256;
                    }
                    MoveLearnt ml = new MoveLearnt();
                    ml.level = level;
                    ml.move = move;
                    moves.add(ml);
                    moveDataLoc += 2;
                }
            }
            movesets.put(pkmn, moves);
        }
        return movesets;
    }

    @Override
    public void setMovesLearnt(Map<Pokemon, List<MoveLearnt>> movesets) {
        int baseOffset = this.romEntry.getValue("PokemonMovesets");
        int fso = this.romEntry.getValue("FreeSpace");
        for (int i = 1; i <= this.numRealPokemon; ++i) {
            int entrySize;
            Pokemon pkmn = this.pokemonList.get(i);
            int offsToPtr = baseOffset + this.pokedexToInternal[pkmn.number] * 4;
            int moveDataLoc = this.readPointer(offsToPtr);
            List<MoveLearnt> moves = movesets.get(pkmn);
            int newMoveCount = moves.size();
            int mloc = moveDataLoc;
            if (this.jamboMovesetHack) {
                while ((this.rom[mloc] & 0xFF) != 0 || (this.rom[mloc + 1] & 0xFF) != 0 || (this.rom[mloc + 2] & 0xFF) != 255) {
                    mloc += 3;
                }
                entrySize = 3;
            } else {
                while ((this.rom[mloc] & 0xFF) != 255 || (this.rom[mloc + 1] & 0xFF) != 255) {
                    mloc += 2;
                }
                entrySize = 2;
            }
            int currentMoveCount = (mloc - moveDataLoc) / entrySize;
            if (newMoveCount > currentMoveCount) {
                int newBytesNeeded = newMoveCount * entrySize + entrySize * 2;
                int writeSpace = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, newBytesNeeded, fso);
                if (writeSpace < fso) {
                    throw new RandomizerIOException("ROM is full");
                }
                this.writePointer(offsToPtr, writeSpace);
                moveDataLoc = writeSpace;
            }
            for (int mv = 0; mv < newMoveCount; ++mv) {
                MoveLearnt ml = moves.get(mv);
                moveDataLoc += this.writeMLToOffset(moveDataLoc, ml);
            }
            if (newMoveCount == currentMoveCount) continue;
            if (this.jamboMovesetHack) {
                this.rom[moveDataLoc] = 0;
                this.rom[moveDataLoc + 1] = 0;
                this.rom[moveDataLoc + 2] = -1;
                this.rom[moveDataLoc + 3] = 0;
                this.rom[moveDataLoc + 4] = 0;
                this.rom[moveDataLoc + 5] = 0;
                continue;
            }
            this.rom[moveDataLoc] = -1;
            this.rom[moveDataLoc + 1] = -1;
            this.rom[moveDataLoc + 2] = 0;
            this.rom[moveDataLoc + 3] = 0;
        }
    }

    private int writeMLToOffset(int offset, MoveLearnt ml) {
        if (this.jamboMovesetHack) {
            this.writeWord(offset, ml.move);
            this.rom[offset + 2] = (byte)ml.level;
            return 3;
        }
        this.rom[offset] = (byte)(ml.move & 0xFF);
        int levelPart = ml.level << 1 & 0xFE;
        if (ml.move > 255) {
            ++levelPart;
        }
        this.rom[offset + 1] = (byte)levelPart;
        return 2;
    }

    @Override
    public List<Pokemon> getStaticPokemon() {
        ArrayList<Pokemon> statics = new ArrayList<Pokemon>();
        List staticsHere = this.romEntry.staticPokemon;
        for (StaticPokemon staticPK : staticsHere) {
            statics.add(staticPK.getPokemon(this));
        }
        return statics;
    }

    @Override
    public boolean setStaticPokemon(List<Pokemon> staticPokemon) {
        this.attemptObedienceEvolutionPatches();
        List staticsHere = this.romEntry.staticPokemon;
        if (staticPokemon.size() != staticsHere.size()) {
            return false;
        }
        for (int i = 0; i < staticsHere.size(); ++i) {
            ((StaticPokemon)staticsHere.get(i)).setPokemon(this, staticPokemon.get(i));
        }
        return true;
    }

    @Override
    public List<Integer> getTMMoves() {
        ArrayList<Integer> tms = new ArrayList<Integer>();
        int offset = this.romEntry.getValue("TmMoves");
        for (int i = 1; i <= 50; ++i) {
            tms.add(this.readWord(offset + (i - 1) * 2));
        }
        return tms;
    }

    @Override
    public List<Integer> getHMMoves() {
        return Gen3Constants.hmMoves;
    }

    @Override
    public void setTMMoves(List<Integer> moveIndexes) {
        int iiOffset;
        if (!this.mapLoadingDone) {
            this.preprocessMaps();
            this.mapLoadingDone = true;
        }
        int offset = this.romEntry.getValue("TmMoves");
        for (int i = 1; i <= 50; ++i) {
            this.writeWord(offset + (i - 1) * 2, moveIndexes.get(i - 1));
        }
        int otherOffset = this.romEntry.getValue("TmMovesDuplicate");
        if (otherOffset > 0) {
            System.arraycopy(this.rom, offset, this.rom, otherOffset, 100);
        }
        if ((iiOffset = this.romEntry.getValue("ItemImages")) > 0) {
            int[] pals = (int[])this.romEntry.arrayEntries.get("TmPals");
            for (int i = 0; i < 50; ++i) {
                Move mv = this.moves[moveIndexes.get(i)];
                byte typeID = Gen3Constants.typeToByte(mv.type);
                this.writePointer(iiOffset + (289 + i) * 8 + 4, pals[typeID]);
            }
        }
        int fsOffset = this.romEntry.getValue("FreeSpace");
        if (this.romEntry.getValue("MoveDescriptions") > 0) {
            int idOffset = this.romEntry.getValue("ItemData");
            int mdOffset = this.romEntry.getValue("MoveDescriptions");
            int entrySize = this.romEntry.getValue("ItemEntrySize");
            int limitPerLine = this.romEntry.romType == 3 ? 24 : 18;
            for (int i = 0; i < 50; ++i) {
                int itemBaseOffset = idOffset + (i + 289) * entrySize;
                int moveBaseOffset = mdOffset + (moveIndexes.get(i) - 1) * 4;
                int moveTextPointer = this.readPointer(moveBaseOffset);
                String moveDesc = this.readVariableLengthString(moveTextPointer);
                String newItemDesc = RomFunctions.rewriteDescriptionForNewLineSize(moveDesc, "\\n", limitPerLine, this.ssd);
                int fsBytesNeeded = this.translateString(newItemDesc).length + 1;
                int newItemDescOffset = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, fsBytesNeeded, fsOffset);
                if (newItemDescOffset < fsOffset) {
                    String nl = System.getProperty("line.separator");
                    this.log("Couldn't insert new item description." + nl);
                    return;
                }
                this.writeVariableLengthString(newItemDesc, newItemDescOffset);
                this.writePointer(itemBaseOffset + 20, newItemDescOffset);
            }
        }
        for (TMOrMTTextEntry tte : this.romEntry.tmmtTexts) {
            if (tte.actualOffset <= 0 || tte.isMoveTutor) continue;
            int oldPointer = this.readPointer(tte.actualOffset);
            if (oldPointer < 0 || oldPointer >= this.rom.length) {
                String nl = System.getProperty("line.separator");
                this.log("Couldn't insert new TM text. Skipping remaining TM text updates." + nl);
                return;
            }
            String moveName = this.moves[moveIndexes.get((int)(((TMOrMTTextEntry)tte).number - 1)).intValue()].name;
            String tmpMoveName = moveName.replace(' ', '_');
            String unformatted = tte.template.replace("[move]", tmpMoveName);
            String newText = RomFunctions.formatTextWithReplacements(unformatted, null, "\\n", "\\l", "\\p", 36, this.ssd);
            int fsBytesNeeded = this.translateString(newText = newText.replace(tmpMoveName, moveName)).length + 1;
            int newOffset = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, fsBytesNeeded, fsOffset);
            if (newOffset < fsOffset) {
                String nl = System.getProperty("line.separator");
                this.log("Couldn't insert new TM text." + nl);
                return;
            }
            this.writeVariableLengthString(newText, newOffset);
            byte[] searchNeedle = new byte[4];
            System.arraycopy(this.rom, tte.actualOffset, searchNeedle, 0, 4);
            int minOffset = Math.max(0, tte.actualOffset - 500);
            int maxOffset = Math.min(this.rom.length, tte.actualOffset + 500);
            List<Integer> pointerLocs = RomFunctions.search(this.rom, minOffset, maxOffset, searchNeedle);
            for (int pointerLoc : pointerLocs) {
                this.writePointer(pointerLoc, newOffset);
            }
        }
    }

    @Override
    public int getTMCount() {
        return 50;
    }

    @Override
    public int getHMCount() {
        return 8;
    }

    @Override
    public Map<Pokemon, boolean[]> getTMHMCompatibility() {
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        int offset = this.romEntry.getValue("PokemonTMHMCompat");
        for (int i = 1; i <= this.numRealPokemon; ++i) {
            Pokemon pkmn = this.pokemonList.get(i);
            int compatOffset = offset + this.pokedexToInternal[pkmn.number] * 8;
            boolean[] flags = new boolean[59];
            for (int j = 0; j < 8; ++j) {
                this.readByteIntoFlags(flags, j * 8 + 1, compatOffset + j);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setTMHMCompatibility(Map<Pokemon, boolean[]> compatData) {
        int offset = this.romEntry.getValue("PokemonTMHMCompat");
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            int compatOffset = offset + this.pokedexToInternal[pkmn.number] * 8;
            for (int j = 0; j < 8; ++j) {
                this.rom[compatOffset + j] = this.getByteFromFlags(flags, j * 8 + 1);
            }
        }
    }

    @Override
    public boolean hasMoveTutors() {
        return this.romEntry.romType == 2 || this.romEntry.romType == 3;
    }

    @Override
    public List<Integer> getMoveTutorMoves() {
        if (!this.hasMoveTutors()) {
            return new ArrayList<Integer>();
        }
        ArrayList<Integer> mts = new ArrayList<Integer>();
        int moveCount = this.romEntry.getValue("MoveTutorMoves");
        int offset = this.romEntry.getValue("MoveTutorData");
        for (int i = 0; i < moveCount; ++i) {
            mts.add(this.readWord(offset + i * 2));
        }
        return mts;
    }

    @Override
    public void setMoveTutorMoves(List<Integer> moves) {
        if (!this.hasMoveTutors()) {
            return;
        }
        int moveCount = this.romEntry.getValue("MoveTutorMoves");
        int offset = this.romEntry.getValue("MoveTutorData");
        if (moveCount != moves.size()) {
            return;
        }
        for (int i = 0; i < moveCount; ++i) {
            this.writeWord(offset + i * 2, moves.get(i));
        }
        int fsOffset = this.romEntry.getValue("FreeSpace");
        for (TMOrMTTextEntry tte : this.romEntry.tmmtTexts) {
            if (tte.actualOffset <= 0 || !tte.isMoveTutor) continue;
            int oldPointer = this.readPointer(tte.actualOffset);
            if (oldPointer < 0 || oldPointer >= this.rom.length) {
                throw new RandomizationException("Move Tutor Text update failed: couldn't read a move tutor text pointer.");
            }
            String moveName = this.moves[moves.get((int)((TMOrMTTextEntry)tte).number).intValue()].name;
            String tmpMoveName = moveName.replace(' ', '_');
            String unformatted = tte.template.replace("[move]", tmpMoveName);
            String newText = RomFunctions.formatTextWithReplacements(unformatted, null, "\\n", "\\l", "\\p", 36, this.ssd);
            int fsBytesNeeded = this.translateString(newText = newText.replace(tmpMoveName, moveName)).length + 1;
            int newOffset = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, fsBytesNeeded, fsOffset);
            if (newOffset < fsOffset) {
                String nl = System.getProperty("line.separator");
                this.log("Couldn't insert new Move Tutor text." + nl);
                return;
            }
            this.writeVariableLengthString(newText, newOffset);
            byte[] searchNeedle = new byte[4];
            System.arraycopy(this.rom, tte.actualOffset, searchNeedle, 0, 4);
            int minOffset = Math.max(0, tte.actualOffset - 500);
            int maxOffset = Math.min(this.rom.length, tte.actualOffset + 500);
            List<Integer> pointerLocs = RomFunctions.search(this.rom, minOffset, maxOffset, searchNeedle);
            for (int pointerLoc : pointerLocs) {
                this.writePointer(pointerLoc, newOffset);
            }
        }
    }

    @Override
    public Map<Pokemon, boolean[]> getMoveTutorCompatibility() {
        if (!this.hasMoveTutors()) {
            return new TreeMap<Pokemon, boolean[]>();
        }
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        int moveCount = this.romEntry.getValue("MoveTutorMoves");
        int offset = this.romEntry.getValue("MoveTutorCompatibility");
        int bytesRequired = (moveCount + 7 & 0xFFFFFFF8) / 8;
        for (int i = 1; i <= this.numRealPokemon; ++i) {
            Pokemon pkmn = this.pokemonList.get(i);
            int compatOffset = offset + this.pokedexToInternal[pkmn.number] * bytesRequired;
            boolean[] flags = new boolean[moveCount + 1];
            for (int j = 0; j < bytesRequired; ++j) {
                this.readByteIntoFlags(flags, j * 8 + 1, compatOffset + j);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setMoveTutorCompatibility(Map<Pokemon, boolean[]> compatData) {
        if (!this.hasMoveTutors()) {
            return;
        }
        int moveCount = this.romEntry.getValue("MoveTutorMoves");
        int offset = this.romEntry.getValue("MoveTutorCompatibility");
        int bytesRequired = (moveCount + 7 & 0xFFFFFFF8) / 8;
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            int compatOffset = offset + this.pokedexToInternal[pkmn.number] * bytesRequired;
            for (int j = 0; j < bytesRequired; ++j) {
                this.rom[compatOffset + j] = this.getByteFromFlags(flags, j * 8 + 1);
            }
        }
    }

    @Override
    public String getROMName() {
        return this.romEntry.name + (this.isRomHack ? " (ROM Hack)" : "");
    }

    @Override
    public String getROMCode() {
        return this.romEntry.romCode;
    }

    @Override
    public String getSupportLevel() {
        return this.romEntry.getValue("StaticPokemonSupport") > 0 ? "Complete" : "No Static Pokemon";
    }

    private int find(String hexString) {
        return Gen3RomHandler.find(this.rom, hexString);
    }

    private static int find(byte[] haystack, String hexString) {
        if (hexString.length() % 2 != 0) {
            return -3;
        }
        byte[] searchFor = new byte[hexString.length() / 2];
        for (int i = 0; i < searchFor.length; ++i) {
            searchFor[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        List<Integer> found = RomFunctions.search(haystack, searchFor);
        if (found.size() == 0) {
            return -1;
        }
        if (found.size() > 1) {
            return -2;
        }
        return found.get(0);
    }

    private List<Integer> findMultiple(String hexString) {
        return Gen3RomHandler.findMultiple(this.rom, hexString);
    }

    private static List<Integer> findMultiple(byte[] haystack, String hexString) {
        if (hexString.length() % 2 != 0) {
            return new ArrayList<Integer>();
        }
        byte[] searchFor = new byte[hexString.length() / 2];
        for (int i = 0; i < searchFor.length; ++i) {
            searchFor[i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
        List<Integer> found = RomFunctions.search(haystack, searchFor);
        return found;
    }

    private void writeHexString(String hexString, int offset) {
        if (hexString.length() % 2 != 0) {
            return;
        }
        for (int i = 0; i < hexString.length() / 2; ++i) {
            this.rom[offset + i] = (byte)Integer.parseInt(hexString.substring(i * 2, i * 2 + 2), 16);
        }
    }

    private void attemptObedienceEvolutionPatches() {
        if (this.havePatchedObedience) {
            return;
        }
        this.havePatchedObedience = true;
        int deoxysObOffset = this.find("CD21490088420FD0");
        if (deoxysObOffset > 0) {
            this.rom[deoxysObOffset] = 0;
            this.rom[deoxysObOffset + 1] = 33;
            this.rom[deoxysObOffset + 2] = 0;
            this.rom[deoxysObOffset + 3] = 33;
            if (this.readWord(deoxysObOffset + 22) == 10391) {
                this.writeWord(deoxysObOffset + 22, 10240);
            }
        }
        if (this.romEntry.romType == 3) {
            int stoneJumpOffset;
            int evoJumpOffset = this.find("972814DD");
            if (evoJumpOffset > 0) {
                this.writeWord(evoJumpOffset, 18112);
                this.writeWord(evoJumpOffset + 2, 57364);
            }
            if ((stoneJumpOffset = this.find("972808D9")) > 0) {
                this.writeWord(stoneJumpOffset, 18112);
                this.writeWord(stoneJumpOffset + 2, 57352);
            }
        }
    }

    private void patchForNationalDex() {
        this.log("--Patching for National Dex at Start of Game--");
        String nl = System.getProperty("line.separator");
        int fso = this.romEntry.getValue("FreeSpace");
        if (this.romEntry.romType == 0 || this.romEntry.romType == 1) {
            int pkDexOffset = this.find("326629010803");
            if (pkDexOffset < 0) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            int textPointer = this.readPointer(pkDexOffset - 4);
            int realScriptLocation = pkDexOffset - 8;
            int pointerLocToScript = this.find(this.pointerToHexString(realScriptLocation));
            if (pointerLocToScript < 0) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            int writeSpace = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, 44, fso);
            if (writeSpace < fso) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            this.writePointer(pointerLocToScript, writeSpace);
            this.writeHexString("31720167", writeSpace);
            this.writePointer(writeSpace + 4, textPointer);
            this.writeHexString("32662901082B00801102006B02021103016B020211DABE4E020211675A6A02022A008003", writeSpace + 8);
        } else if (this.romEntry.romType == 3) {
            int oakHouseCheckOffs;
            int pkDexOffset = this.find("292908258101");
            if (pkDexOffset < 0) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            int writeSpace = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, 10, fso);
            if (writeSpace < fso) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            this.rom[pkDexOffset] = 4;
            this.writePointer(pkDexOffset + 1, writeSpace);
            this.rom[pkDexOffset + 5] = 0;
            this.writeHexString("292908258101256F0103", writeSpace);
            List<Integer> ndexChecks = this.findMultiple("260D809301210D800100");
            for (int ndexCheckOffset : ndexChecks) {
                this.writeHexString("2B2C0800000000000000", ndexCheckOffset);
            }
            int oakLabCheckOffs = this.find("257D011604800000260D80D400");
            if (oakLabCheckOffs > 0) {
                this.writeHexString("257D011604800100", oakLabCheckOffs);
            }
            if ((oakHouseCheckOffs = this.find("1604800000260D80D4001908800580190980068083000880830109802109803C")) > 0) {
                this.writeHexString("1604800100", oakHouseCheckOffs);
            }
        } else {
            int pkDexOffset = this.find("3229610825F00129E40816CD40010003");
            if (pkDexOffset < 0) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            int textPointer = this.readPointer(pkDexOffset - 4);
            int realScriptLocation = pkDexOffset - 8;
            int pointerLocToScript = this.find(this.pointerToHexString(realScriptLocation));
            if (pointerLocToScript < 0) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            int writeSpace = RomFunctions.freeSpaceFinder(this.rom, (byte)-1, 27, fso);
            if (writeSpace < fso) {
                this.log("Patch unsuccessful." + nl);
                return;
            }
            this.writePointer(pointerLocToScript, writeSpace);
            this.writeHexString("31720167", writeSpace);
            this.writePointer(writeSpace + 4, textPointer);
            this.writeHexString("3229610825F00129E40825F30116CD40010003", writeSpace + 8);
        }
        this.log("Patch successful!" + nl);
    }

    public String pointerToHexString(int pointer) {
        String hex = String.format("%08X", pointer + 0x8000000);
        return new String(new char[]{hex.charAt(6), hex.charAt(7), hex.charAt(4), hex.charAt(5), hex.charAt(2), hex.charAt(3), hex.charAt(0), hex.charAt(1)});
    }

    private void populateEvolutions() {
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            pkmn.evolutionsFrom.clear();
            pkmn.evolutionsTo.clear();
        }
        int baseOffset = this.romEntry.getValue("PokemonEvolutions");
        int numInternalPokes = this.romEntry.getValue("PokemonCount");
        for (int i = 1; i <= this.numRealPokemon; ++i) {
            Pokemon pk = this.pokemonList.get(i);
            int idx = this.pokedexToInternal[pk.number];
            int evoOffset = baseOffset + idx * 40;
            for (int j = 0; j < 5; ++j) {
                int method = this.readWord(evoOffset + j * 8);
                int evolvingTo = this.readWord(evoOffset + j * 8 + 4);
                if (method < 1 || method > 15 || evolvingTo < 1 || evolvingTo > numInternalPokes) continue;
                int extraInfo = this.readWord(evoOffset + j * 8 + 2);
                EvolutionType et = EvolutionType.fromIndex(3, method);
                Evolution evo = new Evolution(pk, this.pokesInternal[evolvingTo], true, et, extraInfo);
                if (pk.evolutionsFrom.contains(evo)) continue;
                pk.evolutionsFrom.add(evo);
                this.pokesInternal[evolvingTo].evolutionsTo.add(evo);
            }
            if (pk.evolutionsFrom.size() <= 1) continue;
            for (Evolution e : pk.evolutionsFrom) {
                e.carryStats = false;
            }
        }
    }

    private void writeEvolutions() {
        int baseOffset = this.romEntry.getValue("PokemonEvolutions");
        for (int i = 1; i <= this.numRealPokemon; ++i) {
            Pokemon pk = this.pokemonList.get(i);
            int idx = this.pokedexToInternal[pk.number];
            int evoOffset = baseOffset + idx * 40;
            int evosWritten = 0;
            for (Evolution evo : pk.evolutionsFrom) {
                this.writeWord(evoOffset, evo.type.toIndex(3));
                this.writeWord(evoOffset + 2, evo.extraInfo);
                this.writeWord(evoOffset + 4, this.pokedexToInternal[evo.to.number]);
                this.writeWord(evoOffset + 6, 0);
                evoOffset += 8;
                if (++evosWritten != 5) continue;
                break;
            }
            while (evosWritten < 5) {
                this.writeWord(evoOffset, 0);
                this.writeWord(evoOffset + 2, 0);
                this.writeWord(evoOffset + 4, 0);
                this.writeWord(evoOffset + 6, 0);
                evoOffset += 8;
                ++evosWritten;
            }
        }
    }

    @Override
    public void removeTradeEvolutions(boolean changeMoveEvos) {
        this.attemptObedienceEvolutionPatches();
        this.log("--Removing Trade Evolutions--");
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            for (Evolution evo : pkmn.evolutionsFrom) {
                if (evo.type == EvolutionType.HAPPINESS_DAY && this.romEntry.romType == 3) {
                    evo.type = EvolutionType.STONE;
                    evo.extraInfo = 93;
                    this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames[93]);
                }
                if (evo.type == EvolutionType.HAPPINESS_NIGHT && this.romEntry.romType == 3) {
                    evo.type = EvolutionType.STONE;
                    evo.extraInfo = 94;
                    this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames[94]);
                }
                if (evo.type == EvolutionType.LEVEL_HIGH_BEAUTY && this.romEntry.romType == 3) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 35;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 35);
                }
                if (evo.type == EvolutionType.TRADE) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 37;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 37);
                }
                if (evo.type != EvolutionType.TRADE_ITEM) continue;
                if (evo.from.number == 61) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 37;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 37);
                    continue;
                }
                if (evo.from.number == 79) {
                    evo.type = EvolutionType.STONE;
                    evo.extraInfo = 97;
                    this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames[97]);
                    continue;
                }
                if (evo.from.number == 117) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 40;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 40);
                    continue;
                }
                if (evo.from.number == 366 && evo.to.number == 367) {
                    evo.type = EvolutionType.LEVEL;
                    evo.extraInfo = 30;
                    this.logEvoChangeLevel(evo.from.name, evo.to.name, 30);
                    continue;
                }
                if (evo.from.number == 366 && evo.to.number == 368) {
                    evo.type = EvolutionType.STONE;
                    evo.extraInfo = 97;
                    this.logEvoChangeStone(evo.from.name, evo.to.name, this.itemNames[97]);
                    continue;
                }
                evo.type = EvolutionType.LEVEL;
                evo.extraInfo = 30;
                this.logEvoChangeLevel(evo.from.name, evo.to.name, 30);
            }
        }
        this.logBlankLine();
    }

    @Override
    public boolean canChangeTrainerText() {
        return true;
    }

    @Override
    public List<String> getTrainerNames() {
        int baseOffset = this.romEntry.getValue("TrainerData");
        int amount = this.romEntry.getValue("TrainerCount");
        int entryLen = this.romEntry.getValue("TrainerEntrySize");
        ArrayList<String> theTrainers = new ArrayList<String>();
        for (int i = 1; i < amount; ++i) {
            theTrainers.add(this.readVariableLengthString(baseOffset + i * entryLen + 4));
        }
        return theTrainers;
    }

    @Override
    public void setTrainerNames(List<String> trainerNames) {
        int baseOffset = this.romEntry.getValue("TrainerData");
        int amount = this.romEntry.getValue("TrainerCount");
        int entryLen = this.romEntry.getValue("TrainerEntrySize");
        int nameLen = this.romEntry.getValue("TrainerNameLength");
        Iterator<String> theTrainers = trainerNames.iterator();
        for (int i = 1; i < amount; ++i) {
            String newName = theTrainers.next();
            this.writeFixedLengthString(newName, baseOffset + i * entryLen + 4, nameLen);
        }
    }

    @Override
    public RomHandler.TrainerNameMode trainerNameMode() {
        return RomHandler.TrainerNameMode.MAX_LENGTH;
    }

    @Override
    public List<Integer> getTCNameLengthsByTrainer() {
        return new ArrayList<Integer>();
    }

    @Override
    public int maxTrainerNameLength() {
        return this.romEntry.getValue("TrainerNameLength") - 1;
    }

    @Override
    public List<String> getTrainerClassNames() {
        int baseOffset = this.romEntry.getValue("TrainerClassNames");
        int amount = this.romEntry.getValue("TrainerClassCount");
        int length = this.romEntry.getValue("TrainerClassNameLength");
        ArrayList<String> trainerClasses = new ArrayList<String>();
        for (int i = 0; i < amount; ++i) {
            trainerClasses.add(this.readVariableLengthString(baseOffset + i * length));
        }
        return trainerClasses;
    }

    @Override
    public void setTrainerClassNames(List<String> trainerClassNames) {
        int baseOffset = this.romEntry.getValue("TrainerClassNames");
        int amount = this.romEntry.getValue("TrainerClassCount");
        int length = this.romEntry.getValue("TrainerClassNameLength");
        Iterator<String> trainerClasses = trainerClassNames.iterator();
        for (int i = 0; i < amount; ++i) {
            this.writeFixedLengthString(trainerClasses.next(), baseOffset + i * length, length);
        }
    }

    @Override
    public int maxTrainerClassNameLength() {
        return this.romEntry.getValue("TrainerClassNameLength") - 1;
    }

    @Override
    public boolean fixedTrainerClassNamesLength() {
        return false;
    }

    @Override
    public List<Integer> getDoublesTrainerClasses() {
        int[] doublesClasses = (int[])this.romEntry.arrayEntries.get("DoublesTrainerClasses");
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        for (int tClass : doublesClasses) {
            doubles.add(tClass);
        }
        return doubles;
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return this.romEntry.getValue("StaticPokemonSupport") > 0;
    }

    @Override
    public String getDefaultExtension() {
        return "gba";
    }

    @Override
    public int abilitiesPerPokemon() {
        return 2;
    }

    @Override
    public int highestAbilityIndex() {
        return 77;
    }

    private void loadAbilityNames() {
        int nameoffs = this.romEntry.getValue("AbilityNames");
        int namelen = this.romEntry.getValue("AbilityNameLength");
        this.abilityNames = new String[78];
        for (int i = 0; i <= 77; ++i) {
            this.abilityNames[i] = this.readFixedLengthString(nameoffs + namelen * i, namelen);
        }
    }

    @Override
    public String abilityName(int number) {
        return this.abilityNames[number];
    }

    @Override
    public int internalStringLength(String string) {
        return this.translateString(string).length;
    }

    @Override
    public void applySignature() {
        if (this.romEntry.romType == 3) {
            Pokemon introPk = this.randomPokemonLimited(255, false);
            if (introPk == null) {
                return;
            }
            int introPokemon = this.pokedexToInternal[introPk.number];
            int frontSprites = this.romEntry.getValue("FrontSprites");
            int palettes = this.romEntry.getValue("PokemonPalettes");
            this.rom[((RomEntry)this.romEntry).getValue((String)"IntroCryOffset")] = (byte)introPokemon;
            this.rom[((RomEntry)this.romEntry).getValue((String)"IntroOtherOffset")] = (byte)introPokemon;
            int spriteBase = this.romEntry.getValue("IntroSpriteOffset");
            this.writePointer(spriteBase, frontSprites + introPokemon * 8);
            this.writePointer(spriteBase + 4, palettes + introPokemon * 8);
        } else if (this.romEntry.romType == 0 || this.romEntry.romType == 1) {
            int numInternalPokes = this.romEntry.getValue("PokemonCount");
            int introPokemon = this.random.nextInt(Math.min(numInternalPokes, 509)) + 1;
            while (this.internalToPokedex[introPokemon] < 252) {
                introPokemon = this.random.nextInt(Math.min(numInternalPokes, 509)) + 1;
            }
            int frontSprites = this.romEntry.getValue("PokemonFrontSprites");
            int palettes = this.romEntry.getValue("PokemonNormalPalettes");
            int cryCommand = this.romEntry.getValue("IntroCryOffset");
            int otherCommand = this.romEntry.getValue("IntroOtherOffset");
            if (introPokemon > 255) {
                this.rom[cryCommand] = -1;
                this.rom[cryCommand + 1] = 32;
                this.rom[cryCommand + 2] = (byte)(introPokemon - 255);
                this.rom[cryCommand + 3] = 48;
                this.rom[otherCommand] = -1;
                this.rom[otherCommand + 1] = 36;
                this.rom[otherCommand + 2] = (byte)(introPokemon - 255);
                this.rom[otherCommand + 3] = 52;
            } else {
                this.rom[cryCommand] = (byte)introPokemon;
                this.rom[cryCommand + 1] = 32;
                this.writeWord(cryCommand + 2, 18112);
                this.rom[otherCommand] = (byte)introPokemon;
                this.rom[otherCommand + 1] = 36;
                this.writeWord(otherCommand + 2, 18112);
            }
            this.writePointer(this.romEntry.getValue("IntroSpriteOffset"), frontSprites + introPokemon * 8);
            this.writePointer(this.romEntry.getValue("IntroPaletteOffset"), palettes + introPokemon * 8);
        } else {
            int introPokemon = this.pokedexToInternal[this.randomPokemon().number];
            this.writeWord(this.romEntry.getValue("IntroSpriteOffset"), introPokemon);
            this.writeWord(this.romEntry.getValue("IntroCryOffset"), introPokemon);
        }
    }

    private Pokemon randomPokemonLimited(int maxValue, boolean blockNonMales) {
        this.checkPokemonRestrictions();
        ArrayList<Pokemon> validPokemon = new ArrayList<Pokemon>();
        for (Pokemon pk : this.mainPokemonList) {
            if (this.pokedexToInternal[pk.number] > maxValue || blockNonMales && pk.genderRatio > 253) continue;
            validPokemon.add(pk);
        }
        if (validPokemon.size() == 0) {
            return null;
        }
        return (Pokemon)validPokemon.get(this.random.nextInt(validPokemon.size()));
    }

    private void determineMapBankSizes() {
        int mbpsOffset = this.romEntry.getValue("MapHeaders");
        ArrayList<Integer> mapBankOffsets = new ArrayList<Integer>();
        int offset = mbpsOffset;
        while (true) {
            int newMBOffset;
            boolean valid = true;
            Iterator iterator = mapBankOffsets.iterator();
            while (iterator.hasNext()) {
                int mbOffset = (Integer)iterator.next();
                if (mbpsOffset >= mbOffset || offset < mbOffset) continue;
                valid = false;
                break;
            }
            if (!valid || (newMBOffset = this.readPointer(offset)) < 0 || newMBOffset >= this.rom.length) break;
            mapBankOffsets.add(newMBOffset);
            offset += 4;
        }
        int bankCount = mapBankOffsets.size();
        int[] bankMapCounts = new int[bankCount];
        for (int bank = 0; bank < bankCount; ++bank) {
            int baseBankOffset = (Integer)mapBankOffsets.get(bank);
            int count = 0;
            offset = baseBankOffset;
            while (true) {
                int newMapOffset;
                boolean valid = true;
                Iterator iterator = mapBankOffsets.iterator();
                while (iterator.hasNext()) {
                    int mbOffset = (Integer)iterator.next();
                    if (baseBankOffset >= mbOffset || offset < mbOffset) continue;
                    valid = false;
                    break;
                }
                if (!valid || baseBankOffset < mbpsOffset && offset >= mbpsOffset || (newMapOffset = this.readPointer(offset)) < 0 || newMapOffset >= this.rom.length) break;
                ++count;
                offset += 4;
            }
            bankMapCounts[bank] = count;
        }
        this.romEntry.entries.put("MapBankCount", bankCount);
        this.romEntry.arrayEntries.put("MapBankSizes", bankMapCounts);
    }

    private void preprocessMaps() {
        this.itemOffs = new ArrayList<Integer>();
        int bankCount = this.romEntry.getValue("MapBankCount");
        int[] bankMapCounts = (int[])this.romEntry.arrayEntries.get("MapBankSizes");
        int itemBall = this.romEntry.getValue("ItemBallPic");
        this.mapNames = new String[bankCount][];
        int mbpsOffset = this.romEntry.getValue("MapHeaders");
        int mapLabels = this.romEntry.getValue("MapLabels");
        HashMap<Integer, String> mapLabelsM = new HashMap<Integer, String>();
        for (int bank = 0; bank < bankCount; ++bank) {
            int bankOffset = this.readPointer(mbpsOffset + bank * 4);
            this.mapNames[bank] = new String[bankMapCounts[bank]];
            for (int map = 0; map < bankMapCounts[bank]; ++map) {
                int mhOffset = this.readPointer(bankOffset + map * 4);
                int mapLabel = this.rom[mhOffset + 20] & 0xFF;
                if (mapLabelsM.containsKey(mapLabel)) {
                    this.mapNames[bank][map] = (String)mapLabelsM.get(mapLabel);
                } else {
                    this.mapNames[bank][map] = this.romEntry.romType == 3 ? this.readVariableLengthString(this.readPointer(mapLabels + (mapLabel - 88) * 4)) : this.readVariableLengthString(this.readPointer(mapLabels + mapLabel * 8 + 4));
                    mapLabelsM.put(mapLabel, this.mapNames[bank][map]);
                }
                int eventOffset = this.readPointer(mhOffset + 4);
                if (eventOffset < 0 || eventOffset >= this.rom.length) continue;
                int pCount = this.rom[eventOffset] & 0xFF;
                int spCount = this.rom[eventOffset + 3] & 0xFF;
                if (pCount > 0) {
                    int scriptOffset;
                    int peopleOffset = this.readPointer(eventOffset + 4);
                    for (int p = 0; p < pCount; ++p) {
                        byte pSprite = this.rom[peopleOffset + p * 24 + 1];
                        if (pSprite != itemBall || this.readPointer(peopleOffset + p * 24 + 16) < 0 || this.rom[scriptOffset = this.readPointer(peopleOffset + p * 24 + 16)] != 26 || this.rom[scriptOffset + 1] != 0 || (this.rom[scriptOffset + 2] & 0xFF) != 128 || this.rom[scriptOffset + 5] != 26 || this.rom[scriptOffset + 6] != 1 || (this.rom[scriptOffset + 7] & 0xFF) != 128 || this.rom[scriptOffset + 10] != 9 || this.rom[scriptOffset + 11] != 0 && this.rom[scriptOffset + 11] != 1) continue;
                        this.itemOffs.add(scriptOffset + 3);
                    }
                    for (TMOrMTTextEntry tte : this.romEntry.tmmtTexts) {
                        int lookAt;
                        if (tte.mapBank != bank || tte.mapNumber != map || (scriptOffset = this.readPointer(peopleOffset + (tte.personNum - 1) * 24 + 16)) < 0) continue;
                        if (this.romEntry.romType == 3 && tte.isMoveTutor && (tte.number == 5 || tte.number >= 8 && tte.number <= 11)) {
                            scriptOffset = this.readPointer(scriptOffset + 1);
                        } else if (this.romEntry.romType == 3 && tte.isMoveTutor && tte.number == 7) {
                            scriptOffset = this.readPointer(scriptOffset + 31);
                        }
                        if ((lookAt = scriptOffset + tte.offsetInScript) < 0 || lookAt >= this.rom.length - 2 || this.rom[lookAt + 3] != 8 && this.rom[lookAt + 3] != 9) continue;
                        tte.actualOffset = lookAt;
                    }
                }
                if (spCount <= 0) continue;
                int signpostsOffset = this.readPointer(eventOffset + 16);
                for (int sp = 0; sp < spCount; ++sp) {
                    int itemHere;
                    byte spType = this.rom[signpostsOffset + sp * 12 + 5];
                    if (spType < 5 || spType > 7 || (itemHere = this.readWord(signpostsOffset + sp * 12 + 8)) == 0) continue;
                    this.itemOffs.add(signpostsOffset + sp * 12 + 8);
                }
            }
        }
    }

    @Override
    public ItemList getAllowedItems() {
        return this.allowedItems;
    }

    @Override
    public ItemList getNonBadItems() {
        return this.nonBadItems;
    }

    private void loadItemNames() {
        int nameoffs = this.romEntry.getValue("ItemData");
        int structlen = this.romEntry.getValue("ItemEntrySize");
        int maxcount = this.romEntry.getValue("ItemCount");
        this.itemNames = new String[maxcount + 1];
        for (int i = 0; i <= maxcount; ++i) {
            this.itemNames[i] = this.readVariableLengthString(nameoffs + structlen * i);
        }
    }

    @Override
    public String[] getItemNames() {
        return this.itemNames;
    }

    @Override
    public List<Integer> getRequiredFieldTMs() {
        if (this.romEntry.romType == 3) {
            return Gen3Constants.frlgRequiredFieldTMs;
        }
        if (this.romEntry.romType == 0 || this.romEntry.romType == 1) {
            return Gen3Constants.rsRequiredFieldTMs;
        }
        return Gen3Constants.eRequiredFieldTMs;
    }

    @Override
    public List<Integer> getCurrentFieldTMs() {
        if (!this.mapLoadingDone) {
            this.preprocessMaps();
            this.mapLoadingDone = true;
        }
        ArrayList<Integer> fieldTMs = new ArrayList<Integer>();
        for (int offset : this.itemOffs) {
            int thisTM;
            int itemHere = this.readWord(offset);
            if (!Gen3Constants.allowedItems.isTM(itemHere) || fieldTMs.contains(thisTM = itemHere - 289 + 1)) continue;
            fieldTMs.add(thisTM);
        }
        return fieldTMs;
    }

    @Override
    public void setFieldTMs(List<Integer> fieldTMs) {
        if (!this.mapLoadingDone) {
            this.preprocessMaps();
            this.mapLoadingDone = true;
        }
        Iterator<Integer> iterTMs = fieldTMs.iterator();
        int[] givenTMs = new int[512];
        for (int offset : this.itemOffs) {
            int itemHere = this.readWord(offset);
            if (!Gen3Constants.allowedItems.isTM(itemHere)) continue;
            if (givenTMs[itemHere] != 0) {
                this.rom[offset] = (byte)givenTMs[itemHere];
                continue;
            }
            int tm = iterTMs.next();
            givenTMs[itemHere] = tm += 288;
            this.writeWord(offset, tm);
        }
    }

    @Override
    public List<Integer> getRegularFieldItems() {
        if (!this.mapLoadingDone) {
            this.preprocessMaps();
            this.mapLoadingDone = true;
        }
        ArrayList<Integer> fieldItems = new ArrayList<Integer>();
        for (int offset : this.itemOffs) {
            int itemHere = this.readWord(offset);
            if (!Gen3Constants.allowedItems.isAllowed(itemHere) || Gen3Constants.allowedItems.isTM(itemHere)) continue;
            fieldItems.add(itemHere);
        }
        return fieldItems;
    }

    @Override
    public void setRegularFieldItems(List<Integer> items) {
        if (!this.mapLoadingDone) {
            this.preprocessMaps();
            this.mapLoadingDone = true;
        }
        Iterator<Integer> iterItems = items.iterator();
        for (int offset : this.itemOffs) {
            int itemHere = this.readWord(offset);
            if (!Gen3Constants.allowedItems.isAllowed(itemHere) || Gen3Constants.allowedItems.isTM(itemHere)) continue;
            this.writeWord(offset, iterItems.next());
        }
    }

    @Override
    public List<IngameTrade> getIngameTrades() {
        ArrayList<IngameTrade> trades = new ArrayList<IngameTrade>();
        int tableOffset = this.romEntry.getValue("TradeTableOffset");
        int tableSize = this.romEntry.getValue("TradeTableSize");
        int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
        int unusedOffset = 0;
        int entryLength = 60;
        for (int entry = 0; entry < tableSize; ++entry) {
            if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                ++unusedOffset;
                continue;
            }
            IngameTrade trade = new IngameTrade();
            int entryOffset = tableOffset + entry * entryLength;
            trade.nickname = this.readVariableLengthString(entryOffset);
            trade.givenPokemon = this.pokesInternal[this.readWord(entryOffset + 12)];
            trade.ivs = new int[6];
            for (int i = 0; i < 6; ++i) {
                trade.ivs[i] = this.rom[entryOffset + 14 + i] & 0xFF;
            }
            trade.otId = this.readWord(entryOffset + 24);
            trade.item = this.readWord(entryOffset + 40);
            trade.otName = this.readVariableLengthString(entryOffset + 43);
            trade.requestedPokemon = this.pokesInternal[this.readWord(entryOffset + 56)];
            trades.add(trade);
        }
        return trades;
    }

    @Override
    public void setIngameTrades(List<IngameTrade> trades) {
        int tableOffset = this.romEntry.getValue("TradeTableOffset");
        int tableSize = this.romEntry.getValue("TradeTableSize");
        int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
        int unusedOffset = 0;
        int entryLength = 60;
        int tradeOffset = 0;
        for (int entry = 0; entry < tableSize; ++entry) {
            if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                ++unusedOffset;
                continue;
            }
            IngameTrade trade = trades.get(tradeOffset++);
            int entryOffset = tableOffset + entry * entryLength;
            this.writeFixedLengthString(trade.nickname, entryOffset, 12);
            this.writeWord(entryOffset + 12, this.pokedexToInternal[trade.givenPokemon.number]);
            for (int i = 0; i < 6; ++i) {
                this.rom[entryOffset + 14 + i] = (byte)trade.ivs[i];
            }
            this.writeWord(entryOffset + 24, trade.otId);
            this.writeWord(entryOffset + 40, trade.item);
            this.writeFixedLengthString(trade.otName, entryOffset + 43, 11);
            this.writeWord(entryOffset + 56, this.pokedexToInternal[trade.requestedPokemon.number]);
        }
    }

    @Override
    public boolean hasDVs() {
        return false;
    }

    @Override
    public int generationOfPokemon() {
        return 3;
    }

    @Override
    public void removeEvosForPokemonPool() {
        List pokemonIncluded = this.mainPokemonList;
        HashSet<Evolution> keepEvos = new HashSet<Evolution>();
        for (Pokemon pk : this.pokes) {
            if (pk == null) continue;
            keepEvos.clear();
            for (Evolution evol : pk.evolutionsFrom) {
                if (pokemonIncluded.contains(evol.from) && pokemonIncluded.contains(evol.to)) {
                    keepEvos.add(evol);
                    continue;
                }
                evol.to.evolutionsTo.remove(evol);
            }
            pk.evolutionsFrom.retainAll(keepEvos);
        }
    }

    @Override
    public boolean supportsFourStartingMoves() {
        return true;
    }

    @Override
    public List<Integer> getFieldMoves() {
        if (this.romEntry.romType == 3) {
            return Gen3Constants.frlgFieldMoves;
        }
        return Gen3Constants.rseFieldMoves;
    }

    @Override
    public List<Integer> getEarlyRequiredHMMoves() {
        if (this.romEntry.romType == 3) {
            return Gen3Constants.frlgEarlyRequiredHMMoves;
        }
        return Gen3Constants.rseEarlyRequiredHMMoves;
    }

    @Override
    public int miscTweaksAvailable() {
        int available = MiscTweak.LOWER_CASE_POKEMON_NAMES.getValue();
        available |= MiscTweak.NATIONAL_DEX_AT_START.getValue();
        if (this.romEntry.getValue("RunIndoorsTweakOffset") > 0) {
            available |= MiscTweak.RUNNING_SHOES_INDOORS.getValue();
        }
        if (this.romEntry.getValue("TextSpeedValuesOffset") > 0) {
            available |= MiscTweak.FASTEST_TEXT.getValue();
        }
        if (this.romEntry.getValue("CatchingTutorialOpponentMonOffset") > 0 || this.romEntry.getValue("CatchingTutorialPlayerMonOffset") > 0) {
            available |= MiscTweak.RANDOMIZE_CATCHING_TUTORIAL.getValue();
        }
        return available |= MiscTweak.BAN_LUCKY_EGG.getValue();
    }

    @Override
    public void applyMiscTweak(MiscTweak tweak) {
        if (tweak == MiscTweak.RUNNING_SHOES_INDOORS) {
            this.applyRunningShoesIndoorsPatch();
        } else if (tweak == MiscTweak.FASTEST_TEXT) {
            this.applyFastestTextPatch();
        } else if (tweak == MiscTweak.LOWER_CASE_POKEMON_NAMES) {
            this.applyCamelCaseNames();
        } else if (tweak == MiscTweak.NATIONAL_DEX_AT_START) {
            this.patchForNationalDex();
        } else if (tweak == MiscTweak.RANDOMIZE_CATCHING_TUTORIAL) {
            this.randomizeCatchingTutorial();
        } else if (tweak == MiscTweak.BAN_LUCKY_EGG) {
            this.allowedItems.banSingles(197);
            this.nonBadItems.banSingles(197);
        }
    }

    private void randomizeCatchingTutorial() {
        if (this.romEntry.getValue("CatchingTutorialOpponentMonOffset") > 0) {
            int oppValue;
            Pokemon opponent;
            int oppOffset = this.romEntry.getValue("CatchingTutorialOpponentMonOffset");
            if (this.romEntry.romType == 3) {
                opponent = this.randomPokemonLimited(255, true);
                if (opponent != null) {
                    oppValue = this.pokedexToInternal[opponent.number];
                    this.rom[oppOffset] = (byte)oppValue;
                    this.rom[oppOffset + 1] = 33;
                }
            } else {
                opponent = this.randomPokemonLimited(510, true);
                if (opponent != null) {
                    oppValue = this.pokedexToInternal[opponent.number];
                    if (oppValue > 255) {
                        this.rom[oppOffset] = -1;
                        this.rom[oppOffset + 1] = 33;
                        this.rom[oppOffset + 2] = (byte)(oppValue - 255);
                        this.rom[oppOffset + 3] = 49;
                    } else {
                        this.rom[oppOffset] = (byte)oppValue;
                        this.rom[oppOffset + 1] = 33;
                        this.writeWord(oppOffset + 2, 18112);
                    }
                }
            }
        }
        if (this.romEntry.getValue("CatchingTutorialPlayerMonOffset") > 0) {
            int playerOffset = this.romEntry.getValue("CatchingTutorialPlayerMonOffset");
            Pokemon playerMon = this.randomPokemonLimited(510, false);
            if (playerMon != null) {
                int plyValue = this.pokedexToInternal[playerMon.number];
                if (plyValue > 255) {
                    this.rom[playerOffset] = -1;
                    this.rom[playerOffset + 1] = 33;
                    this.rom[playerOffset + 2] = (byte)(plyValue - 255);
                    this.rom[playerOffset + 3] = 49;
                } else {
                    this.rom[playerOffset] = (byte)plyValue;
                    this.rom[playerOffset + 1] = 33;
                    this.writeWord(playerOffset + 2, 18112);
                }
            }
        }
    }

    private void applyRunningShoesIndoorsPatch() {
        if (this.romEntry.getValue("RunIndoorsTweakOffset") != 0) {
            this.rom[((RomEntry)this.romEntry).getValue((String)"RunIndoorsTweakOffset")] = 0;
        }
    }

    private void applyFastestTextPatch() {
        if (this.romEntry.getValue("TextSpeedValuesOffset") > 0) {
            int tsvOffset = this.romEntry.getValue("TextSpeedValuesOffset");
            this.rom[tsvOffset] = 4;
            this.rom[tsvOffset + 1] = 1;
            this.rom[tsvOffset + 2] = 0;
        }
    }

    @Override
    public boolean isROMHack() {
        return this.isRomHack;
    }

    @Override
    public BufferedImage getMascotImage() {
        Pokemon mascotPk = this.randomPokemon();
        int mascotPokemon = this.pokedexToInternal[mascotPk.number];
        int frontSprites = this.romEntry.getValue("FrontSprites");
        int palettes = this.romEntry.getValue("PokemonPalettes");
        int fsOffset = this.readPointer(frontSprites + mascotPokemon * 8);
        int palOffset = this.readPointer(palettes + mascotPokemon * 8);
        byte[] trueFrontSprite = DSDecmp.Decompress(this.rom, fsOffset);
        byte[] truePalette = DSDecmp.Decompress(this.rom, palOffset);
        int[] convPalette = new int[16];
        for (int i = 0; i < 15; ++i) {
            int palValue = this.readWord(truePalette, i * 2 + 2);
            convPalette[i + 1] = GFXFunctions.conv16BitColorToARGB(palValue);
        }
        BufferedImage bim = GFXFunctions.drawTiledImage(trueFrontSprite, convPalette, 64, 64, 4);
        return bim;
    }

    static {
        Gen3RomHandler.loadROMInfo();
    }

    private static class StaticPokemon {
        private int[] offsets;

        public StaticPokemon(int ... offsets) {
            this.offsets = offsets;
        }

        public Pokemon getPokemon(Gen3RomHandler parent) {
            return parent.pokesInternal[parent.readWord(this.offsets[0])];
        }

        public void setPokemon(Gen3RomHandler parent, Pokemon pkmn) {
            int value = parent.pokedexToInternal[pkmn.number];
            for (int offset : this.offsets) {
                parent.writeWord(offset, value);
            }
        }
    }

    private static class TMOrMTTextEntry {
        private int number;
        private int mapBank;
        private int mapNumber;
        private int personNum;
        private int offsetInScript;
        private int actualOffset;
        private String template;
        private boolean isMoveTutor;

        private TMOrMTTextEntry() {
        }
    }

    private static class RomEntry {
        private String name;
        private String romCode;
        private String tableFile;
        private int version;
        private int romType;
        private boolean copyStaticPokemon;
        private Map<String, Integer> entries = new HashMap<String, Integer>();
        private Map<String, int[]> arrayEntries = new HashMap<String, int[]>();
        private List<StaticPokemon> staticPokemon = new ArrayList<StaticPokemon>();
        private List<TMOrMTTextEntry> tmmtTexts = new ArrayList<TMOrMTTextEntry>();

        public RomEntry() {
        }

        public RomEntry(RomEntry toCopy) {
            this.name = toCopy.name;
            this.romCode = toCopy.romCode;
            this.tableFile = toCopy.tableFile;
            this.version = toCopy.version;
            this.romType = toCopy.romType;
            this.copyStaticPokemon = toCopy.copyStaticPokemon;
            this.entries.putAll(toCopy.entries);
            this.arrayEntries.putAll(toCopy.arrayEntries);
            this.staticPokemon.addAll(toCopy.staticPokemon);
            this.tmmtTexts.addAll(toCopy.tmmtTexts);
        }

        private int getValue(String key) {
            if (!this.entries.containsKey(key)) {
                this.entries.put(key, 0);
            }
            return this.entries.get(key);
        }
    }

    public static class Factory
    extends RomHandler.Factory {
        @Override
        public Gen3RomHandler create(Random random, PrintStream logStream) {
            return new Gen3RomHandler(random, logStream);
        }

        @Override
        public boolean isLoadable(String filename) {
            long fileLength = new File(filename).length();
            if (fileLength > 0x2000000L) {
                return false;
            }
            byte[] loaded = AbstractGBRomHandler.loadFilePartial(filename, 0x100000);
            if (loaded.length == 0) {
                return false;
            }
            return Gen3RomHandler.detectRomInner(loaded, (int)fileLength);
        }
    }
}

