/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.GFXFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RomFunctions;
import com.dabomstew.pkrandom.constants.Gen2Constants;
import com.dabomstew.pkrandom.constants.GlobalConstants;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.EvolutionType;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.romhandlers.AbstractGBCRomHandler;
import com.dabomstew.pkrandom.romhandlers.AbstractGBRomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import compressors.Gen2Decmp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;

public class Gen2RomHandler
extends AbstractGBCRomHandler {
    private static List<RomEntry> roms;
    private Pokemon[] pokes;
    private List<Pokemon> pokemonList;
    private RomEntry romEntry;
    private Move[] moves;
    private boolean havePatchedFleeing;
    private String[] itemNames;
    private List<Integer> itemOffs;
    private String[][] mapNames;
    private String[] landmarkNames;
    private boolean isVietCrystal;
    private ItemList allowedItems;
    private ItemList nonBadItems;

    public Gen2RomHandler(Random random) {
        super(random, null);
    }

    public Gen2RomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    private static void loadROMInfo() {
        roms = new ArrayList<RomEntry>();
        RomEntry current = null;
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig("gen2_offsets.ini"), "UTF-8");
            while (sc.hasNextLine()) {
                int c;
                int[] offs;
                String q = sc.nextLine().trim();
                if (q.contains("//")) {
                    q = q.substring(0, q.indexOf("//")).trim();
                }
                if (q.isEmpty()) continue;
                if (q.startsWith("[") && q.endsWith("]")) {
                    current = new RomEntry();
                    current.name = q.substring(1, q.length() - 1);
                    roms.add(current);
                    continue;
                }
                String[] r = q.split("=", 2);
                if (r.length == 1) {
                    System.err.println("invalid entry " + q);
                    continue;
                }
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                r[1] = r[1].trim();
                r[0] = r[0].trim();
                if (r[0].equals("StaticPokemon[]")) {
                    if (r[1].startsWith("[") && r[1].endsWith("]")) {
                        String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                        offs = new int[offsets.length];
                        c = 0;
                        for (String off : offsets) {
                            offs[c++] = Gen2RomHandler.parseRIInt(off);
                        }
                        current.staticPokemon.add(new StaticPokemon(offs));
                        continue;
                    }
                    int offs2 = Gen2RomHandler.parseRIInt(r[1]);
                    current.staticPokemon.add(new StaticPokemon(offs2));
                    continue;
                }
                if (r[0].equals("StaticPokemonGameCorner[]")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    offs = new int[offsets.length];
                    c = 0;
                    for (String off : offsets) {
                        offs[c++] = Gen2RomHandler.parseRIInt(off);
                    }
                    current.staticPokemon.add(new StaticPokemonGameCorner(offs));
                    continue;
                }
                if (r[0].equals("TMText[]")) {
                    if (!r[1].startsWith("[") || !r[1].endsWith("]")) continue;
                    String[] parts = r[1].substring(1, r[1].length() - 1).split(",", 3);
                    TMTextEntry tte = new TMTextEntry();
                    tte.number = Gen2RomHandler.parseRIInt(parts[0]);
                    tte.offset = Gen2RomHandler.parseRIInt(parts[1]);
                    tte.template = parts[2];
                    current.tmTexts.add(tte);
                    continue;
                }
                if (r[0].equals("Game")) {
                    current.romCode = r[1];
                    continue;
                }
                if (r[0].equals("Version")) {
                    current.version = Gen2RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].equals("NonJapanese")) {
                    current.nonJapanese = Gen2RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].equals("Type")) {
                    if (r[1].equalsIgnoreCase("Crystal")) {
                        current.isCrystal = true;
                        continue;
                    }
                    current.isCrystal = false;
                    continue;
                }
                if (r[0].equals("ExtraTableFile")) {
                    current.extraTableFile = r[1];
                    continue;
                }
                if (r[0].equals("CRCInHeader")) {
                    current.crcInHeader = Gen2RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].endsWith("Tweak")) {
                    current.codeTweaks.put(r[0], r[1]);
                    continue;
                }
                if (r[0].equals("CopyFrom")) {
                    for (RomEntry otherEntry : roms) {
                        if (!r[1].equalsIgnoreCase(otherEntry.name)) continue;
                        boolean cSP = current.getValue("CopyStaticPokemon") == 1;
                        boolean cTT = current.getValue("CopyTMText") == 1;
                        current.arrayEntries.putAll(otherEntry.arrayEntries);
                        current.entries.putAll(otherEntry.entries);
                        if (cSP) {
                            current.staticPokemon.addAll(otherEntry.staticPokemon);
                            current.entries.put("StaticPokemonSupport", 1);
                        } else {
                            current.entries.put("StaticPokemonSupport", 0);
                            current.entries.remove("StaticPokemonOddEggOffset");
                            current.entries.remove("StaticPokemonOddEggDataSize");
                        }
                        if (cTT) {
                            current.tmTexts.addAll(otherEntry.tmTexts);
                        }
                        current.extraTableFile = otherEntry.extraTableFile;
                    }
                    continue;
                }
                if (r[1].startsWith("[") && r[1].endsWith("]")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    if (offsets.length == 1 && offsets[0].trim().isEmpty()) {
                        current.arrayEntries.put(r[0], new int[0]);
                        continue;
                    }
                    offs = new int[offsets.length];
                    c = 0;
                    for (String off : offsets) {
                        offs[c++] = Gen2RomHandler.parseRIInt(off);
                    }
                    current.arrayEntries.put(r[0], offs);
                    continue;
                }
                int offs3 = Gen2RomHandler.parseRIInt(r[1]);
                current.entries.put(r[0], offs3);
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static int parseRIInt(String off) {
        int radix = 10;
        if ((off = off.trim().toLowerCase()).startsWith("0x") || off.startsWith("&h")) {
            radix = 16;
            off = off.substring(2);
        }
        try {
            return Integer.parseInt(off, radix);
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid base " + radix + "number " + off);
            return 0;
        }
    }

    @Override
    public boolean detectRom(byte[] rom) {
        return Gen2RomHandler.detectRomInner(rom, rom.length);
    }

    private static boolean detectRomInner(byte[] rom, int romSize) {
        if (romSize < 524288 || romSize > 0x200000) {
            return false;
        }
        return Gen2RomHandler.checkRomEntry(rom) != null;
    }

    @Override
    public void loadedRom() {
        this.romEntry = Gen2RomHandler.checkRomEntry(this.rom);
        this.clearTextTables();
        this.readTextTable("gameboy_jap");
        if (this.romEntry.extraTableFile != null && !this.romEntry.extraTableFile.equalsIgnoreCase("none")) {
            this.readTextTable(this.romEntry.extraTableFile);
        }
        if (this.romEntry.name.equals("Crystal (J)") && this.rom[99] == -11) {
            this.readTextTable("vietcrystal");
            this.isVietCrystal = true;
        } else {
            this.isVietCrystal = false;
        }
        this.havePatchedFleeing = false;
        this.loadPokemonStats();
        this.pokemonList = Arrays.asList(this.pokes);
        this.loadMoves();
        this.loadLandmarkNames();
        this.preprocessMaps();
        this.loadItemNames();
        this.allowedItems = Gen2Constants.allowedItems.copy();
        this.nonBadItems = Gen2Constants.nonBadItems.copy();
    }

    private static RomEntry checkRomEntry(byte[] rom) {
        int version = rom[332] & 0xFF;
        int nonjap = rom[330] & 0xFF;
        int crcInHeader = (rom[334] & 0xFF) << 8 | rom[335] & 0xFF;
        for (RomEntry re : roms) {
            if (!Gen2RomHandler.romCode(rom, re.romCode) || re.version != version || re.nonJapanese != nonjap || re.crcInHeader != crcInHeader) continue;
            return re;
        }
        for (RomEntry re : roms) {
            if (!Gen2RomHandler.romCode(rom, re.romCode) || re.version != version || re.nonJapanese != nonjap || re.crcInHeader != -1) continue;
            return re;
        }
        return null;
    }

    @Override
    public void savingRom() {
        this.savePokemonStats();
        this.saveMoves();
    }

    private void loadPokemonStats() {
        this.pokes = new Pokemon[252];
        String[] pokeNames = this.readPokemonNames();
        int offs = this.romEntry.getValue("PokemonStatsOffset");
        for (int i = 1; i <= 251; ++i) {
            this.pokes[i] = new Pokemon();
            this.pokes[i].number = i;
            this.loadBasicPokeStats(this.pokes[i], offs + (i - 1) * 32);
            this.pokes[i].name = pokeNames[i];
        }
        this.populateEvolutions();
    }

    private void savePokemonStats() {
        int offs = this.romEntry.getValue("PokemonNamesOffset");
        int len = this.romEntry.getValue("PokemonNamesLength");
        for (int i = 1; i <= 251; ++i) {
            int stringOffset = offs + (i - 1) * len;
            this.writeFixedLengthString(this.pokes[i].name, stringOffset, len);
        }
        int offs2 = this.romEntry.getValue("PokemonStatsOffset");
        for (int i = 1; i <= 251; ++i) {
            this.saveBasicPokeStats(this.pokes[i], offs2 + (i - 1) * 32);
        }
        this.writeEvosAndMovesLearnt(true, null);
    }

    private String[] readMoveNames() {
        int offset = this.romEntry.getValue("MoveNamesOffset");
        String[] moveNames = new String[252];
        for (int i = 1; i <= 251; ++i) {
            moveNames[i] = this.readVariableLengthString(offset, false);
            offset += this.lengthOfStringAt(offset, false) + 1;
        }
        return moveNames;
    }

    private void loadMoves() {
        this.moves = new Move[252];
        String[] moveNames = this.readMoveNames();
        int offs = this.romEntry.getValue("MoveDataOffset");
        for (int i = 1; i <= 251; ++i) {
            this.moves[i] = new Move();
            this.moves[i].name = moveNames[i];
            this.moves[i].number = i;
            this.moves[i].internalId = i;
            this.moves[i].effectIndex = this.rom[offs + (i - 1) * 7 + 1] & 0xFF;
            this.moves[i].hitratio = (double)((this.rom[offs + (i - 1) * 7 + 4] & 0xFF) + 0) / 255.0 * 100.0;
            this.moves[i].power = this.rom[offs + (i - 1) * 7 + 2] & 0xFF;
            this.moves[i].pp = this.rom[offs + (i - 1) * 7 + 5] & 0xFF;
            this.moves[i].type = Gen2Constants.typeTable[this.rom[offs + (i - 1) * 7 + 3]];
            if (GlobalConstants.normalMultihitMoves.contains(i)) {
                this.moves[i].hitCount = 3.0;
                continue;
            }
            if (GlobalConstants.doubleHitMoves.contains(i)) {
                this.moves[i].hitCount = 2.0;
                continue;
            }
            if (i != 167) continue;
            this.moves[i].hitCount = 2.71;
        }
    }

    private void saveMoves() {
        int offs = this.romEntry.getValue("MoveDataOffset");
        for (int i = 1; i <= 251; ++i) {
            this.rom[offs + (i - 1) * 7 + 1] = (byte)this.moves[i].effectIndex;
            this.rom[offs + (i - 1) * 7 + 2] = (byte)this.moves[i].power;
            this.rom[offs + (i - 1) * 7 + 3] = Gen2Constants.typeToByte(this.moves[i].type);
            int hitratio = (int)Math.round(this.moves[i].hitratio * 2.55);
            if (hitratio < 0) {
                hitratio = 0;
            }
            if (hitratio > 255) {
                hitratio = 255;
            }
            this.rom[offs + (i - 1) * 7 + 4] = (byte)hitratio;
            this.rom[offs + (i - 1) * 7 + 5] = (byte)this.moves[i].pp;
        }
    }

    @Override
    public List<Move> getMoves() {
        return Arrays.asList(this.moves);
    }

    private void loadBasicPokeStats(Pokemon pkmn, int offset) {
        pkmn.hp = this.rom[offset + 1] & 0xFF;
        pkmn.attack = this.rom[offset + 2] & 0xFF;
        pkmn.defense = this.rom[offset + 3] & 0xFF;
        pkmn.speed = this.rom[offset + 4] & 0xFF;
        pkmn.spatk = this.rom[offset + 5] & 0xFF;
        pkmn.spdef = this.rom[offset + 6] & 0xFF;
        pkmn.primaryType = Gen2Constants.typeTable[this.rom[offset + 7] & 0xFF];
        pkmn.secondaryType = Gen2Constants.typeTable[this.rom[offset + 8] & 0xFF];
        if (pkmn.secondaryType == pkmn.primaryType) {
            pkmn.secondaryType = null;
        }
        pkmn.catchRate = this.rom[offset + 9] & 0xFF;
        pkmn.guaranteedHeldItem = -1;
        pkmn.commonHeldItem = this.rom[offset + 11] & 0xFF;
        pkmn.rareHeldItem = this.rom[offset + 12] & 0xFF;
        pkmn.darkGrassHeldItem = -1;
        pkmn.growthCurve = ExpCurve.fromByte(this.rom[offset + 22]);
        pkmn.picDimensions = this.rom[offset + 17] & 0xFF;
    }

    private void saveBasicPokeStats(Pokemon pkmn, int offset) {
        this.rom[offset + 1] = (byte)pkmn.hp;
        this.rom[offset + 2] = (byte)pkmn.attack;
        this.rom[offset + 3] = (byte)pkmn.defense;
        this.rom[offset + 4] = (byte)pkmn.speed;
        this.rom[offset + 5] = (byte)pkmn.spatk;
        this.rom[offset + 6] = (byte)pkmn.spdef;
        this.rom[offset + 7] = Gen2Constants.typeToByte(pkmn.primaryType);
        this.rom[offset + 8] = pkmn.secondaryType == null ? this.rom[offset + 7] : Gen2Constants.typeToByte(pkmn.secondaryType);
        this.rom[offset + 9] = (byte)pkmn.catchRate;
        this.rom[offset + 11] = (byte)pkmn.commonHeldItem;
        this.rom[offset + 12] = (byte)pkmn.rareHeldItem;
        this.rom[offset + 22] = pkmn.growthCurve.toByte();
    }

    private String[] readPokemonNames() {
        int offs = this.romEntry.getValue("PokemonNamesOffset");
        int len = this.romEntry.getValue("PokemonNamesLength");
        String[] names = new String[252];
        for (int i = 1; i <= 251; ++i) {
            names[i] = this.readFixedLengthString(offs + (i - 1) * len, len);
        }
        return names;
    }

    @Override
    public List<Pokemon> getStarters() {
        ArrayList<Pokemon> starters = new ArrayList<Pokemon>();
        starters.add(this.pokes[this.rom[((int[])this.romEntry.arrayEntries.get("StarterOffsets1"))[0]] & 0xFF]);
        starters.add(this.pokes[this.rom[((int[])this.romEntry.arrayEntries.get("StarterOffsets2"))[0]] & 0xFF]);
        starters.add(this.pokes[this.rom[((int[])this.romEntry.arrayEntries.get("StarterOffsets3"))[0]] & 0xFF]);
        return starters;
    }

    @Override
    public boolean setStarters(List<Pokemon> newStarters) {
        if (newStarters.size() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            int[] offsets;
            byte starter = (byte)newStarters.get((int)i).number;
            for (int offset : offsets = (int[])this.romEntry.arrayEntries.get("StarterOffsets" + (i + 1))) {
                this.rom[offset] = starter;
            }
        }
        if (this.romEntry.getValue("CanChangeStarterText") > 0) {
            int[] starterTextOffsets = (int[])this.romEntry.arrayEntries.get("StarterTextOffsets");
            for (int i = 0; i < 3 && i < starterTextOffsets.length; ++i) {
                this.writeVariableLengthString(String.format("%s?\\e", newStarters.get((int)i).name), starterTextOffsets[i], true);
            }
        }
        return true;
    }

    @Override
    public List<Integer> getStarterHeldItems() {
        int[] shiOffsets;
        ArrayList<Integer> sHeldItems = new ArrayList<Integer>();
        for (int offset : shiOffsets = (int[])this.romEntry.arrayEntries.get("StarterHeldItems")) {
            sHeldItems.add(this.rom[offset] & 0xFF);
        }
        return sHeldItems;
    }

    @Override
    public void setStarterHeldItems(List<Integer> items) {
        int[] shiOffsets = (int[])this.romEntry.arrayEntries.get("StarterHeldItems");
        if (items.size() != shiOffsets.length) {
            return;
        }
        Iterator<Integer> sHeldItems = items.iterator();
        for (int offset : shiOffsets) {
            this.rom[offset] = sHeldItems.next().byteValue();
        }
    }

    @Override
    public List<EncounterSet> getEncounters(boolean useTimeOfDay) {
        int level;
        int pokeNum;
        int i;
        EncounterSet es;
        int k;
        int offset = this.romEntry.getValue("WildPokemonOffset");
        ArrayList<EncounterSet> areas = new ArrayList<EncounterSet>();
        offset = this.readLandEncounters(offset, areas, useTimeOfDay);
        offset = this.readSeaEncounters(offset, areas);
        offset = this.readLandEncounters(offset, areas, useTimeOfDay);
        offset = this.readSeaEncounters(offset, areas);
        offset = this.readLandEncounters(offset, areas, useTimeOfDay);
        offset = this.readSeaEncounters(offset, areas);
        int rootOffset = offset = this.romEntry.getValue("FishingWildsOffset");
        for (k = 0; k < 12; ++k) {
            es = new EncounterSet();
            es.displayName = "Fishing Group " + (k + 1);
            for (i = 0; i < 11; ++i) {
                int n = ++offset;
                pokeNum = this.rom[n] & 0xFF;
                int n2 = ++offset;
                ++offset;
                level = this.rom[n2] & 0xFF;
                if (pokeNum == 0) {
                    if (useTimeOfDay) continue;
                    int specialOffset = rootOffset + 396 + level * 4 + 2;
                    Encounter enc = new Encounter();
                    enc.pokemon = this.pokes[this.rom[specialOffset] & 0xFF];
                    enc.level = this.rom[specialOffset + 1] & 0xFF;
                    es.encounters.add(enc);
                    continue;
                }
                Encounter enc = new Encounter();
                enc.pokemon = this.pokes[pokeNum];
                enc.level = level;
                es.encounters.add(enc);
            }
            areas.add(es);
        }
        if (useTimeOfDay) {
            for (k = 0; k < 11; ++k) {
                es = new EncounterSet();
                es.displayName = "Time-Specific Fishing " + (k + 1);
                for (i = 0; i < 4; ++i) {
                    pokeNum = this.rom[offset++] & 0xFF;
                    level = this.rom[offset++] & 0xFF;
                    Encounter enc = new Encounter();
                    enc.pokemon = this.pokes[pokeNum];
                    enc.level = level;
                    es.encounters.add(enc);
                }
                areas.add(es);
            }
        }
        offset = this.romEntry.getValue("HeadbuttWildsOffset");
        int limit = this.romEntry.getValue("HeadbuttTableSize");
        for (int i2 = 0; i2 < limit; ++i2) {
            EncounterSet es2 = new EncounterSet();
            es2.displayName = "Headbutt Trees Set " + (i2 + 1);
            while ((this.rom[offset] & 0xFF) != 255) {
                int n = ++offset;
                pokeNum = this.rom[n] & 0xFF;
                int n3 = ++offset;
                ++offset;
                level = this.rom[n3] & 0xFF;
                Encounter enc = new Encounter();
                enc.pokemon = this.pokes[pokeNum];
                enc.level = level;
                es2.encounters.add(enc);
            }
            ++offset;
            areas.add(es2);
        }
        offset = this.romEntry.getValue("BCCWildsOffset");
        EncounterSet bccES = new EncounterSet();
        bccES.displayName = "Bug Catching Contest";
        while ((this.rom[offset] & 0xFF) != 255) {
            Encounter enc = new Encounter();
            int n = ++offset;
            enc.pokemon = this.pokes[this.rom[n] & 0xFF];
            int n4 = ++offset;
            enc.level = this.rom[n4] & 0xFF;
            int n5 = ++offset;
            ++offset;
            enc.maxLevel = this.rom[n5] & 0xFF;
            bccES.encounters.add(enc);
        }
        areas.add(bccES);
        return areas;
    }

    private int readLandEncounters(int offset, List<EncounterSet> areas, boolean useTimeOfDay) {
        String[] todNames = new String[]{"Morning", "Day", "Night"};
        while ((this.rom[offset] & 0xFF) != 255) {
            int mapBank = this.rom[offset] & 0xFF;
            int mapNumber = this.rom[offset + 1] & 0xFF;
            String mapName = this.mapNames[mapBank][mapNumber];
            if (useTimeOfDay) {
                for (int i = 0; i < 3; ++i) {
                    EncounterSet encset = new EncounterSet();
                    encset.rate = this.rom[offset + 2 + i] & 0xFF;
                    encset.displayName = mapName + " Grass/Cave (" + todNames[i] + ")";
                    for (int j = 0; j < 7; ++j) {
                        Encounter enc = new Encounter();
                        enc.level = this.rom[offset + 5 + i * 7 * 2 + j * 2] & 0xFF;
                        enc.maxLevel = 0;
                        enc.pokemon = this.pokes[this.rom[offset + 5 + i * 7 * 2 + j * 2 + 1] & 0xFF];
                        encset.encounters.add(enc);
                    }
                    areas.add(encset);
                }
            } else {
                EncounterSet encset = new EncounterSet();
                encset.rate = this.rom[offset + 3] & 0xFF;
                encset.displayName = mapName + " Grass/Cave";
                for (int j = 0; j < 7; ++j) {
                    Encounter enc = new Encounter();
                    enc.level = this.rom[offset + 5 + 14 + j * 2] & 0xFF;
                    enc.maxLevel = 0;
                    enc.pokemon = this.pokes[this.rom[offset + 5 + 14 + j * 2 + 1] & 0xFF];
                    encset.encounters.add(enc);
                }
                areas.add(encset);
            }
            offset += 47;
        }
        return offset + 1;
    }

    private int readSeaEncounters(int offset, List<EncounterSet> areas) {
        while ((this.rom[offset] & 0xFF) != 255) {
            int mapBank = this.rom[offset] & 0xFF;
            int mapNumber = this.rom[offset + 1] & 0xFF;
            String mapName = this.mapNames[mapBank][mapNumber];
            EncounterSet encset = new EncounterSet();
            encset.rate = this.rom[offset + 2] & 0xFF;
            encset.displayName = mapName + " Surfing";
            for (int j = 0; j < 3; ++j) {
                Encounter enc = new Encounter();
                enc.level = this.rom[offset + 3 + j * 2] & 0xFF;
                enc.maxLevel = 0;
                enc.pokemon = this.pokes[this.rom[offset + 3 + j * 2 + 1] & 0xFF];
                encset.encounters.add(enc);
            }
            areas.add(encset);
            offset += 9;
        }
        return offset + 1;
    }

    @Override
    public void setEncounters(boolean useTimeOfDay, List<EncounterSet> encounters) {
        Encounter enc;
        int i;
        Iterator<Encounter> encs;
        EncounterSet es;
        int k;
        if (!this.havePatchedFleeing) {
            this.patchFleeing();
        }
        int offset = this.romEntry.getValue("WildPokemonOffset");
        Iterator<EncounterSet> areas = encounters.iterator();
        offset = this.writeLandEncounters(offset, areas, useTimeOfDay);
        offset = this.writeSeaEncounters(offset, areas);
        offset = this.writeLandEncounters(offset, areas, useTimeOfDay);
        offset = this.writeSeaEncounters(offset, areas);
        offset = this.writeLandEncounters(offset, areas, useTimeOfDay);
        offset = this.writeSeaEncounters(offset, areas);
        offset = this.romEntry.getValue("FishingWildsOffset");
        for (k = 0; k < 12; ++k) {
            es = areas.next();
            encs = es.encounters.iterator();
            for (i = 0; i < 11; ++i) {
                if (this.rom[++offset] == 0) {
                    if (!useTimeOfDay) {
                        enc = encs.next();
                        this.rom[offset++] = (byte)enc.pokemon.number;
                        this.rom[offset++] = (byte)enc.level;
                        continue;
                    }
                    offset += 2;
                    continue;
                }
                enc = encs.next();
                this.rom[offset++] = (byte)enc.pokemon.number;
                this.rom[offset++] = (byte)enc.level;
            }
        }
        if (useTimeOfDay) {
            for (k = 0; k < 11; ++k) {
                es = areas.next();
                encs = es.encounters.iterator();
                for (i = 0; i < 4; ++i) {
                    enc = encs.next();
                    this.rom[offset++] = (byte)enc.pokemon.number;
                    this.rom[offset++] = (byte)enc.level;
                }
            }
        }
        offset = this.romEntry.getValue("HeadbuttWildsOffset");
        int limit = this.romEntry.getValue("HeadbuttTableSize");
        for (int i2 = 0; i2 < limit; ++i2) {
            EncounterSet es2 = areas.next();
            Iterator<Encounter> encs2 = es2.encounters.iterator();
            while ((this.rom[offset] & 0xFF) != 255) {
                enc = encs2.next();
                int n = ++offset;
                this.rom[n] = (byte)enc.pokemon.number;
                int n2 = ++offset;
                ++offset;
                this.rom[n2] = (byte)enc.level;
            }
            ++offset;
        }
        offset = this.romEntry.getValue("BCCWildsOffset");
        EncounterSet bccES = areas.next();
        Iterator<Encounter> bccEncs = bccES.encounters.iterator();
        while ((this.rom[offset] & 0xFF) != 255) {
            Encounter enc2 = bccEncs.next();
            int n = ++offset;
            this.rom[n] = (byte)enc2.pokemon.number;
            int n3 = ++offset;
            this.rom[n3] = (byte)enc2.level;
            int n4 = ++offset;
            ++offset;
            this.rom[n4] = (byte)enc2.maxLevel;
        }
    }

    private int writeLandEncounters(int offset, Iterator<EncounterSet> areas, boolean useTimeOfDay) {
        while ((this.rom[offset] & 0xFF) != 255) {
            int j;
            Iterator<Encounter> encountersHere;
            if (useTimeOfDay) {
                for (int i = 0; i < 3; ++i) {
                    EncounterSet encset = areas.next();
                    encountersHere = encset.encounters.iterator();
                    for (j = 0; j < 7; ++j) {
                        this.rom[offset + 5 + i * 7 * 2 + j * 2 + 1] = (byte)encountersHere.next().pokemon.number;
                    }
                }
            } else {
                EncounterSet encset = areas.next();
                for (int i = 0; i < 3; ++i) {
                    encountersHere = encset.encounters.iterator();
                    for (j = 0; j < 7; ++j) {
                        this.rom[offset + 5 + i * 7 * 2 + j * 2 + 1] = (byte)encountersHere.next().pokemon.number;
                    }
                }
            }
            offset += 47;
        }
        return offset + 1;
    }

    private int writeSeaEncounters(int offset, Iterator<EncounterSet> areas) {
        while ((this.rom[offset] & 0xFF) != 255) {
            EncounterSet encset = areas.next();
            Iterator<Encounter> encountersHere = encset.encounters.iterator();
            for (int j = 0; j < 3; ++j) {
                this.rom[offset + 3 + j * 2 + 1] = (byte)encountersHere.next().pokemon.number;
            }
            offset += 9;
        }
        return offset + 1;
    }

    @Override
    public List<Trainer> getTrainers() {
        int traineroffset = this.romEntry.getValue("TrainerDataTableOffset");
        int traineramount = this.romEntry.getValue("TrainerClassAmount");
        int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
        int[] pointers = new int[traineramount];
        for (int i = 0; i < traineramount; ++i) {
            int pointer = this.readWord(traineroffset + i * 2);
            pointers[i] = this.calculateOffset(this.bankOf(traineroffset), pointer);
        }
        List<String> tcnames = this.getTrainerClassNames();
        ArrayList<Trainer> allTrainers = new ArrayList<Trainer>();
        for (int i = 0; i < traineramount; ++i) {
            int offs = pointers[i];
            int limit = trainerclasslimits[i];
            for (int trnum = 0; trnum < limit; ++trnum) {
                int dataType;
                String name;
                Trainer tr = new Trainer();
                tr.offset = offs;
                tr.trainerclass = i;
                tr.name = name = this.readVariableLengthString(offs, false);
                tr.fullDisplayName = tcnames.get(i) + " " + name;
                offs += this.lengthOfStringAt(offs, false) + 1;
                tr.poketype = dataType = this.rom[offs] & 0xFF;
                ++offs;
                while ((this.rom[offs] & 0xFF) != 255) {
                    TrainerPokemon tp = new TrainerPokemon();
                    tp.level = this.rom[offs] & 0xFF;
                    tp.pokemon = this.pokes[this.rom[offs + 1] & 0xFF];
                    offs += 2;
                    if ((dataType & 2) == 2) {
                        tp.heldItem = this.rom[offs] & 0xFF;
                        ++offs;
                    }
                    if ((dataType & 1) == 1) {
                        tp.move1 = this.rom[offs] & 0xFF;
                        tp.move2 = this.rom[offs + 1] & 0xFF;
                        tp.move3 = this.rom[offs + 2] & 0xFF;
                        tp.move4 = this.rom[offs + 3] & 0xFF;
                        offs += 4;
                    }
                    tr.pokemon.add(tp);
                }
                allTrainers.add(tr);
                ++offs;
            }
        }
        Gen2Constants.universalTrainerTags(allTrainers);
        if (this.romEntry.isCrystal) {
            Gen2Constants.crystalTags(allTrainers);
        } else {
            Gen2Constants.goldSilverTags(allTrainers);
        }
        return allTrainers;
    }

    @Override
    public void setTrainers(List<Trainer> trainerData) {
        int traineroffset = this.romEntry.getValue("TrainerDataTableOffset");
        int traineramount = this.romEntry.getValue("TrainerClassAmount");
        int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
        int[] pointers = new int[traineramount];
        for (int i = 0; i < traineramount; ++i) {
            int pointer = this.readWord(traineroffset + i * 2);
            pointers[i] = this.calculateOffset(this.bankOf(traineroffset), pointer);
        }
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        Iterator<Trainer> allTrainers = trainerData.iterator();
        for (int i = 0; i < traineramount; ++i) {
            int offs = pointers[i];
            int limit = trainerclasslimits[i];
            for (int trnum = 0; trnum < limit; ++trnum) {
                Trainer tr = allTrainers.next();
                if (tr.trainerclass != i) {
                    System.err.println("Trainer mismatch: " + tr.name);
                }
                int trnamelen = this.internalStringLength(tr.name);
                this.writeFixedLengthString(tr.name, offs, trnamelen + 1);
                offs += trnamelen + 1;
                this.rom[offs++] = (byte)tr.poketype;
                Iterator<TrainerPokemon> tPokes = tr.pokemon.iterator();
                for (int tpnum = 0; tpnum < tr.pokemon.size(); ++tpnum) {
                    TrainerPokemon tp = tPokes.next();
                    this.rom[offs] = (byte)tp.level;
                    this.rom[offs + 1] = (byte)tp.pokemon.number;
                    offs += 2;
                    if ((tr.poketype & 2) == 2) {
                        this.rom[offs] = (byte)tp.heldItem;
                        ++offs;
                    }
                    if ((tr.poketype & 1) != 1) continue;
                    if (tp.resetMoves) {
                        int[] pokeMoves = RomFunctions.getMovesAtLevel(tp.pokemon, movesets, tp.level);
                        for (int m = 0; m < 4; ++m) {
                            this.rom[offs + m] = (byte)pokeMoves[m];
                        }
                    } else {
                        this.rom[offs] = (byte)tp.move1;
                        this.rom[offs + 1] = (byte)tp.move2;
                        this.rom[offs + 2] = (byte)tp.move3;
                        this.rom[offs + 3] = (byte)tp.move4;
                    }
                    offs += 4;
                }
                this.rom[offs] = -1;
                ++offs;
            }
        }
    }

    @Override
    public List<Pokemon> getPokemon() {
        return this.pokemonList;
    }

    @Override
    public Map<Pokemon, List<MoveLearnt>> getMovesLearnt() {
        TreeMap<Pokemon, List<MoveLearnt>> movesets = new TreeMap<Pokemon, List<MoveLearnt>>();
        int pointersOffset = this.romEntry.getValue("PokemonMovesetsTableOffset");
        for (int i = 1; i <= 251; ++i) {
            int pointer = this.readWord(pointersOffset + (i - 1) * 2);
            int realPointer = this.calculateOffset(this.bankOf(pointersOffset), pointer);
            Pokemon pkmn = this.pokes[i];
            while (this.rom[realPointer] != 0) {
                if (this.rom[realPointer] == 5) {
                    realPointer += 4;
                    continue;
                }
                realPointer += 3;
            }
            ArrayList<MoveLearnt> ourMoves = new ArrayList<MoveLearnt>();
            ++realPointer;
            while (this.rom[realPointer] != 0) {
                MoveLearnt learnt = new MoveLearnt();
                learnt.level = this.rom[realPointer] & 0xFF;
                learnt.move = this.rom[realPointer + 1] & 0xFF;
                ourMoves.add(learnt);
                realPointer += 2;
            }
            movesets.put(pkmn, ourMoves);
        }
        return movesets;
    }

    @Override
    public void setMovesLearnt(Map<Pokemon, List<MoveLearnt>> movesets) {
        this.writeEvosAndMovesLearnt(false, movesets);
    }

    @Override
    public List<Integer> getMovesBannedFromLevelup() {
        return Gen2Constants.bannedLevelupMoves;
    }

    @Override
    public List<Pokemon> getStaticPokemon() {
        ArrayList<Pokemon> statics = new ArrayList<Pokemon>();
        if (this.romEntry.getValue("StaticPokemonSupport") > 0) {
            for (StaticPokemon sp : this.romEntry.staticPokemon) {
                statics.add(sp.getPokemon(this));
            }
        }
        if (this.romEntry.getValue("StaticPokemonOddEggOffset") > 0) {
            int oeOffset = this.romEntry.getValue("StaticPokemonOddEggOffset");
            int oeSize = this.romEntry.getValue("StaticPokemonOddEggDataSize");
            for (int i = 0; i < 14; ++i) {
                statics.add(this.pokes[this.rom[oeOffset + i * oeSize] & 0xFF]);
            }
        }
        return statics;
    }

    @Override
    public boolean setStaticPokemon(List<Pokemon> staticPokemon) {
        if (this.romEntry.getValue("StaticPokemonSupport") == 0) {
            return false;
        }
        if (!this.havePatchedFleeing) {
            this.patchFleeing();
        }
        int desiredSize = this.romEntry.staticPokemon.size();
        if (this.romEntry.getValue("StaticPokemonOddEggOffset") > 0) {
            desiredSize += 14;
        }
        if (staticPokemon.size() != desiredSize) {
            return false;
        }
        Iterator<Pokemon> statics = staticPokemon.iterator();
        for (StaticPokemon sp : this.romEntry.staticPokemon) {
            sp.setPokemon(this, statics.next());
        }
        if (this.romEntry.getValue("StaticPokemonOddEggOffset") > 0) {
            int oeOffset = this.romEntry.getValue("StaticPokemonOddEggOffset");
            int oeSize = this.romEntry.getValue("StaticPokemonOddEggDataSize");
            for (int i = 0; i < 14; ++i) {
                this.rom[oeOffset + i * oeSize] = (byte)statics.next().number;
            }
        }
        return true;
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return this.romEntry.getValue("StaticPokemonSupport") > 0;
    }

    @Override
    public List<Pokemon> bannedForStaticPokemon() {
        return Arrays.asList(this.pokes[201]);
    }

    private void writePaddedPokemonName(String name, int length, int offset) {
        String paddedName = String.format("%-" + length + "s", name);
        byte[] rawData = this.translateString(paddedName);
        for (int i = 0; i < length; ++i) {
            this.rom[offset + i] = rawData[i];
        }
    }

    @Override
    public List<Integer> getTMMoves() {
        ArrayList<Integer> tms = new ArrayList<Integer>();
        int offset = this.romEntry.getValue("TMMovesOffset");
        for (int i = 1; i <= 50; ++i) {
            tms.add(this.rom[offset + (i - 1)] & 0xFF);
        }
        return tms;
    }

    @Override
    public List<Integer> getHMMoves() {
        ArrayList<Integer> hms = new ArrayList<Integer>();
        int offset = this.romEntry.getValue("TMMovesOffset");
        for (int i = 1; i <= 7; ++i) {
            hms.add(this.rom[offset + 50 + (i - 1)] & 0xFF);
        }
        return hms;
    }

    @Override
    public void setTMMoves(List<Integer> moveIndexes) {
        int offset = this.romEntry.getValue("TMMovesOffset");
        for (int i = 1; i <= 50; ++i) {
            this.rom[offset + (i - 1)] = moveIndexes.get(i - 1).byteValue();
        }
        String[] moveNames = this.readMoveNames();
        for (TMTextEntry tte : this.romEntry.tmTexts) {
            String moveName = moveNames[moveIndexes.get(tte.number - 1)];
            String text = tte.template.replace("%m", moveName);
            this.writeVariableLengthString(text, tte.offset, true);
        }
    }

    @Override
    public int getTMCount() {
        return 50;
    }

    @Override
    public int getHMCount() {
        return 7;
    }

    @Override
    public Map<Pokemon, boolean[]> getTMHMCompatibility() {
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        for (int i = 1; i <= 251; ++i) {
            int baseStatsOffset = this.romEntry.getValue("PokemonStatsOffset") + (i - 1) * 32;
            Pokemon pkmn = this.pokes[i];
            boolean[] flags = new boolean[58];
            for (int j = 0; j < 8; ++j) {
                this.readByteIntoFlags(flags, j * 8 + 1, baseStatsOffset + 24 + j);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setTMHMCompatibility(Map<Pokemon, boolean[]> compatData) {
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            int baseStatsOffset = this.romEntry.getValue("PokemonStatsOffset") + (pkmn.number - 1) * 32;
            for (int j = 0; j < 8; ++j) {
                if (!this.romEntry.isCrystal || j != 7) {
                    this.rom[baseStatsOffset + 24 + j] = this.getByteFromFlags(flags, j * 8 + 1);
                    continue;
                }
                int changedByte = this.getByteFromFlags(flags, j * 8 + 1) & 0xFF;
                byte currentByte = this.rom[baseStatsOffset + 24 + j];
                changedByte |= (currentByte >> 1 & 1) << 1;
                changedByte |= (currentByte >> 2 & 1) << 2;
                this.rom[baseStatsOffset + 24 + j] = (byte)(changedByte |= (currentByte >> 3 & 1) << 3);
            }
        }
    }

    @Override
    public boolean hasMoveTutors() {
        return this.romEntry.isCrystal;
    }

    @Override
    public List<Integer> getMoveTutorMoves() {
        if (this.romEntry.isCrystal) {
            ArrayList<Integer> mtMoves = new ArrayList<Integer>();
            for (int offset : (int[])this.romEntry.arrayEntries.get("MoveTutorMoves")) {
                mtMoves.add(this.rom[offset] & 0xFF);
            }
            return mtMoves;
        }
        return new ArrayList<Integer>();
    }

    @Override
    public void setMoveTutorMoves(List<Integer> moves) {
        if (!this.romEntry.isCrystal) {
            return;
        }
        if (moves.size() != 3) {
            return;
        }
        Iterator<Integer> mvList = moves.iterator();
        for (int offset : (int[])this.romEntry.arrayEntries.get("MoveTutorMoves")) {
            this.rom[offset] = mvList.next().byteValue();
        }
        if (this.romEntry.getValue("MoveTutorMenuOffset") > 0 && this.romEntry.getValue("MoveTutorMenuNewSpace") > 0) {
            String[] moveNames = this.readMoveNames();
            String[] names = new String[]{moveNames[moves.get(0)], moveNames[moves.get(1)], moveNames[moves.get(2)], "CANCEL"};
            int menuOffset = this.romEntry.getValue("MoveTutorMenuNewSpace");
            this.rom[menuOffset++] = -128;
            this.rom[menuOffset++] = 4;
            for (int i = 0; i < 4; ++i) {
                byte[] trans = this.translateString(names[i]);
                System.arraycopy(trans, 0, this.rom, menuOffset, trans.length);
                menuOffset += trans.length;
                this.rom[menuOffset++] = 80;
            }
            int pointerOffset = this.romEntry.getValue("MoveTutorMenuOffset");
            this.writeWord(pointerOffset, this.makeGBPointer(this.romEntry.getValue("MoveTutorMenuNewSpace")));
        }
    }

    @Override
    public Map<Pokemon, boolean[]> getMoveTutorCompatibility() {
        if (!this.romEntry.isCrystal) {
            return new TreeMap<Pokemon, boolean[]>();
        }
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        for (int i = 1; i <= 251; ++i) {
            int baseStatsOffset = this.romEntry.getValue("PokemonStatsOffset") + (i - 1) * 32;
            Pokemon pkmn = this.pokes[i];
            boolean[] flags = new boolean[4];
            int mtByte = this.rom[baseStatsOffset + 31] & 0xFF;
            for (int j = 1; j <= 3; ++j) {
                flags[j] = (mtByte >> j & 1) > 0;
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setMoveTutorCompatibility(Map<Pokemon, boolean[]> compatData) {
        if (!this.romEntry.isCrystal) {
            return;
        }
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            int baseStatsOffset = this.romEntry.getValue("PokemonStatsOffset") + (pkmn.number - 1) * 32;
            int origMtByte = this.rom[baseStatsOffset + 31] & 0xFF;
            int mtByte = origMtByte & 1;
            for (int j = 1; j <= 3; ++j) {
                mtByte |= flags[j] ? 1 << j : 0;
            }
            this.rom[baseStatsOffset + 31] = (byte)mtByte;
        }
    }

    @Override
    public String getROMName() {
        if (this.isVietCrystal) {
            return "Pokemon VietCrystal";
        }
        return "Pokemon " + this.romEntry.name;
    }

    @Override
    public String getROMCode() {
        return this.romEntry.romCode;
    }

    @Override
    public String getSupportLevel() {
        return "Complete";
    }

    @Override
    public boolean hasTimeBasedEncounters() {
        return true;
    }

    private void populateEvolutions() {
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            pkmn.evolutionsFrom.clear();
            pkmn.evolutionsTo.clear();
        }
        int pointersOffset = this.romEntry.getValue("PokemonMovesetsTableOffset");
        for (int i = 1; i <= 251; ++i) {
            int pointer = this.readWord(pointersOffset + (i - 1) * 2);
            int realPointer = this.calculateOffset(this.bankOf(pointersOffset), pointer);
            Pokemon pkmn = this.pokes[i];
            int thisPoke = i;
            while (this.rom[realPointer] != 0) {
                int method = this.rom[realPointer] & 0xFF;
                int otherPoke = this.rom[realPointer + 2 + (method == 5 ? 1 : 0)] & 0xFF;
                EvolutionType type = EvolutionType.fromIndex(2, method);
                int extraInfo = 0;
                if (type == EvolutionType.TRADE) {
                    int itemNeeded = this.rom[realPointer + 1] & 0xFF;
                    if (itemNeeded != 255) {
                        type = EvolutionType.TRADE_ITEM;
                        extraInfo = itemNeeded;
                    }
                } else if (type == EvolutionType.LEVEL_ATTACK_HIGHER) {
                    int tyrogueCond = this.rom[realPointer + 2] & 0xFF;
                    if (tyrogueCond == 2) {
                        type = EvolutionType.LEVEL_DEFENSE_HIGHER;
                    } else if (tyrogueCond == 3) {
                        type = EvolutionType.LEVEL_ATK_DEF_SAME;
                    }
                    extraInfo = this.rom[realPointer + 1] & 0xFF;
                } else if (type == EvolutionType.HAPPINESS) {
                    int happCond = this.rom[realPointer + 1] & 0xFF;
                    if (happCond == 2) {
                        type = EvolutionType.HAPPINESS_DAY;
                    } else if (happCond == 3) {
                        type = EvolutionType.HAPPINESS_NIGHT;
                    }
                } else {
                    extraInfo = this.rom[realPointer + 1] & 0xFF;
                }
                Evolution evo = new Evolution(this.pokes[thisPoke], this.pokes[otherPoke], true, type, extraInfo);
                if (!pkmn.evolutionsFrom.contains(evo)) {
                    pkmn.evolutionsFrom.add(evo);
                    this.pokes[otherPoke].evolutionsTo.add(evo);
                }
                realPointer += method == 5 ? 4 : 3;
            }
            if (pkmn.evolutionsFrom.size() <= 1) continue;
            for (Evolution e : pkmn.evolutionsFrom) {
                e.carryStats = false;
            }
        }
    }

    @Override
    public void removeTradeEvolutions(boolean changeMoveEvos) {
        this.log("--Removing Trade Evolutions--");
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            for (Evolution evol : pkmn.evolutionsFrom) {
                if (evol.type != EvolutionType.TRADE && evol.type != EvolutionType.TRADE_ITEM) continue;
                if (evol.from.number == 79) {
                    evol.type = EvolutionType.STONE;
                    evol.extraInfo = 24;
                    this.logEvoChangeStone(evol.from.name, evol.to.name, this.itemNames[24]);
                    continue;
                }
                if (evol.from.number == 117) {
                    evol.type = EvolutionType.LEVEL;
                    evol.extraInfo = 40;
                    this.logEvoChangeLevel(evol.from.name, evol.to.name, 40);
                    continue;
                }
                if (evol.from.number == 61 || evol.type == EvolutionType.TRADE) {
                    evol.type = EvolutionType.LEVEL;
                    evol.extraInfo = 37;
                    this.logEvoChangeLevel(evol.from.name, evol.to.name, 37);
                    continue;
                }
                evol.type = EvolutionType.LEVEL;
                evol.extraInfo = 30;
                this.logEvoChangeLevel(evol.from.name, evol.to.name, 30);
            }
        }
        this.logBlankLine();
    }

    @Override
    public boolean canChangeTrainerText() {
        return this.romEntry.getValue("CanChangeTrainerText") > 0;
    }

    @Override
    public List<String> getTrainerNames() {
        int traineroffset = this.romEntry.getValue("TrainerDataTableOffset");
        int traineramount = this.romEntry.getValue("TrainerClassAmount");
        int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
        int[] pointers = new int[traineramount];
        for (int i = 0; i < traineramount; ++i) {
            int pointer = this.readWord(traineroffset + i * 2);
            pointers[i] = this.calculateOffset(this.bankOf(traineroffset), pointer);
        }
        ArrayList<String> allTrainers = new ArrayList<String>();
        for (int i = 0; i < traineramount; ++i) {
            int offs = pointers[i];
            int limit = trainerclasslimits[i];
            for (int trnum = 0; trnum < limit; ++trnum) {
                String name = this.readVariableLengthString(offs, false);
                allTrainers.add(name);
                offs += this.lengthOfStringAt(offs, false) + 1;
                int dataType = this.rom[offs] & 0xFF;
                ++offs;
                while ((this.rom[offs] & 0xFF) != 255) {
                    offs += 2;
                    if (dataType == 2 || dataType == 3) {
                        ++offs;
                    }
                    if (dataType % 2 != 1) continue;
                    offs += 4;
                }
                ++offs;
            }
        }
        return allTrainers;
    }

    @Override
    public void setTrainerNames(List<String> trainerNames) {
        if (this.romEntry.getValue("CanChangeTrainerText") != 0) {
            int traineroffset = this.romEntry.getValue("TrainerDataTableOffset");
            int traineramount = this.romEntry.getValue("TrainerClassAmount");
            int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
            int[] pointers = new int[traineramount];
            for (int i = 0; i < traineramount; ++i) {
                int pointer = this.readWord(traineroffset + i * 2);
                pointers[i] = this.calculateOffset(this.bankOf(traineroffset), pointer);
            }
            int[] offsetsInNew = new int[traineramount];
            int oInNewCurrent = 0;
            Iterator<String> allTrainers = trainerNames.iterator();
            ByteArrayOutputStream newData = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < traineramount; ++i) {
                    int offs = pointers[i];
                    int limit = trainerclasslimits[i];
                    offsetsInNew[i] = oInNewCurrent;
                    for (int trnum = 0; trnum < limit; ++trnum) {
                        String newName = allTrainers.next();
                        byte[] newNameStr = this.translateString(newName);
                        newData.write(newNameStr);
                        newData.write(80);
                        oInNewCurrent += newNameStr.length + 1;
                        offs += this.lengthOfStringAt(offs, false) + 1;
                        int dataType = this.rom[offs] & 0xFF;
                        ++offs;
                        newData.write(dataType);
                        ++oInNewCurrent;
                        while ((this.rom[offs] & 0xFF) != 255) {
                            newData.write(this.rom, offs, 2);
                            oInNewCurrent += 2;
                            offs += 2;
                            if (dataType == 2 || dataType == 3) {
                                newData.write(this.rom, offs, 1);
                                ++oInNewCurrent;
                                ++offs;
                            }
                            if (dataType % 2 != 1) continue;
                            newData.write(this.rom, offs, 4);
                            oInNewCurrent += 4;
                            offs += 4;
                        }
                        newData.write(255);
                        ++oInNewCurrent;
                        ++offs;
                    }
                }
                byte[] newTrainerData = newData.toByteArray();
                int tdBase = pointers[0];
                System.arraycopy(newTrainerData, 0, this.rom, pointers[0], newTrainerData.length);
                for (int i = 1; i < traineramount; ++i) {
                    int newOffset = tdBase + offsetsInNew[i];
                    this.writeWord(traineroffset + i * 2, this.makeGBPointer(newOffset));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public RomHandler.TrainerNameMode trainerNameMode() {
        return RomHandler.TrainerNameMode.MAX_LENGTH_WITH_CLASS;
    }

    @Override
    public int maxTrainerNameLength() {
        return 17;
    }

    @Override
    public int maxSumOfTrainerNameLengths() {
        return this.romEntry.getValue("MaxSumOfTrainerNameLengths");
    }

    @Override
    public List<Integer> getTCNameLengthsByTrainer() {
        int traineramount = this.romEntry.getValue("TrainerClassAmount");
        int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
        List<String> tcNames = this.getTrainerClassNames();
        ArrayList<Integer> tcLengthsByT = new ArrayList<Integer>();
        for (int i = 0; i < traineramount; ++i) {
            int len = this.internalStringLength(tcNames.get(i));
            for (int k = 0; k < trainerclasslimits[i]; ++k) {
                tcLengthsByT.add(len);
            }
        }
        return tcLengthsByT;
    }

    @Override
    public List<String> getTrainerClassNames() {
        int amount = this.romEntry.getValue("TrainerClassAmount");
        int offset = this.romEntry.getValue("TrainerClassNamesOffset");
        ArrayList<String> trainerClassNames = new ArrayList<String>();
        for (int j = 0; j < amount; ++j) {
            String name = this.readVariableLengthString(offset, false);
            offset += this.lengthOfStringAt(offset, false) + 1;
            trainerClassNames.add(name);
        }
        return trainerClassNames;
    }

    @Override
    public void setTrainerClassNames(List<String> trainerClassNames) {
        if (this.romEntry.getValue("CanChangeTrainerText") != 0) {
            int amount = this.romEntry.getValue("TrainerClassAmount");
            int offset = this.romEntry.getValue("TrainerClassNamesOffset");
            Iterator<String> trainerClassNamesI = trainerClassNames.iterator();
            for (int j = 0; j < amount; ++j) {
                int len = this.lengthOfStringAt(offset, false) + 1;
                String newName = trainerClassNamesI.next();
                this.writeFixedLengthString(newName, offset, len);
                offset += len;
            }
        }
    }

    @Override
    public boolean fixedTrainerClassNamesLength() {
        return true;
    }

    @Override
    public List<Integer> getDoublesTrainerClasses() {
        int[] doublesClasses = (int[])this.romEntry.arrayEntries.get("DoublesTrainerClasses");
        ArrayList<Integer> doubles = new ArrayList<Integer>();
        for (int tClass : doublesClasses) {
            doubles.add(tClass);
        }
        return doubles;
    }

    @Override
    public String getDefaultExtension() {
        return "gbc";
    }

    @Override
    public int abilitiesPerPokemon() {
        return 0;
    }

    @Override
    public int highestAbilityIndex() {
        return 0;
    }

    @Override
    public int internalStringLength(String string) {
        return this.translateString(string).length;
    }

    @Override
    public int miscTweaksAvailable() {
        int available = MiscTweak.LOWER_CASE_POKEMON_NAMES.getValue();
        if (this.romEntry.codeTweaks.get("BWXPTweak") != null) {
            available |= MiscTweak.BW_EXP_PATCH.getValue();
        }
        if (this.romEntry.getValue("TextDelayFunctionOffset") != 0) {
            available |= MiscTweak.FASTEST_TEXT.getValue();
        }
        if (this.romEntry.arrayEntries.containsKey("CatchingTutorialOffsets")) {
            available |= MiscTweak.RANDOMIZE_CATCHING_TUTORIAL.getValue();
        }
        return available |= MiscTweak.BAN_LUCKY_EGG.getValue();
    }

    @Override
    public void applyMiscTweak(MiscTweak tweak) {
        if (tweak == MiscTweak.BW_EXP_PATCH) {
            this.applyBWEXPPatch();
        } else if (tweak == MiscTweak.FASTEST_TEXT) {
            this.applyFastestTextPatch();
        } else if (tweak == MiscTweak.LOWER_CASE_POKEMON_NAMES) {
            this.applyCamelCaseNames();
        } else if (tweak == MiscTweak.RANDOMIZE_CATCHING_TUTORIAL) {
            this.randomizeCatchingTutorial();
        } else if (tweak == MiscTweak.BAN_LUCKY_EGG) {
            this.allowedItems.banSingles(126);
            this.nonBadItems.banSingles(126);
        }
    }

    private void randomizeCatchingTutorial() {
        if (this.romEntry.arrayEntries.containsKey("CatchingTutorialOffsets")) {
            int[] offsets;
            int pokemon = this.random.nextInt(251) + 1;
            while (pokemon == 201) {
                pokemon = this.random.nextInt(251) + 1;
            }
            for (int offset : offsets = (int[])this.romEntry.arrayEntries.get("CatchingTutorialOffsets")) {
                this.rom[offset] = (byte)pokemon;
            }
        }
    }

    private void applyBWEXPPatch() {
        String patchName = (String)this.romEntry.codeTweaks.get("BWXPTweak");
        if (patchName == null) {
            return;
        }
        try {
            FileFunctions.applyPatch(this.rom, patchName);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    private void applyFastestTextPatch() {
        if (this.romEntry.getValue("TextDelayFunctionOffset") != 0) {
            this.rom[((RomEntry)this.romEntry).getValue((String)"TextDelayFunctionOffset")] = -55;
        }
    }

    @Override
    public void applySignature() {
        int pokemon = this.random.nextInt(251) + 1;
        while (pokemon == 201) {
            pokemon = this.random.nextInt(251) + 1;
        }
        this.rom[((RomEntry)this.romEntry).getValue((String)"IntroSpriteOffset")] = (byte)pokemon;
        this.rom[((RomEntry)this.romEntry).getValue((String)"IntroCryOffset")] = (byte)pokemon;
    }

    @Override
    public ItemList getAllowedItems() {
        return this.allowedItems;
    }

    @Override
    public ItemList getNonBadItems() {
        return this.nonBadItems;
    }

    private void loadItemNames() {
        int origOffset;
        this.itemNames = new String[256];
        this.itemNames[0] = "glitch";
        int itemNameOffset = origOffset = this.romEntry.getValue("ItemNamesOffset");
        for (int index = 1; index <= 256 && itemNameOffset / 16384 <= origOffset / 16384; ++index) {
            int startOfText = itemNameOffset;
            while ((this.rom[itemNameOffset] & 0xFF) != 80) {
                ++itemNameOffset;
            }
            ++itemNameOffset;
            this.itemNames[index % 256] = this.readFixedLengthString(startOfText, 20);
        }
    }

    @Override
    public String[] getItemNames() {
        return this.itemNames;
    }

    private void patchFleeing() {
        this.havePatchedFleeing = true;
        int offset = this.romEntry.getValue("FleeingDataOffset");
        this.rom[offset] = -1;
        this.rom[offset + 14] = -1;
        this.rom[offset + 23] = -1;
    }

    private void loadLandmarkNames() {
        int lmOffset = this.romEntry.getValue("LandmarkTableOffset");
        int lmBank = this.bankOf(lmOffset);
        int lmCount = this.romEntry.getValue("LandmarkCount");
        this.landmarkNames = new String[lmCount];
        for (int i = 0; i < lmCount; ++i) {
            int lmNameOffset = this.calculateOffset(lmBank, this.readWord(lmOffset + i * 4 + 2));
            this.landmarkNames[i] = this.readVariableLengthString(lmNameOffset, false).replace("\\x1F", " ");
        }
    }

    private void preprocessMaps() {
        this.itemOffs = new ArrayList<Integer>();
        int mhOffset = this.romEntry.getValue("MapHeaders");
        int mapGroupCount = 26;
        int mapsInLastGroup = 11;
        int mhBank = this.bankOf(mhOffset);
        this.mapNames = new String[mapGroupCount + 1][100];
        int[] groupOffsets = new int[mapGroupCount];
        for (int i = 0; i < mapGroupCount; ++i) {
            groupOffsets[i] = this.calculateOffset(mhBank, this.readWord(mhOffset + i * 2));
        }
        for (int mg = 0; mg < mapGroupCount; ++mg) {
            int maxMap;
            int offset = groupOffsets[mg];
            int maxOffset = mg == mapGroupCount - 1 ? (mhBank + 1) * 16384 : groupOffsets[mg + 1];
            int n = maxMap = mg == mapGroupCount - 1 ? mapsInLastGroup : Integer.MAX_VALUE;
            for (int map = 0; offset < maxOffset && map < maxMap; offset += 9, ++map) {
                this.processMapAt(offset, mg + 1, map + 1);
            }
        }
    }

    private void processMapAt(int offset, int mapBank, int mapNumber) {
        int smhBank = this.rom[offset] & 0xFF;
        int smhPointer = this.readWord(offset + 3);
        int smhOffset = this.calculateOffset(smhBank, smhPointer);
        int mapLandmark = this.rom[offset + 5] & 0xFF;
        this.mapNames[mapBank][mapNumber] = this.landmarkNames[mapLandmark];
        int ehBank = this.rom[smhOffset + 6] & 0xFF;
        int ehPointer = this.readWord(smhOffset + 9);
        int ehOffset = this.calculateOffset(ehBank, ehPointer);
        ehOffset += 2;
        int warpCount = this.rom[ehOffset++] & 0xFF;
        ehOffset += warpCount * 5;
        int triggerCount = this.rom[ehOffset++] & 0xFF;
        ehOffset += triggerCount * 8;
        int signpostCount = this.rom[ehOffset++] & 0xFF;
        for (int sp = 0; sp < signpostCount; ++sp) {
            int spType = this.rom[ehOffset + sp * 5 + 2] & 0xFF;
            if (spType != 7) continue;
            int spPointer = this.readWord(ehOffset + sp * 5 + 3);
            int spOffset = this.calculateOffset(ehBank, spPointer);
            this.itemOffs.add(spOffset + 2);
        }
        ehOffset += signpostCount * 5;
        int peopleCount = this.rom[ehOffset++] & 0xFF;
        for (int p = 0; p < peopleCount; ++p) {
            byte pColorFunction = this.rom[ehOffset + p * 13 + 7];
            if ((pColorFunction & 1) != 1) continue;
            int pPointer = this.readWord(ehOffset + p * 13 + 9);
            int pOffset = this.calculateOffset(ehBank, pPointer);
            this.itemOffs.add(pOffset);
        }
    }

    @Override
    public List<Integer> getRequiredFieldTMs() {
        return Gen2Constants.requiredFieldTMs;
    }

    @Override
    public List<Integer> getCurrentFieldTMs() {
        ArrayList<Integer> fieldTMs = new ArrayList<Integer>();
        for (int offset : this.itemOffs) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen2Constants.allowedItems.isTM(itemHere)) continue;
            int thisTM = 0;
            thisTM = itemHere >= 191 && itemHere < 195 ? itemHere - 191 + 1 : (itemHere >= 196 && itemHere < 220 ? itemHere - 196 + 1 + 4 : itemHere - 221 + 1 + 4 + 24);
            if (fieldTMs.contains(thisTM)) continue;
            fieldTMs.add(thisTM);
        }
        return fieldTMs;
    }

    @Override
    public void setFieldTMs(List<Integer> fieldTMs) {
        Iterator<Integer> iterTMs = fieldTMs.iterator();
        int[] givenTMs = new int[256];
        for (int offset : this.itemOffs) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen2Constants.allowedItems.isTM(itemHere)) continue;
            if (givenTMs[itemHere] != 0) {
                this.rom[offset] = (byte)givenTMs[itemHere];
                continue;
            }
            int tm = iterTMs.next();
            tm = tm >= 1 && tm <= 4 ? (tm += 190) : (tm >= 5 && tm <= 28 ? (tm += 191) : (tm += 192));
            givenTMs[itemHere] = tm;
            this.rom[offset] = (byte)tm;
        }
    }

    @Override
    public List<Integer> getRegularFieldItems() {
        ArrayList<Integer> fieldItems = new ArrayList<Integer>();
        for (int offset : this.itemOffs) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen2Constants.allowedItems.isAllowed(itemHere) || Gen2Constants.allowedItems.isTM(itemHere)) continue;
            fieldItems.add(itemHere);
        }
        return fieldItems;
    }

    @Override
    public void setRegularFieldItems(List<Integer> items) {
        Iterator<Integer> iterItems = items.iterator();
        for (int offset : this.itemOffs) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen2Constants.allowedItems.isAllowed(itemHere) || Gen2Constants.allowedItems.isTM(itemHere)) continue;
            this.rom[offset] = (byte)iterItems.next().intValue();
        }
    }

    @Override
    public List<IngameTrade> getIngameTrades() {
        ArrayList<IngameTrade> trades = new ArrayList<IngameTrade>();
        int tableOffset = this.romEntry.getValue("TradeTableOffset");
        int tableSize = this.romEntry.getValue("TradeTableSize");
        int nicknameLength = this.romEntry.getValue("TradeNameLength");
        int otLength = this.romEntry.getValue("TradeOTLength");
        int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
        int unusedOffset = 0;
        int entryLength = nicknameLength + otLength + 9;
        if (entryLength % 2 != 0) {
            ++entryLength;
        }
        for (int entry = 0; entry < tableSize; ++entry) {
            if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                ++unusedOffset;
                continue;
            }
            IngameTrade trade = new IngameTrade();
            int entryOffset = tableOffset + entry * entryLength;
            trade.requestedPokemon = this.pokes[this.rom[entryOffset + 1] & 0xFF];
            trade.givenPokemon = this.pokes[this.rom[entryOffset + 2] & 0xFF];
            trade.nickname = this.readString(entryOffset + 3, nicknameLength, false);
            int atkdef = this.rom[entryOffset + 3 + nicknameLength] & 0xFF;
            int spdspc = this.rom[entryOffset + 4 + nicknameLength] & 0xFF;
            trade.ivs = new int[]{atkdef >> 4 & 0xF, atkdef & 0xF, spdspc >> 4 & 0xF, spdspc & 0xF};
            trade.item = this.rom[entryOffset + 5 + nicknameLength] & 0xFF;
            trade.otId = this.readWord(entryOffset + 6 + nicknameLength);
            trade.otName = this.readString(entryOffset + 8 + nicknameLength, otLength, false);
            trades.add(trade);
        }
        return trades;
    }

    @Override
    public void setIngameTrades(List<IngameTrade> trades) {
        int tableOffset = this.romEntry.getValue("TradeTableOffset");
        int tableSize = this.romEntry.getValue("TradeTableSize");
        int nicknameLength = this.romEntry.getValue("TradeNameLength");
        int otLength = this.romEntry.getValue("TradeOTLength");
        int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
        int unusedOffset = 0;
        int entryLength = nicknameLength + otLength + 9;
        if (entryLength % 2 != 0) {
            ++entryLength;
        }
        int tradeOffset = 0;
        for (int entry = 0; entry < tableSize; ++entry) {
            if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                ++unusedOffset;
                continue;
            }
            IngameTrade trade = trades.get(tradeOffset++);
            int entryOffset = tableOffset + entry * entryLength;
            this.rom[entryOffset + 1] = (byte)trade.requestedPokemon.number;
            this.rom[entryOffset + 2] = (byte)trade.givenPokemon.number;
            if (this.romEntry.getValue("CanChangeTrainerText") > 0) {
                this.writeFixedLengthString(trade.nickname, entryOffset + 3, nicknameLength);
            }
            this.rom[entryOffset + 3 + nicknameLength] = (byte)(trade.ivs[0] << 4 | trade.ivs[1]);
            this.rom[entryOffset + 4 + nicknameLength] = (byte)(trade.ivs[2] << 4 | trade.ivs[3]);
            this.rom[entryOffset + 5 + nicknameLength] = (byte)trade.item;
            this.writeWord(entryOffset + 6 + nicknameLength, trade.otId);
            if (this.romEntry.getValue("CanChangeTrainerText") > 0) {
                this.writeFixedLengthString(trade.otName, entryOffset + 8 + nicknameLength, otLength);
            }
            this.rom[entryOffset + 8 + nicknameLength + otLength] = 0;
        }
    }

    @Override
    public boolean hasDVs() {
        return true;
    }

    @Override
    public int generationOfPokemon() {
        return 2;
    }

    @Override
    public void removeEvosForPokemonPool() {
        List pokemonIncluded = this.mainPokemonList;
        HashSet<Evolution> keepEvos = new HashSet<Evolution>();
        for (Pokemon pk : this.pokes) {
            if (pk == null) continue;
            keepEvos.clear();
            for (Evolution evol : pk.evolutionsFrom) {
                if (pokemonIncluded.contains(evol.from) && pokemonIncluded.contains(evol.to)) {
                    keepEvos.add(evol);
                    continue;
                }
                evol.to.evolutionsTo.remove(evol);
            }
            pk.evolutionsFrom.retainAll(keepEvos);
        }
    }

    private void writeEvosAndMovesLearnt(boolean writeEvos, Map<Pokemon, List<MoveLearnt>> movesets) {
        int movesEvosStart = this.romEntry.getValue("PokemonMovesetsTableOffset");
        int movesEvosBank = this.bankOf(movesEvosStart);
        byte[] pointerTable = new byte[502];
        int startOfNextBank = (movesEvosStart / 16384 + 1) * 16384;
        int dataBlockSize = startOfNextBank - (movesEvosStart + pointerTable.length);
        int dataBlockOffset = movesEvosStart + pointerTable.length;
        byte[] dataBlock = new byte[dataBlockSize];
        int offsetInData = 0;
        for (int i = 1; i <= 251; ++i) {
            int oldDataOffset = this.calculateOffset(movesEvosBank, this.readWord(movesEvosStart + (i - 1) * 2));
            int offsetStart = dataBlockOffset + offsetInData;
            boolean evoWritten = false;
            if (!writeEvos) {
                int evoOffset = oldDataOffset;
                while (this.rom[evoOffset] != 0) {
                    int method = this.rom[evoOffset] & 0xFF;
                    int limiter = method == 5 ? 4 : 3;
                    for (int b = 0; b < limiter; ++b) {
                        dataBlock[offsetInData++] = this.rom[evoOffset++];
                    }
                    evoWritten = true;
                }
            } else {
                for (Evolution evo : this.pokes[i].evolutionsFrom) {
                    dataBlock[offsetInData++] = (byte)evo.type.toIndex(2);
                    if (evo.type == EvolutionType.LEVEL || evo.type == EvolutionType.STONE || evo.type == EvolutionType.TRADE_ITEM) {
                        dataBlock[offsetInData++] = (byte)evo.extraInfo;
                    } else if (evo.type == EvolutionType.TRADE) {
                        dataBlock[offsetInData++] = -1;
                    } else if (evo.type == EvolutionType.HAPPINESS) {
                        dataBlock[offsetInData++] = 1;
                    } else if (evo.type == EvolutionType.HAPPINESS_DAY) {
                        dataBlock[offsetInData++] = 2;
                    } else if (evo.type == EvolutionType.HAPPINESS_NIGHT) {
                        dataBlock[offsetInData++] = 3;
                    } else if (evo.type == EvolutionType.LEVEL_ATTACK_HIGHER) {
                        dataBlock[offsetInData++] = (byte)evo.extraInfo;
                        dataBlock[offsetInData++] = 1;
                    } else if (evo.type == EvolutionType.LEVEL_DEFENSE_HIGHER) {
                        dataBlock[offsetInData++] = (byte)evo.extraInfo;
                        dataBlock[offsetInData++] = 2;
                    } else if (evo.type == EvolutionType.LEVEL_ATK_DEF_SAME) {
                        dataBlock[offsetInData++] = (byte)evo.extraInfo;
                        dataBlock[offsetInData++] = 3;
                    }
                    dataBlock[offsetInData++] = (byte)evo.to.number;
                    evoWritten = true;
                }
            }
            if (!evoWritten && offsetStart != dataBlockOffset) {
                --offsetStart;
            } else {
                dataBlock[offsetInData++] = 0;
            }
            int pointerNow = this.makeGBPointer(offsetStart);
            this.writeWord(pointerTable, (i - 1) * 2, pointerNow);
            if (movesets == null) {
                int movesOffset = oldDataOffset;
                while (this.rom[movesOffset] != 0) {
                    int method;
                    movesOffset += (method = this.rom[movesOffset] & 0xFF) == 5 ? 4 : 3;
                }
                ++movesOffset;
                while (this.rom[movesOffset] != 0) {
                    dataBlock[offsetInData++] = this.rom[movesOffset++];
                    dataBlock[offsetInData++] = this.rom[movesOffset++];
                }
            } else {
                List<MoveLearnt> moves = movesets.get(this.pokes[i]);
                for (MoveLearnt ml : moves) {
                    dataBlock[offsetInData++] = (byte)ml.level;
                    dataBlock[offsetInData++] = (byte)ml.move;
                }
            }
            dataBlock[offsetInData++] = 0;
        }
        System.arraycopy(pointerTable, 0, this.rom, movesEvosStart, pointerTable.length);
        System.arraycopy(dataBlock, 0, this.rom, dataBlockOffset, dataBlock.length);
    }

    @Override
    public boolean supportsFourStartingMoves() {
        return this.romEntry.getValue("SupportsFourStartingMoves") > 0;
    }

    @Override
    public List<Integer> getGameBreakingMoves() {
        return Gen2Constants.brokenMoves;
    }

    @Override
    public List<Integer> getFieldMoves() {
        return Gen2Constants.fieldMoves;
    }

    @Override
    public List<Integer> getEarlyRequiredHMMoves() {
        return Gen2Constants.earlyRequiredHMMoves;
    }

    @Override
    public BufferedImage getMascotImage() {
        Pokemon mascot = this.randomPokemon();
        while (mascot.number == 201) {
            mascot = this.randomPokemon();
        }
        int picPointer = this.romEntry.getValue("PicPointers") + (mascot.number - 1) * 6;
        int picWidth = mascot.picDimensions & 0xF;
        int picHeight = mascot.picDimensions >> 4 & 0xF;
        int picBank = this.rom[picPointer] & 0xFF;
        if (this.romEntry.isCrystal) {
            picBank += 54;
        } else if (picBank == 19) {
            picBank = 31;
        } else if (picBank == 20) {
            picBank = 32;
        } else if (picBank == 31) {
            picBank = 46;
        }
        int picOffset = this.calculateOffset(picBank, this.readWord(picPointer + 1));
        Gen2Decmp mscSprite = new Gen2Decmp(this.rom, picOffset, picWidth, picHeight);
        int w = picWidth * 8;
        int h = picHeight * 8;
        int[] palette = new int[]{-1, -5592406, -10066330, -16777216};
        int paletteOffset = this.romEntry.getValue("PokemonPalettes") + mascot.number * 8;
        if (this.random.nextInt(10) == 0) {
            paletteOffset += 4;
        }
        for (int i = 0; i < 2; ++i) {
            palette[i + 1] = GFXFunctions.conv16BitColorToARGB(this.readWord(paletteOffset + i * 2));
        }
        byte[] data = mscSprite.getFlattenedData();
        BufferedImage bim = GFXFunctions.drawTiledImage(data, palette, w, h, 8);
        GFXFunctions.pseudoTransparency(bim, palette[0]);
        return bim;
    }

    @Override
    public void writeCheckValueToROM(int value) {
        if (this.romEntry.getValue("CheckValueOffset") > 0) {
            int cvOffset = this.romEntry.getValue("CheckValueOffset");
            for (int i = 0; i < 4; ++i) {
                this.rom[cvOffset + i] = (byte)(value >> (3 - i) * 8 & 0xFF);
            }
        }
    }

    static {
        Gen2RomHandler.loadROMInfo();
    }

    private static class StaticPokemonGameCorner
    extends StaticPokemon {
        public StaticPokemonGameCorner(int ... offsets) {
            super(offsets);
        }

        @Override
        public void setPokemon(Gen2RomHandler rh, Pokemon pkmn) {
            int offsetSize = this.offsets.length;
            for (int i = 0; i < offsetSize - 1; ++i) {
                rh.rom[this.offsets[i]] = (byte)pkmn.number;
            }
            rh.writePaddedPokemonName(pkmn.name, rh.romEntry.getValue("GameCornerPokemonNameLength"), this.offsets[offsetSize - 1]);
        }
    }

    private static class StaticPokemon {
        protected int[] offsets;

        public StaticPokemon(int ... offsets) {
            this.offsets = offsets;
        }

        public Pokemon getPokemon(Gen2RomHandler rh) {
            return rh.pokes[rh.rom[this.offsets[0]] & 0xFF];
        }

        public void setPokemon(Gen2RomHandler rh, Pokemon pkmn) {
            for (int offset : this.offsets) {
                rh.rom[offset] = (byte)pkmn.number;
            }
        }
    }

    private static class TMTextEntry {
        private int number;
        private int offset;
        private String template;

        private TMTextEntry() {
        }
    }

    private static class RomEntry {
        private String name;
        private String romCode;
        private int version;
        private int nonJapanese;
        private String extraTableFile;
        private boolean isCrystal;
        private int crcInHeader = -1;
        private Map<String, String> codeTweaks = new HashMap<String, String>();
        private List<TMTextEntry> tmTexts = new ArrayList<TMTextEntry>();
        private Map<String, Integer> entries = new HashMap<String, Integer>();
        private Map<String, int[]> arrayEntries = new HashMap<String, int[]>();
        private List<StaticPokemon> staticPokemon = new ArrayList<StaticPokemon>();

        private RomEntry() {
        }

        private int getValue(String key) {
            if (!this.entries.containsKey(key)) {
                this.entries.put(key, 0);
            }
            return this.entries.get(key);
        }
    }

    public static class Factory
    extends RomHandler.Factory {
        @Override
        public Gen2RomHandler create(Random random, PrintStream logStream) {
            return new Gen2RomHandler(random, logStream);
        }

        @Override
        public boolean isLoadable(String filename) {
            long fileLength = new File(filename).length();
            if (fileLength > 0x800000L) {
                return false;
            }
            byte[] loaded = AbstractGBRomHandler.loadFilePartial(filename, 4096);
            if (loaded.length == 0) {
                return false;
            }
            return Gen2RomHandler.detectRomInner(loaded, (int)fileLength);
        }
    }
}

