/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.GFXFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.constants.Gen1Constants;
import com.dabomstew.pkrandom.constants.GlobalConstants;
import com.dabomstew.pkrandom.exceptions.RandomizationException;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.EvolutionType;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.pokemon.Type;
import com.dabomstew.pkrandom.romhandlers.AbstractGBCRomHandler;
import com.dabomstew.pkrandom.romhandlers.AbstractGBRomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import compressors.Gen1Decmp;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;

public class Gen1RomHandler
extends AbstractGBCRomHandler {
    private int[] pokeNumToRBYTable;
    private int[] pokeRBYToNumTable;
    private int[] moveNumToRomTable;
    private int[] moveRomToNumTable;
    private int pokedexCount;
    private static List<RomEntry> roms;
    private Pokemon[] pokes;
    private List<Pokemon> pokemonList;
    private RomEntry romEntry;
    private Move[] moves;
    private String[] itemNames;
    private String[] mapNames;
    private SubMap[] maps;
    private boolean xAccNerfed;

    public Gen1RomHandler(Random random) {
        super(random, null);
    }

    public Gen1RomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    private Type idToType(int value) {
        if (Gen1Constants.typeTable[value] != null) {
            return Gen1Constants.typeTable[value];
        }
        if (this.romEntry.extraTypeLookup.containsKey(value)) {
            return (Type)((Object)this.romEntry.extraTypeLookup.get(value));
        }
        return null;
    }

    private byte typeToByte(Type type) {
        if (type == null) {
            return 0;
        }
        if (this.romEntry.extraTypeReverse.containsKey((Object)type)) {
            return ((Integer)this.romEntry.extraTypeReverse.get((Object)type)).byteValue();
        }
        return Gen1Constants.typeToByte(type);
    }

    /*
     * WARNING - void declaration
     */
    private static void loadROMInfo() {
        roms = new ArrayList<RomEntry>();
        RomEntry current = null;
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig("gen1_offsets.ini"), "UTF-8");
            while (sc.hasNextLine()) {
                String[] tte;
                int c;
                int[] offs;
                String q = sc.nextLine().trim();
                if (q.contains("//")) {
                    q = q.substring(0, q.indexOf("//")).trim();
                }
                if (q.isEmpty()) continue;
                if (q.startsWith("[") && q.endsWith("]")) {
                    current = new RomEntry();
                    current.name = q.substring(1, q.length() - 1);
                    roms.add(current);
                    continue;
                }
                String[] r = q.split("=", 2);
                if (r.length == 1) {
                    System.err.println("invalid entry " + q);
                    continue;
                }
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                r[1] = r[1].trim();
                r[0] = r[0].trim();
                if (r[0].equals("StaticPokemonGameCorner[]")) {
                    if (r[1].startsWith("[") && r[1].endsWith("]")) {
                        String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                        offs = new int[offsets.length];
                        c = 0;
                        for (String off : offsets) {
                            offs[c++] = Gen1RomHandler.parseRIInt(off);
                        }
                        GameCornerPokemon gameCornerPokemon = new GameCornerPokemon();
                        GameCornerPokemon.access$502(gameCornerPokemon, offs);
                        current.staticPokemonGameCorner.add(gameCornerPokemon);
                        continue;
                    }
                    int offs2 = Gen1RomHandler.parseRIInt(r[1]);
                    GameCornerPokemon gc = new GameCornerPokemon();
                    GameCornerPokemon.access$502(gc, new int[]{offs2});
                    current.staticPokemonGameCorner.add(gc);
                    continue;
                }
                if (r[0].equals("StaticPokemonGhostMarowak")) {
                    if (!r[1].startsWith("[") || !r[1].endsWith("]")) continue;
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    offs = new int[offsets.length];
                    c = 0;
                    for (String off : offsets) {
                        offs[c++] = Gen1RomHandler.parseRIInt(off);
                    }
                    RomEntry.access$702(current, offs);
                    continue;
                }
                if (r[0].equals("TMText[]")) {
                    if (!r[1].startsWith("[") || !r[1].endsWith("]")) continue;
                    String[] parts = r[1].substring(1, r[1].length() - 1).split(",", 3);
                    tte = new TMTextEntry();
                    ((TMTextEntry)tte).number = Gen1RomHandler.parseRIInt(parts[0]);
                    ((TMTextEntry)tte).offset = Gen1RomHandler.parseRIInt(parts[1]);
                    ((TMTextEntry)tte).template = parts[2];
                    current.tmTexts.add(tte);
                    continue;
                }
                if (r[0].equals("Game")) {
                    current.romName = r[1];
                    continue;
                }
                if (r[0].equals("Version")) {
                    current.version = Gen1RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].equals("NonJapanese")) {
                    current.nonJapanese = Gen1RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].equals("Type")) {
                    if (r[1].equalsIgnoreCase("Yellow")) {
                        current.isYellow = true;
                        continue;
                    }
                    current.isYellow = false;
                    continue;
                }
                if (r[0].equals("ExtraTableFile")) {
                    current.extraTableFile = r[1];
                    continue;
                }
                if (r[0].equals("CRCInHeader")) {
                    current.crcInHeader = Gen1RomHandler.parseRIInt(r[1]);
                    continue;
                }
                if (r[0].endsWith("Tweak")) {
                    current.tweakFiles.put(r[0], r[1]);
                    continue;
                }
                if (r[0].equals("ExtraTypes")) {
                    void var7_19;
                    String[] parts;
                    r[1] = r[1].substring(1, r[1].length() - 1);
                    tte = parts = r[1].split(",");
                    c = tte.length;
                    boolean bl = false;
                    while (var7_19 < c) {
                        String part = tte[var7_19];
                        String[] iParts = part.split("=");
                        int typeId = Integer.parseInt(iParts[0], 16);
                        String typeName = iParts[1].trim();
                        Type theType = Type.valueOf(typeName);
                        current.extraTypeLookup.put(typeId, theType);
                        current.extraTypeReverse.put(theType, typeId);
                        ++var7_19;
                    }
                    continue;
                }
                if (r[0].equals("CopyFrom")) {
                    for (RomEntry otherEntry : roms) {
                        if (!r[1].equalsIgnoreCase(otherEntry.name)) continue;
                        boolean cSP = current.getValue("CopyStaticPokemon") == 1;
                        boolean bl = current.getValue("CopyTMText") == 1;
                        current.arrayEntries.putAll(otherEntry.arrayEntries);
                        current.entries.putAll(otherEntry.entries);
                        if (cSP) {
                            current.staticPokemonSingle.addAll(otherEntry.staticPokemonSingle);
                            current.staticPokemonGameCorner.addAll(otherEntry.staticPokemonGameCorner);
                            RomEntry.access$702(current, otherEntry.ghostMarowakOffsets);
                            current.entries.put("StaticPokemonSupport", 1);
                        } else {
                            current.entries.put("StaticPokemonSupport", 0);
                        }
                        if (bl) {
                            current.tmTexts.addAll(otherEntry.tmTexts);
                        }
                        current.extraTableFile = otherEntry.extraTableFile;
                    }
                    continue;
                }
                if (r[1].startsWith("[") && r[1].endsWith("]")) {
                    String[] offsets = r[1].substring(1, r[1].length() - 1).split(",");
                    if (offsets.length == 1 && offsets[0].trim().isEmpty()) {
                        current.arrayEntries.put(r[0], new int[0]);
                        continue;
                    }
                    offs = new int[offsets.length];
                    c = 0;
                    for (String off : offsets) {
                        offs[c++] = Gen1RomHandler.parseRIInt(off);
                    }
                    if (r[0].startsWith("StaticPokemon")) {
                        for (int off : offs) {
                            current.staticPokemonSingle.add(off);
                        }
                        continue;
                    }
                    current.arrayEntries.put(r[0], offs);
                    continue;
                }
                int offs3 = Gen1RomHandler.parseRIInt(r[1]);
                current.entries.put(r[0], offs3);
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static int parseRIInt(String off) {
        int radix = 10;
        if ((off = off.trim().toLowerCase()).startsWith("0x") || off.startsWith("&h")) {
            radix = 16;
            off = off.substring(2);
        }
        try {
            return Integer.parseInt(off, radix);
        }
        catch (NumberFormatException ex) {
            System.err.println("invalid base " + radix + "number " + off);
            return 0;
        }
    }

    @Override
    public boolean detectRom(byte[] rom) {
        return Gen1RomHandler.detectRomInner(rom, rom.length);
    }

    public static boolean detectRomInner(byte[] rom, int romSize) {
        if (romSize < 524288 || romSize > 0x200000) {
            return false;
        }
        return Gen1RomHandler.checkRomEntry(rom) != null;
    }

    @Override
    public void loadedRom() {
        this.romEntry = Gen1RomHandler.checkRomEntry(this.rom);
        this.pokeNumToRBYTable = new int[256];
        this.pokeRBYToNumTable = new int[256];
        this.moveNumToRomTable = new int[256];
        this.moveRomToNumTable = new int[256];
        this.maps = new SubMap[256];
        this.xAccNerfed = false;
        this.clearTextTables();
        this.readTextTable("gameboy_jap");
        if (this.romEntry.extraTableFile != null && !this.romEntry.extraTableFile.equalsIgnoreCase("none")) {
            this.readTextTable(this.romEntry.extraTableFile);
        }
        this.loadPokedexOrder();
        this.loadPokemonStats();
        this.pokemonList = Arrays.asList(this.pokes);
        this.loadMoves();
        this.loadItemNames();
        this.preloadMaps();
        this.loadMapNames();
    }

    private void loadPokedexOrder() {
        int pkmnCount = this.romEntry.getValue("InternalPokemonCount");
        int orderOffset = this.romEntry.getValue("PokedexOrder");
        this.pokedexCount = 0;
        for (int i = 1; i <= pkmnCount; ++i) {
            int pokedexNum;
            this.pokeRBYToNumTable[i] = pokedexNum = this.rom[orderOffset + i - 1] & 0xFF;
            if (pokedexNum != 0 && this.pokeNumToRBYTable[pokedexNum] == 0) {
                this.pokeNumToRBYTable[pokedexNum] = i;
            }
            this.pokedexCount = Math.max(this.pokedexCount, pokedexNum);
        }
    }

    private static RomEntry checkRomEntry(byte[] rom) {
        int version = rom[332] & 0xFF;
        int nonjap = rom[330] & 0xFF;
        int crcInHeader = (rom[334] & 0xFF) << 8 | rom[335] & 0xFF;
        for (RomEntry re : roms) {
            if (!Gen1RomHandler.romSig(rom, re.romName) || re.version != version || re.nonJapanese != nonjap || re.crcInHeader != crcInHeader) continue;
            return re;
        }
        for (RomEntry re : roms) {
            if (!Gen1RomHandler.romSig(rom, re.romName) || re.version != version || re.nonJapanese != nonjap || re.crcInHeader != -1) continue;
            return re;
        }
        return null;
    }

    @Override
    public void savingRom() {
        this.savePokemonStats();
        this.saveMoves();
    }

    private String[] readMoveNames() {
        int moveCount = this.romEntry.getValue("MoveCount");
        int offset = this.romEntry.getValue("MoveNamesOffset");
        String[] moveNames = new String[moveCount + 1];
        for (int i = 1; i <= moveCount; ++i) {
            moveNames[i] = this.readVariableLengthString(offset, false);
            offset += this.lengthOfStringAt(offset, false) + 1;
        }
        return moveNames;
    }

    private void loadMoves() {
        String[] moveNames = this.readMoveNames();
        int moveCount = this.romEntry.getValue("MoveCount");
        int movesOffset = this.romEntry.getValue("MoveDataOffset");
        int trueMoveCount = 0;
        for (int i = 1; i <= moveCount; ++i) {
            if (this.rom[movesOffset + (i - 1) * 6] == 0 || moveNames[i].equals("Nothing")) continue;
            ++trueMoveCount;
        }
        this.moves = new Move[trueMoveCount + 1];
        int trueMoveIndex = 0;
        for (int i = 1; i <= moveCount; ++i) {
            int anim = this.rom[movesOffset + (i - 1) * 6] & 0xFF;
            if (anim <= 0 || moveNames[i].equals("Nothing")) continue;
            this.moveNumToRomTable[++trueMoveIndex] = i;
            this.moveRomToNumTable[i] = trueMoveIndex;
            this.moves[trueMoveIndex] = new Move();
            this.moves[trueMoveIndex].name = moveNames[i];
            this.moves[trueMoveIndex].internalId = i;
            this.moves[trueMoveIndex].number = trueMoveIndex;
            this.moves[trueMoveIndex].effectIndex = this.rom[movesOffset + (i - 1) * 6 + 1] & 0xFF;
            this.moves[trueMoveIndex].hitratio = (double)((this.rom[movesOffset + (i - 1) * 6 + 4] & 0xFF) + 0) / 255.0 * 100.0;
            this.moves[trueMoveIndex].power = this.rom[movesOffset + (i - 1) * 6 + 2] & 0xFF;
            this.moves[trueMoveIndex].pp = this.rom[movesOffset + (i - 1) * 6 + 5] & 0xFF;
            this.moves[trueMoveIndex].type = this.idToType(this.rom[movesOffset + (i - 1) * 6 + 3] & 0xFF);
            if (GlobalConstants.normalMultihitMoves.contains(i)) {
                this.moves[trueMoveIndex].hitCount = 3.0;
                continue;
            }
            if (!GlobalConstants.doubleHitMoves.contains(i)) continue;
            this.moves[trueMoveIndex].hitCount = 2.0;
        }
    }

    private void saveMoves() {
        int movesOffset = this.romEntry.getValue("MoveDataOffset");
        for (Move m : this.moves) {
            if (m == null) continue;
            int i = m.internalId;
            this.rom[movesOffset + (i - 1) * 6 + 1] = (byte)m.effectIndex;
            this.rom[movesOffset + (i - 1) * 6 + 2] = (byte)m.power;
            this.rom[movesOffset + (i - 1) * 6 + 3] = this.typeToByte(m.type);
            int hitratio = (int)Math.round(m.hitratio * 2.55);
            if (hitratio < 0) {
                hitratio = 0;
            }
            if (hitratio > 255) {
                hitratio = 255;
            }
            this.rom[movesOffset + (i - 1) * 6 + 4] = (byte)hitratio;
            this.rom[movesOffset + (i - 1) * 6 + 5] = (byte)m.pp;
        }
    }

    @Override
    public List<Move> getMoves() {
        return Arrays.asList(this.moves);
    }

    private void loadPokemonStats() {
        this.pokes = new Pokemon[this.pokedexCount + 1];
        String[] pokeNames = this.readPokemonNames();
        int pokeStatsOffset = this.romEntry.getValue("PokemonStatsOffset");
        for (int i = 1; i <= this.pokedexCount; ++i) {
            this.pokes[i] = new Pokemon();
            this.pokes[i].number = i;
            if (i != 151 || this.romEntry.isYellow) {
                this.loadBasicPokeStats(this.pokes[i], pokeStatsOffset + (i - 1) * 28);
            }
            this.pokes[i].name = pokeNames[this.pokeNumToRBYTable[i]];
        }
        if (!this.romEntry.isYellow) {
            this.loadBasicPokeStats(this.pokes[151], this.romEntry.getValue("MewStatsOffset"));
        }
        this.populateEvolutions();
    }

    private void savePokemonStats() {
        int offs = this.romEntry.getValue("PokemonNamesOffset");
        int nameLength = this.romEntry.getValue("PokemonNamesLength");
        for (int i = 1; i <= this.pokedexCount; ++i) {
            int rbynum = this.pokeNumToRBYTable[i];
            int stringOffset = offs + (rbynum - 1) * nameLength;
            this.writeFixedLengthString(this.pokes[i].name, stringOffset, nameLength);
        }
        int pokeStatsOffset = this.romEntry.getValue("PokemonStatsOffset");
        for (int i = 1; i <= this.pokedexCount; ++i) {
            if (i == 151) continue;
            this.saveBasicPokeStats(this.pokes[i], pokeStatsOffset + (i - 1) * 28);
        }
        int mewOffset = this.romEntry.isYellow ? pokeStatsOffset + 4200 : this.romEntry.getValue("MewStatsOffset");
        this.saveBasicPokeStats(this.pokes[151], mewOffset);
        this.writeEvosAndMovesLearnt(true, null);
    }

    private void loadBasicPokeStats(Pokemon pkmn, int offset) {
        pkmn.hp = this.rom[offset + 1] & 0xFF;
        pkmn.attack = this.rom[offset + 2] & 0xFF;
        pkmn.defense = this.rom[offset + 3] & 0xFF;
        pkmn.speed = this.rom[offset + 4] & 0xFF;
        pkmn.spatk = pkmn.special = this.rom[offset + 5] & 0xFF;
        pkmn.spdef = pkmn.special;
        pkmn.primaryType = this.idToType(this.rom[offset + 6] & 0xFF);
        pkmn.secondaryType = this.idToType(this.rom[offset + 7] & 0xFF);
        if (pkmn.secondaryType == pkmn.primaryType) {
            pkmn.secondaryType = null;
        }
        pkmn.catchRate = this.rom[offset + 8] & 0xFF;
        pkmn.expYield = this.rom[offset + 9] & 0xFF;
        pkmn.growthCurve = ExpCurve.fromByte(this.rom[offset + 19]);
        pkmn.frontSpritePointer = this.readWord(offset + 11);
        pkmn.guaranteedHeldItem = -1;
        pkmn.commonHeldItem = -1;
        pkmn.rareHeldItem = -1;
        pkmn.darkGrassHeldItem = -1;
    }

    private void saveBasicPokeStats(Pokemon pkmn, int offset) {
        this.rom[offset + 1] = (byte)pkmn.hp;
        this.rom[offset + 2] = (byte)pkmn.attack;
        this.rom[offset + 3] = (byte)pkmn.defense;
        this.rom[offset + 4] = (byte)pkmn.speed;
        this.rom[offset + 5] = (byte)pkmn.special;
        this.rom[offset + 6] = this.typeToByte(pkmn.primaryType);
        this.rom[offset + 7] = pkmn.secondaryType == null ? this.rom[offset + 6] : this.typeToByte(pkmn.secondaryType);
        this.rom[offset + 8] = (byte)pkmn.catchRate;
        this.rom[offset + 19] = pkmn.growthCurve.toByte();
        this.rom[offset + 9] = (byte)pkmn.expYield;
    }

    private String[] readPokemonNames() {
        int offs = this.romEntry.getValue("PokemonNamesOffset");
        int nameLength = this.romEntry.getValue("PokemonNamesLength");
        int pkmnCount = this.romEntry.getValue("InternalPokemonCount");
        String[] names = new String[pkmnCount + 1];
        for (int i = 1; i <= pkmnCount; ++i) {
            names[i] = this.readFixedLengthString(offs + (i - 1) * nameLength, nameLength);
        }
        return names;
    }

    @Override
    public List<Pokemon> getStarters() {
        ArrayList<Pokemon> starters = new ArrayList<Pokemon>();
        starters.add(this.pokes[this.pokeRBYToNumTable[this.rom[((int[])this.romEntry.arrayEntries.get("StarterOffsets1"))[0]] & 0xFF]]);
        starters.add(this.pokes[this.pokeRBYToNumTable[this.rom[((int[])this.romEntry.arrayEntries.get("StarterOffsets2"))[0]] & 0xFF]]);
        if (!this.romEntry.isYellow) {
            starters.add(this.pokes[this.pokeRBYToNumTable[this.rom[((int[])this.romEntry.arrayEntries.get("StarterOffsets3"))[0]] & 0xFF]]);
        }
        return starters;
    }

    @Override
    public boolean setStarters(List<Pokemon> newStarters) {
        int starterAmount = 2;
        if (!this.romEntry.isYellow) {
            starterAmount = 3;
        }
        if (newStarters.size() != starterAmount) {
            return false;
        }
        for (int i = 0; i < starterAmount; ++i) {
            int[] offsets;
            byte starter = (byte)this.pokeNumToRBYTable[newStarters.get((int)i).number];
            for (int offset : offsets = (int[])this.romEntry.arrayEntries.get("StarterOffsets" + (i + 1))) {
                this.rom[offset] = starter;
            }
        }
        if (!this.romEntry.isYellow) {
            int i;
            if (this.romEntry.getValue("CanChangeStarterText") > 0) {
                int[] starterTextOffsets = (int[])this.romEntry.arrayEntries.get("StarterTextOffsets");
                for (i = 0; i < 3 && i < starterTextOffsets.length; ++i) {
                    this.writeVariableLengthString(String.format("So! You want\\n%s?\\e", newStarters.get((int)i).name), starterTextOffsets[i], true);
                }
            }
            if (this.romEntry.getValue("PatchPokedex") > 0) {
                TreeMap<Integer, Integer> onValues = new TreeMap<Integer, Integer>();
                for (i = 0; i < 3; ++i) {
                    int pkDexNum = newStarters.get((int)i).number;
                    int ramOffset = (pkDexNum - 1) / 8 + this.romEntry.getValue("PokedexRamOffset");
                    int bitShift = (pkDexNum - 1) % 8;
                    int writeValue = 1 << bitShift;
                    if (onValues.containsKey(ramOffset)) {
                        onValues.put(ramOffset, (Integer)onValues.get(ramOffset) | writeValue);
                        continue;
                    }
                    onValues.put(ramOffset, writeValue);
                }
                int pkDexOnOffset = this.romEntry.getValue("StarterPokedexOnOffset");
                int pkDexOffOffset = this.romEntry.getValue("StarterPokedexOffOffset");
                int sizeForOnRoutine = 5 * onValues.size() + 3;
                int writeOnRoutineTo = this.romEntry.getValue("StarterPokedexBranchOffset");
                int writeOffRoutineTo = writeOnRoutineTo + sizeForOnRoutine;
                int offsetForOnRoutine = this.makeGBPointer(writeOnRoutineTo);
                int offsetForOffRoutine = this.makeGBPointer(writeOffRoutineTo);
                int retOnOffset = this.makeGBPointer(pkDexOnOffset + 5);
                int retOffOffset = this.makeGBPointer(pkDexOffOffset + 4);
                this.rom[pkDexOnOffset] = -61;
                this.writeWord(pkDexOnOffset + 1, offsetForOnRoutine);
                this.rom[pkDexOnOffset + 3] = 0;
                this.rom[pkDexOnOffset + 4] = 0;
                this.rom[pkDexOffOffset] = -61;
                this.writeWord(pkDexOffOffset + 1, offsetForOffRoutine);
                this.rom[pkDexOffOffset + 3] = 0;
                this.rom[writeOffRoutineTo] = -81;
                int turnOnOffset = writeOnRoutineTo;
                int turnOffOffset = writeOffRoutineTo + 1;
                Iterator iterator = onValues.keySet().iterator();
                while (iterator.hasNext()) {
                    int ramOffset = (Integer)iterator.next();
                    int onValue = (Integer)onValues.get(ramOffset);
                    this.rom[turnOnOffset++] = 62;
                    this.rom[turnOnOffset++] = (byte)onValue;
                    this.rom[turnOnOffset++] = -22;
                    this.rom[turnOnOffset++] = (byte)(ramOffset % 256);
                    this.rom[turnOnOffset++] = (byte)(ramOffset / 256);
                    this.rom[turnOffOffset++] = -22;
                    this.rom[turnOffOffset++] = (byte)(ramOffset % 256);
                    this.rom[turnOffOffset++] = (byte)(ramOffset / 256);
                }
                this.rom[turnOnOffset++] = -61;
                this.writeWord(turnOnOffset, retOnOffset);
                this.rom[turnOffOffset++] = -61;
                this.writeWord(turnOffOffset, retOffOffset);
            }
        }
        return true;
    }

    @Override
    public List<Integer> getStarterHeldItems() {
        return new ArrayList<Integer>();
    }

    @Override
    public void setStarterHeldItems(List<Integer> items) {
    }

    @Override
    public List<EncounterSet> getEncounters(boolean useTimeOfDay) {
        int superRodOffset;
        Encounter enc;
        ArrayList<EncounterSet> encounters = new ArrayList<EncounterSet>();
        Pokemon ghostMarowak = this.pokes[105];
        if (this.canChangeStaticPokemon()) {
            ghostMarowak = this.pokes[this.pokeRBYToNumTable[this.rom[this.romEntry.ghostMarowakOffsets[0]] & 0xFF]];
        }
        ArrayList<Integer> usedOffsets = new ArrayList<Integer>();
        int tableOffset = this.romEntry.getValue("WildPokemonTableOffset");
        int tableBank = this.bankOf(tableOffset);
        int mapID = -1;
        while (this.readWord(tableOffset) != 65535) {
            int offset;
            ++mapID;
            int rootOffset = offset = this.calculateOffset(tableBank, this.readWord(tableOffset));
            if (!usedOffsets.contains(offset)) {
                usedOffsets.add(offset);
                for (int a = 0; a < 2; ++a) {
                    int rate;
                    if ((rate = this.rom[offset++] & 0xFF) <= 0) continue;
                    EncounterSet thisSet = new EncounterSet();
                    thisSet.rate = rate;
                    thisSet.offset = rootOffset;
                    thisSet.displayName = (a == 1 ? "Surfing" : "Grass/Cave") + " on " + this.mapNames[mapID];
                    if (mapID >= 144 && mapID <= 148) {
                        thisSet.bannedPokemon.add(ghostMarowak);
                    }
                    for (int slot = 0; slot < 10; ++slot) {
                        enc = new Encounter();
                        enc.level = this.rom[offset] & 0xFF;
                        enc.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[offset + 1] & 0xFF]];
                        thisSet.encounters.add(enc);
                        offset += 2;
                    }
                    encounters.add(thisSet);
                }
            } else {
                for (EncounterSet es : encounters) {
                    if (es.offset != offset) continue;
                    es.displayName = es.displayName + ", " + this.mapNames[mapID];
                }
            }
            tableOffset += 2;
        }
        int oldRodOffset = this.romEntry.getValue("OldRodOffset");
        EncounterSet oldRodSet = new EncounterSet();
        oldRodSet.displayName = "Old Rod Fishing";
        Encounter oldRodEnc = new Encounter();
        oldRodEnc.level = this.rom[oldRodOffset + 2] & 0xFF;
        oldRodEnc.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[oldRodOffset + 1] & 0xFF]];
        oldRodSet.encounters.add(oldRodEnc);
        oldRodSet.bannedPokemon.add(ghostMarowak);
        encounters.add(oldRodSet);
        int goodRodOffset = this.romEntry.getValue("GoodRodOffset");
        EncounterSet goodRodSet = new EncounterSet();
        goodRodSet.displayName = "Good Rod Fishing";
        for (int grSlot = 0; grSlot < 2; ++grSlot) {
            enc = new Encounter();
            enc.level = this.rom[goodRodOffset + grSlot * 2] & 0xFF;
            enc.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[goodRodOffset + grSlot * 2 + 1] & 0xFF]];
            goodRodSet.encounters.add(enc);
        }
        goodRodSet.bannedPokemon.add(ghostMarowak);
        encounters.add(goodRodSet);
        if (this.romEntry.isYellow) {
            superRodOffset = this.romEntry.getValue("SuperRodTableOffset");
            while ((this.rom[superRodOffset] & 0xFF) != 255) {
                int map = this.rom[superRodOffset++] & 0xFF;
                EncounterSet thisSet = new EncounterSet();
                thisSet.displayName = "Super Rod Fishing on " + this.mapNames[map];
                for (int encN = 0; encN < 4; ++encN) {
                    Encounter enc2 = new Encounter();
                    enc2.level = this.rom[superRodOffset + 1] & 0xFF;
                    enc2.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[superRodOffset] & 0xFF]];
                    thisSet.encounters.add(enc2);
                    superRodOffset += 2;
                }
                thisSet.bannedPokemon.add(ghostMarowak);
                encounters.add(thisSet);
            }
        } else {
            superRodOffset = this.romEntry.getValue("SuperRodTableOffset");
            int superRodBank = this.bankOf(superRodOffset);
            ArrayList<Integer> usedSROffsets = new ArrayList<Integer>();
            while ((this.rom[superRodOffset] & 0xFF) != 255) {
                int map = this.rom[superRodOffset++] & 0xFF;
                int setOffset = this.calculateOffset(superRodBank, this.readWord(superRodOffset));
                superRodOffset += 2;
                if (!usedSROffsets.contains(setOffset)) {
                    usedSROffsets.add(setOffset);
                    EncounterSet thisSet = new EncounterSet();
                    thisSet.displayName = "Super Rod Fishing on " + this.mapNames[map];
                    thisSet.offset = setOffset;
                    int pokesInSet = this.rom[setOffset++] & 0xFF;
                    for (int encN = 0; encN < pokesInSet; ++encN) {
                        Encounter enc3 = new Encounter();
                        enc3.level = this.rom[setOffset] & 0xFF;
                        enc3.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[setOffset + 1] & 0xFF]];
                        thisSet.encounters.add(enc3);
                        setOffset += 2;
                    }
                    thisSet.bannedPokemon.add(ghostMarowak);
                    encounters.add(thisSet);
                    continue;
                }
                for (EncounterSet es : encounters) {
                    if (es.offset != setOffset) continue;
                    es.displayName = es.displayName + ", " + this.mapNames[map];
                }
            }
        }
        return encounters;
    }

    @Override
    public void setEncounters(boolean useTimeOfDay, List<EncounterSet> encounters) {
        int superRodOffset;
        Iterator<EncounterSet> encsetit = encounters.iterator();
        ArrayList<Integer> usedOffsets = new ArrayList<Integer>();
        int tableOffset = this.romEntry.getValue("WildPokemonTableOffset");
        int tableBank = this.bankOf(tableOffset);
        while (this.readWord(tableOffset) != 65535) {
            int offset = this.calculateOffset(tableBank, this.readWord(tableOffset));
            if (!usedOffsets.contains(offset)) {
                usedOffsets.add(offset);
                for (int a = 0; a < 2; ++a) {
                    int rate;
                    if ((rate = this.rom[offset++] & 0xFF) <= 0) continue;
                    EncounterSet thisSet = encsetit.next();
                    for (int slot = 0; slot < 10; ++slot) {
                        Encounter enc = thisSet.encounters.get(slot);
                        this.rom[offset] = (byte)enc.level;
                        this.rom[offset + 1] = (byte)this.pokeNumToRBYTable[enc.pokemon.number];
                        offset += 2;
                    }
                }
            }
            tableOffset += 2;
        }
        int oldRodOffset = this.romEntry.getValue("OldRodOffset");
        EncounterSet oldRodSet = encsetit.next();
        Encounter oldRodEnc = oldRodSet.encounters.get(0);
        this.rom[oldRodOffset + 2] = (byte)oldRodEnc.level;
        this.rom[oldRodOffset + 1] = (byte)this.pokeNumToRBYTable[oldRodEnc.pokemon.number];
        int goodRodOffset = this.romEntry.getValue("GoodRodOffset");
        EncounterSet goodRodSet = encsetit.next();
        for (int grSlot = 0; grSlot < 2; ++grSlot) {
            Encounter enc = goodRodSet.encounters.get(grSlot);
            this.rom[goodRodOffset + grSlot * 2] = (byte)enc.level;
            this.rom[goodRodOffset + grSlot * 2 + 1] = (byte)this.pokeNumToRBYTable[enc.pokemon.number];
        }
        if (this.romEntry.isYellow) {
            superRodOffset = this.romEntry.getValue("SuperRodTableOffset");
            while ((this.rom[superRodOffset] & 0xFF) != 255) {
                ++superRodOffset;
                EncounterSet thisSet = encsetit.next();
                for (int encN = 0; encN < 4; ++encN) {
                    Encounter enc = thisSet.encounters.get(encN);
                    this.rom[superRodOffset + 1] = (byte)enc.level;
                    this.rom[superRodOffset] = (byte)this.pokeNumToRBYTable[enc.pokemon.number];
                    superRodOffset += 2;
                }
            }
        } else {
            superRodOffset = this.romEntry.getValue("SuperRodTableOffset");
            int superRodBank = this.bankOf(superRodOffset);
            ArrayList<Integer> usedSROffsets = new ArrayList<Integer>();
            while ((this.rom[superRodOffset] & 0xFF) != 255) {
                int setOffset = this.calculateOffset(superRodBank, this.readWord(++superRodOffset));
                superRodOffset += 2;
                if (usedSROffsets.contains(setOffset)) continue;
                usedSROffsets.add(setOffset);
                int pokesInSet = this.rom[setOffset++] & 0xFF;
                EncounterSet thisSet = encsetit.next();
                for (int encN = 0; encN < pokesInSet; ++encN) {
                    Encounter enc = thisSet.encounters.get(encN);
                    this.rom[setOffset] = (byte)enc.level;
                    this.rom[setOffset + 1] = (byte)this.pokeNumToRBYTable[enc.pokemon.number];
                    setOffset += 2;
                }
            }
        }
    }

    @Override
    public List<Pokemon> getPokemon() {
        return this.pokemonList;
    }

    @Override
    public List<Trainer> getTrainers() {
        int traineroffset = this.romEntry.getValue("TrainerDataTableOffset");
        int traineramount = 47;
        int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
        int[] pointers = new int[traineramount + 1];
        for (int i = 1; i <= traineramount; ++i) {
            int tPointer = this.readWord(traineroffset + (i - 1) * 2);
            pointers[i] = this.calculateOffset(this.bankOf(traineroffset), tPointer);
        }
        List<String> tcnames = this.getTrainerClassesForText();
        ArrayList<Trainer> allTrainers = new ArrayList<Trainer>();
        for (int i = 1; i <= traineramount; ++i) {
            int offs = pointers[i];
            int limit = trainerclasslimits[i];
            String tcname = tcnames.get(i - 1);
            for (int trnum = 0; trnum < limit; ++trnum) {
                Trainer tr = new Trainer();
                tr.offset = offs;
                tr.trainerclass = i;
                tr.fullDisplayName = tcname;
                int dataType = this.rom[offs] & 0xFF;
                if (dataType == 255) {
                    tr.poketype = 1;
                    ++offs;
                    while (this.rom[offs] != 0) {
                        TrainerPokemon tpk = new TrainerPokemon();
                        tpk.level = this.rom[offs] & 0xFF;
                        tpk.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[offs + 1] & 0xFF]];
                        tr.pokemon.add(tpk);
                        offs += 2;
                    }
                } else {
                    tr.poketype = 0;
                    int fixedLevel = dataType;
                    ++offs;
                    while (this.rom[offs] != 0) {
                        TrainerPokemon tpk = new TrainerPokemon();
                        tpk.level = fixedLevel;
                        tpk.pokemon = this.pokes[this.pokeRBYToNumTable[this.rom[offs] & 0xFF]];
                        tr.pokemon.add(tpk);
                        ++offs;
                    }
                }
                ++offs;
                allTrainers.add(tr);
            }
        }
        Gen1Constants.tagTrainersUniversal(allTrainers);
        if (this.romEntry.isYellow) {
            Gen1Constants.tagTrainersYellow(allTrainers);
        } else {
            Gen1Constants.tagTrainersRB(allTrainers);
        }
        return allTrainers;
    }

    @Override
    public void setTrainers(List<Trainer> trainerData) {
        int traineroffset = this.romEntry.getValue("TrainerDataTableOffset");
        int traineramount = 47;
        int[] trainerclasslimits = (int[])this.romEntry.arrayEntries.get("TrainerDataClassCounts");
        int[] pointers = new int[traineramount + 1];
        for (int i = 1; i <= traineramount; ++i) {
            int tPointer = this.readWord(traineroffset + (i - 1) * 2);
            pointers[i] = this.calculateOffset(this.bankOf(traineroffset), tPointer);
        }
        Iterator<Trainer> allTrainers = trainerData.iterator();
        for (int i = 1; i <= traineramount; ++i) {
            int offs = pointers[i];
            int limit = trainerclasslimits[i];
            for (int trnum = 0; trnum < limit; ++trnum) {
                Trainer tr = allTrainers.next();
                if (tr.trainerclass != i) {
                    System.err.println("Trainer mismatch: " + tr.name);
                }
                Iterator<TrainerPokemon> tPokes = tr.pokemon.iterator();
                if (tr.poketype == 0) {
                    int fixedLevel = tr.pokemon.get((int)0).level;
                    this.rom[offs] = (byte)fixedLevel;
                    ++offs;
                    while (tPokes.hasNext()) {
                        TrainerPokemon tpk = tPokes.next();
                        this.rom[offs] = (byte)this.pokeNumToRBYTable[tpk.pokemon.number];
                        ++offs;
                    }
                } else {
                    this.rom[offs] = -1;
                    ++offs;
                    while (tPokes.hasNext()) {
                        TrainerPokemon tpk = tPokes.next();
                        this.rom[offs] = (byte)tpk.level;
                        this.rom[offs + 1] = (byte)this.pokeNumToRBYTable[tpk.pokemon.number];
                        offs += 2;
                    }
                }
                this.rom[offs] = 0;
                ++offs;
            }
        }
        this.rom[((RomEntry)this.romEntry).getValue((String)"ExtraTrainerMovesTableOffset")] = -1;
        if (!this.isYellow()) {
            int champRivalJump = this.romEntry.getValue("GymLeaderMovesTableOffset") - 68;
            this.rom[champRivalJump] = 0;
            this.rom[champRivalJump + 1] = 0;
        }
    }

    @Override
    public boolean isYellow() {
        return this.romEntry.isYellow;
    }

    @Override
    public boolean typeInGame(Type type) {
        if (!type.isHackOnly && type != Type.DARK && type != Type.STEEL) {
            return true;
        }
        return this.romEntry.extraTypeReverse.containsKey((Object)type);
    }

    private void fixTypeEffectiveness() {
        int base = this.romEntry.getValue("TypeEffectivenessOffset");
        this.log("--Fixing Type Effectiveness--");
        this.log("Replaced: Poison super effective vs Bug => Ice not very effective vs Fire");
        this.rom[base + 135] = this.typeToByte(Type.ICE);
        this.rom[base + 136] = this.typeToByte(Type.FIRE);
        this.rom[base + 137] = 5;
        this.log("Changed: Bug super effective vs Poison => Bug not very effective vs Poison");
        this.rom[base + 203] = 5;
        this.log("Changed: Psychic immune to Ghost => Ghost super effective vs Psychic");
        this.rom[base + 227] = 20;
        this.logBlankLine();
    }

    @Override
    public Map<Pokemon, List<MoveLearnt>> getMovesLearnt() {
        TreeMap<Pokemon, List<MoveLearnt>> movesets = new TreeMap<Pokemon, List<MoveLearnt>>();
        int pointersOffset = this.romEntry.getValue("PokemonMovesetsTableOffset");
        int pokeStatsOffset = this.romEntry.getValue("PokemonStatsOffset");
        int pkmnCount = this.romEntry.getValue("InternalPokemonCount");
        for (int i = 1; i <= pkmnCount; ++i) {
            int pointer = this.readWord(pointersOffset + (i - 1) * 2);
            int realPointer = this.calculateOffset(this.bankOf(pointersOffset), pointer);
            if (this.pokeRBYToNumTable[i] == 0) continue;
            Pokemon pkmn = this.pokes[this.pokeRBYToNumTable[i]];
            int statsOffset = 0;
            statsOffset = this.pokeRBYToNumTable[i] == 151 && !this.romEntry.isYellow ? this.romEntry.getValue("MewStatsOffset") : (this.pokeRBYToNumTable[i] - 1) * 28 + pokeStatsOffset;
            ArrayList<MoveLearnt> ourMoves = new ArrayList<MoveLearnt>();
            for (int delta = 15; delta < 19; ++delta) {
                if (this.rom[statsOffset + delta] == 0) continue;
                MoveLearnt learnt = new MoveLearnt();
                learnt.level = 1;
                learnt.move = this.moveRomToNumTable[this.rom[statsOffset + delta] & 0xFF];
                ourMoves.add(learnt);
            }
            while (this.rom[realPointer] != 0) {
                if (this.rom[realPointer] == 1) {
                    realPointer += 3;
                    continue;
                }
                if (this.rom[realPointer] == 2) {
                    realPointer += 4;
                    continue;
                }
                if (this.rom[realPointer] != 3) continue;
                realPointer += 3;
            }
            ++realPointer;
            while (this.rom[realPointer] != 0) {
                MoveLearnt learnt = new MoveLearnt();
                learnt.level = this.rom[realPointer] & 0xFF;
                learnt.move = this.moveRomToNumTable[this.rom[realPointer + 1] & 0xFF];
                ourMoves.add(learnt);
                realPointer += 2;
            }
            movesets.put(pkmn, ourMoves);
        }
        return movesets;
    }

    @Override
    public void setMovesLearnt(Map<Pokemon, List<MoveLearnt>> movesets) {
        this.writeEvosAndMovesLearnt(false, movesets);
    }

    @Override
    public List<Pokemon> getStaticPokemon() {
        ArrayList<Pokemon> statics = new ArrayList<Pokemon>();
        if (this.romEntry.getValue("StaticPokemonSupport") > 0) {
            Iterator iterator = this.romEntry.staticPokemonSingle.iterator();
            while (iterator.hasNext()) {
                int offset = (Integer)iterator.next();
                statics.add(this.pokes[this.pokeRBYToNumTable[this.rom[offset] & 0xFF]]);
            }
            for (GameCornerPokemon gcp : this.romEntry.staticPokemonGameCorner) {
                statics.add(this.pokes[this.pokeRBYToNumTable[this.rom[gcp.offsets[0]] & 0xFF]]);
            }
            statics.add(this.pokes[this.pokeRBYToNumTable[this.rom[this.romEntry.ghostMarowakOffsets[0]] & 0xFF]]);
        }
        return statics;
    }

    @Override
    public boolean setStaticPokemon(List<Pokemon> staticPokemon) {
        int i;
        if (this.romEntry.getValue("StaticPokemonSupport") == 0) {
            return false;
        }
        int singleSize = this.romEntry.staticPokemonSingle.size();
        int gcSize = this.romEntry.staticPokemonGameCorner.size();
        if (staticPokemon.size() != singleSize + gcSize + 1) {
            return false;
        }
        for (i = 0; i < singleSize; ++i) {
            this.rom[((Integer)((RomEntry)this.romEntry).staticPokemonSingle.get((int)i)).intValue()] = (byte)this.pokeNumToRBYTable[staticPokemon.get((int)i).number];
        }
        for (i = 0; i < gcSize; ++i) {
            int[] offsets;
            byte pokeNum = (byte)this.pokeNumToRBYTable[staticPokemon.get((int)(i + singleSize)).number];
            for (int offset : offsets = ((GameCornerPokemon)this.romEntry.staticPokemonGameCorner.get(i)).offsets) {
                this.rom[offset] = pokeNum;
            }
        }
        byte maroNum = (byte)this.pokeNumToRBYTable[staticPokemon.get((int)(singleSize + gcSize)).number];
        for (int maroOffset : this.romEntry.ghostMarowakOffsets) {
            this.rom[maroOffset] = maroNum;
        }
        return true;
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return this.romEntry.getValue("StaticPokemonSupport") > 0;
    }

    @Override
    public List<Integer> getTMMoves() {
        ArrayList<Integer> tms = new ArrayList<Integer>();
        int offset = this.romEntry.getValue("TMMovesOffset");
        for (int i = 1; i <= 50; ++i) {
            tms.add(this.moveRomToNumTable[this.rom[offset + (i - 1)] & 0xFF]);
        }
        return tms;
    }

    @Override
    public List<Integer> getHMMoves() {
        ArrayList<Integer> hms = new ArrayList<Integer>();
        int offset = this.romEntry.getValue("TMMovesOffset");
        for (int i = 1; i <= 5; ++i) {
            hms.add(this.moveRomToNumTable[this.rom[offset + 50 + (i - 1)] & 0xFF]);
        }
        return hms;
    }

    @Override
    public void setTMMoves(List<Integer> moveIndexes) {
        int offset = this.romEntry.getValue("TMMovesOffset");
        for (int i = 1; i <= 50; ++i) {
            this.rom[offset + (i - 1)] = (byte)this.moveNumToRomTable[moveIndexes.get(i - 1)];
        }
        if (!this.romEntry.isYellow) {
            int[] tms = Gen1Constants.gymLeaderTMs;
            int glMovesOffset = this.romEntry.getValue("GymLeaderMovesTableOffset");
            for (int i = 0; i < tms.length; ++i) {
                this.rom[glMovesOffset + i * 2] = (byte)this.moveNumToRomTable[moveIndexes.get(tms[i] - 1)];
            }
        }
        String[] moveNames = this.readMoveNames();
        for (TMTextEntry tte : this.romEntry.tmTexts) {
            String moveName = moveNames[this.moveNumToRomTable[moveIndexes.get(tte.number - 1)]];
            String text = tte.template.replace("%m", moveName);
            this.writeVariableLengthString(text, tte.offset, true);
        }
    }

    @Override
    public int getTMCount() {
        return 50;
    }

    @Override
    public int getHMCount() {
        return 5;
    }

    @Override
    public Map<Pokemon, boolean[]> getTMHMCompatibility() {
        TreeMap<Pokemon, boolean[]> compat = new TreeMap<Pokemon, boolean[]>();
        int pokeStatsOffset = this.romEntry.getValue("PokemonStatsOffset");
        for (int i = 1; i <= this.pokedexCount; ++i) {
            int baseStatsOffset = this.romEntry.isYellow || i != 151 ? pokeStatsOffset + (i - 1) * 28 : this.romEntry.getValue("MewStatsOffset");
            Pokemon pkmn = this.pokes[i];
            boolean[] flags = new boolean[56];
            for (int j = 0; j < 7; ++j) {
                this.readByteIntoFlags(flags, j * 8 + 1, baseStatsOffset + 20 + j);
            }
            compat.put(pkmn, flags);
        }
        return compat;
    }

    @Override
    public void setTMHMCompatibility(Map<Pokemon, boolean[]> compatData) {
        int pokeStatsOffset = this.romEntry.getValue("PokemonStatsOffset");
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compatData.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            int baseStatsOffset = this.romEntry.isYellow || pkmn.number != 151 ? pokeStatsOffset + (pkmn.number - 1) * 28 : this.romEntry.getValue("MewStatsOffset");
            for (int j = 0; j < 7; ++j) {
                this.rom[baseStatsOffset + 20 + j] = this.getByteFromFlags(flags, j * 8 + 1);
            }
        }
    }

    @Override
    public boolean hasMoveTutors() {
        return false;
    }

    @Override
    public List<Integer> getMoveTutorMoves() {
        return new ArrayList<Integer>();
    }

    @Override
    public void setMoveTutorMoves(List<Integer> moves) {
    }

    @Override
    public Map<Pokemon, boolean[]> getMoveTutorCompatibility() {
        return new TreeMap<Pokemon, boolean[]>();
    }

    @Override
    public void setMoveTutorCompatibility(Map<Pokemon, boolean[]> compatData) {
    }

    @Override
    public String getROMName() {
        return "Pokemon " + this.romEntry.name;
    }

    @Override
    public String getROMCode() {
        return this.romEntry.romName + " (" + this.romEntry.version + "/" + this.romEntry.nonJapanese + ")";
    }

    @Override
    public String getSupportLevel() {
        return this.romEntry.getValue("StaticPokemonSupport") > 0 ? "Complete" : "No Static Pokemon";
    }

    private void populateEvolutions() {
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            pkmn.evolutionsFrom.clear();
            pkmn.evolutionsTo.clear();
        }
        int pointersOffset = this.romEntry.getValue("PokemonMovesetsTableOffset");
        int pkmnCount = this.romEntry.getValue("InternalPokemonCount");
        for (int i = 1; i <= pkmnCount; ++i) {
            int pointer = this.readWord(pointersOffset + (i - 1) * 2);
            int realPointer = this.calculateOffset(this.bankOf(pointersOffset), pointer);
            if (this.pokeRBYToNumTable[i] == 0) continue;
            int thisPoke = this.pokeRBYToNumTable[i];
            Pokemon pkmn = this.pokes[thisPoke];
            while (this.rom[realPointer] != 0) {
                int extraInfo;
                byte method = this.rom[realPointer];
                EvolutionType type = EvolutionType.fromIndex(1, method);
                int otherPoke = this.pokeRBYToNumTable[this.rom[realPointer + 2 + (type == EvolutionType.STONE ? 1 : 0)] & 0xFF];
                Evolution evo = new Evolution(pkmn, this.pokes[otherPoke], true, type, extraInfo = this.rom[realPointer + 1] & 0xFF);
                if (!pkmn.evolutionsFrom.contains(evo)) {
                    pkmn.evolutionsFrom.add(evo);
                    if (this.pokes[otherPoke] != null) {
                        this.pokes[otherPoke].evolutionsTo.add(evo);
                    }
                }
                realPointer += type == EvolutionType.STONE ? 4 : 3;
            }
            if (pkmn.evolutionsFrom.size() <= 1) continue;
            for (Evolution e : pkmn.evolutionsFrom) {
                e.carryStats = false;
            }
        }
    }

    @Override
    public void removeTradeEvolutions(boolean changeMoveEvos) {
        this.log("--Removing Trade Evolutions--");
        for (Pokemon pkmn : this.pokes) {
            if (pkmn == null) continue;
            for (Evolution evo : pkmn.evolutionsFrom) {
                if (evo.type != EvolutionType.TRADE) continue;
                evo.type = EvolutionType.LEVEL;
                evo.extraInfo = 37;
                this.logEvoChangeLevel(evo.from.name, evo.to.name, 37);
            }
        }
        this.logBlankLine();
    }

    private List<String> getTrainerClassesForText() {
        int[] offsets = (int[])this.romEntry.arrayEntries.get("TrainerClassNamesOffsets");
        ArrayList<String> tcNames = new ArrayList<String>();
        int offset = offsets[offsets.length - 1];
        for (int j = 0; j < Gen1Constants.tclassesCounts[1]; ++j) {
            String name = this.readVariableLengthString(offset, false);
            offset += this.lengthOfStringAt(offset, false) + 1;
            tcNames.add(name);
        }
        return tcNames;
    }

    @Override
    public boolean canChangeTrainerText() {
        return this.romEntry.getValue("CanChangeTrainerText") > 0;
    }

    @Override
    public List<Integer> getDoublesTrainerClasses() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getTrainerNames() {
        int[] offsets = (int[])this.romEntry.arrayEntries.get("TrainerClassNamesOffsets");
        ArrayList<String> trainerNames = new ArrayList<String>();
        int offset = offsets[offsets.length - 1];
        for (int j = 0; j < Gen1Constants.tclassesCounts[1]; ++j) {
            String name = this.readVariableLengthString(offset, false);
            offset += this.lengthOfStringAt(offset, false) + 1;
            if (!Gen1Constants.singularTrainers.contains(j)) continue;
            trainerNames.add(name);
        }
        return trainerNames;
    }

    @Override
    public void setTrainerNames(List<String> trainerNames) {
        if (this.romEntry.getValue("CanChangeTrainerText") > 0) {
            int[] offsets = (int[])this.romEntry.arrayEntries.get("TrainerClassNamesOffsets");
            Iterator<String> trainerNamesI = trainerNames.iterator();
            int offset = offsets[offsets.length - 1];
            for (int j = 0; j < Gen1Constants.tclassesCounts[1]; ++j) {
                int oldLength = this.lengthOfStringAt(offset, false) + 1;
                if (Gen1Constants.singularTrainers.contains(j)) {
                    String newName = trainerNamesI.next();
                    this.writeFixedLengthString(newName, offset, oldLength);
                }
                offset += oldLength;
            }
        }
    }

    @Override
    public RomHandler.TrainerNameMode trainerNameMode() {
        return RomHandler.TrainerNameMode.SAME_LENGTH;
    }

    @Override
    public List<Integer> getTCNameLengthsByTrainer() {
        return new ArrayList<Integer>();
    }

    @Override
    public List<String> getTrainerClassNames() {
        int[] offsets = (int[])this.romEntry.arrayEntries.get("TrainerClassNamesOffsets");
        ArrayList<String> trainerClassNames = new ArrayList<String>();
        if (offsets.length == 2) {
            for (int i = 0; i < offsets.length; ++i) {
                int offset = offsets[i];
                for (int j = 0; j < Gen1Constants.tclassesCounts[i]; ++j) {
                    String name = this.readVariableLengthString(offset, false);
                    offset += this.lengthOfStringAt(offset, false) + 1;
                    if (i != 0 && Gen1Constants.singularTrainers.contains(j)) continue;
                    trainerClassNames.add(name);
                }
            }
        } else {
            int offset = offsets[0];
            for (int j = 0; j < Gen1Constants.tclassesCounts[1]; ++j) {
                String name = this.readVariableLengthString(offset, false);
                offset += this.lengthOfStringAt(offset, false) + 1;
                if (Gen1Constants.singularTrainers.contains(j)) continue;
                trainerClassNames.add(name);
            }
        }
        return trainerClassNames;
    }

    @Override
    public void setTrainerClassNames(List<String> trainerClassNames) {
        block7: {
            if (this.romEntry.getValue("CanChangeTrainerText") <= 0) break block7;
            int[] offsets = (int[])this.romEntry.arrayEntries.get("TrainerClassNamesOffsets");
            Iterator<String> tcNamesIter = trainerClassNames.iterator();
            if (offsets.length == 2) {
                for (int i = 0; i < offsets.length; ++i) {
                    int offset = offsets[i];
                    for (int j = 0; j < Gen1Constants.tclassesCounts[i]; ++j) {
                        int oldLength = this.lengthOfStringAt(offset, false) + 1;
                        if (i == 0 || !Gen1Constants.singularTrainers.contains(j)) {
                            String newName = tcNamesIter.next();
                            this.writeFixedLengthString(newName, offset, oldLength);
                        }
                        offset += oldLength;
                    }
                }
            } else {
                int offset = offsets[0];
                for (int j = 0; j < Gen1Constants.tclassesCounts[1]; ++j) {
                    int oldLength = this.lengthOfStringAt(offset, false) + 1;
                    if (!Gen1Constants.singularTrainers.contains(j)) {
                        String newName = tcNamesIter.next();
                        this.writeFixedLengthString(newName, offset, oldLength);
                    }
                    offset += oldLength;
                }
            }
        }
    }

    @Override
    public boolean fixedTrainerClassNamesLength() {
        return true;
    }

    @Override
    public String getDefaultExtension() {
        return "gbc";
    }

    @Override
    public int abilitiesPerPokemon() {
        return 0;
    }

    @Override
    public int highestAbilityIndex() {
        return 0;
    }

    @Override
    public int internalStringLength(String string) {
        return this.translateString(string).length;
    }

    @Override
    public int miscTweaksAvailable() {
        int available = MiscTweak.LOWER_CASE_POKEMON_NAMES.getValue();
        available |= MiscTweak.UPDATE_TYPE_EFFECTIVENESS.getValue();
        if (this.romEntry.tweakFiles.get("BWXPTweak") != null) {
            available |= MiscTweak.BW_EXP_PATCH.getValue();
        }
        if (this.romEntry.tweakFiles.get("XAccNerfTweak") != null) {
            available |= MiscTweak.NERF_X_ACCURACY.getValue();
        }
        if (this.romEntry.tweakFiles.get("CritRateTweak") != null) {
            available |= MiscTweak.FIX_CRIT_RATE.getValue();
        }
        if (this.romEntry.getValue("TextDelayFunctionOffset") != 0) {
            available |= MiscTweak.FASTEST_TEXT.getValue();
        }
        if (this.romEntry.getValue("PCPotionOffset") != 0) {
            available |= MiscTweak.RANDOMIZE_PC_POTION.getValue();
        }
        if (this.romEntry.getValue("PikachuEvoJumpOffset") != 0) {
            available |= MiscTweak.ALLOW_PIKACHU_EVOLUTION.getValue();
        }
        if (this.romEntry.getValue("CatchingTutorialMonOffset") != 0) {
            available |= MiscTweak.RANDOMIZE_CATCHING_TUTORIAL.getValue();
        }
        return available;
    }

    @Override
    public void applyMiscTweak(MiscTweak tweak) {
        if (tweak == MiscTweak.BW_EXP_PATCH) {
            this.applyBWEXPPatch();
        } else if (tweak == MiscTweak.NERF_X_ACCURACY) {
            this.applyXAccNerfPatch();
        } else if (tweak == MiscTweak.FIX_CRIT_RATE) {
            this.applyCritRatePatch();
        } else if (tweak == MiscTweak.FASTEST_TEXT) {
            this.applyFastestTextPatch();
        } else if (tweak == MiscTweak.RANDOMIZE_PC_POTION) {
            this.randomizePCPotion();
        } else if (tweak == MiscTweak.ALLOW_PIKACHU_EVOLUTION) {
            this.applyPikachuEvoPatch();
        } else if (tweak == MiscTweak.LOWER_CASE_POKEMON_NAMES) {
            this.applyCamelCaseNames();
        } else if (tweak == MiscTweak.UPDATE_TYPE_EFFECTIVENESS) {
            this.fixTypeEffectiveness();
        } else if (tweak == MiscTweak.RANDOMIZE_CATCHING_TUTORIAL) {
            this.randomizeCatchingTutorial();
        }
    }

    private void applyBWEXPPatch() {
        this.genericIPSPatch("BWXPTweak");
    }

    private void applyXAccNerfPatch() {
        this.xAccNerfed = this.genericIPSPatch("XAccNerfTweak");
    }

    private void applyCritRatePatch() {
        this.genericIPSPatch("CritRateTweak");
    }

    private void applyFastestTextPatch() {
        if (this.romEntry.getValue("TextDelayFunctionOffset") != 0) {
            this.rom[((RomEntry)this.romEntry).getValue((String)"TextDelayFunctionOffset")] = -55;
        }
    }

    private void randomizePCPotion() {
        if (this.romEntry.getValue("PCPotionOffset") != 0) {
            this.rom[((RomEntry)this.romEntry).getValue((String)"PCPotionOffset")] = (byte)this.getNonBadItems().randomNonTM(this.random);
        }
    }

    private void applyPikachuEvoPatch() {
        if (this.romEntry.getValue("PikachuEvoJumpOffset") != 0) {
            this.rom[((RomEntry)this.romEntry).getValue((String)"PikachuEvoJumpOffset")] = 24;
        }
    }

    private void randomizeCatchingTutorial() {
        if (this.romEntry.getValue("CatchingTutorialMonOffset") != 0) {
            this.rom[((RomEntry)this.romEntry).getValue((String)"CatchingTutorialMonOffset")] = (byte)this.pokeNumToRBYTable[this.randomPokemon().number];
        }
    }

    private boolean genericIPSPatch(String ctName) {
        String patchName = (String)this.romEntry.tweakFiles.get(ctName);
        if (patchName == null) {
            return false;
        }
        try {
            FileFunctions.applyPatch(this.rom, patchName);
            return true;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    @Override
    public List<Integer> getGameBreakingMoves() {
        if (this.xAccNerfed) {
            return Gen1Constants.bannedMovesWithXAccBanned;
        }
        return Gen1Constants.bannedMovesWithoutXAccBanned;
    }

    @Override
    public List<Integer> getFieldMoves() {
        return Gen1Constants.fieldMoves;
    }

    @Override
    public List<Integer> getEarlyRequiredHMMoves() {
        return Gen1Constants.earlyRequiredHMs;
    }

    @Override
    public void applySignature() {
        int introPokemon = this.pokeNumToRBYTable[this.randomPokemon().number];
        this.rom[((RomEntry)this.romEntry).getValue((String)"IntroPokemonOffset")] = (byte)introPokemon;
        this.rom[((RomEntry)this.romEntry).getValue((String)"IntroCryOffset")] = (byte)introPokemon;
    }

    @Override
    public ItemList getAllowedItems() {
        return Gen1Constants.allowedItems;
    }

    @Override
    public ItemList getNonBadItems() {
        return Gen1Constants.allowedItems;
    }

    private void loadItemNames() {
        int index;
        int origOffset;
        this.itemNames = new String[256];
        this.itemNames[0] = "glitch";
        int itemNameOffset = origOffset = this.romEntry.getValue("ItemNamesOffset");
        for (index = 1; index <= 256 && itemNameOffset / 16384 <= origOffset / 16384; ++index) {
            int startOfText = itemNameOffset;
            while ((this.rom[itemNameOffset] & 0xFF) != 80) {
                ++itemNameOffset;
            }
            ++itemNameOffset;
            this.itemNames[index % 256] = this.readFixedLengthString(startOfText, 20);
        }
        for (index = 196; index < 201; ++index) {
            this.itemNames[index] = String.format("HM%02d", index - 196 + 1);
        }
        for (index = 201; index < 256; ++index) {
            this.itemNames[index] = String.format("TM%02d", index - 201 + 1);
        }
    }

    @Override
    public String[] getItemNames() {
        return this.itemNames;
    }

    private void preloadMaps() {
        int mapBanks = this.romEntry.getValue("MapBanks");
        int mapAddresses = this.romEntry.getValue("MapAddresses");
        this.preloadMap(mapBanks, mapAddresses, 0);
    }

    private void preloadMap(int mapBanks, int mapAddresses, int mapID) {
        SubMap map;
        if (this.maps[mapID] != null || mapID == 237 || mapID == 255) {
            return;
        }
        this.maps[mapID] = map = new SubMap();
        map.id = mapID;
        map.addr = this.calculateOffset(this.rom[mapBanks + mapID] & 0xFF, this.readWord(mapAddresses + mapID * 2));
        map.bank = this.bankOf(map.addr);
        map.header = new MapHeader();
        map.header.tileset_id = this.rom[map.addr] & 0xFF;
        map.header.map_h = this.rom[map.addr + 1] & 0xFF;
        map.header.map_w = this.rom[map.addr + 2] & 0xFF;
        map.header.map_ptr = this.calculateOffset(map.bank, this.readWord(map.addr + 3));
        map.header.text_ptr = this.calculateOffset(map.bank, this.readWord(map.addr + 5));
        map.header.script_ptr = this.calculateOffset(map.bank, this.readWord(map.addr + 7));
        map.header.connect_byte = this.rom[map.addr + 9] & 0xFF;
        int cb = map.header.connect_byte;
        map.n_cons = ((cb & 8) >> 3) + ((cb & 4) >> 2) + ((cb & 2) >> 1) + (cb & 1);
        int cons_offset = map.addr + 10;
        SubMap.access$3802(map, new Connection[map.n_cons]);
        for (int i = 0; i < map.n_cons; ++i) {
            int tcon_offs = cons_offset + i * 11;
            Connection con = new Connection();
            con.index = this.rom[tcon_offs] & 0xFF;
            con.connected_map = this.readWord(tcon_offs + 1);
            con.current_map = this.readWord(tcon_offs + 3);
            con.bigness = this.rom[tcon_offs + 5] & 0xFF;
            con.map_width = this.rom[tcon_offs + 6] & 0xFF;
            con.y_align = this.rom[tcon_offs + 7] & 0xFF;
            con.x_align = this.rom[tcon_offs + 8] & 0xFF;
            con.window = this.readWord(tcon_offs + 9);
            ((SubMap)map).cons[i] = con;
            this.preloadMap(mapBanks, mapAddresses, con.index);
        }
        map.obj_addr = this.calculateOffset(map.bank, this.readWord(cons_offset + map.n_cons * 11));
        int n_warps = this.rom[map.obj_addr + 1] & 0xFF;
        int offs = map.obj_addr + 2;
        for (int i = 0; i < n_warps; ++i) {
            int to_map = this.rom[offs + 3] & 0xFF;
            this.preloadMap(mapBanks, mapAddresses, to_map);
            offs += 4;
        }
        int n_signs = this.rom[offs++] & 0xFF;
        offs += n_signs * 3;
        map.itemOffsets = new ArrayList();
        int n_entities = this.rom[offs++] & 0xFF;
        for (int i = 0; i < n_entities; ++i) {
            int tid = this.rom[offs + 5] & 0xFF;
            if ((tid & 0x40) > 0) {
                offs += 8;
                continue;
            }
            if ((tid & 0x80) > 0 && this.rom[offs + 6] != 0) {
                map.itemOffsets.add(offs + 6);
                offs += 7;
                continue;
            }
            offs += 6;
        }
    }

    private void loadMapNames() {
        this.mapNames = new String[256];
        int mapNameTableOffset = this.romEntry.getValue("MapNameTableOffset");
        int mapNameBank = this.bankOf(mapNameTableOffset);
        ArrayList<Integer> usedExternal = new ArrayList<Integer>();
        for (int i = 0; i < 37; ++i) {
            int externalOffset = this.calculateOffset(mapNameBank, this.readWord(mapNameTableOffset + 1));
            usedExternal.add(externalOffset);
            this.mapNames[i] = this.readVariableLengthString(externalOffset, false);
            mapNameTableOffset += 3;
        }
        int lastMaxMap = 37;
        HashMap<Integer, Integer> previousMapCounts = new HashMap<Integer, Integer>();
        while ((this.rom[mapNameTableOffset] & 0xFF) != 255) {
            int maxMap = this.rom[mapNameTableOffset] & 0xFF;
            int nameOffset = this.calculateOffset(mapNameBank, this.readWord(mapNameTableOffset + 2));
            String actualName = this.readVariableLengthString(nameOffset, false).trim();
            if (usedExternal.contains(nameOffset)) {
                for (int i = lastMaxMap; i < maxMap; ++i) {
                    if (this.maps[i] == null) continue;
                    this.mapNames[i] = actualName + " (Building)";
                }
            } else {
                int mapCount = 0;
                if (previousMapCounts.containsKey(nameOffset)) {
                    mapCount = (Integer)previousMapCounts.get(nameOffset);
                }
                for (int i = lastMaxMap; i < maxMap; ++i) {
                    if (this.maps[i] == null) continue;
                    this.mapNames[i] = actualName + " (" + ++mapCount + ")";
                }
                previousMapCounts.put(nameOffset, mapCount);
            }
            lastMaxMap = maxMap;
            mapNameTableOffset += 4;
        }
    }

    private List<Integer> getItemOffsets() {
        ArrayList<Integer> itemOffs = new ArrayList<Integer>();
        for (int i = 0; i < this.maps.length; ++i) {
            if (this.maps[i] == null) continue;
            itemOffs.addAll(this.maps[i].itemOffsets);
        }
        int hiRoutine = this.romEntry.getValue("HiddenItemRoutine");
        int spclTable = this.romEntry.getValue("SpecialMapPointerTable");
        int spclBank = this.bankOf(spclTable);
        if (!this.isYellow()) {
            int spclList;
            int lOffs = spclList = this.romEntry.getValue("SpecialMapList");
            int idx = 0;
            while ((this.rom[lOffs] & 0xFF) != 255) {
                int spclOffset = this.calculateOffset(spclBank, this.readWord(spclTable + idx));
                while ((this.rom[spclOffset] & 0xFF) != 255) {
                    if (this.calculateOffset(this.rom[spclOffset + 3] & 0xFF, this.readWord(spclOffset + 4)) == hiRoutine) {
                        itemOffs.add(spclOffset + 2);
                    }
                    spclOffset += 6;
                }
                ++lOffs;
                idx += 2;
            }
        } else {
            int lOffs = spclTable;
            while ((this.rom[lOffs] & 0xFF) != 255) {
                int spclOffset = this.calculateOffset(spclBank, this.readWord(lOffs + 1));
                while ((this.rom[spclOffset] & 0xFF) != 255) {
                    if (this.calculateOffset(this.rom[spclOffset + 3] & 0xFF, this.readWord(spclOffset + 4)) == hiRoutine) {
                        itemOffs.add(spclOffset + 2);
                    }
                    spclOffset += 6;
                }
                lOffs += 3;
            }
        }
        return itemOffs;
    }

    @Override
    public List<Integer> getRequiredFieldTMs() {
        return Gen1Constants.requiredFieldTMs;
    }

    @Override
    public List<Integer> getCurrentFieldTMs() {
        List<Integer> itemOffsets = this.getItemOffsets();
        ArrayList<Integer> fieldTMs = new ArrayList<Integer>();
        for (int offset : itemOffsets) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen1Constants.allowedItems.isTM(itemHere)) continue;
            fieldTMs.add(itemHere - 201 + 1);
        }
        return fieldTMs;
    }

    @Override
    public void setFieldTMs(List<Integer> fieldTMs) {
        List<Integer> itemOffsets = this.getItemOffsets();
        Iterator<Integer> iterTMs = fieldTMs.iterator();
        for (int offset : itemOffsets) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen1Constants.allowedItems.isTM(itemHere)) continue;
            this.rom[offset] = (byte)(iterTMs.next() + 201 - 1);
        }
    }

    @Override
    public List<Integer> getRegularFieldItems() {
        List<Integer> itemOffsets = this.getItemOffsets();
        ArrayList<Integer> fieldItems = new ArrayList<Integer>();
        for (int offset : itemOffsets) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen1Constants.allowedItems.isAllowed(itemHere) || Gen1Constants.allowedItems.isTM(itemHere)) continue;
            fieldItems.add(itemHere);
        }
        return fieldItems;
    }

    @Override
    public void setRegularFieldItems(List<Integer> items) {
        List<Integer> itemOffsets = this.getItemOffsets();
        Iterator<Integer> iterItems = items.iterator();
        for (int offset : itemOffsets) {
            int itemHere = this.rom[offset] & 0xFF;
            if (!Gen1Constants.allowedItems.isAllowed(itemHere) || Gen1Constants.allowedItems.isTM(itemHere)) continue;
            this.rom[offset] = (byte)iterItems.next().intValue();
        }
    }

    @Override
    public List<IngameTrade> getIngameTrades() {
        ArrayList<IngameTrade> trades = new ArrayList<IngameTrade>();
        int tableOffset = this.romEntry.getValue("TradeTableOffset");
        int tableSize = this.romEntry.getValue("TradeTableSize");
        int nicknameLength = this.romEntry.getValue("TradeNameLength");
        int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
        int unusedOffset = 0;
        int entryLength = nicknameLength + 3;
        for (int entry = 0; entry < tableSize; ++entry) {
            if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                ++unusedOffset;
                continue;
            }
            IngameTrade trade = new IngameTrade();
            int entryOffset = tableOffset + entry * entryLength;
            trade.requestedPokemon = this.pokes[this.pokeRBYToNumTable[this.rom[entryOffset] & 0xFF]];
            trade.givenPokemon = this.pokes[this.pokeRBYToNumTable[this.rom[entryOffset + 1] & 0xFF]];
            trade.nickname = this.readString(entryOffset + 3, nicknameLength, false);
            trades.add(trade);
        }
        return trades;
    }

    @Override
    public void setIngameTrades(List<IngameTrade> trades) {
        int tableOffset = this.romEntry.getValue("TradeTableOffset");
        int tableSize = this.romEntry.getValue("TradeTableSize");
        int nicknameLength = this.romEntry.getValue("TradeNameLength");
        int[] unused = (int[])this.romEntry.arrayEntries.get("TradesUnused");
        int unusedOffset = 0;
        int entryLength = nicknameLength + 3;
        int tradeOffset = 0;
        for (int entry = 0; entry < tableSize; ++entry) {
            if (unusedOffset < unused.length && unused[unusedOffset] == entry) {
                ++unusedOffset;
                continue;
            }
            IngameTrade trade = trades.get(tradeOffset++);
            int entryOffset = tableOffset + entry * entryLength;
            this.rom[entryOffset] = (byte)this.pokeNumToRBYTable[trade.requestedPokemon.number];
            this.rom[entryOffset + 1] = (byte)this.pokeNumToRBYTable[trade.givenPokemon.number];
            if (this.romEntry.getValue("CanChangeTrainerText") <= 0) continue;
            this.writeFixedLengthString(trade.nickname, entryOffset + 3, nicknameLength);
        }
    }

    @Override
    public boolean hasDVs() {
        return true;
    }

    @Override
    public int generationOfPokemon() {
        return 1;
    }

    @Override
    public void removeEvosForPokemonPool() {
    }

    @Override
    public boolean supportsFourStartingMoves() {
        return true;
    }

    private void writeEvosAndMovesLearnt(boolean writeEvos, Map<Pokemon, List<MoveLearnt>> movesets) {
        int pokeStatsOffset = this.romEntry.getValue("PokemonStatsOffset");
        int movesEvosStart = this.romEntry.getValue("PokemonMovesetsTableOffset");
        int movesEvosBank = this.bankOf(movesEvosStart);
        int pkmnCount = this.romEntry.getValue("InternalPokemonCount");
        byte[] pointerTable = new byte[pkmnCount * 2];
        int mainDataBlockSize = this.romEntry.getValue("PokemonMovesetsDataSize");
        int mainDataBlockOffset = movesEvosStart + pointerTable.length;
        byte[] mainDataBlock = new byte[mainDataBlockSize];
        int offsetInMainData = 0;
        int extraSpaceOffset = this.romEntry.getValue("PokemonMovesetsExtraSpaceOffset");
        int extraSpaceBank = this.bankOf(extraSpaceOffset);
        boolean extraSpaceEnabled = false;
        byte[] extraDataBlock = null;
        int offsetInExtraData = 0;
        int extraSpaceSize = 0;
        if (movesEvosBank == extraSpaceBank && extraSpaceOffset != 0) {
            extraSpaceEnabled = true;
            int startOfNextBank = (extraSpaceOffset / 16384 + 1) * 16384;
            extraSpaceSize = startOfNextBank - extraSpaceOffset;
            extraDataBlock = new byte[extraSpaceSize];
        }
        int nullEntryPointer = -1;
        for (int i = 1; i <= pkmnCount; ++i) {
            int writtenDataOffset;
            byte[] writeData = null;
            int oldDataOffset = this.calculateOffset(movesEvosBank, this.readWord(movesEvosStart + (i - 1) * 2));
            boolean setNullEntryPointerHere = false;
            if (this.pokeRBYToNumTable[i] == 0) {
                if (nullEntryPointer == -1) {
                    writeData = new byte[]{0, 0};
                    setNullEntryPointerHere = true;
                } else {
                    this.writeWord(pointerTable, (i - 1) * 2, nullEntryPointer);
                }
            } else {
                int pokeNum = this.pokeRBYToNumTable[i];
                Pokemon pkmn = this.pokes[pokeNum];
                ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                if (!writeEvos) {
                    int evoOffset = oldDataOffset;
                    while (this.rom[evoOffset] != 0) {
                        int method = this.rom[evoOffset] & 0xFF;
                        int limiter = method == 2 ? 4 : 3;
                        for (int b = 0; b < limiter; ++b) {
                            dataStream.write(this.rom[evoOffset++] & 0xFF);
                        }
                    }
                } else {
                    for (Evolution evo : pkmn.evolutionsFrom) {
                        dataStream.write(evo.type.toIndex(1));
                        if (evo.type == EvolutionType.LEVEL) {
                            dataStream.write(evo.extraInfo);
                        } else if (evo.type == EvolutionType.STONE) {
                            dataStream.write(evo.extraInfo);
                            dataStream.write(1);
                        } else if (evo.type == EvolutionType.TRADE) {
                            dataStream.write(1);
                        }
                        int pokeIndexTo = this.pokeNumToRBYTable[evo.to.number];
                        dataStream.write(pokeIndexTo);
                    }
                }
                dataStream.write(0);
                if (movesets == null) {
                    int movesOffset = oldDataOffset;
                    while (this.rom[movesOffset] != 0) {
                        int method;
                        movesOffset += (method = this.rom[movesOffset] & 0xFF) == 2 ? 4 : 3;
                    }
                    ++movesOffset;
                    while (this.rom[movesOffset] != 0) {
                        dataStream.write(this.rom[movesOffset++] & 0xFF);
                        dataStream.write(this.rom[movesOffset++] & 0xFF);
                    }
                } else {
                    int movenum;
                    List<MoveLearnt> ourMoves = movesets.get(pkmn);
                    int statsOffset = 0;
                    statsOffset = pokeNum == 151 && !this.romEntry.isYellow ? this.romEntry.getValue("MewStatsOffset") : (pokeNum - 1) * 28 + pokeStatsOffset;
                    for (movenum = 0; movenum < 4 && ourMoves.size() > movenum && ourMoves.get((int)movenum).level == 1; ++movenum) {
                        this.rom[statsOffset + 15 + movenum] = (byte)this.moveNumToRomTable[ourMoves.get((int)movenum).move];
                    }
                    for (int mn = movenum; mn < 4; ++mn) {
                        this.rom[statsOffset + 15 + mn] = 0;
                    }
                    while (movenum < ourMoves.size()) {
                        dataStream.write(ourMoves.get((int)movenum).level);
                        dataStream.write(this.moveNumToRomTable[ourMoves.get((int)movenum).move]);
                        ++movenum;
                    }
                }
                dataStream.write(0);
                writeData = dataStream.toByteArray();
                try {
                    dataStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (writeData == null) continue;
            int lengthToFit = writeData.length;
            int pointerToWrite = -1;
            if (offsetInMainData + lengthToFit <= mainDataBlockSize || writeData[0] == 0 && offsetInMainData > 0 && offsetInMainData + lengthToFit == mainDataBlockSize + 1) {
                if (writeData[0] == 0 && offsetInMainData > 0) {
                    writtenDataOffset = mainDataBlockOffset + offsetInMainData - 1;
                    pointerToWrite = this.makeGBPointer(writtenDataOffset);
                    System.arraycopy(writeData, 1, mainDataBlock, offsetInMainData, lengthToFit - 1);
                    offsetInMainData += lengthToFit - 1;
                } else {
                    writtenDataOffset = mainDataBlockOffset + offsetInMainData;
                    pointerToWrite = this.makeGBPointer(writtenDataOffset);
                    System.arraycopy(writeData, 0, mainDataBlock, offsetInMainData, lengthToFit);
                    offsetInMainData += lengthToFit;
                }
            } else if (extraSpaceEnabled && (offsetInExtraData + lengthToFit <= extraSpaceSize || writeData[0] == 0 && offsetInExtraData > 0 && offsetInExtraData + lengthToFit == extraSpaceSize + 1)) {
                if (writeData[0] == 0 && offsetInExtraData > 0) {
                    writtenDataOffset = extraSpaceOffset + offsetInExtraData - 1;
                    pointerToWrite = this.makeGBPointer(writtenDataOffset);
                    System.arraycopy(writeData, 1, extraDataBlock, offsetInExtraData, lengthToFit - 1);
                    offsetInExtraData += lengthToFit - 1;
                } else {
                    writtenDataOffset = extraSpaceOffset + offsetInExtraData;
                    pointerToWrite = this.makeGBPointer(writtenDataOffset);
                    System.arraycopy(writeData, 0, extraDataBlock, offsetInExtraData, lengthToFit);
                    offsetInExtraData += lengthToFit;
                }
            } else {
                throw new RandomizationException("Unable to save moves/evolutions, out of space");
            }
            if (pointerToWrite < 0) continue;
            this.writeWord(pointerTable, (i - 1) * 2, pointerToWrite);
            if (!setNullEntryPointerHere) continue;
            nullEntryPointer = pointerToWrite;
        }
        System.arraycopy(pointerTable, 0, this.rom, movesEvosStart, pointerTable.length);
        System.arraycopy(mainDataBlock, 0, this.rom, mainDataBlockOffset, mainDataBlock.length);
        if (extraSpaceEnabled) {
            System.arraycopy(extraDataBlock, 0, this.rom, extraSpaceOffset, extraDataBlock.length);
        }
    }

    @Override
    public BufferedImage getMascotImage() {
        int[] palette;
        Pokemon mascot = this.randomPokemon();
        int idx = this.pokeNumToRBYTable[mascot.number];
        int fsBank = mascot.number == 151 && !this.romEntry.isYellow ? 1 : (idx < 31 ? 9 : (idx < 74 ? 10 : (idx < 116 || idx == 116 && mascot.frontSpritePointer > 28672 ? 11 : (idx < 153 || idx == 153 && mascot.frontSpritePointer > 28672 ? 12 : 13))));
        int fsOffset = this.calculateOffset(fsBank, mascot.frontSpritePointer);
        Gen1Decmp mscSprite = new Gen1Decmp(this.rom, fsOffset);
        mscSprite.decompress();
        mscSprite.transpose();
        int w = mscSprite.getWidth();
        int h = mscSprite.getHeight();
        if (this.romEntry.getValue("MonPaletteIndicesOffset") > 0 && this.romEntry.getValue("SGBPalettesOffset") > 0) {
            int palIndex = this.rom[this.romEntry.getValue("MonPaletteIndicesOffset") + mascot.number] & 0xFF;
            int palOffset = this.romEntry.getValue("SGBPalettesOffset") + palIndex * 8;
            if (this.romEntry.isYellow && this.romEntry.nonJapanese == 1) {
                palOffset += 320;
            }
            palette = new int[4];
            for (int i = 0; i < 4; ++i) {
                palette[i] = GFXFunctions.conv16BitColorToARGB(this.readWord(palOffset + i * 2));
            }
        } else {
            palette = new int[]{-1, -5592406, -10066330, -16777216};
        }
        byte[] data = mscSprite.getFlattenedData();
        BufferedImage bim = GFXFunctions.drawTiledImage(data, palette, w, h, 8);
        GFXFunctions.pseudoTransparency(bim, palette[0]);
        return bim;
    }

    static {
        Gen1RomHandler.loadROMInfo();
    }

    private static class Connection {
        private int index;
        private int connected_map;
        private int current_map;
        private int bigness;
        private int map_width;
        private int y_align;
        private int x_align;
        private int window;

        private Connection() {
        }
    }

    private static class MapHeader {
        private int tileset_id;
        private int map_h;
        private int map_w;
        private int map_ptr;
        private int text_ptr;
        private int script_ptr;
        private int connect_byte;

        private MapHeader() {
        }
    }

    private static class SubMap {
        private int id;
        private int addr;
        private int bank;
        private MapHeader header;
        private Connection[] cons;
        private int n_cons;
        private int obj_addr;
        private List<Integer> itemOffsets;

        private SubMap() {
        }

        static /* synthetic */ Connection[] access$3802(SubMap x0, Connection[] x1) {
            x0.cons = x1;
            return x1;
        }
    }

    private static class TMTextEntry {
        private int number;
        private int offset;
        private String template;

        private TMTextEntry() {
        }
    }

    private static class GameCornerPokemon {
        private int[] offsets;

        private GameCornerPokemon() {
        }

        public String toString() {
            return Arrays.toString(this.offsets);
        }

        static /* synthetic */ int[] access$502(GameCornerPokemon x0, int[] x1) {
            x0.offsets = x1;
            return x1;
        }
    }

    private static class RomEntry {
        private String name;
        private String romName;
        private int version;
        private int nonJapanese;
        private String extraTableFile;
        private boolean isYellow;
        private int crcInHeader = -1;
        private Map<String, String> tweakFiles = new HashMap<String, String>();
        private List<TMTextEntry> tmTexts = new ArrayList<TMTextEntry>();
        private Map<String, Integer> entries = new HashMap<String, Integer>();
        private Map<String, int[]> arrayEntries = new HashMap<String, int[]>();
        private List<Integer> staticPokemonSingle = new ArrayList<Integer>();
        private List<GameCornerPokemon> staticPokemonGameCorner = new ArrayList<GameCornerPokemon>();
        private int[] ghostMarowakOffsets = new int[0];
        private Map<Integer, Type> extraTypeLookup = new HashMap<Integer, Type>();
        private Map<Type, Integer> extraTypeReverse = new HashMap<Type, Integer>();

        private RomEntry() {
        }

        private int getValue(String key) {
            if (!this.entries.containsKey(key)) {
                this.entries.put(key, 0);
            }
            return this.entries.get(key);
        }

        static /* synthetic */ int[] access$702(RomEntry x0, int[] x1) {
            x0.ghostMarowakOffsets = x1;
            return x1;
        }
    }

    public static class Factory
    extends RomHandler.Factory {
        @Override
        public Gen1RomHandler create(Random random, PrintStream logStream) {
            return new Gen1RomHandler(random, logStream);
        }

        @Override
        public boolean isLoadable(String filename) {
            long fileLength = new File(filename).length();
            if (fileLength > 0x800000L) {
                return false;
            }
            byte[] loaded = AbstractGBRomHandler.loadFilePartial(filename, 4096);
            if (loaded.length == 0) {
                return false;
            }
            return Gen1RomHandler.detectRomInner(loaded, (int)fileLength);
        }
    }
}

