/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RomFunctions;
import com.dabomstew.pkrandom.constants.GlobalConstants;
import com.dabomstew.pkrandom.exceptions.RandomizationException;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.EvolutionType;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.GenRestrictions;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveCategory;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.pokemon.Type;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class AbstractRomHandler
implements RomHandler {
    private boolean restrictionsSet;
    protected List<Pokemon> mainPokemonList;
    protected List<Pokemon> noLegendaryList;
    protected List<Pokemon> onlyLegendaryList;
    protected final Random random;
    protected PrintStream logStream;
    private List<Pokemon> twoEvoPokes;
    private Map<Integer, boolean[]> moveUpdates;
    private Map<Type, Integer> typeWeightings;
    private int totalTypeWeighting;
    private Map<Type, List<Pokemon>> cachedReplacementLists;
    private List<Pokemon> cachedAllList;

    public AbstractRomHandler(Random random, PrintStream logStream) {
        this.random = random;
        this.logStream = logStream;
    }

    @Override
    public void setLog(PrintStream logStream) {
        this.logStream = logStream;
    }

    @Override
    public void setPokemonPool(GenRestrictions restrictions) {
        this.restrictionsSet = true;
        this.mainPokemonList = this.allPokemonWithoutNull();
        if (restrictions != null) {
            this.mainPokemonList = new ArrayList<Pokemon>();
            List<Pokemon> allPokemon = this.getPokemon();
            if (restrictions.allow_gen1) {
                this.addPokesFromRange(this.mainPokemonList, allPokemon, 1, 151);
                if (restrictions.assoc_g1_g2 && allPokemon.size() > 251) {
                    this.addEvosFromRange(this.mainPokemonList, 1, 151, 152, 251);
                }
                if (restrictions.assoc_g1_g4 && allPokemon.size() > 493) {
                    this.addEvosFromRange(this.mainPokemonList, 1, 151, 387, 493);
                }
            }
            if (restrictions.allow_gen2 && allPokemon.size() > 251) {
                this.addPokesFromRange(this.mainPokemonList, allPokemon, 152, 251);
                if (restrictions.assoc_g2_g1) {
                    this.addEvosFromRange(this.mainPokemonList, 152, 251, 1, 151);
                }
                if (restrictions.assoc_g2_g3 && allPokemon.size() > 386) {
                    this.addEvosFromRange(this.mainPokemonList, 152, 251, 252, 386);
                }
                if (restrictions.assoc_g2_g4 && allPokemon.size() > 493) {
                    this.addEvosFromRange(this.mainPokemonList, 152, 251, 387, 493);
                }
            }
            if (restrictions.allow_gen3 && allPokemon.size() > 386) {
                this.addPokesFromRange(this.mainPokemonList, allPokemon, 252, 386);
                if (restrictions.assoc_g3_g2) {
                    this.addEvosFromRange(this.mainPokemonList, 252, 386, 152, 251);
                }
                if (restrictions.assoc_g3_g4 && allPokemon.size() > 493) {
                    this.addEvosFromRange(this.mainPokemonList, 252, 386, 387, 493);
                }
            }
            if (restrictions.allow_gen4 && allPokemon.size() > 493) {
                this.addPokesFromRange(this.mainPokemonList, allPokemon, 387, 493);
                if (restrictions.assoc_g4_g1) {
                    this.addEvosFromRange(this.mainPokemonList, 387, 493, 1, 151);
                }
                if (restrictions.assoc_g4_g2) {
                    this.addEvosFromRange(this.mainPokemonList, 387, 493, 152, 251);
                }
                if (restrictions.assoc_g4_g3) {
                    this.addEvosFromRange(this.mainPokemonList, 387, 493, 252, 386);
                }
            }
            if (restrictions.allow_gen5 && allPokemon.size() > 649) {
                this.addPokesFromRange(this.mainPokemonList, allPokemon, 494, 649);
            }
        }
        this.noLegendaryList = new ArrayList<Pokemon>();
        this.onlyLegendaryList = new ArrayList<Pokemon>();
        for (Pokemon p : this.mainPokemonList) {
            if (p.isLegendary()) {
                this.onlyLegendaryList.add(p);
                continue;
            }
            this.noLegendaryList.add(p);
        }
    }

    private void addPokesFromRange(List<Pokemon> pokemonPool, List<Pokemon> allPokemon, int range_min, int range_max) {
        for (int i = range_min; i <= range_max; ++i) {
            if (pokemonPool.contains(allPokemon.get(i))) continue;
            pokemonPool.add(allPokemon.get(i));
        }
    }

    private void addEvosFromRange(List<Pokemon> pokemonPool, int first_min, int first_max, int second_min, int second_max) {
        TreeSet<Pokemon> newPokemon = new TreeSet<Pokemon>();
        for (Pokemon pk : pokemonPool) {
            if (pk.number < first_min || pk.number > first_max) continue;
            for (Evolution ev : pk.evolutionsFrom) {
                if (ev.to.number < second_min || ev.to.number > second_max || pokemonPool.contains(ev.to) || newPokemon.contains(ev.to)) continue;
                newPokemon.add(ev.to);
            }
            for (Evolution ev : pk.evolutionsTo) {
                if (ev.from.number < second_min || ev.from.number > second_max || pokemonPool.contains(ev.from) || newPokemon.contains(ev.from)) continue;
                newPokemon.add(ev.from);
            }
        }
        pokemonPool.addAll(newPokemon);
    }

    @Override
    public void shufflePokemonStats(boolean evolutionSanity) {
        if (evolutionSanity) {
            this.copyUpEvolutionsHelper(new BasePokemonAction(){

                @Override
                public void applyTo(Pokemon pk) {
                    pk.shuffleStats(AbstractRomHandler.this.random);
                }
            }, new EvolvedPokemonAction(){

                @Override
                public void applyTo(Pokemon evFrom, Pokemon evTo, boolean toMonIsFinalEvo) {
                    evTo.copyShuffledStatsUpEvolution(evFrom);
                }
            });
        } else {
            List<Pokemon> allPokes = this.getPokemon();
            for (Pokemon pk : allPokes) {
                if (pk == null) continue;
                pk.shuffleStats(this.random);
            }
        }
    }

    @Override
    public void randomizePokemonStats(boolean evolutionSanity) {
        if (evolutionSanity) {
            this.copyUpEvolutionsHelper(new BasePokemonAction(){

                @Override
                public void applyTo(Pokemon pk) {
                    pk.randomizeStatsWithinBST(AbstractRomHandler.this.random);
                }
            }, new EvolvedPokemonAction(){

                @Override
                public void applyTo(Pokemon evFrom, Pokemon evTo, boolean toMonIsFinalEvo) {
                    evTo.copyRandomizedStatsUpEvolution(evFrom);
                }
            });
        } else {
            List<Pokemon> allPokes = this.getPokemon();
            for (Pokemon pk : allPokes) {
                if (pk == null) continue;
                pk.randomizeStatsWithinBST(this.random);
            }
        }
    }

    @Override
    public void updatePokemonStats() {
        List<Pokemon> pokes = this.getPokemon();
        pokes.get((int)15).attack = 90;
        pokes.get((int)18).speed = 101;
        pokes.get((int)25).defense = 40;
        pokes.get((int)26).speed = 110;
        pokes.get((int)31).attack = 92;
        pokes.get((int)34).attack = 102;
        pokes.get((int)62).attack = 95;
        pokes.get((int)76).attack = 120;
        if (this.generationOfPokemon() == 1) {
            pokes.get((int)12).special = 90;
            pokes.get((int)36).special = 95;
            pokes.get((int)45).special = 110;
        } else {
            pokes.get((int)12).spatk = 90;
            pokes.get((int)25).spdef = 50;
            pokes.get((int)36).spatk = 95;
            pokes.get((int)40).spatk = 85;
            pokes.get((int)45).spatk = 110;
            pokes.get((int)65).spdef = 95;
            pokes.get((int)71).spdef = 70;
            pokes.get((int)181).defense = 85;
            pokes.get((int)182).defense = 95;
            pokes.get((int)184).spatk = 60;
            pokes.get((int)189).spdef = 95;
            if (this.generationOfPokemon() >= 3) {
                pokes.get((int)267).spatk = 100;
                pokes.get((int)295).spdef = 73;
            }
            if (this.generationOfPokemon() >= 4) {
                pokes.get((int)398).spdef = 60;
                pokes.get((int)407).defense = 65;
            }
            if (this.generationOfPokemon() >= 5) {
                pokes.get((int)508).attack = 110;
                pokes.get((int)521).attack = 115;
                pokes.get((int)526).spdef = 80;
                pokes.get((int)537).attack = 95;
                pokes.get((int)542).spdef = 80;
                pokes.get((int)545).attack = 100;
                pokes.get((int)553).defense = 80;
            }
        }
    }

    @Override
    public Pokemon randomPokemon() {
        this.checkPokemonRestrictions();
        return this.mainPokemonList.get(this.random.nextInt(this.mainPokemonList.size()));
    }

    @Override
    public Pokemon randomNonLegendaryPokemon() {
        this.checkPokemonRestrictions();
        return this.noLegendaryList.get(this.random.nextInt(this.noLegendaryList.size()));
    }

    @Override
    public Pokemon randomLegendaryPokemon() {
        this.checkPokemonRestrictions();
        return this.onlyLegendaryList.get(this.random.nextInt(this.onlyLegendaryList.size()));
    }

    @Override
    public Pokemon random2EvosPokemon() {
        if (this.twoEvoPokes == null) {
            this.twoEvoPokes = new ArrayList<Pokemon>();
            List<Pokemon> allPokes = this.getPokemon();
            block0: for (Pokemon pk : allPokes) {
                if (pk == null || pk.evolutionsTo.size() != 0 || pk.evolutionsFrom.size() <= 0) continue;
                for (Evolution ev : pk.evolutionsFrom) {
                    if (ev.to.evolutionsFrom.size() <= 0) continue;
                    this.twoEvoPokes.add(pk);
                    continue block0;
                }
            }
        }
        return this.twoEvoPokes.get(this.random.nextInt(this.twoEvoPokes.size()));
    }

    @Override
    public Type randomType() {
        Type t = Type.randomType(this.random);
        while (!this.typeInGame(t)) {
            t = Type.randomType(this.random);
        }
        return t;
    }

    @Override
    public void randomizePokemonTypes(boolean evolutionSanity) {
        List<Pokemon> allPokes = this.getPokemon();
        if (evolutionSanity) {
            this.copyUpEvolutionsHelper(new BasePokemonAction(){

                @Override
                public void applyTo(Pokemon pk) {
                    block4: {
                        block3: {
                            pk.primaryType = AbstractRomHandler.this.randomType();
                            pk.secondaryType = null;
                            if (pk.evolutionsFrom.size() != 1 || !pk.evolutionsFrom.get((int)0).carryStats) break block3;
                            if (!(AbstractRomHandler.this.random.nextDouble() < 0.35)) break block4;
                            pk.secondaryType = AbstractRomHandler.this.randomType();
                            while (pk.secondaryType == pk.primaryType) {
                                pk.secondaryType = AbstractRomHandler.this.randomType();
                            }
                            break block4;
                        }
                        if (AbstractRomHandler.this.random.nextDouble() < 0.5) {
                            pk.secondaryType = AbstractRomHandler.this.randomType();
                            while (pk.secondaryType == pk.primaryType) {
                                pk.secondaryType = AbstractRomHandler.this.randomType();
                            }
                        }
                    }
                }
            }, new EvolvedPokemonAction(){

                @Override
                public void applyTo(Pokemon evFrom, Pokemon evTo, boolean toMonIsFinalEvo) {
                    evTo.primaryType = evFrom.primaryType;
                    evTo.secondaryType = evFrom.secondaryType;
                    if (evTo.secondaryType == null) {
                        double chance;
                        double d = chance = toMonIsFinalEvo ? 0.25 : 0.15;
                        if (AbstractRomHandler.this.random.nextDouble() < chance) {
                            evTo.secondaryType = AbstractRomHandler.this.randomType();
                            while (evTo.secondaryType == evTo.primaryType) {
                                evTo.secondaryType = AbstractRomHandler.this.randomType();
                            }
                        }
                    }
                }
            });
        } else {
            for (Pokemon pkmn : allPokes) {
                if (pkmn == null) continue;
                pkmn.primaryType = this.randomType();
                pkmn.secondaryType = null;
                if (!(this.random.nextDouble() < 0.5)) continue;
                pkmn.secondaryType = this.randomType();
                while (pkmn.secondaryType == pkmn.primaryType) {
                    pkmn.secondaryType = this.randomType();
                }
            }
        }
    }

    @Override
    public void randomizeAbilities(boolean evolutionSanity, boolean allowWonderGuard, boolean banTrappingAbilities, boolean banNegativeAbilities) {
        if (this.abilitiesPerPokemon() == 0) {
            return;
        }
        final boolean hasDWAbilities = this.abilitiesPerPokemon() == 3;
        final ArrayList<Integer> bannedAbilities = new ArrayList<Integer>();
        if (!allowWonderGuard) {
            bannedAbilities.add(25);
        }
        if (banTrappingAbilities) {
            bannedAbilities.addAll(GlobalConstants.battleTrappingAbilities);
        }
        if (banNegativeAbilities) {
            bannedAbilities.addAll(GlobalConstants.negativeAbilities);
        }
        final int maxAbility = this.highestAbilityIndex();
        if (evolutionSanity) {
            this.copyUpEvolutionsHelper(new BasePokemonAction(){

                @Override
                public void applyTo(Pokemon pk) {
                    if (pk.ability1 != 25 && pk.ability2 != 25 && pk.ability3 != 25) {
                        pk.ability1 = AbstractRomHandler.this.pickRandomAbility(maxAbility, bannedAbilities, new int[0]);
                        pk.ability2 = AbstractRomHandler.this.random.nextDouble() < 0.5 ? AbstractRomHandler.this.pickRandomAbility(maxAbility, bannedAbilities, new int[]{pk.ability1}) : 0;
                        if (hasDWAbilities) {
                            pk.ability3 = AbstractRomHandler.this.pickRandomAbility(maxAbility, bannedAbilities, new int[]{pk.ability1, pk.ability2});
                        }
                    }
                }
            }, new EvolvedPokemonAction(){

                @Override
                public void applyTo(Pokemon evFrom, Pokemon evTo, boolean toMonIsFinalEvo) {
                    if (evTo.ability1 != 25 && evTo.ability2 != 25 && evTo.ability3 != 25) {
                        evTo.ability1 = evFrom.ability1;
                        evTo.ability2 = evFrom.ability2;
                        evTo.ability3 = evFrom.ability3;
                    }
                }
            });
        } else {
            List<Pokemon> allPokes = this.getPokemon();
            for (Pokemon pk : allPokes) {
                if (pk == null || pk.ability1 == 25 || pk.ability2 == 25 || pk.ability3 == 25) continue;
                pk.ability1 = this.pickRandomAbility(maxAbility, bannedAbilities, new int[0]);
                pk.ability2 = this.random.nextDouble() < 0.5 ? this.pickRandomAbility(maxAbility, bannedAbilities, pk.ability1) : 0;
                if (!hasDWAbilities) continue;
                pk.ability3 = this.pickRandomAbility(maxAbility, bannedAbilities, pk.ability1, pk.ability2);
            }
        }
    }

    private int pickRandomAbility(int maxAbility, List<Integer> bannedAbilities, int ... alreadySetAbilities) {
        int newAbility = 0;
        while (true) {
            if (bannedAbilities.contains(newAbility = this.random.nextInt(maxAbility) + 1)) {
                continue;
            }
            boolean repeat = false;
            for (int i = 0; i < alreadySetAbilities.length; ++i) {
                if (alreadySetAbilities[i] != newAbility) continue;
                repeat = true;
                break;
            }
            if (!repeat) break;
        }
        return newAbility;
    }

    @Override
    public void randomEncounters(boolean useTimeOfDay, boolean catchEmAll, boolean typeThemed, boolean usePowerLevels, boolean noLegendaries) {
        this.checkPokemonRestrictions();
        List<EncounterSet> currentEncounters = this.getEncounters(useTimeOfDay);
        ArrayList<EncounterSet> scrambledEncounters = new ArrayList<EncounterSet>(currentEncounters);
        Collections.shuffle(scrambledEncounters, this.random);
        List<Pokemon> banned = this.bannedForWildEncounters();
        if (catchEmAll) {
            ArrayList<Pokemon> allPokes = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
            allPokes.removeAll(banned);
            for (EncounterSet area : scrambledEncounters) {
                ArrayList<Pokemon> pickablePokemon = allPokes;
                if (area.bannedPokemon.size() > 0) {
                    pickablePokemon = new ArrayList<Pokemon>(allPokes);
                    pickablePokemon.removeAll(area.bannedPokemon);
                }
                for (Encounter enc : area.encounters) {
                    if (pickablePokemon.size() == 0) {
                        ArrayList<Pokemon> tempPickable = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
                        tempPickable.removeAll(banned);
                        tempPickable.removeAll(area.bannedPokemon);
                        if (tempPickable.size() == 0) {
                            throw new RandomizationException("ERROR: Couldn't replace a wild Pokemon!");
                        }
                        int picked = this.random.nextInt(tempPickable.size());
                        enc.pokemon = (Pokemon)tempPickable.get(picked);
                        continue;
                    }
                    int picked = this.random.nextInt(pickablePokemon.size());
                    enc.pokemon = (Pokemon)pickablePokemon.get(picked);
                    pickablePokemon.remove(picked);
                    if (allPokes != pickablePokemon) {
                        allPokes.remove(enc.pokemon);
                    }
                    if (allPokes.size() != 0) continue;
                    allPokes.addAll(noLegendaries ? this.noLegendaryList : this.mainPokemonList);
                    allPokes.removeAll(banned);
                    if (pickablePokemon == allPokes) continue;
                    pickablePokemon.addAll(allPokes);
                    pickablePokemon.removeAll(area.bannedPokemon);
                }
            }
        } else if (typeThemed) {
            TreeMap<Object, List<Pokemon>> cachedPokeLists = new TreeMap<Object, List<Pokemon>>();
            for (EncounterSet area : scrambledEncounters) {
                ArrayList possiblePokemon = null;
                for (int iterLoops = 0; possiblePokemon == null && iterLoops < 10000; ++iterLoops) {
                    Object areaTheme = this.randomType();
                    if (!cachedPokeLists.containsKey(areaTheme)) {
                        List<Pokemon> pType = this.pokemonOfType((Type)((Object)areaTheme), noLegendaries);
                        pType.removeAll(banned);
                        cachedPokeLists.put(areaTheme, pType);
                    }
                    possiblePokemon = (ArrayList)cachedPokeLists.get(areaTheme);
                    if (area.bannedPokemon.size() > 0) {
                        possiblePokemon = new ArrayList(possiblePokemon);
                        possiblePokemon.removeAll(area.bannedPokemon);
                    }
                    if (possiblePokemon.size() != 0) continue;
                    possiblePokemon = null;
                }
                if (possiblePokemon == null) {
                    throw new RandomizationException("Could not randomize an area in a reasonable amount of attempts.");
                }
                for (Encounter enc : area.encounters) {
                    enc.pokemon = (Pokemon)possiblePokemon.get(this.random.nextInt(possiblePokemon.size()));
                }
            }
        } else if (usePowerLevels) {
            ArrayList<Pokemon> allowedPokes = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
            allowedPokes.removeAll(banned);
            for (EncounterSet area : scrambledEncounters) {
                ArrayList<Pokemon> localAllowed = allowedPokes;
                if (area.bannedPokemon.size() > 0) {
                    localAllowed = new ArrayList<Pokemon>(allowedPokes);
                    localAllowed.removeAll(area.bannedPokemon);
                }
                for (Encounter enc : area.encounters) {
                    enc.pokemon = this.pickWildPowerLvlReplacement(localAllowed, enc.pokemon, false, null);
                }
            }
        } else {
            for (EncounterSet area : scrambledEncounters) {
                for (Encounter enc : area.encounters) {
                    Pokemon pokemon = enc.pokemon = noLegendaries ? this.randomNonLegendaryPokemon() : this.randomPokemon();
                    while (banned.contains(enc.pokemon) || area.bannedPokemon.contains(enc.pokemon)) {
                        enc.pokemon = noLegendaries ? this.randomNonLegendaryPokemon() : this.randomPokemon();
                    }
                }
            }
        }
        this.setEncounters(useTimeOfDay, currentEncounters);
    }

    @Override
    public void area1to1Encounters(boolean useTimeOfDay, boolean catchEmAll, boolean typeThemed, boolean usePowerLevels, boolean noLegendaries) {
        this.checkPokemonRestrictions();
        List<EncounterSet> currentEncounters = this.getEncounters(useTimeOfDay);
        List<Pokemon> banned = this.bannedForWildEncounters();
        ArrayList<EncounterSet> scrambledEncounters = new ArrayList<EncounterSet>(currentEncounters);
        Collections.shuffle(scrambledEncounters, this.random);
        if (catchEmAll) {
            ArrayList<Pokemon> allPokes = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
            allPokes.removeAll(banned);
            for (EncounterSet area : scrambledEncounters) {
                Set<Pokemon> inArea = this.pokemonInArea(area);
                TreeMap<Pokemon, Pokemon> areaMap = new TreeMap<Pokemon, Pokemon>();
                ArrayList<Pokemon> pickablePokemon = allPokes;
                if (area.bannedPokemon.size() > 0) {
                    pickablePokemon = new ArrayList<Pokemon>(allPokes);
                    pickablePokemon.removeAll(area.bannedPokemon);
                }
                for (Pokemon areaPk : inArea) {
                    if (pickablePokemon.size() == 0) {
                        ArrayList<Pokemon> tempPickable = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
                        tempPickable.removeAll(banned);
                        tempPickable.removeAll(area.bannedPokemon);
                        if (tempPickable.size() == 0) {
                            throw new RandomizationException("ERROR: Couldn't replace a wild Pokemon!");
                        }
                        int picked = this.random.nextInt(tempPickable.size());
                        Pokemon pickedMN = (Pokemon)tempPickable.get(picked);
                        areaMap.put(areaPk, pickedMN);
                        continue;
                    }
                    int picked = this.random.nextInt(allPokes.size());
                    Pokemon pickedMN = (Pokemon)allPokes.get(picked);
                    areaMap.put(areaPk, pickedMN);
                    pickablePokemon.remove(pickedMN);
                    if (allPokes != pickablePokemon) {
                        allPokes.remove(pickedMN);
                    }
                    if (allPokes.size() != 0) continue;
                    allPokes.addAll(noLegendaries ? this.noLegendaryList : this.mainPokemonList);
                    allPokes.removeAll(banned);
                    if (pickablePokemon == allPokes) continue;
                    pickablePokemon.addAll(allPokes);
                    pickablePokemon.removeAll(area.bannedPokemon);
                }
                for (Encounter enc : area.encounters) {
                    enc.pokemon = (Pokemon)areaMap.get(enc.pokemon);
                }
            }
        } else if (typeThemed) {
            TreeMap<Type, List<Pokemon>> cachedPokeLists = new TreeMap<Type, List<Pokemon>>();
            for (EncounterSet area : scrambledEncounters) {
                Set<Pokemon> inArea = this.pokemonInArea(area);
                ArrayList possiblePokemon = null;
                for (int iterLoops = 0; possiblePokemon == null && iterLoops < 10000; ++iterLoops) {
                    Type areaTheme = this.randomType();
                    if (!cachedPokeLists.containsKey((Object)areaTheme)) {
                        List<Pokemon> pType = this.pokemonOfType(areaTheme, noLegendaries);
                        pType.removeAll(banned);
                        cachedPokeLists.put(areaTheme, pType);
                    }
                    possiblePokemon = new ArrayList((Collection)cachedPokeLists.get((Object)areaTheme));
                    if (area.bannedPokemon.size() > 0) {
                        possiblePokemon.removeAll(area.bannedPokemon);
                    }
                    if (possiblePokemon.size() >= inArea.size()) continue;
                    possiblePokemon = null;
                }
                if (possiblePokemon == null) {
                    throw new RandomizationException("Could not randomize an area in a reasonable amount of attempts.");
                }
                TreeMap<Pokemon, Pokemon> areaMap = new TreeMap<Pokemon, Pokemon>();
                for (Pokemon areaPk : inArea) {
                    int picked = this.random.nextInt(possiblePokemon.size());
                    Pokemon pickedMN = (Pokemon)possiblePokemon.get(picked);
                    areaMap.put(areaPk, pickedMN);
                    possiblePokemon.remove(picked);
                }
                for (Encounter enc : area.encounters) {
                    enc.pokemon = (Pokemon)areaMap.get(enc.pokemon);
                }
            }
        } else if (usePowerLevels) {
            ArrayList<Pokemon> allowedPokes = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
            allowedPokes.removeAll(banned);
            for (EncounterSet area : scrambledEncounters) {
                Set<Pokemon> inArea = this.pokemonInArea(area);
                TreeMap<Pokemon, Pokemon> areaMap = new TreeMap<Pokemon, Pokemon>();
                ArrayList<Pokemon> usedPks = new ArrayList<Pokemon>();
                ArrayList<Pokemon> localAllowed = allowedPokes;
                if (area.bannedPokemon.size() > 0) {
                    localAllowed = new ArrayList<Pokemon>(allowedPokes);
                    localAllowed.removeAll(area.bannedPokemon);
                }
                for (Pokemon areaPk : inArea) {
                    Pokemon picked = this.pickWildPowerLvlReplacement(localAllowed, areaPk, false, usedPks);
                    areaMap.put(areaPk, picked);
                    usedPks.add(picked);
                }
                for (Encounter enc : area.encounters) {
                    enc.pokemon = (Pokemon)areaMap.get(enc.pokemon);
                }
            }
        } else {
            for (EncounterSet area : scrambledEncounters) {
                Set<Pokemon> inArea = this.pokemonInArea(area);
                TreeMap<Pokemon, Pokemon> areaMap = new TreeMap<Pokemon, Pokemon>();
                for (Pokemon areaPk : inArea) {
                    Pokemon picked;
                    Pokemon pokemon = picked = noLegendaries ? this.randomNonLegendaryPokemon() : this.randomPokemon();
                    while (areaMap.containsValue(picked) || banned.contains(picked) || area.bannedPokemon.contains(picked)) {
                        picked = noLegendaries ? this.randomNonLegendaryPokemon() : this.randomPokemon();
                    }
                    areaMap.put(areaPk, picked);
                }
                for (Encounter enc : area.encounters) {
                    enc.pokemon = (Pokemon)areaMap.get(enc.pokemon);
                }
            }
        }
        this.setEncounters(useTimeOfDay, currentEncounters);
    }

    @Override
    public void game1to1Encounters(boolean useTimeOfDay, boolean usePowerLevels, boolean noLegendaries) {
        this.checkPokemonRestrictions();
        TreeMap<Pokemon, Pokemon> translateMap = new TreeMap<Pokemon, Pokemon>();
        List<Pokemon> remainingLeft = this.allPokemonWithoutNull();
        ArrayList<Pokemon> remainingRight = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
        List<Pokemon> banned = this.bannedForWildEncounters();
        for (Pokemon bannedPK : banned) {
            translateMap.put(bannedPK, bannedPK);
            remainingLeft.remove(bannedPK);
            remainingRight.remove(bannedPK);
        }
        while (!remainingLeft.isEmpty()) {
            int pickedLeft;
            if (usePowerLevels) {
                pickedLeft = this.random.nextInt(remainingLeft.size());
                Pokemon pickedLeftP = remainingLeft.remove(pickedLeft);
                Pokemon pickedRightP = null;
                pickedRightP = remainingRight.size() == 1 ? (Pokemon)remainingRight.get(0) : this.pickWildPowerLvlReplacement(remainingRight, pickedLeftP, true, null);
                remainingRight.remove(pickedRightP);
                translateMap.put(pickedLeftP, pickedRightP);
            } else {
                pickedLeft = this.random.nextInt(remainingLeft.size());
                int pickedRight = this.random.nextInt(remainingRight.size());
                Pokemon pickedLeftP = remainingLeft.remove(pickedLeft);
                Pokemon pickedRightP = (Pokemon)remainingRight.get(pickedRight);
                while (pickedLeftP.number == pickedRightP.number && remainingRight.size() != 1) {
                    pickedRight = this.random.nextInt(remainingRight.size());
                    pickedRightP = (Pokemon)remainingRight.get(pickedRight);
                }
                remainingRight.remove(pickedRight);
                translateMap.put(pickedLeftP, pickedRightP);
            }
            if (remainingRight.size() != 0) continue;
            remainingRight.addAll(noLegendaries ? this.noLegendaryList : this.mainPokemonList);
            remainingRight.removeAll(banned);
        }
        List<Pokemon> allPokes = this.allPokemonWithoutNull();
        for (Pokemon poke : allPokes) {
            if (translateMap.containsKey(poke)) continue;
            translateMap.put(poke, poke);
        }
        List<EncounterSet> currentEncounters = this.getEncounters(useTimeOfDay);
        for (EncounterSet area : currentEncounters) {
            for (Encounter enc : area.encounters) {
                enc.pokemon = (Pokemon)translateMap.get(enc.pokemon);
                if (!area.bannedPokemon.contains(enc.pokemon)) continue;
                ArrayList<Pokemon> tempPickable = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
                tempPickable.removeAll(banned);
                tempPickable.removeAll(area.bannedPokemon);
                if (tempPickable.size() == 0) {
                    throw new RandomizationException("ERROR: Couldn't replace a wild Pokemon!");
                }
                if (usePowerLevels) {
                    enc.pokemon = this.pickWildPowerLvlReplacement(tempPickable, enc.pokemon, false, null);
                    continue;
                }
                int picked = this.random.nextInt(tempPickable.size());
                enc.pokemon = (Pokemon)tempPickable.get(picked);
            }
        }
        this.setEncounters(useTimeOfDay, currentEncounters);
    }

    @Override
    public void randomizeTrainerPokes(boolean usePowerLevels, boolean noLegendaries, boolean noEarlyWonderGuard, int levelModifier) {
        this.checkPokemonRestrictions();
        List<Trainer> currentTrainers = this.getTrainers();
        ArrayList<Trainer> scrambledTrainers = new ArrayList<Trainer>(currentTrainers);
        Collections.shuffle(scrambledTrainers, this.random);
        this.cachedReplacementLists = new TreeMap<Type, List<Pokemon>>();
        this.cachedAllList = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
        for (Trainer t : scrambledTrainers) {
            if (t.tag != null && t.tag.equals("IRIVAL")) continue;
            for (TrainerPokemon tp : t.pokemon) {
                boolean wgAllowed = !noEarlyWonderGuard || tp.level >= 20;
                tp.pokemon = this.pickReplacement(tp.pokemon, usePowerLevels, null, noLegendaries, wgAllowed);
                tp.resetMoves = true;
                if (levelModifier == 0) continue;
                tp.level = Math.min(100, (int)Math.round((double)tp.level * (1.0 + (double)levelModifier / 100.0)));
            }
        }
        this.setTrainers(currentTrainers);
    }

    @Override
    public void typeThemeTrainerPokes(boolean usePowerLevels, boolean weightByFrequency, boolean noLegendaries, boolean noEarlyWonderGuard, int levelModifier) {
        this.checkPokemonRestrictions();
        List<Trainer> currentTrainers = this.getTrainers();
        this.cachedReplacementLists = new TreeMap<Type, List<Pokemon>>();
        this.cachedAllList = noLegendaries ? new ArrayList<Pokemon>(this.noLegendaryList) : new ArrayList<Pokemon>(this.mainPokemonList);
        this.typeWeightings = new TreeMap<Type, Integer>();
        this.totalTypeWeighting = 0;
        TreeSet<Trainer> assignedTrainers = new TreeSet<Trainer>();
        TreeMap groups = new TreeMap();
        for (Trainer t : currentTrainers) {
            String group;
            if (t.tag != null && t.tag.equals("IRIVAL")) continue;
            String string = group = t.tag == null ? "" : t.tag;
            if (group.contains("-")) {
                group = group.substring(0, group.indexOf(45));
            }
            if (group.startsWith("GYM") || group.startsWith("ELITE") || group.startsWith("CHAMPION") || group.startsWith("THEMED")) {
                if (!groups.containsKey(group)) {
                    groups.put(group, new ArrayList());
                }
                ((List)groups.get(group)).add(t);
                assignedTrainers.add(t);
                continue;
            }
            if (!group.startsWith("GIO")) continue;
            if (!groups.containsKey("GYM8")) {
                groups.put("GYM8", new ArrayList());
            }
            ((List)groups.get("GYM8")).add(t);
            assignedTrainers.add(t);
        }
        TreeSet<Type> usedGymTypes = new TreeSet<Type>();
        TreeSet<Type> usedEliteTypes = new TreeSet<Type>();
        TreeSet<Type> usedUberTypes = new TreeSet<Type>();
        for (String group : groups.keySet()) {
            List trainersInGroup = (List)groups.get(group);
            Collections.shuffle(trainersInGroup, this.random);
            Type typeForGroup = this.pickType(weightByFrequency, noLegendaries);
            if (group.startsWith("GYM")) {
                while (usedGymTypes.contains((Object)typeForGroup)) {
                    typeForGroup = this.pickType(weightByFrequency, noLegendaries);
                }
                usedGymTypes.add(typeForGroup);
            }
            if (group.startsWith("ELITE")) {
                while (usedEliteTypes.contains((Object)typeForGroup)) {
                    typeForGroup = this.pickType(weightByFrequency, noLegendaries);
                }
                usedEliteTypes.add(typeForGroup);
            }
            if (group.equals("CHAMPION")) {
                usedUberTypes.add(typeForGroup);
            }
            for (Trainer t : trainersInGroup) {
                for (TrainerPokemon tp : t.pokemon) {
                    boolean wgAllowed = !noEarlyWonderGuard || tp.level >= 20;
                    tp.pokemon = this.pickReplacement(tp.pokemon, usePowerLevels, typeForGroup, noLegendaries, wgAllowed);
                    tp.resetMoves = true;
                    if (levelModifier == 0) continue;
                    tp.level = Math.min(100, (int)Math.round((double)tp.level * (1.0 + (double)levelModifier / 100.0)));
                }
            }
        }
        ArrayList<Trainer> scrambledTrainers = new ArrayList<Trainer>(currentTrainers);
        Collections.shuffle(scrambledTrainers, this.random);
        for (Trainer t : scrambledTrainers) {
            if (t.tag != null && t.tag.equals("IRIVAL") || assignedTrainers.contains(t)) continue;
            Type typeForTrainer = this.pickType(weightByFrequency, noLegendaries);
            if (t.tag != null && t.tag.equals("UBER")) {
                while (usedUberTypes.contains((Object)typeForTrainer)) {
                    typeForTrainer = this.pickType(weightByFrequency, noLegendaries);
                }
                usedUberTypes.add(typeForTrainer);
            }
            for (TrainerPokemon tp : t.pokemon) {
                boolean shedAllowed = !noEarlyWonderGuard || tp.level >= 20;
                tp.pokemon = this.pickReplacement(tp.pokemon, usePowerLevels, typeForTrainer, noLegendaries, shedAllowed);
                tp.resetMoves = true;
                if (levelModifier == 0) continue;
                tp.level = Math.min(100, (int)Math.round((double)tp.level * (1.0 + (double)levelModifier / 100.0)));
            }
        }
        this.setTrainers(currentTrainers);
    }

    @Override
    public void rivalCarriesStarter() {
        this.checkPokemonRestrictions();
        List<Trainer> currentTrainers = this.getTrainers();
        this.rivalCarriesStarterUpdate(currentTrainers, "RIVAL", 1);
        this.rivalCarriesStarterUpdate(currentTrainers, "FRIEND", 2);
        this.setTrainers(currentTrainers);
    }

    @Override
    public void forceFullyEvolvedTrainerPokes(int minLevel) {
        this.checkPokemonRestrictions();
        List<Trainer> currentTrainers = this.getTrainers();
        for (Trainer t : currentTrainers) {
            for (TrainerPokemon tp : t.pokemon) {
                Pokemon newPokemon;
                if (tp.level < minLevel || (newPokemon = this.fullyEvolve(tp.pokemon)) == tp.pokemon) continue;
                tp.pokemon = newPokemon;
                tp.resetMoves = true;
            }
        }
        this.setTrainers(currentTrainers);
    }

    @Override
    public void randomizeMovePowers() {
        List<Move> moves = this.getMoves();
        for (Move mv : moves) {
            if (mv == null || mv.internalId == 165 || mv.power < 10) continue;
            mv.power = this.random.nextInt(3) != 2 ? this.random.nextInt(11) * 5 + 50 : this.random.nextInt(27) * 5 + 20;
            for (int i = 0; i < 2; ++i) {
                if (this.random.nextInt(100) != 0) continue;
                mv.power += 50;
            }
            if (mv.hitCount == 1.0) continue;
            mv.power = (int)(Math.round((double)mv.power / mv.hitCount / 5.0) * 5L);
            if (mv.power != 0) continue;
            mv.power = 5;
        }
    }

    @Override
    public void randomizeMovePPs() {
        List<Move> moves = this.getMoves();
        for (Move mv : moves) {
            if (mv == null || mv.internalId == 165) continue;
            if (this.random.nextInt(3) != 2) {
                mv.pp = this.random.nextInt(3) * 5 + 15;
                continue;
            }
            mv.pp = this.random.nextInt(8) * 5 + 5;
        }
    }

    @Override
    public void randomizeMoveAccuracies() {
        List<Move> moves = this.getMoves();
        for (Move mv : moves) {
            if (mv == null || mv.internalId == 165 || !(mv.hitratio >= 5.0)) continue;
            if (mv.hitratio <= 50.0) {
                mv.hitratio = this.random.nextInt(7) * 5 + 20;
                if (this.random.nextInt(10) != 0) continue;
                mv.hitratio = mv.hitratio * 3.0 / 2.0 / 5.0 * 5.0;
                continue;
            }
            if (mv.hitratio < 90.0) {
                mv.hitratio = 100.0;
                while (mv.hitratio > 20.0 && this.random.nextInt(10) >= 2) {
                    mv.hitratio -= 5.0;
                }
                continue;
            }
            mv.hitratio = 100.0;
            while (mv.hitratio > 20.0 && this.random.nextInt(10) >= 4) {
                mv.hitratio -= 5.0;
            }
        }
    }

    @Override
    public void randomizeMoveTypes() {
        List<Move> moves = this.getMoves();
        for (Move mv : moves) {
            if (mv == null || mv.internalId == 165 || mv.type == null) continue;
            mv.type = this.randomType();
        }
    }

    @Override
    public void randomizeMoveCategory() {
        if (!this.hasPhysicalSpecialSplit()) {
            return;
        }
        List<Move> moves = this.getMoves();
        for (Move mv : moves) {
            if (mv == null || mv.internalId == 165 || mv.category == MoveCategory.STATUS || this.random.nextInt(2) != 0) continue;
            mv.category = mv.category == MoveCategory.PHYSICAL ? MoveCategory.SPECIAL : MoveCategory.PHYSICAL;
        }
    }

    @Override
    public void updateMovesToGen5() {
        List<Move> moves = this.getMoves();
        this.updateMoveType(moves, 2, Type.FIGHTING);
        this.updateMoveAccuracy(moves, 13, 100);
        this.updateMoveType(moves, 16, Type.FLYING);
        this.updateMovePower(moves, 17, 60);
        this.updateMoveAccuracy(moves, 18, 100);
        this.updateMovePower(moves, 19, 90);
        this.updateMoveAccuracy(moves, 20, 85);
        this.updateMovePP(moves, 22, 15);
        this.updateMovePP(moves, 26, 10);
        this.updateMovePower(moves, 26, 100);
        this.updateMoveType(moves, 28, Type.GROUND);
        this.updateMovePower(moves, 33, 50);
        this.updateMoveAccuracy(moves, 33, 100);
        this.updateMoveAccuracy(moves, 35, 90);
        this.updateMovePP(moves, 37, 10);
        this.updateMovePower(moves, 37, 120);
        this.updateMovePower(moves, 38, 120);
        this.updateMoveAccuracy(moves, 50, 100);
        this.updateMoveAccuracy(moves, 59, 70);
        this.updateMoveAccuracy(moves, 67, 100);
        this.updateMovePP(moves, 71, 25);
        this.updateMovePP(moves, 72, 15);
        this.updateMovePP(moves, 80, 10);
        this.updateMovePower(moves, 80, 120);
        this.updateMoveAccuracy(moves, 83, 85);
        this.updateMovePower(moves, 83, 35);
        this.updateMoveAccuracy(moves, 88, 90);
        this.updateMovePower(moves, 91, 80);
        this.updateMoveAccuracy(moves, 92, 90);
        this.updateMoveAccuracy(moves, 95, 60);
        this.updateMovePP(moves, 105, 10);
        this.updateMovePower(moves, 120, 200);
        this.updateMoveAccuracy(moves, 128, 85);
        this.updateMovePP(moves, 128, 15);
        this.updateMovePP(moves, 136, 10);
        this.updateMovePower(moves, 136, 130);
        this.updateMoveAccuracy(moves, 137, 90);
        this.updateMoveAccuracy(moves, 139, 80);
        this.updateMoveAccuracy(moves, 148, 100);
        this.updateMoveAccuracy(moves, 152, 90);
        this.updateMovePower(moves, 153, 250);
        if (moves.size() >= 251) {
            this.updateMoveType(moves, 174, Type.GHOST);
            this.updateMoveAccuracy(moves, 178, 100);
            this.updateMoveAccuracy(moves, 184, 100);
            this.updateMovePower(moves, 192, 120);
            this.updateMoveAccuracy(moves, 198, 90);
            this.updateMovePower(moves, 200, 120);
            this.updateMovePP(moves, 200, 10);
            this.updateMovePP(moves, 202, 10);
            this.updateMovePower(moves, 202, 75);
            this.updateMovePower(moves, 210, 20);
            this.updateMovePP(moves, 248, 10);
            this.updateMovePower(moves, 248, 100);
            this.updateMoveAccuracy(moves, 248, 100);
            this.updateMovePower(moves, 249, 40);
            this.updateMovePower(moves, 250, 35);
            this.updateMoveAccuracy(moves, 250, 85);
        }
        if (moves.size() >= 354) {
            this.updateMovePower(moves, 253, 90);
            this.updateMovePP(moves, 254, 20);
            this.updateMovePower(moves, 291, 80);
            this.updateMovePower(moves, 328, 35);
            this.updateMoveAccuracy(moves, 328, 85);
            this.updateMovePower(moves, 331, 25);
            this.updateMovePower(moves, 333, 25);
            this.updateMovePower(moves, 343, 60);
            this.updateMovePower(moves, 348, 90);
            this.updateMoveAccuracy(moves, 350, 90);
            this.updateMovePower(moves, 353, 140);
            this.updateMoveAccuracy(moves, 353, 100);
        }
        if (moves.size() >= 467) {
            this.updateMovePower(moves, 364, 30);
            this.updateMovePower(moves, 387, 140);
            this.updateMovePP(moves, 409, 10);
            this.updateMovePower(moves, 409, 75);
            this.updateMoveAccuracy(moves, 463, 75);
        }
    }

    @Override
    public void updateMovesToGen6() {
        List<Move> moves = this.getMoves();
        this.updateMovePP(moves, 14, 20);
        this.updateMovePP(moves, 22, 25);
        this.updateMovePower(moves, 22, 45);
        this.updateMovePower(moves, 42, 25);
        this.updateMoveAccuracy(moves, 42, 95);
        this.updateMovePower(moves, 53, 90);
        this.updateMovePower(moves, 56, 110);
        this.updateMovePower(moves, 57, 90);
        this.updateMovePower(moves, 58, 90);
        this.updateMovePower(moves, 59, 110);
        this.updateMovePP(moves, 74, 20);
        this.updateMovePower(moves, 85, 90);
        this.updateMovePower(moves, 87, 110);
        this.updateMovePP(moves, 107, 10);
        this.updateMovePP(moves, 112, 20);
        this.updateMovePower(moves, 122, 30);
        this.updateMovePower(moves, 123, 30);
        this.updateMovePower(moves, 126, 110);
        this.updateMovePP(moves, 130, 10);
        this.updateMovePower(moves, 130, 130);
        this.updateMoveAccuracy(moves, 137, 100);
        this.updateMoveAccuracy(moves, 139, 90);
        this.updateMovePower(moves, 145, 40);
        this.updateMoveAccuracy(moves, 149, 100);
        this.updateMovePP(moves, 151, 20);
        this.updateMovePower(moves, 152, 100);
        if (moves.size() >= 251) {
            this.updateMovePP(moves, 168, 25);
            this.updateMovePower(moves, 168, 60);
            this.updateMovePower(moves, 173, 50);
            this.updateMovePower(moves, 210, 40);
            this.updateMovePower(moves, 248, 120);
        }
        if (moves.size() >= 354) {
            this.updateMovePower(moves, 257, 95);
            this.updateMoveAccuracy(moves, 261, 85);
            this.updateMovePower(moves, 265, 70);
            this.updateMovePower(moves, 282, 65);
            this.updateMovePower(moves, 309, 90);
            this.updateMoveAccuracy(moves, 309, 90);
            this.updateMovePower(moves, 314, 60);
            this.updateMovePower(moves, 315, 130);
            this.updateMovePP(moves, 317, 15);
            this.updateMovePower(moves, 317, 60);
            this.updateMoveAccuracy(moves, 317, 95);
            this.updateMovePP(moves, 326, 20);
            this.updateMovePower(moves, 330, 90);
            this.updateMovePP(moves, 343, 25);
        }
        if (moves.size() >= 467) {
            this.updateMovePower(moves, 358, 70);
            this.updateMovePP(moves, 366, 15);
            this.updateMovePower(moves, 372, 60);
            this.updateMoveAccuracy(moves, 375, 100);
            this.updateMovePower(moves, 396, 80);
            this.updateMovePP(moves, 403, 15);
            this.updateMovePower(moves, 406, 85);
            this.updateMovePower(moves, 408, 80);
            this.updateMovePower(moves, 412, 90);
            this.updateMovePower(moves, 434, 130);
            this.updateMovePower(moves, 437, 130);
            this.updateMoveAccuracy(moves, 441, 80);
            this.updateMovePower(moves, 448, 65);
            this.updateMovePower(moves, 463, 100);
        }
        if (moves.size() >= 559) {
            this.updateMovePower(moves, 480, 60);
            this.updateMovePower(moves, 485, 120);
            this.updateMovePower(moves, 490, 65);
            this.updateMovePower(moves, 506, 65);
            this.updateMovePower(moves, 510, 60);
            this.updateMovePower(moves, 518, 80);
            this.updateMovePower(moves, 519, 80);
            this.updateMovePower(moves, 520, 80);
            this.updateMovePower(moves, 522, 50);
            this.updateMovePower(moves, 524, 45);
            this.updateMovePP(moves, 533, 15);
            this.updateMovePower(moves, 542, 110);
            this.updateMovePower(moves, 546, 120);
        }
    }

    @Override
    public void initMoveUpdates() {
        this.moveUpdates = new TreeMap<Integer, boolean[]>();
    }

    @Override
    public void printMoveUpdates() {
        this.log("--Move Updates--");
        List<Move> moves = this.getMoves();
        for (int moveID : this.moveUpdates.keySet()) {
            boolean[] changes = this.moveUpdates.get(moveID);
            Move mv = moves.get(moveID);
            ArrayList<String> nonTypeChanges = new ArrayList<String>();
            if (changes[0]) {
                nonTypeChanges.add(String.format("%d power", mv.power));
            }
            if (changes[1]) {
                nonTypeChanges.add(String.format("%d PP", mv.pp));
            }
            if (changes[2]) {
                nonTypeChanges.add(String.format("%.00f%% accuracy", mv.hitratio));
            }
            String logStr = "Made " + mv.name;
            if (changes[3]) {
                logStr = logStr + " be " + (Object)((Object)mv.type) + "-type";
                if (nonTypeChanges.size() > 0) {
                    logStr = logStr + " and";
                }
            }
            if (nonTypeChanges.size() > 0) {
                logStr = logStr + " have ";
                logStr = nonTypeChanges.size() == 3 ? logStr + (String)nonTypeChanges.get(0) + ", " + (String)nonTypeChanges.get(1) + " and " + (String)nonTypeChanges.get(2) : (nonTypeChanges.size() == 2 ? logStr + (String)nonTypeChanges.get(0) + " and " + (String)nonTypeChanges.get(1) : logStr + (String)nonTypeChanges.get(0));
            }
            this.log(logStr);
        }
        this.logBlankLine();
    }

    @Override
    public void randomizeMovesLearnt(boolean typeThemed, boolean noBroken, boolean forceFourStartingMoves, double goodDamagingProbability) {
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        List<Integer> hms = this.getHMMoves();
        List<Move> allMoves = this.getMoves();
        HashSet<Integer> allBanned = new HashSet<Integer>(noBroken ? this.getGameBreakingMoves() : Collections.EMPTY_SET);
        allBanned.addAll(hms);
        allBanned.addAll(this.getMovesBannedFromLevelup());
        ArrayList<Move> validMoves = new ArrayList<Move>();
        ArrayList<Move> validDamagingMoves = new ArrayList<Move>();
        HashMap validTypeMoves = new HashMap();
        HashMap validTypeDamagingMoves = new HashMap();
        for (Move mv : allMoves) {
            if (mv == null || GlobalConstants.bannedRandomMoves[mv.number] || allBanned.contains(mv.number)) continue;
            validMoves.add(mv);
            if (mv.type != null) {
                if (!validTypeMoves.containsKey((Object)mv.type)) {
                    validTypeMoves.put(mv.type, new ArrayList());
                }
                ((List)validTypeMoves.get((Object)mv.type)).add(mv);
            }
            if (GlobalConstants.bannedForDamagingMove[mv.number] || mv.power < 100 && (mv.power < 50 || !(mv.hitratio >= 90.0))) continue;
            validDamagingMoves.add(mv);
            if (mv.type == null) continue;
            if (!validTypeDamagingMoves.containsKey((Object)mv.type)) {
                validTypeDamagingMoves.put(mv.type, new ArrayList());
            }
            ((List)validTypeDamagingMoves.get((Object)mv.type)).add(mv);
        }
        for (Pokemon pkmn : movesets.keySet()) {
            int lv1index;
            TreeSet<Integer> learnt = new TreeSet<Integer>();
            List<MoveLearnt> moves = movesets.get(pkmn);
            if (forceFourStartingMoves) {
                int lv1count = 0;
                for (MoveLearnt ml : moves) {
                    if (ml.level != 1) continue;
                    ++lv1count;
                }
                if (lv1count < 4) {
                    for (int i = 0; i < 4 - lv1count; ++i) {
                        MoveLearnt fakeLv1 = new MoveLearnt();
                        fakeLv1.level = 1;
                        fakeLv1.move = 0;
                        moves.add(0, fakeLv1);
                    }
                }
            }
            for (lv1index = 0; lv1index < moves.size() && moves.get((int)lv1index).level == 1; ++lv1index) {
            }
            if (lv1index != 0) {
                --lv1index;
            }
            for (int i = 0; i < moves.size(); ++i) {
                boolean attemptDamaging = i == lv1index ? true : this.random.nextDouble() < goodDamagingProbability;
                Type typeOfMove = null;
                if (typeThemed) {
                    double picked = this.random.nextDouble();
                    if (pkmn.primaryType == Type.NORMAL || pkmn.secondaryType == Type.NORMAL) {
                        if (pkmn.secondaryType == null) {
                            if (picked < 0.75) {
                                typeOfMove = Type.NORMAL;
                            }
                        } else {
                            Type otherType = pkmn.primaryType;
                            if (otherType == Type.NORMAL) {
                                otherType = pkmn.secondaryType;
                            }
                            if (picked < 0.3) {
                                typeOfMove = Type.NORMAL;
                            } else if (picked < 0.85) {
                                typeOfMove = otherType;
                            }
                        }
                    } else if (pkmn.secondaryType != null) {
                        if (picked < 0.5) {
                            typeOfMove = pkmn.primaryType;
                        } else if (picked < 0.8) {
                            typeOfMove = pkmn.secondaryType;
                        } else if (picked < 0.85) {
                            typeOfMove = Type.NORMAL;
                        }
                    } else if (picked < 0.6) {
                        typeOfMove = pkmn.primaryType;
                    } else if (picked < 0.8) {
                        typeOfMove = Type.NORMAL;
                    }
                }
                List<Object> pickList = validMoves;
                if (attemptDamaging) {
                    if (typeOfMove != null) {
                        if (validTypeDamagingMoves.containsKey((Object)typeOfMove) && this.checkForUnusedMove((List)validTypeDamagingMoves.get((Object)typeOfMove), learnt)) {
                            pickList = (List)validTypeDamagingMoves.get((Object)typeOfMove);
                        } else if (this.checkForUnusedMove(validDamagingMoves, learnt)) {
                            pickList = validDamagingMoves;
                        }
                    } else if (this.checkForUnusedMove(validDamagingMoves, learnt)) {
                        pickList = validDamagingMoves;
                    }
                } else if (typeOfMove != null && validTypeMoves.containsKey((Object)typeOfMove) && this.checkForUnusedMove((List)validTypeMoves.get((Object)typeOfMove), learnt)) {
                    pickList = (List)validTypeMoves.get((Object)typeOfMove);
                }
                Move mv = (Move)pickList.get(this.random.nextInt(pickList.size()));
                while (learnt.contains(mv.number)) {
                    mv = (Move)pickList.get(this.random.nextInt(pickList.size()));
                }
                moves.get((int)i).move = mv.number;
                if (i == lv1index) {
                    moves.get((int)i).level = 1;
                }
                learnt.add(mv.number);
            }
        }
        this.setMovesLearnt(movesets);
    }

    @Override
    public void orderDamagingMovesByDamage() {
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        List<Move> allMoves = this.getMoves();
        for (Pokemon pkmn : movesets.keySet()) {
            int i;
            List<MoveLearnt> moves = movesets.get(pkmn);
            ArrayList<Integer> damagingMoveIndices = new ArrayList<Integer>();
            ArrayList<Move> damagingMoves = new ArrayList<Move>();
            for (i = 0; i < moves.size(); ++i) {
                Move mv = allMoves.get(moves.get((int)i).move);
                if (mv.power <= 1) continue;
                damagingMoveIndices.add(i);
                damagingMoves.add(mv);
            }
            Collections.shuffle(damagingMoves, this.random);
            Collections.sort(damagingMoves, new Comparator<Move>(){

                @Override
                public int compare(Move m1, Move m2) {
                    if ((double)m1.power * m1.hitCount < (double)m2.power * m2.hitCount) {
                        return -1;
                    }
                    if ((double)m1.power * m1.hitCount > (double)m2.power * m2.hitCount) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (i = 0; i < damagingMoves.size(); ++i) {
                moves.get((int)((Integer)damagingMoveIndices.get((int)i)).intValue()).move = ((Move)damagingMoves.get((int)i)).number;
            }
        }
        this.setMovesLearnt(movesets);
    }

    @Override
    public void metronomeOnlyMode() {
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        MoveLearnt metronomeML = new MoveLearnt();
        metronomeML.level = 1;
        metronomeML.move = 118;
        for (List<MoveLearnt> ms : movesets.values()) {
            if (ms == null || ms.size() <= 0) continue;
            ms.clear();
            ms.add(metronomeML);
        }
        this.setMovesLearnt(movesets);
        List<Trainer> trainers = this.getTrainers();
        for (Trainer t : trainers) {
            for (TrainerPokemon tpk : t.pokemon) {
                tpk.resetMoves = true;
            }
        }
        this.setTrainers(trainers);
        List<Integer> tmMoves = this.getTMMoves();
        for (int i = 0; i < tmMoves.size(); ++i) {
            tmMoves.set(i, 118);
        }
        this.setTMMoves(tmMoves);
        if (this.hasMoveTutors()) {
            List<Integer> mtMoves = this.getMoveTutorMoves();
            for (int i = 0; i < mtMoves.size(); ++i) {
                mtMoves.set(i, 118);
            }
            this.setMoveTutorMoves(mtMoves);
        }
        List<Move> moveData = this.getMoves();
        Move metronome = moveData.get(118);
        metronome.pp = 40;
        List<Integer> hms = this.getHMMoves();
        for (int hm : hms) {
            Move thisHM = moveData.get(hm);
            thisHM.pp = 0;
        }
    }

    @Override
    public void randomizeStaticPokemon(boolean legendForLegend) {
        this.checkPokemonRestrictions();
        List<Pokemon> currentStaticPokemon = this.getStaticPokemon();
        ArrayList<Pokemon> replacements = new ArrayList<Pokemon>();
        List<Pokemon> banned = this.bannedForStaticPokemon();
        if (legendForLegend) {
            ArrayList<Pokemon> legendariesLeft = new ArrayList<Pokemon>(this.onlyLegendaryList);
            ArrayList<Pokemon> nonlegsLeft = new ArrayList<Pokemon>(this.noLegendaryList);
            legendariesLeft.removeAll(banned);
            nonlegsLeft.removeAll(banned);
            for (int i = 0; i < currentStaticPokemon.size(); ++i) {
                Pokemon newPK;
                Pokemon old = currentStaticPokemon.get(i);
                if (old.isLegendary()) {
                    newPK = (Pokemon)legendariesLeft.remove(this.random.nextInt(legendariesLeft.size()));
                    if (legendariesLeft.size() == 0) {
                        legendariesLeft.addAll(this.onlyLegendaryList);
                        legendariesLeft.removeAll(banned);
                    }
                } else {
                    newPK = (Pokemon)nonlegsLeft.remove(this.random.nextInt(nonlegsLeft.size()));
                    if (nonlegsLeft.size() == 0) {
                        nonlegsLeft.addAll(this.noLegendaryList);
                        nonlegsLeft.removeAll(banned);
                    }
                }
                replacements.add(newPK);
            }
        } else {
            ArrayList<Pokemon> pokemonLeft = new ArrayList<Pokemon>(this.mainPokemonList);
            pokemonLeft.removeAll(banned);
            for (int i = 0; i < currentStaticPokemon.size(); ++i) {
                Pokemon newPK = (Pokemon)pokemonLeft.remove(this.random.nextInt(pokemonLeft.size()));
                if (pokemonLeft.size() == 0) {
                    pokemonLeft.addAll(this.mainPokemonList);
                    pokemonLeft.removeAll(banned);
                }
                replacements.add(newPK);
            }
        }
        this.setStaticPokemon(replacements);
    }

    @Override
    public void randomizeTMMoves(boolean noBroken, boolean preserveField, double goodDamagingProbability) {
        int tmCount = this.getTMCount();
        List<Move> allMoves = this.getMoves();
        List<Integer> hms = this.getHMMoves();
        List<Integer> oldTMs = this.getTMMoves();
        ArrayList<Integer> banned = new ArrayList<Integer>(noBroken ? this.getGameBreakingMoves() : Collections.EMPTY_LIST);
        List<Integer> fieldMoves = this.getFieldMoves();
        int preservedFieldMoveCount = 0;
        if (preserveField) {
            ArrayList<Integer> banExistingField = new ArrayList<Integer>(oldTMs);
            banExistingField.retainAll(fieldMoves);
            preservedFieldMoveCount = banExistingField.size();
            banned.addAll(banExistingField);
        }
        ArrayList<Move> usableMoves = new ArrayList<Move>(allMoves);
        usableMoves.remove(0);
        HashSet<Move> unusableMoves = new HashSet<Move>();
        HashSet<Move> unusableDamagingMoves = new HashSet<Move>();
        for (Move mv : usableMoves) {
            if (GlobalConstants.bannedRandomMoves[mv.number] || hms.contains(mv.number) || banned.contains(mv.number)) {
                unusableMoves.add(mv);
                continue;
            }
            if (!GlobalConstants.bannedForDamagingMove[mv.number] && mv.power >= 50) continue;
            unusableDamagingMoves.add(mv);
        }
        usableMoves.removeAll(unusableMoves);
        ArrayList<Move> usableDamagingMoves = new ArrayList<Move>(usableMoves);
        usableDamagingMoves.removeAll(unusableDamagingMoves);
        ArrayList<Integer> pickedMoves = new ArrayList<Integer>();
        for (int i = 0; i < tmCount - preservedFieldMoveCount; ++i) {
            Move chosenMove = this.random.nextDouble() < goodDamagingProbability && usableDamagingMoves.size() > 0 ? (Move)usableDamagingMoves.get(this.random.nextInt(usableDamagingMoves.size())) : (Move)usableMoves.get(this.random.nextInt(usableMoves.size()));
            pickedMoves.add(chosenMove.number);
            usableMoves.remove(chosenMove);
            usableDamagingMoves.remove(chosenMove);
        }
        Collections.shuffle(pickedMoves, this.random);
        int pickedMoveIndex = 0;
        ArrayList<Integer> newTMs = new ArrayList<Integer>();
        for (int i = 0; i < tmCount; ++i) {
            if (preserveField && fieldMoves.contains(oldTMs.get(i))) {
                newTMs.add(oldTMs.get(i));
                continue;
            }
            newTMs.add((Integer)pickedMoves.get(pickedMoveIndex++));
        }
        this.setTMMoves(newTMs);
    }

    @Override
    public void randomizeTMHMCompatibility(boolean preferSameType) {
        List<Integer> requiredEarlyOn = this.getEarlyRequiredHMMoves();
        Map<Pokemon, boolean[]> compat = this.getTMHMCompatibility();
        ArrayList<Integer> tmHMs = new ArrayList<Integer>(this.getTMMoves());
        tmHMs.addAll(this.getHMMoves());
        List<Move> moveData = this.getMoves();
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compat.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            for (int i = 1; i <= tmHMs.size(); ++i) {
                int move = (Integer)tmHMs.get(i - 1);
                Move mv = moveData.get(move);
                double probability = 0.5;
                if (preferSameType) {
                    probability = pkmn.primaryType.equals((Object)mv.type) || pkmn.secondaryType != null && pkmn.secondaryType.equals((Object)mv.type) ? 0.9 : (mv.type != null && mv.type.equals((Object)Type.NORMAL) ? 0.5 : 0.25);
                }
                if (requiredEarlyOn.contains(move)) {
                    probability = Math.min(1.0, probability * 1.8);
                }
                flags[i] = this.random.nextDouble() < probability;
            }
        }
        this.setTMHMCompatibility(compat);
    }

    @Override
    public void fullTMHMCompatibility() {
        Map<Pokemon, boolean[]> compat = this.getTMHMCompatibility();
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compat.entrySet()) {
            boolean[] flags = compatEntry.getValue();
            for (int i = 1; i < flags.length; ++i) {
                flags[i] = true;
            }
        }
        this.setTMHMCompatibility(compat);
    }

    @Override
    public void ensureTMCompatSanity() {
        Map<Pokemon, boolean[]> compat = this.getTMHMCompatibility();
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        List<Integer> tmMoves = this.getTMMoves();
        for (Pokemon pkmn : compat.keySet()) {
            List<MoveLearnt> moveset = movesets.get(pkmn);
            boolean[] pkmnCompat = compat.get(pkmn);
            for (MoveLearnt ml : moveset) {
                if (!tmMoves.contains(ml.move)) continue;
                int tmIndex = tmMoves.indexOf(ml.move);
                pkmnCompat[tmIndex + 1] = true;
            }
        }
        this.setTMHMCompatibility(compat);
    }

    @Override
    public void fullHMCompatibility() {
        Map<Pokemon, boolean[]> compat = this.getTMHMCompatibility();
        int tmCount = this.getTMCount();
        for (boolean[] flags : compat.values()) {
            for (int i = tmCount + 1; i < flags.length; ++i) {
                flags[i] = true;
            }
        }
        this.setTMHMCompatibility(compat);
    }

    @Override
    public void randomizeMoveTutorMoves(boolean noBroken, boolean preserveField, double goodDamagingProbability) {
        if (!this.hasMoveTutors()) {
            return;
        }
        List<Move> allMoves = this.getMoves();
        List<Integer> tms = this.getTMMoves();
        List<Integer> oldMTs = this.getMoveTutorMoves();
        int mtCount = oldMTs.size();
        List<Integer> hms = this.getHMMoves();
        ArrayList<Integer> banned = new ArrayList<Integer>(noBroken ? this.getGameBreakingMoves() : Collections.EMPTY_LIST);
        List<Integer> fieldMoves = this.getFieldMoves();
        int preservedFieldMoveCount = 0;
        if (preserveField) {
            ArrayList<Integer> banExistingField = new ArrayList<Integer>(oldMTs);
            banExistingField.retainAll(fieldMoves);
            preservedFieldMoveCount = banExistingField.size();
            banned.addAll(banExistingField);
        }
        ArrayList<Move> usableMoves = new ArrayList<Move>(allMoves);
        usableMoves.remove(0);
        HashSet<Move> unusableMoves = new HashSet<Move>();
        HashSet<Move> unusableDamagingMoves = new HashSet<Move>();
        for (Move mv : usableMoves) {
            if (GlobalConstants.bannedRandomMoves[mv.number] || tms.contains(mv.number) || hms.contains(mv.number) || banned.contains(mv.number)) {
                unusableMoves.add(mv);
                continue;
            }
            if (!GlobalConstants.bannedForDamagingMove[mv.number] && mv.power >= 50) continue;
            unusableDamagingMoves.add(mv);
        }
        usableMoves.removeAll(unusableMoves);
        ArrayList<Move> usableDamagingMoves = new ArrayList<Move>(usableMoves);
        usableDamagingMoves.removeAll(unusableDamagingMoves);
        ArrayList<Integer> pickedMoves = new ArrayList<Integer>();
        for (int i = 0; i < mtCount - preservedFieldMoveCount; ++i) {
            Move chosenMove = this.random.nextDouble() < goodDamagingProbability && usableDamagingMoves.size() > 0 ? (Move)usableDamagingMoves.get(this.random.nextInt(usableDamagingMoves.size())) : (Move)usableMoves.get(this.random.nextInt(usableMoves.size()));
            pickedMoves.add(chosenMove.number);
            usableMoves.remove(chosenMove);
            usableDamagingMoves.remove(chosenMove);
        }
        Collections.shuffle(pickedMoves, this.random);
        int pickedMoveIndex = 0;
        ArrayList<Integer> newMTs = new ArrayList<Integer>();
        for (int i = 0; i < mtCount; ++i) {
            if (preserveField && fieldMoves.contains(oldMTs.get(i))) {
                newMTs.add(oldMTs.get(i));
                continue;
            }
            newMTs.add((Integer)pickedMoves.get(pickedMoveIndex++));
        }
        this.setMoveTutorMoves(newMTs);
    }

    @Override
    public void randomizeMoveTutorCompatibility(boolean preferSameType) {
        if (!this.hasMoveTutors()) {
            return;
        }
        Map<Pokemon, boolean[]> compat = this.getMoveTutorCompatibility();
        List<Integer> mts = this.getMoveTutorMoves();
        List<Move> moveData = this.getMoves();
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compat.entrySet()) {
            Pokemon pkmn = compatEntry.getKey();
            boolean[] flags = compatEntry.getValue();
            for (int i = 1; i <= mts.size(); ++i) {
                int move = mts.get(i - 1);
                Move mv = moveData.get(move);
                double probability = 0.5;
                if (preferSameType) {
                    probability = pkmn.primaryType.equals((Object)mv.type) || pkmn.secondaryType != null && pkmn.secondaryType.equals((Object)mv.type) ? 0.9 : (mv.type != null && mv.type.equals((Object)Type.NORMAL) ? 0.5 : 0.25);
                }
                flags[i] = this.random.nextDouble() < probability;
            }
        }
        this.setMoveTutorCompatibility(compat);
    }

    @Override
    public void fullMoveTutorCompatibility() {
        if (!this.hasMoveTutors()) {
            return;
        }
        Map<Pokemon, boolean[]> compat = this.getMoveTutorCompatibility();
        for (Map.Entry<Pokemon, boolean[]> compatEntry : compat.entrySet()) {
            boolean[] flags = compatEntry.getValue();
            for (int i = 1; i < flags.length; ++i) {
                flags[i] = true;
            }
        }
        this.setMoveTutorCompatibility(compat);
    }

    @Override
    public void ensureMoveTutorCompatSanity() {
        if (!this.hasMoveTutors()) {
            return;
        }
        Map<Pokemon, boolean[]> compat = this.getMoveTutorCompatibility();
        Map<Pokemon, List<MoveLearnt>> movesets = this.getMovesLearnt();
        List<Integer> mtMoves = this.getMoveTutorMoves();
        for (Pokemon pkmn : compat.keySet()) {
            List<MoveLearnt> moveset = movesets.get(pkmn);
            boolean[] pkmnCompat = compat.get(pkmn);
            for (MoveLearnt ml : moveset) {
                if (!mtMoves.contains(ml.move)) continue;
                int mtIndex = mtMoves.indexOf(ml.move);
                pkmnCompat[mtIndex + 1] = true;
            }
        }
        this.setMoveTutorCompatibility(compat);
    }

    @Override
    public void randomizeTrainerNames(CustomNamesSet customNames) {
        ArrayList<String> namesOfThisLength;
        int len;
        if (!this.canChangeTrainerText()) {
            return;
        }
        List[] allTrainerNames = new List[]{new ArrayList(), new ArrayList()};
        Map[] trainerNamesByLength = new Map[]{new TreeMap(), new TreeMap()};
        for (String trainername : customNames.getTrainerNames()) {
            len = this.internalStringLength(trainername);
            if (len > 10) continue;
            allTrainerNames[0].add(trainername);
            if (trainerNamesByLength[0].containsKey(len)) {
                ((List)trainerNamesByLength[0].get(len)).add(trainername);
                continue;
            }
            namesOfThisLength = new ArrayList<String>();
            namesOfThisLength.add(trainername);
            trainerNamesByLength[0].put(len, namesOfThisLength);
        }
        for (String trainername : customNames.getDoublesTrainerNames()) {
            len = this.internalStringLength(trainername);
            if (len > 10) continue;
            allTrainerNames[1].add(trainername);
            if (trainerNamesByLength[1].containsKey(len)) {
                ((List)trainerNamesByLength[1].get(len)).add(trainername);
                continue;
            }
            namesOfThisLength = new ArrayList();
            namesOfThisLength.add(trainername);
            trainerNamesByLength[1].put(len, namesOfThisLength);
        }
        List<String> currentTrainerNames = this.getTrainerNames();
        if (currentTrainerNames.size() == 0) {
            return;
        }
        RomHandler.TrainerNameMode mode = this.trainerNameMode();
        int maxLength = this.maxTrainerNameLength();
        int totalMaxLength = this.maxSumOfTrainerNameLengths();
        boolean success = false;
        int tries = 0;
        HashMap<String, String> translation = new HashMap<String, String>();
        ArrayList<String> newTrainerNames = new ArrayList<String>();
        List<Integer> tcNameLengths = this.getTCNameLengthsByTrainer();
        block2: while (!success && tries < 10000) {
            success = true;
            translation.clear();
            newTrainerNames.clear();
            int totalLength = 0;
            int tnIndex = -1;
            for (String trainerName : currentTrainerNames) {
                ++tnIndex;
                if (translation.containsKey(trainerName) && !trainerName.equalsIgnoreCase("GRUNT") && !trainerName.equalsIgnoreCase("EXECUTIVE")) {
                    newTrainerNames.add((String)translation.get(trainerName));
                    totalLength += this.internalStringLength((String)translation.get(trainerName));
                } else {
                    int idx = trainerName.contains("&") ? 1 : 0;
                    List pickFrom = allTrainerNames[idx];
                    int intStrLen = this.internalStringLength(trainerName);
                    if (mode == RomHandler.TrainerNameMode.SAME_LENGTH) {
                        pickFrom = (List)trainerNamesByLength[idx].get(intStrLen);
                    }
                    String changeTo = trainerName;
                    int ctl = intStrLen;
                    if (pickFrom != null && pickFrom.size() > 0 && intStrLen > 1) {
                        int innerTries = 0;
                        changeTo = (String)pickFrom.get(this.random.nextInt(pickFrom.size()));
                        ctl = this.internalStringLength(changeTo);
                        while (mode == RomHandler.TrainerNameMode.MAX_LENGTH && ctl > maxLength || mode == RomHandler.TrainerNameMode.MAX_LENGTH_WITH_CLASS && ctl + tcNameLengths.get(tnIndex) > maxLength) {
                            if (++innerTries == 100) {
                                changeTo = trainerName;
                                ctl = intStrLen;
                                break;
                            }
                            changeTo = (String)pickFrom.get(this.random.nextInt(pickFrom.size()));
                            ctl = this.internalStringLength(changeTo);
                        }
                    }
                    translation.put(trainerName, changeTo);
                    newTrainerNames.add(changeTo);
                    totalLength += ctl;
                }
                if (totalLength <= totalMaxLength) continue;
                success = false;
                ++tries;
                continue block2;
            }
        }
        if (!success) {
            throw new RandomizationException("Could not randomize trainer names in a reasonable amount of attempts.\nPlease add some shorter names to your custom trainer names.");
        }
        this.setTrainerNames(newTrainerNames);
    }

    @Override
    public void randomizeTrainerClassNames(CustomNamesSet customNames) {
        ArrayList<String> namesOfThisLength;
        int len;
        if (!this.canChangeTrainerText()) {
            return;
        }
        List[] allTrainerClasses = new List[]{new ArrayList(), new ArrayList()};
        Map[] trainerClassesByLength = new Map[]{new HashMap(), new HashMap()};
        for (String trainerClassName : customNames.getTrainerClasses()) {
            allTrainerClasses[0].add(trainerClassName);
            len = this.internalStringLength(trainerClassName);
            if (trainerClassesByLength[0].containsKey(len)) {
                ((List)trainerClassesByLength[0].get(len)).add(trainerClassName);
                continue;
            }
            namesOfThisLength = new ArrayList<String>();
            namesOfThisLength.add(trainerClassName);
            trainerClassesByLength[0].put(len, namesOfThisLength);
        }
        for (String trainerClassName : customNames.getDoublesTrainerClasses()) {
            allTrainerClasses[1].add(trainerClassName);
            len = this.internalStringLength(trainerClassName);
            if (trainerClassesByLength[1].containsKey(len)) {
                ((List)trainerClassesByLength[1].get(len)).add(trainerClassName);
                continue;
            }
            namesOfThisLength = new ArrayList();
            namesOfThisLength.add(trainerClassName);
            trainerClassesByLength[1].put(len, namesOfThisLength);
        }
        List<String> currentClassNames = this.getTrainerClassNames();
        boolean mustBeSameLength = this.fixedTrainerClassNamesLength();
        int maxLength = this.maxTrainerClassNameLength();
        HashMap<String, String> translation = new HashMap<String, String>();
        ArrayList<String> newClassNames = new ArrayList<String>();
        int numTrainerClasses = currentClassNames.size();
        List<Integer> doublesClasses = this.getDoublesTrainerClasses();
        for (int i = 0; i < numTrainerClasses; ++i) {
            String trainerClassName = currentClassNames.get(i);
            if (translation.containsKey(trainerClassName)) {
                newClassNames.add((String)translation.get(trainerClassName));
                continue;
            }
            int idx = doublesClasses.contains(i) ? 1 : 0;
            List pickFrom = allTrainerClasses[idx];
            int intStrLen = this.internalStringLength(trainerClassName);
            if (mustBeSameLength) {
                pickFrom = (List)trainerClassesByLength[idx].get(intStrLen);
            }
            String changeTo = trainerClassName;
            if (pickFrom != null && pickFrom.size() > 0) {
                changeTo = (String)pickFrom.get(this.random.nextInt(pickFrom.size()));
                while (changeTo.length() > maxLength) {
                    changeTo = (String)pickFrom.get(this.random.nextInt(pickFrom.size()));
                }
            }
            translation.put(trainerClassName, changeTo);
            newClassNames.add(changeTo);
        }
        this.setTrainerClassNames(newClassNames);
    }

    @Override
    public void randomizeWildHeldItems(boolean banBadItems) {
        List<Pokemon> pokemon = this.allPokemonWithoutNull();
        ItemList possibleItems = banBadItems ? this.getNonBadItems() : this.getAllowedItems();
        for (Pokemon pk : pokemon) {
            double decision;
            boolean canHaveDarkGrass;
            if (pk.guaranteedHeldItem == -1 && pk.commonHeldItem == -1 && pk.rareHeldItem == -1 && pk.darkGrassHeldItem == -1) {
                return;
            }
            boolean bl = canHaveDarkGrass = pk.darkGrassHeldItem != -1;
            if (pk.guaranteedHeldItem != -1) {
                if (pk.guaranteedHeldItem > 0) {
                    decision = this.random.nextDouble();
                    if (decision < 0.9) {
                        canHaveDarkGrass = false;
                        pk.guaranteedHeldItem = possibleItems.randomItem(this.random);
                    } else {
                        pk.guaranteedHeldItem = 0;
                        pk.commonHeldItem = possibleItems.randomItem(this.random);
                        pk.rareHeldItem = possibleItems.randomItem(this.random);
                        while (pk.rareHeldItem == pk.commonHeldItem) {
                            pk.rareHeldItem = possibleItems.randomItem(this.random);
                        }
                    }
                } else {
                    decision = this.random.nextDouble();
                    if (decision < 0.5) {
                        pk.commonHeldItem = 0;
                        pk.rareHeldItem = 0;
                    } else if (decision < 0.65) {
                        pk.commonHeldItem = 0;
                        pk.rareHeldItem = possibleItems.randomItem(this.random);
                    } else if (decision < 0.8) {
                        pk.commonHeldItem = possibleItems.randomItem(this.random);
                        pk.rareHeldItem = 0;
                    } else if (decision < 0.95) {
                        pk.commonHeldItem = possibleItems.randomItem(this.random);
                        pk.rareHeldItem = possibleItems.randomItem(this.random);
                        while (pk.rareHeldItem == pk.commonHeldItem) {
                            pk.rareHeldItem = possibleItems.randomItem(this.random);
                        }
                    } else {
                        canHaveDarkGrass = false;
                        pk.guaranteedHeldItem = possibleItems.randomItem(this.random);
                        pk.commonHeldItem = 0;
                        pk.rareHeldItem = 0;
                    }
                }
            } else {
                decision = this.random.nextDouble();
                if (decision < 0.5) {
                    pk.commonHeldItem = 0;
                    pk.rareHeldItem = 0;
                } else if (decision < 0.65) {
                    pk.commonHeldItem = 0;
                    pk.rareHeldItem = possibleItems.randomItem(this.random);
                } else if (decision < 0.8) {
                    pk.commonHeldItem = possibleItems.randomItem(this.random);
                    pk.rareHeldItem = 0;
                } else {
                    pk.commonHeldItem = possibleItems.randomItem(this.random);
                    pk.rareHeldItem = possibleItems.randomItem(this.random);
                    while (pk.rareHeldItem == pk.commonHeldItem) {
                        pk.rareHeldItem = possibleItems.randomItem(this.random);
                    }
                }
            }
            if (canHaveDarkGrass) {
                double dgDecision = this.random.nextDouble();
                if (dgDecision < 0.5) {
                    pk.darkGrassHeldItem = possibleItems.randomItem(this.random);
                    continue;
                }
                pk.darkGrassHeldItem = 0;
                continue;
            }
            if (pk.darkGrassHeldItem == -1) continue;
            pk.darkGrassHeldItem = 0;
        }
    }

    @Override
    public void randomizeStarterHeldItems(boolean banBadItems) {
        List<Integer> oldHeldItems = this.getStarterHeldItems();
        ArrayList<Integer> newHeldItems = new ArrayList<Integer>();
        ItemList possibleItems = banBadItems ? this.getNonBadItems() : this.getAllowedItems();
        for (int i = 0; i < oldHeldItems.size(); ++i) {
            newHeldItems.add(possibleItems.randomItem(this.random));
        }
        this.setStarterHeldItems(newHeldItems);
    }

    @Override
    public void shuffleFieldItems() {
        List<Integer> currentItems = this.getRegularFieldItems();
        List<Integer> currentTMs = this.getCurrentFieldTMs();
        Collections.shuffle(currentItems, this.random);
        Collections.shuffle(currentTMs, this.random);
        this.setRegularFieldItems(currentItems);
        this.setFieldTMs(currentTMs);
    }

    @Override
    public void randomizeFieldItems(boolean banBadItems) {
        int i;
        ItemList possibleItems = banBadItems ? this.getNonBadItems() : this.getAllowedItems();
        List<Integer> currentItems = this.getRegularFieldItems();
        List<Integer> currentTMs = this.getCurrentFieldTMs();
        List<Integer> requiredTMs = this.getRequiredFieldTMs();
        int fieldItemCount = currentItems.size();
        int fieldTMCount = currentTMs.size();
        int reqTMCount = requiredTMs.size();
        int totalTMCount = this.getTMCount();
        ArrayList<Integer> newItems = new ArrayList<Integer>();
        ArrayList<Integer> newTMs = new ArrayList<Integer>();
        for (i = 0; i < fieldItemCount; ++i) {
            newItems.add(possibleItems.randomNonTM(this.random));
        }
        newTMs.addAll(requiredTMs);
        for (i = reqTMCount; i < fieldTMCount; ++i) {
            int tm;
            while (newTMs.contains(tm = this.random.nextInt(totalTMCount) + 1)) {
            }
            newTMs.add(tm);
        }
        Collections.shuffle(newItems, this.random);
        Collections.shuffle(newTMs, this.random);
        this.setRegularFieldItems(newItems);
        this.setFieldTMs(newTMs);
    }

    @Override
    public void randomizeIngameTrades(boolean randomizeRequest, boolean randomNickname, boolean randomOT, boolean randomStats, boolean randomItem, CustomNamesSet customNames) {
        this.checkPokemonRestrictions();
        ArrayList<String> trainerNames = new ArrayList<String>();
        if (randomOT) {
            int maxOT = this.maxTradeOTNameLength();
            for (String string : customNames.getTrainerNames()) {
                int len = this.internalStringLength(string);
                if (len > maxOT || trainerNames.contains(string)) continue;
                trainerNames.add(string);
            }
        }
        ArrayList<String> nicknames = new ArrayList<String>();
        if (randomNickname) {
            int maxNN = this.maxTradeNicknameLength();
            for (String nickname : customNames.getPokemonNicknames()) {
                int len = this.internalStringLength(nickname);
                if (len > maxNN || nicknames.contains(nickname)) continue;
                nicknames.add(nickname);
            }
        }
        List<IngameTrade> trades = this.getIngameTrades();
        ArrayList<Pokemon> arrayList = new ArrayList<Pokemon>();
        ArrayList<Pokemon> usedGivens = new ArrayList<Pokemon>();
        ArrayList<String> usedOTs = new ArrayList<String>();
        ArrayList<String> usedNicknames = new ArrayList<String>();
        ItemList possibleItems = this.getAllowedItems();
        int nickCount = nicknames.size();
        int trnameCount = trainerNames.size();
        for (IngameTrade trade : trades) {
            Pokemon oldgiven = trade.givenPokemon;
            Pokemon given = this.randomPokemon();
            while (usedGivens.contains(given)) {
                given = this.randomPokemon();
            }
            usedGivens.add(given);
            trade.givenPokemon = given;
            if (oldgiven == trade.requestedPokemon) {
                trade.requestedPokemon = given;
            } else if (randomizeRequest) {
                Pokemon request = this.randomPokemon();
                while (arrayList.contains(request) || request == given) {
                    request = this.randomPokemon();
                }
                arrayList.add(request);
                trade.requestedPokemon = request;
            }
            if (randomNickname && nickCount > usedNicknames.size()) {
                String nickname = (String)nicknames.get(this.random.nextInt(nickCount));
                while (usedNicknames.contains(nickname)) {
                    nickname = (String)nicknames.get(this.random.nextInt(nickCount));
                }
                usedNicknames.add(nickname);
                trade.nickname = nickname;
            } else if (trade.nickname.equalsIgnoreCase(oldgiven.name)) {
                trade.nickname = trade.givenPokemon.name;
            }
            if (randomOT && trnameCount > usedOTs.size()) {
                String ot = (String)trainerNames.get(this.random.nextInt(trnameCount));
                while (usedOTs.contains(ot)) {
                    ot = (String)trainerNames.get(this.random.nextInt(trnameCount));
                }
                usedOTs.add(ot);
                trade.otName = ot;
                trade.otId = this.random.nextInt(65536);
            }
            if (randomStats) {
                int maxIV = this.hasDVs() ? 16 : 32;
                for (int i = 0; i < trade.ivs.length; ++i) {
                    trade.ivs[i] = this.random.nextInt(maxIV);
                }
            }
            if (!randomItem) continue;
            trade.item = possibleItems.randomItem(this.random);
        }
        this.setIngameTrades(trades);
    }

    @Override
    public void condenseLevelEvolutions(int maxLevel, int maxIntermediateLevel) {
        List<Pokemon> allPokemon = this.getPokemon();
        TreeSet<Evolution> changedEvos = new TreeSet<Evolution>();
        for (Pokemon pk : allPokemon) {
            if (pk == null) continue;
            for (Evolution checkEvo : pk.evolutionsFrom) {
                if (!checkEvo.type.usesLevel()) continue;
                if (checkEvo.extraInfo > maxLevel) {
                    checkEvo.extraInfo = maxLevel;
                    changedEvos.add(checkEvo);
                }
                for (Evolution otherEvo : pk.evolutionsTo) {
                    if (!otherEvo.type.usesLevel() || otherEvo.extraInfo <= maxIntermediateLevel) continue;
                    otherEvo.extraInfo = maxIntermediateLevel;
                    changedEvos.add(otherEvo);
                }
            }
        }
        this.log("--Condensed Level Evolutions--");
        for (Evolution evol : changedEvos) {
            this.log(String.format("%s now evolves into %s at minimum level %d", evol.from.name, evol.to.name, evol.extraInfo));
        }
        this.logBlankLine();
    }

    @Override
    public void randomizeEvolutions(boolean similarStrength, boolean sameType, boolean limitToThreeStages, boolean forceChange) {
        this.checkPokemonRestrictions();
        ArrayList<Pokemon> pokemonPool = new ArrayList<Pokemon>(this.mainPokemonList);
        int stageLimit = limitToThreeStages ? 3 : 10;
        HashMap<Pokemon, ArrayList<Evolution>> originalEvos = new HashMap<Pokemon, ArrayList<Evolution>>();
        for (Pokemon pk : pokemonPool) {
            originalEvos.put(pk, new ArrayList<Evolution>(pk.evolutionsFrom));
        }
        HashSet<EvolutionPair> newEvoPairs = new HashSet<EvolutionPair>();
        HashSet<EvolutionPair> oldEvoPairs = new HashSet<EvolutionPair>();
        if (forceChange) {
            for (Pokemon pk : pokemonPool) {
                for (Evolution ev : pk.evolutionsFrom) {
                    oldEvoPairs.add(new EvolutionPair(ev.from, ev.to));
                }
            }
        }
        ArrayList<Pokemon> replacements = new ArrayList<Pokemon>();
        for (int loops = 0; loops < 1; ++loops) {
            boolean hadError = false;
            for (Pokemon pk : pokemonPool) {
                pk.evolutionsFrom.clear();
                pk.evolutionsTo.clear();
            }
            newEvoPairs.clear();
            Collections.shuffle(pokemonPool, this.random);
            for (Pokemon fromPK : pokemonPool) {
                List oldEvos = (List)originalEvos.get(fromPK);
                for (Evolution ev : oldEvos) {
                    replacements.clear();
                    for (Pokemon pokemon : this.mainPokemonList) {
                        EvolutionPair ep;
                        if (pokemon == fromPK || pokemon.growthCurve != fromPK.growthCurve || newEvoPairs.contains(ep = new EvolutionPair(fromPK, pokemon)) || forceChange && oldEvoPairs.contains(ep) || this.evoCycleCheck(fromPK, pokemon)) continue;
                        Evolution tempEvo = new Evolution(fromPK, pokemon, false, EvolutionType.NONE, 0);
                        fromPK.evolutionsFrom.add(tempEvo);
                        pokemon.evolutionsTo.add(tempEvo);
                        boolean exceededLimit = false;
                        Set<Pokemon> related = this.relatedPokemon(fromPK);
                        for (Pokemon pk2 : related) {
                            int numPreEvos = this.numPreEvolutions(pk2, stageLimit);
                            if (numPreEvos >= stageLimit) {
                                exceededLimit = true;
                                break;
                            }
                            if (numPreEvos != stageLimit - 1 || pk2.evolutionsFrom.size() != 0 || ((List)originalEvos.get(pk2)).size() <= 0) continue;
                            exceededLimit = true;
                            break;
                        }
                        fromPK.evolutionsFrom.remove(tempEvo);
                        pokemon.evolutionsTo.remove(tempEvo);
                        if (exceededLimit) continue;
                        replacements.add(pokemon);
                    }
                    if (replacements.size() == 0) {
                        hadError = true;
                        break;
                    }
                    if (replacements.size() > 1 && sameType) {
                        HashSet<Pokemon> includeType = new HashSet<Pokemon>();
                        for (Pokemon pk2 : replacements) {
                            if (!(pk2.primaryType == fromPK.primaryType || fromPK.secondaryType != null && pk2.primaryType == fromPK.secondaryType || pk2.secondaryType != null && pk2.secondaryType == fromPK.primaryType) && (fromPK.secondaryType == null || pk2.secondaryType == null || pk2.secondaryType != fromPK.secondaryType)) continue;
                            includeType.add(pk2);
                        }
                        if (includeType.size() != 0) {
                            replacements.retainAll(includeType);
                        }
                    }
                    Pokemon picked = null;
                    picked = replacements.size() == 1 ? (Pokemon)replacements.get(0) : (similarStrength ? this.pickEvoPowerLvlReplacement(replacements, ev.to) : (Pokemon)replacements.get(this.random.nextInt(replacements.size())));
                    Evolution evolution = new Evolution(fromPK, picked, ev.carryStats, ev.type, ev.extraInfo);
                    fromPK.evolutionsFrom.add(evolution);
                    picked.evolutionsTo.add(evolution);
                    newEvoPairs.add(new EvolutionPair(fromPK, picked));
                }
                if (!hadError) continue;
                break;
            }
            if (hadError) continue;
            return;
        }
        throw new RandomizationException("Not able to randomize evolutions in a sane amount of retries.");
    }

    @Override
    public void minimumCatchRate(int rateNonLegendary, int rateLegendary) {
        List<Pokemon> pokes = this.getPokemon();
        for (Pokemon pkmn : pokes) {
            if (pkmn == null) continue;
            int minCatchRate = pkmn.isLegendary() ? rateLegendary : rateNonLegendary;
            pkmn.catchRate = Math.max(pkmn.catchRate, minCatchRate);
        }
    }

    @Override
    public void standardizeEXPCurves() {
        List<Pokemon> pokes = this.getPokemon();
        for (Pokemon pkmn : pokes) {
            if (pkmn == null) continue;
            pkmn.growthCurve = pkmn.isLegendary() ? ExpCurve.SLOW : ExpCurve.MEDIUM_FAST;
        }
    }

    private void updateMovePower(List<Move> moves, int moveNum, int power) {
        Move mv = moves.get(moveNum);
        if (mv.power != power) {
            mv.power = power;
            this.addMoveUpdate(moveNum, 0);
        }
    }

    private void updateMovePP(List<Move> moves, int moveNum, int pp) {
        Move mv = moves.get(moveNum);
        if (mv.pp != pp) {
            mv.pp = pp;
            this.addMoveUpdate(moveNum, 1);
        }
    }

    private void updateMoveAccuracy(List<Move> moves, int moveNum, int accuracy) {
        Move mv = moves.get(moveNum);
        if (Math.abs(mv.hitratio - (double)accuracy) >= 1.0) {
            mv.hitratio = accuracy;
            this.addMoveUpdate(moveNum, 2);
        }
    }

    private void updateMoveType(List<Move> moves, int moveNum, Type type) {
        Move mv = moves.get(moveNum);
        if (mv.type != type) {
            mv.type = type;
            this.addMoveUpdate(moveNum, 3);
        }
    }

    private void addMoveUpdate(int moveNum, int updateType) {
        if (!this.moveUpdates.containsKey(moveNum)) {
            boolean[] updateField = new boolean[4];
            updateField[updateType] = true;
            this.moveUpdates.put(moveNum, updateField);
        } else {
            this.moveUpdates.get((Object)Integer.valueOf((int)moveNum))[updateType] = true;
        }
    }

    private Pokemon pickEvoPowerLvlReplacement(List<Pokemon> pokemonPool, Pokemon current) {
        int currentBST = current.bstForPowerLevels();
        int minTarget = currentBST - currentBST / 10;
        int maxTarget = currentBST + currentBST / 10;
        ArrayList<Pokemon> canPick = new ArrayList<Pokemon>();
        for (int expandRounds = 0; canPick.isEmpty() || canPick.size() < 3 && expandRounds < 3; ++expandRounds) {
            for (Pokemon pk : pokemonPool) {
                if (pk.bstForPowerLevels() < minTarget || pk.bstForPowerLevels() > maxTarget || canPick.contains(pk)) continue;
                canPick.add(pk);
            }
            minTarget -= currentBST / 20;
            maxTarget += currentBST / 20;
        }
        return (Pokemon)canPick.get(this.random.nextInt(canPick.size()));
    }

    private boolean evoCycleCheck(Pokemon from, Pokemon to) {
        Evolution tempEvo = new Evolution(from, to, false, EvolutionType.NONE, 0);
        from.evolutionsFrom.add(tempEvo);
        HashSet<Pokemon> visited = new HashSet<Pokemon>();
        HashSet<Pokemon> recStack = new HashSet<Pokemon>();
        boolean recur = this.isCyclic(from, visited, recStack);
        from.evolutionsFrom.remove(tempEvo);
        return recur;
    }

    private boolean isCyclic(Pokemon pk, Set<Pokemon> visited, Set<Pokemon> recStack) {
        if (!visited.contains(pk)) {
            visited.add(pk);
            recStack.add(pk);
            for (Evolution ev : pk.evolutionsFrom) {
                if (!visited.contains(ev.to) && this.isCyclic(ev.to, visited, recStack)) {
                    return true;
                }
                if (!recStack.contains(ev.to)) continue;
                return true;
            }
        }
        recStack.remove(pk);
        return false;
    }

    private void copyUpEvolutionsHelper(BasePokemonAction bpAction, EvolvedPokemonAction epAction) {
        List<Pokemon> allPokes = this.getPokemon();
        for (Pokemon pk : allPokes) {
            if (pk == null) continue;
            pk.temporaryFlag = false;
        }
        Set<Pokemon> dontCopyPokes = RomFunctions.getBasicOrNoCopyPokemon(this);
        Set<Pokemon> middleEvos = RomFunctions.getMiddleEvolutions(this);
        for (Pokemon pk : dontCopyPokes) {
            bpAction.applyTo(pk);
            pk.temporaryFlag = true;
        }
        for (Pokemon pk : allPokes) {
            if (pk == null || pk.temporaryFlag) continue;
            Stack<Evolution> currentStack = new Stack<Evolution>();
            Evolution ev = pk.evolutionsTo.get(0);
            while (!ev.from.temporaryFlag) {
                currentStack.push(ev);
                ev = ev.from.evolutionsTo.get(0);
            }
            epAction.applyTo(ev.from, ev.to, !middleEvos.contains(ev.to));
            ev.to.temporaryFlag = true;
            while (!currentStack.isEmpty()) {
                ev = (Evolution)currentStack.pop();
                epAction.applyTo(ev.from, ev.to, !middleEvos.contains(ev.to));
                ev.to.temporaryFlag = true;
            }
        }
    }

    private boolean checkForUnusedMove(List<Move> potentialList, Set<Integer> alreadyUsed) {
        for (Move mv : potentialList) {
            if (alreadyUsed.contains(mv.number)) continue;
            return true;
        }
        return false;
    }

    private List<Pokemon> pokemonOfType(Type type, boolean noLegendaries) {
        ArrayList<Pokemon> typedPokes = new ArrayList<Pokemon>();
        for (Pokemon pk : this.mainPokemonList) {
            if (pk == null || noLegendaries && pk.isLegendary() || pk.primaryType != type && pk.secondaryType != type) continue;
            typedPokes.add(pk);
        }
        return typedPokes;
    }

    private List<Pokemon> allPokemonWithoutNull() {
        ArrayList<Pokemon> allPokes = new ArrayList<Pokemon>(this.getPokemon());
        allPokes.remove(0);
        return allPokes;
    }

    private Set<Pokemon> pokemonInArea(EncounterSet area) {
        TreeSet<Pokemon> inArea = new TreeSet<Pokemon>();
        for (Encounter enc : area.encounters) {
            inArea.add(enc.pokemon);
        }
        return inArea;
    }

    private Type pickType(boolean weightByFrequency, boolean noLegendaries) {
        if (this.totalTypeWeighting == 0) {
            for (Type t : Type.values()) {
                if (!this.typeInGame(t)) continue;
                int pkWithTyping = this.pokemonOfType(t, noLegendaries).size();
                this.typeWeightings.put(t, pkWithTyping);
                this.totalTypeWeighting += pkWithTyping;
            }
        }
        if (weightByFrequency) {
            int typePick = this.random.nextInt(this.totalTypeWeighting);
            int typePos = 0;
            for (Type t : this.typeWeightings.keySet()) {
                int weight = this.typeWeightings.get((Object)t);
                if (typePos + weight > typePick) {
                    return t;
                }
                typePos += weight;
            }
            return null;
        }
        return this.randomType();
    }

    private void rivalCarriesStarterUpdate(List<Trainer> currentTrainers, String prefix, int pokemonOffset) {
        block23: {
            List<Pokemon> starters;
            int highestRivalNum;
            block21: {
                int j;
                int timesEvolves;
                Pokemon rivalStarter;
                block24: {
                    int j2;
                    block22: {
                        int j3;
                        highestRivalNum = 0;
                        for (Trainer t : currentTrainers) {
                            if (t.tag == null || !t.tag.startsWith(prefix)) continue;
                            highestRivalNum = Math.max(highestRivalNum, Integer.parseInt(t.tag.substring(prefix.length(), t.tag.indexOf(45))));
                        }
                        if (highestRivalNum == 0) {
                            return;
                        }
                        starters = this.getStarters();
                        if (!this.isYellow()) break block21;
                        rivalStarter = starters.get(1);
                        timesEvolves = this.numEvolutions(rivalStarter, 2);
                        if (timesEvolves != 0) break block22;
                        for (j3 = 1; j3 <= 3; ++j3) {
                            this.changeStarterWithTag(currentTrainers, prefix + j3 + "-0", rivalStarter);
                        }
                        for (j3 = 4; j3 <= 7; ++j3) {
                            for (int i = 0; i < 3; ++i) {
                                this.changeStarterWithTag(currentTrainers, prefix + j3 + "-" + i, rivalStarter);
                            }
                        }
                        break block23;
                    }
                    if (timesEvolves != 1) break block24;
                    for (j2 = 1; j2 <= 3; ++j2) {
                        this.changeStarterWithTag(currentTrainers, prefix + j2 + "-0", rivalStarter);
                    }
                    rivalStarter = this.pickRandomEvolutionOf(rivalStarter, false);
                    for (j2 = 4; j2 <= 7; ++j2) {
                        for (int i = 0; i < 3; ++i) {
                            this.changeStarterWithTag(currentTrainers, prefix + j2 + "-" + i, rivalStarter);
                        }
                    }
                    break block23;
                }
                if (timesEvolves != 2) break block23;
                for (j = 1; j <= 2; ++j) {
                    this.changeStarterWithTag(currentTrainers, prefix + j + "-" + 0, rivalStarter);
                }
                rivalStarter = this.pickRandomEvolutionOf(rivalStarter, true);
                this.changeStarterWithTag(currentTrainers, prefix + "3-0", rivalStarter);
                for (int i = 0; i < 3; ++i) {
                    this.changeStarterWithTag(currentTrainers, prefix + "4-" + i, rivalStarter);
                }
                rivalStarter = this.pickRandomEvolutionOf(rivalStarter, false);
                for (j = 5; j <= 7; ++j) {
                    for (int i = 0; i < 3; ++i) {
                        this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, rivalStarter);
                    }
                }
                break block23;
            }
            for (int i = 0; i < 3; ++i) {
                int j;
                int starterToUse = (i + pokemonOffset) % 3;
                Pokemon thisStarter = starters.get(starterToUse);
                int timesEvolves = this.numEvolutions(thisStarter, 2);
                if (timesEvolves == 0) {
                    for (j = 1; j <= highestRivalNum; ++j) {
                        this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, thisStarter);
                    }
                    continue;
                }
                if (timesEvolves == 1) {
                    for (j = 1; j <= highestRivalNum / 2 && this.getLevelOfStarter(currentTrainers, prefix + j + "-" + i) < 30; ++j) {
                        this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, thisStarter);
                    }
                    thisStarter = this.pickRandomEvolutionOf(thisStarter, false);
                    while (j <= highestRivalNum) {
                        this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, thisStarter);
                        ++j;
                    }
                    continue;
                }
                if (timesEvolves != 2) continue;
                for (j = 1; j <= highestRivalNum && this.getLevelOfStarter(currentTrainers, prefix + j + "-" + i) < 16; ++j) {
                    this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, thisStarter);
                }
                thisStarter = this.pickRandomEvolutionOf(thisStarter, true);
                while (j <= highestRivalNum && this.getLevelOfStarter(currentTrainers, prefix + j + "-" + i) < 36) {
                    this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, thisStarter);
                    ++j;
                }
                thisStarter = this.pickRandomEvolutionOf(thisStarter, false);
                while (j <= highestRivalNum) {
                    this.changeStarterWithTag(currentTrainers, prefix + j + "-" + i, thisStarter);
                    ++j;
                }
            }
        }
    }

    private Pokemon pickRandomEvolutionOf(Pokemon base, boolean mustEvolveItself) {
        ArrayList<Pokemon> candidates = new ArrayList<Pokemon>();
        for (Evolution ev : base.evolutionsFrom) {
            if (mustEvolveItself && ev.to.evolutionsFrom.size() <= 0) continue;
            candidates.add(ev.to);
        }
        if (candidates.size() == 0) {
            throw new RandomizationException("Random evolution called on a Pokemon without any usable evolutions.");
        }
        return (Pokemon)candidates.get(this.random.nextInt(candidates.size()));
    }

    private int getLevelOfStarter(List<Trainer> currentTrainers, String tag) {
        for (Trainer t : currentTrainers) {
            if (t.tag == null || !t.tag.equals(tag)) continue;
            int highestLevel = t.pokemon.get((int)0).level;
            int trainerPkmnCount = t.pokemon.size();
            for (int i = 1; i < trainerPkmnCount; ++i) {
                int levelBonus;
                int n = levelBonus = i == trainerPkmnCount - 1 ? 2 : 0;
                if (t.pokemon.get((int)i).level + levelBonus <= highestLevel) continue;
                highestLevel = t.pokemon.get((int)i).level;
            }
            return highestLevel;
        }
        return 0;
    }

    private void changeStarterWithTag(List<Trainer> currentTrainers, String tag, Pokemon starter) {
        for (Trainer t : currentTrainers) {
            if (t.tag == null || !t.tag.equals(tag)) continue;
            TrainerPokemon bestPoke = t.pokemon.get(0);
            int trainerPkmnCount = t.pokemon.size();
            for (int i = 1; i < trainerPkmnCount; ++i) {
                int levelBonus;
                int n = levelBonus = i == trainerPkmnCount - 1 ? 2 : 0;
                if (t.pokemon.get((int)i).level + levelBonus <= bestPoke.level) continue;
                bestPoke = t.pokemon.get(i);
            }
            bestPoke.pokemon = starter;
            bestPoke.resetMoves = true;
        }
    }

    private int numPreEvolutions(Pokemon pk, int maxInterested) {
        return this.numPreEvolutions(pk, 0, maxInterested);
    }

    private int numPreEvolutions(Pokemon pk, int depth, int maxInterested) {
        if (pk.evolutionsTo.size() == 0) {
            return 0;
        }
        if (depth == maxInterested - 1) {
            return 1;
        }
        int maxPreEvos = 0;
        for (Evolution ev : pk.evolutionsTo) {
            maxPreEvos = Math.max(maxPreEvos, this.numPreEvolutions(ev.from, depth + 1, maxInterested) + 1);
        }
        return maxPreEvos;
    }

    private int numEvolutions(Pokemon pk, int maxInterested) {
        return this.numEvolutions(pk, 0, maxInterested);
    }

    private int numEvolutions(Pokemon pk, int depth, int maxInterested) {
        if (pk.evolutionsFrom.size() == 0) {
            return 0;
        }
        if (depth == maxInterested - 1) {
            return 1;
        }
        int maxEvos = 0;
        for (Evolution ev : pk.evolutionsFrom) {
            maxEvos = Math.max(maxEvos, this.numEvolutions(ev.to, depth + 1, maxInterested) + 1);
        }
        return maxEvos;
    }

    private Pokemon fullyEvolve(Pokemon pokemon) {
        HashSet<Pokemon> seenMons = new HashSet<Pokemon>();
        seenMons.add(pokemon);
        while (pokemon.evolutionsFrom.size() != 0) {
            boolean cyclic = false;
            for (Evolution ev : pokemon.evolutionsFrom) {
                if (!seenMons.contains(ev.to)) continue;
                cyclic = true;
                break;
            }
            if (cyclic) break;
            pokemon = pokemon.evolutionsFrom.get((int)this.random.nextInt((int)pokemon.evolutionsFrom.size())).to;
            seenMons.add(pokemon);
        }
        return pokemon;
    }

    private Set<Pokemon> relatedPokemon(Pokemon original) {
        HashSet<Pokemon> results = new HashSet<Pokemon>();
        results.add(original);
        LinkedList<Pokemon> toCheck = new LinkedList<Pokemon>();
        toCheck.add(original);
        while (!toCheck.isEmpty()) {
            Pokemon check = (Pokemon)toCheck.poll();
            for (Evolution ev : check.evolutionsFrom) {
                if (results.contains(ev.to)) continue;
                results.add(ev.to);
                toCheck.add(ev.to);
            }
            for (Evolution ev : check.evolutionsTo) {
                if (results.contains(ev.from)) continue;
                results.add(ev.from);
                toCheck.add(ev.from);
            }
        }
        return results;
    }

    private Pokemon pickReplacement(Pokemon current, boolean usePowerLevels, Type type, boolean noLegendaries, boolean wonderGuardAllowed) {
        List<Pokemon> pickFrom = this.cachedAllList;
        if (type != null) {
            if (!this.cachedReplacementLists.containsKey((Object)type)) {
                this.cachedReplacementLists.put(type, this.pokemonOfType(type, noLegendaries));
            }
            pickFrom = this.cachedReplacementLists.get((Object)type);
        }
        if (usePowerLevels) {
            int currentBST = current.bstForPowerLevels();
            int minTarget = currentBST - currentBST / 10;
            int maxTarget = currentBST + currentBST / 10;
            ArrayList<Pokemon> canPick = new ArrayList<Pokemon>();
            for (int expandRounds = 0; canPick.isEmpty() || canPick.size() < 3 && expandRounds < 2; ++expandRounds) {
                for (Pokemon pk : pickFrom) {
                    if (pk.bstForPowerLevels() < minTarget || pk.bstForPowerLevels() > maxTarget || !wonderGuardAllowed && (pk.ability1 == 25 || pk.ability2 == 25 || pk.ability3 == 25)) continue;
                    canPick.add(pk);
                }
                minTarget -= currentBST / 20;
                maxTarget += currentBST / 20;
            }
            return (Pokemon)canPick.get(this.random.nextInt(canPick.size()));
        }
        if (wonderGuardAllowed) {
            return pickFrom.get(this.random.nextInt(pickFrom.size()));
        }
        Pokemon pk = pickFrom.get(this.random.nextInt(pickFrom.size()));
        while (pk.ability1 == 25 || pk.ability2 == 25 || pk.ability3 == 25) {
            pk = pickFrom.get(this.random.nextInt(pickFrom.size()));
        }
        return pk;
    }

    private Pokemon pickWildPowerLvlReplacement(List<Pokemon> pokemonPool, Pokemon current, boolean banSamePokemon, List<Pokemon> usedUp) {
        int currentBST = current.bstForPowerLevels();
        int minTarget = currentBST - currentBST / 10;
        int maxTarget = currentBST + currentBST / 10;
        ArrayList<Pokemon> canPick = new ArrayList<Pokemon>();
        for (int expandRounds = 0; canPick.isEmpty() || canPick.size() < 3 && expandRounds < 3; ++expandRounds) {
            for (Pokemon pk : pokemonPool) {
                if (pk.bstForPowerLevels() < minTarget || pk.bstForPowerLevels() > maxTarget || banSamePokemon && pk == current || usedUp != null && usedUp.contains(pk) || canPick.contains(pk)) continue;
                canPick.add(pk);
            }
            minTarget -= currentBST / 20;
            maxTarget += currentBST / 20;
        }
        return (Pokemon)canPick.get(this.random.nextInt(canPick.size()));
    }

    protected void checkPokemonRestrictions() {
        if (!this.restrictionsSet) {
            this.setPokemonPool(null);
        }
    }

    protected void applyCamelCaseNames() {
        List<Pokemon> pokes = this.getPokemon();
        for (Pokemon pkmn : pokes) {
            if (pkmn == null) continue;
            pkmn.name = RomFunctions.camelCase(pkmn.name);
        }
    }

    protected void log(String log) {
        if (this.logStream != null) {
            this.logStream.println(log);
        }
    }

    protected void logBlankLine() {
        if (this.logStream != null) {
            this.logStream.println();
        }
    }

    protected void logEvoChangeLevel(String pkFrom, String pkTo, int level) {
        if (this.logStream != null) {
            this.logStream.printf("Made %s evolve into %s at level %d", pkFrom, pkTo, level);
            this.logStream.println();
        }
    }

    protected void logEvoChangeLevelWithItem(String pkFrom, String pkTo, String itemName) {
        if (this.logStream != null) {
            this.logStream.printf("Made %s evolve into %s by leveling up holding %s", pkFrom, pkTo, itemName);
            this.logStream.println();
        }
    }

    protected void logEvoChangeStone(String pkFrom, String pkTo, String itemName) {
        if (this.logStream != null) {
            this.logStream.printf("Made %s evolve into %s using a %s", pkFrom, pkTo, itemName);
            this.logStream.println();
        }
    }

    protected void logEvoChangeLevelWithPkmn(String pkFrom, String pkTo, String otherRequired) {
        if (this.logStream != null) {
            this.logStream.printf("Made %s evolve into %s by leveling up with %s in the party", pkFrom, pkTo, otherRequired);
            this.logStream.println();
        }
    }

    @Override
    public boolean canChangeStarters() {
        return true;
    }

    @Override
    public boolean typeInGame(Type type) {
        return !type.isHackOnly;
    }

    @Override
    public String abilityName(int number) {
        return "";
    }

    @Override
    public boolean hasTimeBasedEncounters() {
        return false;
    }

    @Override
    public List<Pokemon> bannedForWildEncounters() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Integer> getMovesBannedFromLevelup() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Pokemon> bannedForStaticPokemon() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public int maxTrainerNameLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int maxSumOfTrainerNameLengths() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int maxTrainerClassNameLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int maxTradeNicknameLength() {
        return 10;
    }

    @Override
    public int maxTradeOTNameLength() {
        return 7;
    }

    @Override
    public List<Integer> getGameBreakingMoves() {
        return Arrays.asList(49, 82);
    }

    @Override
    public boolean isYellow() {
        return false;
    }

    @Override
    public boolean isROMHack() {
        return false;
    }

    @Override
    public void writeCheckValueToROM(int value) {
    }

    @Override
    public int miscTweaksAvailable() {
        return 0;
    }

    @Override
    public void applyMiscTweak(MiscTweak tweak) {
    }

    private static interface EvolvedPokemonAction {
        public void applyTo(Pokemon var1, Pokemon var2, boolean var3);
    }

    private static interface BasePokemonAction {
        public void applyTo(Pokemon var1);
    }

    private static class EvolutionPair {
        private Pokemon from;
        private Pokemon to;

        public EvolutionPair(Pokemon from, Pokemon to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EvolutionPair other = (EvolutionPair)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

