/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.romhandlers.AbstractRomHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

public abstract class AbstractGBRomHandler
extends AbstractRomHandler {
    protected byte[] rom;
    private String loadedFN;

    public AbstractGBRomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    @Override
    public boolean loadRom(String filename) {
        byte[] loaded = AbstractGBRomHandler.loadFile(filename);
        if (!this.detectRom(loaded)) {
            return false;
        }
        this.rom = loaded;
        this.loadedFN = filename;
        this.loadedRom();
        return true;
    }

    @Override
    public String loadedFilename() {
        return this.loadedFN;
    }

    @Override
    public boolean saveRom(String filename) {
        this.savingRom();
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(this.rom);
            fos.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return true;
    }

    @Override
    public boolean hasPhysicalSpecialSplit() {
        return false;
    }

    public abstract boolean detectRom(byte[] var1);

    public abstract void loadedRom();

    public abstract void savingRom();

    protected static byte[] loadFile(String filename) {
        try {
            return FileFunctions.readFileFullyIntoBuffer(filename);
        }
        catch (IOException ex) {
            throw new RandomizerIOException(ex);
        }
    }

    protected static byte[] loadFilePartial(String filename, int maxBytes) {
        try {
            File fh = new File(filename);
            if (!(fh.exists() && fh.isFile() && fh.canRead())) {
                return new byte[0];
            }
            long fileSize = fh.length();
            if (fileSize > Integer.MAX_VALUE) {
                return new byte[0];
            }
            FileInputStream fis = new FileInputStream(filename);
            byte[] file = FileFunctions.readFullyIntoBuffer(fis, Math.min((int)fileSize, maxBytes));
            fis.close();
            return file;
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }

    protected void readByteIntoFlags(boolean[] flags, int offsetIntoFlags, int offsetIntoROM) {
        int thisByte = this.rom[offsetIntoROM] & 0xFF;
        for (int i = 0; i < 8 && i + offsetIntoFlags < flags.length; ++i) {
            flags[offsetIntoFlags + i] = (thisByte >> i & 1) == 1;
        }
    }

    protected byte getByteFromFlags(boolean[] flags, int offsetIntoFlags) {
        int thisByte = 0;
        for (int i = 0; i < 8 && i + offsetIntoFlags < flags.length; ++i) {
            thisByte |= (flags[offsetIntoFlags + i] ? 1 : 0) << i;
        }
        return (byte)thisByte;
    }

    protected int readWord(int offset) {
        return this.readWord(this.rom, offset);
    }

    protected int readWord(byte[] data, int offset) {
        return (data[offset] & 0xFF) + ((data[offset + 1] & 0xFF) << 8);
    }

    protected void writeWord(int offset, int value) {
        this.writeWord(this.rom, offset, value);
    }

    protected void writeWord(byte[] data, int offset, int value) {
        data[offset] = (byte)(value % 256);
        data[offset + 1] = (byte)(value / 256 % 256);
    }

    protected boolean matches(byte[] data, int offset, byte[] needle) {
        for (int i = 0; i < needle.length; ++i) {
            if (offset + i >= data.length) {
                return false;
            }
            if (data[offset + i] == needle[i]) continue;
            return false;
        }
        return true;
    }
}

