/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.romhandlers.AbstractGBRomHandler;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;

public abstract class AbstractGBCRomHandler
extends AbstractGBRomHandler {
    private String[] tb;
    private Map<String, Byte> d;
    private int longestTableToken;

    public AbstractGBCRomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    protected void clearTextTables() {
        this.tb = new String[256];
        if (this.d != null) {
            this.d.clear();
        } else {
            this.d = new HashMap<String, Byte>();
        }
        this.longestTableToken = 0;
    }

    protected void readTextTable(String name) {
        try {
            Scanner sc = new Scanner(FileFunctions.openConfig(name + ".tbl"), "UTF-8");
            while (sc.hasNextLine()) {
                int hexcode;
                String q = sc.nextLine();
                if (q.trim().isEmpty()) continue;
                String[] r = q.split("=", 2);
                if (r[1].endsWith("\r\n")) {
                    r[1] = r[1].substring(0, r[1].length() - 2);
                }
                if (this.tb[hexcode = Integer.parseInt(r[0], 16)] != null) {
                    String oldMatch = this.tb[hexcode];
                    this.tb[hexcode] = null;
                    if (this.d.get(oldMatch) == hexcode) {
                        this.d.remove(oldMatch);
                    }
                }
                this.tb[hexcode] = r[1];
                this.longestTableToken = Math.max(this.longestTableToken, r[1].length());
                this.d.put(r[1], (byte)hexcode);
            }
            sc.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    protected String readString(int offset, int maxLength, boolean textEngineMode) {
        StringBuilder string = new StringBuilder();
        for (int c = 0; c < maxLength; ++c) {
            int currChar = this.rom[offset + c] & 0xFF;
            if (this.tb[currChar] != null) {
                string.append(this.tb[currChar]);
                if (!textEngineMode || !this.tb[currChar].equals("\\r") && !this.tb[currChar].equals("\\e")) continue;
                break;
            }
            if (currChar == 80) break;
            string.append("\\x" + String.format("%02X", currChar));
        }
        return string.toString();
    }

    protected int lengthOfStringAt(int offset, boolean textEngineMode) {
        int len = 0;
        while (this.rom[offset + len] != 80 && (!textEngineMode || this.rom[offset + len] != 87 && this.rom[offset + len] != 88)) {
            ++len;
        }
        if (textEngineMode && (this.rom[offset + len] == 87 || this.rom[offset + len] == 88)) {
            ++len;
        }
        return len;
    }

    protected byte[] translateString(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (text.length() != 0) {
            int i;
            if (text.charAt(0) == '\\' && text.charAt(1) == 'x') {
                baos.write(Integer.parseInt(text.substring(2, 4), 16));
                text = text.substring(4);
                continue;
            }
            for (i = Math.max(0, this.longestTableToken - text.length()); !this.d.containsKey(text.substring(0, this.longestTableToken - i)) && i != this.longestTableToken; ++i) {
            }
            if (i == this.longestTableToken) {
                text = text.substring(1);
                continue;
            }
            baos.write((int)(this.d.get(text.substring(0, this.longestTableToken - i)) & 0xFF));
            text = text.substring(this.longestTableToken - i);
        }
        return baos.toByteArray();
    }

    protected String readFixedLengthString(int offset, int length) {
        return this.readString(offset, length, false);
    }

    protected void writeFixedLengthString(String str, int offset, int length) {
        int len;
        byte[] translated = this.translateString(str);
        System.arraycopy(translated, 0, this.rom, offset, len);
        for (len = Math.min(translated.length, length); len < length; ++len) {
            this.rom[offset + len] = 80;
        }
    }

    protected void writeVariableLengthString(String str, int offset, boolean alreadyTerminated) {
        byte[] translated = this.translateString(str);
        System.arraycopy(translated, 0, this.rom, offset, translated.length);
        if (!alreadyTerminated) {
            this.rom[offset + translated.length] = 80;
        }
    }

    protected int makeGBPointer(int offset) {
        if (offset < 16384) {
            return offset;
        }
        return offset % 16384 + 16384;
    }

    protected int bankOf(int offset) {
        return offset / 16384;
    }

    protected int calculateOffset(int bank, int pointer) {
        if (pointer < 16384) {
            return pointer;
        }
        return pointer % 16384 + bank * 16384;
    }

    protected String readVariableLengthString(int offset, boolean textEngineMode) {
        return this.readString(offset, Integer.MAX_VALUE, textEngineMode);
    }

    protected static boolean romSig(byte[] rom, String sig) {
        try {
            int sigOffset = 308;
            byte[] sigBytes = sig.getBytes("US-ASCII");
            for (int i = 0; i < sigBytes.length; ++i) {
                if (rom[sigOffset + i] == sigBytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    protected static boolean romCode(byte[] rom, String code) {
        try {
            int sigOffset = 319;
            byte[] sigBytes = code.getBytes("US-ASCII");
            for (int i = 0; i < sigBytes.length; ++i) {
                if (rom[sigOffset + i] == sigBytes[i]) continue;
                return false;
            }
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }
}

