/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.romhandlers;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.exceptions.RandomizerIOException;
import com.dabomstew.pkrandom.newnds.NARCArchive;
import com.dabomstew.pkrandom.newnds.NDSRom;
import com.dabomstew.pkrandom.pokemon.Type;
import com.dabomstew.pkrandom.romhandlers.AbstractRomHandler;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Random;

public abstract class AbstractDSRomHandler
extends AbstractRomHandler {
    protected String dataFolder;
    private NDSRom baseRom;
    private String loadedFN;

    public AbstractDSRomHandler(Random random, PrintStream logStream) {
        super(random, logStream);
    }

    protected abstract boolean detectNDSRom(String var1);

    @Override
    public boolean loadRom(String filename) {
        if (!this.detectNDSRom(AbstractDSRomHandler.getROMCodeFromFile(filename))) {
            return false;
        }
        try {
            this.baseRom = new NDSRom(filename);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        this.loadedFN = filename;
        this.loadedROM(this.baseRom.getCode());
        return true;
    }

    @Override
    public String loadedFilename() {
        return this.loadedFN;
    }

    protected byte[] get3byte(int amount) {
        byte[] ret = new byte[]{(byte)(amount & 0xFF), (byte)(amount >> 8 & 0xFF), (byte)(amount >> 16 & 0xFF)};
        return ret;
    }

    protected abstract void loadedROM(String var1);

    protected abstract void savingROM();

    @Override
    public boolean saveRom(String filename) {
        this.savingROM();
        try {
            this.baseRom.saveTo(filename);
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
        return true;
    }

    public void closeInnerRom() throws IOException {
        this.baseRom.closeROM();
    }

    @Override
    public boolean canChangeStaticPokemon() {
        return false;
    }

    @Override
    public boolean hasPhysicalSpecialSplit() {
        return true;
    }

    public NARCArchive readNARC(String subpath) throws IOException {
        return new NARCArchive(this.readFile(subpath));
    }

    public void writeNARC(String subpath, NARCArchive narc) throws IOException {
        this.writeFile(subpath, narc.getBytes());
    }

    protected static String getROMCodeFromFile(String filename) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            fis.skip(12L);
            byte[] sig = FileFunctions.readFullyIntoBuffer(fis, 4);
            fis.close();
            String ndsCode = new String(sig, "US-ASCII");
            return ndsCode;
        }
        catch (IOException e) {
            throw new RandomizerIOException(e);
        }
    }

    protected int readWord(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8;
    }

    protected int readLong(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
    }

    protected int readRelativePointer(byte[] data, int offset) {
        return this.readLong(data, offset) + offset + 4;
    }

    protected void writeWord(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    protected void writeLong(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 2] = (byte)(value >> 16 & 0xFF);
        data[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    protected void writeRelativePointer(byte[] data, int offset, int pointer) {
        int relPointer = pointer - (offset + 4);
        this.writeLong(data, offset, relPointer);
    }

    protected byte[] readFile(String location) throws IOException {
        return this.baseRom.getFile(location);
    }

    protected void writeFile(String location, byte[] data) throws IOException {
        this.writeFile(location, data, 0, data.length);
    }

    protected void writeFile(String location, byte[] data, int offset, int length) throws IOException {
        if (offset != 0 || length != data.length) {
            byte[] newData = new byte[length];
            System.arraycopy(data, offset, newData, 0, length);
            data = newData;
        }
        this.baseRom.writeFile(location, data);
    }

    protected byte[] readARM9() throws IOException {
        return this.baseRom.getARM9();
    }

    protected void writeARM9(byte[] data) throws IOException {
        this.baseRom.writeARM9(data);
    }

    protected byte[] readOverlay(int number) throws IOException {
        return this.baseRom.getOverlay(number);
    }

    protected void writeOverlay(int number, byte[] data) throws IOException {
        this.baseRom.writeOverlay(number, data);
    }

    protected void readByteIntoFlags(byte[] data, boolean[] flags, int offsetIntoFlags, int offsetIntoData) {
        int thisByte = data[offsetIntoData] & 0xFF;
        for (int i = 0; i < 8 && i + offsetIntoFlags < flags.length; ++i) {
            flags[offsetIntoFlags + i] = (thisByte >> i & 1) == 1;
        }
    }

    protected byte getByteFromFlags(boolean[] flags, int offsetIntoFlags) {
        int thisByte = 0;
        for (int i = 0; i < 8 && i + offsetIntoFlags < flags.length; ++i) {
            thisByte |= (flags[offsetIntoFlags + i] ? 1 : 0) << i;
        }
        return (byte)thisByte;
    }

    protected int typeTMPaletteNumber(Type t) {
        if (t == null) {
            return 411;
        }
        switch (t) {
            case FIGHTING: {
                return 398;
            }
            case DRAGON: {
                return 399;
            }
            case WATER: {
                return 400;
            }
            case PSYCHIC: {
                return 401;
            }
            case NORMAL: {
                return 402;
            }
            case POISON: {
                return 403;
            }
            case ICE: {
                return 404;
            }
            case GRASS: {
                return 405;
            }
            case FIRE: {
                return 406;
            }
            case DARK: {
                return 407;
            }
            case STEEL: {
                return 408;
            }
            case ELECTRIC: {
                return 409;
            }
            case GROUND: {
                return 410;
            }
            default: {
                return 411;
            }
            case ROCK: {
                return 412;
            }
            case FLYING: {
                return 413;
            }
            case BUG: 
        }
        return 610;
    }
}

