/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.pokemon;

import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import java.util.ArrayList;
import java.util.List;

public class Trainer
implements Comparable<Trainer> {
    public int offset;
    public List<TrainerPokemon> pokemon = new ArrayList<TrainerPokemon>();
    public String tag;
    public boolean importantTrainer;
    public int poketype;
    public String name;
    public int trainerclass;
    public String fullDisplayName;

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (this.fullDisplayName != null) {
            sb.append(this.fullDisplayName + " ");
        } else if (this.name != null) {
            sb.append(this.name + " ");
        }
        if (this.trainerclass != 0) {
            sb.append("(" + this.trainerclass + ") - ");
        }
        sb.append(String.format("%x", this.offset));
        sb.append(" => ");
        boolean first = true;
        for (TrainerPokemon p : this.pokemon) {
            if (!first) {
                sb.append(',');
            }
            sb.append(p.pokemon.name + " Lv" + p.level);
            first = false;
        }
        sb.append(']');
        if (this.tag != null) {
            sb.append(" (" + this.tag + ")");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Trainer other = (Trainer)obj;
        return this.offset == other.offset;
    }

    @Override
    public int compareTo(Trainer o) {
        return this.offset - o.offset;
    }
}

