/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.pokemon;

import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.ExpCurve;
import com.dabomstew.pkrandom.pokemon.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Pokemon
implements Comparable<Pokemon> {
    public String name;
    public int number;
    public Type primaryType;
    public Type secondaryType;
    public int hp;
    public int attack;
    public int defense;
    public int spatk;
    public int spdef;
    public int speed;
    public int special;
    public int ability1;
    public int ability2;
    public int ability3;
    public int catchRate;
    public int expYield;
    public int guaranteedHeldItem;
    public int commonHeldItem;
    public int rareHeldItem;
    public int darkGrassHeldItem;
    public int genderRatio;
    public int frontSpritePointer;
    public int picDimensions;
    public ExpCurve growthCurve;
    public List<Evolution> evolutionsFrom = new ArrayList<Evolution>();
    public List<Evolution> evolutionsTo = new ArrayList<Evolution>();
    public List<Integer> shuffledStatsOrder = Arrays.asList(0, 1, 2, 3, 4, 5);
    public boolean temporaryFlag;
    private static final List<Integer> legendaries = Arrays.asList(144, 145, 146, 150, 151, 243, 244, 245, 249, 250, 251, 377, 378, 379, 380, 381, 382, 383, 384, 385, 386, 479, 480, 481, 482, 483, 484, 485, 486, 487, 488, 489, 490, 491, 492, 493, 494, 638, 639, 640, 641, 642, 643, 644, 645, 646, 647, 648, 649);

    public void shuffleStats(Random random) {
        Collections.shuffle(this.shuffledStatsOrder, random);
        this.applyShuffledOrderToStats();
    }

    public void copyShuffledStatsUpEvolution(Pokemon evolvesFrom) {
        this.shuffledStatsOrder = evolvesFrom.shuffledStatsOrder;
        this.applyShuffledOrderToStats();
    }

    private void applyShuffledOrderToStats() {
        List<Integer> stats = Arrays.asList(this.hp, this.attack, this.defense, this.spatk, this.spdef, this.speed);
        this.hp = stats.get(this.shuffledStatsOrder.get(0));
        this.attack = stats.get(this.shuffledStatsOrder.get(1));
        this.defense = stats.get(this.shuffledStatsOrder.get(2));
        this.spatk = stats.get(this.shuffledStatsOrder.get(3));
        this.spdef = stats.get(this.shuffledStatsOrder.get(4));
        this.speed = stats.get(this.shuffledStatsOrder.get(5));
        this.special = (int)Math.ceil((float)(this.spatk + this.spdef) / 2.0f);
    }

    public void randomizeStatsWithinBST(Random random) {
        if (this.number == 292) {
            int bst = this.bst() - 51;
            double atkW = random.nextDouble();
            double defW = random.nextDouble();
            double spaW = random.nextDouble();
            double spdW = random.nextDouble();
            double speW = random.nextDouble();
            double totW = atkW + defW + spaW + spdW + speW;
            this.hp = 1;
            this.attack = (int)Math.max(1L, Math.round(atkW / totW * (double)bst)) + 10;
            this.defense = (int)Math.max(1L, Math.round(defW / totW * (double)bst)) + 10;
            this.spatk = (int)Math.max(1L, Math.round(spaW / totW * (double)bst)) + 10;
            this.spdef = (int)Math.max(1L, Math.round(spdW / totW * (double)bst)) + 10;
            this.speed = (int)Math.max(1L, Math.round(speW / totW * (double)bst)) + 10;
            this.special = (int)Math.ceil((float)(this.spatk + this.spdef) / 2.0f);
        } else {
            int bst = this.bst() - 70;
            double hpW = random.nextDouble();
            double atkW = random.nextDouble();
            double defW = random.nextDouble();
            double spaW = random.nextDouble();
            double spdW = random.nextDouble();
            double speW = random.nextDouble();
            double totW = hpW + atkW + defW + spaW + spdW + speW;
            this.hp = (int)Math.max(1L, Math.round(hpW / totW * (double)bst)) + 20;
            this.attack = (int)Math.max(1L, Math.round(atkW / totW * (double)bst)) + 10;
            this.defense = (int)Math.max(1L, Math.round(defW / totW * (double)bst)) + 10;
            this.spatk = (int)Math.max(1L, Math.round(spaW / totW * (double)bst)) + 10;
            this.spdef = (int)Math.max(1L, Math.round(spdW / totW * (double)bst)) + 10;
            this.speed = (int)Math.max(1L, Math.round(speW / totW * (double)bst)) + 10;
            this.special = (int)Math.ceil((float)(this.spatk + this.spdef) / 2.0f);
        }
        if (this.hp > 255 || this.attack > 255 || this.defense > 255 || this.spatk > 255 || this.spdef > 255 || this.speed > 255) {
            this.randomizeStatsWithinBST(random);
        }
    }

    public void copyRandomizedStatsUpEvolution(Pokemon evolvesFrom) {
        double ourBST = this.bst();
        double theirBST = evolvesFrom.bst();
        double bstRatio = ourBST / theirBST;
        this.hp = (int)Math.min(255L, Math.max(1L, Math.round((double)evolvesFrom.hp * bstRatio)));
        this.attack = (int)Math.min(255L, Math.max(1L, Math.round((double)evolvesFrom.attack * bstRatio)));
        this.defense = (int)Math.min(255L, Math.max(1L, Math.round((double)evolvesFrom.defense * bstRatio)));
        this.speed = (int)Math.min(255L, Math.max(1L, Math.round((double)evolvesFrom.speed * bstRatio)));
        this.spatk = (int)Math.min(255L, Math.max(1L, Math.round((double)evolvesFrom.spatk * bstRatio)));
        this.spdef = (int)Math.min(255L, Math.max(1L, Math.round((double)evolvesFrom.spdef * bstRatio)));
        this.special = (int)Math.ceil((float)(this.spatk + this.spdef) / 2.0f);
    }

    public int bst() {
        return this.hp + this.attack + this.defense + this.spatk + this.spdef + this.speed;
    }

    public int bstForPowerLevels() {
        if (this.number == 292) {
            return (this.attack + this.defense + this.spatk + this.spdef + this.speed) * 6 / 5;
        }
        return this.hp + this.attack + this.defense + this.spatk + this.spdef + this.speed;
    }

    public String toString() {
        return "Pokemon [name=" + this.name + ", number=" + this.number + ", primaryType=" + (Object)((Object)this.primaryType) + ", secondaryType=" + (Object)((Object)this.secondaryType) + ", hp=" + this.hp + ", attack=" + this.attack + ", defense=" + this.defense + ", spatk=" + this.spatk + ", spdef=" + this.spdef + ", speed=" + this.speed + "]";
    }

    public String toStringRBY() {
        return "Pokemon [name=" + this.name + ", number=" + this.number + ", primaryType=" + (Object)((Object)this.primaryType) + ", secondaryType=" + (Object)((Object)this.secondaryType) + ", hp=" + this.hp + ", attack=" + this.attack + ", defense=" + this.defense + ", special=" + this.special + ", speed=" + this.speed + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.number;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pokemon other = (Pokemon)obj;
        return this.number == other.number;
    }

    @Override
    public int compareTo(Pokemon o) {
        return this.number - o.number;
    }

    public boolean isLegendary() {
        return legendaries.contains(this.number);
    }
}

