/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.pokemon;

import java.util.Random;

public class ItemList {
    private boolean[] items;
    private boolean[] tms;

    public ItemList(int highestIndex) {
        this.items = new boolean[highestIndex + 1];
        this.tms = new boolean[highestIndex + 1];
        for (int i = 1; i <= highestIndex; ++i) {
            this.items[i] = true;
        }
    }

    public boolean isTM(int index) {
        if (index < 0 || index >= this.tms.length) {
            return false;
        }
        return this.tms[index];
    }

    public boolean isAllowed(int index) {
        if (index < 0 || index >= this.tms.length) {
            return false;
        }
        return this.items[index];
    }

    public void banSingles(int ... indexes) {
        for (int index : indexes) {
            this.items[index] = false;
        }
    }

    public void banRange(int startIndex, int length) {
        for (int i = 0; i < length; ++i) {
            this.items[i + startIndex] = false;
        }
    }

    public void tmRange(int startIndex, int length) {
        for (int i = 0; i < length; ++i) {
            this.tms[i + startIndex] = true;
        }
    }

    public int randomItem(Random random) {
        int chosen = 0;
        while (!this.items[chosen]) {
            chosen = random.nextInt(this.items.length);
        }
        return chosen;
    }

    public int randomNonTM(Random random) {
        int chosen = 0;
        while (!this.items[chosen] || this.tms[chosen]) {
            chosen = random.nextInt(this.items.length);
        }
        return chosen;
    }

    public int randomTM(Random random) {
        int chosen = 0;
        while (!this.tms[chosen]) {
            chosen = random.nextInt(this.items.length);
        }
        return chosen;
    }

    public ItemList copy() {
        ItemList other = new ItemList(this.items.length - 1);
        System.arraycopy(this.items, 0, other.items, 0, this.items.length);
        System.arraycopy(this.tms, 0, other.tms, 0, this.tms.length);
        return other;
    }
}

