/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.pokemon;

public class GenRestrictions {
    public boolean allow_gen1;
    public boolean allow_gen2;
    public boolean allow_gen3;
    public boolean allow_gen4;
    public boolean allow_gen5;
    public boolean assoc_g1_g2;
    public boolean assoc_g1_g4;
    public boolean assoc_g2_g1;
    public boolean assoc_g2_g3;
    public boolean assoc_g2_g4;
    public boolean assoc_g3_g2;
    public boolean assoc_g3_g4;
    public boolean assoc_g4_g1;
    public boolean assoc_g4_g2;
    public boolean assoc_g4_g3;

    public GenRestrictions() {
    }

    public GenRestrictions(int state) {
        this.allow_gen1 = (state & 1) > 0;
        this.allow_gen2 = (state & 2) > 0;
        this.allow_gen3 = (state & 4) > 0;
        this.allow_gen4 = (state & 8) > 0;
        this.allow_gen5 = (state & 0x10) > 0;
        this.assoc_g1_g2 = (state & 0x20) > 0;
        this.assoc_g1_g4 = (state & 0x40) > 0;
        this.assoc_g2_g1 = (state & 0x80) > 0;
        this.assoc_g2_g3 = (state & 0x100) > 0;
        this.assoc_g2_g4 = (state & 0x200) > 0;
        this.assoc_g3_g2 = (state & 0x400) > 0;
        this.assoc_g3_g4 = (state & 0x800) > 0;
        this.assoc_g4_g1 = (state & 0x1000) > 0;
        this.assoc_g4_g2 = (state & 0x2000) > 0;
        this.assoc_g4_g3 = (state & 0x4000) > 0;
    }

    public boolean nothingSelected() {
        return !this.allow_gen1 && !this.allow_gen2 && !this.allow_gen3 && !this.allow_gen4 && !this.allow_gen5;
    }

    public int toInt() {
        return this.makeIntSelected(this.allow_gen1, this.allow_gen2, this.allow_gen3, this.allow_gen4, this.allow_gen5, this.assoc_g1_g2, this.assoc_g1_g4, this.assoc_g2_g1, this.assoc_g2_g3, this.assoc_g2_g4, this.assoc_g3_g2, this.assoc_g3_g4, this.assoc_g4_g1, this.assoc_g4_g2, this.assoc_g4_g3);
    }

    public void limitToGen(int generation) {
        if (generation < 2) {
            this.allow_gen2 = false;
            this.assoc_g1_g2 = false;
            this.assoc_g2_g1 = false;
        }
        if (generation < 3) {
            this.allow_gen3 = false;
            this.assoc_g2_g3 = false;
            this.assoc_g3_g2 = false;
        }
        if (generation < 4) {
            this.allow_gen4 = false;
            this.assoc_g1_g4 = false;
            this.assoc_g2_g4 = false;
            this.assoc_g3_g4 = false;
            this.assoc_g4_g1 = false;
            this.assoc_g4_g2 = false;
            this.assoc_g4_g3 = false;
        }
        if (generation < 5) {
            this.allow_gen5 = false;
        }
    }

    private int makeIntSelected(boolean ... switches) {
        if (switches.length > 32) {
            return 0;
        }
        int initial = 0;
        int state = 1;
        for (boolean b : switches) {
            initial |= b ? state : 0;
            state *= 2;
        }
        return initial;
    }
}

