/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.newnds;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.newnds.NDSRom;
import cuecompressors.BLZCoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class NDSY9Entry {
    private NDSRom parent;
    public int offset;
    public int size;
    public int original_size;
    public int fileID;
    public int overlay_id;
    public int ram_address;
    public int ram_size;
    public int bss_size;
    public int static_start;
    public int static_end;
    public int compressed_size;
    public int compress_flag;
    public Extracted status = Extracted.NOT;
    public String extFilename;
    public byte[] data;
    private boolean decompressed_data = false;

    public NDSY9Entry(NDSRom parent) {
        this.parent = parent;
    }

    public byte[] getContents() throws IOException {
        if (this.status == Extracted.NOT) {
            this.parent.reopenROM();
            RandomAccessFile rom = this.parent.getBaseRom();
            byte[] buf = new byte[this.original_size];
            rom.seek(this.offset);
            rom.readFully(buf);
            if (this.compress_flag != 0 && this.original_size == this.compressed_size && this.compressed_size != 0) {
                buf = new BLZCoder(null).BLZ_DecodePub(buf, "overlay " + this.overlay_id);
                this.decompressed_data = true;
            }
            if (this.parent.isWritingEnabled()) {
                String tmpFilename;
                String tmpDir = this.parent.getTmpFolder();
                String fullPath = String.format("overlay_%04d", this.overlay_id);
                this.extFilename = tmpFilename = fullPath.replaceAll("[^A-Za-z0-9_]+", "");
                File tmpFile = new File(tmpDir + this.extFilename);
                FileOutputStream fos = new FileOutputStream(tmpFile);
                fos.write(buf);
                fos.close();
                tmpFile.deleteOnExit();
                this.status = Extracted.TO_FILE;
                this.data = null;
                return buf;
            }
            this.status = Extracted.TO_RAM;
            this.data = buf;
            byte[] newcopy = new byte[buf.length];
            System.arraycopy(buf, 0, newcopy, 0, buf.length);
            return newcopy;
        }
        if (this.status == Extracted.TO_RAM) {
            byte[] newcopy = new byte[this.data.length];
            System.arraycopy(this.data, 0, newcopy, 0, this.data.length);
            return newcopy;
        }
        String tmpDir = this.parent.getTmpFolder();
        byte[] file = FileFunctions.readFileFullyIntoBuffer(tmpDir + this.extFilename);
        return file;
    }

    public void writeOverride(byte[] data) throws IOException {
        if (this.status == Extracted.NOT) {
            this.getContents();
        }
        this.size = data.length;
        if (this.status == Extracted.TO_FILE) {
            String tmpDir = this.parent.getTmpFolder();
            FileOutputStream fos = new FileOutputStream(new File(tmpDir + this.extFilename));
            fos.write(data);
            fos.close();
        } else if (this.data.length == data.length) {
            System.arraycopy(data, 0, this.data, 0, data.length);
        } else {
            this.data = null;
            this.data = new byte[data.length];
            System.arraycopy(data, 0, this.data, 0, data.length);
        }
    }

    public byte[] getOverrideContents() throws IOException {
        if (this.status == Extracted.NOT) {
            return null;
        }
        byte[] buf = this.getContents();
        if (this.decompressed_data) {
            buf = new BLZCoder(null).BLZ_EncodePub(buf, false, false, "overlay " + this.overlay_id);
            this.compressed_size = buf.length;
        }
        return buf;
    }

    private static enum Extracted {
        NOT,
        TO_FILE,
        TO_RAM;

    }
}

