/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.newnds;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.RomFunctions;
import com.dabomstew.pkrandom.SysConstants;
import com.dabomstew.pkrandom.newnds.CRC16;
import com.dabomstew.pkrandom.newnds.NDSFile;
import com.dabomstew.pkrandom.newnds.NDSY9Entry;
import cuecompressors.BLZCoder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NDSRom {
    private String romCode;
    private String romFilename;
    private RandomAccessFile baseRom;
    private boolean romOpen;
    private Map<String, NDSFile> files;
    private Map<Integer, NDSFile> filesByID;
    private Map<Integer, NDSY9Entry> arm9overlaysByFileID;
    private NDSY9Entry[] arm9overlays;
    private byte[] fat;
    private String tmpFolder;
    private boolean writingEnabled;
    private boolean arm9_open;
    private boolean arm9_changed;
    private boolean arm9_has_footer;
    private boolean arm9_compressed;
    private int arm9_szmode;
    private int arm9_szoffset;
    private byte[] arm9_footer;
    private byte[] arm9_ramstored;
    private static final int arm9_align = 511;
    private static final int arm7_align = 511;
    private static final int fnt_align = 511;
    private static final int fat_align = 511;
    private static final int banner_align = 511;
    private static final int file_align = 511;

    public NDSRom(String filename) throws IOException {
        this.romFilename = filename;
        this.baseRom = new RandomAccessFile(filename, "r");
        this.romOpen = true;
        String rawFilename = new File(filename).getName();
        String dataFolder = "tmp_" + rawFilename.substring(0, rawFilename.lastIndexOf(46));
        dataFolder = dataFolder.replaceAll("[^A-Za-z0-9_]+", "");
        File tmpFolder = new File(SysConstants.ROOT_PATH + dataFolder);
        tmpFolder.mkdir();
        if (tmpFolder.canWrite()) {
            this.writingEnabled = true;
            this.tmpFolder = SysConstants.ROOT_PATH + dataFolder + File.separator;
            tmpFolder.deleteOnExit();
        } else {
            this.writingEnabled = false;
        }
        this.readFileSystem();
        this.arm9_open = false;
        this.arm9_changed = false;
        this.arm9_ramstored = null;
    }

    public void reopenROM() throws IOException {
        if (!this.romOpen) {
            this.baseRom = new RandomAccessFile(this.romFilename, "r");
            this.romOpen = true;
        }
    }

    public void closeROM() throws IOException {
        if (this.romOpen && this.baseRom != null) {
            this.baseRom.close();
            this.baseRom = null;
            this.romOpen = false;
        }
    }

    private void readFileSystem() throws IOException {
        int end;
        int start;
        int i;
        this.baseRom.seek(12L);
        byte[] sig = new byte[4];
        this.baseRom.readFully(sig);
        this.romCode = new String(sig, "US-ASCII");
        this.baseRom.seek(64L);
        int fntOffset = this.readFromFile(this.baseRom, 4);
        this.readFromFile(this.baseRom, 4);
        int fatOffset = this.readFromFile(this.baseRom, 4);
        int fatSize = this.readFromFile(this.baseRom, 4);
        this.baseRom.seek(fatOffset);
        this.fat = new byte[fatSize];
        this.baseRom.readFully(this.fat);
        HashMap<Integer, String> directoryPaths = new HashMap<Integer, String>();
        directoryPaths.put(61440, "");
        int dircount = this.readFromFile(this.baseRom, fntOffset + 6, 2);
        this.files = new HashMap<String, NDSFile>();
        this.filesByID = new HashMap<Integer, NDSFile>();
        this.baseRom.seek(fntOffset);
        int[] subTableOffsets = new int[dircount];
        int[] firstFileIDs = new int[dircount];
        int[] parentDirIDs = new int[dircount];
        for (int i2 = 0; i2 < dircount && i2 < 4096; ++i2) {
            subTableOffsets[i2] = this.readFromFile(this.baseRom, 4) + fntOffset;
            firstFileIDs[i2] = this.readFromFile(this.baseRom, 2);
            parentDirIDs[i2] = this.readFromFile(this.baseRom, 2);
        }
        String[] directoryNames = new String[dircount];
        TreeMap<Integer, String> filenames = new TreeMap<Integer, String>();
        HashMap<Integer, Integer> fileDirectories = new HashMap<Integer, Integer>();
        for (i = 0; i < dircount && i < 4096; ++i) {
            this.firstPassDirectory(i, subTableOffsets[i], firstFileIDs[i], directoryNames, filenames, fileDirectories);
        }
        for (i = 1; i < dircount && i < 4096; ++i) {
            String dirname = directoryNames[i];
            if (dirname != null) {
                String fullDirName = "";
                int curDir = i;
                while (dirname != null && !dirname.isEmpty()) {
                    if (!fullDirName.isEmpty()) {
                        fullDirName = "/" + fullDirName;
                    }
                    fullDirName = dirname + fullDirName;
                    int parentDir = parentDirIDs[curDir];
                    if (parentDir < 61441 || parentDir > 65535) break;
                    curDir = parentDir - 61440;
                    dirname = directoryNames[curDir];
                }
                directoryPaths.put(i + 61440, fullDirName);
                continue;
            }
            directoryPaths.put(i + 61440, "");
        }
        Iterator i3 = filenames.keySet().iterator();
        while (i3.hasNext()) {
            int fileID = (Integer)i3.next();
            String filename = (String)filenames.get(fileID);
            int directory = (Integer)fileDirectories.get(fileID);
            String dirPath = (String)directoryPaths.get(directory + 61440);
            String fullFilename = filename;
            if (!dirPath.isEmpty()) {
                fullFilename = dirPath + "/" + filename;
            }
            NDSFile nf = new NDSFile(this);
            start = this.readFromByteArr(this.fat, fileID * 8, 4);
            end = this.readFromByteArr(this.fat, fileID * 8 + 4, 4);
            nf.offset = start;
            nf.size = end - start;
            nf.fullPath = fullFilename;
            nf.fileID = fileID;
            this.files.put(fullFilename, nf);
            this.filesByID.put(fileID, nf);
        }
        int arm9_ovl_table_offset = this.readFromFile(this.baseRom, 80, 4);
        int arm9_ovl_table_size = this.readFromFile(this.baseRom, 84, 4);
        int arm9_ovl_count = arm9_ovl_table_size / 32;
        byte[] y9table = new byte[arm9_ovl_table_size];
        this.arm9overlays = new NDSY9Entry[arm9_ovl_count];
        this.arm9overlaysByFileID = new HashMap<Integer, NDSY9Entry>();
        this.baseRom.seek(arm9_ovl_table_offset);
        this.baseRom.readFully(y9table);
        for (int i4 = 0; i4 < arm9_ovl_count; ++i4) {
            NDSY9Entry overlay = new NDSY9Entry(this);
            int fileID = this.readFromByteArr(y9table, i4 * 32 + 24, 4);
            start = this.readFromByteArr(this.fat, fileID * 8, 4);
            end = this.readFromByteArr(this.fat, fileID * 8 + 4, 4);
            overlay.offset = start;
            overlay.size = end - start;
            overlay.original_size = end - start;
            overlay.fileID = fileID;
            overlay.overlay_id = i4;
            overlay.ram_address = this.readFromByteArr(y9table, i4 * 32 + 4, 4);
            overlay.ram_size = this.readFromByteArr(y9table, i4 * 32 + 8, 4);
            overlay.bss_size = this.readFromByteArr(y9table, i4 * 32 + 12, 4);
            overlay.static_start = this.readFromByteArr(y9table, i4 * 32 + 16, 4);
            overlay.static_end = this.readFromByteArr(y9table, i4 * 32 + 20, 4);
            overlay.compressed_size = this.readFromByteArr(y9table, i4 * 32 + 28, 3);
            overlay.compress_flag = y9table[i4 * 32 + 31] & 0xFF;
            this.arm9overlays[i4] = overlay;
            this.arm9overlaysByFileID.put(fileID, overlay);
        }
    }

    public void saveTo(String filename) throws IOException {
        this.reopenROM();
        RandomAccessFile fNew = new RandomAccessFile(filename, "rw");
        int headersize = this.readFromFile(this.baseRom, 132, 4);
        this.baseRom.seek(0L);
        this.copy(this.baseRom, fNew, headersize);
        int arm9_offset = (int)(fNew.getFilePointer() + 511L) & 0xFFFFFE00;
        int old_arm9_offset = this.readFromFile(this.baseRom, 32, 4);
        int arm9_size = this.readFromFile(this.baseRom, 44, 4);
        if (this.arm9_open && this.arm9_changed) {
            byte[] newARM9 = this.getARM9();
            if (this.arm9_compressed) {
                newARM9 = new BLZCoder(null).BLZ_EncodePub(newARM9, true, false, "arm9.bin");
                if (this.arm9_szoffset > 0) {
                    int newValue = this.arm9_szmode == 1 ? newARM9.length : newARM9.length + 16384;
                    this.writeToByteArr(newARM9, this.arm9_szoffset, 3, newValue);
                }
            }
            arm9_size = newARM9.length;
            fNew.seek(arm9_offset);
            fNew.write(newARM9);
            if (this.arm9_has_footer) {
                fNew.write(this.arm9_footer);
            }
        } else {
            this.baseRom.seek(old_arm9_offset);
            fNew.seek(arm9_offset);
            this.copy(this.baseRom, fNew, arm9_size + 12);
        }
        int arm9_ovl_offset = (int)fNew.getFilePointer();
        int arm9_ovl_size = this.arm9overlays.length * 32;
        int arm7_offset = arm9_ovl_offset + arm9_ovl_size + 511 & 0xFFFFFE00;
        int old_arm7_offset = this.readFromFile(this.baseRom, 48, 4);
        int arm7_size = this.readFromFile(this.baseRom, 60, 4);
        this.baseRom.seek(old_arm7_offset);
        fNew.seek(arm7_offset);
        this.copy(this.baseRom, fNew, arm7_size);
        int arm7_ovl_offset = (int)fNew.getFilePointer();
        int old_arm7_ovl_offset = this.readFromFile(this.baseRom, 88, 4);
        int arm7_ovl_size = this.readFromFile(this.baseRom, 92, 4);
        this.baseRom.seek(old_arm7_ovl_offset);
        fNew.seek(arm7_ovl_offset);
        this.copy(this.baseRom, fNew, arm7_ovl_size);
        int banner_offset = (int)(fNew.getFilePointer() + 511L) & 0xFFFFFE00;
        int old_banner_offset = this.readFromFile(this.baseRom, 104, 4);
        int banner_size = 2112;
        this.baseRom.seek(old_banner_offset);
        fNew.seek(banner_offset);
        this.copy(this.baseRom, fNew, banner_size);
        int fnt_offset = (int)(fNew.getFilePointer() + 511L) & 0xFFFFFE00;
        int old_fnt_offset = this.readFromFile(this.baseRom, 64, 4);
        int fnt_size = this.readFromFile(this.baseRom, 68, 4);
        this.baseRom.seek(old_fnt_offset);
        fNew.seek(fnt_offset);
        this.copy(this.baseRom, fNew, fnt_size);
        int fat_offset = (int)(fNew.getFilePointer() + 511L) & 0xFFFFFE00;
        int fat_size = this.fat.length;
        byte[] newfat = new byte[this.fat.length];
        byte[] y9table = new byte[this.arm9overlays.length * 32];
        int base_offset = fat_offset + fat_size;
        int filecount = this.fat.length / 8;
        for (int fid = 0; fid < filecount; ++fid) {
            byte[] customContents;
            int offset_of_file = base_offset + 511 & 0xFFFFFE00;
            int file_len = 0;
            boolean copiedCustom = false;
            if (this.filesByID.containsKey(fid) && (customContents = this.filesByID.get(fid).getOverrideContents()) != null) {
                fNew.seek(offset_of_file);
                fNew.write(customContents);
                copiedCustom = true;
                file_len = customContents.length;
            }
            if (this.arm9overlaysByFileID.containsKey(fid)) {
                NDSY9Entry entry = this.arm9overlaysByFileID.get(fid);
                int overlay_id = entry.overlay_id;
                byte[] customContents2 = entry.getOverrideContents();
                if (customContents2 != null) {
                    fNew.seek(offset_of_file);
                    fNew.write(customContents2);
                    copiedCustom = true;
                    file_len = customContents2.length;
                }
                this.writeToByteArr(y9table, overlay_id * 32, 4, overlay_id);
                this.writeToByteArr(y9table, overlay_id * 32 + 4, 4, entry.ram_address);
                this.writeToByteArr(y9table, overlay_id * 32 + 8, 4, entry.ram_size);
                this.writeToByteArr(y9table, overlay_id * 32 + 12, 4, entry.bss_size);
                this.writeToByteArr(y9table, overlay_id * 32 + 16, 4, entry.static_start);
                this.writeToByteArr(y9table, overlay_id * 32 + 20, 4, entry.static_end);
                this.writeToByteArr(y9table, overlay_id * 32 + 24, 4, fid);
                this.writeToByteArr(y9table, overlay_id * 32 + 28, 3, entry.compressed_size);
                this.writeToByteArr(y9table, overlay_id * 32 + 31, 1, entry.compress_flag);
            }
            if (!copiedCustom) {
                int file_starts = this.readFromByteArr(this.fat, fid * 8, 4);
                int file_ends = this.readFromByteArr(this.fat, fid * 8 + 4, 4);
                file_len = file_ends - file_starts;
                this.baseRom.seek(file_starts);
                fNew.seek(offset_of_file);
                this.copy(this.baseRom, fNew, file_len);
            }
            this.writeToByteArr(newfat, fid * 8, 4, offset_of_file);
            this.writeToByteArr(newfat, fid * 8 + 4, 4, offset_of_file + file_len);
            base_offset = offset_of_file + file_len;
        }
        fNew.seek(fat_offset);
        fNew.write(newfat);
        fNew.seek(arm9_ovl_offset);
        fNew.write(y9table);
        int newfilesize = base_offset;
        int application_end_offset = newfilesize = newfilesize + 3 & 0xFFFFFFFC;
        if (newfilesize != base_offset) {
            fNew.seek(newfilesize - 1);
            fNew.write(0);
        }
        newfilesize |= newfilesize >> 16;
        newfilesize |= newfilesize >> 8;
        newfilesize |= newfilesize >> 4;
        newfilesize |= newfilesize >> 2;
        newfilesize |= newfilesize >> 1;
        if (++newfilesize <= 131072) {
            newfilesize = 131072;
        }
        int devcap = -18;
        int x = newfilesize;
        while (x != 0) {
            x >>= 1;
            ++devcap;
        }
        int devicecap = devcap < 0 ? 0 : devcap;
        this.writeToFile(fNew, 32, 4, arm9_offset);
        this.writeToFile(fNew, 44, 4, arm9_size);
        this.writeToFile(fNew, 48, 4, arm7_offset);
        this.writeToFile(fNew, 60, 4, arm7_size);
        this.writeToFile(fNew, 64, 4, fnt_offset);
        this.writeToFile(fNew, 72, 4, fat_offset);
        this.writeToFile(fNew, 80, 4, arm9_ovl_offset);
        this.writeToFile(fNew, 88, 4, arm7_ovl_offset);
        this.writeToFile(fNew, 104, 4, banner_offset);
        this.writeToFile(fNew, 128, 4, application_end_offset);
        this.writeToFile(fNew, 20, 1, devicecap);
        fNew.seek(0L);
        byte[] headerForCRC = new byte[350];
        fNew.readFully(headerForCRC);
        short crc = CRC16.calculate(headerForCRC, 0, 350);
        this.writeToFile(fNew, 350, 2, crc & 0xFFFF);
        fNew.close();
        this.closeROM();
    }

    private void copy(RandomAccessFile from, RandomAccessFile to, int bytes) throws IOException {
        int sizeof_copybuf = Math.min(262144, bytes);
        byte[] copybuf = new byte[sizeof_copybuf];
        while (bytes > 0) {
            int size2 = bytes >= sizeof_copybuf ? sizeof_copybuf : bytes;
            int read = from.read(copybuf, 0, size2);
            to.write(copybuf, 0, read);
            bytes -= read;
        }
        copybuf = null;
    }

    public String getCode() {
        return this.romCode;
    }

    public byte[] getFile(String filename) throws IOException {
        if (this.files.containsKey(filename)) {
            return this.files.get(filename).getContents();
        }
        return null;
    }

    public byte[] getOverlay(int number) throws IOException {
        if (number >= 0 && number < this.arm9overlays.length) {
            return this.arm9overlays[number].getContents();
        }
        return null;
    }

    public int getOverlayAddress(int number) {
        if (number >= 0 && number < this.arm9overlays.length) {
            return this.arm9overlays[number].ram_address;
        }
        return -1;
    }

    public byte[] getARM9() throws IOException {
        if (!this.arm9_open) {
            int compSize;
            this.arm9_open = true;
            this.reopenROM();
            int arm9_offset = this.readFromFile(this.baseRom, 32, 4);
            int arm9_size = this.readFromFile(this.baseRom, 44, 4);
            byte[] arm9 = new byte[arm9_size];
            this.baseRom.seek(arm9_offset);
            this.baseRom.readFully(arm9);
            int nitrocode = this.readFromFile(this.baseRom, 4);
            if (nitrocode == -557840863) {
                this.arm9_footer = new byte[12];
                this.writeToByteArr(this.arm9_footer, 0, 4, -557840863);
                this.baseRom.readFully(this.arm9_footer, 4, 8);
                this.arm9_has_footer = true;
            } else {
                this.arm9_has_footer = false;
            }
            while (this.readFromByteArr(arm9, arm9.length - 12, 4) == -557840863 || this.readFromByteArr(arm9, arm9.length - 12, 4) == 0 && this.readFromByteArr(arm9, arm9.length - 8, 4) == 0 && this.readFromByteArr(arm9, arm9.length - 4, 4) == 0) {
                if (!this.arm9_has_footer) {
                    this.arm9_has_footer = true;
                    this.arm9_footer = new byte[0];
                }
                byte[] newfooter = new byte[this.arm9_footer.length + 12];
                System.arraycopy(arm9, arm9.length - 12, newfooter, 0, 12);
                System.arraycopy(this.arm9_footer, 0, newfooter, 12, this.arm9_footer.length);
                this.arm9_footer = newfooter;
                byte[] newarm9 = new byte[arm9.length - 12];
                System.arraycopy(arm9, 0, newarm9, 0, arm9.length - 12);
                arm9 = newarm9;
            }
            this.arm9_compressed = false;
            this.arm9_szoffset = 0;
            if (arm9[arm9.length - 5] >= 8 && arm9[arm9.length - 5] <= 11 && (compSize = this.readFromByteArr(arm9, arm9.length - 8, 3)) > arm9.length * 9 / 10 && compSize < arm9.length * 11 / 10) {
                this.arm9_compressed = true;
                byte[] compLength = new byte[3];
                this.writeToByteArr(compLength, 0, 3, arm9.length);
                List<Integer> foundOffsets = RomFunctions.search(arm9, compLength);
                if (foundOffsets.size() == 1) {
                    this.arm9_szmode = 1;
                    this.arm9_szoffset = foundOffsets.get(0);
                } else {
                    byte[] compLength2 = new byte[3];
                    this.writeToByteArr(compLength2, 0, 3, arm9.length + 16384);
                    List<Integer> foundOffsets2 = RomFunctions.search(arm9, compLength2);
                    if (foundOffsets2.size() == 1) {
                        this.arm9_szmode = 2;
                        this.arm9_szoffset = foundOffsets2.get(0);
                    }
                }
            }
            if (this.arm9_compressed) {
                arm9 = new BLZCoder(null).BLZ_DecodePub(arm9, "arm9.bin");
            }
            if (this.writingEnabled) {
                File arm9file = new File(this.tmpFolder + "arm9.bin");
                FileOutputStream fos = new FileOutputStream(arm9file);
                fos.write(arm9);
                fos.close();
                arm9file.deleteOnExit();
                this.arm9_ramstored = null;
                return arm9;
            }
            this.arm9_ramstored = arm9;
            byte[] newcopy = new byte[arm9.length];
            System.arraycopy(arm9, 0, newcopy, 0, arm9.length);
            return newcopy;
        }
        if (this.writingEnabled) {
            byte[] file = FileFunctions.readFileFullyIntoBuffer(this.tmpFolder + "arm9.bin");
            return file;
        }
        byte[] newcopy = new byte[this.arm9_ramstored.length];
        System.arraycopy(this.arm9_ramstored, 0, newcopy, 0, this.arm9_ramstored.length);
        return newcopy;
    }

    public void writeFile(String filename, byte[] data) throws IOException {
        if (this.files.containsKey(filename)) {
            this.files.get(filename).writeOverride(data);
        }
    }

    public void writeOverlay(int number, byte[] data) throws IOException {
        if (number >= 0 && number <= this.arm9overlays.length) {
            this.arm9overlays[number].writeOverride(data);
        }
    }

    public void writeARM9(byte[] arm9) throws IOException {
        if (!this.arm9_open) {
            this.getARM9();
        }
        this.arm9_changed = true;
        if (this.writingEnabled) {
            FileOutputStream fos = new FileOutputStream(new File(this.tmpFolder + "arm9.bin"));
            fos.write(arm9);
            fos.close();
        } else if (this.arm9_ramstored.length == arm9.length) {
            System.arraycopy(arm9, 0, this.arm9_ramstored, 0, arm9.length);
        } else {
            this.arm9_ramstored = null;
            this.arm9_ramstored = new byte[arm9.length];
            System.arraycopy(arm9, 0, this.arm9_ramstored, 0, arm9.length);
        }
    }

    private void firstPassDirectory(int dir, int subTableOffset, int firstFileID, String[] directoryNames, Map<Integer, String> filenames, Map<Integer, Integer> fileDirectories) throws IOException {
        int control;
        this.baseRom.seek(subTableOffset);
        while ((control = this.baseRom.read()) != 0) {
            int namelen = control & 0x7F;
            byte[] rawname = new byte[namelen];
            this.baseRom.readFully(rawname);
            String name = new String(rawname, "US-ASCII");
            if ((control & 0x80) > 0) {
                int subDirectoryID = this.readFromFile(this.baseRom, 2);
                directoryNames[subDirectoryID - 61440] = name;
                continue;
            }
            int fileID = firstFileID++;
            filenames.put(fileID, name);
            fileDirectories.put(fileID, dir);
        }
    }

    public String getTmpFolder() {
        return this.tmpFolder;
    }

    public RandomAccessFile getBaseRom() {
        return this.baseRom;
    }

    public boolean isWritingEnabled() {
        return this.writingEnabled;
    }

    public int readFromByteArr(byte[] data, int offset, int size) {
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result |= (data[i + offset] & 0xFF) << i * 8;
        }
        return result;
    }

    public void writeToByteArr(byte[] data, int offset, int size, int value) {
        for (int i = 0; i < size; ++i) {
            data[offset + i] = (byte)(value >> i * 8 & 0xFF);
        }
    }

    public int readFromFile(RandomAccessFile file, int size) throws IOException {
        return this.readFromFile(file, -1, size);
    }

    public int readFromFile(RandomAccessFile file, int offset, int size) throws IOException {
        byte[] buf = new byte[size];
        if (offset >= 0) {
            file.seek(offset);
        }
        file.readFully(buf);
        int result = 0;
        for (int i = 0; i < size; ++i) {
            result |= (buf[i] & 0xFF) << i * 8;
        }
        return result;
    }

    public void writeToFile(RandomAccessFile file, int size, int value) throws IOException {
        this.writeToFile(file, -1, size, value);
    }

    public void writeToFile(RandomAccessFile file, int offset, int size, int value) throws IOException {
        byte[] buf = new byte[size];
        for (int i = 0; i < size; ++i) {
            buf[i] = (byte)(value >> i * 8 & 0xFF);
        }
        if (offset >= 0) {
            file.seek(offset);
        }
        file.write(buf);
    }
}

