/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.newnds;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NARCArchive {
    public List<String> filenames = new ArrayList<String>();
    public List<byte[]> files = new ArrayList<byte[]>();
    public boolean hasFilenames = false;

    public NARCArchive() {
    }

    public NARCArchive(byte[] data) throws IOException {
        Map<String, byte[]> frames = this.readNitroFrames(data);
        if (!(frames.containsKey("FATB") && frames.containsKey("FNTB") && frames.containsKey("FIMG"))) {
            throw new IOException("Not a valid narc file");
        }
        byte[] fatbframe = frames.get("FATB");
        byte[] fimgframe = frames.get("FIMG");
        int fileCount = this.readLong(fatbframe, 0);
        for (int i = 0; i < fileCount; ++i) {
            int startOffset = this.readLong(fatbframe, 4 + i * 8);
            int endOffset = this.readLong(fatbframe, 8 + i * 8);
            int length = endOffset - startOffset;
            byte[] thisFile = new byte[length];
            System.arraycopy(fimgframe, startOffset, thisFile, 0, length);
            this.files.add(thisFile);
        }
        byte[] fntbframe = frames.get("FNTB");
        int unk1 = this.readLong(fntbframe, 0);
        if (unk1 == 8) {
            this.hasFilenames = true;
            int offset = 8;
            for (int i = 0; i < fileCount; ++i) {
                int fnLength = fntbframe[offset] & 0xFF;
                byte[] filenameBA = new byte[fnLength];
                System.arraycopy(fntbframe, ++offset, filenameBA, 0, fnLength);
                String filename = new String(filenameBA, "US-ASCII");
                this.filenames.add(filename);
            }
        } else {
            this.hasFilenames = false;
            for (int i = 0; i < fileCount; ++i) {
                this.filenames.add(null);
            }
        }
    }

    public byte[] getBytes() throws IOException {
        Object file;
        int bytesRequired = 0;
        for (byte[] file2 : this.files) {
            bytesRequired = (int)((double)bytesRequired + Math.ceil((double)file2.length / 4.0) * 4.0);
        }
        byte[] fatbFrame = new byte[4 + this.files.size() * 8 + 8];
        byte[] fimgFrame = new byte[bytesRequired + 8];
        fatbFrame[0] = 66;
        fatbFrame[1] = 84;
        fatbFrame[2] = 65;
        fatbFrame[3] = 70;
        this.writeLong(fatbFrame, 4, fatbFrame.length);
        fimgFrame[0] = 71;
        fimgFrame[1] = 77;
        fimgFrame[2] = 73;
        fimgFrame[3] = 70;
        this.writeLong(fimgFrame, 4, fimgFrame.length);
        int offset = 0;
        this.writeLong(fatbFrame, 8, this.files.size());
        for (int i = 0; i < this.files.size(); ++i) {
            file = this.files.get(i);
            int bytesRequiredForFile = (int)(Math.ceil((double)((byte[])file).length / 4.0) * 4.0);
            System.arraycopy(file, 0, fimgFrame, offset + 8, ((Object)file).length);
            for (int filler = ((Object)file).length; filler < bytesRequiredForFile; ++filler) {
                fimgFrame[offset + 8 + filler] = -1;
            }
            this.writeLong(fatbFrame, 12 + i * 8, offset);
            this.writeLong(fatbFrame, 16 + i * 8, offset + ((Object)file).length);
            offset += bytesRequiredForFile;
        }
        int bytesForFNTBFrame = 16;
        if (this.hasFilenames) {
            file = this.filenames.iterator();
            while (file.hasNext()) {
                String filename = (String)file.next();
                bytesForFNTBFrame += filename.getBytes("US-ASCII").length + 1;
            }
        }
        byte[] fntbFrame = new byte[bytesForFNTBFrame];
        fntbFrame[0] = 66;
        fntbFrame[1] = 84;
        fntbFrame[2] = 78;
        fntbFrame[3] = 70;
        this.writeLong(fntbFrame, 4, fntbFrame.length);
        if (this.hasFilenames) {
            this.writeLong(fntbFrame, 8, 8);
            this.writeLong(fntbFrame, 12, 65536);
            int fntbOffset = 16;
            for (String filename : this.filenames) {
                byte[] fntbfilename = filename.getBytes("US-ASCII");
                fntbFrame[fntbOffset] = (byte)fntbfilename.length;
                System.arraycopy(fntbfilename, 0, fntbFrame, fntbOffset + 1, fntbfilename.length);
                fntbOffset += 1 + fntbfilename.length;
            }
        } else {
            this.writeLong(fntbFrame, 8, 4);
            this.writeLong(fntbFrame, 12, 65536);
        }
        int nitrolength = 16 + fatbFrame.length + fntbFrame.length + fimgFrame.length;
        byte[] nitroFile = new byte[nitrolength];
        nitroFile[0] = 78;
        nitroFile[1] = 65;
        nitroFile[2] = 82;
        nitroFile[3] = 67;
        this.writeWord(nitroFile, 4, 65534);
        this.writeWord(nitroFile, 6, 256);
        this.writeLong(nitroFile, 8, nitrolength);
        this.writeWord(nitroFile, 12, 16);
        this.writeWord(nitroFile, 14, 3);
        System.arraycopy(fatbFrame, 0, nitroFile, 16, fatbFrame.length);
        System.arraycopy(fntbFrame, 0, nitroFile, 16 + fatbFrame.length, fntbFrame.length);
        System.arraycopy(fimgFrame, 0, nitroFile, 16 + fatbFrame.length + fntbFrame.length, fimgFrame.length);
        return nitroFile;
    }

    private Map<String, byte[]> readNitroFrames(byte[] data) throws IOException {
        int frameCount = this.readWord(data, 14);
        int offset = 16;
        TreeMap<String, byte[]> frames = new TreeMap<String, byte[]>();
        for (int i = 0; i < frameCount; ++i) {
            byte[] magic = new byte[]{data[offset + 3], data[offset + 2], data[offset + 1], data[offset]};
            String magicS = new String(magic, "US-ASCII");
            int frame_size = this.readLong(data, offset + 4);
            if (i == frameCount - 1 && offset + frame_size < data.length) {
                frame_size = data.length - offset;
            }
            byte[] frame = new byte[frame_size - 8];
            System.arraycopy(data, offset + 8, frame, 0, frame_size - 8);
            frames.put(magicS, frame);
            offset += frame_size;
        }
        return frames;
    }

    private int readWord(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8;
    }

    private int readLong(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
    }

    private void writeWord(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    private void writeLong(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >> 8 & 0xFF);
        data[offset + 2] = (byte)(value >> 16 & 0xFF);
        data[offset + 3] = (byte)(value >> 24 & 0xFF);
    }
}

