/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.gui;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.SysConstants;
import com.dabomstew.pkrandom.Utils;
import com.dabomstew.pkrandom.gui.RandomizerGUI;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class UpdateFoundDialog
extends JDialog {
    private static final long serialVersionUID = -1641494584047215623L;
    private int targetVersion;
    private JScrollPane clScroller;
    private JButton closeBtn;
    private JButton downloadUpdateBtn;
    private JTextArea updateChangelogArea;
    private JLabel updateFoundLabel;

    public UpdateFoundDialog(RandomizerGUI parent, int newVersion, String changelog) {
        super((Frame)parent, true);
        this.initComponents();
        this.targetVersion = newVersion;
        Scanner sc = new Scanner(changelog);
        String firstLine = this.htmlspecialchars(sc.nextLine());
        sc.close();
        this.updateFoundLabel.setText("<html>An update to the Randomizer has been found: <b>" + firstLine + ".</b><br />You can see the changes made since your last update below.");
        while (changelog.trim().toLowerCase().startsWith("<html>")) {
            changelog = changelog.trim().substring(6);
        }
        this.updateChangelogArea.setText(changelog);
        this.updateChangelogArea.setCaretPosition(0);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.updateFoundLabel = new JLabel();
        this.clScroller = new JScrollPane();
        this.updateChangelogArea = new JTextArea();
        this.downloadUpdateBtn = new JButton();
        this.closeBtn = new JButton();
        this.setDefaultCloseOperation(2);
        this.updateFoundLabel.setText("<html>An update to the Randomizer has been found: <b>x.x.x</b>, released <b>blah.</b><br /> You can see the changes made below.");
        this.clScroller.setHorizontalScrollBarPolicy(31);
        this.updateChangelogArea.setEditable(false);
        this.updateChangelogArea.setColumns(40);
        this.updateChangelogArea.setLineWrap(true);
        this.updateChangelogArea.setRows(5);
        this.updateChangelogArea.setWrapStyleWord(true);
        this.updateChangelogArea.setEnabled(false);
        this.clScroller.setViewportView(this.updateChangelogArea);
        this.downloadUpdateBtn.setText("Download Update Now");
        this.downloadUpdateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateFoundDialog.this.downloadUpdateBtnActionPerformed(evt);
            }
        });
        this.closeBtn.setText("Close Without Updating");
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UpdateFoundDialog.this.closeBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clScroller).addGroup(layout.createSequentialGroup().addComponent(this.updateFoundLabel, -2, -1, -2).addGap(0, 161, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.downloadUpdateBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.updateFoundLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clScroller, -2, 209, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.downloadUpdateBtn).addComponent(this.closeBtn)).addContainerGap()));
        this.pack();
    }

    private void downloadUpdateBtnActionPerformed(ActionEvent evt) {
        String randomizerBinary;
        try {
            randomizerBinary = Utils.getExecutionLocation().getName();
        }
        catch (UnsupportedEncodingException e) {
            JOptionPane.showMessageDialog(this, "Automatic update not available.\nYou will now be taken to the website to download it manually.");
            this.attemptOpenBrowser();
            return;
        }
        String deltaFile = "delta_1720_" + this.targetVersion + (randomizerBinary.toLowerCase().endsWith(".exe") ? "_win" : "") + ".zip";
        try {
            byte[] zip = FileFunctions.downloadFile("http://pokehacks.dabomstew.com/randomizer/autoupdate/" + deltaFile);
            this.extract(zip, new File(SysConstants.ROOT_PATH), randomizerBinary);
            JOptionPane.showMessageDialog(this, "Update complete - the randomizer will now close.\nYou should now re-open the program and begin using the new version.");
            System.exit(0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Automatic update not available.\nYou will now be taken to the website to download it manually.");
            this.attemptOpenBrowser();
        }
    }

    private void attemptOpenBrowser() {
        Desktop desktop;
        String targetURL = "http://pokehacks.dabomstew.com/randomizer/";
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) {
            JOptionPane.showMessageDialog(this, "The downloads page could not be opened automatically.\nOpen a browser and navigate to the below link to download the update:\n" + targetURL);
        } else {
            try {
                desktop.browse(new URI(targetURL));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The downloads page could not be opened automatically.\nOpen a browser and navigate to the below link to download the update:\n" + targetURL);
            }
        }
        this.setVisible(false);
    }

    private void extractFile(ZipInputStream in, File outdir, String name) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        int count = -1;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private String dirpart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }

    private String htmlspecialchars(String original) {
        return original.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    public void extract(byte[] zipfile, File outdir, String randomizerBinary) throws IOException {
        ZipEntry entry;
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(zipfile));
        while ((entry = zin.getNextEntry()) != null) {
            String name = entry.getName();
            if (entry.isDirectory()) {
                this.mkdirs(outdir, name);
                continue;
            }
            String dir = this.dirpart(name);
            if (dir != null) {
                this.mkdirs(outdir, dir);
            }
            if (name.endsWith("randomizer.jar") || name.endsWith("randomizer.exe")) {
                name = name.substring(0, name.length() - 14) + randomizerBinary;
            }
            this.extractFile(zin, outdir, name);
        }
        zin.close();
    }

    private void closeBtnActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

