/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.gui;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RandomSource;
import com.dabomstew.pkrandom.Randomizer;
import com.dabomstew.pkrandom.Settings;
import com.dabomstew.pkrandom.SysConstants;
import com.dabomstew.pkrandom.Utils;
import com.dabomstew.pkrandom.exceptions.InvalidSupplementFilesException;
import com.dabomstew.pkrandom.exceptions.RandomizationException;
import com.dabomstew.pkrandom.gui.CustomNamesEditorDialog;
import com.dabomstew.pkrandom.gui.GenerationLimitDialog;
import com.dabomstew.pkrandom.gui.OperationDialog;
import com.dabomstew.pkrandom.gui.PresetLoadDialog;
import com.dabomstew.pkrandom.gui.PresetMakeDialog;
import com.dabomstew.pkrandom.gui.QSFileFilter;
import com.dabomstew.pkrandom.gui.ROMFilter;
import com.dabomstew.pkrandom.gui.UpdateCheckThread;
import com.dabomstew.pkrandom.gui.UpdateFoundDialog;
import com.dabomstew.pkrandom.pokemon.GenRestrictions;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.romhandlers.AbstractDSRomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen1RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen2RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen3RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen4RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen5RomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.xml.bind.DatatypeConverter;

public class RandomizerGUI
extends JFrame {
    private static final long serialVersionUID = 637989089525556154L;
    private RomHandler romHandler;
    protected RomHandler.Factory[] checkHandlers;
    private OperationDialog opDialog;
    private List<JCheckBox> tweakCheckboxes;
    private boolean presetMode;
    private GenRestrictions currentRestrictions;
    private LayoutManager noTweaksLayout;
    private boolean autoUpdateEnabled;
    private boolean haveCheckedCustomNames;
    private boolean useScrollPaneMode;
    private ImageIcon emptyIcon = new ImageIcon(this.getClass().getResource("/com/dabomstew/pkrandom/gui/emptyIcon.png"));
    ResourceBundle bundle;
    private static final int TWEAK_COLS = 4;
    private JPanel abilitiesPanel;
    private JPanel baseStatsPanel;
    private JCheckBox brokenMovesCB;
    private JMenuItem customNamesEditorMenuItem;
    private JCheckBox fiBanBadCB;
    private JRadioButton fiRandomRB;
    private JRadioButton fiShuffleRB;
    private JRadioButton fiUnchangedRB;
    private ButtonGroup fieldItemsButtonGroup;
    private JPanel fieldItemsInnerPanel;
    private JPanel fieldItemsPanel;
    private JLabel gameMascotLabel;
    private JPanel generalOptionsPanel;
    private JCheckBox goCondenseEvosCheckBox;
    private JCheckBox goRemoveTradeEvosCheckBox;
    private JCheckBox goUpdateMovesCheckBox;
    private JCheckBox goUpdateMovesLegacyCheckBox;
    private JRadioButton igtBothRB;
    private JRadioButton igtGivenOnlyRB;
    private JCheckBox igtRandomIVsCB;
    private JCheckBox igtRandomItemCB;
    private JCheckBox igtRandomNicknameCB;
    private JCheckBox igtRandomOTCB;
    private JRadioButton igtUnchangedRB;
    private JPanel inGameTradesPanel;
    private ButtonGroup ingameTradesButtonGroup;
    private JButton loadQSButton;
    private JMenuItem manualUpdateMenuItem;
    private JCheckBox mdRandomAccuracyCB;
    private JCheckBox mdRandomCategoryCB;
    private JCheckBox mdRandomPPCB;
    private JCheckBox mdRandomPowerCB;
    private JCheckBox mdRandomTypeCB;
    private JPanel miscTweaksInnerPanel;
    private JPanel miscTweaksPanel;
    private JPanel moveDataPanel;
    private JPanel moveTutorsPanel;
    private JPanel movesAndSetsPanel;
    private JPanel mtCompatPanel;
    private ButtonGroup mtCompatibilityButtonGroup;
    private JCheckBox mtForceGoodDamagingCB;
    private JSlider mtForceGoodDamagingSlider;
    private JCheckBox mtKeepFieldMovesCB;
    private JCheckBox mtLearningSanityCB;
    private ButtonGroup mtMovesButtonGroup;
    private JPanel mtMovesPanel;
    private JLabel mtNoExistLabel;
    private JLabel mtNoneAvailableLabel;
    private JRadioButton mtcFullRB;
    private JRadioButton mtcRandomTotalRB;
    private JRadioButton mtcRandomTypeRB;
    private JRadioButton mtcUnchangedRB;
    private JRadioButton mtmRandomRB;
    private JRadioButton mtmUnchangedRB;
    private JButton openROMButton;
    private JCheckBox paBanNegativeCB;
    private JCheckBox paBanTrappingCB;
    private JLabel paBansLabel;
    private JCheckBox paFollowEvolutionsCB;
    private JRadioButton paRandomizeRB;
    private JRadioButton paUnchangedRB;
    private JCheckBox paWonderGuardCB;
    private JRadioButton pbsChangesRandomRB;
    private JRadioButton pbsChangesShuffleRB;
    private JRadioButton pbsChangesUnchangedRB;
    private JCheckBox pbsFollowEvolutionsCB;
    private JCheckBox pbsStandardEXPCurvesCB;
    private JCheckBox pbsUpdateStatsCB;
    private JCheckBox peForceChangeCB;
    private JRadioButton peRandomRB;
    private JCheckBox peSameTypeCB;
    private JCheckBox peSimilarStrengthCB;
    private JCheckBox peThreeStagesCB;
    private JRadioButton peUnchangedRB;
    private JCheckBox pms4MovesCB;
    private JCheckBox pmsForceGoodDamagingCB;
    private JSlider pmsForceGoodDamagingSlider;
    private JRadioButton pmsMetronomeOnlyRB;
    private JRadioButton pmsRandomTotalRB;
    private JRadioButton pmsRandomTypeRB;
    private JCheckBox pmsReorderDamagingMovesCB;
    private JRadioButton pmsUnchangedRB;
    private ButtonGroup pokeAbilitiesButtonGroup;
    private ButtonGroup pokeEvolutionsButtonGroup;
    private JButton pokeLimitBtn;
    private JCheckBox pokeLimitCB;
    private ButtonGroup pokeMovesetsButtonGroup;
    private ButtonGroup pokeStatChangesButtonGroup;
    private JPanel pokeTraitsPanel;
    private ButtonGroup pokeTypesButtonGroup;
    private JPanel pokemonEvolutionsPanel;
    private JPanel pokemonMovesetsPanel;
    private JPanel pokemonTypesPanel;
    private JRadioButton ptRandomFollowEvosRB;
    private JRadioButton ptRandomTotalRB;
    private JRadioButton ptUnchangedRB;
    private JFileChooser qsOpenChooser;
    private JFileChooser qsSaveChooser;
    private JCheckBox raceModeCB;
    private JTabbedPane randomizerOptionsPane;
    private JLabel riRomCodeLabel;
    private JLabel riRomNameLabel;
    private JLabel riRomSupportLabel;
    private JPanel romInfoPanel;
    private JFileChooser romOpenChooser;
    private JFileChooser romSaveChooser;
    private JButton saveQSButton;
    private JButton saveROMButton;
    private JButton settingsButton;
    private JComboBox spCustomPoke1Chooser;
    private JComboBox spCustomPoke2Chooser;
    private JComboBox spCustomPoke3Chooser;
    private JRadioButton spCustomRB;
    private JCheckBox spHeldItemsBanBadCB;
    private JCheckBox spHeldItemsCB;
    private JRadioButton spRandom2EvosRB;
    private JRadioButton spRandomRB;
    private JRadioButton spUnchangedRB;
    private ButtonGroup starterPokemonButtonGroup;
    private JPanel starterPokemonPanel;
    private JPanel startersInnerPanel;
    private ButtonGroup staticPokemonButtonGroup;
    private JPanel staticPokemonPanel;
    private JRadioButton stpRandomL4LRB;
    private JRadioButton stpRandomTotalRB;
    private JRadioButton stpUnchangedRB;
    private JCheckBox tcnRandomizeCB;
    private JRadioButton thcFullRB;
    private JRadioButton thcRandomTotalRB;
    private JRadioButton thcRandomTypeRB;
    private JRadioButton thcUnchangedRB;
    private JCheckBox tmForceGoodDamagingCB;
    private JSlider tmForceGoodDamagingSlider;
    private JCheckBox tmFullHMCompatCB;
    private JPanel tmHmCompatPanel;
    private ButtonGroup tmHmCompatibilityButtonGroup;
    private JPanel tmHmTutorPanel;
    private JCheckBox tmKeepFieldMovesCB;
    private JCheckBox tmLearningSanityCB;
    private ButtonGroup tmMovesButtonGroup;
    private JPanel tmMovesPanel;
    private JPanel tmhmsPanel;
    private JRadioButton tmmRandomRB;
    private JRadioButton tmmUnchangedRB;
    private JCheckBox tnRandomizeCB;
    private JMenuItem toggleAutoUpdatesMenuItem;
    private JMenuItem toggleScrollPaneMenuItem;
    private JCheckBox tpForceFullyEvolvedCB;
    private JSlider tpForceFullyEvolvedSlider;
    private JCheckBox tpLevelModifierCB;
    private JSlider tpLevelModifierSlider;
    private JCheckBox tpNoEarlyShedinjaCB;
    private JCheckBox tpNoLegendariesCB;
    private JCheckBox tpPowerLevelsCB;
    private JRadioButton tpRandomRB;
    private JCheckBox tpRivalCarriesStarterCB;
    private JRadioButton tpTypeThemedRB;
    private JCheckBox tpTypeWeightingCB;
    private JRadioButton tpUnchangedRB;
    private ButtonGroup trainerPokesButtonGroup;
    private JPanel trainersInnerPanel;
    private JPanel trainersPokemonPanel;
    private JPopupMenu updateSettingsMenu;
    private JButton usePresetsButton;
    private JLabel versionLabel;
    private JLabel websiteLinkLabel;
    private JPanel wildPokemonARulePanel;
    private JPanel wildPokemonPanel;
    private ButtonGroup wildPokesARuleButtonGroup;
    private ButtonGroup wildPokesButtonGroup;
    private JPanel wildsInnerPanel;
    private JRadioButton wpARCatchEmAllRB;
    private JRadioButton wpARNoneRB;
    private JRadioButton wpARSimilarStrengthRB;
    private JRadioButton wpARTypeThemedRB;
    private JRadioButton wpArea11RB;
    private JCheckBox wpCatchRateCB;
    private JSlider wpCatchRateSlider;
    private JRadioButton wpGlobalRB;
    private JCheckBox wpHeldItemsBanBadCB;
    private JCheckBox wpHeldItemsCB;
    private JCheckBox wpNoLegendariesCB;
    private JRadioButton wpRandomRB;
    private JRadioButton wpUnchangedRB;
    private JCheckBox wpUseTimeCB;

    public static void main(String[] args) {
        boolean autoupdate = true;
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("--noupdate")) continue;
            autoupdate = false;
            break;
        }
        final boolean au = autoupdate;
        boolean onWindowsNativeLAF = false;
        try {
            String lafName = UIManager.getSystemLookAndFeelClassName();
            if (lafName.equalsIgnoreCase("com.sun.java.swing.plaf.windows.WindowsLookAndFeel")) {
                UIManager.setLookAndFeel(lafName);
                onWindowsNativeLAF = true;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RandomizerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RandomizerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RandomizerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RandomizerGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        final boolean wn = onWindowsNativeLAF;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RandomizerGUI(au, wn);
            }
        });
    }

    public RandomizerGUI(boolean autoupdate, boolean onWindowsLAF) {
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this.bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
        this.testForRequiredConfigs();
        this.checkHandlers = new RomHandler.Factory[]{new Gen1RomHandler.Factory(), new Gen2RomHandler.Factory(), new Gen3RomHandler.Factory(), new Gen4RomHandler.Factory(), new Gen5RomHandler.Factory()};
        this.autoUpdateEnabled = true;
        this.haveCheckedCustomNames = false;
        this.useScrollPaneMode = !onWindowsLAF;
        this.attemptReadConfig();
        if (!autoupdate) {
            this.autoUpdateEnabled = false;
        }
        this.initComponents();
        this.initTweaksPanel();
        this.guiCleanup();
        if (this.useScrollPaneMode) {
            this.scrollPaneSetup();
        }
        this.noTweaksLayout = this.miscTweaksPanel.getLayout();
        this.initialiseState();
        boolean canWrite = this.attemptWriteConfig();
        if (!canWrite) {
            JOptionPane.showMessageDialog(null, this.bundle.getString("RandomizerGUI.cantWriteConfigFile"));
            this.autoUpdateEnabled = false;
        }
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (!this.haveCheckedCustomNames) {
            this.checkCustomNames();
        }
        if (this.autoUpdateEnabled) {
            new UpdateCheckThread(this, false).start();
        }
    }

    private void guiCleanup() {
        Font f = this.pokeLimitCB.getFont();
        if (f == null || !f.getFontName().equalsIgnoreCase("tahoma") || f.getSize() != 11) {
            System.out.println("activating font face fix");
            Font regularFont = new Font("Tahoma", 0, 11);
            Font boldFont = new Font("Tahoma", 1, 11);
            this.fontFaceFix(this, regularFont, boldFont);
            for (JCheckBox cb : this.tweakCheckboxes) {
                cb.setFont(regularFont);
            }
        }
    }

    private void scrollPaneSetup() {
        JScrollPane optionsScrollPane = new JScrollPane();
        optionsScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        JPanel optionsContainerPanel = new JPanel();
        GroupLayout optionsContainerPanelLayout = new GroupLayout(optionsContainerPanel);
        optionsContainerPanel.setLayout(optionsContainerPanelLayout);
        optionsContainerPanelLayout.setHorizontalGroup(optionsContainerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pokemonTypesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.pokemonMovesetsPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.trainersPokemonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.wildPokemonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.starterPokemonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.staticPokemonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.tmhmsPanel, -1, -1, Short.MAX_VALUE).addGroup(optionsContainerPanelLayout.createSequentialGroup().addComponent(this.baseStatsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.abilitiesPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.moveTutorsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.inGameTradesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.fieldItemsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.pokemonEvolutionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.moveDataPanel, -1, -1, Short.MAX_VALUE).addComponent(this.miscTweaksPanel, -1, -1, Short.MAX_VALUE));
        optionsContainerPanelLayout.setVerticalGroup(optionsContainerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsContainerPanelLayout.createSequentialGroup().addGroup(optionsContainerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.baseStatsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.abilitiesPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pokemonTypesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pokemonEvolutionsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.starterPokemonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveDataPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pokemonMovesetsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.trainersPokemonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wildPokemonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.staticPokemonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tmhmsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveTutorsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inGameTradesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fieldItemsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.miscTweaksPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        optionsScrollPane.setViewportView(optionsContainerPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(optionsScrollPane, -1, 747, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.generalOptionsPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.loadQSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveQSButton)).addComponent(this.romInfoPanel, -2, -1, -2)).addGap(28, 28, 28).addComponent(this.gameMascotLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openROMButton, GroupLayout.Alignment.TRAILING, -2, 159, -2).addComponent(this.saveROMButton, GroupLayout.Alignment.TRAILING, -2, 159, -2).addComponent(this.usePresetsButton, GroupLayout.Alignment.TRAILING, -2, 159, -2).addComponent(this.settingsButton, GroupLayout.Alignment.TRAILING, -2, 159, -2))).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.websiteLinkLabel, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, -1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generalOptionsPanel, -2, -1, -2).addComponent(this.gameMascotLabel).addGroup(layout.createSequentialGroup().addComponent(this.openROMButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveROMButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.usePresetsButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.settingsButton)).addGroup(layout.createSequentialGroup().addComponent(this.romInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadQSButton).addComponent(this.saveQSButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionLabel).addComponent(this.websiteLinkLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(optionsScrollPane, -1, 457, Short.MAX_VALUE).addContainerGap(-1, -1)));
        this.getContentPane().remove(this.randomizerOptionsPane);
        this.getContentPane().setLayout(layout);
    }

    private void fontFaceFix(Container root, Font font, Font boldFont) {
        for (Component c : root.getComponents()) {
            JComponent jc;
            Border b;
            if (c != this.versionLabel) {
                c.setFont(font);
            }
            if (c instanceof JComponent && (b = (jc = (JComponent)c).getBorder()) != null && b instanceof TitledBorder) {
                ((TitledBorder)b).setTitleFont(boldFont);
            }
            if (!(c instanceof Container)) continue;
            this.fontFaceFix((Container)c, font, boldFont);
        }
    }

    private void initTweaksPanel() {
        this.tweakCheckboxes = new ArrayList<JCheckBox>();
        int numTweaks = MiscTweak.allTweaks.size();
        for (int i = 0; i < numTweaks; ++i) {
            MiscTweak ct = MiscTweak.allTweaks.get(i);
            JCheckBox tweakBox = new JCheckBox();
            tweakBox.setText(ct.getTweakName());
            tweakBox.setToolTipText(ct.getTooltipText());
            this.tweakCheckboxes.add(tweakBox);
        }
    }

    private GroupLayout makeTweaksLayout(List<JCheckBox> tweaks) {
        GroupLayout gl = new GroupLayout(this.miscTweaksPanel);
        int numTweaks = tweaks.size();
        GroupLayout.SequentialGroup columnsGroup = gl.createSequentialGroup().addContainerGap();
        int numCols = Math.min(4, numTweaks);
        GroupLayout.ParallelGroup[] colGroups = new GroupLayout.ParallelGroup[numCols];
        for (int col = 0; col < numCols; ++col) {
            if (col > 0) {
                columnsGroup.addGap(18, 18, 18);
            }
            colGroups[col] = gl.createParallelGroup(GroupLayout.Alignment.LEADING);
            columnsGroup.addGroup(colGroups[col]);
        }
        for (int tweak = 0; tweak < numTweaks; ++tweak) {
            colGroups[tweak % numCols].addComponent(tweaks.get(tweak));
        }
        columnsGroup.addContainerGap();
        gl.setHorizontalGroup(gl.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(columnsGroup));
        GroupLayout.SequentialGroup rowsGroup = gl.createSequentialGroup().addContainerGap();
        int numRows = (numTweaks - 1) / numCols + 1;
        GroupLayout.ParallelGroup[] rowGroups = new GroupLayout.ParallelGroup[numRows];
        for (int row = 0; row < numRows; ++row) {
            if (row > 0) {
                rowsGroup.addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED);
            }
            rowGroups[row] = gl.createParallelGroup(GroupLayout.Alignment.BASELINE);
            rowsGroup.addGroup(rowGroups[row]);
        }
        for (int tweak = 0; tweak < numTweaks; ++tweak) {
            rowGroups[tweak / numCols].addComponent(tweaks.get(tweak));
        }
        rowsGroup.addContainerGap();
        gl.setVerticalGroup(gl.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rowsGroup));
        return gl;
    }

    private void checkCustomNames() {
        String[] cnamefiles = new String[]{"trainernames.txt", "trainerclasses.txt", "nicknames.txt"};
        boolean foundFile = false;
        for (int file = 0; file < 3; ++file) {
            File currentFile = new File(SysConstants.ROOT_PATH + cnamefiles[file]);
            if (!currentFile.exists()) continue;
            foundFile = true;
            break;
        }
        if (foundFile) {
            int response = JOptionPane.showConfirmDialog(this, this.bundle.getString("RandomizerGUI.convertNameFilesDialog.text"), this.bundle.getString("RandomizerGUI.convertNameFilesDialog.title"), 0);
            if (response == 0) {
                try {
                    CustomNamesSet newNamesData = CustomNamesSet.importOldNames();
                    byte[] data = newNamesData.getBytes();
                    FileFunctions.writeBytesToFile("customnames.rncn", data);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.convertNameFilesFailed"));
                }
            }
            this.haveCheckedCustomNames = true;
            this.attemptWriteConfig();
        }
    }

    private void attemptReadConfig() {
        File fh = new File(SysConstants.ROOT_PATH + "config.ini");
        if (!fh.exists() || !fh.canRead()) {
            return;
        }
        try {
            Scanner sc = new Scanner(fh, "UTF-8");
            while (sc.hasNextLine()) {
                String[] tokens;
                String q = sc.nextLine().trim();
                if (q.contains("//")) {
                    q = q.substring(0, q.indexOf("//")).trim();
                }
                if (q.isEmpty() || (tokens = q.split("=", 2)).length != 2) continue;
                String key = tokens[0].trim();
                if (key.equalsIgnoreCase("autoupdate")) {
                    this.autoUpdateEnabled = Boolean.parseBoolean(tokens[1].trim());
                    continue;
                }
                if (key.equalsIgnoreCase("checkedcustomnames172")) {
                    this.haveCheckedCustomNames = Boolean.parseBoolean(tokens[1].trim());
                    continue;
                }
                if (!key.equalsIgnoreCase("usescrollpane")) continue;
                this.useScrollPaneMode = Boolean.parseBoolean(tokens[1].trim());
            }
            sc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean attemptWriteConfig() {
        File fh = new File(SysConstants.ROOT_PATH + "config.ini");
        if (fh.exists() && !fh.canWrite()) {
            return false;
        }
        try {
            PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(fh), true, "UTF-8");
            ps.println("autoupdate=" + this.autoUpdateEnabled);
            ps.println("checkedcustomnames=true");
            ps.println("checkedcustomnames172=" + this.haveCheckedCustomNames);
            ps.println("usescrollpane=" + this.useScrollPaneMode);
            ps.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void testForRequiredConfigs() {
        try {
            Utils.testForRequiredConfigs();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, String.format(this.bundle.getString("RandomizerGUI.configFileMissing"), e.getMessage()));
            System.exit(1);
            return;
        }
    }

    private void initialiseState() {
        this.romHandler = null;
        this.currentRestrictions = null;
        this.websiteLinkLabel.setText("<html><a href=\"http://pokehacks.dabomstew.com/randomizer/\">http://pokehacks.dabomstew.com/randomizer/</a>");
        this.initialFormState();
        this.romOpenChooser.setCurrentDirectory(new File(SysConstants.ROOT_PATH));
        this.romSaveChooser.setCurrentDirectory(new File(SysConstants.ROOT_PATH));
        if (new File(SysConstants.ROOT_PATH + "settings/").exists()) {
            this.qsOpenChooser.setCurrentDirectory(new File(SysConstants.ROOT_PATH + "settings/"));
            this.qsSaveChooser.setCurrentDirectory(new File(SysConstants.ROOT_PATH + "settings/"));
        } else {
            this.qsOpenChooser.setCurrentDirectory(new File(SysConstants.ROOT_PATH));
            this.qsSaveChooser.setCurrentDirectory(new File(SysConstants.ROOT_PATH));
        }
    }

    private void initialFormState() {
        this.goRemoveTradeEvosCheckBox.setEnabled(false);
        this.goUpdateMovesCheckBox.setEnabled(false);
        this.goUpdateMovesLegacyCheckBox.setEnabled(false);
        this.goCondenseEvosCheckBox.setEnabled(false);
        this.goRemoveTradeEvosCheckBox.setSelected(false);
        this.goUpdateMovesCheckBox.setSelected(false);
        this.goUpdateMovesLegacyCheckBox.setSelected(false);
        this.goCondenseEvosCheckBox.setSelected(false);
        this.goUpdateMovesLegacyCheckBox.setVisible(true);
        this.pokeLimitCB.setEnabled(false);
        this.pokeLimitCB.setSelected(false);
        this.pokeLimitBtn.setEnabled(false);
        this.pokeLimitBtn.setVisible(true);
        this.pokeLimitCB.setVisible(true);
        this.raceModeCB.setEnabled(false);
        this.raceModeCB.setSelected(false);
        this.brokenMovesCB.setEnabled(false);
        this.brokenMovesCB.setSelected(false);
        this.riRomNameLabel.setText(this.bundle.getString("RandomizerGUI.noRomLoaded"));
        this.riRomCodeLabel.setText("");
        this.riRomSupportLabel.setText("");
        this.loadQSButton.setEnabled(false);
        this.saveQSButton.setEnabled(false);
        this.pbsChangesUnchangedRB.setEnabled(false);
        this.pbsChangesRandomRB.setEnabled(false);
        this.pbsChangesShuffleRB.setEnabled(false);
        this.pbsChangesUnchangedRB.setSelected(true);
        this.pbsStandardEXPCurvesCB.setEnabled(false);
        this.pbsStandardEXPCurvesCB.setSelected(false);
        this.pbsFollowEvolutionsCB.setEnabled(false);
        this.pbsFollowEvolutionsCB.setSelected(false);
        this.pbsUpdateStatsCB.setEnabled(false);
        this.pbsUpdateStatsCB.setSelected(false);
        this.abilitiesPanel.setVisible(true);
        this.paUnchangedRB.setEnabled(false);
        this.paRandomizeRB.setEnabled(false);
        this.paWonderGuardCB.setEnabled(false);
        this.paFollowEvolutionsCB.setEnabled(false);
        this.paBanTrappingCB.setEnabled(false);
        this.paBanNegativeCB.setEnabled(false);
        this.paUnchangedRB.setSelected(true);
        this.paWonderGuardCB.setSelected(false);
        this.paFollowEvolutionsCB.setSelected(false);
        this.paBanTrappingCB.setSelected(false);
        this.paBanNegativeCB.setSelected(false);
        this.spCustomPoke1Chooser.setEnabled(false);
        this.spCustomPoke2Chooser.setEnabled(false);
        this.spCustomPoke3Chooser.setEnabled(false);
        this.spCustomPoke1Chooser.setSelectedIndex(0);
        this.spCustomPoke1Chooser.setModel(new DefaultComboBoxModel<String>(new String[]{"--"}));
        this.spCustomPoke2Chooser.setSelectedIndex(0);
        this.spCustomPoke2Chooser.setModel(new DefaultComboBoxModel<String>(new String[]{"--"}));
        this.spCustomPoke3Chooser.setSelectedIndex(0);
        this.spCustomPoke3Chooser.setModel(new DefaultComboBoxModel<String>(new String[]{"--"}));
        this.spCustomRB.setEnabled(false);
        this.spRandomRB.setEnabled(false);
        this.spRandom2EvosRB.setEnabled(false);
        this.spUnchangedRB.setEnabled(false);
        this.spUnchangedRB.setSelected(true);
        this.spHeldItemsCB.setEnabled(false);
        this.spHeldItemsCB.setSelected(false);
        this.spHeldItemsCB.setVisible(true);
        this.spHeldItemsBanBadCB.setEnabled(false);
        this.spHeldItemsBanBadCB.setSelected(false);
        this.spHeldItemsBanBadCB.setVisible(true);
        this.mdRandomAccuracyCB.setEnabled(false);
        this.mdRandomAccuracyCB.setSelected(false);
        this.mdRandomPowerCB.setEnabled(false);
        this.mdRandomPowerCB.setSelected(false);
        this.mdRandomPPCB.setEnabled(false);
        this.mdRandomPPCB.setSelected(false);
        this.mdRandomTypeCB.setEnabled(false);
        this.mdRandomTypeCB.setSelected(false);
        this.mdRandomCategoryCB.setEnabled(false);
        this.mdRandomCategoryCB.setSelected(false);
        this.mdRandomCategoryCB.setVisible(true);
        this.pmsRandomTotalRB.setEnabled(false);
        this.pmsRandomTypeRB.setEnabled(false);
        this.pmsUnchangedRB.setEnabled(false);
        this.pmsUnchangedRB.setSelected(true);
        this.pmsMetronomeOnlyRB.setEnabled(false);
        this.pms4MovesCB.setEnabled(false);
        this.pms4MovesCB.setSelected(false);
        this.pms4MovesCB.setVisible(true);
        this.pmsReorderDamagingMovesCB.setEnabled(false);
        this.pmsReorderDamagingMovesCB.setSelected(false);
        this.pmsForceGoodDamagingCB.setEnabled(false);
        this.pmsForceGoodDamagingCB.setSelected(false);
        this.pmsForceGoodDamagingSlider.setEnabled(false);
        this.pmsForceGoodDamagingSlider.setValue(this.pmsForceGoodDamagingSlider.getMinimum());
        this.ptRandomFollowEvosRB.setEnabled(false);
        this.ptRandomTotalRB.setEnabled(false);
        this.ptUnchangedRB.setEnabled(false);
        this.ptUnchangedRB.setSelected(true);
        this.tpPowerLevelsCB.setEnabled(false);
        this.tpRandomRB.setEnabled(false);
        this.tpRivalCarriesStarterCB.setEnabled(false);
        this.tpTypeThemedRB.setEnabled(false);
        this.tpTypeWeightingCB.setEnabled(false);
        this.tpNoLegendariesCB.setEnabled(false);
        this.tpNoEarlyShedinjaCB.setEnabled(false);
        this.tpNoEarlyShedinjaCB.setVisible(true);
        this.tpUnchangedRB.setEnabled(false);
        this.tpForceFullyEvolvedCB.setEnabled(false);
        this.tpForceFullyEvolvedSlider.setEnabled(false);
        this.tpLevelModifierCB.setEnabled(false);
        this.tpLevelModifierSlider.setEnabled(false);
        this.tpUnchangedRB.setSelected(true);
        this.tpPowerLevelsCB.setSelected(false);
        this.tpRivalCarriesStarterCB.setSelected(false);
        this.tpTypeWeightingCB.setSelected(false);
        this.tpNoLegendariesCB.setSelected(false);
        this.tpNoEarlyShedinjaCB.setSelected(false);
        this.tpForceFullyEvolvedCB.setSelected(false);
        this.tpForceFullyEvolvedSlider.setValue(this.tpForceFullyEvolvedSlider.getMinimum());
        this.tpLevelModifierCB.setSelected(false);
        this.tpLevelModifierSlider.setValue(0);
        this.tnRandomizeCB.setEnabled(false);
        this.tcnRandomizeCB.setEnabled(false);
        this.tnRandomizeCB.setSelected(false);
        this.tcnRandomizeCB.setSelected(false);
        this.tnRandomizeCB.setVisible(true);
        this.tcnRandomizeCB.setVisible(true);
        this.wpUnchangedRB.setEnabled(false);
        this.wpRandomRB.setEnabled(false);
        this.wpArea11RB.setEnabled(false);
        this.wpGlobalRB.setEnabled(false);
        this.wpUnchangedRB.setSelected(true);
        this.wpARNoneRB.setEnabled(false);
        this.wpARCatchEmAllRB.setEnabled(false);
        this.wpARTypeThemedRB.setEnabled(false);
        this.wpARSimilarStrengthRB.setEnabled(false);
        this.wpARNoneRB.setSelected(true);
        this.wpUseTimeCB.setEnabled(false);
        this.wpUseTimeCB.setVisible(true);
        this.wpUseTimeCB.setSelected(false);
        this.wpNoLegendariesCB.setEnabled(false);
        this.wpNoLegendariesCB.setSelected(false);
        this.wpCatchRateCB.setEnabled(false);
        this.wpCatchRateCB.setSelected(false);
        this.wpCatchRateSlider.setEnabled(false);
        this.wpCatchRateSlider.setValue(this.wpCatchRateSlider.getMinimum());
        this.wpHeldItemsCB.setEnabled(false);
        this.wpHeldItemsCB.setSelected(false);
        this.wpHeldItemsCB.setVisible(true);
        this.wpHeldItemsBanBadCB.setEnabled(false);
        this.wpHeldItemsBanBadCB.setSelected(false);
        this.wpHeldItemsBanBadCB.setVisible(true);
        this.stpRandomL4LRB.setEnabled(false);
        this.stpRandomTotalRB.setEnabled(false);
        this.stpUnchangedRB.setEnabled(false);
        this.stpUnchangedRB.setSelected(true);
        this.tmmRandomRB.setEnabled(false);
        this.tmmUnchangedRB.setEnabled(false);
        this.tmmUnchangedRB.setSelected(true);
        this.thcRandomTotalRB.setEnabled(false);
        this.thcRandomTypeRB.setEnabled(false);
        this.thcUnchangedRB.setEnabled(false);
        this.thcFullRB.setEnabled(false);
        this.thcUnchangedRB.setSelected(true);
        this.tmLearningSanityCB.setEnabled(false);
        this.tmLearningSanityCB.setSelected(false);
        this.tmKeepFieldMovesCB.setEnabled(false);
        this.tmKeepFieldMovesCB.setSelected(false);
        this.tmFullHMCompatCB.setEnabled(false);
        this.tmFullHMCompatCB.setSelected(false);
        this.tmForceGoodDamagingCB.setEnabled(false);
        this.tmForceGoodDamagingCB.setSelected(false);
        this.tmForceGoodDamagingSlider.setEnabled(false);
        this.tmForceGoodDamagingSlider.setValue(this.tmForceGoodDamagingSlider.getMinimum());
        this.mtmRandomRB.setEnabled(false);
        this.mtmUnchangedRB.setEnabled(false);
        this.mtmUnchangedRB.setSelected(true);
        this.mtcRandomTotalRB.setEnabled(false);
        this.mtcRandomTypeRB.setEnabled(false);
        this.mtcUnchangedRB.setEnabled(false);
        this.mtcFullRB.setEnabled(false);
        this.mtcUnchangedRB.setSelected(true);
        this.mtLearningSanityCB.setEnabled(false);
        this.mtLearningSanityCB.setSelected(false);
        this.mtKeepFieldMovesCB.setEnabled(false);
        this.mtKeepFieldMovesCB.setSelected(false);
        this.mtForceGoodDamagingCB.setEnabled(false);
        this.mtForceGoodDamagingCB.setSelected(false);
        this.mtForceGoodDamagingSlider.setEnabled(false);
        this.mtForceGoodDamagingSlider.setValue(this.mtForceGoodDamagingSlider.getMinimum());
        this.mtMovesPanel.setVisible(true);
        this.mtCompatPanel.setVisible(true);
        this.mtNoExistLabel.setVisible(false);
        this.igtUnchangedRB.setEnabled(false);
        this.igtGivenOnlyRB.setEnabled(false);
        this.igtBothRB.setEnabled(false);
        this.igtUnchangedRB.setSelected(true);
        this.igtRandomItemCB.setEnabled(false);
        this.igtRandomItemCB.setSelected(false);
        this.igtRandomItemCB.setVisible(true);
        this.igtRandomIVsCB.setEnabled(false);
        this.igtRandomIVsCB.setSelected(false);
        this.igtRandomIVsCB.setVisible(true);
        this.igtRandomOTCB.setEnabled(false);
        this.igtRandomOTCB.setSelected(false);
        this.igtRandomOTCB.setVisible(true);
        this.igtRandomNicknameCB.setEnabled(false);
        this.igtRandomNicknameCB.setSelected(false);
        this.fiUnchangedRB.setEnabled(false);
        this.fiShuffleRB.setEnabled(false);
        this.fiRandomRB.setEnabled(false);
        this.fiUnchangedRB.setSelected(true);
        this.fiBanBadCB.setEnabled(false);
        this.fiBanBadCB.setSelected(false);
        this.fiBanBadCB.setVisible(true);
        this.peUnchangedRB.setSelected(true);
        this.peUnchangedRB.setEnabled(false);
        this.peRandomRB.setEnabled(false);
        this.peForceChangeCB.setSelected(false);
        this.peForceChangeCB.setEnabled(false);
        this.peThreeStagesCB.setSelected(false);
        this.peThreeStagesCB.setEnabled(false);
        this.peSameTypeCB.setSelected(false);
        this.peSameTypeCB.setEnabled(false);
        this.peSimilarStrengthCB.setSelected(false);
        this.peSimilarStrengthCB.setEnabled(false);
        for (JCheckBox cb : this.tweakCheckboxes) {
            cb.setVisible(true);
            cb.setEnabled(false);
            cb.setSelected(false);
        }
        this.mtNoneAvailableLabel.setVisible(false);
        this.miscTweaksPanel.setLayout(this.makeTweaksLayout(this.tweakCheckboxes));
        this.gameMascotLabel.setIcon(this.emptyIcon);
    }

    private void loadROM() {
        this.romOpenChooser.setSelectedFile(null);
        int returnVal = this.romOpenChooser.showOpenDialog(this);
        if (returnVal == 0) {
            final File fh = this.romOpenChooser.getSelectedFile();
            try {
                Utils.validateRomFile(fh);
            }
            catch (Utils.InvalidROMException e) {
                switch (e.getType()) {
                    case LENGTH: {
                        JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.tooShortToBeARom"), fh.getName()));
                        return;
                    }
                    case ZIP_FILE: {
                        JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.openedZIPfile"), fh.getName()));
                        return;
                    }
                    case RAR_FILE: {
                        JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.openedRARfile"), fh.getName()));
                        return;
                    }
                    case IPS_FILE: {
                        JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.openedIPSfile"), fh.getName()));
                        return;
                    }
                    case UNREADABLE: {
                        JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.unreadableRom"), fh.getName()));
                        return;
                    }
                }
            }
            for (RomHandler.Factory rhf : this.checkHandlers) {
                if (!rhf.isLoadable(fh.getAbsolutePath())) continue;
                this.romHandler = rhf.create(RandomSource.instance());
                this.opDialog = new OperationDialog(this.bundle.getString("RandomizerGUI.loadingText"), this, true);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        boolean romLoaded = false;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RandomizerGUI.this.opDialog.setVisible(true);
                            }
                        });
                        try {
                            RandomizerGUI.this.romHandler.loadRom(fh.getAbsolutePath());
                            romLoaded = true;
                        }
                        catch (Exception ex) {
                            RandomizerGUI.this.attemptToLogException(ex, "RandomizerGUI.loadFailed", "RandomizerGUI.loadFailedNoLog");
                        }
                        final boolean loadSuccess = romLoaded;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RandomizerGUI.this.opDialog.setVisible(false);
                                RandomizerGUI.this.initialFormState();
                                if (loadSuccess) {
                                    RandomizerGUI.this.romLoaded();
                                }
                            }
                        });
                    }
                };
                t.start();
                return;
            }
            JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.unsupportedRom"), fh.getName()));
        }
    }

    private void romLoaded() {
        try {
            this.currentRestrictions = null;
            this.riRomNameLabel.setText(this.romHandler.getROMName());
            this.riRomCodeLabel.setText(this.romHandler.getROMCode());
            this.riRomSupportLabel.setText(this.bundle.getString("RandomizerGUI.romSupportPrefix") + " " + this.romHandler.getSupportLevel());
            this.goUpdateMovesCheckBox.setSelected(false);
            this.goUpdateMovesCheckBox.setSelected(false);
            this.goUpdateMovesCheckBox.setEnabled(true);
            this.goUpdateMovesLegacyCheckBox.setSelected(false);
            this.goUpdateMovesLegacyCheckBox.setEnabled(false);
            this.goUpdateMovesLegacyCheckBox.setVisible(!(this.romHandler instanceof Gen5RomHandler));
            this.goRemoveTradeEvosCheckBox.setSelected(false);
            this.goRemoveTradeEvosCheckBox.setEnabled(true);
            this.goCondenseEvosCheckBox.setSelected(false);
            this.goCondenseEvosCheckBox.setEnabled(true);
            this.raceModeCB.setSelected(false);
            this.raceModeCB.setEnabled(true);
            this.pokeLimitCB.setSelected(false);
            this.pokeLimitBtn.setEnabled(false);
            this.pokeLimitCB.setEnabled(!(this.romHandler instanceof Gen1RomHandler) && !this.romHandler.isROMHack());
            this.pokeLimitCB.setVisible(!(this.romHandler instanceof Gen1RomHandler) && !this.romHandler.isROMHack());
            this.pokeLimitBtn.setVisible(!(this.romHandler instanceof Gen1RomHandler) && !this.romHandler.isROMHack());
            this.brokenMovesCB.setSelected(false);
            this.brokenMovesCB.setEnabled(true);
            this.loadQSButton.setEnabled(true);
            this.saveQSButton.setEnabled(true);
            this.pbsChangesUnchangedRB.setEnabled(true);
            this.pbsChangesUnchangedRB.setSelected(true);
            this.pbsChangesRandomRB.setEnabled(true);
            this.pbsChangesShuffleRB.setEnabled(true);
            this.pbsStandardEXPCurvesCB.setEnabled(true);
            this.pbsStandardEXPCurvesCB.setSelected(false);
            this.pbsUpdateStatsCB.setEnabled(this.romHandler.generationOfPokemon() < 6);
            this.pbsUpdateStatsCB.setSelected(false);
            if (this.romHandler.abilitiesPerPokemon() > 0) {
                this.paUnchangedRB.setEnabled(true);
                this.paUnchangedRB.setSelected(true);
                this.paRandomizeRB.setEnabled(true);
                this.paWonderGuardCB.setEnabled(false);
                this.paFollowEvolutionsCB.setEnabled(false);
            } else {
                this.abilitiesPanel.setVisible(false);
            }
            this.spUnchangedRB.setEnabled(true);
            this.spUnchangedRB.setSelected(true);
            this.spCustomPoke3Chooser.setVisible(true);
            if (this.romHandler.canChangeStarters()) {
                this.spCustomRB.setEnabled(true);
                this.spRandomRB.setEnabled(true);
                this.spRandom2EvosRB.setEnabled(true);
                if (this.romHandler.isYellow()) {
                    this.spCustomPoke3Chooser.setVisible(false);
                }
                this.populateDropdowns();
            }
            this.spHeldItemsCB.setSelected(false);
            boolean hasStarterHeldItems = this.romHandler instanceof Gen2RomHandler || this.romHandler instanceof Gen3RomHandler;
            this.spHeldItemsCB.setEnabled(hasStarterHeldItems);
            this.spHeldItemsCB.setVisible(hasStarterHeldItems);
            this.spHeldItemsBanBadCB.setEnabled(false);
            this.spHeldItemsBanBadCB.setVisible(hasStarterHeldItems);
            this.mdRandomAccuracyCB.setEnabled(true);
            this.mdRandomPowerCB.setEnabled(true);
            this.mdRandomPPCB.setEnabled(true);
            this.mdRandomTypeCB.setEnabled(true);
            this.mdRandomCategoryCB.setEnabled(this.romHandler.hasPhysicalSpecialSplit());
            this.mdRandomCategoryCB.setVisible(this.romHandler.hasPhysicalSpecialSplit());
            this.pmsRandomTotalRB.setEnabled(true);
            this.pmsRandomTypeRB.setEnabled(true);
            this.pmsUnchangedRB.setEnabled(true);
            this.pmsUnchangedRB.setSelected(true);
            this.pmsMetronomeOnlyRB.setEnabled(true);
            this.pms4MovesCB.setVisible(this.romHandler.supportsFourStartingMoves());
            this.ptRandomFollowEvosRB.setEnabled(true);
            this.ptRandomTotalRB.setEnabled(true);
            this.ptUnchangedRB.setEnabled(true);
            this.ptUnchangedRB.setSelected(true);
            this.tpRandomRB.setEnabled(true);
            this.tpTypeThemedRB.setEnabled(true);
            this.tpUnchangedRB.setEnabled(true);
            this.tpUnchangedRB.setSelected(true);
            this.tnRandomizeCB.setEnabled(this.romHandler.canChangeTrainerText());
            this.tcnRandomizeCB.setEnabled(this.romHandler.canChangeTrainerText());
            this.tnRandomizeCB.setVisible(this.romHandler.canChangeTrainerText());
            this.tcnRandomizeCB.setVisible(this.romHandler.canChangeTrainerText());
            if (this.romHandler.generationOfPokemon() < 3) {
                this.tpNoEarlyShedinjaCB.setVisible(false);
            } else {
                this.tpNoEarlyShedinjaCB.setVisible(true);
            }
            this.tpNoEarlyShedinjaCB.setSelected(false);
            this.wpArea11RB.setEnabled(true);
            this.wpGlobalRB.setEnabled(true);
            this.wpRandomRB.setEnabled(true);
            this.wpUnchangedRB.setEnabled(true);
            this.wpUnchangedRB.setSelected(true);
            this.wpUseTimeCB.setEnabled(false);
            this.wpNoLegendariesCB.setEnabled(false);
            if (!this.romHandler.hasTimeBasedEncounters()) {
                this.wpUseTimeCB.setVisible(false);
            }
            this.wpCatchRateCB.setEnabled(true);
            this.wpHeldItemsCB.setSelected(false);
            this.wpHeldItemsCB.setEnabled(true);
            this.wpHeldItemsCB.setVisible(true);
            this.wpHeldItemsBanBadCB.setSelected(false);
            this.wpHeldItemsBanBadCB.setEnabled(false);
            this.wpHeldItemsBanBadCB.setVisible(true);
            if (this.romHandler instanceof Gen1RomHandler) {
                this.wpHeldItemsCB.setVisible(false);
                this.wpHeldItemsBanBadCB.setVisible(false);
            }
            this.stpUnchangedRB.setEnabled(true);
            if (this.romHandler.canChangeStaticPokemon()) {
                this.stpRandomL4LRB.setEnabled(true);
                this.stpRandomTotalRB.setEnabled(true);
            }
            this.tmmRandomRB.setEnabled(true);
            this.tmmUnchangedRB.setEnabled(true);
            this.tmFullHMCompatCB.setEnabled(true);
            this.thcRandomTotalRB.setEnabled(true);
            this.thcRandomTypeRB.setEnabled(true);
            this.thcUnchangedRB.setEnabled(true);
            this.thcFullRB.setEnabled(true);
            if (this.romHandler.hasMoveTutors()) {
                this.mtmRandomRB.setEnabled(true);
                this.mtmUnchangedRB.setEnabled(true);
                this.mtcRandomTotalRB.setEnabled(true);
                this.mtcRandomTypeRB.setEnabled(true);
                this.mtcUnchangedRB.setEnabled(true);
                this.mtcFullRB.setEnabled(true);
            } else {
                this.mtCompatPanel.setVisible(false);
                this.mtMovesPanel.setVisible(false);
                this.mtNoExistLabel.setVisible(true);
            }
            this.igtUnchangedRB.setEnabled(true);
            this.igtBothRB.setEnabled(true);
            this.igtGivenOnlyRB.setEnabled(true);
            if (this.romHandler instanceof Gen1RomHandler) {
                this.igtRandomItemCB.setVisible(false);
                this.igtRandomIVsCB.setVisible(false);
                this.igtRandomOTCB.setVisible(false);
            }
            this.fiUnchangedRB.setEnabled(true);
            this.fiRandomRB.setEnabled(true);
            this.fiShuffleRB.setEnabled(true);
            this.fiBanBadCB.setEnabled(false);
            this.fiBanBadCB.setSelected(false);
            this.peUnchangedRB.setEnabled(true);
            this.peUnchangedRB.setSelected(true);
            this.peRandomRB.setEnabled(true);
            int mtsAvailable = this.romHandler.miscTweaksAvailable();
            int mtCount = MiscTweak.allTweaks.size();
            ArrayList<JCheckBox> usableCheckboxes = new ArrayList<JCheckBox>();
            for (int mti = 0; mti < mtCount; ++mti) {
                MiscTweak mt = MiscTweak.allTweaks.get(mti);
                JCheckBox mtCB = this.tweakCheckboxes.get(mti);
                mtCB.setSelected(false);
                if ((mtsAvailable & mt.getValue()) != 0) {
                    mtCB.setVisible(true);
                    mtCB.setEnabled(true);
                    usableCheckboxes.add(mtCB);
                    continue;
                }
                mtCB.setVisible(false);
                mtCB.setEnabled(false);
            }
            if (usableCheckboxes.size() > 0) {
                this.mtNoneAvailableLabel.setVisible(false);
                this.miscTweaksPanel.setLayout(this.makeTweaksLayout(usableCheckboxes));
            } else {
                this.mtNoneAvailableLabel.setVisible(true);
                this.miscTweaksPanel.setLayout(this.noTweaksLayout);
            }
            this.gameMascotLabel.setIcon(this.makeMascotIcon());
            if (this.romHandler instanceof AbstractDSRomHandler) {
                ((AbstractDSRomHandler)this.romHandler).closeInnerRom();
            }
        }
        catch (Exception ex) {
            this.attemptToLogException(ex, "RandomizerGUI.processFailed", "RandomizerGUI.processFailedNoLog");
            this.romHandler = null;
            this.initialFormState();
        }
    }

    private ImageIcon makeMascotIcon() {
        try {
            BufferedImage handlerImg = this.romHandler.getMascotImage();
            if (handlerImg == null) {
                return this.emptyIcon;
            }
            BufferedImage nImg = new BufferedImage(128, 128, 2);
            int hW = handlerImg.getWidth();
            int hH = handlerImg.getHeight();
            nImg.getGraphics().drawImage(handlerImg, 64 - hW / 2, 64 - hH / 2, this);
            return new ImageIcon(nImg);
        }
        catch (Exception ex) {
            return this.emptyIcon;
        }
    }

    private void populateDropdowns() {
        List<Pokemon> currentStarters = this.romHandler.getStarters();
        List<Pokemon> allPokes = this.romHandler.getPokemon();
        String[] pokeNames = new String[allPokes.size() - 1];
        for (int i = 1; i < allPokes.size(); ++i) {
            pokeNames[i - 1] = allPokes.get((int)i).name;
        }
        this.spCustomPoke1Chooser.setModel(new DefaultComboBoxModel<String>(pokeNames));
        this.spCustomPoke1Chooser.setSelectedIndex(allPokes.indexOf(currentStarters.get(0)) - 1);
        this.spCustomPoke2Chooser.setModel(new DefaultComboBoxModel<String>(pokeNames));
        this.spCustomPoke2Chooser.setSelectedIndex(allPokes.indexOf(currentStarters.get(1)) - 1);
        if (!this.romHandler.isYellow()) {
            this.spCustomPoke3Chooser.setModel(new DefaultComboBoxModel<String>(pokeNames));
            this.spCustomPoke3Chooser.setSelectedIndex(allPokes.indexOf(currentStarters.get(2)) - 1);
        }
    }

    private void enableOrDisableSubControls() {
        if (this.goUpdateMovesCheckBox.isSelected() && !(this.romHandler instanceof Gen5RomHandler)) {
            this.goUpdateMovesLegacyCheckBox.setEnabled(true);
        } else {
            this.goUpdateMovesLegacyCheckBox.setEnabled(false);
            this.goUpdateMovesLegacyCheckBox.setSelected(false);
        }
        this.pokeLimitBtn.setEnabled(this.pokeLimitCB.isSelected());
        if (this.spCustomRB.isSelected()) {
            this.spCustomPoke1Chooser.setEnabled(true);
            this.spCustomPoke2Chooser.setEnabled(true);
            this.spCustomPoke3Chooser.setEnabled(true);
        } else {
            this.spCustomPoke1Chooser.setEnabled(false);
            this.spCustomPoke2Chooser.setEnabled(false);
            this.spCustomPoke3Chooser.setEnabled(false);
        }
        if (this.pbsChangesUnchangedRB.isSelected()) {
            this.pbsFollowEvolutionsCB.setEnabled(false);
            this.pbsFollowEvolutionsCB.setSelected(false);
        } else {
            this.pbsFollowEvolutionsCB.setEnabled(true);
        }
        if (this.spHeldItemsCB.isSelected() && this.spHeldItemsCB.isVisible() && this.spHeldItemsCB.isEnabled()) {
            this.spHeldItemsBanBadCB.setEnabled(true);
        } else {
            this.spHeldItemsBanBadCB.setEnabled(false);
            this.spHeldItemsBanBadCB.setSelected(false);
        }
        if (this.paRandomizeRB.isSelected()) {
            this.paWonderGuardCB.setEnabled(true);
            this.paFollowEvolutionsCB.setEnabled(true);
            this.paBanTrappingCB.setEnabled(true);
            this.paBanNegativeCB.setEnabled(true);
        } else {
            this.paWonderGuardCB.setEnabled(false);
            this.paWonderGuardCB.setSelected(false);
            this.paFollowEvolutionsCB.setEnabled(false);
            this.paFollowEvolutionsCB.setSelected(false);
            this.paBanTrappingCB.setEnabled(false);
            this.paBanTrappingCB.setSelected(false);
            this.paBanNegativeCB.setEnabled(false);
            this.paBanNegativeCB.setSelected(false);
        }
        if (this.tpUnchangedRB.isSelected()) {
            this.tpPowerLevelsCB.setEnabled(false);
            this.tpNoLegendariesCB.setEnabled(false);
            this.tpNoEarlyShedinjaCB.setEnabled(false);
            this.tpNoEarlyShedinjaCB.setSelected(false);
            this.tpForceFullyEvolvedCB.setEnabled(false);
            this.tpForceFullyEvolvedCB.setSelected(false);
            this.tpLevelModifierCB.setEnabled(false);
            this.tpLevelModifierCB.setSelected(false);
        } else {
            this.tpPowerLevelsCB.setEnabled(true);
            this.tpNoLegendariesCB.setEnabled(true);
            this.tpNoEarlyShedinjaCB.setEnabled(true);
            this.tpForceFullyEvolvedCB.setEnabled(true);
            this.tpLevelModifierCB.setEnabled(true);
        }
        if (this.tpForceFullyEvolvedCB.isSelected()) {
            this.tpForceFullyEvolvedSlider.setEnabled(true);
        } else {
            this.tpForceFullyEvolvedSlider.setEnabled(false);
            this.tpForceFullyEvolvedSlider.setValue(this.tpForceFullyEvolvedSlider.getMinimum());
        }
        if (this.tpLevelModifierCB.isSelected()) {
            this.tpLevelModifierSlider.setEnabled(true);
        } else {
            this.tpLevelModifierSlider.setEnabled(false);
            this.tpLevelModifierSlider.setValue(0);
        }
        if (!this.spUnchangedRB.isSelected() || !this.tpUnchangedRB.isSelected()) {
            this.tpRivalCarriesStarterCB.setEnabled(true);
        } else {
            this.tpRivalCarriesStarterCB.setEnabled(false);
            this.tpRivalCarriesStarterCB.setSelected(false);
        }
        if (this.tpTypeThemedRB.isSelected()) {
            this.tpTypeWeightingCB.setEnabled(true);
        } else {
            this.tpTypeWeightingCB.setEnabled(false);
        }
        if (this.wpArea11RB.isSelected() || this.wpRandomRB.isSelected()) {
            this.wpARNoneRB.setEnabled(true);
            this.wpARSimilarStrengthRB.setEnabled(true);
            this.wpARCatchEmAllRB.setEnabled(true);
            this.wpARTypeThemedRB.setEnabled(true);
        } else if (this.wpGlobalRB.isSelected()) {
            if (this.wpARCatchEmAllRB.isSelected() || this.wpARTypeThemedRB.isSelected()) {
                this.wpARNoneRB.setSelected(true);
            }
            this.wpARNoneRB.setEnabled(true);
            this.wpARSimilarStrengthRB.setEnabled(true);
            this.wpARCatchEmAllRB.setEnabled(false);
            this.wpARTypeThemedRB.setEnabled(false);
        } else {
            this.wpARNoneRB.setEnabled(false);
            this.wpARSimilarStrengthRB.setEnabled(false);
            this.wpARCatchEmAllRB.setEnabled(false);
            this.wpARTypeThemedRB.setEnabled(false);
            this.wpARNoneRB.setSelected(true);
        }
        if (this.wpUnchangedRB.isSelected()) {
            this.wpUseTimeCB.setEnabled(false);
            this.wpNoLegendariesCB.setEnabled(false);
        } else {
            this.wpUseTimeCB.setEnabled(true);
            this.wpNoLegendariesCB.setEnabled(true);
        }
        if (this.wpHeldItemsCB.isSelected() && this.wpHeldItemsCB.isVisible() && this.wpHeldItemsCB.isEnabled()) {
            this.wpHeldItemsBanBadCB.setEnabled(true);
        } else {
            this.wpHeldItemsBanBadCB.setEnabled(false);
            this.wpHeldItemsBanBadCB.setSelected(false);
        }
        if (this.wpCatchRateCB.isSelected()) {
            this.wpCatchRateSlider.setEnabled(true);
        } else {
            this.wpCatchRateSlider.setEnabled(false);
            this.wpCatchRateSlider.setValue(this.wpCatchRateSlider.getMinimum());
        }
        if (this.igtUnchangedRB.isSelected()) {
            this.igtRandomItemCB.setEnabled(false);
            this.igtRandomIVsCB.setEnabled(false);
            this.igtRandomNicknameCB.setEnabled(false);
            this.igtRandomOTCB.setEnabled(false);
        } else {
            this.igtRandomItemCB.setEnabled(true);
            this.igtRandomIVsCB.setEnabled(true);
            this.igtRandomNicknameCB.setEnabled(true);
            this.igtRandomOTCB.setEnabled(true);
        }
        if (this.pmsMetronomeOnlyRB.isSelected()) {
            this.tmmUnchangedRB.setEnabled(false);
            this.tmmRandomRB.setEnabled(false);
            this.tmmUnchangedRB.setSelected(true);
            this.mtmUnchangedRB.setEnabled(false);
            this.mtmRandomRB.setEnabled(false);
            this.mtmUnchangedRB.setSelected(true);
            this.tmLearningSanityCB.setEnabled(false);
            this.tmLearningSanityCB.setSelected(false);
            this.tmKeepFieldMovesCB.setEnabled(false);
            this.tmKeepFieldMovesCB.setSelected(false);
            this.tmForceGoodDamagingCB.setEnabled(false);
            this.tmForceGoodDamagingCB.setSelected(false);
            this.mtLearningSanityCB.setEnabled(false);
            this.mtLearningSanityCB.setSelected(false);
            this.mtKeepFieldMovesCB.setEnabled(false);
            this.mtKeepFieldMovesCB.setSelected(false);
            this.mtForceGoodDamagingCB.setEnabled(false);
            this.mtForceGoodDamagingCB.setSelected(false);
        } else {
            this.tmmUnchangedRB.setEnabled(true);
            this.tmmRandomRB.setEnabled(true);
            this.mtmUnchangedRB.setEnabled(true);
            this.mtmRandomRB.setEnabled(true);
            if (!(this.pmsUnchangedRB.isSelected() && this.tmmUnchangedRB.isSelected() && this.thcUnchangedRB.isSelected())) {
                this.tmLearningSanityCB.setEnabled(true);
            } else {
                this.tmLearningSanityCB.setEnabled(false);
                this.tmLearningSanityCB.setSelected(false);
            }
            if (!this.tmmUnchangedRB.isSelected()) {
                this.tmKeepFieldMovesCB.setEnabled(true);
                this.tmForceGoodDamagingCB.setEnabled(true);
            } else {
                this.tmKeepFieldMovesCB.setEnabled(false);
                this.tmKeepFieldMovesCB.setSelected(false);
                this.tmForceGoodDamagingCB.setEnabled(false);
                this.tmForceGoodDamagingCB.setSelected(false);
            }
            if (!(!this.romHandler.hasMoveTutors() || this.pmsUnchangedRB.isSelected() && this.mtmUnchangedRB.isSelected() && this.mtcUnchangedRB.isSelected())) {
                this.mtLearningSanityCB.setEnabled(true);
            } else {
                this.mtLearningSanityCB.setEnabled(false);
                this.mtLearningSanityCB.setSelected(false);
            }
            if (this.romHandler.hasMoveTutors() && !this.mtmUnchangedRB.isSelected()) {
                this.mtKeepFieldMovesCB.setEnabled(true);
                this.mtForceGoodDamagingCB.setEnabled(true);
            } else {
                this.mtKeepFieldMovesCB.setEnabled(false);
                this.mtKeepFieldMovesCB.setSelected(false);
                this.mtForceGoodDamagingCB.setEnabled(false);
                this.mtForceGoodDamagingCB.setSelected(false);
            }
        }
        if (this.tmForceGoodDamagingCB.isSelected()) {
            this.tmForceGoodDamagingSlider.setEnabled(true);
        } else {
            this.tmForceGoodDamagingSlider.setEnabled(false);
            this.tmForceGoodDamagingSlider.setValue(this.tmForceGoodDamagingSlider.getMinimum());
        }
        if (this.mtForceGoodDamagingCB.isSelected()) {
            this.mtForceGoodDamagingSlider.setEnabled(true);
        } else {
            this.mtForceGoodDamagingSlider.setEnabled(false);
            this.mtForceGoodDamagingSlider.setValue(this.mtForceGoodDamagingSlider.getMinimum());
        }
        this.tmFullHMCompatCB.setEnabled(!this.thcFullRB.isSelected());
        if (this.pmsMetronomeOnlyRB.isSelected() || this.pmsUnchangedRB.isSelected()) {
            this.pms4MovesCB.setEnabled(false);
            this.pms4MovesCB.setSelected(false);
            this.pmsForceGoodDamagingCB.setEnabled(false);
            this.pmsForceGoodDamagingCB.setSelected(false);
            this.pmsReorderDamagingMovesCB.setEnabled(false);
            this.pmsReorderDamagingMovesCB.setSelected(false);
        } else {
            this.pms4MovesCB.setEnabled(true);
            this.pmsForceGoodDamagingCB.setEnabled(true);
            this.pmsReorderDamagingMovesCB.setEnabled(true);
        }
        if (this.pmsForceGoodDamagingCB.isSelected()) {
            this.pmsForceGoodDamagingSlider.setEnabled(true);
        } else {
            this.pmsForceGoodDamagingSlider.setEnabled(false);
            this.pmsForceGoodDamagingSlider.setValue(this.pmsForceGoodDamagingSlider.getMinimum());
        }
        if (this.fiRandomRB.isSelected() && this.fiRandomRB.isVisible() && this.fiRandomRB.isEnabled()) {
            this.fiBanBadCB.setEnabled(true);
        } else {
            this.fiBanBadCB.setEnabled(false);
            this.fiBanBadCB.setSelected(false);
        }
        this.peForceChangeCB.setEnabled(this.peRandomRB.isSelected());
        this.peThreeStagesCB.setEnabled(this.peRandomRB.isSelected());
        this.peSameTypeCB.setEnabled(this.peRandomRB.isSelected());
        this.peSimilarStrengthCB.setEnabled(this.peRandomRB.isSelected());
    }

    private void saveROM() {
        if (this.romHandler == null) {
            return;
        }
        if (this.raceModeCB.isSelected() && this.tpUnchangedRB.isSelected() && this.wpUnchangedRB.isSelected()) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.raceModeRequirements"));
            return;
        }
        if (this.pokeLimitCB.isSelected() && (this.currentRestrictions == null || this.currentRestrictions.nothingSelected())) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.pokeLimitNotChosen"));
            return;
        }
        this.romSaveChooser.setSelectedFile(null);
        int returnVal = this.romSaveChooser.showSaveDialog(this);
        if (returnVal == 0) {
            String currentFN;
            File fh = this.romSaveChooser.getSelectedFile();
            ArrayList<String> extensions = new ArrayList<String>(Arrays.asList("sgb", "gbc", "gba", "nds"));
            extensions.remove(this.romHandler.getDefaultExtension());
            fh = FileFunctions.fixFilename(fh, this.romHandler.getDefaultExtension(), extensions);
            boolean allowed = true;
            if (this.romHandler instanceof AbstractDSRomHandler && (currentFN = this.romHandler.loadedFilename()).equals(fh.getAbsolutePath())) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.cantOverwriteDS"));
                allowed = false;
            }
            if (allowed) {
                long seed = RandomSource.pickSeed();
                RandomSource.seed(seed);
                this.presetMode = false;
                try {
                    CustomNamesSet cns = FileFunctions.getCustomNames();
                    this.performRandomization(fh.getAbsolutePath(), seed, cns);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.cantLoadCustomNames"));
                }
            }
        }
    }

    private Settings getCurrentSettings() throws IOException {
        Settings settings = this.createSettingsFromState(FileFunctions.getCustomNames());
        return settings;
    }

    public String getValidRequiredROMName(String config, CustomNamesSet customNames) throws UnsupportedEncodingException, InvalidSupplementFilesException {
        try {
            Utils.validatePresetSupplementFiles(config, customNames);
        }
        catch (InvalidSupplementFilesException e) {
            switch (e.getType()) {
                case CUSTOM_NAMES: {
                    JOptionPane.showMessageDialog(null, this.bundle.getString("RandomizerGUI.presetFailTrainerNames"));
                    throw e;
                }
            }
            throw e;
        }
        byte[] data = DatatypeConverter.parseBase64Binary((String)config);
        int nameLength = data[36] & 0xFF;
        if (data.length != 45 + nameLength) {
            return null;
        }
        String name = new String(data, 37, nameLength, "US-ASCII");
        return name;
    }

    private void restoreStateFromSettings(Settings settings) {
        this.goRemoveTradeEvosCheckBox.setSelected(settings.isChangeImpossibleEvolutions());
        this.goUpdateMovesCheckBox.setSelected(settings.isUpdateMoves());
        this.goUpdateMovesLegacyCheckBox.setSelected(settings.isUpdateMovesLegacy());
        this.tnRandomizeCB.setSelected(settings.isRandomizeTrainerNames());
        this.tcnRandomizeCB.setSelected(settings.isRandomizeTrainerClassNames());
        this.pbsChangesRandomRB.setSelected(settings.getBaseStatisticsMod() == Settings.BaseStatisticsMod.RANDOM);
        this.pbsChangesShuffleRB.setSelected(settings.getBaseStatisticsMod() == Settings.BaseStatisticsMod.SHUFFLE);
        this.pbsChangesUnchangedRB.setSelected(settings.getBaseStatisticsMod() == Settings.BaseStatisticsMod.UNCHANGED);
        this.pbsStandardEXPCurvesCB.setSelected(settings.isStandardizeEXPCurves());
        this.pbsFollowEvolutionsCB.setSelected(settings.isBaseStatsFollowEvolutions());
        this.pbsUpdateStatsCB.setSelected(settings.isUpdateBaseStats());
        this.paUnchangedRB.setSelected(settings.getAbilitiesMod() == Settings.AbilitiesMod.UNCHANGED);
        this.paRandomizeRB.setSelected(settings.getAbilitiesMod() == Settings.AbilitiesMod.RANDOMIZE);
        this.paWonderGuardCB.setSelected(settings.isAllowWonderGuard());
        this.paFollowEvolutionsCB.setSelected(settings.isAbilitiesFollowEvolutions());
        this.paBanTrappingCB.setSelected(settings.isBanTrappingAbilities());
        this.paBanNegativeCB.setSelected(settings.isBanNegativeAbilities());
        this.ptRandomFollowEvosRB.setSelected(settings.getTypesMod() == Settings.TypesMod.RANDOM_FOLLOW_EVOLUTIONS);
        this.ptRandomTotalRB.setSelected(settings.getTypesMod() == Settings.TypesMod.COMPLETELY_RANDOM);
        this.ptUnchangedRB.setSelected(settings.getTypesMod() == Settings.TypesMod.UNCHANGED);
        this.raceModeCB.setSelected(settings.isRaceMode());
        this.brokenMovesCB.setSelected(settings.doBlockBrokenMoves());
        this.pokeLimitCB.setSelected(settings.isLimitPokemon());
        this.goCondenseEvosCheckBox.setSelected(settings.isMakeEvolutionsEasier());
        this.spCustomRB.setSelected(settings.getStartersMod() == Settings.StartersMod.CUSTOM);
        this.spRandomRB.setSelected(settings.getStartersMod() == Settings.StartersMod.COMPLETELY_RANDOM);
        this.spUnchangedRB.setSelected(settings.getStartersMod() == Settings.StartersMod.UNCHANGED);
        this.spRandom2EvosRB.setSelected(settings.getStartersMod() == Settings.StartersMod.RANDOM_WITH_TWO_EVOLUTIONS);
        this.spHeldItemsCB.setSelected(settings.isRandomizeStartersHeldItems());
        this.spHeldItemsBanBadCB.setSelected(settings.isBanBadRandomStarterHeldItems());
        int[] customStarters = settings.getCustomStarters();
        this.spCustomPoke1Chooser.setSelectedIndex(customStarters[0] - 1);
        this.spCustomPoke2Chooser.setSelectedIndex(customStarters[1] - 1);
        this.spCustomPoke3Chooser.setSelectedIndex(customStarters[2] - 1);
        this.peUnchangedRB.setSelected(settings.getEvolutionsMod() == Settings.EvolutionsMod.UNCHANGED);
        this.peRandomRB.setSelected(settings.getEvolutionsMod() == Settings.EvolutionsMod.RANDOM);
        this.peSimilarStrengthCB.setSelected(settings.isEvosSimilarStrength());
        this.peSameTypeCB.setSelected(settings.isEvosSameTyping());
        this.peThreeStagesCB.setSelected(settings.isEvosMaxThreeStages());
        this.peForceChangeCB.setSelected(settings.isEvosForceChange());
        this.mdRandomAccuracyCB.setSelected(settings.isRandomizeMoveAccuracies());
        this.mdRandomCategoryCB.setSelected(settings.isRandomizeMoveCategory());
        this.mdRandomPowerCB.setSelected(settings.isRandomizeMovePowers());
        this.mdRandomPPCB.setSelected(settings.isRandomizeMovePPs());
        this.mdRandomTypeCB.setSelected(settings.isRandomizeMoveTypes());
        this.pmsRandomTotalRB.setSelected(settings.getMovesetsMod() == Settings.MovesetsMod.COMPLETELY_RANDOM);
        this.pmsRandomTypeRB.setSelected(settings.getMovesetsMod() == Settings.MovesetsMod.RANDOM_PREFER_SAME_TYPE);
        this.pmsUnchangedRB.setSelected(settings.getMovesetsMod() == Settings.MovesetsMod.UNCHANGED);
        this.pmsMetronomeOnlyRB.setSelected(settings.getMovesetsMod() == Settings.MovesetsMod.METRONOME_ONLY);
        this.pms4MovesCB.setSelected(settings.isStartWithFourMoves());
        this.pmsReorderDamagingMovesCB.setSelected(settings.isReorderDamagingMoves());
        this.pmsForceGoodDamagingCB.setSelected(settings.isMovesetsForceGoodDamaging());
        this.pmsForceGoodDamagingSlider.setValue(settings.getMovesetsGoodDamagingPercent());
        this.tpPowerLevelsCB.setSelected(settings.isTrainersUsePokemonOfSimilarStrength());
        this.tpRandomRB.setSelected(settings.getTrainersMod() == Settings.TrainersMod.RANDOM);
        this.tpRivalCarriesStarterCB.setSelected(settings.isRivalCarriesStarterThroughout());
        this.tpTypeThemedRB.setSelected(settings.getTrainersMod() == Settings.TrainersMod.TYPE_THEMED);
        this.tpTypeWeightingCB.setSelected(settings.isTrainersMatchTypingDistribution());
        this.tpUnchangedRB.setSelected(settings.getTrainersMod() == Settings.TrainersMod.UNCHANGED);
        this.tpNoLegendariesCB.setSelected(settings.isTrainersBlockLegendaries());
        this.tpNoEarlyShedinjaCB.setSelected(settings.isTrainersBlockEarlyWonderGuard());
        this.tpForceFullyEvolvedCB.setSelected(settings.isTrainersForceFullyEvolved());
        this.tpForceFullyEvolvedSlider.setValue(settings.getTrainersForceFullyEvolvedLevel());
        this.tpLevelModifierCB.setSelected(settings.isTrainersLevelModified());
        this.tpLevelModifierSlider.setValue(settings.getTrainersLevelModifier());
        this.wpARCatchEmAllRB.setSelected(settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.CATCH_EM_ALL);
        this.wpArea11RB.setSelected(settings.getWildPokemonMod() == Settings.WildPokemonMod.AREA_MAPPING);
        this.wpARNoneRB.setSelected(settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.NONE);
        this.wpARTypeThemedRB.setSelected(settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.TYPE_THEME_AREAS);
        this.wpGlobalRB.setSelected(settings.getWildPokemonMod() == Settings.WildPokemonMod.GLOBAL_MAPPING);
        this.wpRandomRB.setSelected(settings.getWildPokemonMod() == Settings.WildPokemonMod.RANDOM);
        this.wpUnchangedRB.setSelected(settings.getWildPokemonMod() == Settings.WildPokemonMod.UNCHANGED);
        this.wpUseTimeCB.setSelected(settings.isUseTimeBasedEncounters());
        this.wpCatchRateCB.setSelected(settings.isUseMinimumCatchRate());
        this.wpCatchRateSlider.setValue(settings.getMinimumCatchRateLevel());
        this.wpNoLegendariesCB.setSelected(settings.isBlockWildLegendaries());
        this.wpARSimilarStrengthRB.setSelected(settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.SIMILAR_STRENGTH);
        this.wpHeldItemsCB.setSelected(settings.isRandomizeWildPokemonHeldItems());
        this.wpHeldItemsBanBadCB.setSelected(settings.isBanBadRandomWildPokemonHeldItems());
        this.stpUnchangedRB.setSelected(settings.getStaticPokemonMod() == Settings.StaticPokemonMod.UNCHANGED);
        this.stpRandomL4LRB.setSelected(settings.getStaticPokemonMod() == Settings.StaticPokemonMod.RANDOM_MATCHING);
        this.stpRandomTotalRB.setSelected(settings.getStaticPokemonMod() == Settings.StaticPokemonMod.COMPLETELY_RANDOM);
        this.thcRandomTotalRB.setSelected(settings.getTmsHmsCompatibilityMod() == Settings.TMsHMsCompatibilityMod.COMPLETELY_RANDOM);
        this.thcRandomTypeRB.setSelected(settings.getTmsHmsCompatibilityMod() == Settings.TMsHMsCompatibilityMod.RANDOM_PREFER_TYPE);
        this.thcUnchangedRB.setSelected(settings.getTmsHmsCompatibilityMod() == Settings.TMsHMsCompatibilityMod.UNCHANGED);
        this.tmmRandomRB.setSelected(settings.getTmsMod() == Settings.TMsMod.RANDOM);
        this.tmmUnchangedRB.setSelected(settings.getTmsMod() == Settings.TMsMod.UNCHANGED);
        this.tmLearningSanityCB.setSelected(settings.isTmLevelUpMoveSanity());
        this.tmKeepFieldMovesCB.setSelected(settings.isKeepFieldMoveTMs());
        this.thcFullRB.setSelected(settings.getTmsHmsCompatibilityMod() == Settings.TMsHMsCompatibilityMod.FULL);
        this.tmFullHMCompatCB.setSelected(settings.isFullHMCompat());
        this.tmForceGoodDamagingCB.setSelected(settings.isTmsForceGoodDamaging());
        this.tmForceGoodDamagingSlider.setValue(settings.getTmsGoodDamagingPercent());
        this.mtcRandomTotalRB.setSelected(settings.getMoveTutorsCompatibilityMod() == Settings.MoveTutorsCompatibilityMod.COMPLETELY_RANDOM);
        this.mtcRandomTypeRB.setSelected(settings.getMoveTutorsCompatibilityMod() == Settings.MoveTutorsCompatibilityMod.RANDOM_PREFER_TYPE);
        this.mtcUnchangedRB.setSelected(settings.getMoveTutorsCompatibilityMod() == Settings.MoveTutorsCompatibilityMod.UNCHANGED);
        this.mtmRandomRB.setSelected(settings.getMoveTutorMovesMod() == Settings.MoveTutorMovesMod.RANDOM);
        this.mtmUnchangedRB.setSelected(settings.getMoveTutorMovesMod() == Settings.MoveTutorMovesMod.UNCHANGED);
        this.mtLearningSanityCB.setSelected(settings.isTutorLevelUpMoveSanity());
        this.mtKeepFieldMovesCB.setSelected(settings.isKeepFieldMoveTutors());
        this.mtcFullRB.setSelected(settings.getMoveTutorsCompatibilityMod() == Settings.MoveTutorsCompatibilityMod.FULL);
        this.mtForceGoodDamagingCB.setSelected(settings.isTutorsForceGoodDamaging());
        this.mtForceGoodDamagingSlider.setValue(settings.getTutorsGoodDamagingPercent());
        this.igtBothRB.setSelected(settings.getInGameTradesMod() == Settings.InGameTradesMod.RANDOMIZE_GIVEN_AND_REQUESTED);
        this.igtGivenOnlyRB.setSelected(settings.getInGameTradesMod() == Settings.InGameTradesMod.RANDOMIZE_GIVEN);
        this.igtRandomItemCB.setSelected(settings.isRandomizeInGameTradesItems());
        this.igtRandomIVsCB.setSelected(settings.isRandomizeInGameTradesIVs());
        this.igtRandomNicknameCB.setSelected(settings.isRandomizeInGameTradesNicknames());
        this.igtRandomOTCB.setSelected(settings.isRandomizeInGameTradesOTs());
        this.igtUnchangedRB.setSelected(settings.getInGameTradesMod() == Settings.InGameTradesMod.UNCHANGED);
        this.fiRandomRB.setSelected(settings.getFieldItemsMod() == Settings.FieldItemsMod.RANDOM);
        this.fiShuffleRB.setSelected(settings.getFieldItemsMod() == Settings.FieldItemsMod.SHUFFLE);
        this.fiUnchangedRB.setSelected(settings.getFieldItemsMod() == Settings.FieldItemsMod.UNCHANGED);
        this.fiBanBadCB.setSelected(settings.isBanBadRandomFieldItems());
        this.currentRestrictions = settings.getCurrentRestrictions();
        if (this.currentRestrictions != null) {
            this.currentRestrictions.limitToGen(this.romHandler.generationOfPokemon());
        }
        int mtsSelected = settings.getCurrentMiscTweaks();
        int mtCount = MiscTweak.allTweaks.size();
        for (int mti = 0; mti < mtCount; ++mti) {
            MiscTweak mt = MiscTweak.allTweaks.get(mti);
            JCheckBox mtCB = this.tweakCheckboxes.get(mti);
            mtCB.setSelected((mtsSelected & mt.getValue()) != 0);
        }
        this.enableOrDisableSubControls();
    }

    private Settings createSettingsFromState(CustomNamesSet customNames) {
        Settings settings = new Settings();
        settings.setRomName(this.romHandler.getROMName());
        settings.setChangeImpossibleEvolutions(this.goRemoveTradeEvosCheckBox.isSelected());
        settings.setUpdateMoves(this.goUpdateMovesCheckBox.isSelected());
        settings.setUpdateMovesLegacy(this.goUpdateMovesLegacyCheckBox.isSelected());
        settings.setRandomizeTrainerNames(this.tnRandomizeCB.isSelected());
        settings.setRandomizeTrainerClassNames(this.tcnRandomizeCB.isSelected());
        settings.setBaseStatisticsMod(this.pbsChangesUnchangedRB.isSelected(), this.pbsChangesShuffleRB.isSelected(), this.pbsChangesRandomRB.isSelected());
        settings.setStandardizeEXPCurves(this.pbsStandardEXPCurvesCB.isSelected());
        settings.setBaseStatsFollowEvolutions(this.pbsFollowEvolutionsCB.isSelected());
        settings.setUpdateBaseStats(this.pbsUpdateStatsCB.isSelected());
        settings.setAbilitiesMod(this.paUnchangedRB.isSelected(), this.paRandomizeRB.isSelected());
        settings.setAllowWonderGuard(this.paWonderGuardCB.isSelected());
        settings.setAbilitiesFollowEvolutions(this.paFollowEvolutionsCB.isSelected());
        settings.setBanTrappingAbilities(this.paBanTrappingCB.isSelected());
        settings.setBanNegativeAbilities(this.paBanNegativeCB.isSelected());
        settings.setTypesMod(this.ptUnchangedRB.isSelected(), this.ptRandomFollowEvosRB.isSelected(), this.ptRandomTotalRB.isSelected());
        settings.setRaceMode(this.raceModeCB.isSelected());
        settings.setBlockBrokenMoves(this.brokenMovesCB.isSelected());
        settings.setLimitPokemon(this.pokeLimitCB.isSelected());
        settings.setMakeEvolutionsEasier(this.goCondenseEvosCheckBox.isSelected());
        settings.setStartersMod(this.spUnchangedRB.isSelected(), this.spCustomRB.isSelected(), this.spRandomRB.isSelected(), this.spRandom2EvosRB.isSelected());
        settings.setRandomizeStartersHeldItems(this.spHeldItemsCB.isSelected());
        settings.setBanBadRandomStarterHeldItems(this.spHeldItemsBanBadCB.isSelected());
        int[] customStarters = new int[]{this.spCustomPoke1Chooser.getSelectedIndex() + 1, this.spCustomPoke2Chooser.getSelectedIndex() + 1, this.spCustomPoke3Chooser.getSelectedIndex() + 1};
        settings.setCustomStarters(customStarters);
        settings.setEvolutionsMod(this.peUnchangedRB.isSelected(), this.peRandomRB.isSelected());
        settings.setEvosSimilarStrength(this.peSimilarStrengthCB.isSelected());
        settings.setEvosSameTyping(this.peSameTypeCB.isSelected());
        settings.setEvosMaxThreeStages(this.peThreeStagesCB.isSelected());
        settings.setEvosForceChange(this.peForceChangeCB.isSelected());
        settings.setRandomizeMoveAccuracies(this.mdRandomAccuracyCB.isSelected());
        settings.setRandomizeMoveCategory(this.mdRandomCategoryCB.isSelected());
        settings.setRandomizeMovePowers(this.mdRandomPowerCB.isSelected());
        settings.setRandomizeMovePPs(this.mdRandomPPCB.isSelected());
        settings.setRandomizeMoveTypes(this.mdRandomTypeCB.isSelected());
        settings.setMovesetsMod(this.pmsUnchangedRB.isSelected(), this.pmsRandomTypeRB.isSelected(), this.pmsRandomTotalRB.isSelected(), this.pmsMetronomeOnlyRB.isSelected());
        settings.setStartWithFourMoves(this.pms4MovesCB.isSelected());
        settings.setReorderDamagingMoves(this.pmsReorderDamagingMovesCB.isSelected());
        settings.setMovesetsForceGoodDamaging(this.pmsForceGoodDamagingCB.isSelected());
        settings.setMovesetsGoodDamagingPercent(this.pmsForceGoodDamagingSlider.getValue());
        settings.setTrainersMod(this.tpUnchangedRB.isSelected(), this.tpRandomRB.isSelected(), this.tpTypeThemedRB.isSelected());
        settings.setTrainersUsePokemonOfSimilarStrength(this.tpPowerLevelsCB.isSelected());
        settings.setRivalCarriesStarterThroughout(this.tpRivalCarriesStarterCB.isSelected());
        settings.setTrainersMatchTypingDistribution(this.tpTypeWeightingCB.isSelected());
        settings.setTrainersBlockLegendaries(this.tpNoLegendariesCB.isSelected());
        settings.setTrainersBlockEarlyWonderGuard(this.tpNoEarlyShedinjaCB.isSelected());
        settings.setTrainersForceFullyEvolved(this.tpForceFullyEvolvedCB.isSelected());
        settings.setTrainersForceFullyEvolvedLevel(this.tpForceFullyEvolvedSlider.getValue());
        settings.setTrainersLevelModified(this.tpLevelModifierCB.isSelected());
        settings.setTrainersLevelModifier(this.tpLevelModifierSlider.getValue());
        settings.setWildPokemonMod(this.wpUnchangedRB.isSelected(), this.wpRandomRB.isSelected(), this.wpArea11RB.isSelected(), this.wpGlobalRB.isSelected());
        settings.setWildPokemonRestrictionMod(this.wpARNoneRB.isSelected(), this.wpARSimilarStrengthRB.isSelected(), this.wpARCatchEmAllRB.isSelected(), this.wpARTypeThemedRB.isSelected());
        settings.setUseTimeBasedEncounters(this.wpUseTimeCB.isSelected());
        settings.setUseMinimumCatchRate(this.wpCatchRateCB.isSelected());
        settings.setMinimumCatchRateLevel(this.wpCatchRateSlider.getValue());
        settings.setBlockWildLegendaries(this.wpNoLegendariesCB.isSelected());
        settings.setRandomizeWildPokemonHeldItems(this.wpHeldItemsCB.isSelected());
        settings.setBanBadRandomWildPokemonHeldItems(this.wpHeldItemsBanBadCB.isSelected());
        settings.setStaticPokemonMod(this.stpUnchangedRB.isSelected(), this.stpRandomL4LRB.isSelected(), this.stpRandomTotalRB.isSelected());
        settings.setTmsMod(this.tmmUnchangedRB.isSelected(), this.tmmRandomRB.isSelected());
        settings.setTmsHmsCompatibilityMod(this.thcUnchangedRB.isSelected(), this.thcRandomTypeRB.isSelected(), this.thcRandomTotalRB.isSelected(), this.thcFullRB.isSelected());
        settings.setTmLevelUpMoveSanity(this.tmLearningSanityCB.isSelected());
        settings.setKeepFieldMoveTMs(this.tmKeepFieldMovesCB.isSelected());
        settings.setFullHMCompat(this.tmFullHMCompatCB.isSelected());
        settings.setTmsForceGoodDamaging(this.tmForceGoodDamagingCB.isSelected());
        settings.setTmsGoodDamagingPercent(this.tmForceGoodDamagingSlider.getValue());
        settings.setMoveTutorMovesMod(this.mtmUnchangedRB.isSelected(), this.mtmRandomRB.isSelected());
        settings.setMoveTutorsCompatibilityMod(this.mtcUnchangedRB.isSelected(), this.mtcRandomTypeRB.isSelected(), this.mtcRandomTotalRB.isSelected(), this.mtcFullRB.isSelected());
        settings.setTutorLevelUpMoveSanity(this.mtLearningSanityCB.isSelected());
        settings.setKeepFieldMoveTutors(this.mtKeepFieldMovesCB.isSelected());
        settings.setTutorsForceGoodDamaging(this.mtForceGoodDamagingCB.isSelected());
        settings.setTutorsGoodDamagingPercent(this.mtForceGoodDamagingSlider.getValue());
        settings.setInGameTradesMod(this.igtUnchangedRB.isSelected(), this.igtGivenOnlyRB.isSelected(), this.igtBothRB.isSelected());
        settings.setRandomizeInGameTradesItems(this.igtRandomItemCB.isSelected());
        settings.setRandomizeInGameTradesIVs(this.igtRandomIVsCB.isSelected());
        settings.setRandomizeInGameTradesNicknames(this.igtRandomNicknameCB.isSelected());
        settings.setRandomizeInGameTradesOTs(this.igtRandomOTCB.isSelected());
        settings.setFieldItemsMod(this.fiUnchangedRB.isSelected(), this.fiShuffleRB.isSelected(), this.fiRandomRB.isSelected());
        settings.setBanBadRandomFieldItems(this.fiBanBadCB.isSelected());
        settings.setCurrentRestrictions(this.currentRestrictions);
        int currentMiscTweaks = 0;
        int mtCount = MiscTweak.allTweaks.size();
        for (int mti = 0; mti < mtCount; ++mti) {
            MiscTweak mt = MiscTweak.allTweaks.get(mti);
            JCheckBox mtCB = this.tweakCheckboxes.get(mti);
            if (!mtCB.isSelected()) continue;
            currentMiscTweaks |= mt.getValue();
        }
        settings.setCurrentMiscTweaks(currentMiscTweaks);
        settings.setCustomNames(customNames);
        return settings;
    }

    private void performRandomization(final String filename, final long seed, CustomNamesSet customNames) {
        block4: {
            PrintStream log;
            final Settings settings = this.createSettingsFromState(customNames);
            final boolean raceMode = settings.isRaceMode();
            final ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                log = new PrintStream((OutputStream)baos, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log = new PrintStream(baos);
            }
            final PrintStream verboseLog = log;
            try {
                final AtomicInteger finishedCV = new AtomicInteger(0);
                this.opDialog = new OperationDialog(this.bundle.getString("RandomizerGUI.savingText"), this, true);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        boolean succeededSave;
                        block6: {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RandomizerGUI.this.opDialog.setVisible(true);
                                }
                            });
                            succeededSave = false;
                            try {
                                RandomizerGUI.this.romHandler.setLog(verboseLog);
                                finishedCV.set(new Randomizer(settings, RandomizerGUI.this.romHandler).randomize(filename, verboseLog, seed));
                                succeededSave = true;
                            }
                            catch (RandomizationException ex) {
                                RandomizerGUI.this.attemptToLogException(ex, "RandomizerGUI.saveFailedMessage", "RandomizerGUI.saveFailedMessageNoLog", true);
                                if (verboseLog != null) {
                                    verboseLog.close();
                                }
                            }
                            catch (Exception ex) {
                                RandomizerGUI.this.attemptToLogException(ex, "RandomizerGUI.saveFailedIO", "RandomizerGUI.saveFailedIONoLog");
                                if (verboseLog == null) break block6;
                                verboseLog.close();
                            }
                        }
                        if (succeededSave) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RandomizerGUI.this.opDialog.setVisible(false);
                                    verboseLog.close();
                                    byte[] out = baos.toByteArray();
                                    if (raceMode) {
                                        JOptionPane.showMessageDialog(RandomizerGUI.this, String.format(RandomizerGUI.this.bundle.getString("RandomizerGUI.raceModeCheckValuePopup"), finishedCV.get()));
                                    } else {
                                        int response = JOptionPane.showConfirmDialog(RandomizerGUI.this, RandomizerGUI.this.bundle.getString("RandomizerGUI.saveLogDialog.text"), RandomizerGUI.this.bundle.getString("RandomizerGUI.saveLogDialog.title"), 0);
                                        if (response == 0) {
                                            try {
                                                FileOutputStream fos = new FileOutputStream(filename + ".log");
                                                fos.write(239);
                                                fos.write(187);
                                                fos.write(191);
                                                fos.write(out);
                                                fos.close();
                                            }
                                            catch (IOException e) {
                                                JOptionPane.showMessageDialog(RandomizerGUI.this, RandomizerGUI.this.bundle.getString("RandomizerGUI.logSaveFailed"));
                                                return;
                                            }
                                            JOptionPane.showMessageDialog(RandomizerGUI.this, String.format(RandomizerGUI.this.bundle.getString("RandomizerGUI.logSaved"), filename));
                                        }
                                    }
                                    if (RandomizerGUI.this.presetMode) {
                                        JOptionPane.showMessageDialog(RandomizerGUI.this, RandomizerGUI.this.bundle.getString("RandomizerGUI.randomizationDone"));
                                        RandomizerGUI.this.romHandler = null;
                                        RandomizerGUI.this.initialFormState();
                                    } else {
                                        try {
                                            String configString = RandomizerGUI.this.getCurrentSettings().toString();
                                            new PresetMakeDialog((Frame)RandomizerGUI.this, seed, configString);
                                        }
                                        catch (IOException ex) {
                                            JOptionPane.showMessageDialog(RandomizerGUI.this, RandomizerGUI.this.bundle.getString("RandomizerGUI.cantLoadCustomNames"));
                                        }
                                        RandomizerGUI.this.romHandler = null;
                                        RandomizerGUI.this.initialFormState();
                                    }
                                }
                            });
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RandomizerGUI.this.opDialog.setVisible(false);
                                    RandomizerGUI.this.romHandler = null;
                                    RandomizerGUI.this.initialFormState();
                                }
                            });
                        }
                    }
                };
                t.start();
            }
            catch (Exception ex) {
                this.attemptToLogException(ex, "RandomizerGUI.saveFailed", "RandomizerGUI.saveFailedNoLog");
                if (verboseLog == null) break block4;
                verboseLog.close();
            }
        }
    }

    private void presetLoader() {
        PresetLoadDialog pld = new PresetLoadDialog(this);
        if (pld.isCompleted()) {
            long seed = pld.getSeed();
            String config = pld.getConfigString();
            this.romHandler = pld.getROM();
            this.romLoaded();
            try {
                Settings settings = Settings.fromString(config);
                settings.tweakForRom(this.romHandler);
                this.restoreStateFromSettings(settings);
            }
            catch (UnsupportedEncodingException e) {
                this.romHandler = null;
                this.initialFormState();
            }
            this.romSaveChooser.setSelectedFile(null);
            int returnVal = this.romSaveChooser.showSaveDialog(this);
            if (returnVal == 0) {
                String currentFN;
                File fh = this.romSaveChooser.getSelectedFile();
                ArrayList<String> extensions = new ArrayList<String>(Arrays.asList("sgb", "gbc", "gba", "nds"));
                extensions.remove(this.romHandler.getDefaultExtension());
                fh = FileFunctions.fixFilename(fh, this.romHandler.getDefaultExtension(), extensions);
                boolean allowed = true;
                if (this.romHandler instanceof AbstractDSRomHandler && (currentFN = this.romHandler.loadedFilename()).equals(fh.getAbsolutePath())) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.cantOverwriteDS"));
                    allowed = false;
                }
                if (allowed) {
                    RandomSource.seed(seed);
                    this.presetMode = true;
                    this.performRandomization(fh.getAbsolutePath(), seed, pld.getCustomNames());
                } else {
                    this.romHandler = null;
                    this.initialFormState();
                }
            } else {
                this.romHandler = null;
                this.initialFormState();
            }
        }
    }

    private void attemptToLogException(Exception ex, String baseMessageKey, String noLogMessageKey) {
        this.attemptToLogException(ex, baseMessageKey, noLogMessageKey, false);
    }

    private void attemptToLogException(Exception ex, String baseMessageKey, String noLogMessageKey, boolean showMessage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RandomizerGUI.this.opDialog.setVisible(false);
            }
        });
        Date now = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        try {
            String errlog = "error_" + ft.format(now) + ".txt";
            PrintStream ps = new PrintStream(new FileOutputStream(errlog));
            ps.println("Randomizer Version: 1720");
            PrintStream e1 = System.err;
            System.setErr(ps);
            if (this.romHandler != null) {
                try {
                    ps.println("ROM: " + this.romHandler.getROMName());
                    ps.println("Code: " + this.romHandler.getROMCode());
                    ps.println("Reported Support Level: " + this.romHandler.getSupportLevel());
                    ps.println();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ex.printStackTrace();
            System.setErr(e1);
            ps.close();
            if (showMessage) {
                JOptionPane.showMessageDialog(this, String.format(this.bundle.getString(baseMessageKey), ex.getMessage(), errlog));
            } else {
                JOptionPane.showMessageDialog(this, String.format(this.bundle.getString(baseMessageKey), errlog));
            }
        }
        catch (Exception logex) {
            if (showMessage) {
                JOptionPane.showMessageDialog(this, String.format(this.bundle.getString(noLogMessageKey), ex.getMessage()));
            }
            JOptionPane.showMessageDialog(this, this.bundle.getString(noLogMessageKey));
        }
    }

    public void updateFound(int newVersion, String changelog) {
        new UpdateFoundDialog(this, newVersion, changelog);
    }

    public void noUpdateFound() {
        JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.noUpdates"));
    }

    private void settingsButtonActionPerformed(ActionEvent evt) {
        if (this.autoUpdateEnabled) {
            this.toggleAutoUpdatesMenuItem.setText(this.bundle.getString("RandomizerGUI.disableAutoUpdate"));
        } else {
            this.toggleAutoUpdatesMenuItem.setText(this.bundle.getString("RandomizerGUI.enableAutoUpdate"));
        }
        if (this.useScrollPaneMode) {
            this.toggleScrollPaneMenuItem.setText(this.bundle.getString("RandomizerGUI.changeToTabbedPane"));
        } else {
            this.toggleScrollPaneMenuItem.setText(this.bundle.getString("RandomizerGUI.changeToScrollPane"));
        }
        this.updateSettingsMenu.show(this.settingsButton, 0, this.settingsButton.getHeight());
    }

    private void toggleAutoUpdatesMenuItemActionPerformed(ActionEvent evt) {
        boolean bl = this.autoUpdateEnabled = !this.autoUpdateEnabled;
        if (this.autoUpdateEnabled) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.autoUpdateEnabled"));
        } else {
            JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.autoUpdateDisabled"));
        }
        this.attemptWriteConfig();
    }

    private void manualUpdateMenuItemActionPerformed(ActionEvent evt) {
        new UpdateCheckThread(this, true).start();
    }

    private void toggleScrollPaneMenuItemActionPerformed(ActionEvent evt) {
        int response = JOptionPane.showConfirmDialog(this, this.bundle.getString("RandomizerGUI.displayModeChangeDialog.text"), this.bundle.getString("RandomizerGUI.displayModeChangeDialog.title"), 0);
        if (response == 0) {
            this.useScrollPaneMode = !this.useScrollPaneMode;
            JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.displayModeChanged"));
            this.attemptWriteConfig();
            System.exit(0);
        }
    }

    private void customNamesEditorMenuItemActionPerformed(ActionEvent evt) {
        new CustomNamesEditorDialog(this);
    }

    private void loadQSButtonActionPerformed(ActionEvent evt) {
        if (this.romHandler == null) {
            return;
        }
        this.qsOpenChooser.setSelectedFile(null);
        int returnVal = this.qsOpenChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File fh = this.qsOpenChooser.getSelectedFile();
            try {
                FileInputStream fis = new FileInputStream(fh);
                Settings settings = Settings.read(fis);
                fis.close();
                this.initialFormState();
                this.romLoaded();
                Settings.TweakForROMFeedback feedback = settings.tweakForRom(this.romHandler);
                if (feedback.isChangedStarter() && settings.getStartersMod() == Settings.StartersMod.CUSTOM) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.starterUnavailable"));
                }
                this.restoreStateFromSettings(settings);
                if (settings.isUpdatedFromOldVersion()) {
                    JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.settingsFileOlder"));
                }
                JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.settingsLoaded"), fh.getName()));
            }
            catch (UnsupportedOperationException ex) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.settingsFileNewer"));
            }
            catch (IllegalArgumentException ex) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.invalidSettingsFile"));
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.settingsLoadFailed"));
            }
        }
    }

    private void saveQSButtonActionPerformed(ActionEvent evt) {
        if (this.romHandler == null) {
            return;
        }
        this.qsSaveChooser.setSelectedFile(null);
        int returnVal = this.qsSaveChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File fh = this.qsSaveChooser.getSelectedFile();
            fh = FileFunctions.fixFilename(fh, "rnqs");
            try {
                FileOutputStream fos = new FileOutputStream(fh);
                this.getCurrentSettings().write(fos);
                fos.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("RandomizerGUI.settingsSaveFailed"));
            }
        }
    }

    private void pokeLimitBtnActionPerformed(ActionEvent evt) {
        GenerationLimitDialog gld = new GenerationLimitDialog(this, this.currentRestrictions, this.romHandler.generationOfPokemon());
        if (gld.pressedOK()) {
            this.currentRestrictions = gld.getChoice();
        }
    }

    private void goUpdateMovesCheckBoxActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pokeLimitCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pmsMetronomeOnlyRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void igtUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void igtGivenOnlyRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void igtBothRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpARNoneRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpARSimilarStrengthRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpARCatchEmAllRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpARTypeThemedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pmsUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pmsRandomTypeRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pmsRandomTotalRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtmUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void paUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void paRandomizeRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void openROMButtonActionPerformed(ActionEvent evt) {
        this.loadROM();
    }

    private void saveROMButtonActionPerformed(ActionEvent evt) {
        this.saveROM();
    }

    private void usePresetsButtonActionPerformed(ActionEvent evt) {
        this.presetLoader();
    }

    private void wpUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tpUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tpRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tpTypeThemedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void spUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void spCustomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void spRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpArea11RBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpGlobalRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tmmUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tmmRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtmRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void thcUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void thcRandomTypeRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void thcRandomTotalRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtcUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtcRandomTypeRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtcRandomTotalRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void thcFullRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtcFullRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void spHeldItemsCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpHeldItemsCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void fiUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void fiShuffleRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void fiRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void spRandom2EvosRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void goCondenseEvosCheckBoxActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void websiteLinkLabelMouseClicked(MouseEvent evt) {
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI("http://pokehacks.dabomstew.com/randomizer/"));
        }
        catch (IOException iOException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private void peUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void peRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pbsChangesUnchangedRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pbsChangesShuffleRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pbsChangesRandomRBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tpForceFullyEvolvedCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tpLevelModifierCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void wpCatchRateCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void pmsForceGoodDamagingCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void tmForceGoodDamagingCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void mtForceGoodDamagingCBActionPerformed(ActionEvent evt) {
        this.enableOrDisableSubControls();
    }

    private void initComponents() {
        this.pokeStatChangesButtonGroup = new ButtonGroup();
        this.pokeTypesButtonGroup = new ButtonGroup();
        this.pokeMovesetsButtonGroup = new ButtonGroup();
        this.trainerPokesButtonGroup = new ButtonGroup();
        this.wildPokesButtonGroup = new ButtonGroup();
        this.wildPokesARuleButtonGroup = new ButtonGroup();
        this.starterPokemonButtonGroup = new ButtonGroup();
        this.romOpenChooser = new JFileChooser();
        this.romSaveChooser = new JFileChooser(){
            private static final long serialVersionUID = 3244234325234511L;

            @Override
            public void approveSelection() {
                File fh = this.getSelectedFile();
                ArrayList<String> extensions = new ArrayList<String>(Arrays.asList("sgb", "gbc", "gba", "nds"));
                extensions.remove(RandomizerGUI.this.romHandler.getDefaultExtension());
                fh = FileFunctions.fixFilename(fh, RandomizerGUI.this.romHandler.getDefaultExtension(), extensions);
                if (fh.exists() && this.getDialogType() == 1) {
                    int result = JOptionPane.showConfirmDialog(this, "The file exists, overwrite?", "Existing file", 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                    return;
                }
                super.approveSelection();
            }
        };
        this.qsOpenChooser = new JFileChooser();
        this.qsSaveChooser = new JFileChooser();
        this.staticPokemonButtonGroup = new ButtonGroup();
        this.tmMovesButtonGroup = new ButtonGroup();
        this.tmHmCompatibilityButtonGroup = new ButtonGroup();
        this.pokeAbilitiesButtonGroup = new ButtonGroup();
        this.mtMovesButtonGroup = new ButtonGroup();
        this.mtCompatibilityButtonGroup = new ButtonGroup();
        this.ingameTradesButtonGroup = new ButtonGroup();
        this.fieldItemsButtonGroup = new ButtonGroup();
        this.updateSettingsMenu = new JPopupMenu();
        this.toggleAutoUpdatesMenuItem = new JMenuItem();
        this.manualUpdateMenuItem = new JMenuItem();
        this.toggleScrollPaneMenuItem = new JMenuItem();
        this.customNamesEditorMenuItem = new JMenuItem();
        this.pokeEvolutionsButtonGroup = new ButtonGroup();
        this.generalOptionsPanel = new JPanel();
        this.pokeLimitCB = new JCheckBox();
        this.pokeLimitBtn = new JButton();
        this.raceModeCB = new JCheckBox();
        this.brokenMovesCB = new JCheckBox();
        this.romInfoPanel = new JPanel();
        this.riRomNameLabel = new JLabel();
        this.riRomCodeLabel = new JLabel();
        this.riRomSupportLabel = new JLabel();
        this.openROMButton = new JButton();
        this.saveROMButton = new JButton();
        this.usePresetsButton = new JButton();
        this.loadQSButton = new JButton();
        this.saveQSButton = new JButton();
        this.settingsButton = new JButton();
        this.randomizerOptionsPane = new JTabbedPane();
        this.pokeTraitsPanel = new JPanel();
        this.pokemonTypesPanel = new JPanel();
        this.ptUnchangedRB = new JRadioButton();
        this.ptRandomFollowEvosRB = new JRadioButton();
        this.ptRandomTotalRB = new JRadioButton();
        this.baseStatsPanel = new JPanel();
        this.pbsChangesUnchangedRB = new JRadioButton();
        this.pbsChangesShuffleRB = new JRadioButton();
        this.pbsChangesRandomRB = new JRadioButton();
        this.pbsStandardEXPCurvesCB = new JCheckBox();
        this.pbsFollowEvolutionsCB = new JCheckBox();
        this.pbsUpdateStatsCB = new JCheckBox();
        this.abilitiesPanel = new JPanel();
        this.paUnchangedRB = new JRadioButton();
        this.paRandomizeRB = new JRadioButton();
        this.paWonderGuardCB = new JCheckBox();
        this.paFollowEvolutionsCB = new JCheckBox();
        this.paBansLabel = new JLabel();
        this.paBanTrappingCB = new JCheckBox();
        this.paBanNegativeCB = new JCheckBox();
        this.pokemonEvolutionsPanel = new JPanel();
        this.peUnchangedRB = new JRadioButton();
        this.peRandomRB = new JRadioButton();
        this.peSimilarStrengthCB = new JCheckBox();
        this.peSameTypeCB = new JCheckBox();
        this.peThreeStagesCB = new JCheckBox();
        this.peForceChangeCB = new JCheckBox();
        this.goRemoveTradeEvosCheckBox = new JCheckBox();
        this.goCondenseEvosCheckBox = new JCheckBox();
        this.startersInnerPanel = new JPanel();
        this.starterPokemonPanel = new JPanel();
        this.spUnchangedRB = new JRadioButton();
        this.spCustomRB = new JRadioButton();
        this.spCustomPoke1Chooser = new JComboBox();
        this.spCustomPoke2Chooser = new JComboBox();
        this.spCustomPoke3Chooser = new JComboBox();
        this.spRandomRB = new JRadioButton();
        this.spRandom2EvosRB = new JRadioButton();
        this.spHeldItemsCB = new JCheckBox();
        this.spHeldItemsBanBadCB = new JCheckBox();
        this.staticPokemonPanel = new JPanel();
        this.stpUnchangedRB = new JRadioButton();
        this.stpRandomL4LRB = new JRadioButton();
        this.stpRandomTotalRB = new JRadioButton();
        this.inGameTradesPanel = new JPanel();
        this.igtUnchangedRB = new JRadioButton();
        this.igtGivenOnlyRB = new JRadioButton();
        this.igtBothRB = new JRadioButton();
        this.igtRandomNicknameCB = new JCheckBox();
        this.igtRandomOTCB = new JCheckBox();
        this.igtRandomIVsCB = new JCheckBox();
        this.igtRandomItemCB = new JCheckBox();
        this.movesAndSetsPanel = new JPanel();
        this.pokemonMovesetsPanel = new JPanel();
        this.pmsUnchangedRB = new JRadioButton();
        this.pmsRandomTypeRB = new JRadioButton();
        this.pmsRandomTotalRB = new JRadioButton();
        this.pmsMetronomeOnlyRB = new JRadioButton();
        this.pms4MovesCB = new JCheckBox();
        this.pmsReorderDamagingMovesCB = new JCheckBox();
        this.pmsForceGoodDamagingCB = new JCheckBox();
        this.pmsForceGoodDamagingSlider = new JSlider();
        this.moveDataPanel = new JPanel();
        this.mdRandomPowerCB = new JCheckBox();
        this.mdRandomAccuracyCB = new JCheckBox();
        this.mdRandomPPCB = new JCheckBox();
        this.mdRandomTypeCB = new JCheckBox();
        this.mdRandomCategoryCB = new JCheckBox();
        this.goUpdateMovesCheckBox = new JCheckBox();
        this.goUpdateMovesLegacyCheckBox = new JCheckBox();
        this.trainersInnerPanel = new JPanel();
        this.trainersPokemonPanel = new JPanel();
        this.tpUnchangedRB = new JRadioButton();
        this.tpRandomRB = new JRadioButton();
        this.tpTypeThemedRB = new JRadioButton();
        this.tpPowerLevelsCB = new JCheckBox();
        this.tpTypeWeightingCB = new JCheckBox();
        this.tpRivalCarriesStarterCB = new JCheckBox();
        this.tpNoLegendariesCB = new JCheckBox();
        this.tnRandomizeCB = new JCheckBox();
        this.tcnRandomizeCB = new JCheckBox();
        this.tpNoEarlyShedinjaCB = new JCheckBox();
        this.tpForceFullyEvolvedCB = new JCheckBox();
        this.tpForceFullyEvolvedSlider = new JSlider();
        this.tpLevelModifierCB = new JCheckBox();
        this.tpLevelModifierSlider = new JSlider();
        this.wildsInnerPanel = new JPanel();
        this.wildPokemonPanel = new JPanel();
        this.wpUnchangedRB = new JRadioButton();
        this.wpRandomRB = new JRadioButton();
        this.wpArea11RB = new JRadioButton();
        this.wpGlobalRB = new JRadioButton();
        this.wildPokemonARulePanel = new JPanel();
        this.wpARNoneRB = new JRadioButton();
        this.wpARCatchEmAllRB = new JRadioButton();
        this.wpARTypeThemedRB = new JRadioButton();
        this.wpARSimilarStrengthRB = new JRadioButton();
        this.wpUseTimeCB = new JCheckBox();
        this.wpNoLegendariesCB = new JCheckBox();
        this.wpCatchRateCB = new JCheckBox();
        this.wpHeldItemsCB = new JCheckBox();
        this.wpHeldItemsBanBadCB = new JCheckBox();
        this.wpCatchRateSlider = new JSlider();
        this.tmHmTutorPanel = new JPanel();
        this.tmhmsPanel = new JPanel();
        this.tmMovesPanel = new JPanel();
        this.tmmUnchangedRB = new JRadioButton();
        this.tmmRandomRB = new JRadioButton();
        this.tmLearningSanityCB = new JCheckBox();
        this.tmKeepFieldMovesCB = new JCheckBox();
        this.tmFullHMCompatCB = new JCheckBox();
        this.tmForceGoodDamagingCB = new JCheckBox();
        this.tmForceGoodDamagingSlider = new JSlider();
        this.tmHmCompatPanel = new JPanel();
        this.thcUnchangedRB = new JRadioButton();
        this.thcRandomTypeRB = new JRadioButton();
        this.thcRandomTotalRB = new JRadioButton();
        this.thcFullRB = new JRadioButton();
        this.moveTutorsPanel = new JPanel();
        this.mtMovesPanel = new JPanel();
        this.mtmUnchangedRB = new JRadioButton();
        this.mtmRandomRB = new JRadioButton();
        this.mtLearningSanityCB = new JCheckBox();
        this.mtKeepFieldMovesCB = new JCheckBox();
        this.mtForceGoodDamagingCB = new JCheckBox();
        this.mtForceGoodDamagingSlider = new JSlider();
        this.mtCompatPanel = new JPanel();
        this.mtcUnchangedRB = new JRadioButton();
        this.mtcRandomTypeRB = new JRadioButton();
        this.mtcRandomTotalRB = new JRadioButton();
        this.mtcFullRB = new JRadioButton();
        this.mtNoExistLabel = new JLabel();
        this.fieldItemsInnerPanel = new JPanel();
        this.fieldItemsPanel = new JPanel();
        this.fiUnchangedRB = new JRadioButton();
        this.fiShuffleRB = new JRadioButton();
        this.fiRandomRB = new JRadioButton();
        this.fiBanBadCB = new JCheckBox();
        this.miscTweaksInnerPanel = new JPanel();
        this.miscTweaksPanel = new JPanel();
        this.mtNoneAvailableLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.websiteLinkLabel = new JLabel();
        this.gameMascotLabel = new JLabel();
        this.romOpenChooser.setFileFilter(new ROMFilter());
        this.romSaveChooser.setDialogType(1);
        this.romSaveChooser.setFileFilter(new ROMFilter());
        this.qsOpenChooser.setFileFilter(new QSFileFilter());
        this.qsSaveChooser.setDialogType(1);
        this.qsSaveChooser.setFileFilter(new QSFileFilter());
        ResourceBundle bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
        this.toggleAutoUpdatesMenuItem.setText(bundle.getString("RandomizerGUI.toggleAutoUpdatesMenuItem.text"));
        this.toggleAutoUpdatesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.toggleAutoUpdatesMenuItemActionPerformed(evt);
            }
        });
        this.updateSettingsMenu.add(this.toggleAutoUpdatesMenuItem);
        this.manualUpdateMenuItem.setText(bundle.getString("RandomizerGUI.manualUpdateMenuItem.text"));
        this.manualUpdateMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.manualUpdateMenuItemActionPerformed(evt);
            }
        });
        this.updateSettingsMenu.add(this.manualUpdateMenuItem);
        this.toggleScrollPaneMenuItem.setText(bundle.getString("RandomizerGUI.toggleScrollPaneMenuItem.text"));
        this.toggleScrollPaneMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.toggleScrollPaneMenuItemActionPerformed(evt);
            }
        });
        this.updateSettingsMenu.add(this.toggleScrollPaneMenuItem);
        this.customNamesEditorMenuItem.setText(bundle.getString("RandomizerGUI.customNamesEditorMenuItem.text"));
        this.customNamesEditorMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.customNamesEditorMenuItemActionPerformed(evt);
            }
        });
        this.updateSettingsMenu.add(this.customNamesEditorMenuItem);
        this.setDefaultCloseOperation(3);
        this.setTitle(bundle.getString("RandomizerGUI.title"));
        this.generalOptionsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.generalOptionsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.pokeLimitCB.setText(bundle.getString("RandomizerGUI.pokeLimitCB.text"));
        this.pokeLimitCB.setToolTipText(bundle.getString("RandomizerGUI.pokeLimitCB.toolTipText"));
        this.pokeLimitCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pokeLimitCBActionPerformed(evt);
            }
        });
        this.pokeLimitBtn.setText(bundle.getString("RandomizerGUI.pokeLimitBtn.text"));
        this.pokeLimitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pokeLimitBtnActionPerformed(evt);
            }
        });
        this.raceModeCB.setText(bundle.getString("RandomizerGUI.raceModeCB.text"));
        this.raceModeCB.setToolTipText(bundle.getString("RandomizerGUI.raceModeCB.toolTipText"));
        this.brokenMovesCB.setText(bundle.getString("RandomizerGUI.brokenMovesCB.text"));
        this.brokenMovesCB.setToolTipText(bundle.getString("RandomizerGUI.brokenMovesCB.toolTipText"));
        GroupLayout generalOptionsPanelLayout = new GroupLayout(this.generalOptionsPanel);
        this.generalOptionsPanel.setLayout(generalOptionsPanelLayout);
        generalOptionsPanelLayout.setHorizontalGroup(generalOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalOptionsPanelLayout.createSequentialGroup().addComponent(this.pokeLimitCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pokeLimitBtn)).addComponent(this.raceModeCB).addComponent(this.brokenMovesCB)).addContainerGap(22, Short.MAX_VALUE)));
        generalOptionsPanelLayout.setVerticalGroup(generalOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(generalOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(generalOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pokeLimitBtn).addComponent(this.pokeLimitCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.raceModeCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.brokenMovesCB).addContainerGap(-1, Short.MAX_VALUE)));
        this.romInfoPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.romInfoPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.riRomNameLabel.setText(bundle.getString("RandomizerGUI.riRomNameLabel.text"));
        this.riRomCodeLabel.setText(bundle.getString("RandomizerGUI.riRomCodeLabel.text"));
        this.riRomSupportLabel.setText(bundle.getString("RandomizerGUI.riRomSupportLabel.text"));
        GroupLayout romInfoPanelLayout = new GroupLayout(this.romInfoPanel);
        this.romInfoPanel.setLayout(romInfoPanelLayout);
        romInfoPanelLayout.setHorizontalGroup(romInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(romInfoPanelLayout.createSequentialGroup().addContainerGap().addGroup(romInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.riRomNameLabel, -1, 170, Short.MAX_VALUE).addComponent(this.riRomCodeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.riRomSupportLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        romInfoPanelLayout.setVerticalGroup(romInfoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(romInfoPanelLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.riRomNameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.riRomCodeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.riRomSupportLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.openROMButton.setText(bundle.getString("RandomizerGUI.openROMButton.text"));
        this.openROMButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.openROMButtonActionPerformed(evt);
            }
        });
        this.saveROMButton.setText(bundle.getString("RandomizerGUI.saveROMButton.text"));
        this.saveROMButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.saveROMButtonActionPerformed(evt);
            }
        });
        this.usePresetsButton.setText(bundle.getString("RandomizerGUI.usePresetsButton.text"));
        this.usePresetsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.usePresetsButtonActionPerformed(evt);
            }
        });
        this.loadQSButton.setText(bundle.getString("RandomizerGUI.loadQSButton.text"));
        this.loadQSButton.setToolTipText(bundle.getString("RandomizerGUI.loadQSButton.toolTipText"));
        this.loadQSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.loadQSButtonActionPerformed(evt);
            }
        });
        this.saveQSButton.setText(bundle.getString("RandomizerGUI.saveQSButton.text"));
        this.saveQSButton.setToolTipText(bundle.getString("RandomizerGUI.saveQSButton.toolTipText"));
        this.saveQSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.saveQSButtonActionPerformed(evt);
            }
        });
        this.settingsButton.setText(bundle.getString("RandomizerGUI.settingsButton.text"));
        this.settingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.settingsButtonActionPerformed(evt);
            }
        });
        this.pokemonTypesPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.pokemonTypesPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.pokeTypesButtonGroup.add(this.ptUnchangedRB);
        this.ptUnchangedRB.setSelected(true);
        this.ptUnchangedRB.setText(bundle.getString("RandomizerGUI.ptUnchangedRB.text"));
        this.ptUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.ptUnchangedRB.toolTipText"));
        this.pokeTypesButtonGroup.add(this.ptRandomFollowEvosRB);
        this.ptRandomFollowEvosRB.setText(bundle.getString("RandomizerGUI.ptRandomFollowEvosRB.text"));
        this.ptRandomFollowEvosRB.setToolTipText(bundle.getString("RandomizerGUI.ptRandomFollowEvosRB.toolTipText"));
        this.pokeTypesButtonGroup.add(this.ptRandomTotalRB);
        this.ptRandomTotalRB.setText(bundle.getString("RandomizerGUI.ptRandomTotalRB.text"));
        this.ptRandomTotalRB.setToolTipText(bundle.getString("RandomizerGUI.ptRandomTotalRB.toolTipText"));
        GroupLayout pokemonTypesPanelLayout = new GroupLayout(this.pokemonTypesPanel);
        this.pokemonTypesPanel.setLayout(pokemonTypesPanelLayout);
        pokemonTypesPanelLayout.setHorizontalGroup(pokemonTypesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonTypesPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokemonTypesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ptUnchangedRB).addComponent(this.ptRandomFollowEvosRB).addComponent(this.ptRandomTotalRB)).addContainerGap(-1, Short.MAX_VALUE)));
        pokemonTypesPanelLayout.setVerticalGroup(pokemonTypesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonTypesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ptUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ptRandomFollowEvosRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.ptRandomTotalRB).addContainerGap(-1, Short.MAX_VALUE)));
        this.baseStatsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.baseStatsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.pokeStatChangesButtonGroup.add(this.pbsChangesUnchangedRB);
        this.pbsChangesUnchangedRB.setSelected(true);
        this.pbsChangesUnchangedRB.setText(bundle.getString("RandomizerGUI.pbsChangesUnchangedRB.text"));
        this.pbsChangesUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.pbsChangesUnchangedRB.toolTipText"));
        this.pbsChangesUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pbsChangesUnchangedRBActionPerformed(evt);
            }
        });
        this.pokeStatChangesButtonGroup.add(this.pbsChangesShuffleRB);
        this.pbsChangesShuffleRB.setText(bundle.getString("RandomizerGUI.pbsChangesShuffleRB.text"));
        this.pbsChangesShuffleRB.setToolTipText(bundle.getString("RandomizerGUI.pbsChangesShuffleRB.toolTipText"));
        this.pbsChangesShuffleRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pbsChangesShuffleRBActionPerformed(evt);
            }
        });
        this.pokeStatChangesButtonGroup.add(this.pbsChangesRandomRB);
        this.pbsChangesRandomRB.setText(bundle.getString("RandomizerGUI.pbsChangesRandomRB.text"));
        this.pbsChangesRandomRB.setToolTipText(bundle.getString("RandomizerGUI.pbsChangesRandomRB.toolTipText"));
        this.pbsChangesRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pbsChangesRandomRBActionPerformed(evt);
            }
        });
        this.pbsStandardEXPCurvesCB.setText(bundle.getString("RandomizerGUI.pbsStandardEXPCurvesCB.text"));
        this.pbsStandardEXPCurvesCB.setToolTipText(bundle.getString("RandomizerGUI.pbsStandardEXPCurvesCB.toolTipText"));
        this.pbsFollowEvolutionsCB.setText(bundle.getString("RandomizerGUI.pbsFollowEvolutionsCB.text"));
        this.pbsFollowEvolutionsCB.setToolTipText(bundle.getString("RandomizerGUI.pbsFollowEvolutionsCB.toolTipText"));
        this.pbsUpdateStatsCB.setText(bundle.getString("RandomizerGUI.pbsUpdateStatsCB.text"));
        this.pbsUpdateStatsCB.setToolTipText(bundle.getString("RandomizerGUI.pbsUpdateStatsCB.toolTipText"));
        GroupLayout baseStatsPanelLayout = new GroupLayout(this.baseStatsPanel);
        this.baseStatsPanel.setLayout(baseStatsPanelLayout);
        baseStatsPanelLayout.setHorizontalGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(baseStatsPanelLayout.createSequentialGroup().addContainerGap().addGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pbsChangesShuffleRB).addComponent(this.pbsChangesUnchangedRB).addComponent(this.pbsChangesRandomRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 66, Short.MAX_VALUE).addGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pbsStandardEXPCurvesCB).addComponent(this.pbsFollowEvolutionsCB).addComponent(this.pbsUpdateStatsCB)).addGap(38, 38, 38)));
        baseStatsPanelLayout.setVerticalGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(baseStatsPanelLayout.createSequentialGroup().addContainerGap().addGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pbsChangesUnchangedRB).addComponent(this.pbsStandardEXPCurvesCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pbsChangesShuffleRB).addComponent(this.pbsFollowEvolutionsCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(baseStatsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pbsChangesRandomRB).addComponent(this.pbsUpdateStatsCB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.abilitiesPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.abilitiesPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.pokeAbilitiesButtonGroup.add(this.paUnchangedRB);
        this.paUnchangedRB.setSelected(true);
        this.paUnchangedRB.setText(bundle.getString("RandomizerGUI.paUnchangedRB.text"));
        this.paUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.paUnchangedRB.toolTipText"));
        this.paUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.paUnchangedRBActionPerformed(evt);
            }
        });
        this.pokeAbilitiesButtonGroup.add(this.paRandomizeRB);
        this.paRandomizeRB.setText(bundle.getString("RandomizerGUI.paRandomizeRB.text"));
        this.paRandomizeRB.setToolTipText(bundle.getString("RandomizerGUI.paRandomizeRB.toolTipText"));
        this.paRandomizeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.paRandomizeRBActionPerformed(evt);
            }
        });
        this.paWonderGuardCB.setText(bundle.getString("RandomizerGUI.paWonderGuardCB.text"));
        this.paWonderGuardCB.setToolTipText(bundle.getString("RandomizerGUI.paWonderGuardCB.toolTipText"));
        this.paFollowEvolutionsCB.setText(bundle.getString("RandomizerGUI.paFollowEvolutionsCB.text"));
        this.paFollowEvolutionsCB.setToolTipText(bundle.getString("RandomizerGUI.paFollowEvolutionsCB.toolTipText"));
        this.paBansLabel.setText(bundle.getString("RandomizerGUI.paBansLabel.text"));
        this.paBanTrappingCB.setText(bundle.getString("RandomizerGUI.paBanTrappingCB.text"));
        this.paBanTrappingCB.setToolTipText(bundle.getString("RandomizerGUI.paBanTrappingCB.toolTipText"));
        this.paBanNegativeCB.setText(bundle.getString("RandomizerGUI.paBanNegativeCB.text"));
        this.paBanNegativeCB.setToolTipText(bundle.getString("RandomizerGUI.paBanNegativeCB.toolTipText"));
        GroupLayout abilitiesPanelLayout = new GroupLayout(this.abilitiesPanel);
        this.abilitiesPanel.setLayout(abilitiesPanelLayout);
        abilitiesPanelLayout.setHorizontalGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(abilitiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(abilitiesPanelLayout.createSequentialGroup().addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paUnchangedRB).addComponent(this.paRandomizeRB)).addGap(32, 32, 32)).addGroup(GroupLayout.Alignment.TRAILING, abilitiesPanelLayout.createSequentialGroup().addComponent(this.paBansLabel).addGap(18, 18, 18))).addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.paWonderGuardCB).addGroup(abilitiesPanelLayout.createSequentialGroup().addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.paFollowEvolutionsCB).addComponent(this.paBanTrappingCB)).addGap(18, 18, 18).addComponent(this.paBanNegativeCB))).addContainerGap(25, Short.MAX_VALUE)));
        abilitiesPanelLayout.setVerticalGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(abilitiesPanelLayout.createSequentialGroup().addContainerGap().addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paUnchangedRB).addComponent(this.paWonderGuardCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paRandomizeRB).addComponent(this.paFollowEvolutionsCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(abilitiesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paBansLabel).addComponent(this.paBanTrappingCB).addComponent(this.paBanNegativeCB)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pokemonEvolutionsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.pokemonEvolutionsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.pokeEvolutionsButtonGroup.add(this.peUnchangedRB);
        this.peUnchangedRB.setSelected(true);
        this.peUnchangedRB.setText(bundle.getString("RandomizerGUI.peUnchangedRB.text"));
        this.peUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.peUnchangedRB.toolTipText"));
        this.peUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.peUnchangedRBActionPerformed(evt);
            }
        });
        this.pokeEvolutionsButtonGroup.add(this.peRandomRB);
        this.peRandomRB.setText(bundle.getString("RandomizerGUI.peRandomRB.text"));
        this.peRandomRB.setToolTipText(bundle.getString("RandomizerGUI.peRandomRB.toolTipText"));
        this.peRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.peRandomRBActionPerformed(evt);
            }
        });
        this.peSimilarStrengthCB.setText(bundle.getString("RandomizerGUI.peSimilarStrengthCB.text"));
        this.peSimilarStrengthCB.setToolTipText(bundle.getString("RandomizerGUI.peSimilarStrengthCB.toolTipText"));
        this.peSameTypeCB.setText(bundle.getString("RandomizerGUI.peSameTypeCB.text"));
        this.peSameTypeCB.setToolTipText(bundle.getString("RandomizerGUI.peSameTypeCB.toolTipText"));
        this.peThreeStagesCB.setText(bundle.getString("RandomizerGUI.peThreeStagesCB.text"));
        this.peThreeStagesCB.setToolTipText(bundle.getString("RandomizerGUI.peThreeStagesCB.toolTipText"));
        this.peForceChangeCB.setText(bundle.getString("RandomizerGUI.peForceChangeCB.text"));
        this.peForceChangeCB.setToolTipText(bundle.getString("RandomizerGUI.peForceChangeCB.toolTipText"));
        this.goRemoveTradeEvosCheckBox.setText(bundle.getString("RandomizerGUI.goRemoveTradeEvosCheckBox.text"));
        this.goRemoveTradeEvosCheckBox.setToolTipText(bundle.getString("RandomizerGUI.goRemoveTradeEvosCheckBox.toolTipText"));
        this.goCondenseEvosCheckBox.setText(bundle.getString("RandomizerGUI.goCondenseEvosCheckBox.text"));
        this.goCondenseEvosCheckBox.setToolTipText(bundle.getString("RandomizerGUI.goCondenseEvosCheckBox.toolTipText"));
        this.goCondenseEvosCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.goCondenseEvosCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout pokemonEvolutionsPanelLayout = new GroupLayout(this.pokemonEvolutionsPanel);
        this.pokemonEvolutionsPanel.setLayout(pokemonEvolutionsPanelLayout);
        pokemonEvolutionsPanelLayout.setHorizontalGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonEvolutionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peUnchangedRB).addComponent(this.peRandomRB)).addGap(83, 83, 83).addGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peForceChangeCB).addComponent(this.peThreeStagesCB).addGroup(GroupLayout.Alignment.TRAILING, pokemonEvolutionsPanelLayout.createSequentialGroup().addGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peSimilarStrengthCB).addComponent(this.peSameTypeCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.goCondenseEvosCheckBox).addComponent(this.goRemoveTradeEvosCheckBox)))).addContainerGap()));
        pokemonEvolutionsPanelLayout.setVerticalGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonEvolutionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peUnchangedRB).addComponent(this.peSimilarStrengthCB).addComponent(this.goRemoveTradeEvosCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pokemonEvolutionsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peRandomRB).addComponent(this.peSameTypeCB).addComponent(this.goCondenseEvosCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peThreeStagesCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peForceChangeCB).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout pokeTraitsPanelLayout = new GroupLayout(this.pokeTraitsPanel);
        this.pokeTraitsPanel.setLayout(pokeTraitsPanelLayout);
        pokeTraitsPanelLayout.setHorizontalGroup(pokeTraitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokeTraitsPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokeTraitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pokeTraitsPanelLayout.createSequentialGroup().addComponent(this.baseStatsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.abilitiesPanel, -2, -1, -2)).addComponent(this.pokemonTypesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.pokemonEvolutionsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        pokeTraitsPanelLayout.setVerticalGroup(pokeTraitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokeTraitsPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokeTraitsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.baseStatsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.abilitiesPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.pokemonTypesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pokemonEvolutionsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.pokeTraitsPanel.TabConstraints.tabTitle"), this.pokeTraitsPanel);
        this.starterPokemonPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.starterPokemonPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.starterPokemonButtonGroup.add(this.spUnchangedRB);
        this.spUnchangedRB.setSelected(true);
        this.spUnchangedRB.setText(bundle.getString("RandomizerGUI.spUnchangedRB.text"));
        this.spUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.spUnchangedRB.toolTipText"));
        this.spUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.spUnchangedRBActionPerformed(evt);
            }
        });
        this.starterPokemonButtonGroup.add(this.spCustomRB);
        this.spCustomRB.setText(bundle.getString("RandomizerGUI.spCustomRB.text"));
        this.spCustomRB.setToolTipText(bundle.getString("RandomizerGUI.spCustomRB.toolTipText"));
        this.spCustomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.spCustomRBActionPerformed(evt);
            }
        });
        this.spCustomPoke1Chooser.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.spCustomPoke1Chooser.setEnabled(false);
        this.spCustomPoke2Chooser.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.spCustomPoke2Chooser.setEnabled(false);
        this.spCustomPoke3Chooser.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.spCustomPoke3Chooser.setEnabled(false);
        this.starterPokemonButtonGroup.add(this.spRandomRB);
        this.spRandomRB.setText(bundle.getString("RandomizerGUI.spRandomRB.text"));
        this.spRandomRB.setToolTipText(bundle.getString("RandomizerGUI.spRandomRB.toolTipText"));
        this.spRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.spRandomRBActionPerformed(evt);
            }
        });
        this.starterPokemonButtonGroup.add(this.spRandom2EvosRB);
        this.spRandom2EvosRB.setText(bundle.getString("RandomizerGUI.spRandom2EvosRB.text"));
        this.spRandom2EvosRB.setToolTipText(bundle.getString("RandomizerGUI.spRandom2EvosRB.toolTipText"));
        this.spRandom2EvosRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.spRandom2EvosRBActionPerformed(evt);
            }
        });
        this.spHeldItemsCB.setText(bundle.getString("RandomizerGUI.spHeldItemsCB.text"));
        this.spHeldItemsCB.setToolTipText(bundle.getString("RandomizerGUI.spHeldItemsCB.toolTipText"));
        this.spHeldItemsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.spHeldItemsCBActionPerformed(evt);
            }
        });
        this.spHeldItemsBanBadCB.setText(bundle.getString("RandomizerGUI.spHeldItemsBanBadCB.text"));
        this.spHeldItemsBanBadCB.setToolTipText(bundle.getString("RandomizerGUI.spHeldItemsBanBadCB.toolTipText"));
        GroupLayout starterPokemonPanelLayout = new GroupLayout(this.starterPokemonPanel);
        this.starterPokemonPanel.setLayout(starterPokemonPanelLayout);
        starterPokemonPanelLayout.setHorizontalGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starterPokemonPanelLayout.createSequentialGroup().addContainerGap().addGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spRandom2EvosRB).addGroup(starterPokemonPanelLayout.createSequentialGroup().addGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starterPokemonPanelLayout.createSequentialGroup().addComponent(this.spCustomRB).addGap(18, 18, 18).addComponent(this.spCustomPoke1Chooser, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spCustomPoke2Chooser, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spCustomPoke3Chooser, -2, 90, -2)).addComponent(this.spRandomRB).addComponent(this.spUnchangedRB)).addGap(18, 18, 18).addGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.spHeldItemsBanBadCB).addComponent(this.spHeldItemsCB)))).addContainerGap(168, Short.MAX_VALUE)));
        starterPokemonPanelLayout.setVerticalGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(starterPokemonPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.spUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spCustomRB).addComponent(this.spCustomPoke1Chooser, -2, -1, -2).addComponent(this.spCustomPoke2Chooser, -2, -1, -2).addComponent(this.spCustomPoke3Chooser, -2, -1, -2).addComponent(this.spHeldItemsCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(starterPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spRandomRB).addComponent(this.spHeldItemsBanBadCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.spRandom2EvosRB).addContainerGap(-1, Short.MAX_VALUE)));
        this.staticPokemonPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.staticPokemonPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.staticPokemonButtonGroup.add(this.stpUnchangedRB);
        this.stpUnchangedRB.setSelected(true);
        this.stpUnchangedRB.setText(bundle.getString("RandomizerGUI.stpUnchangedRB.text"));
        this.stpUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.stpUnchangedRB.toolTipText"));
        this.staticPokemonButtonGroup.add(this.stpRandomL4LRB);
        this.stpRandomL4LRB.setText(bundle.getString("RandomizerGUI.stpRandomL4LRB.text"));
        this.stpRandomL4LRB.setToolTipText(bundle.getString("RandomizerGUI.stpRandomL4LRB.toolTipText"));
        this.staticPokemonButtonGroup.add(this.stpRandomTotalRB);
        this.stpRandomTotalRB.setText(bundle.getString("RandomizerGUI.stpRandomTotalRB.text"));
        this.stpRandomTotalRB.setToolTipText(bundle.getString("RandomizerGUI.stpRandomTotalRB.toolTipText"));
        GroupLayout staticPokemonPanelLayout = new GroupLayout(this.staticPokemonPanel);
        this.staticPokemonPanel.setLayout(staticPokemonPanelLayout);
        staticPokemonPanelLayout.setHorizontalGroup(staticPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(staticPokemonPanelLayout.createSequentialGroup().addContainerGap().addGroup(staticPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stpUnchangedRB).addComponent(this.stpRandomL4LRB).addComponent(this.stpRandomTotalRB)).addContainerGap(407, Short.MAX_VALUE)));
        staticPokemonPanelLayout.setVerticalGroup(staticPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(staticPokemonPanelLayout.createSequentialGroup().addComponent(this.stpUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stpRandomL4LRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.stpRandomTotalRB)));
        this.inGameTradesPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.inGameTradesPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.ingameTradesButtonGroup.add(this.igtUnchangedRB);
        this.igtUnchangedRB.setSelected(true);
        this.igtUnchangedRB.setText(bundle.getString("RandomizerGUI.igtUnchangedRB.text"));
        this.igtUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.igtUnchangedRB.toolTipText"));
        this.igtUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.igtUnchangedRBActionPerformed(evt);
            }
        });
        this.ingameTradesButtonGroup.add(this.igtGivenOnlyRB);
        this.igtGivenOnlyRB.setText(bundle.getString("RandomizerGUI.igtGivenOnlyRB.text"));
        this.igtGivenOnlyRB.setToolTipText(bundle.getString("RandomizerGUI.igtGivenOnlyRB.toolTipText"));
        this.igtGivenOnlyRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.igtGivenOnlyRBActionPerformed(evt);
            }
        });
        this.ingameTradesButtonGroup.add(this.igtBothRB);
        this.igtBothRB.setText(bundle.getString("RandomizerGUI.igtBothRB.text"));
        this.igtBothRB.setToolTipText(bundle.getString("RandomizerGUI.igtBothRB.toolTipText"));
        this.igtBothRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.igtBothRBActionPerformed(evt);
            }
        });
        this.igtRandomNicknameCB.setText(bundle.getString("RandomizerGUI.igtRandomNicknameCB.text"));
        this.igtRandomNicknameCB.setToolTipText(bundle.getString("RandomizerGUI.igtRandomNicknameCB.toolTipText"));
        this.igtRandomOTCB.setText(bundle.getString("RandomizerGUI.igtRandomOTCB.text"));
        this.igtRandomOTCB.setToolTipText(bundle.getString("RandomizerGUI.igtRandomOTCB.toolTipText"));
        this.igtRandomIVsCB.setText(bundle.getString("RandomizerGUI.igtRandomIVsCB.text"));
        this.igtRandomIVsCB.setToolTipText(bundle.getString("RandomizerGUI.igtRandomIVsCB.toolTipText"));
        this.igtRandomItemCB.setText(bundle.getString("RandomizerGUI.igtRandomItemCB.text"));
        this.igtRandomItemCB.setToolTipText(bundle.getString("RandomizerGUI.igtRandomItemCB.toolTipText"));
        GroupLayout inGameTradesPanelLayout = new GroupLayout(this.inGameTradesPanel);
        this.inGameTradesPanel.setLayout(inGameTradesPanelLayout);
        inGameTradesPanelLayout.setHorizontalGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, inGameTradesPanelLayout.createSequentialGroup().addContainerGap().addGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.igtUnchangedRB).addComponent(this.igtGivenOnlyRB).addComponent(this.igtBothRB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 229, Short.MAX_VALUE).addGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.igtRandomItemCB).addComponent(this.igtRandomNicknameCB).addComponent(this.igtRandomOTCB).addComponent(this.igtRandomIVsCB)).addGap(113, 113, 113)));
        inGameTradesPanelLayout.setVerticalGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inGameTradesPanelLayout.createSequentialGroup().addGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.igtUnchangedRB).addComponent(this.igtRandomNicknameCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.igtGivenOnlyRB).addComponent(this.igtRandomOTCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(inGameTradesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.igtBothRB).addComponent(this.igtRandomIVsCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.igtRandomItemCB).addContainerGap(11, Short.MAX_VALUE)));
        GroupLayout startersInnerPanelLayout = new GroupLayout(this.startersInnerPanel);
        this.startersInnerPanel.setLayout(startersInnerPanelLayout);
        startersInnerPanelLayout.setHorizontalGroup(startersInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startersInnerPanelLayout.createSequentialGroup().addContainerGap().addGroup(startersInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.starterPokemonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.staticPokemonPanel, -1, -1, Short.MAX_VALUE).addComponent(this.inGameTradesPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        startersInnerPanelLayout.setVerticalGroup(startersInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startersInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.starterPokemonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.staticPokemonPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inGameTradesPanel, -2, -1, -2).addContainerGap(28, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.startersInnerPanel.TabConstraints.tabTitle"), this.startersInnerPanel);
        this.pokemonMovesetsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.pokemonMovesetsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.pokeMovesetsButtonGroup.add(this.pmsUnchangedRB);
        this.pmsUnchangedRB.setSelected(true);
        this.pmsUnchangedRB.setText(bundle.getString("RandomizerGUI.pmsUnchangedRB.text"));
        this.pmsUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.pmsUnchangedRB.toolTipText"));
        this.pmsUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pmsUnchangedRBActionPerformed(evt);
            }
        });
        this.pokeMovesetsButtonGroup.add(this.pmsRandomTypeRB);
        this.pmsRandomTypeRB.setText(bundle.getString("RandomizerGUI.pmsRandomTypeRB.text"));
        this.pmsRandomTypeRB.setToolTipText(bundle.getString("RandomizerGUI.pmsRandomTypeRB.toolTipText"));
        this.pmsRandomTypeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pmsRandomTypeRBActionPerformed(evt);
            }
        });
        this.pokeMovesetsButtonGroup.add(this.pmsRandomTotalRB);
        this.pmsRandomTotalRB.setText(bundle.getString("RandomizerGUI.pmsRandomTotalRB.text"));
        this.pmsRandomTotalRB.setToolTipText(bundle.getString("RandomizerGUI.pmsRandomTotalRB.toolTipText"));
        this.pmsRandomTotalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pmsRandomTotalRBActionPerformed(evt);
            }
        });
        this.pokeMovesetsButtonGroup.add(this.pmsMetronomeOnlyRB);
        this.pmsMetronomeOnlyRB.setText(bundle.getString("RandomizerGUI.pmsMetronomeOnlyRB.text"));
        this.pmsMetronomeOnlyRB.setToolTipText(bundle.getString("RandomizerGUI.pmsMetronomeOnlyRB.toolTipText"));
        this.pmsMetronomeOnlyRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pmsMetronomeOnlyRBActionPerformed(evt);
            }
        });
        this.pms4MovesCB.setText(bundle.getString("RandomizerGUI.pms4MovesCB.text"));
        this.pms4MovesCB.setToolTipText(bundle.getString("RandomizerGUI.pms4MovesCB.toolTipText"));
        this.pmsReorderDamagingMovesCB.setText(bundle.getString("RandomizerGUI.pmsReorderDamagingMovesCB.text"));
        this.pmsReorderDamagingMovesCB.setToolTipText(bundle.getString("RandomizerGUI.pmsReorderDamagingMovesCB.toolTipText"));
        this.pmsForceGoodDamagingCB.setText(bundle.getString("RandomizerGUI.pmsForceGoodDamagingCB.text"));
        this.pmsForceGoodDamagingCB.setToolTipText(bundle.getString("RandomizerGUI.pmsForceGoodDamagingCB.toolTipText"));
        this.pmsForceGoodDamagingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.pmsForceGoodDamagingCBActionPerformed(evt);
            }
        });
        this.pmsForceGoodDamagingSlider.setMajorTickSpacing(20);
        this.pmsForceGoodDamagingSlider.setMinorTickSpacing(5);
        this.pmsForceGoodDamagingSlider.setPaintLabels(true);
        this.pmsForceGoodDamagingSlider.setPaintTicks(true);
        this.pmsForceGoodDamagingSlider.setSnapToTicks(true);
        this.pmsForceGoodDamagingSlider.setToolTipText(bundle.getString("RandomizerGUI.pmsForceGoodDamagingSlider.toolTipText"));
        this.pmsForceGoodDamagingSlider.setValue(0);
        GroupLayout pokemonMovesetsPanelLayout = new GroupLayout(this.pokemonMovesetsPanel);
        this.pokemonMovesetsPanel.setLayout(pokemonMovesetsPanelLayout);
        pokemonMovesetsPanelLayout.setHorizontalGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonMovesetsPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonMovesetsPanelLayout.createSequentialGroup().addComponent(this.pmsUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pms4MovesCB).addGap(151, 151, 151)).addGroup(pokemonMovesetsPanelLayout.createSequentialGroup().addComponent(this.pmsRandomTypeRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pmsReorderDamagingMovesCB).addGap(203, 203, 203)).addGroup(pokemonMovesetsPanelLayout.createSequentialGroup().addComponent(this.pmsRandomTotalRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pmsForceGoodDamagingCB).addGap(161, 161, 161)).addGroup(pokemonMovesetsPanelLayout.createSequentialGroup().addComponent(this.pmsMetronomeOnlyRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pmsForceGoodDamagingSlider, -2, -1, -2).addGap(152, 152, 152)))));
        pokemonMovesetsPanelLayout.setVerticalGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pokemonMovesetsPanelLayout.createSequentialGroup().addContainerGap().addGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pmsUnchangedRB).addComponent(this.pms4MovesCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pmsRandomTypeRB).addComponent(this.pmsReorderDamagingMovesCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pmsRandomTotalRB).addComponent(this.pmsForceGoodDamagingCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pokemonMovesetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pmsMetronomeOnlyRB).addComponent(this.pmsForceGoodDamagingSlider, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.moveDataPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.moveDataPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.mdRandomPowerCB.setText(bundle.getString("RandomizerGUI.mdRandomPowerCB.text"));
        this.mdRandomPowerCB.setToolTipText(bundle.getString("RandomizerGUI.mdRandomPowerCB.toolTipText"));
        this.mdRandomAccuracyCB.setText(bundle.getString("RandomizerGUI.mdRandomAccuracyCB.text"));
        this.mdRandomAccuracyCB.setToolTipText(bundle.getString("RandomizerGUI.mdRandomAccuracyCB.toolTipText"));
        this.mdRandomPPCB.setText(bundle.getString("RandomizerGUI.mdRandomPPCB.text"));
        this.mdRandomPPCB.setToolTipText(bundle.getString("RandomizerGUI.mdRandomPPCB.toolTipText"));
        this.mdRandomTypeCB.setText(bundle.getString("RandomizerGUI.mdRandomTypeCB.text"));
        this.mdRandomTypeCB.setToolTipText(bundle.getString("RandomizerGUI.mdRandomTypeCB.toolTipText"));
        this.mdRandomCategoryCB.setText(bundle.getString("RandomizerGUI.mdRandomCategoryCB.text"));
        this.mdRandomCategoryCB.setToolTipText(bundle.getString("RandomizerGUI.mdRandomCategoryCB.toolTipText"));
        this.goUpdateMovesCheckBox.setText(bundle.getString("RandomizerGUI.goUpdateMovesCheckBox.text"));
        this.goUpdateMovesCheckBox.setToolTipText(bundle.getString("RandomizerGUI.goUpdateMovesCheckBox.toolTipText"));
        this.goUpdateMovesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.goUpdateMovesCheckBoxActionPerformed(evt);
            }
        });
        this.goUpdateMovesLegacyCheckBox.setText(bundle.getString("RandomizerGUI.goUpdateMovesLegacyCheckBox.text"));
        this.goUpdateMovesLegacyCheckBox.setToolTipText(bundle.getString("RandomizerGUI.goUpdateMovesLegacyCheckBox.toolTipText"));
        GroupLayout moveDataPanelLayout = new GroupLayout(this.moveDataPanel);
        this.moveDataPanel.setLayout(moveDataPanelLayout);
        moveDataPanelLayout.setHorizontalGroup(moveDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moveDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(moveDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mdRandomPowerCB).addComponent(this.mdRandomAccuracyCB).addComponent(this.mdRandomPPCB).addComponent(this.mdRandomTypeCB)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 211, Short.MAX_VALUE).addGroup(moveDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mdRandomCategoryCB).addGroup(moveDataPanelLayout.createSequentialGroup().addComponent(this.goUpdateMovesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.goUpdateMovesLegacyCheckBox))).addGap(190, 190, 190)));
        moveDataPanelLayout.setVerticalGroup(moveDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moveDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(moveDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mdRandomPowerCB).addComponent(this.mdRandomCategoryCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mdRandomAccuracyCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mdRandomPPCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(moveDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mdRandomTypeCB).addComponent(this.goUpdateMovesCheckBox).addComponent(this.goUpdateMovesLegacyCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout movesAndSetsPanelLayout = new GroupLayout(this.movesAndSetsPanel);
        this.movesAndSetsPanel.setLayout(movesAndSetsPanelLayout);
        movesAndSetsPanelLayout.setHorizontalGroup(movesAndSetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(movesAndSetsPanelLayout.createSequentialGroup().addContainerGap().addGroup(movesAndSetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moveDataPanel, -1, -1, Short.MAX_VALUE).addComponent(this.pokemonMovesetsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        movesAndSetsPanelLayout.setVerticalGroup(movesAndSetsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(movesAndSetsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.moveDataPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pokemonMovesetsPanel, -2, -1, -2).addContainerGap(109, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.movesAndSetsPanel.TabConstraints.tabTitle"), this.movesAndSetsPanel);
        this.trainersPokemonPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.trainersPokemonPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.trainerPokesButtonGroup.add(this.tpUnchangedRB);
        this.tpUnchangedRB.setSelected(true);
        this.tpUnchangedRB.setText(bundle.getString("RandomizerGUI.tpUnchangedRB.text"));
        this.tpUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.tpUnchangedRB.toolTipText"));
        this.tpUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tpUnchangedRBActionPerformed(evt);
            }
        });
        this.trainerPokesButtonGroup.add(this.tpRandomRB);
        this.tpRandomRB.setText(bundle.getString("RandomizerGUI.tpRandomRB.text"));
        this.tpRandomRB.setToolTipText(bundle.getString("RandomizerGUI.tpRandomRB.toolTipText"));
        this.tpRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tpRandomRBActionPerformed(evt);
            }
        });
        this.trainerPokesButtonGroup.add(this.tpTypeThemedRB);
        this.tpTypeThemedRB.setText(bundle.getString("RandomizerGUI.tpTypeThemedRB.text"));
        this.tpTypeThemedRB.setToolTipText(bundle.getString("RandomizerGUI.tpTypeThemedRB.toolTipText"));
        this.tpTypeThemedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tpTypeThemedRBActionPerformed(evt);
            }
        });
        this.tpPowerLevelsCB.setText(bundle.getString("RandomizerGUI.tpPowerLevelsCB.text"));
        this.tpPowerLevelsCB.setToolTipText(bundle.getString("RandomizerGUI.tpPowerLevelsCB.toolTipText"));
        this.tpPowerLevelsCB.setEnabled(false);
        this.tpTypeWeightingCB.setText(bundle.getString("RandomizerGUI.tpTypeWeightingCB.text"));
        this.tpTypeWeightingCB.setToolTipText(bundle.getString("RandomizerGUI.tpTypeWeightingCB.toolTipText"));
        this.tpTypeWeightingCB.setEnabled(false);
        this.tpRivalCarriesStarterCB.setText(bundle.getString("RandomizerGUI.tpRivalCarriesStarterCB.text"));
        this.tpRivalCarriesStarterCB.setToolTipText(bundle.getString("RandomizerGUI.tpRivalCarriesStarterCB.toolTipText"));
        this.tpRivalCarriesStarterCB.setEnabled(false);
        this.tpNoLegendariesCB.setText(bundle.getString("RandomizerGUI.tpNoLegendariesCB.text"));
        this.tpNoLegendariesCB.setEnabled(false);
        this.tnRandomizeCB.setText(bundle.getString("RandomizerGUI.tnRandomizeCB.text"));
        this.tnRandomizeCB.setToolTipText(bundle.getString("RandomizerGUI.tnRandomizeCB.toolTipText"));
        this.tcnRandomizeCB.setText(bundle.getString("RandomizerGUI.tcnRandomizeCB.text"));
        this.tcnRandomizeCB.setToolTipText(bundle.getString("RandomizerGUI.tcnRandomizeCB.toolTipText"));
        this.tpNoEarlyShedinjaCB.setText(bundle.getString("RandomizerGUI.tpNoEarlyShedinjaCB.text"));
        this.tpNoEarlyShedinjaCB.setToolTipText(bundle.getString("RandomizerGUI.tpNoEarlyShedinjaCB.toolTipText"));
        this.tpForceFullyEvolvedCB.setText(bundle.getString("RandomizerGUI.tpForceFullyEvolvedCB.text"));
        this.tpForceFullyEvolvedCB.setToolTipText(bundle.getString("RandomizerGUI.tpForceFullyEvolvedCB.toolTipText"));
        this.tpForceFullyEvolvedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tpForceFullyEvolvedCBActionPerformed(evt);
            }
        });
        this.tpForceFullyEvolvedSlider.setMajorTickSpacing(5);
        this.tpForceFullyEvolvedSlider.setMaximum(65);
        this.tpForceFullyEvolvedSlider.setMinimum(30);
        this.tpForceFullyEvolvedSlider.setMinorTickSpacing(1);
        this.tpForceFullyEvolvedSlider.setPaintLabels(true);
        this.tpForceFullyEvolvedSlider.setPaintTicks(true);
        this.tpForceFullyEvolvedSlider.setToolTipText(bundle.getString("RandomizerGUI.tpForceFullyEvolvedSlider.toolTipText"));
        this.tpForceFullyEvolvedSlider.setValue(30);
        this.tpLevelModifierCB.setText(bundle.getString("RandomizerGUI.tpLevelModifierCB.text"));
        this.tpLevelModifierCB.setToolTipText(bundle.getString("RandomizerGUI.tpLevelModifierCB.toolTipText"));
        this.tpLevelModifierCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tpLevelModifierCBActionPerformed(evt);
            }
        });
        this.tpLevelModifierSlider.setMajorTickSpacing(10);
        this.tpLevelModifierSlider.setMaximum(50);
        this.tpLevelModifierSlider.setMinimum(-50);
        this.tpLevelModifierSlider.setMinorTickSpacing(2);
        this.tpLevelModifierSlider.setPaintLabels(true);
        this.tpLevelModifierSlider.setPaintTicks(true);
        this.tpLevelModifierSlider.setToolTipText(bundle.getString("RandomizerGUI.tpLevelModifierSlider.toolTipText"));
        this.tpLevelModifierSlider.setValue(0);
        GroupLayout trainersPokemonPanelLayout = new GroupLayout(this.trainersPokemonPanel);
        this.trainersPokemonPanel.setLayout(trainersPokemonPanelLayout);
        trainersPokemonPanelLayout.setHorizontalGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trainersPokemonPanelLayout.createSequentialGroup().addContainerGap().addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tpTypeThemedRB).addGroup(trainersPokemonPanelLayout.createSequentialGroup().addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tpUnchangedRB).addComponent(this.tpRandomRB)).addGap(47, 47, 47).addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tpTypeWeightingCB, -1, -1, Short.MAX_VALUE).addComponent(this.tpRivalCarriesStarterCB, -1, -1, Short.MAX_VALUE).addComponent(this.tpPowerLevelsCB, -1, -1, Short.MAX_VALUE).addComponent(this.tpNoLegendariesCB, -1, -1, Short.MAX_VALUE)).addComponent(this.tpNoEarlyShedinjaCB)).addGap(18, 18, 18).addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tnRandomizeCB).addComponent(this.tcnRandomizeCB).addComponent(this.tpForceFullyEvolvedCB).addComponent(this.tpForceFullyEvolvedSlider, -2, -1, -2).addComponent(this.tpLevelModifierCB).addComponent(this.tpLevelModifierSlider, -2, -1, -2)))).addContainerGap(143, Short.MAX_VALUE)));
        trainersPokemonPanelLayout.setVerticalGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trainersPokemonPanelLayout.createSequentialGroup().addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tpUnchangedRB).addComponent(this.tpRivalCarriesStarterCB).addComponent(this.tnRandomizeCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tpRandomRB).addComponent(this.tpPowerLevelsCB).addComponent(this.tcnRandomizeCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tpTypeThemedRB).addComponent(this.tpTypeWeightingCB).addComponent(this.tpForceFullyEvolvedCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(trainersPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trainersPokemonPanelLayout.createSequentialGroup().addComponent(this.tpNoLegendariesCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tpNoEarlyShedinjaCB)).addComponent(this.tpForceFullyEvolvedSlider, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tpLevelModifierCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tpLevelModifierSlider, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout trainersInnerPanelLayout = new GroupLayout(this.trainersInnerPanel);
        this.trainersInnerPanel.setLayout(trainersInnerPanelLayout);
        trainersInnerPanelLayout.setHorizontalGroup(trainersInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trainersInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.trainersPokemonPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        trainersInnerPanelLayout.setVerticalGroup(trainersInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(trainersInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.trainersPokemonPanel, -2, -1, -2).addContainerGap(180, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.trainersInnerPanel.TabConstraints.tabTitle"), this.trainersInnerPanel);
        this.wildPokemonPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.wildPokemonPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.wildPokesButtonGroup.add(this.wpUnchangedRB);
        this.wpUnchangedRB.setSelected(true);
        this.wpUnchangedRB.setText(bundle.getString("RandomizerGUI.wpUnchangedRB.text"));
        this.wpUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.wpUnchangedRB.toolTipText"));
        this.wpUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpUnchangedRBActionPerformed(evt);
            }
        });
        this.wildPokesButtonGroup.add(this.wpRandomRB);
        this.wpRandomRB.setText(bundle.getString("RandomizerGUI.wpRandomRB.text"));
        this.wpRandomRB.setToolTipText(bundle.getString("RandomizerGUI.wpRandomRB.toolTipText"));
        this.wpRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpRandomRBActionPerformed(evt);
            }
        });
        this.wildPokesButtonGroup.add(this.wpArea11RB);
        this.wpArea11RB.setText(bundle.getString("RandomizerGUI.wpArea11RB.text"));
        this.wpArea11RB.setToolTipText(bundle.getString("RandomizerGUI.wpArea11RB.toolTipText"));
        this.wpArea11RB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpArea11RBActionPerformed(evt);
            }
        });
        this.wildPokesButtonGroup.add(this.wpGlobalRB);
        this.wpGlobalRB.setText(bundle.getString("RandomizerGUI.wpGlobalRB.text"));
        this.wpGlobalRB.setToolTipText(bundle.getString("RandomizerGUI.wpGlobalRB.toolTipText"));
        this.wpGlobalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpGlobalRBActionPerformed(evt);
            }
        });
        this.wildPokemonARulePanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RandomizerGUI.wildPokemonARulePanel.border.title")));
        this.wildPokesARuleButtonGroup.add(this.wpARNoneRB);
        this.wpARNoneRB.setSelected(true);
        this.wpARNoneRB.setText(bundle.getString("RandomizerGUI.wpARNoneRB.text"));
        this.wpARNoneRB.setToolTipText(bundle.getString("RandomizerGUI.wpARNoneRB.toolTipText"));
        this.wpARNoneRB.setEnabled(false);
        this.wpARNoneRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpARNoneRBActionPerformed(evt);
            }
        });
        this.wildPokesARuleButtonGroup.add(this.wpARCatchEmAllRB);
        this.wpARCatchEmAllRB.setText(bundle.getString("RandomizerGUI.wpARCatchEmAllRB.text"));
        this.wpARCatchEmAllRB.setToolTipText(bundle.getString("RandomizerGUI.wpARCatchEmAllRB.toolTipText"));
        this.wpARCatchEmAllRB.setEnabled(false);
        this.wpARCatchEmAllRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpARCatchEmAllRBActionPerformed(evt);
            }
        });
        this.wildPokesARuleButtonGroup.add(this.wpARTypeThemedRB);
        this.wpARTypeThemedRB.setText(bundle.getString("RandomizerGUI.wpARTypeThemedRB.text"));
        this.wpARTypeThemedRB.setToolTipText(bundle.getString("RandomizerGUI.wpARTypeThemedRB.toolTipText"));
        this.wpARTypeThemedRB.setEnabled(false);
        this.wpARTypeThemedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpARTypeThemedRBActionPerformed(evt);
            }
        });
        this.wildPokesARuleButtonGroup.add(this.wpARSimilarStrengthRB);
        this.wpARSimilarStrengthRB.setText(bundle.getString("RandomizerGUI.wpARSimilarStrengthRB.text"));
        this.wpARSimilarStrengthRB.setToolTipText(bundle.getString("RandomizerGUI.wpARSimilarStrengthRB.toolTipText"));
        this.wpARSimilarStrengthRB.setEnabled(false);
        this.wpARSimilarStrengthRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpARSimilarStrengthRBActionPerformed(evt);
            }
        });
        GroupLayout wildPokemonARulePanelLayout = new GroupLayout(this.wildPokemonARulePanel);
        this.wildPokemonARulePanel.setLayout(wildPokemonARulePanelLayout);
        wildPokemonARulePanelLayout.setHorizontalGroup(wildPokemonARulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wildPokemonARulePanelLayout.createSequentialGroup().addContainerGap().addGroup(wildPokemonARulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wildPokemonARulePanelLayout.createSequentialGroup().addComponent(this.wpARTypeThemedRB).addGap(0, 0, Short.MAX_VALUE)).addGroup(wildPokemonARulePanelLayout.createSequentialGroup().addGroup(wildPokemonARulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wpARSimilarStrengthRB).addComponent(this.wpARNoneRB).addComponent(this.wpARCatchEmAllRB)).addContainerGap(58, Short.MAX_VALUE)))));
        wildPokemonARulePanelLayout.setVerticalGroup(wildPokemonARulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wildPokemonARulePanelLayout.createSequentialGroup().addComponent(this.wpARNoneRB).addGap(3, 3, 3).addComponent(this.wpARSimilarStrengthRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpARCatchEmAllRB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 3, Short.MAX_VALUE).addComponent(this.wpARTypeThemedRB, -2, 30, -2).addContainerGap()));
        this.wpUseTimeCB.setText(bundle.getString("RandomizerGUI.wpUseTimeCB.text"));
        this.wpUseTimeCB.setToolTipText(bundle.getString("RandomizerGUI.wpUseTimeCB.toolTipText"));
        this.wpNoLegendariesCB.setText(bundle.getString("RandomizerGUI.wpNoLegendariesCB.text"));
        this.wpCatchRateCB.setText(bundle.getString("RandomizerGUI.wpCatchRateCB.text"));
        this.wpCatchRateCB.setToolTipText(bundle.getString("RandomizerGUI.wpCatchRateCB.toolTipText"));
        this.wpCatchRateCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpCatchRateCBActionPerformed(evt);
            }
        });
        this.wpHeldItemsCB.setText(bundle.getString("RandomizerGUI.wpHeldItemsCB.text"));
        this.wpHeldItemsCB.setToolTipText(bundle.getString("RandomizerGUI.wpHeldItemsCB.toolTipText"));
        this.wpHeldItemsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.wpHeldItemsCBActionPerformed(evt);
            }
        });
        this.wpHeldItemsBanBadCB.setText(bundle.getString("RandomizerGUI.wpHeldItemsBanBadCB.text"));
        this.wpHeldItemsBanBadCB.setToolTipText(bundle.getString("RandomizerGUI.wpHeldItemsBanBadCB.toolTipText"));
        this.wpCatchRateSlider.setMajorTickSpacing(1);
        this.wpCatchRateSlider.setMaximum(4);
        this.wpCatchRateSlider.setMinimum(1);
        this.wpCatchRateSlider.setPaintLabels(true);
        this.wpCatchRateSlider.setToolTipText(bundle.getString("RandomizerGUI.wpCatchRateSlider.toolTipText"));
        this.wpCatchRateSlider.setValue(1);
        GroupLayout wildPokemonPanelLayout = new GroupLayout(this.wildPokemonPanel);
        this.wildPokemonPanel.setLayout(wildPokemonPanelLayout);
        wildPokemonPanelLayout.setHorizontalGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wildPokemonPanelLayout.createSequentialGroup().addContainerGap().addGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wpUnchangedRB).addComponent(this.wpRandomRB).addComponent(this.wpArea11RB).addComponent(this.wpGlobalRB)).addGap(18, 18, 18).addComponent(this.wildPokemonARulePanel, -2, -1, -2).addGap(18, 18, 18).addGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wpUseTimeCB).addComponent(this.wpNoLegendariesCB).addGroup(wildPokemonPanelLayout.createSequentialGroup().addGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wpCatchRateCB).addComponent(this.wpHeldItemsCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpCatchRateSlider, -2, -1, -2)).addComponent(this.wpHeldItemsBanBadCB)).addContainerGap(-1, Short.MAX_VALUE)));
        wildPokemonPanelLayout.setVerticalGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(wildPokemonPanelLayout.createSequentialGroup().addContainerGap().addGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wildPokemonPanelLayout.createSequentialGroup().addComponent(this.wpUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpRandomRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpArea11RB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpGlobalRB)).addGroup(wildPokemonPanelLayout.createSequentialGroup().addComponent(this.wpUseTimeCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpNoLegendariesCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(wildPokemonPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.wpCatchRateSlider, -2, -1, -2).addGroup(wildPokemonPanelLayout.createSequentialGroup().addComponent(this.wpCatchRateCB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpHeldItemsCB))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.wpHeldItemsBanBadCB)).addComponent(this.wildPokemonARulePanel, -2, -1, -2)).addGap(9, 9, 9)));
        GroupLayout wildsInnerPanelLayout = new GroupLayout(this.wildsInnerPanel);
        this.wildsInnerPanel.setLayout(wildsInnerPanelLayout);
        wildsInnerPanelLayout.setHorizontalGroup(wildsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, wildsInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.wildPokemonPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        wildsInnerPanelLayout.setVerticalGroup(wildsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(wildsInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.wildPokemonPanel, -2, -1, -2).addContainerGap(245, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.wildsInnerPanel.TabConstraints.tabTitle"), this.wildsInnerPanel);
        this.tmhmsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.tmhmsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.tmMovesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RandomizerGUI.tmMovesPanel.border.title")));
        this.tmMovesButtonGroup.add(this.tmmUnchangedRB);
        this.tmmUnchangedRB.setSelected(true);
        this.tmmUnchangedRB.setText(bundle.getString("RandomizerGUI.tmmUnchangedRB.text"));
        this.tmmUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.tmmUnchangedRB.toolTipText"));
        this.tmmUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tmmUnchangedRBActionPerformed(evt);
            }
        });
        this.tmMovesButtonGroup.add(this.tmmRandomRB);
        this.tmmRandomRB.setText(bundle.getString("RandomizerGUI.tmmRandomRB.text"));
        this.tmmRandomRB.setToolTipText(bundle.getString("RandomizerGUI.tmmRandomRB.toolTipText"));
        this.tmmRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tmmRandomRBActionPerformed(evt);
            }
        });
        this.tmLearningSanityCB.setText(bundle.getString("RandomizerGUI.tmLearningSanityCB.text"));
        this.tmLearningSanityCB.setToolTipText(bundle.getString("RandomizerGUI.tmLearningSanityCB.toolTipText"));
        this.tmKeepFieldMovesCB.setText(bundle.getString("RandomizerGUI.tmKeepFieldMovesCB.text"));
        this.tmKeepFieldMovesCB.setToolTipText(bundle.getString("RandomizerGUI.tmKeepFieldMovesCB.toolTipText"));
        this.tmFullHMCompatCB.setText(bundle.getString("RandomizerGUI.tmFullHMCompatCB.text"));
        this.tmFullHMCompatCB.setToolTipText(bundle.getString("RandomizerGUI.tmFullHMCompatCB.toolTipText"));
        this.tmForceGoodDamagingCB.setText(bundle.getString("RandomizerGUI.tmForceGoodDamagingCB.text"));
        this.tmForceGoodDamagingCB.setToolTipText(bundle.getString("RandomizerGUI.tmForceGoodDamagingCB.toolTipText"));
        this.tmForceGoodDamagingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.tmForceGoodDamagingCBActionPerformed(evt);
            }
        });
        this.tmForceGoodDamagingSlider.setMajorTickSpacing(20);
        this.tmForceGoodDamagingSlider.setMinorTickSpacing(5);
        this.tmForceGoodDamagingSlider.setPaintLabels(true);
        this.tmForceGoodDamagingSlider.setPaintTicks(true);
        this.tmForceGoodDamagingSlider.setSnapToTicks(true);
        this.tmForceGoodDamagingSlider.setToolTipText(bundle.getString("RandomizerGUI.tmForceGoodDamagingSlider.toolTipText"));
        this.tmForceGoodDamagingSlider.setValue(0);
        GroupLayout tmMovesPanelLayout = new GroupLayout(this.tmMovesPanel);
        this.tmMovesPanel.setLayout(tmMovesPanelLayout);
        tmMovesPanelLayout.setHorizontalGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmMovesPanelLayout.createSequentialGroup().addContainerGap().addGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tmmUnchangedRB).addComponent(this.tmmRandomRB).addComponent(this.tmFullHMCompatCB)).addGap(17, 17, 17).addGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tmForceGoodDamagingSlider, -2, -1, -2).addComponent(this.tmForceGoodDamagingCB).addComponent(this.tmKeepFieldMovesCB).addComponent(this.tmLearningSanityCB)).addContainerGap(52, Short.MAX_VALUE)));
        tmMovesPanelLayout.setVerticalGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmMovesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmmUnchangedRB).addComponent(this.tmLearningSanityCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmmRandomRB).addComponent(this.tmKeepFieldMovesCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(tmMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tmFullHMCompatCB).addComponent(this.tmForceGoodDamagingCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.tmForceGoodDamagingSlider, -2, -1, -2)));
        this.tmHmCompatPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RandomizerGUI.tmHmCompatPanel.border.title")));
        this.tmHmCompatibilityButtonGroup.add(this.thcUnchangedRB);
        this.thcUnchangedRB.setSelected(true);
        this.thcUnchangedRB.setText(bundle.getString("RandomizerGUI.thcUnchangedRB.text"));
        this.thcUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.thcUnchangedRB.toolTipText"));
        this.thcUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.thcUnchangedRBActionPerformed(evt);
            }
        });
        this.tmHmCompatibilityButtonGroup.add(this.thcRandomTypeRB);
        this.thcRandomTypeRB.setText(bundle.getString("RandomizerGUI.thcRandomTypeRB.text"));
        this.thcRandomTypeRB.setToolTipText(bundle.getString("RandomizerGUI.thcRandomTypeRB.toolTipText"));
        this.thcRandomTypeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.thcRandomTypeRBActionPerformed(evt);
            }
        });
        this.tmHmCompatibilityButtonGroup.add(this.thcRandomTotalRB);
        this.thcRandomTotalRB.setText(bundle.getString("RandomizerGUI.thcRandomTotalRB.text"));
        this.thcRandomTotalRB.setToolTipText(bundle.getString("RandomizerGUI.thcRandomTotalRB.toolTipText"));
        this.thcRandomTotalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.thcRandomTotalRBActionPerformed(evt);
            }
        });
        this.tmHmCompatibilityButtonGroup.add(this.thcFullRB);
        this.thcFullRB.setText(bundle.getString("RandomizerGUI.thcFullRB.text"));
        this.thcFullRB.setToolTipText(bundle.getString("RandomizerGUI.thcFullRB.toolTipText"));
        this.thcFullRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.thcFullRBActionPerformed(evt);
            }
        });
        GroupLayout tmHmCompatPanelLayout = new GroupLayout(this.tmHmCompatPanel);
        this.tmHmCompatPanel.setLayout(tmHmCompatPanelLayout);
        tmHmCompatPanelLayout.setHorizontalGroup(tmHmCompatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmHmCompatPanelLayout.createSequentialGroup().addContainerGap().addGroup(tmHmCompatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.thcUnchangedRB).addComponent(this.thcRandomTypeRB).addComponent(this.thcRandomTotalRB).addComponent(this.thcFullRB)).addContainerGap(79, Short.MAX_VALUE)));
        tmHmCompatPanelLayout.setVerticalGroup(tmHmCompatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmHmCompatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.thcUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.thcRandomTypeRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.thcRandomTotalRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.thcFullRB).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout tmhmsPanelLayout = new GroupLayout(this.tmhmsPanel);
        this.tmhmsPanel.setLayout(tmhmsPanelLayout);
        tmhmsPanelLayout.setHorizontalGroup(tmhmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmhmsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tmMovesPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.tmHmCompatPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        tmhmsPanelLayout.setVerticalGroup(tmhmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmhmsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(tmhmsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tmMovesPanel, -1, -1, Short.MAX_VALUE).addComponent(this.tmHmCompatPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.moveTutorsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.moveTutorsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.mtMovesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RandomizerGUI.mtMovesPanel.border.title")));
        this.mtMovesButtonGroup.add(this.mtmUnchangedRB);
        this.mtmUnchangedRB.setSelected(true);
        this.mtmUnchangedRB.setText(bundle.getString("RandomizerGUI.mtmUnchangedRB.text"));
        this.mtmUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.mtmUnchangedRB.toolTipText"));
        this.mtmUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtmUnchangedRBActionPerformed(evt);
            }
        });
        this.mtMovesButtonGroup.add(this.mtmRandomRB);
        this.mtmRandomRB.setText(bundle.getString("RandomizerGUI.mtmRandomRB.text"));
        this.mtmRandomRB.setToolTipText(bundle.getString("RandomizerGUI.mtmRandomRB.toolTipText"));
        this.mtmRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtmRandomRBActionPerformed(evt);
            }
        });
        this.mtLearningSanityCB.setText(bundle.getString("RandomizerGUI.mtLearningSanityCB.text"));
        this.mtLearningSanityCB.setToolTipText(bundle.getString("RandomizerGUI.mtLearningSanityCB.toolTipText"));
        this.mtKeepFieldMovesCB.setText(bundle.getString("RandomizerGUI.mtKeepFieldMovesCB.text"));
        this.mtKeepFieldMovesCB.setToolTipText(bundle.getString("RandomizerGUI.mtKeepFieldMovesCB.toolTipText"));
        this.mtForceGoodDamagingCB.setText(bundle.getString("RandomizerGUI.mtForceGoodDamagingCB.text"));
        this.mtForceGoodDamagingCB.setToolTipText(bundle.getString("RandomizerGUI.mtForceGoodDamagingCB.toolTipText"));
        this.mtForceGoodDamagingCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtForceGoodDamagingCBActionPerformed(evt);
            }
        });
        this.mtForceGoodDamagingSlider.setMajorTickSpacing(20);
        this.mtForceGoodDamagingSlider.setMinorTickSpacing(5);
        this.mtForceGoodDamagingSlider.setPaintLabels(true);
        this.mtForceGoodDamagingSlider.setPaintTicks(true);
        this.mtForceGoodDamagingSlider.setSnapToTicks(true);
        this.mtForceGoodDamagingSlider.setToolTipText(bundle.getString("RandomizerGUI.mtForceGoodDamagingSlider.toolTipText"));
        this.mtForceGoodDamagingSlider.setValue(0);
        GroupLayout mtMovesPanelLayout = new GroupLayout(this.mtMovesPanel);
        this.mtMovesPanel.setLayout(mtMovesPanelLayout);
        mtMovesPanelLayout.setHorizontalGroup(mtMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mtMovesPanelLayout.createSequentialGroup().addContainerGap().addGroup(mtMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mtmUnchangedRB).addComponent(this.mtmRandomRB)).addGap(64, 64, 64).addGroup(mtMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mtForceGoodDamagingSlider, -2, -1, -2).addComponent(this.mtForceGoodDamagingCB).addComponent(this.mtKeepFieldMovesCB).addComponent(this.mtLearningSanityCB)).addContainerGap(52, Short.MAX_VALUE)));
        mtMovesPanelLayout.setVerticalGroup(mtMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mtMovesPanelLayout.createSequentialGroup().addContainerGap().addGroup(mtMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mtmUnchangedRB).addComponent(this.mtLearningSanityCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(mtMovesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mtmRandomRB).addComponent(this.mtKeepFieldMovesCB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mtForceGoodDamagingCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mtForceGoodDamagingSlider, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.mtCompatPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("RandomizerGUI.mtCompatPanel.border.title")));
        this.mtCompatibilityButtonGroup.add(this.mtcUnchangedRB);
        this.mtcUnchangedRB.setSelected(true);
        this.mtcUnchangedRB.setText(bundle.getString("RandomizerGUI.mtcUnchangedRB.text"));
        this.mtcUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.mtcUnchangedRB.toolTipText"));
        this.mtcUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtcUnchangedRBActionPerformed(evt);
            }
        });
        this.mtCompatibilityButtonGroup.add(this.mtcRandomTypeRB);
        this.mtcRandomTypeRB.setText(bundle.getString("RandomizerGUI.mtcRandomTypeRB.text"));
        this.mtcRandomTypeRB.setToolTipText(bundle.getString("RandomizerGUI.mtcRandomTypeRB.toolTipText"));
        this.mtcRandomTypeRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtcRandomTypeRBActionPerformed(evt);
            }
        });
        this.mtCompatibilityButtonGroup.add(this.mtcRandomTotalRB);
        this.mtcRandomTotalRB.setText(bundle.getString("RandomizerGUI.mtcRandomTotalRB.text"));
        this.mtcRandomTotalRB.setToolTipText(bundle.getString("RandomizerGUI.mtcRandomTotalRB.toolTipText"));
        this.mtcRandomTotalRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtcRandomTotalRBActionPerformed(evt);
            }
        });
        this.mtCompatibilityButtonGroup.add(this.mtcFullRB);
        this.mtcFullRB.setText(bundle.getString("RandomizerGUI.mtcFullRB.text"));
        this.mtcFullRB.setToolTipText(bundle.getString("RandomizerGUI.mtcFullRB.toolTipText"));
        this.mtcFullRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.mtcFullRBActionPerformed(evt);
            }
        });
        GroupLayout mtCompatPanelLayout = new GroupLayout(this.mtCompatPanel);
        this.mtCompatPanel.setLayout(mtCompatPanelLayout);
        mtCompatPanelLayout.setHorizontalGroup(mtCompatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mtCompatPanelLayout.createSequentialGroup().addContainerGap().addGroup(mtCompatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mtcUnchangedRB).addComponent(this.mtcRandomTypeRB).addComponent(this.mtcRandomTotalRB).addComponent(this.mtcFullRB)).addContainerGap(79, Short.MAX_VALUE)));
        mtCompatPanelLayout.setVerticalGroup(mtCompatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mtCompatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mtcUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mtcRandomTypeRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mtcRandomTotalRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mtcFullRB).addContainerGap(-1, Short.MAX_VALUE)));
        this.mtNoExistLabel.setText(bundle.getString("RandomizerGUI.mtNoExistLabel.text"));
        GroupLayout moveTutorsPanelLayout = new GroupLayout(this.moveTutorsPanel);
        this.moveTutorsPanel.setLayout(moveTutorsPanelLayout);
        moveTutorsPanelLayout.setHorizontalGroup(moveTutorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moveTutorsPanelLayout.createSequentialGroup().addContainerGap().addGroup(moveTutorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moveTutorsPanelLayout.createSequentialGroup().addComponent(this.mtNoExistLabel).addContainerGap(-1, Short.MAX_VALUE)).addGroup(moveTutorsPanelLayout.createSequentialGroup().addComponent(this.mtMovesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.mtCompatPanel, -2, -1, -2).addGap(27, 27, 27)))));
        moveTutorsPanelLayout.setVerticalGroup(moveTutorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(moveTutorsPanelLayout.createSequentialGroup().addComponent(this.mtNoExistLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(moveTutorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mtCompatPanel, -1, -1, Short.MAX_VALUE).addComponent(this.mtMovesPanel, -1, -1, Short.MAX_VALUE))));
        GroupLayout tmHmTutorPanelLayout = new GroupLayout(this.tmHmTutorPanel);
        this.tmHmTutorPanel.setLayout(tmHmTutorPanelLayout);
        tmHmTutorPanelLayout.setHorizontalGroup(tmHmTutorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tmHmTutorPanelLayout.createSequentialGroup().addContainerGap().addGroup(tmHmTutorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.moveTutorsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.tmhmsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        tmHmTutorPanelLayout.setVerticalGroup(tmHmTutorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, tmHmTutorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.tmhmsPanel, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveTutorsPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.tmHmTutorPanel.TabConstraints.tabTitle"), this.tmHmTutorPanel);
        this.fieldItemsPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.fieldItemsPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.fieldItemsButtonGroup.add(this.fiUnchangedRB);
        this.fiUnchangedRB.setSelected(true);
        this.fiUnchangedRB.setText(bundle.getString("RandomizerGUI.fiUnchangedRB.text"));
        this.fiUnchangedRB.setToolTipText(bundle.getString("RandomizerGUI.fiUnchangedRB.toolTipText"));
        this.fiUnchangedRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.fiUnchangedRBActionPerformed(evt);
            }
        });
        this.fieldItemsButtonGroup.add(this.fiShuffleRB);
        this.fiShuffleRB.setText(bundle.getString("RandomizerGUI.fiShuffleRB.text"));
        this.fiShuffleRB.setToolTipText(bundle.getString("RandomizerGUI.fiShuffleRB.toolTipText"));
        this.fiShuffleRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.fiShuffleRBActionPerformed(evt);
            }
        });
        this.fieldItemsButtonGroup.add(this.fiRandomRB);
        this.fiRandomRB.setText(bundle.getString("RandomizerGUI.fiRandomRB.text"));
        this.fiRandomRB.setToolTipText(bundle.getString("RandomizerGUI.fiRandomRB.toolTipText"));
        this.fiRandomRB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomizerGUI.this.fiRandomRBActionPerformed(evt);
            }
        });
        this.fiBanBadCB.setText(bundle.getString("RandomizerGUI.fiBanBadCB.text"));
        this.fiBanBadCB.setToolTipText(bundle.getString("RandomizerGUI.fiBanBadCB.toolTipText"));
        GroupLayout fieldItemsPanelLayout = new GroupLayout(this.fieldItemsPanel);
        this.fieldItemsPanel.setLayout(fieldItemsPanelLayout);
        fieldItemsPanelLayout.setHorizontalGroup(fieldItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldItemsPanelLayout.createSequentialGroup().addContainerGap().addGroup(fieldItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fiUnchangedRB).addComponent(this.fiShuffleRB).addGroup(fieldItemsPanelLayout.createSequentialGroup().addComponent(this.fiRandomRB).addGap(76, 76, 76).addComponent(this.fiBanBadCB))).addContainerGap(466, Short.MAX_VALUE)));
        fieldItemsPanelLayout.setVerticalGroup(fieldItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldItemsPanelLayout.createSequentialGroup().addComponent(this.fiUnchangedRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fiShuffleRB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(fieldItemsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fiRandomRB).addComponent(this.fiBanBadCB)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout fieldItemsInnerPanelLayout = new GroupLayout(this.fieldItemsInnerPanel);
        this.fieldItemsInnerPanel.setLayout(fieldItemsInnerPanelLayout);
        fieldItemsInnerPanelLayout.setHorizontalGroup(fieldItemsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldItemsInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldItemsPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        fieldItemsInnerPanelLayout.setVerticalGroup(fieldItemsInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fieldItemsInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.fieldItemsPanel, -2, -1, -2).addContainerGap(321, Short.MAX_VALUE)));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.fieldItemsInnerPanel.TabConstraints.tabTitle"), this.fieldItemsInnerPanel);
        this.miscTweaksPanel.setBorder(BorderFactory.createTitledBorder(null, bundle.getString("RandomizerGUI.miscTweaksPanel.border.title"), 0, 0, new Font("Tahoma", 1, 11)));
        this.mtNoneAvailableLabel.setText(bundle.getString("RandomizerGUI.mtNoneAvailableLabel.text"));
        GroupLayout miscTweaksPanelLayout = new GroupLayout(this.miscTweaksPanel);
        this.miscTweaksPanel.setLayout(miscTweaksPanelLayout);
        miscTweaksPanelLayout.setHorizontalGroup(miscTweaksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscTweaksPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mtNoneAvailableLabel).addContainerGap(418, Short.MAX_VALUE)));
        miscTweaksPanelLayout.setVerticalGroup(miscTweaksPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscTweaksPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.mtNoneAvailableLabel).addContainerGap(367, Short.MAX_VALUE)));
        GroupLayout miscTweaksInnerPanelLayout = new GroupLayout(this.miscTweaksInnerPanel);
        this.miscTweaksInnerPanel.setLayout(miscTweaksInnerPanelLayout);
        miscTweaksInnerPanelLayout.setHorizontalGroup(miscTweaksInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscTweaksInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.miscTweaksPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        miscTweaksInnerPanelLayout.setVerticalGroup(miscTweaksInnerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(miscTweaksInnerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.miscTweaksPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.randomizerOptionsPane.addTab(bundle.getString("RandomizerGUI.miscTweaksInnerPanel.TabConstraints.tabTitle"), this.miscTweaksInnerPanel);
        this.versionLabel.setFont(new Font("Tahoma", 1, 11));
        this.versionLabel.setText(bundle.getString("RandomizerGUI.versionLabel.text"));
        this.websiteLinkLabel.setText(bundle.getString("RandomizerGUI.websiteLinkLabel.text"));
        this.websiteLinkLabel.setCursor(new Cursor(12));
        this.websiteLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                RandomizerGUI.this.websiteLinkLabelMouseClicked(evt);
            }
        });
        this.gameMascotLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/dabomstew/pkrandom/gui/emptyIcon.png")));
        this.gameMascotLabel.setText(bundle.getString("RandomizerGUI.gameMascotLabel.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.generalOptionsPanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.loadQSButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveQSButton)).addComponent(this.romInfoPanel, -2, -1, -2)).addGap(28, 28, 28).addComponent(this.gameMascotLabel).addGap(18, 37, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openROMButton, GroupLayout.Alignment.TRAILING, -2, 159, -2).addComponent(this.saveROMButton, GroupLayout.Alignment.TRAILING, -2, 159, -2).addComponent(this.usePresetsButton, GroupLayout.Alignment.TRAILING, -2, 159, -2).addComponent(this.settingsButton, GroupLayout.Alignment.TRAILING, -2, 159, -2))).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.websiteLinkLabel, -2, -1, -2)).addComponent(this.randomizerOptionsPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generalOptionsPanel, -2, -1, -2).addComponent(this.gameMascotLabel).addGroup(layout.createSequentialGroup().addComponent(this.openROMButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.saveROMButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.usePresetsButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.settingsButton)).addGroup(layout.createSequentialGroup().addComponent(this.romInfoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadQSButton).addComponent(this.saveQSButton)))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.versionLabel).addComponent(this.websiteLinkLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.randomizerOptionsPane, -2, 465, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }
}

