/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.gui;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.gui.PresetFileFilter;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class PresetMakeDialog
extends JDialog {
    private static final long serialVersionUID = 7663903108783731673L;
    private long seed;
    private String configString;
    private JLabel canProduceFileLabel;
    private JTextField configStringField;
    private JLabel configStringFieldLabel;
    private JButton doneButton;
    private JLabel gameRandomizedLabel;
    private JFileChooser presetFileChooser;
    private JButton produceFileButton;
    private JTextField randomSeedField;
    private JLabel seedFieldLabel;
    private JLabel settingsToGiveLabel;

    public PresetMakeDialog(Frame parent, long seed, String configString) {
        super(parent, true);
        this.initComponents();
        this.randomSeedField.setText(Long.toString(seed));
        this.configStringField.setText("172" + configString);
        this.seed = seed;
        this.configString = configString;
        this.presetFileChooser.setCurrentDirectory(new File("./"));
        this.randomSeedField.addMouseListener(new SelectTextListener(this.randomSeedField));
        this.configStringField.addMouseListener(new SelectTextListener(this.configStringField));
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.presetFileChooser = new JFileChooser();
        this.gameRandomizedLabel = new JLabel();
        this.settingsToGiveLabel = new JLabel();
        this.seedFieldLabel = new JLabel();
        this.randomSeedField = new JTextField();
        this.configStringFieldLabel = new JLabel();
        this.configStringField = new JTextField();
        this.canProduceFileLabel = new JLabel();
        this.produceFileButton = new JButton();
        this.doneButton = new JButton();
        this.presetFileChooser.setFileFilter(new PresetFileFilter());
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
        this.setTitle(bundle.getString("PresetMakeDialog.title"));
        this.setModal(true);
        this.setResizable(false);
        this.gameRandomizedLabel.setHorizontalAlignment(0);
        this.gameRandomizedLabel.setText(bundle.getString("PresetMakeDialog.gameRandomizedLabel.text"));
        this.settingsToGiveLabel.setHorizontalAlignment(0);
        this.settingsToGiveLabel.setText(bundle.getString("PresetMakeDialog.settingsToGiveLabel.text"));
        this.seedFieldLabel.setText(bundle.getString("PresetMakeDialog.seedFieldLabel.text"));
        this.randomSeedField.setEditable(false);
        this.configStringFieldLabel.setText(bundle.getString("PresetMakeDialog.configStringFieldLabel.text"));
        this.configStringField.setEditable(false);
        this.canProduceFileLabel.setHorizontalAlignment(0);
        this.canProduceFileLabel.setText(bundle.getString("PresetMakeDialog.canProduceFileLabel.text"));
        this.produceFileButton.setText(bundle.getString("PresetMakeDialog.produceFileButton.text"));
        this.produceFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetMakeDialog.this.produceFileButtonActionPerformed(evt);
            }
        });
        this.doneButton.setText(bundle.getString("PresetMakeDialog.doneButton.text"));
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetMakeDialog.this.doneButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gameRandomizedLabel, -1, -1, Short.MAX_VALUE).addComponent(this.settingsToGiveLabel, -1, 599, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.seedFieldLabel).addComponent(this.configStringFieldLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.randomSeedField).addComponent(this.configStringField)).addContainerGap()).addComponent(this.canProduceFileLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(67, 67, 67).addComponent(this.produceFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.doneButton).addGap(66, 66, 66)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.gameRandomizedLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.settingsToGiveLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.seedFieldLabel).addComponent(this.randomSeedField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configStringFieldLabel).addComponent(this.configStringField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.canProduceFileLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.produceFileButton).addComponent(this.doneButton)).addGap(0, 11, Short.MAX_VALUE)));
        this.pack();
    }

    private void produceFileButtonActionPerformed(ActionEvent evt) {
        this.presetFileChooser.setSelectedFile(null);
        int returnVal = this.presetFileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File fh = this.presetFileChooser.getSelectedFile();
            fh = FileFunctions.fixFilename(fh, "rndp");
            try {
                DataOutputStream dos = new DataOutputStream(new FileOutputStream(fh));
                dos.writeByte(-84);
                dos.writeLong(this.seed);
                dos.writeUTF(this.configString);
                byte[] customnames = PresetMakeDialog.readFile(FileFunctions.openConfig("customnames.rncn"));
                dos.write(customnames);
                dos.close();
                JOptionPane.showMessageDialog(this, "Preset file saved to\n" + fh.getAbsolutePath());
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, "Could not save the preset file.");
            }
        }
    }

    protected static byte[] readFile(InputStream is) throws IOException {
        byte[] file = FileFunctions.readFullyIntoBuffer(is, is.available());
        is.close();
        return file;
    }

    private void doneButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    public class SelectTextListener
    implements MouseListener {
        private JTextField fieldFor;

        public SelectTextListener(JTextField fieldFor) {
            this.fieldFor = fieldFor;
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SelectTextListener.this.fieldFor.selectAll();
                }
            });
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

