/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.gui;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.RandomSource;
import com.dabomstew.pkrandom.exceptions.InvalidSupplementFilesException;
import com.dabomstew.pkrandom.gui.OperationDialog;
import com.dabomstew.pkrandom.gui.PresetFileFilter;
import com.dabomstew.pkrandom.gui.ROMFilter;
import com.dabomstew.pkrandom.gui.RandomizerGUI;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PresetLoadDialog
extends JDialog {
    private static final long serialVersionUID = -7898067118947765260L;
    private RandomizerGUI parentGUI;
    private RomHandler currentROM;
    private boolean completed = false;
    private String requiredName = null;
    private volatile boolean changeFieldsWithoutCheck = false;
    private CustomNamesSet customNames;
    ResourceBundle bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
    private JButton acceptButton;
    private JButton cancelButton;
    private JLabel configStringBoxLabel;
    private JTextField configStringField;
    private JLabel orLabel;
    private JButton presetFileButton;
    private JFileChooser presetFileChooser;
    private JTextField presetFileField;
    private JLabel presetFileLabel;
    private JTextField randomSeedField;
    private JLabel romFileBoxLabel;
    private JButton romFileButton;
    private JFileChooser romFileChooser;
    private JTextField romFileField;
    private JLabel romRequiredLabel;
    private JLabel seedBoxLabel;

    public PresetLoadDialog(RandomizerGUI parent) {
        super((Frame)parent, true);
        this.initComponents();
        this.parentGUI = parent;
        this.presetFileChooser.setCurrentDirectory(new File("./"));
        this.romFileChooser.setCurrentDirectory(new File("./"));
        this.initialState();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initialState() {
        this.romFileButton.setEnabled(false);
        this.acceptButton.setEnabled(false);
        this.addChangeListener(this.randomSeedField);
        this.addChangeListener(this.configStringField);
    }

    private void addChangeListener(JTextField field) {
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!PresetLoadDialog.this.changeFieldsWithoutCheck) {
                    PresetLoadDialog.this.checkValues();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!PresetLoadDialog.this.changeFieldsWithoutCheck) {
                    PresetLoadDialog.this.checkValues();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!PresetLoadDialog.this.changeFieldsWithoutCheck) {
                    PresetLoadDialog.this.checkValues();
                }
            }
        });
    }

    protected boolean checkValues() {
        String name;
        try {
            Long.parseLong(this.randomSeedField.getText());
        }
        catch (NumberFormatException ex) {
            this.invalidValues();
            return false;
        }
        String configString = this.configStringField.getText();
        if (configString.length() < 3) {
            this.invalidValues();
            return false;
        }
        try {
            int presetVersionNumber = Integer.parseInt(configString.substring(0, 3));
            if (presetVersionNumber != 172) {
                this.promptForDifferentRandomizerVersion(presetVersionNumber);
                this.safelyClearFields();
                this.invalidValues();
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this.invalidValues();
            return false;
        }
        try {
            name = this.parentGUI.getValidRequiredROMName(configString.substring(3), this.customNames);
        }
        catch (InvalidSupplementFilesException ex) {
            this.safelyClearFields();
            this.invalidValues();
            return false;
        }
        catch (Exception ex) {
            this.invalidValues();
            return false;
        }
        if (name == null) {
            this.invalidValues();
            return false;
        }
        this.requiredName = name;
        this.romRequiredLabel.setText(String.format(this.bundle.getString("PresetLoadDialog.romRequiredLabel.textWithROM"), name));
        this.romFileButton.setEnabled(true);
        if (this.currentROM != null && !this.currentROM.getROMName().equals(name)) {
            this.currentROM = null;
            this.acceptButton.setEnabled(false);
            this.romFileField.setText("");
        }
        return true;
    }

    private void promptForDifferentRandomizerVersion(int presetVN) {
        if (presetVN > 172) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("PresetLoadDialog.newerVersionRequired"));
        } else {
            String versionWanted = "";
            if (presetVN == 100) {
                versionWanted = "1.0.1a";
            } else if (presetVN == 102) {
                versionWanted = "1.0.2a";
            } else if (presetVN == 110) {
                versionWanted = "1.1.0";
            } else if (presetVN == 111) {
                versionWanted = "1.1.1";
            } else if (presetVN == 112) {
                versionWanted = "1.1.2";
            } else if (presetVN == 120) {
                versionWanted = "1.2.0a";
            } else if (presetVN == 150) {
                versionWanted = "1.5.0";
            } else if (presetVN == 160) {
                versionWanted = "1.6.0a";
            } else if (presetVN == 161) {
                versionWanted = "1.6.1";
            } else if (presetVN == 162) {
                versionWanted = "1.6.2";
            } else if (presetVN == 163) {
                versionWanted = "1.6.3b";
            } else if (presetVN == 170) {
                versionWanted = "1.7.0b";
            } else if (presetVN == 171) {
                versionWanted = "1.7.1";
            }
            JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("PresetLoadDialog.olderVersionRequired"), versionWanted));
        }
    }

    private void safelyClearFields() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PresetLoadDialog.this.changeFieldsWithoutCheck = true;
                PresetLoadDialog.this.configStringField.setText("");
                PresetLoadDialog.this.randomSeedField.setText("");
                PresetLoadDialog.this.changeFieldsWithoutCheck = false;
            }
        });
    }

    private void invalidValues() {
        this.currentROM = null;
        this.romFileField.setText("");
        this.romRequiredLabel.setText(this.bundle.getString("PresetLoadDialog.romRequiredLabel.text"));
        this.romFileButton.setEnabled(false);
        this.acceptButton.setEnabled(false);
        this.requiredName = null;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public RomHandler getROM() {
        return this.currentROM;
    }

    public long getSeed() {
        return Long.parseLong(this.randomSeedField.getText());
    }

    public String getConfigString() {
        return this.configStringField.getText().substring(3);
    }

    public CustomNamesSet getCustomNames() {
        return this.customNames;
    }

    private void presetFileButtonActionPerformed(ActionEvent evt) {
        this.presetFileChooser.setSelectedFile(null);
        int returnVal = this.presetFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File fh = this.presetFileChooser.getSelectedFile();
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(fh));
                int checkByte = dis.readByte() & 0xFF;
                if (checkByte != 172) {
                    dis.close();
                    this.promptForDifferentRandomizerVersion(checkByte);
                    return;
                }
                long seed = dis.readLong();
                String preset = dis.readUTF();
                this.customNames = new CustomNamesSet(dis);
                this.changeFieldsWithoutCheck = true;
                this.randomSeedField.setText(Long.toString(seed));
                this.configStringField.setText(checkByte + "" + preset);
                this.changeFieldsWithoutCheck = false;
                if (this.checkValues()) {
                    this.randomSeedField.setEnabled(false);
                    this.configStringField.setEnabled(false);
                    this.presetFileField.setText(fh.getAbsolutePath());
                } else {
                    this.randomSeedField.setText("");
                    this.configStringField.setText("");
                    this.randomSeedField.setEnabled(true);
                    this.configStringField.setEnabled(true);
                    this.presetFileField.setText("");
                    this.customNames = null;
                    JOptionPane.showMessageDialog(this, this.bundle.getString("PresetLoadDialog.invalidSeedFile"));
                }
                dis.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, this.bundle.getString("PresetLoadDialog.loadingSeedFileFailed"));
            }
        }
    }

    private void romFileButtonActionPerformed(ActionEvent evt) {
        this.romFileChooser.setSelectedFile(null);
        int returnVal = this.romFileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            final File fh = this.romFileChooser.getSelectedFile();
            for (RomHandler.Factory rhf : this.parentGUI.checkHandlers) {
                if (!rhf.isLoadable(fh.getAbsolutePath())) continue;
                final RomHandler checkHandler = rhf.create(RandomSource.instance());
                final OperationDialog opDialog = new OperationDialog(this.bundle.getString("RandomizerGUI.loadingText"), this, true);
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                opDialog.setVisible(true);
                            }
                        });
                        try {
                            checkHandler.loadRom(fh.getAbsolutePath());
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(PresetLoadDialog.this, PresetLoadDialog.this.bundle.getString("RandomizerGUI.loadFailedNoLog"));
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                opDialog.setVisible(false);
                                if (checkHandler.getROMName().equals(PresetLoadDialog.this.requiredName)) {
                                    PresetLoadDialog.this.romFileField.setText(fh.getAbsolutePath());
                                    PresetLoadDialog.this.currentROM = checkHandler;
                                    PresetLoadDialog.this.acceptButton.setEnabled(true);
                                    return;
                                }
                                JOptionPane.showMessageDialog(PresetLoadDialog.this, String.format(PresetLoadDialog.this.bundle.getString("PresetLoadDialog.notRequiredROM"), PresetLoadDialog.this.requiredName, checkHandler.getROMName()));
                            }
                        });
                    }
                };
                t.start();
                return;
            }
            JOptionPane.showMessageDialog(this, String.format(this.bundle.getString("RandomizerGUI.unsupportedRom"), fh.getName()));
        }
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        this.completed = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.completed = false;
        this.setVisible(false);
    }

    private void initComponents() {
        this.presetFileChooser = new JFileChooser();
        this.romFileChooser = new JFileChooser();
        this.presetFileLabel = new JLabel();
        this.presetFileField = new JTextField();
        this.presetFileButton = new JButton();
        this.orLabel = new JLabel();
        this.seedBoxLabel = new JLabel();
        this.randomSeedField = new JTextField();
        this.configStringBoxLabel = new JLabel();
        this.configStringField = new JTextField();
        this.romRequiredLabel = new JLabel();
        this.romFileBoxLabel = new JLabel();
        this.romFileField = new JTextField();
        this.romFileButton = new JButton();
        this.acceptButton = new JButton();
        this.cancelButton = new JButton();
        this.presetFileChooser.setFileFilter(new PresetFileFilter());
        this.romFileChooser.setFileFilter(new ROMFilter());
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
        this.setTitle(bundle.getString("PresetLoadDialog.title"));
        this.setModal(true);
        this.setResizable(false);
        this.presetFileLabel.setText(bundle.getString("PresetLoadDialog.presetFileLabel.text"));
        this.presetFileField.setEditable(false);
        this.presetFileButton.setText(bundle.getString("PresetLoadDialog.presetFileButton.text"));
        this.presetFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetLoadDialog.this.presetFileButtonActionPerformed(evt);
            }
        });
        this.orLabel.setFont(new Font("Tahoma", 1, 11));
        this.orLabel.setHorizontalAlignment(0);
        this.orLabel.setText(bundle.getString("PresetLoadDialog.orLabel.text"));
        this.seedBoxLabel.setText(bundle.getString("PresetLoadDialog.seedBoxLabel.text"));
        this.configStringBoxLabel.setText(bundle.getString("PresetLoadDialog.configStringBoxLabel.text"));
        this.romRequiredLabel.setHorizontalAlignment(0);
        this.romRequiredLabel.setText(bundle.getString("PresetLoadDialog.romRequiredLabel.text"));
        this.romFileBoxLabel.setText(bundle.getString("PresetLoadDialog.romFileBoxLabel.text"));
        this.romFileField.setEditable(false);
        this.romFileButton.setText(bundle.getString("PresetLoadDialog.romFileButton.text"));
        this.romFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetLoadDialog.this.romFileButtonActionPerformed(evt);
            }
        });
        this.acceptButton.setText(bundle.getString("PresetLoadDialog.acceptButton.text"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetLoadDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("PresetLoadDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PresetLoadDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.romFileBoxLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.presetFileLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.seedBoxLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.configStringBoxLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.acceptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 169, Short.MAX_VALUE).addComponent(this.cancelButton)).addComponent(this.randomSeedField).addComponent(this.configStringField).addComponent(this.presetFileField).addComponent(this.romFileField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.presetFileButton, -2, 26, -2).addComponent(this.romFileButton, -2, 1, Short.MAX_VALUE)).addGap(12, 12, 12)).addComponent(this.orLabel, -1, -1, Short.MAX_VALUE).addComponent(this.romRequiredLabel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.presetFileLabel).addComponent(this.presetFileField, -2, -1, -2).addComponent(this.presetFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.seedBoxLabel).addComponent(this.randomSeedField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.configStringBoxLabel).addComponent(this.configStringField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.romRequiredLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.romFileBoxLabel).addComponent(this.romFileField, -2, -1, -2).addComponent(this.romFileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.acceptButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }
}

