/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.gui;

import com.dabomstew.pkrandom.gui.RandomizerGUI;
import com.dabomstew.pkrandom.pokemon.GenRestrictions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;

public class GenerationLimitDialog
extends JDialog {
    private static final long serialVersionUID = 106783506965080925L;
    private boolean pressedOk;
    private JButton cancelButton;
    private JCheckBox g1Rg2CB;
    private JCheckBox g1Rg4CB;
    private JCheckBox g2Rg1CB;
    private JCheckBox g2Rg3CB;
    private JCheckBox g2Rg4CB;
    private JCheckBox g3Rg2CB;
    private JCheckBox g3Rg4CB;
    private JCheckBox g4Rg1CB;
    private JCheckBox g4Rg2CB;
    private JCheckBox g4Rg3CB;
    private JCheckBox gen1CB;
    private JCheckBox gen2CB;
    private JCheckBox gen3CB;
    private JCheckBox gen4CB;
    private JCheckBox gen5CB;
    private JLabel includePokemonHeader;
    private JButton okButton;
    private JLabel relatedPokemonHeader;
    private JLabel warningRomHackLabel;

    public GenerationLimitDialog(RandomizerGUI parent, GenRestrictions current, int generation) {
        super((Frame)parent, true);
        this.initComponents();
        this.initialState(generation);
        if (current != null) {
            current.limitToGen(generation);
            this.restoreFrom(current);
        }
        this.enableAndDisableBoxes();
        this.pressedOk = false;
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public boolean pressedOK() {
        return this.pressedOk;
    }

    public GenRestrictions getChoice() {
        GenRestrictions gr = new GenRestrictions();
        gr.allow_gen1 = this.gen1CB.isSelected();
        gr.allow_gen2 = this.gen2CB.isSelected();
        gr.allow_gen3 = this.gen3CB.isSelected();
        gr.allow_gen4 = this.gen4CB.isSelected();
        gr.allow_gen5 = this.gen5CB.isSelected();
        gr.assoc_g1_g2 = this.g1Rg2CB.isSelected();
        gr.assoc_g1_g4 = this.g1Rg4CB.isSelected();
        gr.assoc_g2_g1 = this.g2Rg1CB.isSelected();
        gr.assoc_g2_g3 = this.g2Rg3CB.isSelected();
        gr.assoc_g2_g4 = this.g2Rg4CB.isSelected();
        gr.assoc_g3_g2 = this.g3Rg2CB.isSelected();
        gr.assoc_g3_g4 = this.g3Rg4CB.isSelected();
        gr.assoc_g4_g1 = this.g4Rg1CB.isSelected();
        gr.assoc_g4_g2 = this.g4Rg2CB.isSelected();
        gr.assoc_g4_g3 = this.g4Rg3CB.isSelected();
        return gr;
    }

    private void initialState(int generation) {
        if (generation < 2) {
            this.gen2CB.setVisible(false);
            this.g1Rg2CB.setVisible(false);
            this.g2Rg1CB.setVisible(false);
            this.g2Rg3CB.setVisible(false);
            this.g2Rg4CB.setVisible(false);
        }
        if (generation < 3) {
            this.gen3CB.setVisible(false);
            this.g2Rg3CB.setVisible(false);
            this.g3Rg2CB.setVisible(false);
            this.g3Rg4CB.setVisible(false);
        }
        if (generation < 4) {
            this.gen4CB.setVisible(false);
            this.g1Rg4CB.setVisible(false);
            this.g2Rg4CB.setVisible(false);
            this.g3Rg4CB.setVisible(false);
            this.g4Rg1CB.setVisible(false);
            this.g4Rg2CB.setVisible(false);
            this.g4Rg3CB.setVisible(false);
        }
        if (generation < 5) {
            this.gen5CB.setVisible(false);
        }
    }

    private void restoreFrom(GenRestrictions restrict) {
        this.gen1CB.setSelected(restrict.allow_gen1);
        this.gen2CB.setSelected(restrict.allow_gen2);
        this.gen3CB.setSelected(restrict.allow_gen3);
        this.gen4CB.setSelected(restrict.allow_gen4);
        this.gen5CB.setSelected(restrict.allow_gen5);
        this.g1Rg2CB.setSelected(restrict.assoc_g1_g2);
        this.g1Rg4CB.setSelected(restrict.assoc_g1_g4);
        this.g2Rg1CB.setSelected(restrict.assoc_g2_g1);
        this.g2Rg3CB.setSelected(restrict.assoc_g2_g3);
        this.g2Rg4CB.setSelected(restrict.assoc_g2_g4);
        this.g3Rg2CB.setSelected(restrict.assoc_g3_g2);
        this.g3Rg4CB.setSelected(restrict.assoc_g3_g4);
        this.g4Rg1CB.setSelected(restrict.assoc_g4_g1);
        this.g4Rg2CB.setSelected(restrict.assoc_g4_g2);
        this.g4Rg3CB.setSelected(restrict.assoc_g4_g3);
    }

    private void initComponents() {
        this.includePokemonHeader = new JLabel();
        this.gen1CB = new JCheckBox();
        this.gen2CB = new JCheckBox();
        this.gen3CB = new JCheckBox();
        this.gen4CB = new JCheckBox();
        this.gen5CB = new JCheckBox();
        this.relatedPokemonHeader = new JLabel();
        this.g1Rg2CB = new JCheckBox();
        this.g1Rg4CB = new JCheckBox();
        this.g2Rg1CB = new JCheckBox();
        this.g2Rg3CB = new JCheckBox();
        this.g2Rg4CB = new JCheckBox();
        this.g3Rg2CB = new JCheckBox();
        this.g3Rg4CB = new JCheckBox();
        this.g4Rg1CB = new JCheckBox();
        this.g4Rg2CB = new JCheckBox();
        this.g4Rg3CB = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.warningRomHackLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
        this.setTitle(bundle.getString("GenerationLimitDialog.title"));
        this.includePokemonHeader.setFont(new Font("Tahoma", 1, 11));
        this.includePokemonHeader.setText(bundle.getString("GenerationLimitDialog.includePokemonHeader.text"));
        this.gen1CB.setText(bundle.getString("GenerationLimitDialog.gen1CB.text"));
        this.gen1CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.gen1CBActionPerformed(evt);
            }
        });
        this.gen2CB.setText(bundle.getString("GenerationLimitDialog.gen2CB.text"));
        this.gen2CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.gen2CBActionPerformed(evt);
            }
        });
        this.gen3CB.setText(bundle.getString("GenerationLimitDialog.gen3CB.text"));
        this.gen3CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.gen3CBActionPerformed(evt);
            }
        });
        this.gen4CB.setText(bundle.getString("GenerationLimitDialog.gen4CB.text"));
        this.gen4CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.gen4CBActionPerformed(evt);
            }
        });
        this.gen5CB.setText(bundle.getString("GenerationLimitDialog.gen5CB.text"));
        this.gen5CB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.gen5CBActionPerformed(evt);
            }
        });
        this.relatedPokemonHeader.setFont(new Font("Tahoma", 1, 11));
        this.relatedPokemonHeader.setText(bundle.getString("GenerationLimitDialog.relatedPokemonHeader.text"));
        this.g1Rg2CB.setText(bundle.getString("GenerationLimitDialog.gen2Short"));
        this.g1Rg4CB.setText(bundle.getString("GenerationLimitDialog.gen4Short"));
        this.g2Rg1CB.setText(bundle.getString("GenerationLimitDialog.gen1Short"));
        this.g2Rg3CB.setText(bundle.getString("GenerationLimitDialog.gen3Short"));
        this.g2Rg4CB.setText(bundle.getString("GenerationLimitDialog.gen4Short"));
        this.g3Rg2CB.setText(bundle.getString("GenerationLimitDialog.gen2Short"));
        this.g3Rg4CB.setText(bundle.getString("GenerationLimitDialog.gen4Short"));
        this.g4Rg1CB.setText(bundle.getString("GenerationLimitDialog.gen1Short"));
        this.g4Rg2CB.setText(bundle.getString("GenerationLimitDialog.gen2Short"));
        this.g4Rg3CB.setText(bundle.getString("GenerationLimitDialog.gen3Short"));
        this.okButton.setText(bundle.getString("GenerationLimitDialog.okButton.text"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("GenerationLimitDialog.cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GenerationLimitDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.warningRomHackLabel.setFont(new Font("Tahoma", 1, 11));
        this.warningRomHackLabel.setForeground(new Color(255, 0, 0));
        this.warningRomHackLabel.setHorizontalAlignment(0);
        this.warningRomHackLabel.setText(bundle.getString("GenerationLimitDialog.warningRomHackLabel.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gen5CB).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includePokemonHeader).addComponent(this.gen1CB).addComponent(this.gen2CB).addComponent(this.gen3CB).addComponent(this.gen4CB)).addGap(106, 106, 106).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.g4Rg1CB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.g4Rg2CB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.g4Rg3CB)).addGroup(layout.createSequentialGroup().addComponent(this.g3Rg2CB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.g3Rg4CB)).addGroup(layout.createSequentialGroup().addComponent(this.g2Rg1CB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.g2Rg3CB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.g2Rg4CB)).addGroup(layout.createSequentialGroup().addComponent(this.g1Rg2CB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.g1Rg4CB)).addComponent(this.relatedPokemonHeader)))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addGap(32, 32, 32).addComponent(this.cancelButton).addGap(134, 134, 134)))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.warningRomHackLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.includePokemonHeader).addComponent(this.relatedPokemonHeader)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gen1CB).addComponent(this.g1Rg2CB).addComponent(this.g1Rg4CB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gen2CB).addComponent(this.g2Rg1CB).addComponent(this.g2Rg3CB).addComponent(this.g2Rg4CB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gen3CB).addComponent(this.g3Rg2CB).addComponent(this.g3Rg4CB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gen4CB).addComponent(this.g4Rg1CB).addComponent(this.g4Rg2CB).addComponent(this.g4Rg3CB)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.gen5CB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.warningRomHackLabel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void enableAndDisableBoxes() {
        this.g1Rg2CB.setEnabled(this.gen1CB.isSelected());
        this.g1Rg4CB.setEnabled(this.gen1CB.isSelected());
        this.g2Rg1CB.setEnabled(this.gen2CB.isSelected());
        this.g2Rg3CB.setEnabled(this.gen2CB.isSelected());
        this.g2Rg4CB.setEnabled(this.gen2CB.isSelected());
        this.g3Rg2CB.setEnabled(this.gen3CB.isSelected());
        this.g3Rg4CB.setEnabled(this.gen3CB.isSelected());
        this.g4Rg1CB.setEnabled(this.gen4CB.isSelected());
        this.g4Rg2CB.setEnabled(this.gen4CB.isSelected());
        this.g4Rg3CB.setEnabled(this.gen4CB.isSelected());
        if (!this.gen1CB.isSelected()) {
            this.g1Rg2CB.setSelected(false);
            this.g1Rg4CB.setSelected(false);
        }
        if (!this.gen2CB.isSelected()) {
            this.g2Rg1CB.setSelected(false);
            this.g2Rg3CB.setSelected(false);
            this.g2Rg4CB.setSelected(false);
        }
        if (!this.gen3CB.isSelected()) {
            this.g3Rg2CB.setSelected(false);
            this.g3Rg4CB.setSelected(false);
        }
        if (!this.gen4CB.isSelected()) {
            this.g4Rg1CB.setSelected(false);
            this.g4Rg2CB.setSelected(false);
            this.g4Rg3CB.setSelected(false);
        }
        if (this.gen1CB.isSelected()) {
            this.g2Rg1CB.setEnabled(false);
            this.g2Rg1CB.setSelected(true);
            this.g4Rg1CB.setEnabled(false);
            this.g4Rg1CB.setSelected(true);
        }
        if (this.gen2CB.isSelected()) {
            this.g1Rg2CB.setEnabled(false);
            this.g1Rg2CB.setSelected(true);
            this.g3Rg2CB.setEnabled(false);
            this.g3Rg2CB.setSelected(true);
            this.g4Rg2CB.setEnabled(false);
            this.g4Rg2CB.setSelected(true);
        }
        if (this.gen3CB.isSelected()) {
            this.g2Rg3CB.setEnabled(false);
            this.g2Rg3CB.setSelected(true);
            this.g4Rg3CB.setEnabled(false);
            this.g4Rg3CB.setSelected(true);
        }
        if (this.gen4CB.isSelected()) {
            this.g1Rg4CB.setEnabled(false);
            this.g1Rg4CB.setSelected(true);
            this.g2Rg4CB.setEnabled(false);
            this.g2Rg4CB.setSelected(true);
            this.g3Rg4CB.setEnabled(false);
            this.g3Rg4CB.setSelected(true);
        }
    }

    private void gen1CBActionPerformed(ActionEvent evt) {
        this.enableAndDisableBoxes();
    }

    private void gen2CBActionPerformed(ActionEvent evt) {
        this.enableAndDisableBoxes();
    }

    private void gen3CBActionPerformed(ActionEvent evt) {
        this.enableAndDisableBoxes();
    }

    private void gen4CBActionPerformed(ActionEvent evt) {
        this.enableAndDisableBoxes();
    }

    private void gen5CBActionPerformed(ActionEvent evt) {
        this.enableAndDisableBoxes();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.pressedOk = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.pressedOk = false;
        this.setVisible(false);
    }
}

