/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.gui;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.SysConstants;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CustomNamesEditorDialog
extends JDialog {
    private static final long serialVersionUID = -1421503126547242929L;
    private boolean pendingChanges;
    private JButton closeBtn;
    private JScrollPane doublesTrainerClassesSP;
    private JTextArea doublesTrainerClassesText;
    private JScrollPane doublesTrainerNamesSP;
    private JTextArea doublesTrainerNamesText;
    private JTabbedPane editorTabsPane;
    private JScrollPane nicknamesSP;
    private JTextArea nicknamesText;
    private JButton saveBtn;
    private JScrollPane trainerClassesSP;
    private JTextArea trainerClassesText;
    private JScrollPane trainerNamesSP;
    private JTextArea trainerNamesText;

    public CustomNamesEditorDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CustomNamesEditorDialog.this.setVisible(true);
            }
        });
        try {
            CustomNamesSet cns = FileFunctions.getCustomNames();
            this.populateNames(this.trainerNamesText, cns.getTrainerNames());
            this.populateNames(this.trainerClassesText, cns.getTrainerClasses());
            this.populateNames(this.doublesTrainerNamesText, cns.getDoublesTrainerNames());
            this.populateNames(this.doublesTrainerClassesText, cns.getDoublesTrainerClasses());
            this.populateNames(this.nicknamesText, cns.getPokemonNicknames());
        }
        catch (IOException ex) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(CustomNamesEditorDialog.this, "Your custom names file is for a different randomizer version or otherwise corrupt.");
                }
            });
        }
        if (!new File(SysConstants.ROOT_PATH + "customnames.rncn").exists()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(CustomNamesEditorDialog.this, String.format("Welcome to the custom names editor!\nThis is where you can edit the names used for options like \"Randomize Trainer Names\".\nThe names are initially populated with a few default names included with the randomizer.\nYou can share your customized name sets with others, too!\nJust send them the %s file created in the randomizer directory.", "customnames.rncn"));
                }
            });
        }
        this.pendingChanges = false;
        this.addDocListener(this.trainerNamesText);
        this.addDocListener(this.trainerClassesText);
        this.addDocListener(this.doublesTrainerNamesText);
        this.addDocListener(this.doublesTrainerClassesText);
        this.addDocListener(this.nicknamesText);
    }

    private void addDocListener(JTextArea textArea) {
        textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CustomNamesEditorDialog.this.pendingChanges = true;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CustomNamesEditorDialog.this.pendingChanges = true;
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CustomNamesEditorDialog.this.pendingChanges = true;
            }
        });
    }

    private void formWindowClosing(WindowEvent evt) {
        this.attemptClose();
    }

    private void saveBtnActionPerformed(ActionEvent evt) {
        this.save();
    }

    private void closeBtnActionPerformed(ActionEvent evt) {
        this.attemptClose();
    }

    private boolean save() {
        CustomNamesSet cns = new CustomNamesSet();
        cns.setTrainerNames(this.getNameList(this.trainerNamesText));
        cns.setTrainerClasses(this.getNameList(this.trainerClassesText));
        cns.setDoublesTrainerNames(this.getNameList(this.doublesTrainerNamesText));
        cns.setDoublesTrainerClasses(this.getNameList(this.doublesTrainerClassesText));
        cns.setPokemonNicknames(this.getNameList(this.nicknamesText));
        try {
            byte[] data = cns.getBytes();
            FileFunctions.writeBytesToFile("customnames.rncn", data);
            this.pendingChanges = false;
            JOptionPane.showMessageDialog(this, "Custom names saved.");
            return true;
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Could not save changes.");
            return false;
        }
    }

    private void attemptClose() {
        if (this.pendingChanges) {
            int result = JOptionPane.showConfirmDialog(this, "You've made some unsaved changes to your custom names.\nDo you want to save them before closing the editor?");
            if (result == 0) {
                if (this.save()) {
                    this.dispose();
                }
            } else if (result == 1) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private List<String> getNameList(JTextArea textArea) {
        String contents = textArea.getText();
        contents = contents.replace("\r\n", "\n");
        contents = contents.replace("\r", "\n");
        String[] names = contents.split("\n");
        ArrayList<String> results = new ArrayList<String>();
        for (String name : names) {
            String ln = name.trim();
            if (ln.isEmpty()) continue;
            results.add(ln);
        }
        return results;
    }

    private void populateNames(JTextArea textArea, List<String> names) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                sb.append(SysConstants.LINE_SEP);
            }
            first = false;
            sb.append(name);
        }
        textArea.setText(sb.toString());
    }

    private void initComponents() {
        this.editorTabsPane = new JTabbedPane();
        this.trainerNamesSP = new JScrollPane();
        this.trainerNamesText = new JTextArea();
        this.trainerClassesSP = new JScrollPane();
        this.trainerClassesText = new JTextArea();
        this.doublesTrainerNamesSP = new JScrollPane();
        this.doublesTrainerNamesText = new JTextArea();
        this.doublesTrainerClassesSP = new JScrollPane();
        this.doublesTrainerClassesText = new JTextArea();
        this.nicknamesSP = new JScrollPane();
        this.nicknamesText = new JTextArea();
        this.saveBtn = new JButton();
        this.closeBtn = new JButton();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("com/dabomstew/pkrandom/gui/Bundle");
        this.setTitle(bundle.getString("CustomNamesEditorDialog.title"));
        this.setCursor(new Cursor(0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CustomNamesEditorDialog.this.formWindowClosing(evt);
            }
        });
        this.trainerNamesSP.setHorizontalScrollBar(null);
        this.trainerNamesText.setColumns(20);
        this.trainerNamesText.setRows(5);
        this.trainerNamesSP.setViewportView(this.trainerNamesText);
        this.editorTabsPane.addTab(bundle.getString("CustomNamesEditorDialog.trainerNamesSP.TabConstraints.tabTitle"), this.trainerNamesSP);
        this.trainerClassesSP.setHorizontalScrollBar(null);
        this.trainerClassesText.setColumns(20);
        this.trainerClassesText.setRows(5);
        this.trainerClassesSP.setViewportView(this.trainerClassesText);
        this.editorTabsPane.addTab(bundle.getString("CustomNamesEditorDialog.trainerClassesSP.TabConstraints.tabTitle"), this.trainerClassesSP);
        this.doublesTrainerNamesSP.setHorizontalScrollBar(null);
        this.doublesTrainerNamesText.setColumns(20);
        this.doublesTrainerNamesText.setRows(5);
        this.doublesTrainerNamesSP.setViewportView(this.doublesTrainerNamesText);
        this.editorTabsPane.addTab(bundle.getString("CustomNamesEditorDialog.doublesTrainerNamesSP.TabConstraints.tabTitle"), this.doublesTrainerNamesSP);
        this.doublesTrainerClassesSP.setHorizontalScrollBar(null);
        this.doublesTrainerClassesText.setColumns(20);
        this.doublesTrainerClassesText.setRows(5);
        this.doublesTrainerClassesSP.setViewportView(this.doublesTrainerClassesText);
        this.editorTabsPane.addTab(bundle.getString("CustomNamesEditorDialog.doublesTrainerClassesSP.TabConstraints.tabTitle"), this.doublesTrainerClassesSP);
        this.nicknamesSP.setHorizontalScrollBar(null);
        this.nicknamesText.setColumns(20);
        this.nicknamesText.setRows(5);
        this.nicknamesSP.setViewportView(this.nicknamesText);
        this.editorTabsPane.addTab(bundle.getString("CustomNamesEditorDialog.nicknamesSP.TabConstraints.tabTitle"), this.nicknamesSP);
        this.saveBtn.setText(bundle.getString("CustomNamesEditorDialog.saveBtn.text"));
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomNamesEditorDialog.this.saveBtnActionPerformed(evt);
            }
        });
        this.closeBtn.setText(bundle.getString("CustomNamesEditorDialog.closeBtn.text"));
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomNamesEditorDialog.this.closeBtnActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.editorTabsPane, -1, 616, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.saveBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.closeBtn))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.editorTabsPane, -1, 357, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.saveBtn).addComponent(this.closeBtn)).addContainerGap()));
        this.pack();
    }
}

