/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.constants;

import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.MoveCategory;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Gen5Constants {
    public static final int Type_BW = 0;
    public static final int Type_BW2 = 1;
    public static final int pokemonCount = 649;
    public static final int moveCount = 559;
    public static final int nonUnovaPokemonCount = 493;
    public static final int bsHPOffset = 0;
    public static final int bsAttackOffset = 1;
    public static final int bsDefenseOffset = 2;
    public static final int bsSpeedOffset = 3;
    public static final int bsSpAtkOffset = 4;
    public static final int bsSpDefOffset = 5;
    public static final int bsPrimaryTypeOffset = 6;
    public static final int bsSecondaryTypeOffset = 7;
    public static final int bsCatchRateOffset = 8;
    public static final int bsCommonHeldItemOffset = 12;
    public static final int bsRareHeldItemOffset = 14;
    public static final int bsDarkGrassHeldItemOffset = 16;
    public static final int bsGrowthCurveOffset = 21;
    public static final int bsAbility1Offset = 24;
    public static final int bsAbility2Offset = 25;
    public static final int bsAbility3Offset = 26;
    public static final int bsTMHMCompatOffset = 40;
    public static final int bsMTCompatOffset = 60;
    public static final byte[] bw1NewStarterScript = new byte[]{36, 0, -89, 2, -25, 0, 0, 0, -34, 0, 0, 0, -8, 1, 5, 0};
    public static final String bw1StarterScriptMagic = "2400A702";
    public static final int bw1StarterTextOffset = 18;
    public static final int bw1CherenText1Offset = 26;
    public static final int bw1CherenText2Offset = 53;
    public static final byte[] bw2NewStarterScript = new byte[]{40, 0, -95, 64, 4, 0, -34, 0, 0, 0, -3, 1, 5, 0};
    public static final String bw2StarterScriptMagic = "2800A1400400";
    public static final int bw2StarterTextOffset = 37;
    public static final int bw2RivalTextOffset = 60;
    public static final int perSeasonEncounterDataLength = 232;
    public static final int bw2AreaDataEntryLength = 345;
    public static final int bw2EncounterAreaCount = 85;
    public static final int[] encountersOfEachType = new int[]{12, 12, 12, 5, 5, 5, 5};
    public static final String[] encounterTypeNames = new String[]{"Grass/Cave", "Doubles Grass", "Shaking Spots", "Surfing", "Surfing Spots", "Fishing", "Fishing Spots"};
    public static final int[] habitatClassificationOfEachType = new int[]{0, 0, 0, 1, 1, 2, 2};
    public static final int bw2Route4AreaIndex = 40;
    public static final int bw2VictoryRoadAreaIndex = 76;
    public static final int bw2ReversalMountainAreaIndex = 73;
    public static final int b2Route4EncounterFile = 104;
    public static final int b2VRExclusiveRoom1 = 71;
    public static final int b2VRExclusiveRoom2 = 73;
    public static final int b2ReversalMountainStart = 49;
    public static final int b2ReversalMountainEnd = 54;
    public static final int w2Route4EncounterFile = 105;
    public static final int w2VRExclusiveRoom1 = 78;
    public static final int w2VRExclusiveRoom2 = 79;
    public static final int w2ReversalMountainStart = 55;
    public static final int w2ReversalMountainEnd = 60;
    public static final int[] bw2HiddenHollowUnovaPokemon = new int[]{505, 507, 510, 511, 513, 515, 519, 523, 525, 527, 529, 531, 533, 535, 538, 539, 542, 545, 546, 548, 550, 553, 556, 558, 559, 561, 564, 569, 572, 575, 578, 580, 583, 587, 588, 594, 596, 601, 605, 607, 610, 613, 616, 618, 619, 621, 622, 624, 626, 628, 630, 631, 632};
    public static final String tmDataPrefix = "87038803";
    public static final int tmCount = 95;
    public static final int hmCount = 6;
    public static final int tmBlockOneCount = 92;
    public static final int tmBlockOneOffset = 328;
    public static final int tmBlockTwoOffset = 618;
    public static final String bw1ItemPalettesPrefix = "E903EA03020003000400050006000700";
    public static final String bw2ItemPalettesPrefix = "FD03FE03020003000400050006000700";
    public static final int bw2MoveTutorCount = 60;
    public static final int bw2MoveTutorBytesPerEntry = 12;
    public static final int evolutionMethodCount = 27;
    public static final int slowpokeIndex = 79;
    public static final int karrablastIndex = 588;
    public static final int shelmetIndex = 616;
    public static final int waterStoneIndex = 84;
    public static final int highestAbilityIndex = 123;
    public static final int normalItemSetVarCommand = 40;
    public static final int hiddenItemSetVarCommand = 42;
    public static final int normalItemVarSet = 32780;
    public static final int hiddenItemVarSet = 32768;
    public static final int scriptListTerminator = 64787;
    public static final int luckyEggIndex = 231;
    public static final MoveCategory[] moveCategoryIndices = new MoveCategory[]{MoveCategory.STATUS, MoveCategory.PHYSICAL, MoveCategory.SPECIAL};
    public static final Type[] typeTable = Gen5Constants.constructTypeTable();
    public static final List<Integer> bw1RequiredFieldTMs = Arrays.asList(2, 3, 5, 6, 9, 12, 13, 19, 22, 24, 26, 29, 30, 35, 36, 39, 41, 46, 47, 50, 52, 53, 55, 58, 61, 63, 65, 66, 71, 80, 81, 84, 85, 86, 90, 91, 92, 93);
    public static final List<Integer> bw2RequiredFieldTMs = Arrays.asList(1, 2, 3, 5, 6, 12, 13, 19, 22, 26, 28, 29, 30, 36, 39, 41, 46, 47, 50, 52, 53, 56, 58, 61, 63, 65, 66, 67, 69, 71, 80, 81, 84, 85, 86, 90, 91, 92, 93);
    public static final List<Integer> bw1EarlyRequiredHMMoves = Arrays.asList(15);
    public static final List<Integer> bw2EarlyRequiredHMMoves = Collections.EMPTY_LIST;
    public static final List<Integer> fieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100, 127, 230, 291);
    public static ItemList allowedItems;
    public static ItemList nonBadItems;
    private static final int[][] habitatListEntries;
    public static final int[] wildFileToAreaMap;

    public static byte moveCategoryToByte(MoveCategory cat) {
        switch (cat) {
            case PHYSICAL: {
                return 1;
            }
            case SPECIAL: {
                return 2;
            }
        }
        return 0;
    }

    private static Type[] constructTypeTable() {
        Type[] table = new Type[256];
        table[0] = Type.NORMAL;
        table[1] = Type.FIGHTING;
        table[2] = Type.FLYING;
        table[3] = Type.POISON;
        table[4] = Type.GROUND;
        table[5] = Type.ROCK;
        table[6] = Type.BUG;
        table[7] = Type.GHOST;
        table[8] = Type.STEEL;
        table[9] = Type.FIRE;
        table[10] = Type.WATER;
        table[11] = Type.GRASS;
        table[12] = Type.ELECTRIC;
        table[13] = Type.PSYCHIC;
        table[14] = Type.ICE;
        table[15] = Type.DRAGON;
        table[16] = Type.DARK;
        return table;
    }

    public static byte typeToByte(Type type) {
        if (type == null) {
            return 0;
        }
        switch (type) {
            case NORMAL: {
                return 0;
            }
            case FIGHTING: {
                return 1;
            }
            case FLYING: {
                return 2;
            }
            case POISON: {
                return 3;
            }
            case GROUND: {
                return 4;
            }
            case ROCK: {
                return 5;
            }
            case BUG: {
                return 6;
            }
            case GHOST: {
                return 7;
            }
            case FIRE: {
                return 9;
            }
            case WATER: {
                return 10;
            }
            case GRASS: {
                return 11;
            }
            case ELECTRIC: {
                return 12;
            }
            case PSYCHIC: {
                return 13;
            }
            case ICE: {
                return 14;
            }
            case DRAGON: {
                return 15;
            }
            case STEEL: {
                return 8;
            }
            case DARK: {
                return 16;
            }
        }
        return 0;
    }

    private static void setupAllowedItems() {
        allowedItems = new ItemList(638);
        allowedItems.banRange(428, 109);
        allowedItems.banRange(621, 18);
        allowedItems.banSingles(574, 578, 579, 616, 617);
        allowedItems.banRange(113, 3);
        allowedItems.banRange(120, 14);
        allowedItems.tmRange(328, 92);
        allowedItems.tmRange(618, 3);
        allowedItems.banRange(328, 100);
        allowedItems.banRange(618, 3);
        allowedItems.banRange(592, 24);
        nonBadItems = allowedItems.copy();
        nonBadItems.banSingles(111, 112, 236, 155);
        nonBadItems.banRange(95, 4);
        nonBadItems.banRange(135, 2);
        nonBadItems.banRange(137, 12);
        nonBadItems.banRange(159, 54);
        nonBadItems.banRange(256, 4);
        nonBadItems.banRange(260, 5);
    }

    public static void tagTrainersBW(List<Trainer> trs) {
        Gen5Constants.tag(trs, "GYM11", 9, 10);
        Gen5Constants.tag(trs, "GYM2", 86, 87, 88);
        Gen5Constants.tag(trs, "GYM3", 196, 198, 199, 200);
        Gen5Constants.tag(trs, "GYM4", 66, 67, 68, 69);
        Gen5Constants.tag(trs, "GYM5", 201, 202, 203, 95, 168);
        Gen5Constants.tag(trs, "GYM6", 125, 127, 128, 70, 71);
        Gen5Constants.tag(trs, "GYM7", 215, 216, 217, 212, 213, 214);
        Gen5Constants.tag(trs, "GYM8", 265, 266, 271, 270, 272, 267, 275, 274);
        Gen5Constants.tag(trs, 12, "GYM1");
        Gen5Constants.tag(trs, 11, "GYM9");
        Gen5Constants.tag(trs, 13, "GYM10");
        Gen5Constants.tag(trs, 21, "GYM2");
        Gen5Constants.tag(trs, 22, "GYM3");
        Gen5Constants.tag(trs, 23, "GYM4");
        Gen5Constants.tag(trs, 24, "GYM5");
        Gen5Constants.tag(trs, 25, "GYM6");
        Gen5Constants.tag(trs, 131, "GYM7");
        Gen5Constants.tag(trs, 132, "GYM8");
        Gen5Constants.tag(trs, 133, "GYM8");
        Gen5Constants.tag(trs, 228, "ELITE1");
        Gen5Constants.tag(trs, 230, "ELITE2");
        Gen5Constants.tag(trs, 231, "ELITE3");
        Gen5Constants.tag(trs, 229, "ELITE4");
        Gen5Constants.tag(trs, 563, "ELITE1");
        Gen5Constants.tag(trs, 565, "ELITE2");
        Gen5Constants.tag(trs, 566, "ELITE3");
        Gen5Constants.tag(trs, 564, "ELITE4");
        Gen5Constants.tag(trs, 407, "CHAMPION");
        Gen5Constants.tag(trs, 542, "UBER");
        Gen5Constants.tag(trs, 567, "UBER");
        Gen5Constants.tag(trs, 232, "UBER");
        Gen5Constants.tag(trs, 586, "UBER");
        Gen5Constants.tag(trs, 587, "UBER");
        Gen5Constants.tagRivalBW(trs, "RIVAL1", 53);
        Gen5Constants.tagRivalBW(trs, "RIVAL2", 287);
        Gen5Constants.tagRivalBW(trs, "RIVAL3", 56);
        Gen5Constants.tagRivalBW(trs, "RIVAL4", 403);
        Gen5Constants.tagRivalBW(trs, "RIVAL5", 90);
        Gen5Constants.tagRivalBW(trs, "RIVAL6", 539);
        Gen5Constants.tagRivalBW(trs, "RIVAL7", 588);
        Gen5Constants.tagRivalBW(trs, "RIVAL8", 591);
        Gen5Constants.tagRivalBW(trs, "FRIEND1", 59);
        Gen5Constants.tagRivalBW(trs, "FRIEND2", 498);
        Gen5Constants.tagRivalBW(trs, "FRIEND3", 507);
        Gen5Constants.tagRivalBW(trs, "FRIEND4", 491);
        Gen5Constants.tagRivalBW(trs, "FRIEND5", 494);
        Gen5Constants.tagRivalBW(trs, "FRIEND6", 594);
    }

    public static void tagTrainersBW2(List<Trainer> trs) {
        Gen5Constants.tag(trs, "GYM1", 171, 172);
        Gen5Constants.tag(trs, "GYM2", 178, 179);
        Gen5Constants.tag(trs, "GYM3", 734, 735, 736, 737);
        Gen5Constants.tag(trs, "GYM4", 621, 148, 207, 208, 209);
        Gen5Constants.tag(trs, "GYM5", 319, 320, 321, 322, 323, 324, 325);
        Gen5Constants.tag(trs, "GYM6", 149, 150, 151, 152, 332);
        Gen5Constants.tag(trs, "GYM7", 381, 382, 383, 384, 385);
        Gen5Constants.tag(trs, "GYM8", 350, 351, 352, 353, 354, 355);
        Gen5Constants.tag(trs, "GYM1", 156, 764);
        Gen5Constants.tag(trs, "GYM2", 157, 765);
        Gen5Constants.tag(trs, "GYM3", 154, 766);
        Gen5Constants.tag(trs, "GYM4", 153, 767);
        Gen5Constants.tag(trs, "GYM5", 158, 768);
        Gen5Constants.tag(trs, "GYM6", 155, 769);
        Gen5Constants.tag(trs, "GYM7", 159, 770);
        Gen5Constants.tag(trs, "GYM8", 160, 771);
        Gen5Constants.tag(trs, "ELITE1", 38, 772, 143, 777);
        Gen5Constants.tag(trs, "ELITE2", 40, 773, 145, 778);
        Gen5Constants.tag(trs, "ELITE3", 41, 775, 146, 780);
        Gen5Constants.tag(trs, "ELITE4", 39, 774, 144, 779);
        Gen5Constants.tag(trs, "CHAMPION", 341, 776, 536, 781);
        Gen5Constants.tagRivalBW(trs, "RIVAL1", 161);
        Gen5Constants.tagRivalBW(trs, "RIVAL2", 166);
        Gen5Constants.tagRivalBW(trs, "RIVAL3", 588);
        Gen5Constants.tagRivalBW(trs, "RIVAL4", 368);
        Gen5Constants.tagRivalBW(trs, "RIVAL5", 378);
        Gen5Constants.tagRivalBW(trs, "RIVAL6", 701);
        Gen5Constants.tagRivalBW(trs, "RIVAL7", 794);
        Gen5Constants.tagRivalBW(trs, "RIVAL8", 684);
        Gen5Constants.tagRivalBW(trs, "RIVAL9", 693);
        Gen5Constants.tagRivalBW(trs, "RIVAL10", 696);
        Gen5Constants.tagRivalBW(trs, "FRIEND1", 360);
        Gen5Constants.tagRivalBW(trs, "FRIEND1", 363);
        Gen5Constants.tag(trs, "GYM1", 371, 632, 814);
        Gen5Constants.tag(trs, "GYM9", 496);
        Gen5Constants.tag(trs, "GYM10", 494);
        Gen5Constants.tag(trs, "GYM11", 495);
        Gen5Constants.tag(trs, "THEMED:ZINZOLIN", 704, 584, 347);
        Gen5Constants.tag(trs, "THEMED:COLRESS", 358, 344, 813, 815);
        Gen5Constants.tag(trs, "THEMED:SHADOW1", 583, 348, 687);
        Gen5Constants.tag(trs, "THEMED:SHADOW2", 498, 688);
        Gen5Constants.tag(trs, "THEMED:SHADOW3", 499, 689);
        Gen5Constants.tag(trs, 582, "UBER");
        Gen5Constants.tag(trs, 456, "UBER");
        Gen5Constants.tag(trs, 202, "UBER");
        Gen5Constants.tag(trs, 201, "UBER");
        Gen5Constants.tag(trs, 5, "UBER");
        Gen5Constants.tag(trs, 6, "UBER");
        Gen5Constants.tag(trs, 782, "UBER");
        Gen5Constants.tag(trs, 783, "UBER");
        Gen5Constants.tag(trs, 784, "UBER");
        Gen5Constants.tag(trs, 785, "UBER");
        Gen5Constants.tag(trs, 345, "UBER");
        Gen5Constants.tag(trs, 140, "UBER");
        Gen5Constants.tag(trs, 591, "UBER");
    }

    private static void tagRivalBW(List<Trainer> allTrainers, String tag, int offset) {
        allTrainers.get((int)(offset - 1)).tag = tag + "-0";
        allTrainers.get((int)offset).tag = tag + "-1";
        allTrainers.get((int)(offset + 1)).tag = tag + "-2";
    }

    private static void tag(List<Trainer> allTrainers, int number, String tag) {
        if (allTrainers.size() > number - 1) {
            allTrainers.get((int)(number - 1)).tag = tag;
        }
    }

    private static void tag(List<Trainer> allTrainers, String tag, int ... numbers) {
        for (int num : numbers) {
            if (allTrainers.size() <= num - 1) continue;
            allTrainers.get((int)(num - 1)).tag = tag;
        }
    }

    static {
        Gen5Constants.setupAllowedItems();
        habitatListEntries = new int[][]{{104, 105}, {124}, {134}, {84, 85, 86}, {23, 24, 25, 26}, {97}, {27, 28, 29, 30}, {81, 82, 83}, {106}, {125}, {98}, {123}, {132}, {107}, {43}, {102, 103}, {95}, {127}, {32, 33, 34, 35, 36}, {111}, {31, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80}, {12, 13, 14, 15, 16, 17, 18, 19}, {0}, {128}, {3}, {116}, {44, 45}, {61, 62, 63, 64, 65, 66, 67, 68, 69, 70}, {129}, {4}, {37, 38, 39, 40, 41}, {118}, {46, 47}, {42}, {1}, {8, 9}, {5}, {48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60}, {6, 7}, {112, 113, 114, 115}, {130}, {10, 11}, {119}, {133}, {99}, {131}, {2}, {120}, {100}, {108, 109}, {121}, {101}, {117}, {96}, {93, 94}, {126}, {122}, {20, 21, 22}};
        wildFileToAreaMap = new int[]{2, 4, 8, 59, 61, 63, 19, 19, 20, 20, 21, 21, 22, 22, 22, 22, 22, 22, 22, 22, 24, 24, 24, 25, 25, 25, 25, 26, 26, 26, 26, 76, 27, 27, 27, 27, 27, 70, 70, 70, 70, 70, 29, 35, 71, 71, 72, 72, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 77, 77, 77, 79, 79, 79, 79, 79, 79, 79, 79, 79, 78, 78, -1, 55, 57, 58, 37, 38, 39, 30, 30, 40, 40, 41, 42, 31, 31, 31, 43, 32, 32, 32, 32, 44, 33, 45, 46, 47, 48, 49, 34, 50, 51, 36, 53, 66, 67, 69, 75, 12, 52, 68};
    }
}

