/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.constants;

import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.MoveCategory;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.Type;
import java.util.Arrays;
import java.util.List;

public class Gen4Constants {
    public static final int Type_DP = 0;
    public static final int Type_Plat = 1;
    public static final int Type_HGSS = 2;
    public static final int pokemonCount = 493;
    public static final int moveCount = 467;
    public static final int bsHPOffset = 0;
    public static final int bsAttackOffset = 1;
    public static final int bsDefenseOffset = 2;
    public static final int bsSpeedOffset = 3;
    public static final int bsSpAtkOffset = 4;
    public static final int bsSpDefOffset = 5;
    public static final int bsPrimaryTypeOffset = 6;
    public static final int bsSecondaryTypeOffset = 7;
    public static final int bsCatchRateOffset = 8;
    public static final int bsCommonHeldItemOffset = 12;
    public static final int bsRareHeldItemOffset = 14;
    public static final int bsGrowthCurveOffset = 19;
    public static final int bsAbility1Offset = 22;
    public static final int bsAbility2Offset = 23;
    public static final int bsTMHMCompatOffset = 28;
    public static final byte[] hgssStarterCodeSuffix = new byte[]{3, 3, 26, 18, 1, 35, 0, 0};
    public static final int[] hgssFilesWithRivalScript = new int[]{7, 23, 96, 110, 819, 850, 866};
    public static final byte[] hgssRivalScriptMagic = new byte[]{-50, 0, 12, -128, 17, 0, 12, -128, -104, 0, 28, 0, 5};
    public static final int[] ptFilesWithRivalScript = new int[]{31, 36, 112, 123, 186, 427, 429, 1096};
    public static final int[] dpFilesWithRivalScript = new int[]{34, 90, 118, 180, 195, 394};
    public static final byte[] dpptRivalScriptMagic = new byte[]{-34, 0, 12, -128, 17, 0, 12, -128, -125, 1, 28, 0, 1};
    public static final byte[] dpptTagBattleScriptMagic1 = new byte[]{-34, 0, 12, -128, 40, 0, 4, -128};
    public static final byte[] dpptTagBattleScriptMagic2 = new byte[]{17, 0, 12, -128, -122, 1, 28, 0, 1};
    public static final int[] ptFilesWithTagScript = new int[]{2, 136, 201, 236};
    public static final int[] dpFilesWithTagScript = new int[]{2, 131, 230};
    public static final int dpStarterStringIndex = 19;
    public static final int ptStarterStringIndex = 36;
    public static final int chikoritaIndex = 152;
    public static final int cyndaquilIndex = 155;
    public static final int totodileIndex = 158;
    public static final int turtwigIndex = 387;
    public static final int chimcharIndex = 390;
    public static final int piplupIndex = 393;
    public static final int slowpokeIndex = 79;
    public static final int fossilCount = 7;
    public static final String dpptTMDataPrefix = "D100D200D300D400";
    public static final String hgssTMDataPrefix = "1E003200";
    public static final int tmCount = 92;
    public static final int hmCount = 8;
    public static final int tmItemOffset = 328;
    public static final int textCharsPerLine = 40;
    public static final String dpItemPalettesPrefix = "8D018E01210132018D018F0122013301";
    public static final String pthgssItemPalettesPrefix = "8D018E01210133018D018F0122013401";
    public static final int evolutionMethodCount = 26;
    public static final int waterStoneIndex = 84;
    public static final int leafStoneIndex = 85;
    public static final int dawnStoneIndex = 109;
    public static final int highestAbilityIndex = 123;
    public static final int dpptSetVarScript = 40;
    public static final int hgssSetVarScript = 41;
    public static final int scriptListTerminator = 64787;
    public static final int itemScriptVariable = 32776;
    public static final int luckyEggIndex = 231;
    public static final int[] dpptAlternateSlots = new int[]{0, 1, 2, 3, 2, 3, 4, 5, 10, 11, 8, 9, 8, 9, 8, 9, 8, 9, 8, 9};
    public static final String[] dpptWaterSlotSetNames = new String[]{"Surfing", "Filler", "Old Rod", "Good Rod", "Super Rod"};
    public static final String[] hgssTimeOfDayNames = new String[]{"Morning", "Day", "Night"};
    public static final String[] hgssNonGrassSetNames = new String[]{"", "Surfing", "Rock Smash", "Old Rod", "Good Rod", "Super Rod"};
    public static final MoveCategory[] moveCategoryIndices = new MoveCategory[]{MoveCategory.PHYSICAL, MoveCategory.SPECIAL, MoveCategory.STATUS};
    public static final List<Integer> dpRequiredFieldTMs = Arrays.asList(2, 3, 5, 9, 12, 19, 23, 28, 34, 39, 41, 43, 46, 47, 49, 50, 62, 69, 79, 80, 82, 84, 85, 87);
    public static final List<Integer> ptRequiredFieldTMs = Arrays.asList(2, 3, 5, 7, 9, 11, 12, 18, 19, 23, 28, 34, 37, 39, 41, 43, 46, 47, 49, 50, 62, 69, 79, 80, 82, 84, 85, 87);
    public static final List<Integer> dpptFieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100, 127, 249, 230, 432, 431);
    public static final List<Integer> hgssFieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100, 250, 127, 249, 29, 230, 431);
    public static final List<Integer> dpptEarlyRequiredHMMoves = Arrays.asList(249, 15);
    public static final List<Integer> hgssEarlyRequiredHMMoves = Arrays.asList(15);
    public static ItemList allowedItems;
    public static ItemList nonBadItems;
    public static final Type[] typeTable;

    public static byte moveCategoryToByte(MoveCategory cat) {
        switch (cat) {
            case PHYSICAL: {
                return 0;
            }
            case SPECIAL: {
                return 1;
            }
        }
        return 2;
    }

    private static void setupAllowedItems() {
        allowedItems = new ItemList(536);
        allowedItems.banRange(428, 109);
        allowedItems.banRange(112, 23);
        allowedItems.banRange(420, 8);
        allowedItems.tmRange(328, 92);
        nonBadItems = allowedItems.copy();
        nonBadItems.banSingles(111, 112, 236, 155);
        nonBadItems.banRange(95, 4);
        nonBadItems.banRange(135, 2);
        nonBadItems.banRange(137, 12);
        nonBadItems.banRange(159, 54);
        nonBadItems.banRange(256, 4);
        nonBadItems.banRange(260, 5);
    }

    private static Type[] constructTypeTable() {
        Type[] table = new Type[256];
        table[0] = Type.NORMAL;
        table[1] = Type.FIGHTING;
        table[2] = Type.FLYING;
        table[3] = Type.POISON;
        table[4] = Type.GROUND;
        table[5] = Type.ROCK;
        table[6] = Type.BUG;
        table[7] = Type.GHOST;
        table[8] = Type.STEEL;
        table[10] = Type.FIRE;
        table[11] = Type.WATER;
        table[12] = Type.GRASS;
        table[13] = Type.ELECTRIC;
        table[14] = Type.PSYCHIC;
        table[15] = Type.ICE;
        table[16] = Type.DRAGON;
        table[17] = Type.DARK;
        return table;
    }

    public static byte typeToByte(Type type) {
        if (type == null) {
            return 9;
        }
        switch (type) {
            case NORMAL: {
                return 0;
            }
            case FIGHTING: {
                return 1;
            }
            case FLYING: {
                return 2;
            }
            case POISON: {
                return 3;
            }
            case GROUND: {
                return 4;
            }
            case ROCK: {
                return 5;
            }
            case BUG: {
                return 6;
            }
            case GHOST: {
                return 7;
            }
            case FIRE: {
                return 10;
            }
            case WATER: {
                return 11;
            }
            case GRASS: {
                return 12;
            }
            case ELECTRIC: {
                return 13;
            }
            case PSYCHIC: {
                return 14;
            }
            case ICE: {
                return 15;
            }
            case DRAGON: {
                return 16;
            }
            case STEEL: {
                return 8;
            }
            case DARK: {
                return 17;
            }
        }
        return 0;
    }

    public static void tagTrainersDP(List<Trainer> trs) {
        Gen4Constants.tag(trs, "GYM1", 244, 245);
        Gen4Constants.tag(trs, "GYM2", 324, 259, 260, 348);
        Gen4Constants.tag(trs, "GYM3", 309, 310, 311, 312);
        Gen4Constants.tag(trs, "GYM4", 497, 498, 401, 339, 293, 483);
        Gen4Constants.tag(trs, "GYM5", 357, 325, 266, 330, 340, 343, 280, 284);
        Gen4Constants.tag(trs, "GYM6", 314, 256, 257, 279, 367, 232, 283);
        Gen4Constants.tag(trs, "GYM7", 268, 269, 270, 271, 827, 828);
        Gen4Constants.tag(trs, "GYM8", 344, 341, 301, 302, 303, 285, 281);
        Gen4Constants.tag(trs, 246, "GYM1");
        Gen4Constants.tag(trs, 315, "GYM2");
        Gen4Constants.tag(trs, 317, "GYM3");
        Gen4Constants.tag(trs, 316, "GYM4");
        Gen4Constants.tag(trs, 318, "GYM5");
        Gen4Constants.tag(trs, 250, "GYM6");
        Gen4Constants.tag(trs, 319, "GYM7");
        Gen4Constants.tag(trs, 320, "GYM8");
        Gen4Constants.tag(trs, 261, "ELITE1");
        Gen4Constants.tag(trs, 262, "ELITE2");
        Gen4Constants.tag(trs, 263, "ELITE3");
        Gen4Constants.tag(trs, 264, "ELITE4");
        Gen4Constants.tag(trs, 267, "CHAMPION");
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL1", 248);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL2", 471);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL3", 474);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL4", 477);
        Gen4Constants.tag(trs, 619, "RIVAL5-0");
        Gen4Constants.tag(trs, 620, "RIVAL5-1");
        Gen4Constants.tag(trs, 607, "RIVAL5-2");
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL6", 480);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL7", 838);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL8", 841);
        Gen4Constants.tag(trs, "THEMED:CYRUS", 403, 404);
        Gen4Constants.tag(trs, "THEMED:MARS", 295, 405, 528);
        Gen4Constants.tag(trs, "THEMED:JUPITER", 406, 407);
        Gen4Constants.tag(trs, "THEMED:SATURN", 408, 409);
        Gen4Constants.tagFriendConsecutive(trs, "FRIEND1", 613);
        Gen4Constants.tagFriendConsecutive(trs, "FRIEND1", 616);
        Gen4Constants.tagFriendConsecutive2(trs, "FRIEND2", 621);
        Gen4Constants.tagFriendConsecutive2(trs, "FRIEND2", 624);
    }

    public static void tagTrainersPt(List<Trainer> trs) {
        Gen4Constants.tag(trs, "GYM1", 244, 245);
        Gen4Constants.tag(trs, "GYM2", 324, 259, 260, 348);
        Gen4Constants.tag(trs, "GYM3", 357, 325, 340, 343, 280, 284);
        Gen4Constants.tag(trs, "GYM4", 309, 310, 311, 312);
        Gen4Constants.tag(trs, "GYM5", 497, 498, 401, 339, 293, 483);
        Gen4Constants.tag(trs, "GYM6", 314, 256, 257, 279, 367, 232, 283);
        Gen4Constants.tag(trs, "GYM7", 268, 269, 270, 271, 827, 828);
        Gen4Constants.tag(trs, "GYM8", 344, 341, 301, 302, 303, 285, 281, 331);
        Gen4Constants.tag(trs, 246, "GYM1");
        Gen4Constants.tag(trs, 315, "GYM2");
        Gen4Constants.tag(trs, 318, "GYM3");
        Gen4Constants.tag(trs, 317, "GYM4");
        Gen4Constants.tag(trs, 316, "GYM5");
        Gen4Constants.tag(trs, 250, "GYM6");
        Gen4Constants.tag(trs, 319, "GYM7");
        Gen4Constants.tag(trs, 320, "GYM8");
        Gen4Constants.tag(trs, 261, "ELITE1");
        Gen4Constants.tag(trs, 262, "ELITE2");
        Gen4Constants.tag(trs, 263, "ELITE3");
        Gen4Constants.tag(trs, 264, "ELITE4");
        Gen4Constants.tag(trs, 267, "CHAMPION");
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL1", 851);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL2", 248);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL3", 471);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL4", 474);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL5", 477);
        Gen4Constants.tag(trs, 619, "RIVAL6-0");
        Gen4Constants.tag(trs, 620, "RIVAL6-1");
        Gen4Constants.tag(trs, 607, "RIVAL6-2");
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL7", 480);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL8", 838);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL9", 841);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL10", 872);
        Gen4Constants.tag(trs, 858, "GYM1");
        Gen4Constants.tag(trs, 857, "GYM2");
        Gen4Constants.tag(trs, 860, "GYM3");
        Gen4Constants.tag(trs, 854, "GYM4");
        Gen4Constants.tag(trs, 859, "GYM5");
        Gen4Constants.tag(trs, 856, "GYM6");
        Gen4Constants.tag(trs, 853, "GYM7");
        Gen4Constants.tag(trs, 855, "GYM8");
        Gen4Constants.tag(trs, 921, "GYM8");
        Gen4Constants.tag(trs, 922, "ELITE3");
        Gen4Constants.tag(trs, 866, "ELITE1");
        Gen4Constants.tag(trs, 867, "ELITE2");
        Gen4Constants.tag(trs, 868, "ELITE3");
        Gen4Constants.tag(trs, 869, "ELITE4");
        Gen4Constants.tag(trs, 870, "CHAMPION");
        Gen4Constants.tag(trs, "THEMED:CYRUS", 913, 403, 404);
        Gen4Constants.tag(trs, "THEMED:MARS", 295, 405, 528, 926);
        Gen4Constants.tag(trs, "THEMED:JUPITER", 406, 407, 927);
        Gen4Constants.tag(trs, "THEMED:SATURN", 408, 409);
        Gen4Constants.tagFriendConsecutive(trs, "FRIEND1", 613);
        Gen4Constants.tagFriendConsecutive(trs, "FRIEND1", 616);
        Gen4Constants.tagFriendConsecutive2(trs, "FRIEND2", 621);
        Gen4Constants.tagFriendConsecutive2(trs, "FRIEND2", 624);
    }

    public static void tagTrainersHGSS(List<Trainer> trs) {
        Gen4Constants.tag(trs, "GYM1", 50, 29);
        Gen4Constants.tag(trs, "GYM2", 67, 68, 69, 10);
        Gen4Constants.tag(trs, "GYM3", 5, 70, 71, 22);
        Gen4Constants.tag(trs, "GYM4", 87, 88, 89, 46);
        Gen4Constants.tag(trs, "GYM5", 156, 157, 159, 251);
        Gen4Constants.tag(trs, "GYM7", 480, 481, 482, 483, 484);
        Gen4Constants.tag(trs, "GYM8", 110, 111, 112, 117, 119);
        Gen4Constants.tag(trs, "GYM9", 308, 685);
        Gen4Constants.tag(trs, "GYM10", 676, 677, 678, 297, 298);
        Gen4Constants.tag(trs, "GYM11", 396, 232, 337);
        Gen4Constants.tag(trs, "GYM12", 336, 326, 356, 346);
        Gen4Constants.tag(trs, "GYM13", 83, 84, 183, 136);
        Gen4Constants.tag(trs, "GYM14", 368, 369, 230, 415);
        Gen4Constants.tag(trs, "GYM15", 689, 690, 691, 692, 693, 694);
        Gen4Constants.tag(trs, "GYM16", 681, 682, 683, 684);
        Gen4Constants.tag(trs, 20, "GYM1");
        Gen4Constants.tag(trs, 21, "GYM2");
        Gen4Constants.tag(trs, 30, "GYM3");
        Gen4Constants.tag(trs, 31, "GYM4");
        Gen4Constants.tag(trs, 34, "GYM5");
        Gen4Constants.tag(trs, 33, "GYM6");
        Gen4Constants.tag(trs, 32, "GYM7");
        Gen4Constants.tag(trs, 35, "GYM8");
        Gen4Constants.tag(trs, 253, "GYM9");
        Gen4Constants.tag(trs, 254, "GYM10");
        Gen4Constants.tag(trs, 255, "GYM11");
        Gen4Constants.tag(trs, 256, "GYM12");
        Gen4Constants.tag(trs, 257, "GYM13");
        Gen4Constants.tag(trs, 258, "GYM14");
        Gen4Constants.tag(trs, 259, "GYM15");
        Gen4Constants.tag(trs, 261, "GYM16");
        Gen4Constants.tag(trs, 245, "ELITE1");
        Gen4Constants.tag(trs, 247, "ELITE2");
        Gen4Constants.tag(trs, 418, "ELITE3");
        Gen4Constants.tag(trs, 246, "ELITE4");
        Gen4Constants.tag(trs, 244, "CHAMPION");
        Gen4Constants.tag(trs, 260, "UBER");
        Gen4Constants.tag(trs, 712, "GYM1");
        Gen4Constants.tag(trs, 713, "GYM2");
        Gen4Constants.tag(trs, 714, "GYM3");
        Gen4Constants.tag(trs, 715, "GYM4");
        Gen4Constants.tag(trs, 718, "GYM5");
        Gen4Constants.tag(trs, 717, "GYM6");
        Gen4Constants.tag(trs, 716, "GYM7");
        Gen4Constants.tag(trs, 719, "GYM8");
        Gen4Constants.tag(trs, 720, "GYM9");
        Gen4Constants.tag(trs, 721, "GYM10");
        Gen4Constants.tag(trs, 722, "GYM11");
        Gen4Constants.tag(trs, 723, "GYM12");
        Gen4Constants.tag(trs, 724, "GYM13");
        Gen4Constants.tag(trs, 725, "GYM14");
        Gen4Constants.tag(trs, 726, "GYM15");
        Gen4Constants.tag(trs, 727, "GYM16");
        Gen4Constants.tag(trs, 702, "ELITE1");
        Gen4Constants.tag(trs, 703, "ELITE2");
        Gen4Constants.tag(trs, 704, "ELITE3");
        Gen4Constants.tag(trs, 705, "ELITE4");
        Gen4Constants.tag(trs, 701, "CHAMPION");
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL1", 496);
        Gen4Constants.tag(trs, 266, "RIVAL2-0");
        Gen4Constants.tag(trs, 269, "RIVAL2-1");
        Gen4Constants.tag(trs, 1, "RIVAL2-2");
        Gen4Constants.tag(trs, 267, "RIVAL3-0");
        Gen4Constants.tag(trs, 270, "RIVAL3-1");
        Gen4Constants.tag(trs, 263, "RIVAL3-2");
        Gen4Constants.tag(trs, 289, "RIVAL4-0");
        Gen4Constants.tag(trs, 271, "RIVAL4-1");
        Gen4Constants.tag(trs, 288, "RIVAL4-2");
        Gen4Constants.tag(trs, 268, "RIVAL5-0");
        Gen4Constants.tag(trs, 272, "RIVAL5-1");
        Gen4Constants.tag(trs, 264, "RIVAL5-2");
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL6", 286);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL7", 736);
        Gen4Constants.tagRivalConsecutive(trs, "RIVAL8", 490);
        Gen4Constants.tag(trs, 734, "GYM8");
        Gen4Constants.tag(trs, 733, "CHAMPION");
        Gen4Constants.tag(trs, "THEMED:ARIANA", 479, 478);
        Gen4Constants.tag(trs, "THEMED:PETREL", 488, 487);
        Gen4Constants.tag(trs, "THEMED:PROTON", 486, 706);
        Gen4Constants.tag(trs, "THEMED:SPROUTTOWER", 43, 51, 52, 53, 54, 55, 290);
    }

    private static void tag(List<Trainer> allTrainers, int number, String tag) {
        allTrainers.get((int)(number - 1)).tag = tag;
    }

    private static void tag(List<Trainer> allTrainers, String tag, int ... numbers) {
        for (int num : numbers) {
            allTrainers.get((int)(num - 1)).tag = tag;
        }
    }

    private static void tagRivalConsecutive(List<Trainer> allTrainers, String tag, int offsetFire) {
        allTrainers.get((int)(offsetFire - 1)).tag = tag + "-0";
        allTrainers.get((int)offsetFire).tag = tag + "-1";
        allTrainers.get((int)(offsetFire - 2)).tag = tag + "-2";
    }

    private static void tagFriendConsecutive(List<Trainer> allTrainers, String tag, int offsetGrass) {
        allTrainers.get((int)(offsetGrass - 1)).tag = tag + "-1";
        allTrainers.get((int)offsetGrass).tag = tag + "-2";
        allTrainers.get((int)(offsetGrass + 1)).tag = tag + "-0";
    }

    private static void tagFriendConsecutive2(List<Trainer> allTrainers, String tag, int offsetWater) {
        allTrainers.get((int)(offsetWater - 1)).tag = tag + "-0";
        allTrainers.get((int)offsetWater).tag = tag + "-1";
        allTrainers.get((int)(offsetWater + 1)).tag = tag + "-2";
    }

    static {
        Gen4Constants.setupAllowedItems();
        typeTable = Gen4Constants.constructTypeTable();
    }
}

