/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.constants;

import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.Type;
import java.util.Arrays;
import java.util.List;

public class Gen3Constants {
    public static final int RomType_Ruby = 0;
    public static final int RomType_Sapp = 1;
    public static final int RomType_Em = 2;
    public static final int RomType_FRLG = 3;
    public static final int size8M = 0x800000;
    public static final int size16M = 0x1000000;
    public static final int size32M = 0x2000000;
    public static final String unofficialEmeraldROMName = "YJencrypted";
    public static final int romNameOffset = 160;
    public static final int romCodeOffset = 172;
    public static final int romVersionOffset = 188;
    public static final int headerChecksumOffset = 189;
    public static final String wildPokemonPointerPrefix = "0348048009E00000FFFF0000";
    public static final String mapBanksPointerPrefix = "80180068890B091808687047";
    public static final String rsPokemonNamesPointerSuffix = "30B50025084CC8F7";
    public static final String frlgMapLabelsPointerPrefix = "AC470000AE470000B0470000";
    public static final String rseMapLabelsPointerPrefix = "C078288030BC01BC00470000";
    public static final String pokedexOrderPointerPrefix = "0448814208D0481C0004000C05E00000";
    public static final String rsFrontSpritesPointerPrefix = "05E0";
    public static final String rsFrontSpritesPointerSuffix = "1068191C";
    public static final String rsPokemonPalettesPointerPrefix = "04D90148006817E0";
    public static final String rsPokemonPalettesPointerSuffix = "080C064A11404840";
    public static final int efrlgPokemonNamesPointer = 324;
    public static final int efrlgMoveNamesPointer = 328;
    public static final int efrlgAbilityNamesPointer = 448;
    public static final int efrlgItemDataPointer = 456;
    public static final int efrlgMoveDataPointer = 460;
    public static final int efrlgPokemonStatsPointer = 444;
    public static final int efrlgFrontSpritesPointer = 296;
    public static final int efrlgPokemonPalettesPointer = 304;
    public static final byte[] emptyPokemonSig = new byte[]{50, -106, 50, -106, -106, 50, 0, 0, 3, 1, -86, 10, 0, 0, 0, 0, -1, 120, 0, 0, 15, 15, 0, 0, 0, 4, 0, 0};
    public static final int baseStatsEntrySize = 28;
    public static final int bsHPOffset = 0;
    public static final int bsAttackOffset = 1;
    public static final int bsDefenseOffset = 2;
    public static final int bsSpeedOffset = 3;
    public static final int bsSpAtkOffset = 4;
    public static final int bsSpDefOffset = 5;
    public static final int bsPrimaryTypeOffset = 6;
    public static final int bsSecondaryTypeOffset = 7;
    public static final int bsCatchRateOffset = 8;
    public static final int bsCommonHeldItemOffset = 12;
    public static final int bsRareHeldItemOffset = 14;
    public static final int bsGenderRatioOffset = 16;
    public static final int bsGrowthCurveOffset = 19;
    public static final int bsAbility1Offset = 22;
    public static final int bsAbility2Offset = 23;
    public static final int textTerminator = 255;
    public static final int textVariable = 253;
    public static final byte freeSpaceByte = -1;
    public static final int rseStarter2Offset = 2;
    public static final int rseStarter3Offset = 4;
    public static final int frlgStarter2Offset = 515;
    public static final int frlgStarter3Offset = 461;
    public static final int frlgStarterRepeatOffset = 5;
    public static final int frlgBaseStarter1 = 1;
    public static final int frlgBaseStarter2 = 4;
    public static final int frlgBaseStarter3 = 7;
    public static final int frlgStarterItemsOffset = 218;
    public static final int gbaAddRxOpcode = 48;
    public static final int gbaUnconditionalJumpOpcode = 224;
    public static final int gbaSetRxOpcode = 32;
    public static final int gbaCmpRxOpcode = 40;
    public static final int gbaNopOpcode = 18112;
    public static final int gbaR0 = 0;
    public static final int gbaR1 = 1;
    public static final int gbaR2 = 2;
    public static final int gbaR3 = 3;
    public static final int gbaR4 = 4;
    public static final int gbaR5 = 5;
    public static final int gbaR6 = 6;
    public static final int gbaR7 = 7;
    public static final Type[] typeTable = Gen3Constants.constructTypeTable();
    public static final int grassSlots = 12;
    public static final int surfingSlots = 5;
    public static final int rockSmashSlots = 5;
    public static final int fishingSlots = 10;
    public static final int unownIndex = 201;
    public static final int slowpokeIndex = 79;
    public static final int seadraIndex = 117;
    public static final int poliwhirlIndex = 61;
    public static final int mewIndex = 151;
    public static final int clamperlIndex = 366;
    public static final int huntailIndex = 367;
    public static final int gorebyssIndex = 368;
    public static final int tmCount = 50;
    public static final int hmCount = 8;
    public static final List<Integer> hmMoves = Arrays.asList(15, 19, 57, 70, 148, 249, 127, 291);
    public static final int tmItemOffset = 289;
    public static final int rseItemDescCharsPerLine = 18;
    public static final int frlgItemDescCharsPerLine = 24;
    public static final int regularTextboxCharsPerLine = 36;
    public static final int pointerSearchRadius = 500;
    public static final int itemDataDescriptionOffset = 20;
    public static final String deoxysObeyCode = "CD21490088420FD0";
    public static final int mewObeyOffsetFromDeoxysObey = 22;
    public static final String levelEvoKantoDexCheckCode = "972814DD";
    public static final String stoneEvoKantoDexCheckCode = "972808D9";
    public static final int levelEvoKantoDexJumpAmount = 20;
    public static final int stoneEvoKantoDexJumpAmount = 8;
    public static final String rsPokedexScriptIdentifier = "326629010803";
    public static final String rsNatDexScriptPart1 = "31720167";
    public static final String rsNatDexScriptPart2 = "32662901082B00801102006B02021103016B020211DABE4E020211675A6A02022A008003";
    public static final String frlgPokedexScriptIdentifier = "292908258101";
    public static final String frlgNatDexScript = "292908258101256F0103";
    public static final String frlgNatDexFlagChecker = "260D809301210D800100";
    public static final String frlgE4FlagChecker = "2B2C0800000000000000";
    public static final String frlgOaksLabKantoDexChecker = "257D011604800000260D80D400";
    public static final String frlgOaksLabFix = "257D011604800100";
    public static final String frlgOakOutsideHouseCheck = "1604800000260D80D4001908800580190980068083000880830109802109803C";
    public static final String frlgOakOutsideHouseFix = "1604800100";
    public static final String ePokedexScriptIdentifier = "3229610825F00129E40816CD40010003";
    public static final String eNatDexScriptPart1 = "31720167";
    public static final String eNatDexScriptPart2 = "3229610825F00129E40825F30116CD40010003";
    public static final int unhackedMaxPokedex = 411;
    public static final int unhackedRealPokedex = 386;
    public static final int hoennPokesStart = 252;
    public static final int evolutionMethodCount = 15;
    public static final int sunStoneIndex = 93;
    public static final int moonStoneIndex = 94;
    public static final int waterStoneIndex = 97;
    public static final int highestAbilityIndex = 77;
    public static final int frlgMapLabelsStart = 88;
    public static final List<Integer> rsRequiredFieldTMs = Arrays.asList(1, 2, 6, 7, 11, 18, 22, 23, 26, 30, 37, 48);
    public static final List<Integer> eRequiredFieldTMs = Arrays.asList(2, 6, 7, 11, 18, 22, 23, 30, 37, 48);
    public static final List<Integer> frlgRequiredFieldTMs = Arrays.asList(1, 2, 7, 8, 9, 11, 12, 14, 17, 18, 21, 22, 25, 32, 36, 37, 40, 41, 44, 46, 47, 48, 49, 50);
    public static final List<Integer> rseFieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100, 127, 249, 230, 291, 290);
    public static final List<Integer> frlgFieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100, 127, 249, 230);
    public static final List<Integer> rseEarlyRequiredHMMoves = Arrays.asList(249);
    public static final List<Integer> frlgEarlyRequiredHMMoves = Arrays.asList(15);
    public static final int luckyEggIndex = 197;
    public static ItemList allowedItems;
    public static ItemList nonBadItems;

    private static Type[] constructTypeTable() {
        Type[] table = new Type[256];
        table[0] = Type.NORMAL;
        table[1] = Type.FIGHTING;
        table[2] = Type.FLYING;
        table[3] = Type.POISON;
        table[4] = Type.GROUND;
        table[5] = Type.ROCK;
        table[6] = Type.BUG;
        table[7] = Type.GHOST;
        table[8] = Type.STEEL;
        table[10] = Type.FIRE;
        table[11] = Type.WATER;
        table[12] = Type.GRASS;
        table[13] = Type.ELECTRIC;
        table[14] = Type.PSYCHIC;
        table[15] = Type.ICE;
        table[16] = Type.DRAGON;
        table[17] = Type.DARK;
        return table;
    }

    public static byte typeToByte(Type type) {
        if (type == null) {
            return 9;
        }
        switch (type) {
            case NORMAL: {
                return 0;
            }
            case FIGHTING: {
                return 1;
            }
            case FLYING: {
                return 2;
            }
            case POISON: {
                return 3;
            }
            case GROUND: {
                return 4;
            }
            case ROCK: {
                return 5;
            }
            case BUG: {
                return 6;
            }
            case GHOST: {
                return 7;
            }
            case FIRE: {
                return 10;
            }
            case WATER: {
                return 11;
            }
            case GRASS: {
                return 12;
            }
            case ELECTRIC: {
                return 13;
            }
            case PSYCHIC: {
                return 14;
            }
            case ICE: {
                return 15;
            }
            case DRAGON: {
                return 16;
            }
            case STEEL: {
                return 8;
            }
            case DARK: {
                return 17;
            }
        }
        return 0;
    }

    private static void setupAllowedItems() {
        allowedItems = new ItemList(376);
        allowedItems.banRange(259, 30);
        allowedItems.banRange(349, 28);
        allowedItems.banRange(52, 11);
        allowedItems.banRange(87, 6);
        allowedItems.banRange(99, 4);
        allowedItems.banRange(112, 9);
        allowedItems.banRange(176, 3);
        allowedItems.banRange(226, 28);
        allowedItems.banRange(347, 2);
        allowedItems.banSingles(72, 82, 105, 267);
        allowedItems.banRange(339, 8);
        allowedItems.tmRange(289, 50);
        nonBadItems = allowedItems.copy();
        nonBadItems.banSingles(202, 139);
        nonBadItems.banRange(121, 12);
        nonBadItems.banRange(143, 33);
        nonBadItems.banRange(222, 4);
        nonBadItems.banRange(254, 5);
    }

    public static void trainerTagsRS(List<Trainer> trs, int romType) {
        Gen3Constants.tag(trs, "GYM1", 320, 321);
        Gen3Constants.tag(trs, "GYM2", 426, 425, 179);
        Gen3Constants.tag(trs, "GYM3", 191, 323, 194, 649);
        Gen3Constants.tag(trs, "GYM4", 201, 648, 203, 650, 205);
        Gen3Constants.tag(trs, "GYM5", 71, 89, 73, 90, 72, 91, 74);
        Gen3Constants.tag(trs, "GYM6", 401, 655, 654, 404);
        Gen3Constants.tag(trs, "GYM7", 233, 234, 235, 244, 245, 246);
        Gen3Constants.tag(trs, "GYM8", 130, 614, 131, 301, 129, 116, 128, 613);
        Gen3Constants.tag(trs, 265, "GYM1");
        Gen3Constants.tag(trs, 266, "GYM2");
        Gen3Constants.tag(trs, 267, "GYM3");
        Gen3Constants.tag(trs, 268, "GYM4");
        Gen3Constants.tag(trs, 269, "GYM5");
        Gen3Constants.tag(trs, 270, "GYM6");
        Gen3Constants.tag(trs, 271, "GYM7");
        Gen3Constants.tag(trs, 272, "GYM8");
        Gen3Constants.tag(trs, 261, "ELITE1");
        Gen3Constants.tag(trs, 262, "ELITE2");
        Gen3Constants.tag(trs, 263, "ELITE3");
        Gen3Constants.tag(trs, 264, "ELITE4");
        Gen3Constants.tag(trs, 335, "CHAMPION");
        Gen3Constants.tag(trs, 520, "RIVAL1-2");
        Gen3Constants.tag(trs, 523, "RIVAL1-0");
        Gen3Constants.tag(trs, 526, "RIVAL1-1");
        Gen3Constants.tag(trs, 521, "RIVAL2-2");
        Gen3Constants.tag(trs, 524, "RIVAL2-0");
        Gen3Constants.tag(trs, 527, "RIVAL2-1");
        Gen3Constants.tag(trs, 522, "RIVAL3-2");
        Gen3Constants.tag(trs, 525, "RIVAL3-0");
        Gen3Constants.tag(trs, 528, "RIVAL3-1");
        Gen3Constants.tag(trs, 661, "RIVAL4-2");
        Gen3Constants.tag(trs, 662, "RIVAL4-0");
        Gen3Constants.tag(trs, 663, "RIVAL4-1");
        Gen3Constants.tag(trs, 529, "RIVAL1-2");
        Gen3Constants.tag(trs, 532, "RIVAL1-0");
        Gen3Constants.tag(trs, 535, "RIVAL1-1");
        Gen3Constants.tag(trs, 530, "RIVAL2-2");
        Gen3Constants.tag(trs, 533, "RIVAL2-0");
        Gen3Constants.tag(trs, 536, "RIVAL2-1");
        Gen3Constants.tag(trs, 531, "RIVAL3-2");
        Gen3Constants.tag(trs, 534, "RIVAL3-0");
        Gen3Constants.tag(trs, 537, "RIVAL3-1");
        Gen3Constants.tag(trs, 664, "RIVAL4-2");
        Gen3Constants.tag(trs, 665, "RIVAL4-0");
        Gen3Constants.tag(trs, 666, "RIVAL4-1");
        if (romType == 0) {
            Gen3Constants.tag(trs, "THEMED:MAXIE", 601, 602);
            Gen3Constants.tag(trs, "THEMED:COURTNEY", 599, 600);
            Gen3Constants.tag(trs, "THEMED:TABITHA", 596, 597);
        } else {
            Gen3Constants.tag(trs, "THEMED:ARCHIE", 35, 34);
            Gen3Constants.tag(trs, "THEMED:MATT", 30, 31);
            Gen3Constants.tag(trs, "THEMED:SHELLY", 32, 33);
        }
    }

    public static void trainerTagsE(List<Trainer> trs) {
        Gen3Constants.tag(trs, "GYM1", 320, 321, 571);
        Gen3Constants.tag(trs, "GYM2", 426, 425, 179, 572, 573, 574);
        Gen3Constants.tag(trs, "GYM3", 191, 323, 194, 649, 802);
        Gen3Constants.tag(trs, "GYM4", 648, 201, 203, 650, 202, 204, 501, 205);
        Gen3Constants.tag(trs, "GYM5", 71, 89, 73, 90, 72, 91, 74);
        Gen3Constants.tag(trs, "GYM6", 402, 655, 401, 654, 404, 803);
        Gen3Constants.tag(trs, "GYM7", 233, 234, 235, 244, 245, 246, 591, 584, 583, 585, 582, 575);
        Gen3Constants.tag(trs, "GYM8", 613, 128, 502, 115, 129, 118, 130, 301, 131, 614);
        Gen3Constants.tag(trs, "GYM1", 265, 770, 771, 772, 773);
        Gen3Constants.tag(trs, "GYM2", 266, 774, 775, 776, 777);
        Gen3Constants.tag(trs, "GYM3", 267, 778, 779, 780, 781);
        Gen3Constants.tag(trs, "GYM4", 268, 782, 783, 784, 785);
        Gen3Constants.tag(trs, "GYM5", 269, 786, 787, 788, 789);
        Gen3Constants.tag(trs, "GYM6", 270, 790, 791, 792, 793);
        Gen3Constants.tag(trs, "GYM7", 271, 794, 795, 796, 797);
        Gen3Constants.tag(trs, "GYM8", 272, 798, 799, 800, 801);
        Gen3Constants.tag(trs, 261, "ELITE1");
        Gen3Constants.tag(trs, 262, "ELITE2");
        Gen3Constants.tag(trs, 263, "ELITE3");
        Gen3Constants.tag(trs, 264, "ELITE4");
        Gen3Constants.tag(trs, 335, "CHAMPION");
        Gen3Constants.tag(trs, 520, "RIVAL1-2");
        Gen3Constants.tag(trs, 523, "RIVAL1-0");
        Gen3Constants.tag(trs, 526, "RIVAL1-1");
        Gen3Constants.tag(trs, 593, "RIVAL2-2");
        Gen3Constants.tag(trs, 592, "RIVAL2-0");
        Gen3Constants.tag(trs, 599, "RIVAL2-1");
        Gen3Constants.tag(trs, 521, "RIVAL3-2");
        Gen3Constants.tag(trs, 524, "RIVAL3-0");
        Gen3Constants.tag(trs, 527, "RIVAL3-1");
        Gen3Constants.tag(trs, 522, "RIVAL4-2");
        Gen3Constants.tag(trs, 525, "RIVAL4-0");
        Gen3Constants.tag(trs, 528, "RIVAL4-1");
        Gen3Constants.tag(trs, 661, "RIVAL5-2");
        Gen3Constants.tag(trs, 662, "RIVAL5-0");
        Gen3Constants.tag(trs, 663, "RIVAL5-1");
        Gen3Constants.tag(trs, 529, "RIVAL1-2");
        Gen3Constants.tag(trs, 532, "RIVAL1-0");
        Gen3Constants.tag(trs, 535, "RIVAL1-1");
        Gen3Constants.tag(trs, 600, "RIVAL2-2");
        Gen3Constants.tag(trs, 768, "RIVAL2-0");
        Gen3Constants.tag(trs, 769, "RIVAL2-1");
        Gen3Constants.tag(trs, 530, "RIVAL3-2");
        Gen3Constants.tag(trs, 533, "RIVAL3-0");
        Gen3Constants.tag(trs, 536, "RIVAL3-1");
        Gen3Constants.tag(trs, 531, "RIVAL4-2");
        Gen3Constants.tag(trs, 534, "RIVAL4-0");
        Gen3Constants.tag(trs, 537, "RIVAL4-1");
        Gen3Constants.tag(trs, 664, "RIVAL5-2");
        Gen3Constants.tag(trs, 665, "RIVAL5-0");
        Gen3Constants.tag(trs, 666, "RIVAL5-1");
        Gen3Constants.tag(trs, "THEMED:MAXIE", 601, 602, 734);
        Gen3Constants.tag(trs, "THEMED:TABITHA", 514, 597, 732);
        Gen3Constants.tag(trs, "THEMED:ARCHIE", 34);
        Gen3Constants.tag(trs, "THEMED:MATT", 30);
        Gen3Constants.tag(trs, "THEMED:SHELLY", 32, 33);
        Gen3Constants.tag(trs, 804, "UBER");
    }

    public static void trainerTagsFRLG(List<Trainer> trs) {
        Gen3Constants.tag(trs, "GYM1", 142);
        Gen3Constants.tag(trs, "GYM2", 234, 150);
        Gen3Constants.tag(trs, "GYM3", 220, 141, 423);
        Gen3Constants.tag(trs, "GYM4", 266, 132, 265, 160, 402, 267, 133);
        Gen3Constants.tag(trs, "GYM5", 293, 292, 288, 295, 294, 289);
        Gen3Constants.tag(trs, "GYM6", 282, 281, 463, 283, 462, 464, 280);
        Gen3Constants.tag(trs, "GYM7", 213, 177, 178, 214, 179, 215, 180);
        Gen3Constants.tag(trs, "GYM8", 297, 323, 392, 400, 322, 296, 401, 324);
        Gen3Constants.tag(trs, 414, "GYM1");
        Gen3Constants.tag(trs, 415, "GYM2");
        Gen3Constants.tag(trs, 416, "GYM3");
        Gen3Constants.tag(trs, 417, "GYM4");
        Gen3Constants.tag(trs, 418, "GYM5");
        Gen3Constants.tag(trs, 420, "GYM6");
        Gen3Constants.tag(trs, 419, "GYM7");
        Gen3Constants.tag(trs, 350, "GYM8");
        Gen3Constants.tag(trs, 348, "GIO1");
        Gen3Constants.tag(trs, 349, "GIO2");
        Gen3Constants.tag(trs, 410, "ELITE1-1");
        Gen3Constants.tag(trs, 411, "ELITE2-1");
        Gen3Constants.tag(trs, 412, "ELITE3-1");
        Gen3Constants.tag(trs, 413, "ELITE4-1");
        Gen3Constants.tag(trs, 735, "ELITE1-2");
        Gen3Constants.tag(trs, 736, "ELITE2-2");
        Gen3Constants.tag(trs, 737, "ELITE3-2");
        Gen3Constants.tag(trs, 738, "ELITE4-2");
        Gen3Constants.tag(trs, 328, "RIVAL1-0");
        Gen3Constants.tag(trs, 326, "RIVAL1-1");
        Gen3Constants.tag(trs, 327, "RIVAL1-2");
        Gen3Constants.tag(trs, 331, "RIVAL2-0");
        Gen3Constants.tag(trs, 329, "RIVAL2-1");
        Gen3Constants.tag(trs, 330, "RIVAL2-2");
        Gen3Constants.tag(trs, 334, "RIVAL3-0");
        Gen3Constants.tag(trs, 332, "RIVAL3-1");
        Gen3Constants.tag(trs, 333, "RIVAL3-2");
        Gen3Constants.tag(trs, 428, "RIVAL4-0");
        Gen3Constants.tag(trs, 426, "RIVAL4-1");
        Gen3Constants.tag(trs, 427, "RIVAL4-2");
        Gen3Constants.tag(trs, 431, "RIVAL5-0");
        Gen3Constants.tag(trs, 429, "RIVAL5-1");
        Gen3Constants.tag(trs, 430, "RIVAL5-2");
        Gen3Constants.tag(trs, 434, "RIVAL6-0");
        Gen3Constants.tag(trs, 432, "RIVAL6-1");
        Gen3Constants.tag(trs, 433, "RIVAL6-2");
        Gen3Constants.tag(trs, 437, "RIVAL7-0");
        Gen3Constants.tag(trs, 435, "RIVAL7-1");
        Gen3Constants.tag(trs, 436, "RIVAL7-2");
        Gen3Constants.tag(trs, 440, "RIVAL8-0");
        Gen3Constants.tag(trs, 438, "RIVAL8-1");
        Gen3Constants.tag(trs, 439, "RIVAL8-2");
        Gen3Constants.tag(trs, 741, "RIVAL9-0");
        Gen3Constants.tag(trs, 739, "RIVAL9-1");
        Gen3Constants.tag(trs, 740, "RIVAL9-2");
    }

    private static void tag(List<Trainer> trainers, int trainerNum, String tag) {
        trainers.get((int)(trainerNum - 1)).tag = tag;
    }

    private static void tag(List<Trainer> allTrainers, String tag, int ... numbers) {
        for (int num : numbers) {
            allTrainers.get((int)(num - 1)).tag = tag;
        }
    }

    static {
        Gen3Constants.setupAllowedItems();
    }
}

