/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.constants;

import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.Type;
import java.util.Arrays;
import java.util.List;

public class Gen2Constants {
    public static final int vietCrystalCheckOffset = 99;
    public static final byte vietCrystalCheckValue = -11;
    public static final String vietCrystalROMName = "Pokemon VietCrystal";
    public static final int pokemonCount = 251;
    public static final int moveCount = 251;
    public static final int baseStatsEntrySize = 32;
    public static final Type[] typeTable = Gen2Constants.constructTypeTable();
    public static final int bsHPOffset = 1;
    public static final int bsAttackOffset = 2;
    public static final int bsDefenseOffset = 3;
    public static final int bsSpeedOffset = 4;
    public static final int bsSpAtkOffset = 5;
    public static final int bsSpDefOffset = 6;
    public static final int bsPrimaryTypeOffset = 7;
    public static final int bsSecondaryTypeOffset = 8;
    public static final int bsCatchRateOffset = 9;
    public static final int bsCommonHeldItemOffset = 11;
    public static final int bsRareHeldItemOffset = 12;
    public static final int bsPicDimensionsOffset = 17;
    public static final int bsGrowthCurveOffset = 22;
    public static final int bsTMHMCompatOffset = 24;
    public static final int bsMTCompatOffset = 31;
    public static final String[] starterNames = new String[]{"CYNDAQUIL", "TOTODILE", "CHIKORITA"};
    public static final int fishingGroupCount = 12;
    public static final int pokesPerFishingGroup = 11;
    public static final int fishingGroupEntryLength = 3;
    public static final int timeSpecificFishingGroupCount = 11;
    public static final int pokesPerTSFishingGroup = 4;
    public static final int landEncounterSlots = 7;
    public static final int seaEncounterSlots = 3;
    public static final int oddEggPokemonCount = 14;
    public static final int unownIndex = 201;
    public static final int slowpokeIndex = 79;
    public static final int seadraIndex = 117;
    public static final int poliwhirlIndex = 61;
    public static final int tmCount = 50;
    public static final int hmCount = 7;
    public static final String mtMenuCancelString = "CANCEL";
    public static final byte mtMenuInitByte = -128;
    public static final int maxTrainerNameLength = 17;
    public static final int fleeingSetTwoOffset = 14;
    public static final int fleeingSetThreeOffset = 23;
    public static final int mapGroupCount = 26;
    public static final int mapsInLastGroup = 11;
    public static final List<Integer> requiredFieldTMs = Arrays.asList(4, 20, 22, 26, 28, 34, 35, 39, 40, 43, 44, 46);
    public static final List<Integer> fieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100, 250, 127, 249, 29, 230);
    public static final List<Integer> earlyRequiredHMMoves = Arrays.asList(15);
    public static final List<Integer> bannedLevelupMoves = Arrays.asList(168);
    public static final List<Integer> brokenMoves = Arrays.asList(49, 82, 32, 90, 12);
    public static final int tmBlockOneIndex = 191;
    public static final int tmBlockOneSize = 4;
    public static final int tmBlockTwoIndex = 196;
    public static final int tmBlockTwoSize = 24;
    public static final int tmBlockThreeIndex = 221;
    public static final int tmBlockThreeSize = 22;
    public static final int luckyEggIndex = 126;
    public static ItemList allowedItems;
    public static ItemList nonBadItems;

    private static Type[] constructTypeTable() {
        Type[] table = new Type[256];
        table[0] = Type.NORMAL;
        table[1] = Type.FIGHTING;
        table[2] = Type.FLYING;
        table[3] = Type.POISON;
        table[4] = Type.GROUND;
        table[5] = Type.ROCK;
        table[7] = Type.BUG;
        table[8] = Type.GHOST;
        table[9] = Type.STEEL;
        table[20] = Type.FIRE;
        table[21] = Type.WATER;
        table[22] = Type.GRASS;
        table[23] = Type.ELECTRIC;
        table[24] = Type.PSYCHIC;
        table[25] = Type.ICE;
        table[26] = Type.DRAGON;
        table[27] = Type.DARK;
        return table;
    }

    public static byte typeToByte(Type type) {
        if (type == null) {
            return 19;
        }
        switch (type) {
            case NORMAL: {
                return 0;
            }
            case FIGHTING: {
                return 1;
            }
            case FLYING: {
                return 2;
            }
            case POISON: {
                return 3;
            }
            case GROUND: {
                return 4;
            }
            case ROCK: {
                return 5;
            }
            case BUG: {
                return 7;
            }
            case GHOST: {
                return 8;
            }
            case FIRE: {
                return 20;
            }
            case WATER: {
                return 21;
            }
            case GRASS: {
                return 22;
            }
            case ELECTRIC: {
                return 23;
            }
            case PSYCHIC: {
                return 24;
            }
            case ICE: {
                return 25;
            }
            case DRAGON: {
                return 26;
            }
            case STEEL: {
                return 9;
            }
            case DARK: {
                return 27;
            }
        }
        return 0;
    }

    private static void setupAllowedItems() {
        allowedItems = new ItemList(249);
        allowedItems.banSingles(6, 54, 55, 58, 59, 61, 115, 116, 133, 134, 175, 178);
        allowedItems.banRange(66, 6);
        allowedItems.banRange(127, 4);
        allowedItems.banRange(243, 7);
        allowedItems.banSingles(7, 25, 45, 50, 56, 90, 100, 120, 135, 136, 137);
        allowedItems.banSingles(141, 142, 145, 147, 148, 149, 153, 154, 155, 162, 171);
        allowedItems.banSingles(176, 179, 190, 220, 195);
        allowedItems.tmRange(191, 4);
        allowedItems.tmRange(196, 24);
        allowedItems.tmRange(221, 22);
        nonBadItems = allowedItems.copy();
        nonBadItems.banSingles(30, 35, 60, 75, 85, 89, 97, 99, 101, 105, 118, 158, 163, 173, 180);
        nonBadItems.banRange(92, 2);
        nonBadItems.banRange(167, 2);
        nonBadItems.banRange(181, 9);
    }

    public static void universalTrainerTags(List<Trainer> allTrainers) {
        Gen2Constants.tbc(allTrainers, 1, 0, "GYM1");
        Gen2Constants.tbc(allTrainers, 3, 0, "GYM2");
        Gen2Constants.tbc(allTrainers, 2, 0, "GYM3");
        Gen2Constants.tbc(allTrainers, 4, 0, "GYM4");
        Gen2Constants.tbc(allTrainers, 7, 0, "GYM5");
        Gen2Constants.tbc(allTrainers, 6, 0, "GYM6");
        Gen2Constants.tbc(allTrainers, 5, 0, "GYM7");
        Gen2Constants.tbc(allTrainers, 8, 0, "GYM8");
        Gen2Constants.tbc(allTrainers, 17, 0, "GYM9");
        Gen2Constants.tbc(allTrainers, 18, 0, "GYM10");
        Gen2Constants.tbc(allTrainers, 19, 0, "GYM11");
        Gen2Constants.tbc(allTrainers, 21, 0, "GYM12");
        Gen2Constants.tbc(allTrainers, 26, 0, "GYM13");
        Gen2Constants.tbc(allTrainers, 35, 0, "GYM14");
        Gen2Constants.tbc(allTrainers, 46, 0, "GYM15");
        Gen2Constants.tbc(allTrainers, 64, 0, "GYM16");
        Gen2Constants.tbc(allTrainers, 11, 0, "ELITE1");
        Gen2Constants.tbc(allTrainers, 15, 0, "ELITE2");
        Gen2Constants.tbc(allTrainers, 13, 0, "ELITE3");
        Gen2Constants.tbc(allTrainers, 14, 0, "ELITE4");
        Gen2Constants.tbc(allTrainers, 16, 0, "CHAMPION");
        Gen2Constants.tbc(allTrainers, 63, 0, "UBER");
        Gen2Constants.tbc(allTrainers, 9, 0, "RIVAL1-1");
        Gen2Constants.tbc(allTrainers, 9, 1, "RIVAL1-2");
        Gen2Constants.tbc(allTrainers, 9, 2, "RIVAL1-0");
        Gen2Constants.tbc(allTrainers, 9, 3, "RIVAL2-1");
        Gen2Constants.tbc(allTrainers, 9, 4, "RIVAL2-2");
        Gen2Constants.tbc(allTrainers, 9, 5, "RIVAL2-0");
        Gen2Constants.tbc(allTrainers, 9, 6, "RIVAL3-1");
        Gen2Constants.tbc(allTrainers, 9, 7, "RIVAL3-2");
        Gen2Constants.tbc(allTrainers, 9, 8, "RIVAL3-0");
        Gen2Constants.tbc(allTrainers, 9, 9, "RIVAL4-1");
        Gen2Constants.tbc(allTrainers, 9, 10, "RIVAL4-2");
        Gen2Constants.tbc(allTrainers, 9, 11, "RIVAL4-0");
        Gen2Constants.tbc(allTrainers, 9, 12, "RIVAL5-1");
        Gen2Constants.tbc(allTrainers, 9, 13, "RIVAL5-2");
        Gen2Constants.tbc(allTrainers, 9, 14, "RIVAL5-0");
        Gen2Constants.tbc(allTrainers, 42, 0, "RIVAL6-1");
        Gen2Constants.tbc(allTrainers, 42, 1, "RIVAL6-2");
        Gen2Constants.tbc(allTrainers, 42, 2, "RIVAL6-0");
        Gen2Constants.tbc(allTrainers, 42, 3, "RIVAL7-1");
        Gen2Constants.tbc(allTrainers, 42, 4, "RIVAL7-2");
        Gen2Constants.tbc(allTrainers, 42, 5, "RIVAL7-0");
        Gen2Constants.tbc(allTrainers, 55, 0, "THEMED:ARIANA");
        Gen2Constants.tbc(allTrainers, 55, 1, "THEMED:ARIANA");
        Gen2Constants.tbc(allTrainers, 51, 2, "THEMED:PETREL");
        Gen2Constants.tbc(allTrainers, 51, 3, "THEMED:PETREL");
        Gen2Constants.tbc(allTrainers, 51, 1, "THEMED:PROTON");
        Gen2Constants.tbc(allTrainers, 31, 0, "THEMED:PROTON");
        Gen2Constants.tbc(allTrainers, 56, 0, "THEMED:SPROUTTOWER");
        Gen2Constants.tbc(allTrainers, 56, 1, "THEMED:SPROUTTOWER");
        Gen2Constants.tbc(allTrainers, 56, 2, "THEMED:SPROUTTOWER");
        Gen2Constants.tbc(allTrainers, 56, 3, "THEMED:SPROUTTOWER");
        Gen2Constants.tbc(allTrainers, 56, 6, "THEMED:SPROUTTOWER");
        Gen2Constants.tbc(allTrainers, 56, 7, "THEMED:SPROUTTOWER");
        Gen2Constants.tbc(allTrainers, 56, 8, "THEMED:SPROUTTOWER");
    }

    public static void goldSilverTags(List<Trainer> allTrainers) {
        Gen2Constants.tbc(allTrainers, 24, 0, "GYM1");
        Gen2Constants.tbc(allTrainers, 24, 1, "GYM1");
        Gen2Constants.tbc(allTrainers, 36, 4, "GYM2");
        Gen2Constants.tbc(allTrainers, 36, 5, "GYM2");
        Gen2Constants.tbc(allTrainers, 36, 6, "GYM2");
        Gen2Constants.tbc(allTrainers, 61, 0, "GYM2");
        Gen2Constants.tbc(allTrainers, 61, 3, "GYM2");
        Gen2Constants.tbc(allTrainers, 25, 0, "GYM3");
        Gen2Constants.tbc(allTrainers, 25, 1, "GYM3");
        Gen2Constants.tbc(allTrainers, 29, 0, "GYM3");
        Gen2Constants.tbc(allTrainers, 29, 1, "GYM3");
        Gen2Constants.tbc(allTrainers, 56, 4, "GYM4");
        Gen2Constants.tbc(allTrainers, 56, 5, "GYM4");
        Gen2Constants.tbc(allTrainers, 57, 0, "GYM4");
        Gen2Constants.tbc(allTrainers, 57, 1, "GYM4");
        Gen2Constants.tbc(allTrainers, 50, 1, "GYM5");
        Gen2Constants.tbc(allTrainers, 50, 3, "GYM5");
        Gen2Constants.tbc(allTrainers, 50, 4, "GYM5");
        Gen2Constants.tbc(allTrainers, 50, 6, "GYM5");
        Gen2Constants.tbc(allTrainers, 58, 0, "GYM7");
        Gen2Constants.tbc(allTrainers, 58, 1, "GYM7");
        Gen2Constants.tbc(allTrainers, 58, 2, "GYM7");
        Gen2Constants.tbc(allTrainers, 33, 0, "GYM7");
        Gen2Constants.tbc(allTrainers, 33, 1, "GYM7");
        Gen2Constants.tbc(allTrainers, 27, 2, "GYM8");
        Gen2Constants.tbc(allTrainers, 27, 4, "GYM8");
        Gen2Constants.tbc(allTrainers, 27, 3, "GYM8");
        Gen2Constants.tbc(allTrainers, 28, 2, "GYM8");
        Gen2Constants.tbc(allTrainers, 28, 3, "GYM8");
        Gen2Constants.tbc(allTrainers, 54, 17, "GYM9");
        Gen2Constants.tbc(allTrainers, 38, 20, "GYM10");
        Gen2Constants.tbc(allTrainers, 39, 17, "GYM10");
        Gen2Constants.tbc(allTrainers, 39, 18, "GYM10");
        Gen2Constants.tbc(allTrainers, 49, 2, "GYM11");
        Gen2Constants.tbc(allTrainers, 43, 1, "GYM11");
        Gen2Constants.tbc(allTrainers, 32, 2, "GYM11");
        Gen2Constants.tbc(allTrainers, 61, 4, "GYM12");
        Gen2Constants.tbc(allTrainers, 61, 5, "GYM12");
        Gen2Constants.tbc(allTrainers, 25, 8, "GYM12");
        Gen2Constants.tbc(allTrainers, 53, 18, "GYM12");
        Gen2Constants.tbc(allTrainers, 29, 13, "GYM12");
        Gen2Constants.tbc(allTrainers, 25, 2, "GYM13");
        Gen2Constants.tbc(allTrainers, 25, 5, "GYM13");
        Gen2Constants.tbc(allTrainers, 53, 4, "GYM13");
        Gen2Constants.tbc(allTrainers, 54, 4, "GYM13");
        Gen2Constants.tbc(allTrainers, 57, 5, "GYM14");
        Gen2Constants.tbc(allTrainers, 57, 6, "GYM14");
        Gen2Constants.tbc(allTrainers, 52, 1, "GYM14");
        Gen2Constants.tbc(allTrainers, 52, 10, "GYM14");
    }

    public static void crystalTags(List<Trainer> allTrainers) {
        Gen2Constants.tbc(allTrainers, 24, 0, "GYM1");
        Gen2Constants.tbc(allTrainers, 24, 1, "GYM1");
        Gen2Constants.tbc(allTrainers, 36, 4, "GYM2");
        Gen2Constants.tbc(allTrainers, 36, 5, "GYM2");
        Gen2Constants.tbc(allTrainers, 36, 6, "GYM2");
        Gen2Constants.tbc(allTrainers, 61, 0, "GYM2");
        Gen2Constants.tbc(allTrainers, 61, 3, "GYM2");
        Gen2Constants.tbc(allTrainers, 25, 0, "GYM3");
        Gen2Constants.tbc(allTrainers, 25, 1, "GYM3");
        Gen2Constants.tbc(allTrainers, 29, 0, "GYM3");
        Gen2Constants.tbc(allTrainers, 29, 1, "GYM3");
        Gen2Constants.tbc(allTrainers, 56, 4, "GYM4");
        Gen2Constants.tbc(allTrainers, 56, 5, "GYM4");
        Gen2Constants.tbc(allTrainers, 57, 0, "GYM4");
        Gen2Constants.tbc(allTrainers, 57, 1, "GYM4");
        Gen2Constants.tbc(allTrainers, 50, 1, "GYM5");
        Gen2Constants.tbc(allTrainers, 50, 3, "GYM5");
        Gen2Constants.tbc(allTrainers, 50, 4, "GYM5");
        Gen2Constants.tbc(allTrainers, 50, 6, "GYM5");
        Gen2Constants.tbc(allTrainers, 58, 0, "GYM7");
        Gen2Constants.tbc(allTrainers, 58, 1, "GYM7");
        Gen2Constants.tbc(allTrainers, 58, 2, "GYM7");
        Gen2Constants.tbc(allTrainers, 33, 0, "GYM7");
        Gen2Constants.tbc(allTrainers, 33, 1, "GYM7");
        Gen2Constants.tbc(allTrainers, 27, 2, "GYM8");
        Gen2Constants.tbc(allTrainers, 27, 4, "GYM8");
        Gen2Constants.tbc(allTrainers, 27, 3, "GYM8");
        Gen2Constants.tbc(allTrainers, 28, 2, "GYM8");
        Gen2Constants.tbc(allTrainers, 28, 3, "GYM8");
        Gen2Constants.tbc(allTrainers, 54, 17, "GYM9");
        Gen2Constants.tbc(allTrainers, 38, 20, "GYM10");
        Gen2Constants.tbc(allTrainers, 39, 17, "GYM10");
        Gen2Constants.tbc(allTrainers, 39, 18, "GYM10");
        Gen2Constants.tbc(allTrainers, 49, 2, "GYM11");
        Gen2Constants.tbc(allTrainers, 43, 1, "GYM11");
        Gen2Constants.tbc(allTrainers, 32, 2, "GYM11");
        Gen2Constants.tbc(allTrainers, 61, 4, "GYM12");
        Gen2Constants.tbc(allTrainers, 61, 5, "GYM12");
        Gen2Constants.tbc(allTrainers, 25, 8, "GYM12");
        Gen2Constants.tbc(allTrainers, 53, 18, "GYM12");
        Gen2Constants.tbc(allTrainers, 29, 13, "GYM12");
        Gen2Constants.tbc(allTrainers, 25, 2, "GYM13");
        Gen2Constants.tbc(allTrainers, 25, 5, "GYM13");
        Gen2Constants.tbc(allTrainers, 53, 4, "GYM13");
        Gen2Constants.tbc(allTrainers, 54, 4, "GYM13");
        Gen2Constants.tbc(allTrainers, 57, 5, "GYM14");
        Gen2Constants.tbc(allTrainers, 57, 6, "GYM14");
        Gen2Constants.tbc(allTrainers, 52, 1, "GYM14");
        Gen2Constants.tbc(allTrainers, 52, 10, "GYM14");
    }

    private static void tbc(List<Trainer> allTrainers, int classNum, int number, String tag) {
        int currnum = -1;
        for (Trainer t : allTrainers) {
            if (t.trainerclass != classNum - 1 || ++currnum != number) continue;
            t.tag = tag;
            return;
        }
    }

    static {
        Gen2Constants.setupAllowedItems();
    }
}

