/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom.constants;

import com.dabomstew.pkrandom.pokemon.ItemList;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.Type;
import java.util.Arrays;
import java.util.List;

public class Gen1Constants {
    public static final int baseStatsEntrySize = 28;
    public static final int bsHPOffset = 1;
    public static final int bsAttackOffset = 2;
    public static final int bsDefenseOffset = 3;
    public static final int bsSpeedOffset = 4;
    public static final int bsSpecialOffset = 5;
    public static final int bsPrimaryTypeOffset = 6;
    public static final int bsSecondaryTypeOffset = 7;
    public static final int bsCatchRateOffset = 8;
    public static final int bsExpYieldOffset = 9;
    public static final int bsFrontSpriteOffset = 11;
    public static final int bsLevel1MovesOffset = 15;
    public static final int bsGrowthCurveOffset = 19;
    public static final int bsTMHMCompatOffset = 20;
    public static final int mewIndex = 151;
    public static final int marowakIndex = 105;
    public static final int encounterTableEnd = 65535;
    public static final int encounterTableSize = 10;
    public static final int yellowSuperRodTableSize = 4;
    public static final int trainerClassCount = 47;
    public static final int champRivalOffsetFromGymLeaderMoves = 68;
    public static final int tmCount = 50;
    public static final int hmCount = 5;
    public static final int[] gymLeaderTMs = new int[]{34, 11, 24, 21, 6, 46, 38, 27};
    public static final int[] tclassesCounts = new int[]{21, 47};
    public static final List<Integer> singularTrainers = Arrays.asList(28, 32, 33, 34, 35, 36, 37, 38, 39, 43, 45, 46);
    public static final List<Integer> bannedMovesWithXAccBanned = Arrays.asList(49, 82, 147);
    public static final List<Integer> bannedMovesWithoutXAccBanned = Arrays.asList(49, 82, 32, 90, 12, 147);
    public static final List<Integer> fieldMoves = Arrays.asList(15, 19, 57, 70, 148, 91, 100);
    public static final List<Integer> earlyRequiredHMs = Arrays.asList(15);
    public static final int hmsStartIndex = 196;
    public static final int tmsStartIndex = 201;
    public static final List<Integer> requiredFieldTMs = Arrays.asList(3, 4, 8, 10, 12, 14, 16, 19, 20, 22, 25, 26, 30, 40, 43, 44, 45, 47);
    public static final int towerMapsStartIndex = 144;
    public static final int towerMapsEndIndex = 148;
    public static final Type[] typeTable = Gen1Constants.constructTypeTable();
    public static final ItemList allowedItems = Gen1Constants.setupAllowedItems();

    private static Type[] constructTypeTable() {
        Type[] table = new Type[32];
        table[0] = Type.NORMAL;
        table[1] = Type.FIGHTING;
        table[2] = Type.FLYING;
        table[3] = Type.POISON;
        table[4] = Type.GROUND;
        table[5] = Type.ROCK;
        table[7] = Type.BUG;
        table[8] = Type.GHOST;
        table[20] = Type.FIRE;
        table[21] = Type.WATER;
        table[22] = Type.GRASS;
        table[23] = Type.ELECTRIC;
        table[24] = Type.PSYCHIC;
        table[25] = Type.ICE;
        table[26] = Type.DRAGON;
        return table;
    }

    public static byte typeToByte(Type type) {
        for (int i = 0; i < typeTable.length; ++i) {
            if (typeTable[i] != type) continue;
            return (byte)i;
        }
        return 0;
    }

    private static ItemList setupAllowedItems() {
        ItemList allowedItems = new ItemList(250);
        allowedItems.banSingles(5, 6, 7, 8, 9, 31, 48, 50, 59, 63, 64);
        allowedItems.banRange(21, 8);
        allowedItems.banRange(41, 5);
        allowedItems.banRange(69, 10);
        allowedItems.banRange(84, 112);
        allowedItems.banRange(196, 5);
        allowedItems.tmRange(201, 50);
        return allowedItems;
    }

    public static void tagTrainersUniversal(List<Trainer> trs) {
        Gen1Constants.tbc(trs, 34, 0, "GYM1");
        Gen1Constants.tbc(trs, 35, 0, "GYM2");
        Gen1Constants.tbc(trs, 36, 0, "GYM3");
        Gen1Constants.tbc(trs, 37, 0, "GYM4");
        Gen1Constants.tbc(trs, 38, 0, "GYM5");
        Gen1Constants.tbc(trs, 40, 0, "GYM6");
        Gen1Constants.tbc(trs, 39, 0, "GYM7");
        Gen1Constants.tbc(trs, 29, 2, "GYM8");
        Gen1Constants.tbc(trs, 29, 0, "GIO1");
        Gen1Constants.tbc(trs, 29, 1, "GIO2");
        Gen1Constants.tbc(trs, 44, 0, "ELITE1");
        Gen1Constants.tbc(trs, 33, 0, "ELITE2");
        Gen1Constants.tbc(trs, 46, 0, "ELITE3");
        Gen1Constants.tbc(trs, 47, 0, "ELITE4");
    }

    public static void tagTrainersRB(List<Trainer> trs) {
        Gen1Constants.tbc(trs, 25, 0, "RIVAL1-0");
        Gen1Constants.tbc(trs, 25, 1, "RIVAL1-1");
        Gen1Constants.tbc(trs, 25, 2, "RIVAL1-2");
        Gen1Constants.tbc(trs, 25, 3, "RIVAL2-0");
        Gen1Constants.tbc(trs, 25, 4, "RIVAL2-1");
        Gen1Constants.tbc(trs, 25, 5, "RIVAL2-2");
        Gen1Constants.tbc(trs, 25, 6, "RIVAL3-0");
        Gen1Constants.tbc(trs, 25, 7, "RIVAL3-1");
        Gen1Constants.tbc(trs, 25, 8, "RIVAL3-2");
        Gen1Constants.tbc(trs, 42, 0, "RIVAL4-0");
        Gen1Constants.tbc(trs, 42, 1, "RIVAL4-1");
        Gen1Constants.tbc(trs, 42, 2, "RIVAL4-2");
        Gen1Constants.tbc(trs, 42, 3, "RIVAL5-0");
        Gen1Constants.tbc(trs, 42, 4, "RIVAL5-1");
        Gen1Constants.tbc(trs, 42, 5, "RIVAL5-2");
        Gen1Constants.tbc(trs, 42, 6, "RIVAL6-0");
        Gen1Constants.tbc(trs, 42, 7, "RIVAL6-1");
        Gen1Constants.tbc(trs, 42, 8, "RIVAL6-2");
        Gen1Constants.tbc(trs, 42, 9, "RIVAL7-0");
        Gen1Constants.tbc(trs, 42, 10, "RIVAL7-1");
        Gen1Constants.tbc(trs, 42, 11, "RIVAL7-2");
        Gen1Constants.tbc(trs, 43, 0, "RIVAL8-0");
        Gen1Constants.tbc(trs, 43, 1, "RIVAL8-1");
        Gen1Constants.tbc(trs, 43, 2, "RIVAL8-2");
        Gen1Constants.tbc(trs, 5, 0, "GYM1");
        Gen1Constants.tbc(trs, 15, 0, "GYM2");
        Gen1Constants.tbc(trs, 6, 0, "GYM2");
        Gen1Constants.tbc(trs, 4, 7, "GYM3");
        Gen1Constants.tbc(trs, 20, 0, "GYM3");
        Gen1Constants.tbc(trs, 41, 2, "GYM3");
        Gen1Constants.tbc(trs, 3, 16, "GYM4");
        Gen1Constants.tbc(trs, 3, 17, "GYM4");
        Gen1Constants.tbc(trs, 6, 10, "GYM4");
        Gen1Constants.tbc(trs, 18, 0, "GYM4");
        Gen1Constants.tbc(trs, 18, 1, "GYM4");
        Gen1Constants.tbc(trs, 18, 2, "GYM4");
        Gen1Constants.tbc(trs, 32, 0, "GYM4");
        Gen1Constants.tbc(trs, 21, 2, "GYM5");
        Gen1Constants.tbc(trs, 21, 3, "GYM5");
        Gen1Constants.tbc(trs, 21, 6, "GYM5");
        Gen1Constants.tbc(trs, 21, 7, "GYM5");
        Gen1Constants.tbc(trs, 22, 0, "GYM5");
        Gen1Constants.tbc(trs, 22, 1, "GYM5");
        Gen1Constants.tbc(trs, 19, 0, "GYM6");
        Gen1Constants.tbc(trs, 19, 1, "GYM6");
        Gen1Constants.tbc(trs, 19, 2, "GYM6");
        Gen1Constants.tbc(trs, 19, 3, "GYM6");
        Gen1Constants.tbc(trs, 45, 21, "GYM6");
        Gen1Constants.tbc(trs, 45, 22, "GYM6");
        Gen1Constants.tbc(trs, 45, 23, "GYM6");
        Gen1Constants.tbc(trs, 8, 8, "GYM7");
        Gen1Constants.tbc(trs, 8, 9, "GYM7");
        Gen1Constants.tbc(trs, 8, 10, "GYM7");
        Gen1Constants.tbc(trs, 8, 11, "GYM7");
        Gen1Constants.tbc(trs, 11, 3, "GYM7");
        Gen1Constants.tbc(trs, 11, 4, "GYM7");
        Gen1Constants.tbc(trs, 11, 5, "GYM7");
        Gen1Constants.tbc(trs, 22, 2, "GYM8");
        Gen1Constants.tbc(trs, 22, 3, "GYM8");
        Gen1Constants.tbc(trs, 24, 5, "GYM8");
        Gen1Constants.tbc(trs, 24, 6, "GYM8");
        Gen1Constants.tbc(trs, 24, 7, "GYM8");
        Gen1Constants.tbc(trs, 31, 0, "GYM8");
        Gen1Constants.tbc(trs, 31, 8, "GYM8");
        Gen1Constants.tbc(trs, 31, 9, "GYM8");
    }

    public static void tagTrainersYellow(List<Trainer> trs) {
        Gen1Constants.tbc(trs, 25, 0, "IRIVAL");
        Gen1Constants.tbc(trs, 25, 1, "RIVAL1-0");
        Gen1Constants.tbc(trs, 25, 2, "RIVAL2-0");
        Gen1Constants.tbc(trs, 42, 0, "RIVAL3-0");
        Gen1Constants.tbc(trs, 42, 1, "RIVAL4-0");
        Gen1Constants.tbc(trs, 42, 2, "RIVAL4-1");
        Gen1Constants.tbc(trs, 42, 3, "RIVAL4-2");
        Gen1Constants.tbc(trs, 42, 4, "RIVAL5-0");
        Gen1Constants.tbc(trs, 42, 5, "RIVAL5-1");
        Gen1Constants.tbc(trs, 42, 6, "RIVAL5-2");
        Gen1Constants.tbc(trs, 42, 7, "RIVAL6-0");
        Gen1Constants.tbc(trs, 42, 8, "RIVAL6-1");
        Gen1Constants.tbc(trs, 42, 9, "RIVAL6-2");
        Gen1Constants.tbc(trs, 43, 0, "RIVAL7-0");
        Gen1Constants.tbc(trs, 43, 1, "RIVAL7-1");
        Gen1Constants.tbc(trs, 43, 2, "RIVAL7-2");
        Gen1Constants.tbc(trs, 30, 41, "THEMED:JESSIE&JAMES");
        Gen1Constants.tbc(trs, 30, 42, "THEMED:JESSIE&JAMES");
        Gen1Constants.tbc(trs, 30, 43, "THEMED:JESSIE&JAMES");
        Gen1Constants.tbc(trs, 30, 44, "THEMED:JESSIE&JAMES");
        Gen1Constants.tbc(trs, 5, 0, "GYM1");
        Gen1Constants.tbc(trs, 6, 0, "GYM2");
        Gen1Constants.tbc(trs, 15, 0, "GYM2");
        Gen1Constants.tbc(trs, 4, 7, "GYM3");
        Gen1Constants.tbc(trs, 20, 0, "GYM3");
        Gen1Constants.tbc(trs, 41, 2, "GYM3");
        Gen1Constants.tbc(trs, 3, 16, "GYM4");
        Gen1Constants.tbc(trs, 3, 17, "GYM4");
        Gen1Constants.tbc(trs, 6, 10, "GYM4");
        Gen1Constants.tbc(trs, 18, 0, "GYM4");
        Gen1Constants.tbc(trs, 18, 1, "GYM4");
        Gen1Constants.tbc(trs, 18, 2, "GYM4");
        Gen1Constants.tbc(trs, 32, 0, "GYM4");
        Gen1Constants.tbc(trs, 21, 2, "GYM5");
        Gen1Constants.tbc(trs, 21, 3, "GYM5");
        Gen1Constants.tbc(trs, 21, 6, "GYM5");
        Gen1Constants.tbc(trs, 21, 7, "GYM5");
        Gen1Constants.tbc(trs, 22, 0, "GYM5");
        Gen1Constants.tbc(trs, 22, 1, "GYM5");
        Gen1Constants.tbc(trs, 19, 0, "GYM6");
        Gen1Constants.tbc(trs, 19, 1, "GYM6");
        Gen1Constants.tbc(trs, 19, 2, "GYM6");
        Gen1Constants.tbc(trs, 19, 3, "GYM6");
        Gen1Constants.tbc(trs, 45, 21, "GYM6");
        Gen1Constants.tbc(trs, 45, 22, "GYM6");
        Gen1Constants.tbc(trs, 45, 23, "GYM6");
        Gen1Constants.tbc(trs, 8, 8, "GYM7");
        Gen1Constants.tbc(trs, 8, 9, "GYM7");
        Gen1Constants.tbc(trs, 8, 10, "GYM7");
        Gen1Constants.tbc(trs, 8, 11, "GYM7");
        Gen1Constants.tbc(trs, 11, 3, "GYM7");
        Gen1Constants.tbc(trs, 11, 4, "GYM7");
        Gen1Constants.tbc(trs, 11, 5, "GYM7");
        Gen1Constants.tbc(trs, 22, 2, "GYM8");
        Gen1Constants.tbc(trs, 22, 3, "GYM8");
        Gen1Constants.tbc(trs, 24, 5, "GYM8");
        Gen1Constants.tbc(trs, 24, 6, "GYM8");
        Gen1Constants.tbc(trs, 24, 7, "GYM8");
        Gen1Constants.tbc(trs, 31, 0, "GYM8");
        Gen1Constants.tbc(trs, 31, 8, "GYM8");
        Gen1Constants.tbc(trs, 31, 9, "GYM8");
    }

    private static void tbc(List<Trainer> allTrainers, int classNum, int number, String tag) {
        int currnum = -1;
        for (Trainer t : allTrainers) {
            if (t.trainerclass != classNum || ++currnum != number) continue;
            t.tag = tag;
            return;
        }
    }
}

