/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.exceptions.InvalidSupplementFilesException;
import com.dabomstew.pkrandom.gui.RandomizerGUI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import javax.xml.bind.DatatypeConverter;

public class Utils {
    public static void validateRomFile(File fh) throws InvalidROMException {
        try {
            FileInputStream fis = new FileInputStream(fh);
            byte[] sig = new byte[10];
            int sigLength = fis.read(sig);
            fis.close();
            if (sigLength < 10) {
                throw new InvalidROMException(InvalidROMException.Type.LENGTH, String.format("%s appears to be a blank or nearly blank file.", fh.getName()));
            }
            if (sig[0] == 80 && sig[1] == 75 && sig[2] == 3 && sig[3] == 4) {
                throw new InvalidROMException(InvalidROMException.Type.ZIP_FILE, String.format("%s is a ZIP archive, not a ROM.", fh.getName()));
            }
            if (sig[0] == 82 && sig[1] == 97 && sig[2] == 114 && sig[3] == 33 && sig[4] == 26 && sig[5] == 7) {
                throw new InvalidROMException(InvalidROMException.Type.RAR_FILE, String.format("%s is a RAR archive, not a ROM.", fh.getName()));
            }
            if (sig[0] == 80 && sig[1] == 65 && sig[2] == 84 && sig[3] == 67 && sig[4] == 72) {
                throw new InvalidROMException(InvalidROMException.Type.IPS_FILE, String.format("%s is a IPS patch, not a ROM.", fh.getName()));
            }
        }
        catch (IOException ex) {
            throw new InvalidROMException(InvalidROMException.Type.UNREADABLE, String.format("Could not read %s from disk.", fh.getName()));
        }
    }

    public static void testForRequiredConfigs() throws FileNotFoundException {
        String[] required;
        for (String filename : required = new String[]{"gameboy_jap.tbl", "rby_english.tbl", "rby_freger.tbl", "rby_espita.tbl", "green_translation.tbl", "gsc_english.tbl", "gsc_freger.tbl", "gsc_espita.tbl", "gba_english.tbl", "gba_jap.tbl", "Generation4.tbl", "Generation5.tbl", "gen1_offsets.ini", "gen2_offsets.ini", "gen3_offsets.ini", "gen4_offsets.ini", "gen5_offsets.ini", "customnames.rncn"}) {
            if (FileFunctions.configExists(filename)) continue;
            throw new FileNotFoundException(filename);
        }
    }

    public static void validatePresetSupplementFiles(String config, CustomNamesSet customNames) throws UnsupportedEncodingException, InvalidSupplementFilesException {
        byte[] data = DatatypeConverter.parseBase64Binary((String)config);
        if (data.length < 45) {
            throw new InvalidSupplementFilesException(InvalidSupplementFilesException.Type.UNKNOWN, "The preset config is too short to be valid");
        }
        ByteBuffer buf = ByteBuffer.allocate(4).put(data, data.length - 8, 4);
        buf.rewind();
        int crc = buf.getInt();
        CRC32 checksum = new CRC32();
        checksum.update(data, 0, data.length - 8);
        if ((int)checksum.getValue() != crc) {
            throw new IllegalArgumentException("Checksum failure.");
        }
        if (customNames == null && !FileFunctions.checkOtherCRC(data, 16, 4, "customnames.rncn", data.length - 4)) {
            throw new InvalidSupplementFilesException(InvalidSupplementFilesException.Type.CUSTOM_NAMES, "Can't use this preset because you have a different set of custom names to the creator.");
        }
    }

    public static File getExecutionLocation() throws UnsupportedEncodingException {
        URL location = RandomizerGUI.class.getProtectionDomain().getCodeSource().getLocation();
        File fh = new File(URLDecoder.decode(location.getFile(), "UTF-8"));
        return fh;
    }

    public static class InvalidROMException
    extends Exception {
        private static final long serialVersionUID = 6568398515886021477L;
        private final Type type;

        public InvalidROMException(Type type, String message) {
            super(message);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public static enum Type {
            LENGTH,
            ZIP_FILE,
            RAR_FILE,
            IPS_FILE,
            UNREADABLE;

        }
    }
}

