/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.MiscTweak;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import javax.xml.bind.DatatypeConverter;

public class SettingsUpdater {
    private byte[] dataBlock;
    private int actualDataLength;

    public String update(int oldVersion, String configString) {
        byte[] data = DatatypeConverter.parseBase64Binary((String)configString);
        this.dataBlock = new byte[200];
        this.actualDataLength = data.length;
        System.arraycopy(data, 0, this.dataBlock, 0, this.actualDataLength);
        if (oldVersion < 102) {
            this.dataBlock[1] = (byte)(this.dataBlock[1] | 0x10);
        }
        if (oldVersion < 110) {
            this.insertExtraByte(15, (byte)20);
        }
        if (oldVersion < 150) {
            this.insertExtraByte(16, (byte)64);
            this.insertExtraByte(17, (byte)4);
            this.actualDataLength += 4;
        }
        if (oldVersion < 160) {
            int firstByte = this.dataBlock[0] & 0xFF;
            int updateMoves = firstByte & 8;
            int laterFields = firstByte & 0x70;
            this.dataBlock[0] = (byte)(firstByte & 0xF | updateMoves << 1 | laterFields << 1);
            int hasBWPatch = (this.dataBlock[2] & 8) >> 3;
            int hasHeldItems = (this.dataBlock[2] & 0x80) >> 7;
            this.dataBlock[2] = (byte)(this.dataBlock[2] & 0x7F);
            if (hasHeldItems > 0) {
                this.dataBlock[3] = (byte)(this.dataBlock[3] | 0x10);
            }
            int wpNoLegendaries = (this.dataBlock[11] & 0x80) >> 7;
            int tpNoEarlyShedinja = (this.dataBlock[13] & 0x10) >> 4;
            int wpCatchRate = (this.dataBlock[13] & 8) >> 3;
            this.dataBlock[11] = (byte)(this.dataBlock[11] & 0x7F | tpNoEarlyShedinja << 7);
            this.insertExtraByte(13, (byte)(wpCatchRate | wpNoLegendaries << 1 | hasHeldItems << 3));
            this.dataBlock[14] = (byte)(this.dataBlock[14] & 7);
            this.insertIntField(19, 0);
            this.insertIntField(23, hasBWPatch);
        }
        if ((this.dataBlock[12] & 0xD) == 0) {
            this.dataBlock[13] = (byte)(this.dataBlock[13] | 4);
        }
        if (oldVersion < 162) {
            this.insertExtraByte(3, (byte)0);
        }
        if (oldVersion < 170) {
            this.insertExtraByte(17, (byte)0);
            this.insertExtraByte(21, (byte)0);
            this.insertExtraByte(22, (byte)1);
            int oldTweaks = FileFunctions.readFullInt(this.dataBlock, 27);
            if ((this.dataBlock[0] & 1) != 0) {
                oldTweaks |= MiscTweak.LOWER_CASE_POKEMON_NAMES.getValue();
            }
            if ((this.dataBlock[0] & 2) != 0) {
                oldTweaks |= MiscTweak.NATIONAL_DEX_AT_START.getValue();
            }
            if ((this.dataBlock[0] & 0x20) != 0) {
                oldTweaks |= MiscTweak.UPDATE_TYPE_EFFECTIVENESS.getValue();
            }
            if ((this.dataBlock[2] & 0x20) != 0) {
                oldTweaks |= MiscTweak.RANDOMIZE_HIDDEN_HOLLOWS.getValue();
            }
            FileFunctions.writeFullInt(this.dataBlock, 27, oldTweaks);
            this.dataBlock[0] = SettingsUpdater.getRemappedByte(this.dataBlock[0], new int[]{2, 3, 4, 6, 7});
            this.dataBlock[2] = SettingsUpdater.getRemappedByte(this.dataBlock[2], new int[]{0, 1, 2, 4, 6, 7});
        }
        if (oldVersion < 171) {
            if ((this.dataBlock[1] & 1) != 0) {
                this.dataBlock[1] = (byte)(this.dataBlock[1] | 2);
            }
            if ((this.dataBlock[3] & 1) != 0) {
                this.dataBlock[0] = (byte)(this.dataBlock[0] | 0x20);
            }
            this.dataBlock[3] = (byte)((this.dataBlock[1] & 0x70) >> 4);
            this.dataBlock[1] = (byte)(this.dataBlock[1] & 0xF | (this.dataBlock[1] & 0x80) >> 3);
            this.insertExtraByte(13, (byte)30);
            this.insertExtraByte(12, (byte)0);
            this.insertExtraByte(20, (byte)0);
            this.insertExtraByte(22, (byte)0);
        }
        if (oldVersion < 172) {
            this.actualDataLength -= 8;
            this.dataBlock[16] = (byte)(this.dataBlock[16] ^ 2);
            this.insertExtraByte(35, (byte)50);
        }
        CRC32 checksum = new CRC32();
        checksum.update(this.dataBlock, 0, this.actualDataLength - 8);
        byte[] crcBuf = ByteBuffer.allocate(4).putInt((int)checksum.getValue()).array();
        System.arraycopy(crcBuf, 0, this.dataBlock, this.actualDataLength - 8, 4);
        byte[] finalConfigString = new byte[this.actualDataLength];
        System.arraycopy(this.dataBlock, 0, finalConfigString, 0, this.actualDataLength);
        return DatatypeConverter.printBase64Binary((byte[])finalConfigString);
    }

    private static byte getRemappedByte(byte old, int[] oldIndexes) {
        int newValue = 0;
        int oldValue = old & 0xFF;
        for (int i = 0; i < oldIndexes.length; ++i) {
            if ((oldValue & 1 << oldIndexes[i]) == 0) continue;
            newValue |= 1 << i;
        }
        return (byte)newValue;
    }

    private void insertIntField(int position, int value) {
        if (this.actualDataLength + 4 > this.dataBlock.length) {
            return;
        }
        for (int j = this.actualDataLength; j > position + 3; --j) {
            this.dataBlock[j] = this.dataBlock[j - 4];
        }
        byte[] valueBuf = ByteBuffer.allocate(4).putInt(value).array();
        System.arraycopy(valueBuf, 0, this.dataBlock, position, 4);
        this.actualDataLength += 4;
    }

    private void insertExtraByte(int position, byte value) {
        if (this.actualDataLength == this.dataBlock.length) {
            return;
        }
        for (int j = this.actualDataLength; j > position; --j) {
            this.dataBlock[j] = this.dataBlock[j - 1];
        }
        this.dataBlock[position] = value;
        ++this.actualDataLength;
    }
}

