/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.SettingsUpdater;
import com.dabomstew.pkrandom.pokemon.GenRestrictions;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.romhandlers.Gen1RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen2RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen3RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen5RomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.CRC32;
import javax.xml.bind.DatatypeConverter;

public class Settings {
    public static final int VERSION = 172;
    public static final int LENGTH_OF_SETTINGS_DATA = 36;
    private CustomNamesSet customNames;
    private String romName;
    private boolean updatedFromOldVersion = false;
    private GenRestrictions currentRestrictions;
    private int currentMiscTweaks;
    private boolean changeImpossibleEvolutions;
    private boolean makeEvolutionsEasier;
    private boolean raceMode;
    private boolean blockBrokenMoves;
    private boolean limitPokemon;
    private BaseStatisticsMod baseStatisticsMod = BaseStatisticsMod.UNCHANGED;
    private boolean standardizeEXPCurves;
    private boolean baseStatsFollowEvolutions;
    private boolean updateBaseStats;
    private AbilitiesMod abilitiesMod = AbilitiesMod.UNCHANGED;
    private boolean allowWonderGuard = true;
    private boolean abilitiesFollowEvolutions;
    private boolean banTrappingAbilities;
    private boolean banNegativeAbilities;
    private StartersMod startersMod = StartersMod.UNCHANGED;
    private int[] customStarters = new int[3];
    private boolean randomizeStartersHeldItems;
    private boolean banBadRandomStarterHeldItems;
    private TypesMod typesMod = TypesMod.UNCHANGED;
    private EvolutionsMod evolutionsMod = EvolutionsMod.UNCHANGED;
    private boolean evosSimilarStrength;
    private boolean evosSameTyping;
    private boolean evosMaxThreeStages;
    private boolean evosForceChange;
    private boolean randomizeMovePowers;
    private boolean randomizeMoveAccuracies;
    private boolean randomizeMovePPs;
    private boolean randomizeMoveTypes;
    private boolean randomizeMoveCategory;
    private boolean updateMoves;
    private boolean updateMovesLegacy;
    private MovesetsMod movesetsMod = MovesetsMod.UNCHANGED;
    private boolean startWithFourMoves;
    private boolean reorderDamagingMoves;
    private boolean movesetsForceGoodDamaging;
    private int movesetsGoodDamagingPercent = 0;
    private TrainersMod trainersMod = TrainersMod.UNCHANGED;
    private boolean rivalCarriesStarterThroughout;
    private boolean trainersUsePokemonOfSimilarStrength;
    private boolean trainersMatchTypingDistribution;
    private boolean trainersBlockLegendaries = true;
    private boolean trainersBlockEarlyWonderGuard = true;
    private boolean randomizeTrainerNames;
    private boolean randomizeTrainerClassNames;
    private boolean trainersForceFullyEvolved;
    private int trainersForceFullyEvolvedLevel = 30;
    private boolean trainersLevelModified;
    private int trainersLevelModifier = 0;
    private WildPokemonMod wildPokemonMod = WildPokemonMod.UNCHANGED;
    private WildPokemonRestrictionMod wildPokemonRestrictionMod = WildPokemonRestrictionMod.NONE;
    private boolean useTimeBasedEncounters;
    private boolean blockWildLegendaries = true;
    private boolean useMinimumCatchRate;
    private int minimumCatchRateLevel = 1;
    private boolean randomizeWildPokemonHeldItems;
    private boolean banBadRandomWildPokemonHeldItems;
    private StaticPokemonMod staticPokemonMod = StaticPokemonMod.UNCHANGED;
    private TMsMod tmsMod = TMsMod.UNCHANGED;
    private boolean tmLevelUpMoveSanity;
    private boolean keepFieldMoveTMs;
    private boolean fullHMCompat;
    private boolean tmsForceGoodDamaging;
    private int tmsGoodDamagingPercent = 0;
    private TMsHMsCompatibilityMod tmsHmsCompatibilityMod = TMsHMsCompatibilityMod.UNCHANGED;
    private MoveTutorMovesMod moveTutorMovesMod = MoveTutorMovesMod.UNCHANGED;
    private boolean tutorLevelUpMoveSanity;
    private boolean keepFieldMoveTutors;
    private boolean tutorsForceGoodDamaging;
    private int tutorsGoodDamagingPercent = 0;
    private MoveTutorsCompatibilityMod moveTutorsCompatibilityMod = MoveTutorsCompatibilityMod.UNCHANGED;
    private InGameTradesMod inGameTradesMod = InGameTradesMod.UNCHANGED;
    private boolean randomizeInGameTradesNicknames;
    private boolean randomizeInGameTradesOTs;
    private boolean randomizeInGameTradesIVs;
    private boolean randomizeInGameTradesItems;
    private FieldItemsMod fieldItemsMod = FieldItemsMod.UNCHANGED;
    private boolean banBadRandomFieldItems;

    public void write(FileOutputStream out) throws IOException {
        out.write(172);
        byte[] settings = this.toString().getBytes("UTF-8");
        out.write(settings.length);
        out.write(settings);
    }

    public static Settings read(FileInputStream in) throws IOException, UnsupportedOperationException {
        int version = in.read();
        if (version > 172) {
            throw new UnsupportedOperationException("Cannot read settings from a newer version of the randomizer.");
        }
        int length = in.read();
        byte[] buffer = FileFunctions.readFullyIntoBuffer(in, length);
        String settings = new String(buffer, "UTF-8");
        boolean oldUpdate = false;
        if (version < 172) {
            oldUpdate = true;
            settings = new SettingsUpdater().update(version, settings);
        }
        Settings settingsObj = Settings.fromString(settings);
        settingsObj.setUpdatedFromOldVersion(oldUpdate);
        return settingsObj;
    }

    public String toString() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(Settings.makeByteSelected(this.changeImpossibleEvolutions, this.updateMoves, this.updateMovesLegacy, this.randomizeTrainerNames, this.randomizeTrainerClassNames, this.makeEvolutionsEasier));
        out.write(Settings.makeByteSelected(this.baseStatsFollowEvolutions, this.baseStatisticsMod == BaseStatisticsMod.RANDOM, this.baseStatisticsMod == BaseStatisticsMod.SHUFFLE, this.baseStatisticsMod == BaseStatisticsMod.UNCHANGED, this.standardizeEXPCurves, this.updateBaseStats));
        out.write(Settings.makeByteSelected(this.typesMod == TypesMod.RANDOM_FOLLOW_EVOLUTIONS, this.typesMod == TypesMod.COMPLETELY_RANDOM, this.typesMod == TypesMod.UNCHANGED, this.raceMode, this.blockBrokenMoves, this.limitPokemon));
        out.write(Settings.makeByteSelected(this.abilitiesMod == AbilitiesMod.UNCHANGED, this.abilitiesMod == AbilitiesMod.RANDOMIZE, this.allowWonderGuard, this.abilitiesFollowEvolutions, this.banTrappingAbilities, this.banNegativeAbilities));
        out.write(Settings.makeByteSelected(this.startersMod == StartersMod.CUSTOM, this.startersMod == StartersMod.COMPLETELY_RANDOM, this.startersMod == StartersMod.UNCHANGED, this.startersMod == StartersMod.RANDOM_WITH_TWO_EVOLUTIONS, this.randomizeStartersHeldItems, this.banBadRandomStarterHeldItems));
        Settings.write2ByteInt(out, this.customStarters[0] - 1);
        Settings.write2ByteInt(out, this.customStarters[1] - 1);
        Settings.write2ByteInt(out, this.customStarters[2] - 1);
        out.write(Settings.makeByteSelected(this.movesetsMod == MovesetsMod.COMPLETELY_RANDOM, this.movesetsMod == MovesetsMod.RANDOM_PREFER_SAME_TYPE, this.movesetsMod == MovesetsMod.UNCHANGED, this.movesetsMod == MovesetsMod.METRONOME_ONLY, this.startWithFourMoves, this.reorderDamagingMoves));
        out.write((this.movesetsForceGoodDamaging ? 128 : 0) | this.movesetsGoodDamagingPercent);
        out.write(Settings.makeByteSelected(this.trainersUsePokemonOfSimilarStrength, this.trainersMod == TrainersMod.RANDOM, this.rivalCarriesStarterThroughout, this.trainersMod == TrainersMod.TYPE_THEMED, this.trainersMatchTypingDistribution, this.trainersMod == TrainersMod.UNCHANGED, this.trainersBlockLegendaries, this.trainersBlockEarlyWonderGuard));
        out.write((this.trainersForceFullyEvolved ? 128 : 0) | this.trainersForceFullyEvolvedLevel);
        out.write(Settings.makeByteSelected(this.wildPokemonRestrictionMod == WildPokemonRestrictionMod.CATCH_EM_ALL, this.wildPokemonMod == WildPokemonMod.AREA_MAPPING, this.wildPokemonRestrictionMod == WildPokemonRestrictionMod.NONE, this.wildPokemonRestrictionMod == WildPokemonRestrictionMod.TYPE_THEME_AREAS, this.wildPokemonMod == WildPokemonMod.GLOBAL_MAPPING, this.wildPokemonMod == WildPokemonMod.RANDOM, this.wildPokemonMod == WildPokemonMod.UNCHANGED, this.useTimeBasedEncounters));
        out.write(Settings.makeByteSelected(this.useMinimumCatchRate, this.blockWildLegendaries, this.wildPokemonRestrictionMod == WildPokemonRestrictionMod.SIMILAR_STRENGTH, this.randomizeWildPokemonHeldItems, this.banBadRandomWildPokemonHeldItems) | this.minimumCatchRateLevel - 1 << 5);
        out.write(Settings.makeByteSelected(this.staticPokemonMod == StaticPokemonMod.UNCHANGED, this.staticPokemonMod == StaticPokemonMod.RANDOM_MATCHING, this.staticPokemonMod == StaticPokemonMod.COMPLETELY_RANDOM));
        out.write(Settings.makeByteSelected(this.tmsHmsCompatibilityMod == TMsHMsCompatibilityMod.COMPLETELY_RANDOM, this.tmsHmsCompatibilityMod == TMsHMsCompatibilityMod.RANDOM_PREFER_TYPE, this.tmsHmsCompatibilityMod == TMsHMsCompatibilityMod.UNCHANGED, this.tmsMod == TMsMod.RANDOM, this.tmsMod == TMsMod.UNCHANGED, this.tmLevelUpMoveSanity, this.keepFieldMoveTMs, this.tmsHmsCompatibilityMod == TMsHMsCompatibilityMod.FULL));
        out.write(Settings.makeByteSelected(this.fullHMCompat));
        out.write((this.tmsForceGoodDamaging ? 128 : 0) | this.tmsGoodDamagingPercent);
        out.write(Settings.makeByteSelected(this.moveTutorsCompatibilityMod == MoveTutorsCompatibilityMod.COMPLETELY_RANDOM, this.moveTutorsCompatibilityMod == MoveTutorsCompatibilityMod.RANDOM_PREFER_TYPE, this.moveTutorsCompatibilityMod == MoveTutorsCompatibilityMod.UNCHANGED, this.moveTutorMovesMod == MoveTutorMovesMod.RANDOM, this.moveTutorMovesMod == MoveTutorMovesMod.UNCHANGED, this.tutorLevelUpMoveSanity, this.keepFieldMoveTutors, this.moveTutorsCompatibilityMod == MoveTutorsCompatibilityMod.FULL));
        out.write((this.tutorsForceGoodDamaging ? 128 : 0) | this.tutorsGoodDamagingPercent);
        out.write(Settings.makeByteSelected(this.inGameTradesMod == InGameTradesMod.RANDOMIZE_GIVEN_AND_REQUESTED, this.inGameTradesMod == InGameTradesMod.RANDOMIZE_GIVEN, this.randomizeInGameTradesItems, this.randomizeInGameTradesIVs, this.randomizeInGameTradesNicknames, this.randomizeInGameTradesOTs, this.inGameTradesMod == InGameTradesMod.UNCHANGED));
        out.write(Settings.makeByteSelected(this.fieldItemsMod == FieldItemsMod.RANDOM, this.fieldItemsMod == FieldItemsMod.SHUFFLE, this.fieldItemsMod == FieldItemsMod.UNCHANGED, this.banBadRandomFieldItems));
        out.write(Settings.makeByteSelected(this.randomizeMovePowers, this.randomizeMoveAccuracies, this.randomizeMovePPs, this.randomizeMoveTypes, this.randomizeMoveCategory));
        out.write(Settings.makeByteSelected(this.evolutionsMod == EvolutionsMod.UNCHANGED, this.evolutionsMod == EvolutionsMod.RANDOM, this.evosSimilarStrength, this.evosSameTyping, this.evosMaxThreeStages, this.evosForceChange));
        try {
            if (this.currentRestrictions != null) {
                Settings.writeFullInt(out, this.currentRestrictions.toInt());
            } else {
                Settings.writeFullInt(out, 0);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Settings.writeFullInt(out, this.currentMiscTweaks);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.write((this.trainersLevelModified ? 128 : 0) | this.trainersLevelModifier + 50);
        try {
            byte[] romName = this.romName.getBytes("US-ASCII");
            out.write(romName.length);
            out.write(romName);
        }
        catch (UnsupportedEncodingException e) {
            out.write(0);
        }
        catch (IOException e) {
            out.write(0);
        }
        byte[] current = out.toByteArray();
        CRC32 checksum = new CRC32();
        checksum.update(current);
        try {
            Settings.writeFullInt(out, (int)checksum.getValue());
            Settings.writeFullInt(out, FileFunctions.getFileChecksum("customnames.rncn"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DatatypeConverter.printBase64Binary((byte[])out.toByteArray());
    }

    public static Settings fromString(String settingsString) throws UnsupportedEncodingException {
        byte[] data = DatatypeConverter.parseBase64Binary((String)settingsString);
        Settings.checkChecksum(data);
        Settings settings = new Settings();
        settings.setChangeImpossibleEvolutions(Settings.restoreState(data[0], 0));
        settings.setUpdateMoves(Settings.restoreState(data[0], 1));
        settings.setUpdateMovesLegacy(Settings.restoreState(data[0], 2));
        settings.setRandomizeTrainerNames(Settings.restoreState(data[0], 3));
        settings.setRandomizeTrainerClassNames(Settings.restoreState(data[0], 4));
        settings.setMakeEvolutionsEasier(Settings.restoreState(data[0], 5));
        settings.setBaseStatisticsMod(Settings.restoreEnum(BaseStatisticsMod.class, data[1], 3, 2, 1));
        settings.setStandardizeEXPCurves(Settings.restoreState(data[1], 4));
        settings.setBaseStatsFollowEvolutions(Settings.restoreState(data[1], 0));
        settings.setUpdateBaseStats(Settings.restoreState(data[1], 5));
        settings.setTypesMod(Settings.restoreEnum(TypesMod.class, data[2], 2, 0, 1));
        settings.setRaceMode(Settings.restoreState(data[2], 3));
        settings.setBlockBrokenMoves(Settings.restoreState(data[2], 4));
        settings.setLimitPokemon(Settings.restoreState(data[2], 5));
        settings.setAbilitiesMod(Settings.restoreEnum(AbilitiesMod.class, data[3], 0, 1));
        settings.setAllowWonderGuard(Settings.restoreState(data[3], 2));
        settings.setAbilitiesFollowEvolutions(Settings.restoreState(data[3], 3));
        settings.setBanTrappingAbilities(Settings.restoreState(data[3], 4));
        settings.setBanNegativeAbilities(Settings.restoreState(data[3], 5));
        settings.setStartersMod(Settings.restoreEnum(StartersMod.class, data[4], 2, 0, 1, 3));
        settings.setRandomizeStartersHeldItems(Settings.restoreState(data[4], 4));
        settings.setBanBadRandomStarterHeldItems(Settings.restoreState(data[4], 5));
        settings.setCustomStarters(new int[]{FileFunctions.read2ByteInt(data, 5) + 1, FileFunctions.read2ByteInt(data, 7) + 1, FileFunctions.read2ByteInt(data, 9) + 1});
        settings.setMovesetsMod(Settings.restoreEnum(MovesetsMod.class, data[11], 2, 1, 0, 3));
        settings.setStartWithFourMoves(Settings.restoreState(data[11], 4));
        settings.setReorderDamagingMoves(Settings.restoreState(data[11], 5));
        settings.setMovesetsForceGoodDamaging(Settings.restoreState(data[12], 7));
        settings.setMovesetsGoodDamagingPercent(data[12] & 0x7F);
        settings.setTrainersMod(Settings.restoreEnum(TrainersMod.class, data[13], 5, 1, 3));
        settings.setTrainersUsePokemonOfSimilarStrength(Settings.restoreState(data[13], 0));
        settings.setRivalCarriesStarterThroughout(Settings.restoreState(data[13], 2));
        settings.setTrainersMatchTypingDistribution(Settings.restoreState(data[13], 4));
        settings.setTrainersBlockLegendaries(Settings.restoreState(data[13], 6));
        settings.setTrainersBlockEarlyWonderGuard(Settings.restoreState(data[13], 7));
        settings.setTrainersForceFullyEvolved(Settings.restoreState(data[14], 7));
        settings.setTrainersForceFullyEvolvedLevel(data[14] & 0x7F);
        settings.setWildPokemonMod(Settings.restoreEnum(WildPokemonMod.class, data[15], 6, 5, 1, 4));
        settings.setWildPokemonRestrictionMod(Settings.getEnum(WildPokemonRestrictionMod.class, Settings.restoreState(data[15], 2), Settings.restoreState(data[16], 2), Settings.restoreState(data[15], 0), Settings.restoreState(data[15], 3)));
        settings.setUseTimeBasedEncounters(Settings.restoreState(data[15], 7));
        settings.setUseMinimumCatchRate(Settings.restoreState(data[16], 0));
        settings.setBlockWildLegendaries(Settings.restoreState(data[16], 1));
        settings.setRandomizeWildPokemonHeldItems(Settings.restoreState(data[16], 3));
        settings.setBanBadRandomWildPokemonHeldItems(Settings.restoreState(data[16], 4));
        settings.setMinimumCatchRateLevel(((data[16] & 0x60) >> 5) + 1);
        settings.setStaticPokemonMod(Settings.restoreEnum(StaticPokemonMod.class, data[17], 0, 1, 2));
        settings.setTmsMod(Settings.restoreEnum(TMsMod.class, data[18], 4, 3));
        settings.setTmsHmsCompatibilityMod(Settings.restoreEnum(TMsHMsCompatibilityMod.class, data[18], 2, 1, 0, 7));
        settings.setTmLevelUpMoveSanity(Settings.restoreState(data[18], 5));
        settings.setKeepFieldMoveTMs(Settings.restoreState(data[18], 6));
        settings.setFullHMCompat(Settings.restoreState(data[19], 0));
        settings.setTmsForceGoodDamaging(Settings.restoreState(data[20], 7));
        settings.setTmsGoodDamagingPercent(data[20] & 0x7F);
        settings.setMoveTutorMovesMod(Settings.restoreEnum(MoveTutorMovesMod.class, data[21], 4, 3));
        settings.setMoveTutorsCompatibilityMod(Settings.restoreEnum(MoveTutorsCompatibilityMod.class, data[21], 2, 1, 0, 7));
        settings.setTutorLevelUpMoveSanity(Settings.restoreState(data[21], 5));
        settings.setKeepFieldMoveTutors(Settings.restoreState(data[21], 6));
        settings.setTutorsForceGoodDamaging(Settings.restoreState(data[22], 7));
        settings.setTutorsGoodDamagingPercent(data[22] & 0x7F);
        settings.setInGameTradesMod(Settings.restoreEnum(InGameTradesMod.class, data[23], 6, 1, 0));
        settings.setRandomizeInGameTradesItems(Settings.restoreState(data[23], 2));
        settings.setRandomizeInGameTradesIVs(Settings.restoreState(data[23], 3));
        settings.setRandomizeInGameTradesNicknames(Settings.restoreState(data[23], 4));
        settings.setRandomizeInGameTradesOTs(Settings.restoreState(data[23], 5));
        settings.setFieldItemsMod(Settings.restoreEnum(FieldItemsMod.class, data[24], 2, 1, 0));
        settings.setBanBadRandomFieldItems(Settings.restoreState(data[24], 3));
        settings.setRandomizeMovePowers(Settings.restoreState(data[25], 0));
        settings.setRandomizeMoveAccuracies(Settings.restoreState(data[25], 1));
        settings.setRandomizeMovePPs(Settings.restoreState(data[25], 2));
        settings.setRandomizeMoveTypes(Settings.restoreState(data[25], 3));
        settings.setRandomizeMoveCategory(Settings.restoreState(data[25], 4));
        settings.setEvolutionsMod(Settings.restoreEnum(EvolutionsMod.class, data[26], 0, 1));
        settings.setEvosSimilarStrength(Settings.restoreState(data[26], 2));
        settings.setEvosSameTyping(Settings.restoreState(data[26], 3));
        settings.setEvosMaxThreeStages(Settings.restoreState(data[26], 4));
        settings.setEvosForceChange(Settings.restoreState(data[26], 5));
        int genLimit = FileFunctions.readFullInt(data, 27);
        GenRestrictions restrictions = null;
        if (genLimit != 0) {
            restrictions = new GenRestrictions(genLimit);
        }
        settings.setCurrentRestrictions(restrictions);
        int codeTweaks = FileFunctions.readFullInt(data, 31);
        settings.setCurrentMiscTweaks(codeTweaks);
        settings.setTrainersLevelModified(Settings.restoreState(data[35], 7));
        settings.setTrainersLevelModifier((data[35] & 0x7F) - 50);
        int romNameLength = data[36] & 0xFF;
        String romName = new String(data, 37, romNameLength, "US-ASCII");
        settings.setRomName(romName);
        return settings;
    }

    public TweakForROMFeedback tweakForRom(RomHandler rh) {
        TweakForROMFeedback feedback = new TweakForROMFeedback();
        if (this.isUpdateMovesLegacy() && rh instanceof Gen5RomHandler) {
            this.setUpdateMovesLegacy(false);
            this.setUpdateMoves(false);
        }
        List<Pokemon> romPokemon = rh.getPokemon();
        List<Pokemon> romStarters = rh.getStarters();
        for (int starter = 0; starter < 3; ++starter) {
            if (this.customStarters[starter] >= 0 && this.customStarters[starter] < romPokemon.size()) continue;
            feedback.setChangedStarter(true);
            this.customStarters[starter] = starter >= romStarters.size() ? 1 : romPokemon.indexOf(romStarters.get(starter));
        }
        if (rh instanceof Gen1RomHandler || rh.isROMHack()) {
            this.currentRestrictions = null;
            this.setLimitPokemon(false);
        } else if (this.currentRestrictions != null) {
            this.currentRestrictions.limitToGen(rh.generationOfPokemon());
        }
        int oldMiscTweaks = this.currentMiscTweaks;
        this.currentMiscTweaks &= rh.miscTweaksAvailable();
        if (oldMiscTweaks != this.currentMiscTweaks) {
            feedback.setRemovedCodeTweaks(true);
        }
        if (rh.abilitiesPerPokemon() == 0) {
            this.setAbilitiesMod(AbilitiesMod.UNCHANGED);
            this.setAllowWonderGuard(false);
        }
        if (!(rh instanceof Gen2RomHandler) && !(rh instanceof Gen3RomHandler)) {
            this.setRandomizeStartersHeldItems(false);
            this.setBanBadRandomStarterHeldItems(false);
        }
        if (!rh.supportsFourStartingMoves()) {
            this.setStartWithFourMoves(false);
        }
        if (rh instanceof Gen1RomHandler || rh instanceof Gen2RomHandler) {
            this.setTrainersBlockEarlyWonderGuard(false);
        }
        if (!rh.hasTimeBasedEncounters()) {
            this.setUseTimeBasedEncounters(false);
        }
        if (rh instanceof Gen1RomHandler) {
            this.setRandomizeWildPokemonHeldItems(false);
            this.setBanBadRandomWildPokemonHeldItems(false);
        }
        if (!rh.canChangeStaticPokemon()) {
            this.setStaticPokemonMod(StaticPokemonMod.UNCHANGED);
        }
        if (!rh.hasMoveTutors()) {
            this.setMoveTutorMovesMod(MoveTutorMovesMod.UNCHANGED);
            this.setMoveTutorsCompatibilityMod(MoveTutorsCompatibilityMod.UNCHANGED);
            this.setTutorLevelUpMoveSanity(false);
            this.setKeepFieldMoveTutors(false);
        }
        if (rh instanceof Gen1RomHandler) {
            this.setRandomizeInGameTradesItems(false);
            this.setRandomizeInGameTradesIVs(false);
            this.setRandomizeInGameTradesOTs(false);
        }
        if (!rh.hasPhysicalSpecialSplit()) {
            this.setRandomizeMoveCategory(false);
        }
        return feedback;
    }

    public CustomNamesSet getCustomNames() {
        return this.customNames;
    }

    public Settings setCustomNames(CustomNamesSet customNames) {
        this.customNames = customNames;
        return this;
    }

    public String getRomName() {
        return this.romName;
    }

    public Settings setRomName(String romName) {
        this.romName = romName;
        return this;
    }

    public boolean isUpdatedFromOldVersion() {
        return this.updatedFromOldVersion;
    }

    public Settings setUpdatedFromOldVersion(boolean updatedFromOldVersion) {
        this.updatedFromOldVersion = updatedFromOldVersion;
        return this;
    }

    public GenRestrictions getCurrentRestrictions() {
        return this.currentRestrictions;
    }

    public Settings setCurrentRestrictions(GenRestrictions currentRestrictions) {
        this.currentRestrictions = currentRestrictions;
        return this;
    }

    public int getCurrentMiscTweaks() {
        return this.currentMiscTweaks;
    }

    public Settings setCurrentMiscTweaks(int currentMiscTweaks) {
        this.currentMiscTweaks = currentMiscTweaks;
        return this;
    }

    public boolean isUpdateMoves() {
        return this.updateMoves;
    }

    public Settings setUpdateMoves(boolean updateMoves) {
        this.updateMoves = updateMoves;
        return this;
    }

    public boolean isUpdateMovesLegacy() {
        return this.updateMovesLegacy;
    }

    public Settings setUpdateMovesLegacy(boolean updateMovesLegacy) {
        this.updateMovesLegacy = updateMovesLegacy;
        return this;
    }

    public boolean isChangeImpossibleEvolutions() {
        return this.changeImpossibleEvolutions;
    }

    public Settings setChangeImpossibleEvolutions(boolean changeImpossibleEvolutions) {
        this.changeImpossibleEvolutions = changeImpossibleEvolutions;
        return this;
    }

    public boolean isMakeEvolutionsEasier() {
        return this.makeEvolutionsEasier;
    }

    public Settings setMakeEvolutionsEasier(boolean makeEvolutionsEasier) {
        this.makeEvolutionsEasier = makeEvolutionsEasier;
        return this;
    }

    public boolean isRaceMode() {
        return this.raceMode;
    }

    public Settings setRaceMode(boolean raceMode) {
        this.raceMode = raceMode;
        return this;
    }

    public boolean doBlockBrokenMoves() {
        return this.blockBrokenMoves;
    }

    public Settings setBlockBrokenMoves(boolean blockBrokenMoves) {
        this.blockBrokenMoves = blockBrokenMoves;
        return this;
    }

    public boolean isLimitPokemon() {
        return this.limitPokemon;
    }

    public Settings setLimitPokemon(boolean limitPokemon) {
        this.limitPokemon = limitPokemon;
        return this;
    }

    public BaseStatisticsMod getBaseStatisticsMod() {
        return this.baseStatisticsMod;
    }

    public Settings setBaseStatisticsMod(BaseStatisticsMod baseStatisticsMod) {
        this.baseStatisticsMod = baseStatisticsMod;
        return this;
    }

    public Settings setBaseStatisticsMod(boolean ... bools) {
        return this.setBaseStatisticsMod(Settings.getEnum(BaseStatisticsMod.class, bools));
    }

    public boolean isBaseStatsFollowEvolutions() {
        return this.baseStatsFollowEvolutions;
    }

    public Settings setBaseStatsFollowEvolutions(boolean baseStatsFollowEvolutions) {
        this.baseStatsFollowEvolutions = baseStatsFollowEvolutions;
        return this;
    }

    public boolean isStandardizeEXPCurves() {
        return this.standardizeEXPCurves;
    }

    public Settings setStandardizeEXPCurves(boolean standardizeEXPCurves) {
        this.standardizeEXPCurves = standardizeEXPCurves;
        return this;
    }

    public boolean isUpdateBaseStats() {
        return this.updateBaseStats;
    }

    public Settings setUpdateBaseStats(boolean updateBaseStats) {
        this.updateBaseStats = updateBaseStats;
        return this;
    }

    public AbilitiesMod getAbilitiesMod() {
        return this.abilitiesMod;
    }

    public Settings setAbilitiesMod(AbilitiesMod abilitiesMod) {
        this.abilitiesMod = abilitiesMod;
        return this;
    }

    public Settings setAbilitiesMod(boolean ... bools) {
        return this.setAbilitiesMod(Settings.getEnum(AbilitiesMod.class, bools));
    }

    public boolean isAllowWonderGuard() {
        return this.allowWonderGuard;
    }

    public Settings setAllowWonderGuard(boolean allowWonderGuard) {
        this.allowWonderGuard = allowWonderGuard;
        return this;
    }

    public boolean isAbilitiesFollowEvolutions() {
        return this.abilitiesFollowEvolutions;
    }

    public Settings setAbilitiesFollowEvolutions(boolean abilitiesFollowEvolutions) {
        this.abilitiesFollowEvolutions = abilitiesFollowEvolutions;
        return this;
    }

    public boolean isBanTrappingAbilities() {
        return this.banTrappingAbilities;
    }

    public Settings setBanTrappingAbilities(boolean banTrappingAbilities) {
        this.banTrappingAbilities = banTrappingAbilities;
        return this;
    }

    public boolean isBanNegativeAbilities() {
        return this.banNegativeAbilities;
    }

    public Settings setBanNegativeAbilities(boolean banNegativeAbilities) {
        this.banNegativeAbilities = banNegativeAbilities;
        return this;
    }

    public StartersMod getStartersMod() {
        return this.startersMod;
    }

    public Settings setStartersMod(StartersMod startersMod) {
        this.startersMod = startersMod;
        return this;
    }

    public Settings setStartersMod(boolean ... bools) {
        return this.setStartersMod(Settings.getEnum(StartersMod.class, bools));
    }

    public int[] getCustomStarters() {
        return this.customStarters;
    }

    public Settings setCustomStarters(int[] customStarters) {
        this.customStarters = customStarters;
        return this;
    }

    public boolean isRandomizeStartersHeldItems() {
        return this.randomizeStartersHeldItems;
    }

    public Settings setRandomizeStartersHeldItems(boolean randomizeStartersHeldItems) {
        this.randomizeStartersHeldItems = randomizeStartersHeldItems;
        return this;
    }

    public boolean isBanBadRandomStarterHeldItems() {
        return this.banBadRandomStarterHeldItems;
    }

    public Settings setBanBadRandomStarterHeldItems(boolean banBadRandomStarterHeldItems) {
        this.banBadRandomStarterHeldItems = banBadRandomStarterHeldItems;
        return this;
    }

    public TypesMod getTypesMod() {
        return this.typesMod;
    }

    public Settings setTypesMod(TypesMod typesMod) {
        this.typesMod = typesMod;
        return this;
    }

    public Settings setTypesMod(boolean ... bools) {
        return this.setTypesMod(Settings.getEnum(TypesMod.class, bools));
    }

    public EvolutionsMod getEvolutionsMod() {
        return this.evolutionsMod;
    }

    public Settings setEvolutionsMod(EvolutionsMod evolutionsMod) {
        this.evolutionsMod = evolutionsMod;
        return this;
    }

    public Settings setEvolutionsMod(boolean ... bools) {
        return this.setEvolutionsMod(Settings.getEnum(EvolutionsMod.class, bools));
    }

    public boolean isEvosSimilarStrength() {
        return this.evosSimilarStrength;
    }

    public Settings setEvosSimilarStrength(boolean evosSimilarStrength) {
        this.evosSimilarStrength = evosSimilarStrength;
        return this;
    }

    public boolean isEvosSameTyping() {
        return this.evosSameTyping;
    }

    public Settings setEvosSameTyping(boolean evosSameTyping) {
        this.evosSameTyping = evosSameTyping;
        return this;
    }

    public boolean isEvosMaxThreeStages() {
        return this.evosMaxThreeStages;
    }

    public Settings setEvosMaxThreeStages(boolean evosMaxThreeStages) {
        this.evosMaxThreeStages = evosMaxThreeStages;
        return this;
    }

    public boolean isEvosForceChange() {
        return this.evosForceChange;
    }

    public Settings setEvosForceChange(boolean evosForceChange) {
        this.evosForceChange = evosForceChange;
        return this;
    }

    public boolean isRandomizeMovePowers() {
        return this.randomizeMovePowers;
    }

    public Settings setRandomizeMovePowers(boolean randomizeMovePowers) {
        this.randomizeMovePowers = randomizeMovePowers;
        return this;
    }

    public boolean isRandomizeMoveAccuracies() {
        return this.randomizeMoveAccuracies;
    }

    public Settings setRandomizeMoveAccuracies(boolean randomizeMoveAccuracies) {
        this.randomizeMoveAccuracies = randomizeMoveAccuracies;
        return this;
    }

    public boolean isRandomizeMovePPs() {
        return this.randomizeMovePPs;
    }

    public Settings setRandomizeMovePPs(boolean randomizeMovePPs) {
        this.randomizeMovePPs = randomizeMovePPs;
        return this;
    }

    public boolean isRandomizeMoveTypes() {
        return this.randomizeMoveTypes;
    }

    public Settings setRandomizeMoveTypes(boolean randomizeMoveTypes) {
        this.randomizeMoveTypes = randomizeMoveTypes;
        return this;
    }

    public boolean isRandomizeMoveCategory() {
        return this.randomizeMoveCategory;
    }

    public Settings setRandomizeMoveCategory(boolean randomizeMoveCategory) {
        this.randomizeMoveCategory = randomizeMoveCategory;
        return this;
    }

    public MovesetsMod getMovesetsMod() {
        return this.movesetsMod;
    }

    public Settings setMovesetsMod(MovesetsMod movesetsMod) {
        this.movesetsMod = movesetsMod;
        return this;
    }

    public Settings setMovesetsMod(boolean ... bools) {
        return this.setMovesetsMod(Settings.getEnum(MovesetsMod.class, bools));
    }

    public boolean isStartWithFourMoves() {
        return this.startWithFourMoves;
    }

    public Settings setStartWithFourMoves(boolean startWithFourMoves) {
        this.startWithFourMoves = startWithFourMoves;
        return this;
    }

    public boolean isReorderDamagingMoves() {
        return this.reorderDamagingMoves;
    }

    public Settings setReorderDamagingMoves(boolean reorderDamagingMoves) {
        this.reorderDamagingMoves = reorderDamagingMoves;
        return this;
    }

    public boolean isMovesetsForceGoodDamaging() {
        return this.movesetsForceGoodDamaging;
    }

    public Settings setMovesetsForceGoodDamaging(boolean movesetsForceGoodDamaging) {
        this.movesetsForceGoodDamaging = movesetsForceGoodDamaging;
        return this;
    }

    public int getMovesetsGoodDamagingPercent() {
        return this.movesetsGoodDamagingPercent;
    }

    public Settings setMovesetsGoodDamagingPercent(int movesetsGoodDamagingPercent) {
        this.movesetsGoodDamagingPercent = movesetsGoodDamagingPercent;
        return this;
    }

    public TrainersMod getTrainersMod() {
        return this.trainersMod;
    }

    public Settings setTrainersMod(TrainersMod trainersMod) {
        this.trainersMod = trainersMod;
        return this;
    }

    public Settings setTrainersMod(boolean ... bools) {
        return this.setTrainersMod(Settings.getEnum(TrainersMod.class, bools));
    }

    public boolean isRivalCarriesStarterThroughout() {
        return this.rivalCarriesStarterThroughout;
    }

    public Settings setRivalCarriesStarterThroughout(boolean rivalCarriesStarterThroughout) {
        this.rivalCarriesStarterThroughout = rivalCarriesStarterThroughout;
        return this;
    }

    public boolean isTrainersUsePokemonOfSimilarStrength() {
        return this.trainersUsePokemonOfSimilarStrength;
    }

    public Settings setTrainersUsePokemonOfSimilarStrength(boolean trainersUsePokemonOfSimilarStrength) {
        this.trainersUsePokemonOfSimilarStrength = trainersUsePokemonOfSimilarStrength;
        return this;
    }

    public boolean isTrainersMatchTypingDistribution() {
        return this.trainersMatchTypingDistribution;
    }

    public Settings setTrainersMatchTypingDistribution(boolean trainersMatchTypingDistribution) {
        this.trainersMatchTypingDistribution = trainersMatchTypingDistribution;
        return this;
    }

    public boolean isTrainersBlockLegendaries() {
        return this.trainersBlockLegendaries;
    }

    public Settings setTrainersBlockLegendaries(boolean trainersBlockLegendaries) {
        this.trainersBlockLegendaries = trainersBlockLegendaries;
        return this;
    }

    public boolean isTrainersBlockEarlyWonderGuard() {
        return this.trainersBlockEarlyWonderGuard;
    }

    public Settings setTrainersBlockEarlyWonderGuard(boolean trainersBlockEarlyWonderGuard) {
        this.trainersBlockEarlyWonderGuard = trainersBlockEarlyWonderGuard;
        return this;
    }

    public boolean isRandomizeTrainerNames() {
        return this.randomizeTrainerNames;
    }

    public Settings setRandomizeTrainerNames(boolean randomizeTrainerNames) {
        this.randomizeTrainerNames = randomizeTrainerNames;
        return this;
    }

    public boolean isRandomizeTrainerClassNames() {
        return this.randomizeTrainerClassNames;
    }

    public Settings setRandomizeTrainerClassNames(boolean randomizeTrainerClassNames) {
        this.randomizeTrainerClassNames = randomizeTrainerClassNames;
        return this;
    }

    public boolean isTrainersForceFullyEvolved() {
        return this.trainersForceFullyEvolved;
    }

    public Settings setTrainersForceFullyEvolved(boolean trainersForceFullyEvolved) {
        this.trainersForceFullyEvolved = trainersForceFullyEvolved;
        return this;
    }

    public int getTrainersForceFullyEvolvedLevel() {
        return this.trainersForceFullyEvolvedLevel;
    }

    public Settings setTrainersForceFullyEvolvedLevel(int trainersForceFullyEvolvedLevel) {
        this.trainersForceFullyEvolvedLevel = trainersForceFullyEvolvedLevel;
        return this;
    }

    public boolean isTrainersLevelModified() {
        return this.trainersLevelModified;
    }

    public Settings setTrainersLevelModified(boolean trainersLevelModified) {
        this.trainersLevelModified = trainersLevelModified;
        return this;
    }

    public int getTrainersLevelModifier() {
        return this.trainersLevelModifier;
    }

    public Settings setTrainersLevelModifier(int trainersLevelModifier) {
        this.trainersLevelModifier = trainersLevelModifier;
        return this;
    }

    public WildPokemonMod getWildPokemonMod() {
        return this.wildPokemonMod;
    }

    public Settings setWildPokemonMod(WildPokemonMod wildPokemonMod) {
        this.wildPokemonMod = wildPokemonMod;
        return this;
    }

    public Settings setWildPokemonMod(boolean ... bools) {
        return this.setWildPokemonMod(Settings.getEnum(WildPokemonMod.class, bools));
    }

    public WildPokemonRestrictionMod getWildPokemonRestrictionMod() {
        return this.wildPokemonRestrictionMod;
    }

    public Settings setWildPokemonRestrictionMod(WildPokemonRestrictionMod wildPokemonRestrictionMod) {
        this.wildPokemonRestrictionMod = wildPokemonRestrictionMod;
        return this;
    }

    public Settings setWildPokemonRestrictionMod(boolean ... bools) {
        return this.setWildPokemonRestrictionMod(Settings.getEnum(WildPokemonRestrictionMod.class, bools));
    }

    public boolean isUseTimeBasedEncounters() {
        return this.useTimeBasedEncounters;
    }

    public Settings setUseTimeBasedEncounters(boolean useTimeBasedEncounters) {
        this.useTimeBasedEncounters = useTimeBasedEncounters;
        return this;
    }

    public boolean isBlockWildLegendaries() {
        return this.blockWildLegendaries;
    }

    public Settings setBlockWildLegendaries(boolean blockWildLegendaries) {
        this.blockWildLegendaries = blockWildLegendaries;
        return this;
    }

    public boolean isUseMinimumCatchRate() {
        return this.useMinimumCatchRate;
    }

    public Settings setUseMinimumCatchRate(boolean useMinimumCatchRate) {
        this.useMinimumCatchRate = useMinimumCatchRate;
        return this;
    }

    public int getMinimumCatchRateLevel() {
        return this.minimumCatchRateLevel;
    }

    public Settings setMinimumCatchRateLevel(int minimumCatchRateLevel) {
        this.minimumCatchRateLevel = minimumCatchRateLevel;
        return this;
    }

    public boolean isRandomizeWildPokemonHeldItems() {
        return this.randomizeWildPokemonHeldItems;
    }

    public Settings setRandomizeWildPokemonHeldItems(boolean randomizeWildPokemonHeldItems) {
        this.randomizeWildPokemonHeldItems = randomizeWildPokemonHeldItems;
        return this;
    }

    public boolean isBanBadRandomWildPokemonHeldItems() {
        return this.banBadRandomWildPokemonHeldItems;
    }

    public Settings setBanBadRandomWildPokemonHeldItems(boolean banBadRandomWildPokemonHeldItems) {
        this.banBadRandomWildPokemonHeldItems = banBadRandomWildPokemonHeldItems;
        return this;
    }

    public StaticPokemonMod getStaticPokemonMod() {
        return this.staticPokemonMod;
    }

    public Settings setStaticPokemonMod(StaticPokemonMod staticPokemonMod) {
        this.staticPokemonMod = staticPokemonMod;
        return this;
    }

    public Settings setStaticPokemonMod(boolean ... bools) {
        return this.setStaticPokemonMod(Settings.getEnum(StaticPokemonMod.class, bools));
    }

    public TMsMod getTmsMod() {
        return this.tmsMod;
    }

    public Settings setTmsMod(TMsMod tmsMod) {
        this.tmsMod = tmsMod;
        return this;
    }

    public Settings setTmsMod(boolean ... bools) {
        return this.setTmsMod(Settings.getEnum(TMsMod.class, bools));
    }

    public boolean isTmLevelUpMoveSanity() {
        return this.tmLevelUpMoveSanity;
    }

    public Settings setTmLevelUpMoveSanity(boolean tmLevelUpMoveSanity) {
        this.tmLevelUpMoveSanity = tmLevelUpMoveSanity;
        return this;
    }

    public boolean isKeepFieldMoveTMs() {
        return this.keepFieldMoveTMs;
    }

    public Settings setKeepFieldMoveTMs(boolean keepFieldMoveTMs) {
        this.keepFieldMoveTMs = keepFieldMoveTMs;
        return this;
    }

    public boolean isFullHMCompat() {
        return this.fullHMCompat;
    }

    public Settings setFullHMCompat(boolean fullHMCompat) {
        this.fullHMCompat = fullHMCompat;
        return this;
    }

    public boolean isTmsForceGoodDamaging() {
        return this.tmsForceGoodDamaging;
    }

    public Settings setTmsForceGoodDamaging(boolean tmsForceGoodDamaging) {
        this.tmsForceGoodDamaging = tmsForceGoodDamaging;
        return this;
    }

    public int getTmsGoodDamagingPercent() {
        return this.tmsGoodDamagingPercent;
    }

    public Settings setTmsGoodDamagingPercent(int tmsGoodDamagingPercent) {
        this.tmsGoodDamagingPercent = tmsGoodDamagingPercent;
        return this;
    }

    public TMsHMsCompatibilityMod getTmsHmsCompatibilityMod() {
        return this.tmsHmsCompatibilityMod;
    }

    public Settings setTmsHmsCompatibilityMod(TMsHMsCompatibilityMod tmsHmsCompatibilityMod) {
        this.tmsHmsCompatibilityMod = tmsHmsCompatibilityMod;
        return this;
    }

    public Settings setTmsHmsCompatibilityMod(boolean ... bools) {
        return this.setTmsHmsCompatibilityMod(Settings.getEnum(TMsHMsCompatibilityMod.class, bools));
    }

    public MoveTutorMovesMod getMoveTutorMovesMod() {
        return this.moveTutorMovesMod;
    }

    public Settings setMoveTutorMovesMod(MoveTutorMovesMod moveTutorMovesMod) {
        this.moveTutorMovesMod = moveTutorMovesMod;
        return this;
    }

    public Settings setMoveTutorMovesMod(boolean ... bools) {
        return this.setMoveTutorMovesMod(Settings.getEnum(MoveTutorMovesMod.class, bools));
    }

    public boolean isTutorLevelUpMoveSanity() {
        return this.tutorLevelUpMoveSanity;
    }

    public Settings setTutorLevelUpMoveSanity(boolean tutorLevelUpMoveSanity) {
        this.tutorLevelUpMoveSanity = tutorLevelUpMoveSanity;
        return this;
    }

    public boolean isKeepFieldMoveTutors() {
        return this.keepFieldMoveTutors;
    }

    public Settings setKeepFieldMoveTutors(boolean keepFieldMoveTutors) {
        this.keepFieldMoveTutors = keepFieldMoveTutors;
        return this;
    }

    public boolean isTutorsForceGoodDamaging() {
        return this.tutorsForceGoodDamaging;
    }

    public Settings setTutorsForceGoodDamaging(boolean tutorsForceGoodDamaging) {
        this.tutorsForceGoodDamaging = tutorsForceGoodDamaging;
        return this;
    }

    public int getTutorsGoodDamagingPercent() {
        return this.tutorsGoodDamagingPercent;
    }

    public Settings setTutorsGoodDamagingPercent(int tutorsGoodDamagingPercent) {
        this.tutorsGoodDamagingPercent = tutorsGoodDamagingPercent;
        return this;
    }

    public MoveTutorsCompatibilityMod getMoveTutorsCompatibilityMod() {
        return this.moveTutorsCompatibilityMod;
    }

    public Settings setMoveTutorsCompatibilityMod(MoveTutorsCompatibilityMod moveTutorsCompatibilityMod) {
        this.moveTutorsCompatibilityMod = moveTutorsCompatibilityMod;
        return this;
    }

    public Settings setMoveTutorsCompatibilityMod(boolean ... bools) {
        return this.setMoveTutorsCompatibilityMod(Settings.getEnum(MoveTutorsCompatibilityMod.class, bools));
    }

    public InGameTradesMod getInGameTradesMod() {
        return this.inGameTradesMod;
    }

    public Settings setInGameTradesMod(InGameTradesMod inGameTradesMod) {
        this.inGameTradesMod = inGameTradesMod;
        return this;
    }

    public Settings setInGameTradesMod(boolean ... bools) {
        return this.setInGameTradesMod(Settings.getEnum(InGameTradesMod.class, bools));
    }

    public boolean isRandomizeInGameTradesNicknames() {
        return this.randomizeInGameTradesNicknames;
    }

    public Settings setRandomizeInGameTradesNicknames(boolean randomizeInGameTradesNicknames) {
        this.randomizeInGameTradesNicknames = randomizeInGameTradesNicknames;
        return this;
    }

    public boolean isRandomizeInGameTradesOTs() {
        return this.randomizeInGameTradesOTs;
    }

    public Settings setRandomizeInGameTradesOTs(boolean randomizeInGameTradesOTs) {
        this.randomizeInGameTradesOTs = randomizeInGameTradesOTs;
        return this;
    }

    public boolean isRandomizeInGameTradesIVs() {
        return this.randomizeInGameTradesIVs;
    }

    public Settings setRandomizeInGameTradesIVs(boolean randomizeInGameTradesIVs) {
        this.randomizeInGameTradesIVs = randomizeInGameTradesIVs;
        return this;
    }

    public boolean isRandomizeInGameTradesItems() {
        return this.randomizeInGameTradesItems;
    }

    public Settings setRandomizeInGameTradesItems(boolean randomizeInGameTradesItems) {
        this.randomizeInGameTradesItems = randomizeInGameTradesItems;
        return this;
    }

    public FieldItemsMod getFieldItemsMod() {
        return this.fieldItemsMod;
    }

    public Settings setFieldItemsMod(FieldItemsMod fieldItemsMod) {
        this.fieldItemsMod = fieldItemsMod;
        return this;
    }

    public Settings setFieldItemsMod(boolean ... bools) {
        return this.setFieldItemsMod(Settings.getEnum(FieldItemsMod.class, bools));
    }

    public boolean isBanBadRandomFieldItems() {
        return this.banBadRandomFieldItems;
    }

    public Settings setBanBadRandomFieldItems(boolean banBadRandomFieldItems) {
        this.banBadRandomFieldItems = banBadRandomFieldItems;
        return this;
    }

    private static int makeByteSelected(boolean ... bools) {
        if (bools.length > 8) {
            throw new IllegalArgumentException("Can't set more than 8 bits in a byte!");
        }
        int initial = 0;
        int state = 1;
        for (boolean b : bools) {
            initial |= b ? state : 0;
            state *= 2;
        }
        return initial;
    }

    private static boolean restoreState(byte b, int index) {
        if (index >= 8) {
            throw new IllegalArgumentException("Can't read more than 8 bits from a byte!");
        }
        int value = b & 0xFF;
        return (value >> index & 1) == 1;
    }

    private static void writeFullInt(ByteArrayOutputStream out, int value) throws IOException {
        byte[] crc = ByteBuffer.allocate(4).putInt(value).array();
        out.write(crc);
    }

    private static void write2ByteInt(ByteArrayOutputStream out, int value) {
        out.write(value & 0xFF);
        out.write(value >> 8 & 0xFF);
    }

    public static <E extends Enum<E>> E restoreEnum(Class<E> clazz, byte b, int ... indices) {
        boolean[] bools = new boolean[indices.length];
        int i = 0;
        for (int idx : indices) {
            bools[i] = Settings.restoreState(b, idx);
            ++i;
        }
        return Settings.getEnum(clazz, bools);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> clazz, boolean ... bools) {
        int index = Settings.getSetEnum(clazz.getSimpleName(), bools);
        try {
            return (E)((Enum[])clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]))[index];
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to parse enum of type %s", clazz.getSimpleName()), e);
        }
    }

    private static int getSetEnum(String type, boolean ... bools) {
        int index = -1;
        for (int i = 0; i < bools.length; ++i) {
            if (!bools[i]) continue;
            if (index >= 0) {
                throw new IllegalStateException(String.format("Only one value for %s may be chosen!", type));
            }
            index = i;
        }
        return index >= 0 ? index : 0;
    }

    private static void checkChecksum(byte[] data) {
        ByteBuffer buf = ByteBuffer.allocate(4).put(data, data.length - 8, 4);
        buf.rewind();
        int crc = buf.getInt();
        CRC32 checksum = new CRC32();
        checksum.update(data, 0, data.length - 8);
        if ((int)checksum.getValue() != crc) {
            throw new IllegalArgumentException("Malformed input string");
        }
    }

    public static class TweakForROMFeedback {
        private boolean changedStarter;
        private boolean removedCodeTweaks;

        public boolean isChangedStarter() {
            return this.changedStarter;
        }

        public TweakForROMFeedback setChangedStarter(boolean changedStarter) {
            this.changedStarter = changedStarter;
            return this;
        }

        public boolean isRemovedCodeTweaks() {
            return this.removedCodeTweaks;
        }

        public TweakForROMFeedback setRemovedCodeTweaks(boolean removedCodeTweaks) {
            this.removedCodeTweaks = removedCodeTweaks;
            return this;
        }
    }

    public static enum FieldItemsMod {
        UNCHANGED,
        SHUFFLE,
        RANDOM;

    }

    public static enum InGameTradesMod {
        UNCHANGED,
        RANDOMIZE_GIVEN,
        RANDOMIZE_GIVEN_AND_REQUESTED;

    }

    public static enum MoveTutorsCompatibilityMod {
        UNCHANGED,
        RANDOM_PREFER_TYPE,
        COMPLETELY_RANDOM,
        FULL;

    }

    public static enum MoveTutorMovesMod {
        UNCHANGED,
        RANDOM;

    }

    public static enum TMsHMsCompatibilityMod {
        UNCHANGED,
        RANDOM_PREFER_TYPE,
        COMPLETELY_RANDOM,
        FULL;

    }

    public static enum TMsMod {
        UNCHANGED,
        RANDOM;

    }

    public static enum StaticPokemonMod {
        UNCHANGED,
        RANDOM_MATCHING,
        COMPLETELY_RANDOM;

    }

    public static enum WildPokemonRestrictionMod {
        NONE,
        SIMILAR_STRENGTH,
        CATCH_EM_ALL,
        TYPE_THEME_AREAS;

    }

    public static enum WildPokemonMod {
        UNCHANGED,
        RANDOM,
        AREA_MAPPING,
        GLOBAL_MAPPING;

    }

    public static enum TrainersMod {
        UNCHANGED,
        RANDOM,
        TYPE_THEMED;

    }

    public static enum MovesetsMod {
        UNCHANGED,
        RANDOM_PREFER_SAME_TYPE,
        COMPLETELY_RANDOM,
        METRONOME_ONLY;

    }

    public static enum EvolutionsMod {
        UNCHANGED,
        RANDOM;

    }

    public static enum TypesMod {
        UNCHANGED,
        RANDOM_FOLLOW_EVOLUTIONS,
        COMPLETELY_RANDOM;

    }

    public static enum StartersMod {
        UNCHANGED,
        CUSTOM,
        COMPLETELY_RANDOM,
        RANDOM_WITH_TWO_EVOLUTIONS;

    }

    public static enum AbilitiesMod {
        UNCHANGED,
        RANDOMIZE;

    }

    public static enum BaseStatisticsMod {
        UNCHANGED,
        SHUFFLE,
        RANDOM;

    }
}

