/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.pokemon.Evolution;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class RomFunctions {
    public static Set<Pokemon> getBasicOrNoCopyPokemon(RomHandler baseRom) {
        List<Pokemon> allPokes = baseRom.getPokemon();
        TreeSet<Pokemon> dontCopyPokes = new TreeSet<Pokemon>();
        for (Pokemon pkmn : allPokes) {
            if (pkmn == null) continue;
            if (pkmn.evolutionsTo.size() != 1) {
                dontCopyPokes.add(pkmn);
                continue;
            }
            Evolution onlyEvo = pkmn.evolutionsTo.get(0);
            if (onlyEvo.carryStats) continue;
            dontCopyPokes.add(pkmn);
        }
        return dontCopyPokes;
    }

    public static Set<Pokemon> getMiddleEvolutions(RomHandler baseRom) {
        List<Pokemon> allPokes = baseRom.getPokemon();
        TreeSet<Pokemon> middleEvolutions = new TreeSet<Pokemon>();
        for (Pokemon pkmn : allPokes) {
            if (pkmn == null || pkmn.evolutionsTo.size() != 1 || pkmn.evolutionsFrom.size() <= 0) continue;
            Evolution onlyEvo = pkmn.evolutionsTo.get(0);
            if (!onlyEvo.carryStats) continue;
            middleEvolutions.add(pkmn);
        }
        return middleEvolutions;
    }

    public static Set<Pokemon> getFinalEvolutions(RomHandler baseRom) {
        List<Pokemon> allPokes = baseRom.getPokemon();
        TreeSet<Pokemon> finalEvolutions = new TreeSet<Pokemon>();
        for (Pokemon pkmn : allPokes) {
            if (pkmn == null || pkmn.evolutionsTo.size() != 1 || pkmn.evolutionsFrom.size() != 0) continue;
            Evolution onlyEvo = pkmn.evolutionsTo.get(0);
            if (!onlyEvo.carryStats) continue;
            finalEvolutions.add(pkmn);
        }
        return finalEvolutions;
    }

    public static int[] getMovesAtLevel(Pokemon pkmn, Map<Pokemon, List<MoveLearnt>> movesets, int level) {
        return RomFunctions.getMovesAtLevel(pkmn, movesets, level, 0);
    }

    public static int[] getMovesAtLevel(Pokemon pkmn, Map<Pokemon, List<MoveLearnt>> movesets, int level, int emptyValue) {
        int[] curMoves = new int[4];
        if (emptyValue != 0) {
            Arrays.fill(curMoves, emptyValue);
        }
        int moveCount = 0;
        List<MoveLearnt> movepool = movesets.get(pkmn);
        for (MoveLearnt ml : movepool) {
            int i;
            if (ml.level > level) break;
            boolean alreadyKnownMove = false;
            for (i = 0; i < moveCount; ++i) {
                if (curMoves[i] != ml.move) continue;
                alreadyKnownMove = true;
                break;
            }
            if (alreadyKnownMove) continue;
            if (moveCount == 4) {
                for (i = 0; i < 3; ++i) {
                    curMoves[i] = curMoves[i + 1];
                }
                curMoves[3] = ml.move;
                continue;
            }
            curMoves[moveCount++] = ml.move;
        }
        return curMoves;
    }

    public static String camelCase(String original) {
        char[] string = original.toLowerCase().toCharArray();
        boolean docap = true;
        for (int j = 0; j < string.length; ++j) {
            char current = string[j];
            if (docap && Character.isLetter(current)) {
                string[j] = Character.toUpperCase(current);
                docap = false;
                continue;
            }
            if (docap || Character.isLetter(current) || current == '\'') continue;
            docap = true;
        }
        return new String(string);
    }

    public static int freeSpaceFinder(byte[] rom, byte freeSpace, int amount, int offset) {
        return RomFunctions.freeSpaceFinder(rom, freeSpace, amount, offset, true);
    }

    public static int freeSpaceFinder(byte[] rom, byte freeSpace, int amount, int offset, boolean longAligned) {
        if (!longAligned) {
            byte[] searchNeedle = new byte[amount + 2];
            for (int i = 0; i < amount + 2; ++i) {
                searchNeedle[i] = freeSpace;
            }
            return RomFunctions.searchForFirst(rom, offset, searchNeedle) + 2;
        }
        byte[] searchNeedle = new byte[amount + 5];
        for (int i = 0; i < amount + 5; ++i) {
            searchNeedle[i] = freeSpace;
        }
        return RomFunctions.searchForFirst(rom, offset, searchNeedle) + 5 & 0xFFFFFFFC;
    }

    public static List<Integer> search(byte[] haystack, byte[] needle) {
        return RomFunctions.search(haystack, 0, haystack.length, needle);
    }

    public static List<Integer> search(byte[] haystack, int beginOffset, byte[] needle) {
        return RomFunctions.search(haystack, beginOffset, haystack.length, needle);
    }

    public static List<Integer> search(byte[] haystack, int beginOffset, int endOffset, byte[] needle) {
        int currentMatchStart = beginOffset;
        int currentCharacterPosition = 0;
        int docSize = endOffset;
        int needleSize = needle.length;
        int[] toFillTable = RomFunctions.buildKMPSearchTable(needle);
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (currentMatchStart + currentCharacterPosition < docSize) {
            if (needle[currentCharacterPosition] == haystack[currentCharacterPosition + currentMatchStart]) {
                if (++currentCharacterPosition != needleSize) continue;
                results.add(currentMatchStart);
                currentCharacterPosition = 0;
                currentMatchStart += needleSize;
                continue;
            }
            currentMatchStart = currentMatchStart + currentCharacterPosition - toFillTable[currentCharacterPosition];
            if (toFillTable[currentCharacterPosition] > -1) {
                currentCharacterPosition = toFillTable[currentCharacterPosition];
                continue;
            }
            currentCharacterPosition = 0;
        }
        return results;
    }

    public static int searchForFirst(byte[] haystack, int beginOffset, byte[] needle) {
        int currentMatchStart = beginOffset;
        int currentCharacterPosition = 0;
        int docSize = haystack.length;
        int needleSize = needle.length;
        int[] toFillTable = RomFunctions.buildKMPSearchTable(needle);
        while (currentMatchStart + currentCharacterPosition < docSize) {
            if (needle[currentCharacterPosition] == haystack[currentCharacterPosition + currentMatchStart]) {
                if (++currentCharacterPosition != needleSize) continue;
                return currentMatchStart;
            }
            currentMatchStart = currentMatchStart + currentCharacterPosition - toFillTable[currentCharacterPosition];
            if (toFillTable[currentCharacterPosition] > -1) {
                currentCharacterPosition = toFillTable[currentCharacterPosition];
                continue;
            }
            currentCharacterPosition = 0;
        }
        return -1;
    }

    private static int[] buildKMPSearchTable(byte[] needle) {
        int[] stable = new int[needle.length];
        int pos = 2;
        int j = 0;
        stable[0] = -1;
        stable[1] = 0;
        while (pos < needle.length) {
            if (needle[pos - 1] == needle[j]) {
                stable[pos] = j + 1;
                ++pos;
                ++j;
                continue;
            }
            if (j > 0) {
                j = stable[j];
                continue;
            }
            stable[pos] = 0;
            ++pos;
        }
        return stable;
    }

    public static String rewriteDescriptionForNewLineSize(String moveDesc, String newline, int lineSize, StringSizeDeterminer ssd) {
        moveDesc = moveDesc.replace("-" + newline, "").replace(newline, " ");
        moveDesc = moveDesc.replace("Sp. Atk", "Sp__Atk");
        moveDesc = moveDesc.replace("Sp. Def", "Sp__Def");
        moveDesc = moveDesc.replace("SP. ATK", "SP__ATK");
        moveDesc = moveDesc.replace("SP. DEF", "SP__DEF");
        String[] words = moveDesc.split(" ");
        StringBuilder fullDesc = new StringBuilder();
        StringBuilder thisLine = new StringBuilder();
        int currLineWC = 0;
        int currLineCC = 0;
        int linesWritten = 0;
        for (int i = 0; i < words.length; ++i) {
            words[i] = words[i].replace("SP__", "SP. ");
            words[i] = words[i].replace("Sp__", "Sp. ");
            int reqLength = ssd.lengthFor(words[i]);
            if (currLineWC > 0) {
                ++reqLength;
            }
            if (currLineCC + reqLength <= lineSize) {
                if (currLineWC > 0) {
                    thisLine.append(' ');
                }
                thisLine.append(words[i]);
                ++currLineWC;
                currLineCC += reqLength;
                continue;
            }
            if (currLineWC > 0) {
                if (linesWritten > 0) {
                    fullDesc.append(newline);
                }
                fullDesc.append(thisLine.toString());
                ++linesWritten;
                thisLine = new StringBuilder();
            }
            thisLine.append(words[i]);
            currLineWC = 1;
            currLineCC = ssd.lengthFor(words[i]);
        }
        if (currLineWC > 0) {
            if (linesWritten > 0) {
                fullDesc.append(newline);
            }
            fullDesc.append(thisLine.toString());
            ++linesWritten;
        }
        return fullDesc.toString();
    }

    public static String formatTextWithReplacements(String text, Map<String, String> replacements, String newline, String extraline, String newpara, int maxLineLength, StringSizeDeterminer ssd) {
        boolean endsWithPara = false;
        if (text.endsWith(newpara)) {
            endsWithPara = true;
            text = text.substring(0, text.length() - newpara.length());
        }
        text = text.replace(newline, " ").replace(extraline, " ");
        if (replacements != null) {
            int index = 0;
            for (Map.Entry<String, String> toReplace : replacements.entrySet()) {
                text = text.replace(toReplace.getKey(), "<tmpreplace" + ++index + ">");
            }
            index = 0;
            for (Map.Entry<String, String> toReplace : replacements.entrySet()) {
                text = text.replace("<tmpreplace" + ++index + ">", toReplace.getValue());
            }
        }
        String[] oldParagraphs = text.split(newpara.replace("\\", "\\\\"));
        StringBuilder finalResult = new StringBuilder();
        int sentenceNewLineSize = Math.max(10, maxLineLength / 2);
        for (int para = 0; para < oldParagraphs.length; ++para) {
            String[] words = oldParagraphs[para].split(" ");
            StringBuilder fullPara = new StringBuilder();
            StringBuilder thisLine = new StringBuilder();
            int currLineWC = 0;
            int currLineCC = 0;
            int linesWritten = 0;
            int currLineLastChar = 0;
            for (int i = 0; i < words.length; ++i) {
                int reqLength = ssd.lengthFor(words[i]);
                if (currLineWC > 0) {
                    ++reqLength;
                }
                if (currLineCC + reqLength > maxLineLength || currLineCC >= sentenceNewLineSize && (currLineLastChar == 46 || currLineLastChar == 63 || currLineLastChar == 33 || currLineLastChar == 8230 || currLineLastChar == 44)) {
                    if (currLineWC > 0) {
                        if (linesWritten > 1) {
                            fullPara.append(extraline);
                        } else if (linesWritten == 1) {
                            fullPara.append(newline);
                        }
                        fullPara.append(thisLine.toString());
                        ++linesWritten;
                        thisLine = new StringBuilder();
                    }
                    thisLine.append(words[i]);
                    currLineWC = 1;
                    currLineCC = ssd.lengthFor(words[i]);
                    if (words[i].length() == 0) {
                        currLineLastChar = 0;
                        continue;
                    }
                    currLineLastChar = words[i].charAt(words[i].length() - 1);
                    continue;
                }
                if (currLineWC > 0) {
                    thisLine.append(' ');
                }
                thisLine.append(words[i]);
                ++currLineWC;
                currLineCC += reqLength;
                currLineLastChar = words[i].length() == 0 ? 0 : (int)words[i].charAt(words[i].length() - 1);
            }
            if (currLineWC > 0) {
                if (linesWritten > 1) {
                    fullPara.append(extraline);
                } else if (linesWritten == 1) {
                    fullPara.append(newline);
                }
                fullPara.append(thisLine.toString());
                ++linesWritten;
            }
            if (para > 0) {
                finalResult.append(newpara);
            }
            finalResult.append(fullPara.toString());
        }
        if (endsWithPara) {
            finalResult.append(newpara);
        }
        return finalResult.toString();
    }

    public static class StringLengthSD
    implements StringSizeDeterminer {
        @Override
        public int lengthFor(String encodedText) {
            return encodedText.length();
        }
    }

    public static interface StringSizeDeterminer {
        public int lengthFor(String var1);
    }
}

