/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.MiscTweak;
import com.dabomstew.pkrandom.RandomSource;
import com.dabomstew.pkrandom.Settings;
import com.dabomstew.pkrandom.pokemon.Encounter;
import com.dabomstew.pkrandom.pokemon.EncounterSet;
import com.dabomstew.pkrandom.pokemon.IngameTrade;
import com.dabomstew.pkrandom.pokemon.Move;
import com.dabomstew.pkrandom.pokemon.MoveLearnt;
import com.dabomstew.pkrandom.pokemon.Pokemon;
import com.dabomstew.pkrandom.pokemon.Trainer;
import com.dabomstew.pkrandom.pokemon.TrainerPokemon;
import com.dabomstew.pkrandom.romhandlers.Gen1RomHandler;
import com.dabomstew.pkrandom.romhandlers.Gen5RomHandler;
import com.dabomstew.pkrandom.romhandlers.RomHandler;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Randomizer {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final Settings settings;
    private final RomHandler romHandler;

    public Randomizer(Settings settings, RomHandler romHandler) {
        this.settings = settings;
        this.romHandler = romHandler;
    }

    public int randomize(String filename) {
        return this.randomize(filename, new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }));
    }

    public int randomize(String filename, PrintStream log) {
        long seed = RandomSource.pickSeed();
        return this.randomize(filename, log, seed);
    }

    /*
     * WARNING - void declaration
     */
    public int randomize(String filename, PrintStream log, long seed) {
        double msGoodDamagingProb;
        long startTime = System.currentTimeMillis();
        RandomSource.seed(seed);
        boolean raceMode = this.settings.isRaceMode();
        int checkValue = 0;
        if (this.settings.isLimitPokemon()) {
            this.romHandler.setPokemonPool(this.settings.getCurrentRestrictions());
            this.romHandler.removeEvosForPokemonPool();
        } else {
            this.romHandler.setPokemonPool(null);
        }
        if (this.settings.isUpdateMoves()) {
            this.romHandler.initMoveUpdates();
            if (!(this.romHandler instanceof Gen5RomHandler)) {
                this.romHandler.updateMovesToGen5();
            }
            if (!this.settings.isUpdateMovesLegacy()) {
                this.romHandler.updateMovesToGen6();
            }
            this.romHandler.printMoveUpdates();
        }
        if (this.settings.isRandomizeMovePowers()) {
            this.romHandler.randomizeMovePowers();
        }
        if (this.settings.isRandomizeMoveAccuracies()) {
            this.romHandler.randomizeMoveAccuracies();
        }
        if (this.settings.isRandomizeMovePPs()) {
            this.romHandler.randomizeMovePPs();
        }
        if (this.settings.isRandomizeMoveTypes()) {
            this.romHandler.randomizeMoveTypes();
        }
        if (this.settings.isRandomizeMoveCategory() && this.romHandler.hasPhysicalSpecialSplit()) {
            this.romHandler.randomizeMoveCategory();
        }
        List<Move> moves = this.romHandler.getMoves();
        int currentMiscTweaks = this.settings.getCurrentMiscTweaks();
        if (this.romHandler.miscTweaksAvailable() != 0) {
            int codeTweaksAvailable = this.romHandler.miscTweaksAvailable();
            ArrayList<MiscTweak> arrayList = new ArrayList<MiscTweak>();
            for (MiscTweak mt : MiscTweak.allTweaks) {
                if ((codeTweaksAvailable & mt.getValue()) <= 0 || (currentMiscTweaks & mt.getValue()) <= 0) continue;
                arrayList.add(mt);
            }
            Collections.sort(arrayList);
            for (MiscTweak mt : arrayList) {
                this.romHandler.applyMiscTweak(mt);
            }
        }
        if (this.settings.isUpdateBaseStats()) {
            this.romHandler.updatePokemonStats();
        }
        switch (this.settings.getBaseStatisticsMod()) {
            case SHUFFLE: {
                this.romHandler.shufflePokemonStats(this.settings.isBaseStatsFollowEvolutions());
                break;
            }
            case RANDOM: {
                this.romHandler.randomizePokemonStats(this.settings.isBaseStatsFollowEvolutions());
                break;
            }
        }
        if (this.settings.isStandardizeEXPCurves()) {
            this.romHandler.standardizeEXPCurves();
        }
        if (this.romHandler.abilitiesPerPokemon() > 0 && this.settings.getAbilitiesMod() == Settings.AbilitiesMod.RANDOMIZE) {
            this.romHandler.randomizeAbilities(this.settings.isAbilitiesFollowEvolutions(), this.settings.isAllowWonderGuard(), this.settings.isBanTrappingAbilities(), this.settings.isBanNegativeAbilities());
        }
        switch (this.settings.getTypesMod()) {
            case RANDOM_FOLLOW_EVOLUTIONS: {
                this.romHandler.randomizePokemonTypes(true);
                break;
            }
            case COMPLETELY_RANDOM: {
                this.romHandler.randomizePokemonTypes(false);
                break;
            }
        }
        if (this.settings.isRandomizeWildPokemonHeldItems()) {
            this.romHandler.randomizeWildHeldItems(this.settings.isBanBadRandomWildPokemonHeldItems());
        }
        this.maybeLogBaseStatAndTypeChanges(log, this.romHandler);
        for (Pokemon pokemon : this.romHandler.getPokemon()) {
            if (pokemon == null) continue;
            checkValue = Randomizer.addToCV(checkValue, pokemon.hp, pokemon.attack, pokemon.defense, pokemon.speed, pokemon.spatk, pokemon.spdef, pokemon.ability1, pokemon.ability2, pokemon.ability3);
        }
        if (this.settings.getEvolutionsMod() == Settings.EvolutionsMod.RANDOM) {
            this.romHandler.randomizeEvolutions(this.settings.isEvosSimilarStrength(), this.settings.isEvosSameTyping(), this.settings.isEvosMaxThreeStages(), this.settings.isEvosForceChange());
            log.println("--Randomized Evolutions--");
            List<Pokemon> allPokes = this.romHandler.getPokemon();
            for (Pokemon pk : allPokes) {
                int numEvos;
                if (pk == null || (numEvos = pk.evolutionsFrom.size()) <= 0) continue;
                StringBuilder evoStr = new StringBuilder(pk.evolutionsFrom.get((int)0).to.name);
                for (int i = 1; i < numEvos; ++i) {
                    if (i == numEvos - 1) {
                        evoStr.append(" and " + pk.evolutionsFrom.get((int)i).to.name);
                        continue;
                    }
                    evoStr.append(", " + pk.evolutionsFrom.get((int)i).to.name);
                }
                log.println(pk.name + " now evolves into " + evoStr.toString());
            }
            log.println();
        }
        if (this.settings.isChangeImpossibleEvolutions()) {
            this.romHandler.removeTradeEvolutions(this.settings.getMovesetsMod() != Settings.MovesetsMod.UNCHANGED);
        }
        if (this.settings.isMakeEvolutionsEasier()) {
            this.romHandler.condenseLevelEvolutions(40, 30);
        }
        this.maybeChangeAndLogStarters(log, this.romHandler);
        this.maybeLogMoveChanges(log, this.romHandler);
        boolean noBrokenMoves = this.settings.doBlockBrokenMoves();
        boolean bl = this.romHandler.supportsFourStartingMoves() && this.settings.isStartWithFourMoves();
        double d = msGoodDamagingProb = this.settings.isMovesetsForceGoodDamaging() ? (double)this.settings.getMovesetsGoodDamagingPercent() / 100.0 : 0.0;
        if (this.settings.getMovesetsMod() == Settings.MovesetsMod.RANDOM_PREFER_SAME_TYPE) {
            this.romHandler.randomizeMovesLearnt(true, noBrokenMoves, bl, msGoodDamagingProb);
        } else if (this.settings.getMovesetsMod() == Settings.MovesetsMod.COMPLETELY_RANDOM) {
            this.romHandler.randomizeMovesLearnt(false, noBrokenMoves, bl, msGoodDamagingProb);
        }
        if (this.settings.isReorderDamagingMoves()) {
            this.romHandler.orderDamagingMovesByDamage();
        }
        if (this.settings.getMovesetsMod() == Settings.MovesetsMod.UNCHANGED) {
            log.println("Pokemon Movesets: Unchanged." + NEWLINE);
        } else if (this.settings.getMovesetsMod() == Settings.MovesetsMod.METRONOME_ONLY) {
            log.println("Pokemon Movesets: Metronome Only." + NEWLINE);
        } else {
            log.println("--Pokemon Movesets--");
            ArrayList<String> movesets = new ArrayList<String>();
            Map<Pokemon, List<MoveLearnt>> moveData = this.romHandler.getMovesLearnt();
            for (Pokemon pokemon : moveData.keySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("%03d %-10s : ", pokemon.number, pokemon.name));
                List<MoveLearnt> data = moveData.get(pokemon);
                boolean first = true;
                for (MoveLearnt ml : data) {
                    if (!first) {
                        stringBuilder.append(", ");
                    }
                    try {
                        stringBuilder.append(moves.get((int)ml.move).name).append(" at level ").append(ml.level);
                    }
                    catch (NullPointerException ex) {
                        stringBuilder.append("invalid move at level" + ml.level);
                    }
                    first = false;
                }
                movesets.add(stringBuilder.toString());
            }
            Collections.sort(movesets);
            for (String string : movesets) {
                log.println(string);
            }
            log.println();
        }
        if (this.settings.getTrainersMod() == Settings.TrainersMod.RANDOM) {
            this.romHandler.randomizeTrainerPokes(this.settings.isTrainersUsePokemonOfSimilarStrength(), this.settings.isTrainersBlockLegendaries(), this.settings.isTrainersBlockEarlyWonderGuard(), this.settings.isTrainersLevelModified() ? this.settings.getTrainersLevelModifier() : 0);
        } else if (this.settings.getTrainersMod() == Settings.TrainersMod.TYPE_THEMED) {
            this.romHandler.typeThemeTrainerPokes(this.settings.isTrainersUsePokemonOfSimilarStrength(), this.settings.isTrainersMatchTypingDistribution(), this.settings.isTrainersBlockLegendaries(), this.settings.isTrainersBlockEarlyWonderGuard(), this.settings.isTrainersLevelModified() ? this.settings.getTrainersLevelModifier() : 0);
        }
        if ((this.settings.getTrainersMod() != Settings.TrainersMod.UNCHANGED || this.settings.getStartersMod() != Settings.StartersMod.UNCHANGED) && this.settings.isRivalCarriesStarterThroughout()) {
            this.romHandler.rivalCarriesStarter();
        }
        if (this.settings.isTrainersForceFullyEvolved()) {
            this.romHandler.forceFullyEvolvedTrainerPokes(this.settings.getTrainersForceFullyEvolvedLevel());
        }
        if (this.romHandler.canChangeTrainerText()) {
            if (this.settings.isRandomizeTrainerClassNames()) {
                this.romHandler.randomizeTrainerClassNames(this.settings.getCustomNames());
            }
            if (this.settings.isRandomizeTrainerNames()) {
                this.romHandler.randomizeTrainerNames(this.settings.getCustomNames());
            }
        }
        this.maybeLogTrainerChanges(log, this.romHandler);
        if (this.settings.getMovesetsMod() == Settings.MovesetsMod.METRONOME_ONLY) {
            this.romHandler.metronomeOnlyMode();
        }
        List<Trainer> trainers = this.romHandler.getTrainers();
        for (Trainer t : trainers) {
            for (TrainerPokemon trainerPokemon : t.pokemon) {
                checkValue = Randomizer.addToCV(checkValue, trainerPokemon.level, trainerPokemon.pokemon.number);
            }
        }
        checkValue = this.maybeChangeAndLogStaticPokemon(log, this.romHandler, raceMode, checkValue);
        if (this.settings.isUseMinimumCatchRate()) {
            void var18_44;
            int normalMin;
            boolean gen5 = this.romHandler instanceof Gen5RomHandler;
            switch (this.settings.getMinimumCatchRateLevel()) {
                default: {
                    normalMin = gen5 ? 50 : 75;
                    int n = gen5 ? 25 : 37;
                    break;
                }
                case 2: {
                    normalMin = gen5 ? 100 : 128;
                    int n = gen5 ? 45 : 64;
                    break;
                }
                case 3: {
                    normalMin = gen5 ? 180 : 200;
                    int n = gen5 ? 75 : 100;
                    break;
                }
                case 4: {
                    int n = 255;
                    normalMin = 255;
                }
            }
            this.romHandler.minimumCatchRate(normalMin, (int)var18_44);
        }
        switch (this.settings.getWildPokemonMod()) {
            case RANDOM: {
                this.romHandler.randomEncounters(this.settings.isUseTimeBasedEncounters(), this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.CATCH_EM_ALL, this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.TYPE_THEME_AREAS, this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.SIMILAR_STRENGTH, this.settings.isBlockWildLegendaries());
                break;
            }
            case AREA_MAPPING: {
                this.romHandler.area1to1Encounters(this.settings.isUseTimeBasedEncounters(), this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.CATCH_EM_ALL, this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.TYPE_THEME_AREAS, this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.SIMILAR_STRENGTH, this.settings.isBlockWildLegendaries());
                break;
            }
            case GLOBAL_MAPPING: {
                this.romHandler.game1to1Encounters(this.settings.isUseTimeBasedEncounters(), this.settings.getWildPokemonRestrictionMod() == Settings.WildPokemonRestrictionMod.SIMILAR_STRENGTH, this.settings.isBlockWildLegendaries());
                break;
            }
        }
        this.maybeLogWildPokemonChanges(log, this.romHandler);
        List<EncounterSet> encounters = this.romHandler.getEncounters(this.settings.isUseTimeBasedEncounters());
        for (EncounterSet encounterSet : encounters) {
            for (Encounter e : encounterSet.encounters) {
                checkValue = Randomizer.addToCV(checkValue, e.level, e.pokemon.number);
            }
        }
        if (this.settings.getMovesetsMod() != Settings.MovesetsMod.METRONOME_ONLY && this.settings.getTmsMod() == Settings.TMsMod.RANDOM) {
            double goodDamagingProb = this.settings.isTmsForceGoodDamaging() ? (double)this.settings.getTmsGoodDamagingPercent() / 100.0 : 0.0;
            this.romHandler.randomizeTMMoves(noBrokenMoves, this.settings.isKeepFieldMoveTMs(), goodDamagingProb);
            log.println("--TM Moves--");
            List<Integer> list = this.romHandler.getTMMoves();
            for (int i = 0; i < list.size(); ++i) {
                log.printf("TM%02d %s" + NEWLINE, i + 1, moves.get((int)list.get((int)i).intValue()).name);
                checkValue = Randomizer.addToCV(checkValue, list.get(i));
            }
            log.println();
        } else if (this.settings.getMovesetsMod() == Settings.MovesetsMod.METRONOME_ONLY) {
            log.println("TM Moves: Metronome Only." + NEWLINE);
        } else {
            log.println("TM Moves: Unchanged." + NEWLINE);
        }
        switch (this.settings.getTmsHmsCompatibilityMod()) {
            case RANDOM_PREFER_TYPE: {
                this.romHandler.randomizeTMHMCompatibility(true);
                break;
            }
            case COMPLETELY_RANDOM: {
                this.romHandler.randomizeTMHMCompatibility(false);
                break;
            }
            case FULL: {
                this.romHandler.fullTMHMCompatibility();
                break;
            }
        }
        if (this.settings.isTmLevelUpMoveSanity()) {
            this.romHandler.ensureTMCompatSanity();
        }
        if (this.settings.isFullHMCompat()) {
            this.romHandler.fullHMCompatibility();
        }
        if (this.romHandler.hasMoveTutors()) {
            if (this.settings.getMovesetsMod() != Settings.MovesetsMod.METRONOME_ONLY && this.settings.getMoveTutorMovesMod() == Settings.MoveTutorMovesMod.RANDOM) {
                List<Integer> oldMtMoves = this.romHandler.getMoveTutorMoves();
                double d2 = this.settings.isTutorsForceGoodDamaging() ? (double)this.settings.getTutorsGoodDamagingPercent() / 100.0 : 0.0;
                this.romHandler.randomizeMoveTutorMoves(noBrokenMoves, this.settings.isKeepFieldMoveTutors(), d2);
                log.println("--Move Tutor Moves--");
                List<Integer> newMtMoves = this.romHandler.getMoveTutorMoves();
                for (int i = 0; i < newMtMoves.size(); ++i) {
                    log.printf("%s => %s" + NEWLINE, moves.get((int)oldMtMoves.get((int)i).intValue()).name, moves.get((int)newMtMoves.get((int)i).intValue()).name);
                    checkValue = Randomizer.addToCV(checkValue, newMtMoves.get(i));
                }
                log.println();
            } else if (this.settings.getMovesetsMod() == Settings.MovesetsMod.METRONOME_ONLY) {
                log.println("Move Tutor Moves: Metronome Only." + NEWLINE);
            } else {
                log.println("Move Tutor Moves: Unchanged." + NEWLINE);
            }
            switch (this.settings.getMoveTutorsCompatibilityMod()) {
                case RANDOM_PREFER_TYPE: {
                    this.romHandler.randomizeMoveTutorCompatibility(true);
                    break;
                }
                case COMPLETELY_RANDOM: {
                    this.romHandler.randomizeMoveTutorCompatibility(false);
                    break;
                }
                case FULL: {
                    this.romHandler.fullMoveTutorCompatibility();
                    break;
                }
            }
            if (this.settings.isTutorLevelUpMoveSanity()) {
                this.romHandler.ensureMoveTutorCompatSanity();
            }
        }
        List<IngameTrade> oldTrades = this.romHandler.getIngameTrades();
        if (this.settings.getInGameTradesMod() == Settings.InGameTradesMod.RANDOMIZE_GIVEN) {
            this.romHandler.randomizeIngameTrades(false, this.settings.isRandomizeInGameTradesNicknames(), this.settings.isRandomizeInGameTradesOTs(), this.settings.isRandomizeInGameTradesIVs(), this.settings.isRandomizeInGameTradesItems(), this.settings.getCustomNames());
        } else if (this.settings.getInGameTradesMod() == Settings.InGameTradesMod.RANDOMIZE_GIVEN_AND_REQUESTED) {
            this.romHandler.randomizeIngameTrades(true, this.settings.isRandomizeInGameTradesNicknames(), this.settings.isRandomizeInGameTradesOTs(), this.settings.isRandomizeInGameTradesIVs(), this.settings.isRandomizeInGameTradesItems(), this.settings.getCustomNames());
        }
        if (this.settings.getInGameTradesMod() != Settings.InGameTradesMod.UNCHANGED) {
            log.println("--In-Game Trades--");
            List<IngameTrade> list = this.romHandler.getIngameTrades();
            int n = oldTrades.size();
            for (int i = 0; i < n; ++i) {
                IngameTrade oldT = oldTrades.get(i);
                IngameTrade newT = list.get(i);
                log.printf("Trading %s for %s the %s has become trading %s for %s the %s" + NEWLINE, oldT.requestedPokemon.name, oldT.nickname, oldT.givenPokemon.name, newT.requestedPokemon.name, newT.nickname, newT.givenPokemon.name);
            }
            log.println();
        }
        if (this.settings.getFieldItemsMod() == Settings.FieldItemsMod.SHUFFLE) {
            this.romHandler.shuffleFieldItems();
        } else if (this.settings.getFieldItemsMod() == Settings.FieldItemsMod.RANDOM) {
            this.romHandler.randomizeFieldItems(this.settings.isBanBadRandomFieldItems());
        }
        this.romHandler.applySignature();
        this.romHandler.writeCheckValueToROM(checkValue);
        this.romHandler.saveRom(filename);
        log.println("------------------------------------------------------------------");
        log.println("Randomization of " + this.romHandler.getROMName() + " completed.");
        log.println("Time elapsed: " + (System.currentTimeMillis() - startTime) + "ms");
        log.println("RNG Calls: " + RandomSource.callsSinceSeed());
        log.println("------------------------------------------------------------------");
        return checkValue;
    }

    private void maybeLogBaseStatAndTypeChanges(PrintStream log, RomHandler romHandler) {
        List<Pokemon> allPokes = romHandler.getPokemon();
        String[] itemNames = romHandler.getItemNames();
        if (this.settings.getBaseStatisticsMod() == Settings.BaseStatisticsMod.UNCHANGED && this.settings.getTypesMod() == Settings.TypesMod.UNCHANGED && this.settings.getAbilitiesMod() == Settings.AbilitiesMod.UNCHANGED && !this.settings.isRandomizeWildPokemonHeldItems()) {
            log.println("Pokemon base stats & type: unchanged" + NEWLINE);
        } else {
            log.println("--Pokemon Base Stats & Types--");
            if (romHandler instanceof Gen1RomHandler) {
                log.println("NUM|NAME      |TYPE             |  HP| ATK| DEF| SPE|SPEC");
                for (Pokemon pkmn : allPokes) {
                    String typeString;
                    if (pkmn == null) continue;
                    String string = typeString = pkmn.primaryType == null ? "???" : pkmn.primaryType.toString();
                    if (pkmn.secondaryType != null) {
                        typeString = typeString + "/" + pkmn.secondaryType.toString();
                    }
                    log.printf("%3d|%-10s|%-17s|%4d|%4d|%4d|%4d|%4d" + NEWLINE, pkmn.number, pkmn.name, typeString, pkmn.hp, pkmn.attack, pkmn.defense, pkmn.speed, pkmn.special);
                }
            } else {
                log.print("NUM|NAME      |TYPE             |  HP| ATK| DEF| SPE|SATK|SDEF");
                int abils = romHandler.abilitiesPerPokemon();
                for (int i = 0; i < abils; ++i) {
                    log.print("|ABILITY" + (i + 1) + "    ");
                }
                log.print("|ITEM");
                log.println();
                for (Pokemon pkmn : allPokes) {
                    String typeString;
                    if (pkmn == null) continue;
                    String string = typeString = pkmn.primaryType == null ? "???" : pkmn.primaryType.toString();
                    if (pkmn.secondaryType != null) {
                        typeString = typeString + "/" + pkmn.secondaryType.toString();
                    }
                    log.printf("%3d|%-10s|%-17s|%4d|%4d|%4d|%4d|%4d|%4d", pkmn.number, pkmn.name, typeString, pkmn.hp, pkmn.attack, pkmn.defense, pkmn.speed, pkmn.spatk, pkmn.spdef);
                    if (abils > 0) {
                        log.printf("|%-12s|%-12s", romHandler.abilityName(pkmn.ability1), romHandler.abilityName(pkmn.ability2));
                        if (abils > 2) {
                            log.printf("|%-12s", romHandler.abilityName(pkmn.ability3));
                        }
                    }
                    log.print("|");
                    if (pkmn.guaranteedHeldItem > 0) {
                        log.print(itemNames[pkmn.guaranteedHeldItem] + " (100%)");
                    } else {
                        int itemCount = 0;
                        if (pkmn.commonHeldItem > 0) {
                            ++itemCount;
                            log.print(itemNames[pkmn.commonHeldItem] + " (common)");
                        }
                        if (pkmn.rareHeldItem > 0) {
                            if (itemCount > 0) {
                                log.print(", ");
                            }
                            ++itemCount;
                            log.print(itemNames[pkmn.rareHeldItem] + " (rare)");
                        }
                        if (pkmn.darkGrassHeldItem > 0) {
                            if (itemCount > 0) {
                                log.print(", ");
                            }
                            ++itemCount;
                            log.print(itemNames[pkmn.darkGrassHeldItem] + " (dark grass only)");
                        }
                    }
                    log.println();
                }
            }
            log.println();
        }
    }

    private void maybeChangeAndLogStarters(PrintStream log, RomHandler romHandler) {
        if (romHandler.canChangeStarters()) {
            if (this.settings.getStartersMod() == Settings.StartersMod.CUSTOM) {
                log.println("--Custom Starters--");
                List<Pokemon> romPokemon = romHandler.getPokemon();
                int[] customStarters = this.settings.getCustomStarters();
                Pokemon pkmn1 = romPokemon.get(customStarters[0]);
                log.println("Set starter 1 to " + pkmn1.name);
                Pokemon pkmn2 = romPokemon.get(customStarters[1]);
                log.println("Set starter 2 to " + pkmn2.name);
                if (romHandler.isYellow()) {
                    romHandler.setStarters(Arrays.asList(pkmn1, pkmn2));
                } else {
                    Pokemon pkmn3 = romPokemon.get(customStarters[2]);
                    log.println("Set starter 3 to " + pkmn3.name);
                    romHandler.setStarters(Arrays.asList(pkmn1, pkmn2, pkmn3));
                }
                log.println();
            } else if (this.settings.getStartersMod() == Settings.StartersMod.COMPLETELY_RANDOM) {
                log.println("--Random Starters--");
                int starterCount = 3;
                if (romHandler.isYellow()) {
                    starterCount = 2;
                }
                ArrayList<Pokemon> starters = new ArrayList<Pokemon>();
                for (int i = 0; i < starterCount; ++i) {
                    Pokemon pkmn = romHandler.randomPokemon();
                    while (starters.contains(pkmn)) {
                        pkmn = romHandler.randomPokemon();
                    }
                    log.println("Set starter " + (i + 1) + " to " + pkmn.name);
                    starters.add(pkmn);
                }
                romHandler.setStarters(starters);
                log.println();
            } else if (this.settings.getStartersMod() == Settings.StartersMod.RANDOM_WITH_TWO_EVOLUTIONS) {
                log.println("--Random 2-Evolution Starters--");
                int starterCount = 3;
                if (romHandler.isYellow()) {
                    starterCount = 2;
                }
                ArrayList<Pokemon> starters = new ArrayList<Pokemon>();
                for (int i = 0; i < starterCount; ++i) {
                    Pokemon pkmn = romHandler.random2EvosPokemon();
                    while (starters.contains(pkmn)) {
                        pkmn = romHandler.random2EvosPokemon();
                    }
                    log.println("Set starter " + (i + 1) + " to " + pkmn.name);
                    starters.add(pkmn);
                }
                romHandler.setStarters(starters);
                log.println();
            }
            if (this.settings.isRandomizeStartersHeldItems() && !(romHandler instanceof Gen1RomHandler)) {
                romHandler.randomizeStarterHeldItems(this.settings.isBanBadRandomStarterHeldItems());
            }
        }
    }

    private void maybeLogWildPokemonChanges(PrintStream log, RomHandler romHandler) {
        if (this.settings.getWildPokemonMod() == Settings.WildPokemonMod.UNCHANGED) {
            log.println("Wild Pokemon: Unchanged." + NEWLINE);
        } else {
            log.println("--Wild Pokemon--");
            List<EncounterSet> encounters = romHandler.getEncounters(this.settings.isUseTimeBasedEncounters());
            int idx = 0;
            for (EncounterSet es : encounters) {
                log.print("Set #" + ++idx + " ");
                if (es.displayName != null) {
                    log.print("- " + es.displayName + " ");
                }
                log.print("(rate=" + es.rate + ")");
                log.print(" - ");
                boolean first = true;
                for (Encounter e : es.encounters) {
                    if (!first) {
                        log.print(", ");
                    }
                    log.print(e.pokemon.name + " Lv");
                    if (e.maxLevel > 0 && e.maxLevel != e.level) {
                        log.print("s " + e.level + "-" + e.maxLevel);
                    } else {
                        log.print(e.level);
                    }
                    first = false;
                }
                log.println();
            }
            log.println();
        }
    }

    private void maybeLogTrainerChanges(PrintStream log, RomHandler romHandler) {
        if (this.settings.getTrainersMod() == Settings.TrainersMod.UNCHANGED && !this.settings.isRivalCarriesStarterThroughout()) {
            log.println("Trainers: Unchanged." + NEWLINE);
        } else {
            log.println("--Trainers Pokemon--");
            List<Trainer> trainers = romHandler.getTrainers();
            int idx = 0;
            for (Trainer t : trainers) {
                log.print("#" + ++idx + " ");
                if (t.fullDisplayName != null) {
                    log.print("(" + t.fullDisplayName + ")");
                } else if (t.name != null) {
                    log.print("(" + t.name + ")");
                }
                if (t.offset != idx && t.offset != 0) {
                    log.printf("@%X", t.offset);
                }
                log.print(" - ");
                boolean first = true;
                for (TrainerPokemon tpk : t.pokemon) {
                    if (!first) {
                        log.print(", ");
                    }
                    log.print(tpk.pokemon.name + " Lv" + tpk.level);
                    first = false;
                }
                log.println();
            }
            log.println();
        }
    }

    private int maybeChangeAndLogStaticPokemon(PrintStream log, RomHandler romHandler, boolean raceMode, int checkValue) {
        if (romHandler.canChangeStaticPokemon()) {
            List<Pokemon> oldStatics = romHandler.getStaticPokemon();
            if (this.settings.getStaticPokemonMod() == Settings.StaticPokemonMod.RANDOM_MATCHING) {
                romHandler.randomizeStaticPokemon(true);
            } else if (this.settings.getStaticPokemonMod() == Settings.StaticPokemonMod.COMPLETELY_RANDOM) {
                romHandler.randomizeStaticPokemon(false);
            }
            List<Pokemon> newStatics = romHandler.getStaticPokemon();
            if (this.settings.getStaticPokemonMod() == Settings.StaticPokemonMod.UNCHANGED) {
                log.println("Static Pokemon: Unchanged." + NEWLINE);
            } else {
                log.println("--Static Pokemon--");
                TreeMap<Pokemon, Integer> seenPokemon = new TreeMap<Pokemon, Integer>();
                for (int i = 0; i < oldStatics.size(); ++i) {
                    Pokemon oldP = oldStatics.get(i);
                    Pokemon newP = newStatics.get(i);
                    checkValue = Randomizer.addToCV(checkValue, newP.number);
                    log.print(oldP.name);
                    if (seenPokemon.containsKey(oldP)) {
                        int amount = (Integer)seenPokemon.get(oldP);
                        log.print("(" + ++amount + ")");
                        seenPokemon.put(oldP, amount);
                    } else {
                        seenPokemon.put(oldP, 1);
                    }
                    log.println(" => " + newP.name);
                }
                log.println();
            }
        }
        return checkValue;
    }

    private void maybeLogMoveChanges(PrintStream log, RomHandler romHandler) {
        if (!(this.settings.isRandomizeMoveAccuracies() || this.settings.isRandomizeMovePowers() || this.settings.isRandomizeMovePPs() || this.settings.isRandomizeMoveCategory() || this.settings.isRandomizeMoveTypes())) {
            if (!this.settings.isUpdateMoves()) {
                log.println("Move Data: Unchanged." + NEWLINE);
            }
        } else {
            log.println("--Move Data--");
            log.print("NUM|NAME           |TYPE    |POWER|ACC.|PP");
            if (romHandler.hasPhysicalSpecialSplit()) {
                log.print(" |CATEGORY");
            }
            log.println();
            List<Move> allMoves = romHandler.getMoves();
            for (Move mv : allMoves) {
                if (mv == null) continue;
                String mvType = mv.type == null ? "???" : mv.type.toString();
                log.printf("%3d|%-15s|%-8s|%5d|%4d|%3d", mv.internalId, mv.name, mvType, mv.power, (int)mv.hitratio, mv.pp);
                if (romHandler.hasPhysicalSpecialSplit()) {
                    log.printf("| %s", mv.category.toString());
                }
                log.println();
            }
            log.println();
        }
    }

    private static int addToCV(int checkValue, int ... values) {
        for (int value : values) {
            checkValue = Integer.rotateLeft(checkValue, 3);
            checkValue ^= value;
        }
        return checkValue;
    }
}

