/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.CustomNamesSet;
import com.dabomstew.pkrandom.SysConstants;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.zip.CRC32;

public class FileFunctions {
    private static List<String> overrideFiles = Arrays.asList("customnames.rncn", "trainerclasses.txt", "trainernames.txt", "nicknames.txt");

    public static File fixFilename(File original, String defaultExtension) {
        return FileFunctions.fixFilename(original, defaultExtension, null);
    }

    public static File fixFilename(File original, String defaultExtension, List<String> bannedExtensions) {
        String filename = original.getName();
        if (filename.lastIndexOf(46) >= filename.length() - 5 && filename.lastIndexOf(46) != filename.length() - 1 && filename.length() > 4 && filename.lastIndexOf(46) != -1) {
            String ext = filename.substring(filename.lastIndexOf(46) + 1).toLowerCase();
            if (bannedExtensions != null && bannedExtensions.contains(ext)) {
                filename = filename.substring(0, filename.lastIndexOf(46) + 1) + defaultExtension;
            }
        } else {
            filename = filename + "." + defaultExtension;
        }
        return new File(original.getAbsolutePath().replace(original.getName(), "") + filename);
    }

    public static boolean configExists(String filename) {
        if (overrideFiles.contains(filename)) {
            File fh = new File(SysConstants.ROOT_PATH + filename);
            if (fh.exists() && fh.canRead()) {
                return true;
            }
            fh = new File("./" + filename);
            if (fh.exists() && fh.canRead()) {
                return true;
            }
        }
        return FileFunctions.class.getResource("/com/dabomstew/pkrandom/config/" + filename) != null;
    }

    public static InputStream openConfig(String filename) throws FileNotFoundException {
        if (overrideFiles.contains(filename)) {
            File fh = new File(SysConstants.ROOT_PATH + filename);
            if (fh.exists() && fh.canRead()) {
                return new FileInputStream(fh);
            }
            fh = new File("./" + filename);
            if (fh.exists() && fh.canRead()) {
                return new FileInputStream(fh);
            }
        }
        return FileFunctions.class.getResourceAsStream("/com/dabomstew/pkrandom/config/" + filename);
    }

    public static CustomNamesSet getCustomNames() throws IOException {
        InputStream is = FileFunctions.openConfig("customnames.rncn");
        CustomNamesSet cns = new CustomNamesSet(is);
        is.close();
        return cns;
    }

    public static int readFullInt(byte[] data, int offset) {
        ByteBuffer buf = ByteBuffer.allocate(4).put(data, offset, 4);
        buf.rewind();
        return buf.getInt();
    }

    public static int read2ByteInt(byte[] data, int index) {
        return data[index] & 0xFF | (data[index + 1] & 0xFF) << 8;
    }

    public static void writeFullInt(byte[] data, int offset, int value) {
        byte[] valueBytes = ByteBuffer.allocate(4).putInt(value).array();
        System.arraycopy(valueBytes, 0, data, offset, 4);
    }

    public static byte[] readFileFullyIntoBuffer(String filename) throws IOException {
        File fh = new File(filename);
        if (!(fh.exists() && fh.isFile() && fh.canRead())) {
            throw new FileNotFoundException(filename);
        }
        long fileSize = fh.length();
        if (fileSize > Integer.MAX_VALUE) {
            throw new IOException(filename + " is too long to read in as a byte-array.");
        }
        FileInputStream fis = new FileInputStream(filename);
        byte[] buf = FileFunctions.readFullyIntoBuffer(fis, (int)fileSize);
        fis.close();
        return buf;
    }

    public static byte[] readFullyIntoBuffer(InputStream in, int bytes) throws IOException {
        byte[] buf = new byte[bytes];
        FileFunctions.readFully(in, buf, 0, bytes);
        return buf;
    }

    public static void readFully(InputStream in, byte[] buf, int offset, int length) throws IOException {
        int read = 0;
        for (int offs = 0; offs < length && (read = in.read(buf, offs + offset, length - offs)) != -1; offs += read) {
        }
    }

    public static void writeBytesToFile(String filename, byte[] data) throws IOException {
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(data);
        fos.close();
    }

    public static byte[] getConfigAsBytes(String filename) throws IOException {
        InputStream in = FileFunctions.openConfig(filename);
        byte[] buf = FileFunctions.readFullyIntoBuffer(in, in.available());
        in.close();
        return buf;
    }

    public static int getFileChecksum(String filename) {
        try {
            return FileFunctions.getFileChecksum(FileFunctions.openConfig(filename));
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static int getFileChecksum(InputStream stream) {
        try {
            Scanner sc = new Scanner(stream, "UTF-8");
            CRC32 checksum = new CRC32();
            while (sc.hasNextLine()) {
                String line = sc.nextLine().trim();
                if (line.isEmpty()) continue;
                checksum.update(line.getBytes("UTF-8"));
            }
            sc.close();
            return (int)checksum.getValue();
        }
        catch (IOException e) {
            return 0;
        }
    }

    public static boolean checkOtherCRC(byte[] data, int byteIndex, int switchIndex, String filename, int offsetInData) {
        int switches = data[byteIndex] & 0xFF;
        if ((switches >> switchIndex & 1) == 1) {
            int crc = FileFunctions.readFullInt(data, offsetInData);
            if (FileFunctions.getFileChecksum(filename) != crc) {
                return false;
            }
        }
        return true;
    }

    public static byte[] getCodeTweakFile(String filename) throws IOException {
        InputStream is = FileFunctions.class.getResourceAsStream("/com/dabomstew/pkrandom/patches/" + filename);
        byte[] buf = FileFunctions.readFullyIntoBuffer(is, is.available());
        is.close();
        return buf;
    }

    public static byte[] downloadFile(String url) throws IOException {
        int count;
        BufferedInputStream in = new BufferedInputStream(new URL(url).openStream());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((count = in.read(buf, 0, 1024)) != -1) {
            out.write(buf, 0, count);
        }
        in.close();
        byte[] output = out.toByteArray();
        return output;
    }

    public static void applyPatch(byte[] rom, String patchName) throws IOException {
        byte[] patch = FileFunctions.getCodeTweakFile(patchName + ".ips");
        int patchlen = patch.length;
        if (patchlen < 8 || patch[0] != 80 || patch[1] != 65 || patch[2] != 84 || patch[3] != 67 || patch[4] != 72) {
            throw new IOException("not a valid IPS file");
        }
        int offset = 5;
        while (offset + 2 < patchlen) {
            int writeOffset = FileFunctions.readIPSOffset(patch, offset);
            if (writeOffset == 4542278) {
                return;
            }
            if ((offset += 3) + 1 >= patchlen) {
                throw new IOException("abrupt ending to IPS file, entry cut off before size");
            }
            int size = FileFunctions.readIPSSize(patch, offset);
            offset += 2;
            if (size == 0) {
                if (offset + 1 >= patchlen) {
                    throw new IOException("abrupt ending to IPS file, entry cut off before RLE size");
                }
                int rleSize = FileFunctions.readIPSSize(patch, offset);
                if (writeOffset + rleSize > rom.length) {
                    throw new IOException("trying to patch data past the end of the ROM file");
                }
                if ((offset += 2) >= patchlen) {
                    throw new IOException("abrupt ending to IPS file, entry cut off before RLE byte");
                }
                byte rleByte = patch[offset++];
                for (int i = writeOffset; i < writeOffset + rleSize; ++i) {
                    rom[i] = rleByte;
                }
                continue;
            }
            if (offset + size > patchlen) {
                throw new IOException("abrupt ending to IPS file, entry cut off before end of data block");
            }
            if (writeOffset + size > rom.length) {
                throw new IOException("trying to patch data past the end of the ROM file");
            }
            System.arraycopy(patch, offset, rom, writeOffset, size);
            offset += size;
        }
        throw new IOException("improperly terminated IPS file");
    }

    private static int readIPSOffset(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 16 | (data[offset + 1] & 0xFF) << 8 | data[offset + 2] & 0xFF;
    }

    private static int readIPSSize(byte[] data, int offset) {
        return (data[offset] & 0xFF) << 8 | data[offset + 1] & 0xFF;
    }

    public static byte[] convIntArrToByteArr(int[] arg) {
        byte[] out = new byte[arg.length];
        for (int i = 0; i < arg.length; ++i) {
            out[i] = (byte)arg[i];
        }
        return out;
    }
}

