/*
 * Decompiled with CFR 0.152.
 */
package com.dabomstew.pkrandom;

import com.dabomstew.pkrandom.FileFunctions;
import com.dabomstew.pkrandom.SysConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public class CustomNamesSet {
    private List<String> trainerNames;
    private List<String> trainerClasses;
    private List<String> doublesTrainerNames;
    private List<String> doublesTrainerClasses;
    private List<String> pokemonNicknames;
    private static final int CUSTOM_NAMES_VERSION = 1;

    public CustomNamesSet(InputStream data) throws IOException {
        if (data.read() != 1) {
            throw new IOException("Invalid custom names file provided.");
        }
        this.trainerNames = this.readNamesBlock(data);
        this.trainerClasses = this.readNamesBlock(data);
        this.doublesTrainerNames = this.readNamesBlock(data);
        this.doublesTrainerClasses = this.readNamesBlock(data);
        this.pokemonNicknames = this.readNamesBlock(data);
    }

    public CustomNamesSet() {
        this.trainerNames = new ArrayList<String>();
        this.trainerClasses = new ArrayList<String>();
        this.doublesTrainerNames = new ArrayList<String>();
        this.doublesTrainerClasses = new ArrayList<String>();
        this.pokemonNicknames = new ArrayList<String>();
    }

    private List<String> readNamesBlock(InputStream in) throws IOException {
        byte[] szData = FileFunctions.readFullyIntoBuffer(in, 4);
        int size = FileFunctions.readFullInt(szData, 0);
        if (in.available() < size) {
            throw new IOException("Invalid size specified.");
        }
        byte[] namesData = FileFunctions.readFullyIntoBuffer(in, size);
        ArrayList<String> names = new ArrayList<String>();
        Scanner sc = new Scanner((InputStream)new ByteArrayInputStream(namesData), "UTF-8");
        while (sc.hasNextLine()) {
            String name = sc.nextLine().trim();
            if (name.isEmpty()) continue;
            names.add(name);
        }
        sc.close();
        return names;
    }

    public byte[] getBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        this.writeNamesBlock(baos, this.trainerNames);
        this.writeNamesBlock(baos, this.trainerClasses);
        this.writeNamesBlock(baos, this.doublesTrainerNames);
        this.writeNamesBlock(baos, this.doublesTrainerClasses);
        this.writeNamesBlock(baos, this.pokemonNicknames);
        return baos.toByteArray();
    }

    private void writeNamesBlock(OutputStream out, List<String> names) throws IOException {
        String newln = SysConstants.LINE_SEP;
        StringBuffer outNames = new StringBuffer();
        boolean first = true;
        for (String name : names) {
            if (!first) {
                outNames.append(newln);
            }
            first = false;
            outNames.append(name);
        }
        byte[] namesData = outNames.toString().getBytes("UTF-8");
        byte[] szData = new byte[4];
        FileFunctions.writeFullInt(szData, 0, namesData.length);
        out.write(szData);
        out.write(namesData);
    }

    public List<String> getTrainerNames() {
        return Collections.unmodifiableList(this.trainerNames);
    }

    public List<String> getTrainerClasses() {
        return Collections.unmodifiableList(this.trainerClasses);
    }

    public List<String> getDoublesTrainerNames() {
        return Collections.unmodifiableList(this.doublesTrainerNames);
    }

    public List<String> getDoublesTrainerClasses() {
        return Collections.unmodifiableList(this.doublesTrainerClasses);
    }

    public List<String> getPokemonNicknames() {
        return Collections.unmodifiableList(this.pokemonNicknames);
    }

    public void setTrainerNames(List<String> names) {
        this.trainerNames.clear();
        this.trainerNames.addAll(names);
    }

    public void setTrainerClasses(List<String> names) {
        this.trainerClasses.clear();
        this.trainerClasses.addAll(names);
    }

    public void setDoublesTrainerNames(List<String> names) {
        this.doublesTrainerNames.clear();
        this.doublesTrainerNames.addAll(names);
    }

    public void setDoublesTrainerClasses(List<String> names) {
        this.doublesTrainerClasses.clear();
        this.doublesTrainerClasses.addAll(names);
    }

    public void setPokemonNicknames(List<String> names) {
        this.pokemonNicknames.clear();
        this.pokemonNicknames.addAll(names);
    }

    public static CustomNamesSet importOldNames() throws FileNotFoundException {
        Scanner sc;
        CustomNamesSet cns = new CustomNamesSet();
        if (FileFunctions.configExists("trainernames.txt")) {
            sc = new Scanner(FileFunctions.openConfig("trainernames.txt"), "UTF-8");
            while (sc.hasNextLine()) {
                String trainername = sc.nextLine().trim();
                if (trainername.isEmpty()) continue;
                if (trainername.startsWith("\ufeff")) {
                    trainername = trainername.substring(1);
                }
                if (trainername.contains("&")) {
                    cns.doublesTrainerNames.add(trainername);
                    continue;
                }
                cns.trainerNames.add(trainername);
            }
            sc.close();
        }
        if (FileFunctions.configExists("trainerclasses.txt")) {
            sc = new Scanner(FileFunctions.openConfig("trainerclasses.txt"), "UTF-8");
            while (sc.hasNextLine()) {
                String checkName;
                boolean idx;
                String trainerClassName = sc.nextLine().trim();
                if (trainerClassName.isEmpty()) continue;
                if (trainerClassName.startsWith("\ufeff")) {
                    trainerClassName = trainerClassName.substring(1);
                }
                boolean bl = idx = (checkName = trainerClassName.toLowerCase()).endsWith("couple") || checkName.contains(" and ") || checkName.endsWith("kin") || checkName.endsWith("team") || checkName.contains("&") || checkName.endsWith("s") && !checkName.endsWith("ss");
                if (idx) {
                    cns.doublesTrainerClasses.add(trainerClassName);
                    continue;
                }
                cns.trainerClasses.add(trainerClassName);
            }
            sc.close();
        }
        if (FileFunctions.configExists("nicknames.txt")) {
            sc = new Scanner(FileFunctions.openConfig("nicknames.txt"), "UTF-8");
            while (sc.hasNextLine()) {
                String nickname = sc.nextLine().trim();
                if (nickname.isEmpty()) continue;
                if (nickname.startsWith("\ufeff")) {
                    nickname = nickname.substring(1);
                }
                cns.pokemonNicknames.add(nickname);
            }
            sc.close();
        }
        return cns;
    }
}

